<?php
/*
Plugin Name: BirdEye Reviews Plugin
Plugin URI: https:/birdeye.com/
Description: BirdEye Business Reviews Plugin
Version: 1.0
Author: BirdEye Inc.
Author URI: https://birdeye.com
License: GPL
*/
// create custom plugin settings menu
ob_start();
add_action('admin_menu', 'birdeye_plugin_create_menu');

function birdeye_plugin_create_menu() {

  //create new top-level menu
  add_menu_page('BirdEye Reviews Page', 'Reviews Setting', 'administrator', __FILE__, 'birdeye_plugin_settings_page' , plugins_url('/images/birdeye.png', __FILE__) );

  //call register settings function
  add_action( 'admin_init', 'register_birdeye_plugin_settings' );
  //add_action( 'admin_init', 'new_plugin' );
    
}
function register_birdeye_plugin_settings() {
  //register our settings
  register_setting( 'birdeye-plugin-settings-group', 'businessNumber' );
  register_setting( 'birdeye-plugin-settings-group', 'apiKey' );
  register_setting( 'birdeye-plugin-settings-group', 'apiHost' );
  register_setting( 'birdeye-plugin-settings-group', 'cssStyle' );
  register_setting( 'birdeye-plugin-settings-group', 'demo-checkbox');
  register_setting( 'birdeye-plugin-settings-group', 'Appointment-tab');
  register_setting( 'birdeye-plugin-settings-group', 'review-tab');
  register_setting( 'birdeye-plugin-settings-group', 'default-reviews');
  wp_register_style ( 'mycss', plugins_url ( 'css/mycss.css', __FILE__ ) );
  }
function birdeye_plugin_settings_page() {

wp_enqueue_style('mycss');    
?>
<div class="be-seeting">
<div class="bg">
<div class="be-container">
      <div class="be-logo">
      <img src="<?php echo plugin_dir_url(( __FILE__ ) ) . 'images/logo-color.png'; ?>">
    </div>
  <div class="be-social">
    <div class="twit">
      <a href="https://twitter.com/birdeye_" target="_blank"><img src="<?php echo plugin_dir_url(( __FILE__ ) ) . 'images/twitter.png'; ?>"><span class="Follow-on-Twitter">Follow On Twitter</span></a>
    </div>
    <div class="fb">
      <a href="https://www.facebook.com/BirdEyeReviews" target="_blank"><img src="<?php echo plugin_dir_url(( __FILE__ ) ) . 'images/facebook.png'; ?>"><span class="Like-on-Facebook">Like on Facebook</span></a>
    </div>
    <div class="yout">
      <a href="https://www.youtube.com/channel/UC5GVt-szboTnj2DKO6PKW5w" target="_blank"><span style="background:#ad2b2b;"><img src="<?php echo plugin_dir_url(( __FILE__ ) ) . 'images/youtube.png'; ?>"></span><span class="Subscribe-On-YouTube">Subscribe YouTube</span></a>
    </div>
  </div>
  <div class="be-head">BirdEye Reviews Plugin</div>
  <div class="form">
    <form method="post" action="options.php">
    <?php settings_fields( 'birdeye-plugin-settings-group' ); ?>
        <?php do_settings_sections( 'birdeye-plugin-settings-group' ); ?>
     <div>
    <label for="fullname">Business ID</label>
    <input type="number" name="businessNumber" value="<?php echo esc_attr( get_option('businessNumber') ); ?>" class="txt"/>
  </div>
  <div>
    <label for="email">API Key</label>
    <input type="text" name="apiKey" value="<?php echo esc_attr( get_option('apiKey') ); ?>" class="txt"/>
  </div>
  <div style="display: none;">
    <label for="password1">API Host</label>
    <input type="text" name="apiHost" value="api.birdeye.com" class="txt"/>
  </div>
  <div>
    <label for="password2">CSS Style</label>
    <textarea name="cssStyle" cols="100"><?php echo esc_attr( get_option('cssStyle') ); ?></textarea>
  </div>
   <div>
    <label for="password2">Reviews Summary TAB</label>
    <label class="switch">
                <input class="switch-input" type="checkbox" style="display: none;" name="demo-checkbox" value="1" <?php checked(1, get_option('demo-checkbox'), true); ?> />
                <span class="switch-label" data-on="On" data-off="Off"></span> 
                <span class="switch-handle"></span> 
              </label>
  </div>
   <div>
    <label for="password2">Display Appointment TAB</label>
    <label class="switch">
                <input class="switch-input" type="checkbox" style="display: none;" name="Appointment-tab" value="1" <?php checked(1, get_option('Appointment-tab'), true); ?> />
                <span class="switch-label" data-on="On" data-off="Off"></span> 
                <span class="switch-handle"></span> 
              </label>
  </div>
   <div>
    <label for="password2">Write Review TAB</label>
    <label class="switch">
                <input class="switch-input" type="checkbox" style="display: none;" name="review-tab" value="1" <?php checked(1, get_option('review-tab'), true); ?> />
                <span class="switch-label" data-on="On" data-off="Off"></span> 
                <span class="switch-handle"></span> 
              </label>
  </div>
  <div>
 <?php $default_state = get_option('default-reviews');
 ?>

    <label for="level">No. Of Reviews Show</label>
    <select name="default-reviews">
             <option>Select Option</option>
              <option  <?php if ($default_state == 15 ) echo 'selected' ; ?> value="15">15</option>
              <option <?php if ($default_state == 20 ) echo 'selected' ; ?> value="20">20</option>
              <option <?php if ($default_state == 25 ) echo 'selected' ; ?> value="25">25</option>
              <option <?php if ($default_state == 30 ) echo 'selected' ; ?> value="30">30</option>
              </select>
  </div>
  <div>
    <?php submit_button(); ?>
  </div>
  
</form>
  </div>
</div>
</div>
</div>
<?php } ?>
<?php require_once('review.php');
?>
