<script
  src="https://code.jquery.com/jquery-3.1.1.min.js"
  integrity="sha256-hVVnYaiADRTO2PzUGmuLJr8BLUSjGIZsDYGmIJLv2b8="
  crossorigin="anonymous"></script>
<script type="text/javascript">
	var data = {};
	data.business = {};
	data.reviews = {};
	data.overall = {};
	data.sources = {};
	data.index = 0;
	$.ajax({
	  method: "GET",
	  dataType: 'json',
	  url: "https://api.birdeye.com/resources/v1/business/145875423866494/?api_key=ZsmeBE0rUZjWPx0492wtfJZYQz89Xvo5&op=1"
	})
	  .done(function( response ) {
	  	data.business = response;
	  	getReview([]);
	  	getReviewOverall();
	  });
	var getReview = function (sources) {
		var req = {"sources": sources};
		$.ajax({
		  method: "POST",
		  dataType: 'json',	
		  headers: {"content-type": "application/json"},
		  data: JSON.stringify(req),
		  url: "https://api.birdeye.com/resources/v1/review/businessId/145875423866494/?api_key=ZsmeBE0rUZjWPx0492wtfJZYQz89Xvo5&op=3&sindex=" + data.index + "&count=25"
		})
		  .done(function( response ) {
		  	data.index = data.index + response.length;
		  	data.reviews = response;
		  	if(data.reviews.length > 0) {
			  	var strReviews = "<table class='reviews'>";
			  	$.each(response, function(i, ele){
			  		strReviews += "<tr>";
			  			strReviews += "<td class='review--pic'><div class='pic'><img src='"+ ele.reviewer.thumbnailUrl +"' alt='reviewer profile image'></div></td>";
			  			strReviews += "<td class='review--info'>";
			  				strReviews += "<div class='name--date'>";
			  					strReviews += "<div class='name'>" + ele.reviewer.nickName ? ele.reviewer.nickName : (ele.reviewer.firstName ? ele.reviewer.firstName : "Anonymous") + "</div>";
			  					strReviews += "<div class='date'>" + ele.reviewDate + "</div>";
			  					strReviews += "<div class='source'>" + ele.sourceType + "</div>";
			  				strReviews += "</div>";
			  				strReviews += "<div class='stars--rating'>";
			  					strReviews += "<div class='stars'>";
			  						for(var i=0; i<ele.rating;i++){
			  							strReviews +="<i class='fa fa-star'></i>";
			  						}
			  					strReviews += "</div>";	
			  				strReviews += "</div>";
			  				strReviews += "<div class='comments'>" + (ele.comments || '') + "</div>"
			  			strReviews += "</td>";
			  		strReviews += "</tr>";
			  	});
			  	strReviews += "</table>";
			  	if (data.reviews.length == 25) {
			  		$(".reviews-container .load-button").remove();
			     	strReviews += '<div class="load-button" style="text-align: center;"><a id="LoadReviews" class="button" style="margin: 20px auto;">Load More</a></div>';
			    }
			  	$(".reviews-container").append(strReviews);
			  	$('.reviews-container').off().on('click', 'a#LoadReviews', function(){
					getReview([]);
				});
			} else {
				$(".reviews-container").append('No Data Found');
			}
		  });
	}; 
	var getReviewOverall = function () {
		$.ajax({
		  method: "GET",
		  dataType: 'json',
		  url: "https://api.birdeye.com/resources/v1/review/businessid/145875423866494/summary?api_key=ZsmeBE0rUZjWPx0492wtfJZYQz89Xvo5&statuses=published"
		})
		  .done(function( response ) {
		  	data.overall = response; 
		  	if(response) {
		  		var strOverall = "<div>";
			  	for(var i=0; i<response.avgRating; i ++) {
			  		strOverall += "<i class='fa fa-star'></i>";
			  	}
			  	strOverall += "</div> <div> <span class='count'>" + response.reviewCount + "</span> reviews </div>";
			  	$(".reviews-overall").html(strOverall);


			  	var strSummery = "<div class='reviews-sum'><div class='stars--rating'>";
			  	$.each(response.ratings.reverse(), function (index, ele){
			  		if( index < response.ratings.length-1) {
				  		strSummery += "<div class='stars'>";
				  		for(var i=0; i<ele.rating; i++) {
				  			strSummery +="<i class='fa fa-star'></i>";
				  		}
				  		strSummery +="<div class='reviews-sum-count'>" + ele.reviewCount + "</div></div>";
				  	}else {
				  		strSummery += "<p>"+ele.reviewCount+ " review with no rating </p>";
				  	}
			  	});
			  	strSummery += "</div></div>";
			  	$(".reviews-summary").append(strSummery);
			  	getReviewSources(response)
		  	}
		  });
	};
	var getReviewSources = function (response) {
		var strSummery = '<div class="reviews-source"><input type="checkbox" name="reviews-filter" value="all"> All</div>';
		for(var i=0; i<response.sources.length; i ++) {
			response.sources[i].sourceAlias = response.sources[i].sourceAlias == 'birdeye' ? "our_website" : response.sources[i].sourceAlias;
	  		strSummery += '<div class="reviews-source"><input type="checkbox" name="reviews-filter" value="' +response.sources[i].sourceAlias+ '"> ' +response.sources[i].sourceName + ' (' + response.sources[i].reviewCount + ')</div>';
	  	}
	  	$('.reviews-sources').append(strSummery);

	  	$('body').on('change', '.reviews-source input', function(){
	  		var isValue = $(this).val();
	  		if(isValue == 'all') {
	  			if($(this). prop("checked")) {
	  				$('.reviews-source input'). prop("checked",true);
	  			}else {
	  				$('.reviews-source input'). prop("checked",false);
	  			}
	  		}
	  		var arr = [];
	  		$('.reviews-source input').each(function(){
	  			if($(this). prop("checked")) {
	  				if($(this).val() != "all")
	  					arr.push($(this).val());
	  			}
	  		});
	  		$('.reviews-container').empty();
	  		data.index = 0;
			getReview(arr);
		});
	};
	
</script>