<?php
if(isset($_REQUEST['action']) && $_REQUEST['action']=='birdeye_ajax_fetch_reviews'):
    add_action('wp_ajax_birdeye_ajax_fetch_reviews', 'birdeye_ajax_fetch_reviews');
    add_action('wp_ajax_nopriv_birdeye_ajax_fetch_reviews', 'birdeye_ajax_fetch_reviews');
endif;
if(isset($_REQUEST['action'])):
        do_action( 'wp_ajax_' . $_REQUEST['action'] );
        do_action( 'wp_ajax_nopriv_' . $_REQUEST['action'] );
endif;
function getSlug($string) {
    $string = html_entity_decode($string);
    $arr = array("ˆ" => '-', "‡" => '-', "Š" => '-', "‰" => '-', "" => '-',
        "Ž" => '-', "‘" => '-', "" => '-', "“" => '-', "’" => '-',
        "•" => '-', "”" => '-', "˜" => '-', "—" => '-', "š" => '-',
        "™" => '-', "" => '-', "œ" => '-', "Ÿ" => '-', "ž" => '-',
        "–" => '-', "" => '-', "á" => '-', "/" => '-', "_" => '-',
        "," => '-', ":" => '-', ";" => '-');
    $string = strtr($string,  $arr);
    $string = strtolower(trim($string));
    $string = preg_replace('/[^a-z0-9\\-\\ ]/', '', $string);
    //$string = preg_replace("/\s+/", "-", $string);
    $string = preg_replace("/-+/", "-", $string);

    if(substr($string, strlen($string) - 1, strlen($string)) === "-") {
        $string = substr($string, 0, strlen($string) - 1);
    }

    return $string;
}

function getPublicProfileUrl($business) {
    $protocol = 'http';

    if ($business->secureEnabled) {
        $protocol .= 's';
    }
    $url = $protocol . '://' . $business->domain . '/' . getSlug($business->name) . '-' . $business->businessNumber;

    return $url;
}

function birdeye_ajax_fetch_reviews(){
$source[] = !empty($_POST['source']) ? $_POST['source'] : "All";	
$sindex = $_POST['page'];
$count = $sindex +25; 
$businessNumber = get_option('businessNumber');
$apiKey = get_option('apiKey');
$apiHost = get_option('apiHost');
$cssStyle = get_option('cssStyle');
$data = array('sources' => $source);
$opts = array(
		'http' => array(
				'method' => 'POST',
				'header' => "Content-Type: application/json\r\n" .  
				"Accept  : application/json\r\n",
				'content'=> json_encode($data)
		)
);
$context = stream_context_create($opts);
$response = file_get_contents('https://' . $apiHost . '/resources/v1/review/businessId/' . $businessNumber . '?api_key=' . $apiKey . '&sindex='.$sindex.'&count='.$count, false, $context);
$objReviews = json_decode($response);
foreach($objReviews as $objReview) {
$objReview->sourceType = $objReview->sourceType == 'Our Website' ? "BirdEye" : $objReview->sourceType;
$objReview->recommended = $objReview->recommended == 1 ? "Recommended" : "Null";
$reviewerImg = $objReview->reviewer->thumbnailUrl;
$reviewerName = !empty($objReview->reviewer->firstName) ? $objReview->reviewer->firstName : $objReview->reviewer->nickName;		
$reviewerHtml='	<article>
			<p>
			    <span><img src=' .$reviewerImg. ' class="person"></span>';
			    	if ($objReview->recommended =='Recommended'){

			    		$reviewerHtml.='<span><img src='.plugin_dir_url(( __FILE__ ) ) . 'images/fb_r.svg'.'></span><span class="beFBColor">Recommended</span>';

			    	}else {
			    		$reviewerHtml.='<span class="star-num">'.$objReview->rating.'<span><img src='.plugin_dir_url(( __FILE__ ) ) . 'images/fill-2-copy-45.svg'.'></span></span>';

			    	}
			
			if($objReview->sourceType == 'BirdEye'){
			  				$reviewerHtml.='<span class="on-brand"><a target=_blank style="color: #1976d2;" href='.$objReview->uniqueReviewUrl.'>on <span class="brand">'.$objReview->sourceType.'</a>,</span></span><span class="date">'.$objReview->reviewDate .'</span>';
			  			}else{
                             $reviewerHtml.='<span class="on-brand"><a target=_blank style="color: #1976d2"; href='.$objReview->reviewUrl.'>on <span class="brand">'.$objReview->sourceType.'</a>,</span></span><span class="date">'.$objReview->reviewDate .'</span>';

			  			}'</p>';
		$reviewerHtml.='<p class="heading">'.$reviewerName.'</p>';
		$reviewerHtml.='<p class="content">'.$objReview->comments .'</p>
		</article>
		<hr>';
   echo $reviewerHtml;

}
exit();
}
/***************** Our Main Function ******************/
ob_start();
function birdeye_plugin()
{
wp_register_script ( 'mysample1', plugins_url ( 'js/birdeye.ajax.js', __FILE__ ) );
wp_enqueue_script('mysample1');
$businessNumber = get_option('businessNumber');
$apiKey = get_option('apiKey');
$apiHost = get_option('apiHost');
$cssStyle = get_option('cssStyle');
$check = get_option('demo-checkbox');
$appointTab = get_option('Appointment-tab');
$reviewTab = get_option('review-tab');
$numOfReviews = get_option('default-reviews');
$opts = array(
		'http' => array(
				'method' => 'GET',
				'header'=> "Content-Type: application/json\r\n" . 
				"Accept: application/json\r\n"
		)
);

$context = stream_context_create($opts);

$postData = [
    "statuses" => ["published"]
];

$opts1 = array(
            'http' => array(
                'method' => 'POST',
                'header'=> "Content-Type: application/json\r\n" . 
                "Accept: application/json\r\n",
                "content" => json_encode($postData)
        )
);

$context1 = stream_context_create($opts1);
$response = file_get_contents('https://' . $apiHost . '/resources/v1/business/number/' . $businessNumber . '?api_key=' . $apiKey, false, $context);
$objBusiness = json_decode($response);
$publicProfileUrl = getPublicProfileUrl($objBusiness);
$poweredUrl = 'https://birdeye.com';
$poweredText = 'Powered by BirdEye';

if ($objBusiness->accountType == 2) {
    $poweredUrl = $objBusiness->resellerInfo->websiteUrl;
    $poweredText = 'Provided by ' . $objBusiness->resellerInfo->name;
}
?>
<script type="text/javascript">
var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
</script>
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
<style type="text/css"><?=$cssStyle;?></style>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js"></script>

	<div class="review-wrapper">
                         
		<div class="grid grid--1of3">
			<section class="grid-cell left">
				<div class="">
					<!--Rating Box-->
					<p><?php echo $objBusiness->name ;?> review summary</p>
					<?php if(!empty($check)) {?>
	        <?php 
				  $response1 = file_get_contents('https://' . $apiHost . '/resources/v1/review/businessid/' . $businessNumber . '/summary?api_key=' . $apiKey .'&statuses=published',false ,$context);
	            $objReview = json_decode($response1);
				$htmlOut ='<div id="reviewsBySite" class="card-content-wrapper">
						<div class="review-summary">
							<div class="review-bar" style="width:62%;">';
				 arsort($objReview->ratings);
          $mycount =$objBusiness->reviewCount;
          foreach($objReview->ratings as $reviewSummary) {
        	$relativeWidth = (($reviewSummary->reviewCount / $mycount) * 100) * 0.6;
            if ($reviewSummary->rating > 0){			
					$htmlOut .= '<div>
									<span class="bew_c_ratingstar">
										<span class="beInverseRating">
											<span class="ratingval">'. $reviewSummary->rating.'</span>
											<span class="starOn">
												<img src='.plugin_dir_url(( __FILE__ ) ) . 'images/star-active.svg'.'>
											</span>
										</span>
									</span>
									<span class="bf-brand-color-bg" style="width:'. $relativeWidth .'%;">&nbsp;</span>';
							if ($reviewSummary->reviewCount > 0) {		
								$htmlOut .= '<span class="number">' . $reviewSummary->reviewCount . '</span>';
							}
								$htmlOut .= '</div>';
						 } else { 
                if ($reviewSummary->reviewCount > 0){
                    $htmlOut .= '<span class="noRating">'. $reviewSummary->reviewCount .' reviews with no rating</span>';
                }
            }
        }
        echo $htmlOut;
        ?>		
		</div>
		<?php
						$response = file_get_contents('https://' . $apiHost . '/resources/v1/business/' . $businessNumber . '?api_key=' . $apiKey, false, $context);
						$objBusiness = json_decode($response);
						$avrating= number_format($objBusiness->avgRating, 1);
			$reviewall='<div class="stars-without-bubble">
					<div class="bew-avgstars bf-brand-color ">
						<span class="be-c-ratingval">'. $avrating .'</span>';
						echo $reviewall;
					
						for($x=0; $x < $objBusiness->avgRating; $x++){
					echo $star='<span class="be-c-star">
								<span class="starOn"><img src='.plugin_dir_url(( __FILE__ ) ) . 'images/star-active.svg'.'></span>
							</span>';}?>
					
					</div>
				</div>

			</div>
		</div>
<hr class="hidden-xs">

	<div class="hidden-xs">
		<div class="reviews-sources">
			<span class="heading">View by source:</span>
			  <?php 
				 $response = file_get_contents('https://' . $apiHost . '/resources/v1/review/businessid/' . $businessNumber . '/summary?api_key=' . $apiKey .'&statuses=published',false ,$context);
		         $objReviews = json_decode($response);
				 //echo $objReviews->sources[1];
				 $strSummery = '<div class="reviews-source"><input type="checkbox" name="reviews-filter" value="all"> All</div>';
				 for($i=0; $i< sizeof($objReviews->sources); $i++){
					$objReviews->sources[$i]->sourceAlias= ($objReviews->sources[$i]->sourceAlias== 'birdeye') ? "our_website" : $objReviews->sources[$i]->sourceAlias;
			  		$strSummery.= '<div class="reviews-source"><input type="checkbox" name="reviews-filter" value="' .$objReviews->sources[$i]->sourceAlias .'"> ' .$objReviews->sources[$i]->sourceName . '<span> ('.$objReviews->sources[$i]->reviewCount .')</span></div>';
			  	} 
				echo $strSummery;
			    ?>
<?php }?>
	</div>
	
	</div>
	<hr class="hidden-xs">

	    <div class="actionButtonWrapper">
				<?php if(!empty($reviewTab)){?>
					<a id="btnWriteAReview" href="<?php echo $publicProfileUrl; ?>/mobile" class="" target="_blank">
						Write a review
					</a><?php }?>
	            <?php if(!empty($appointTab)){?>
					<a href="<?php echo $publicProfileUrl; ?>/appointment" target="_blank">
						Request appointment
					</a>
				<?php }?>
			</div>
		<?php $hostname =$_SERVER['HTTP_HOST'];?>
		<div class="powered">
			<a href="https://birdeye.com/?utm_source=<?php echo $hostname;?>&utm_medium=wordpress_clients&utm_campaign=wordpressplugin&utm_term=poweredby" target="_blank">
				<img src="<?php echo plugin_dir_url(( __FILE__ ) ) . 'images/BirdEye-Logo.png'; ?>">
			</a>
		</div>
	</section>
	<hr class="hidden-xs">
	<section class="grid-cell rights" id="Reviews_Container">
	<?php 
$response = file_get_contents('https://' . $apiHost . '/resources/v1/review/businessid/' . $businessNumber . '/summary?api_key=' . $apiKey .'&statuses=published',false ,$context);
$objReviews = json_decode($response);    
	$strSummery = '<div class="visible-xs">
			<select name="selectSource" class="selectSource">
				<option value="" selected>View all sources</option>';
			for($i=0; $i< sizeof($objReviews->sources); $i++){
					$objReviews->sources[$i]->sourceAlias= ($objReviews->sources[$i]->sourceAlias== 'birdeye') ? "our_website" : $objReviews->sources[$i]->sourceAlias;
    		$strSummery.= '<option value="' .$objReviews->sources[$i]->sourceAlias .'">' .$objReviews->sources[$i]->sourceName . ' ('.$objReviews->sources[$i]->reviewCount .')';				
}
echo $strSummery;?> 
			</select>
		</div>

<div class="block"> 
		
<?php
// Reviews GET API consume
$response = file_get_contents('https://' . $apiHost . '/resources/v1/review/businessId/' . $businessNumber . '?api_key=' . $apiKey . '&sindex=0&count='.$numOfReviews , false, $context1);
$objReviews = json_decode($response);
//print_r($objReviews);
foreach($objReviews as $objReview) {
$objReview->sourceType = $objReview->sourceType == 'Our Website' ? "BirdEye" : $objReview->sourceType;
$objReview->recommended = $objReview->recommended == 1 ? "Recommended" : "Null";
$reviewerImg = $objReview->reviewer->thumbnailUrl;
$reviewerName = !empty($objReview->reviewer->firstName) ? $objReview->reviewer->firstName : $objReview->reviewer->nickName;		
$reviewerHtml='<article>
			<p>
			    <span><img src=' .$reviewerImg. ' class="person"></span>';
			 if ($objReview->recommended =='Recommended'){

			    		$reviewerHtml.='<span><img src='.plugin_dir_url(( __FILE__ ) ) . 'images/fb_r.svg'.'></span><span class="beFBColor">Recommended</span>';

			    	}else {
			    		$reviewerHtml.='<span class="star-num">'.$objReview->rating.'<span><img src='.plugin_dir_url(( __FILE__ ) ) . 'images/fill-2-copy-45.svg'.'></span></span>';

			    	}	
			if($objReview->sourceType == 'BirdEye'){
			  				$reviewerHtml.='<span class="on-brand"><a target=_blank style="color: #1976d2"; href='.$objReview->uniqueReviewUrl.'>on <span class="brand">'.$objReview->sourceType.'</a>,</span></span><span class="date">'.$objReview->reviewDate .'</span>';
			  			}else{
                             $reviewerHtml.='<span class="on-brand"><a target=_blank style="color: #1976d2"; href='.$objReview->reviewUrl.'>on <span class="brand">'.$objReview->sourceType.'</a>,</span></span><span class="date">'.$objReview->reviewDate .'</span>';

			  			}'</p>';
		$reviewerHtml.='<p class="heading">'.$reviewerName.'</p>';
		$reviewerHtml.='<p class="content">'.$objReview->comments .'</p>
		</article>
		<hr>';
   echo $reviewerHtml;
}
?>
	</div>  
</section>
</div>
</div>
<?php 
/***** Our LocalBusiness Script ********/
// Business GET API Consume
$ImgUrl = !empty($objBusiness->coverImageUrl) ? $objBusiness->coverImageUrl : (!empty($objBusiness->categoryImageUrl) ? $objBusiness->categoryImageUrl : "");
$businessStr = '<span itemprop="name">'. $objBusiness->name .'</span> 
 <div itemprop="aggregateRating" itemscope="0" itemtype="https://schema.org/AggregateRating">Rating : 
      <span itemprop="ratingValue">' . $objBusiness->avgRating . '</span>
      | Review Count :
	 <span itemprop="reviewCount">
	 <a href=https://birdeye.com/a-'.$businessNumber.' target=_blank>' . $objBusiness->reviewCount . '</a> reviews
	 </span></div>';
$businessStr.='<img title="'. $objBusiness->name .'" style="display:none;" alt="'. $objBusiness->name .'" src="https://ddjkm7nmu27lx.cloudfront.net/'.$businessNumber.'/'.$ImgUrl.'" itemprop="image">';

 $businessStr.='<div style="display:none;">
 <span itemprop="address" itemscope itemtype="http://schema.org/PostalAddress">
 <span itemprop="streetAddress" content="'.$objBusiness->locations[0]->address1.''.$objBusiness->locations[0]->address2.'">'.$objBusiness->locations[0]->address1.' '.$objBusiness->locations[0]->address2.'
 </span>
 <span itemprop="addressLocality" content="'.$objBusiness->locations[0]->city.'">'.$objBusiness->locations[0]->city.' </span>
 <span itemprop="addressRegion" content="'.$objBusiness->locations[0]->state.'">'.$objBusiness->locations[0]->state.' </span>
 <span itemprop="postalCode" content="'. $objBusiness->locations[0]->zip.'">'.$objBusiness->locations[0]->zip.' </span>
 <span itemprop="addressCountry" content="'.$objBusiness->locations[0]->countryCode.'" style="display: none;"> </span>
 </span>
 </div>
 <span style="display:none;" itemprop="priceRange">exclude</span>
 <span style="display:none;" itemprop="telephone">'.$objBusiness->phone.'</span>';
 echo "<div class='busiDet' style='display:none;'>$businessStr</div></div>";
 }
add_shortcode( 'BirdEyePlugin', 'birdeye_plugin' );
?>