<?php
/*
Plugin Name: Gravity Forms Tooltips
Plugin URI: https://jetsloth.com/gravity-forms-tooltips
Description: Easily add tooltips to your Gravity Forms fields
Author: JetSloth
Version: 1.1.17
Requires at 3.5
Tested up to: 5.7.1
Author URI: https://jetsloth.com
License: GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: gf_tooltips
*/

/*
	Copyright 2020 JetSloth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2, as
    published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

define('GFTT_VERSION', '1.1.17');
define('GFTT_HOME', 'https://jetsloth.com');
define('GFTT_NAME', 'Gravity Forms Tooltips');
define('GFTT_SLUG', 'gf-tooltips');
define('GFTT_AUTHOR', 'JetSloth');
define('GFTT_TIMEOUT', 20);
define('GFTT_SSL_VERIFY', false);

add_action( 'gform_loaded', array( 'GF_Tooltips_Bootstrap', 'load' ), 5 );

class GF_Tooltips_Bootstrap {

	public static function load() {

		if ( ! method_exists( 'GFForms', 'include_addon_framework' ) ) {
			return;
		}

		// are we on GF 2.5+
		define( 'GFTT_GF_MIN_2_5', version_compare( GFCommon::$version, '2.5-dev-1', '>=' ) );

		require_once( 'class-gf-tooltips.php' );

		GFAddOn::register( 'GFTooltips' );
	}
}

function gf_tooltips() {
	if ( ! class_exists( 'GFTooltips' ) ) {
		return false;
	}

	return GFTooltips::get_instance();
}

add_action('init', 'gf_tooltips_plugin_updater', 0);
function gf_tooltips_plugin_updater() {

	if (gf_tooltips() === false) {
		return;
	}

	if ( ! class_exists( 'EDD_SL_Plugin_Updater' ) ) {
		// load our custom updater if it doesn't already exist
		include_once( dirname( __FILE__ ) . '/inc/EDD_SL_Plugin_Updater.php' );
	}

	// retrieve the license key
	$license_key = trim( gf_tooltips()->get_plugin_setting( 'gf_tooltips_license_key' ) );

	// setup the updater
	$edd_updater = new EDD_SL_Plugin_Updater( GFTT_HOME, __FILE__, array(
			'version'   => GFTT_VERSION,
			'license'   => $license_key,
			'item_name' => GFTT_NAME,
			'author'    => 'JetSloth'
		)
	);

}
