<?php

class Youzify_Social_Share_Admin {

    public $field_name;

    function __construct() {

        // Set Licence Field Name
        $this->field_name = 'yz_social_share_license_key';

        add_filter( 'youzify_extensions_settings_menu', array( $this, 'settings_menu' ) );

        // Add Plugin Links.
        add_filter( 'plugin_action_links_' . YZSS_BASENAME, array( $this, 'plugin_action_links' ) );

        // Add Plugin Links in Multisite..
        add_filter( 'network_admin_plugin_action_links_' . YZSS_BASENAME, array( $this, 'plugin_action_links' ) );

        // Check for updates.
        add_action( 'admin_init', array( $this, 'check_for_updates' ) );

    }

    /**
     * Action Links
     */
    function plugin_action_links( $links ) {
        // Get Youzer Plugin Pages.
        $panel_url = esc_url( add_query_arg( array( 'page' => 'youzify-extensions-settings&tab=social-share' ), admin_url( 'admin.php' ) ) );
        $plugin_url = 'https://youzify.com/downloads/buddypress-social-share/';
        $documentation_url = 'https://kainelabs.ticksy.com/articles/100012977';
        // Add a few links to the existing links array.
        return array_merge( $links, array(
            'settings' => '<a href="' . $panel_url . '">' . esc_html__( 'Settings', 'youzify-social-share' ) . '</a>',
            'documentation' => '<a href="' . $documentation_url . '">' . esc_html__( 'Documentation',    'youzify-social-share' ) . '</a>',
            'about'    => '<a href="' . $plugin_url . '">' . esc_html__( 'About',    'youzify-social-share' ) . '</a>'
        ) );
    }

    /**
     * # Add Settings New Tab
     */
    function settings_menu( $tabs ) {

        $tabs['social-share'] = array(
            'icon'  => 'fas fa-share-square',
            'id'    => 'social-share',
            'function' => array( $this, 'settings' ),
            'title' => __( 'Social Share Settings', 'youzify-social-share' ),
        );

        return $tabs;

    }

    /**
     * Social Share Seetings.
     */
    function settings() {

        global $Youzify_Admin;

        // Get License.
        $license = get_option( $this->field_name );

        if ( ! empty( $license ) ) {

        // Get License Status.
        $Youzify_Admin->get_license_status( array( 'license' => $license, 'option_id' => $this->field_name, 'product_id' => 171, 'position' => 'top' )  );

        global $Youzify_Settings;

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'General Settings', 'youzify-social-share' ),
                'type'  => 'openBox'
            )
        );

        // $Youzify_Settings->get_field(
        //     array(
        //         'title' => __( 'Enable Social Share', 'youzify-social-share' ),
        //         'desc'  => __( 'Enable the social share feature', 'youzify-social-share' ),
        //         'id'    => 'yzss_enable_social_share',
        //         'type'  => 'checkbox'
        //     )
        // );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Display Share Buttons For Visitors', 'youzify-social-share' ),
                'desc'  => __( 'Allow non logged-in user to use sharing buttons', 'youzify-social-share' ),
                'id'    => 'yzss_enable_nonloggedin_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Share Button title', 'youzify-social-share' ),
                'desc'  => __( 'Activity social share button title', 'youzify-social-share' ),
                'id'    => 'yzss_share_btn_title',
                'type'  => 'text'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Networks Type', 'youzify-social-share' ),
                'id'    => 'yzss_networks_bg_type',
                'desc'  => __( 'Header background type', 'youzify-social-share' ),
                'type'  => 'select',
                'opts'  => array(
                    'gray'      => __( 'Gray', 'youzify-social-share' ),
                    'silver'    => __( 'Silver', 'youzify-social-share' ),
                    'colorful'  => __( 'Colorful', 'youzify-social-share' ),
                    'no-bg'     => __( 'No Background', 'youzify-social-share' )
                ),
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Networks Style', 'youzify-social-share' ),
                'id'    => 'yzss_networks_border_style',
                'desc'  => __( 'Networks background style', 'youzify-social-share' ),
                'type'  => 'select',
                'opts'  => $Youzify_Settings->get_field_options( 'border_styles' )
            )
        );

        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Sharable Elements', 'youzify-social-share' ),
                'class' => 'ukai-box-3cols',
                'type'  => 'openBox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Posts', 'youzify-social-share' ),
                'desc'  => __( 'Allow sharing wall posts', 'youzify-social-share' ),
                'id'    => 'yzss_enable_posts_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Users Profile', 'youzify-social-share' ),
                'desc'  => __( 'Allow sharing users profile', 'youzify-social-share' ),
                'id'    => 'yzss_enable_profiles_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Groups', 'youzify-social-share' ),
                'desc'  => __( 'Allow sharing groups', 'youzify-social-share' ),
                'id'    => 'yzss_enable_groups_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Members Directory', 'youzify-social-share' ),
                'desc'  => __( 'Enable members cards social share', 'youzify-social-share' ),
                'id'    => 'yzss_enable_md_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Groups Directory', 'youzify-social-share' ),
                'desc'  => __( 'Enable groups cards social share', 'youzify-social-share' ),
                'id'    => 'yzss_enable_gd_social_share',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Networks Visibility Settings', 'youzify-social-share' ),
                'class' => 'ukai-box-3cols',
                'type'  => 'openBox'
            )
        );

        // Get social networks.
        $social_networks = yzss_share_networks();

        foreach ( $social_networks as $key => $data ) {
            $Youzify_Settings->get_field(
                array(
                    'title' => $data['title'],
                    'desc'  => sprintf( __( 'Enable %s', 'youzify-social-share' ), $data['title'] ),
                    'id'    => 'yzss_enable_' . $key,
                    'type'  => 'checkbox'
                )
            );
        }

        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Sharable Posts', 'youzify-social-share' ),
                'class' => 'ukai-box-2cols',
                'type'  => 'openBox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Status Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the status post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_status_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Photo Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the photo post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_photo_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Slideshow Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the slideshow post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_slideshow_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Quote Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the quote post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_quote_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Link Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the link post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_link_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Video Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the video post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_video_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Audio Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the audio post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_audio_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'File Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the file post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_activity_file_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Cover Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the cover post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_new_cover_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Avatar Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the avatar post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_new_avatar_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Blog Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the blog post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_new_blog_post_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Comment Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the comment post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_new_blog_comment_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Friendship Created Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the created friendship post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_friendship_created_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Friendship Accepted Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the accepted group post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_friendship_accepted_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Group Creation Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the created group post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_created_group_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Joined Group Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the joined group post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_joined_group_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'New Member Post', 'youzify-social-share' ),
                'desc'  => __( 'Make the new member post sharable', 'youzify-social-share' ),
                'id'    => 'yzss_is_new_member_sharable',
                'type'  => 'checkbox'
            )
        );

        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Open Graph Default Thumbnails', 'youzify-social-share' ),
                'type'  => 'openBox'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Profile Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the user profile default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_profile',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Group Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the group default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_group',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Status Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the status post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_status',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Quote Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the quote post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_quote',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Link Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the link post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_link',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Video Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the video post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_video',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Audio Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the audio post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_audio',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'File Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the file post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_activity_file',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'New Blog Post Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the new blog post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_new_blog_post',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'New Blog Comment Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the new blog comment post default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_new_blog_comment',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Friendship Created/Accepted Posts Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the friendship created or accepted posts default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_friendship',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field(
            array(
                'title' => __( 'Group Created/Joined Posts Thumbnail', 'youzify-social-share' ),
                'desc'  => __( 'Set the group created or joined posts default thumbnail', 'youzify-social-share' ),
                'id'    => 'yzss_default_thumb_group_created',
                'type'  => 'upload'
            )
        );

        $Youzify_Settings->get_field( array( 'type' => 'closeBox' ) );

        }

        // Get License Settings.
        $Youzify_Admin->get_license_settings( array( 'license' => $license, 'option_id' => $this->field_name, 'product_id' => 171 )  );

    }


    /**
     * Check For Updates.
     **/
    function check_for_updates() {

        // Get Licence.
        $license = get_option( $this->field_name );

        if ( empty( $license ) ) {
            return;
        }

        if ( ! class_exists( 'Youzify_Addons_Updater' ) ) {
            require YZ_SOCIAL_SHARE_PATH . 'admin/panel/youzify-addons-updater.php';
        }

        // setup the updater
        $edd_updater = new Youzify_Addons_Updater( YOUZIFY_STORE_URL,
            YZSS_FILE,
            array(
                'version' => YZSS_VERSION,
                'license' => $license,
                'item_id' => '171',
                'author'  => 'Youssef Kaine',
                'beta'    => false,
            )
        );

    }

}

$social_share = new Youzify_Social_Share_Admin();