( function( $ ) {

    'use strict';

    $( document ).ready( function() {

    	function yzss_PopupCenter(url, title, w, h ) {
		    // Fixes dual-screen position                         Most browsers      Firefox
		    var dualScreenLeft = window.screenLeft != undefined ? window.screenLeft : window.screenX;
		    var dualScreenTop = window.screenTop != undefined ? window.screenTop : window.screenY;

		    var width = window.innerWidth ? window.innerWidth : document.documentElement.clientWidth ? document.documentElement.clientWidth : screen.width;
		    var height = window.innerHeight ? window.innerHeight : document.documentElement.clientHeight ? document.documentElement.clientHeight : screen.height;

		    var left = ((width / 2) - (w / 2)) + dualScreenLeft;
		    var top = ((height / 2) - (h / 2)) + dualScreenTop;
		    var newWindow = window.open(url, title, 'scrollbars=yes, resizable=yes, width=' + w + ', height=' + h + ', top=' + top + ', left=' + left);

		    // Puts focus on the newWindow
		    if ( window.focus ) {
		        newWindow.focus();
		    }
		}

    	// Show Pop Up.
    	$( 'body' ).on( 'click', '.youzify-share-buttons a', function( e ) {
	        e.preventDefault();
	        var button = $( this );
	        if ( $( this ).hasClass( 'youzify-copy_link-sbtn' ) ) {
	        	var copyText = button.attr( 'href' ), old_text = button.attr( 'data-youzify-tooltip' );
			    navigator.clipboard.writeText(copyText);
			    navigator.clipboard.writeText(copyText).then(function() {
				}, function() {

				});
			    button.attr( 'data-youzify-tooltip', button.attr( 'data-copied' ) );
			    setTimeout( function() {
			    	button.attr( 'data-youzify-tooltip', old_text );
				}, 500 );
	        	return;
	        }
	        yzss_PopupCenter( button.attr( 'href' ), 'targetWindow', 700, 500 );
    	});

    	// Get Share buttons.
    	$( document ).on( 'click', '.youzify-social-share-activity', function( e ) {

	        e.preventDefault();

    		// Load Scripts.
    		youzify_ss_load_files();

	        // Get Current Buttons.
	        var yz_share_btn = $( this );

	        // Show/Hide Share Buttons.
	        if ( $( this ).attr( 'data-loaded' ) == 'true' ) {
	        	yz_share_btn.closest( 'li' ).find( '.activity-meta' ).prev( '.youzify-share-buttons' ).fadeToggle();
	        	return;
	        }

    		// Disable Click On Displaying Share Box.
    		if ( yz_share_btn.hasClass( 'youzify-loading-share-btns' ) ) {
    			return false;
    		}

	        // Add Loading Class.
	        yz_share_btn.addClass( 'youzify-loading-share-btns' );

	       // Get Data.
			var data = {
				'component' : 'activity',
				'action' : 'yzss_get_post_social_share_buttons',
				'item_id' : $( this ).closest( 'li' ).attr( 'id' ).split( '-' )[1]
			};

			// Get Social Buttons.
			jQuery.post( ajaxurl, data, function( response ) {

	        	// Remove Loading Class.
	        	yz_share_btn.removeClass( 'youzify-loading-share-btns' );

				// Mark Buttons as Loaded.
				yz_share_btn.attr( 'data-loaded', 'true' );

				// Append Content.
				$( response ).insertBefore( yz_share_btn.closest( 'li' ).find( '.activity-meta' ).first() );

			});

    	});

    	/**
    	 * Share Profile / Group
    	 */
    	$( document ).on( 'click', '.youzify-social-share-btn', function( e ) {

    		e.preventDefault();

    		// Load Scripts.
    		youzify_ss_load_files();

    		// Init Vars
    		var yz_curent_btn = $( this ), yz_item_id;

    		// Get Component
    		var yz_component = $( this ).parent( '.youzify-tools' ).attr( 'data-component' );

    		// Get Component
    		if ( 'profile' == yz_component ) {
    			yz_item_id = $( this ).parent( '.youzify-tools' ).attr( 'data-user-id' );
    		} else if ( 'group' == yz_component ) {
    			yz_item_id = $( this ).parent( '.youzify-tools' ).attr( 'data-group-id' );
    		}

    		// Show Loaded Modal.
    		if ( $( this ).attr( 'data-loaded' ) == 'true' ) {

    			// Add Modal Class.
				$( 'body' ).addClass( 'youzify-modal-overlay-active' );

    			if ( 'profile' == yz_component ) {
	    			$( '.youzify-social-share-modal[data-user-id="' + yz_item_id + '"]' ).fadeIn();
    			} else if( 'group' == yz_component ) {
	    			$( '.youzify-social-share-modal[data-group-id="' + yz_item_id + '"]' ).fadeIn();
	    		}

    			return;
    		}

    		// Disable Click On Displaying Share Box.
    		if ( $( this ).hasClass( 'loading' ) ) {
    			return false;
    		}

    		// Add Loading Class.
    		yz_curent_btn.addClass( 'loading' );

    		// Get Button Data.
			var data = {
				item_id: yz_item_id,
				component : yz_component,
				action : 'yzss_get_profile_social_share_buttons'
			};

			// Process Verification.
			$.post( ajaxurl, data, function( res ) {

				if ( res == '0' ) {

		    		// Remove Loading Class.
		    		yz_curent_btn.removeClass( 'loading' );

					return false;

				} else {

					// Mark Button As laoded.
					yz_curent_btn.attr( 'data-loaded', 'true' );

		    		// Remove Loading Class.
		    		yz_curent_btn.removeClass( 'loading' );

					// Update Button Icon.
					yz_curent_btn.find( '.youzify-tool-icon i' ).attr( 'class', 'fas fa-share-alt' );

					// Append Content.
    				$( 'body' ).append( res ).addClass( 'youzify-modal-overlay-active' );

					return false;
				}

			});

		});

		// Load Social Share Files.
		function youzify_ss_load_files() {
    		if ( ! $( 'body' ).hasClass( 'youzify-social-share-scripts' ) ) {
    			$( 'body' ).addClass( 'youzify-social-share-scripts' );
    			$( 'head' ).append( '<link href="' + Youzify_Social_Share.path + 'assets/css/youzify-social-share.min.css' + '" rel="stylesheet" type="text/css">' );
    			$( 'head' ).append( '<link href="' + Youzify_Social_Share.path + 'assets/css/all.min.css' + '" rel="stylesheet" type="text/css">' );
    		}
		}

		/**
		 * Hide Modal if user clicked Close Button or Icon
		 */
		$( document ).on( 'click', '.youzify-close-dialog' , function( e ) {

			e.preventDefault();

			// Get Data.
			$( this ).closest( '.youzify-social-share-modal' ).fadeOut( 300, function() {
				$( 'body' ).removeClass( 'youzify-modal-overlay-active' );
			});

		});

		// Hide Modal If User Clicked Escape Button
		$( document ).keyup( function( e ) {
			if ( $( '.youzify-social-share-modal' )[0] ) {
			    if ( e.keyCode === 27 ) {
				    $( '.youzify-close-dialog' ).trigger( 'click' );
			    }
			}
		});

    });

})( jQuery );