<?php

// Add Reports Buttons.
add_action( 'init', 'youzify_ss_add_activity_share_buttons' );

/**
 * Add activity Report button.
 */
function youzify_ss_add_activity_share_buttons() {
    if ( 'on' == youzify_social_share_option( 'yzss_enable_posts_social_share', 'on' ) ) {
		add_action( 'bp_activity_entry_meta_non_logged_in', 'yzss_add_wall_share_button' );
	}
}

/**
 * Add New Sharing Button
 */
function yzss_add_wall_share_button() {

	if ( ! yzss_is_post_type_sharable( bp_get_activity_type() ) ) {
		return;
	}

	?>

    <a href="#" class="button youzify-social-share-activity bp-primary-action" data-loaded="false"><?php echo youzify_social_share_option( 'yzss_share_btn_title', __( 'Social Share', 'youzify-social-share' ) ); ?></a><?php
}

/**
 * Add Members Report Button
 */
add_action( 'bp_before_members_loop', 'youzify_ss_add_members_report_button' );
add_action( 'youzify_profile_before_profile', 'youzify_ss_add_members_report_button' );

function youzify_ss_add_members_report_button() {

    if ( bp_is_user() && 'off' == youzify_social_share_option( 'yzss_enable_profiles_social_share', 'on' ) ) {
    	return;
    }

    if ( bp_is_members_directory() && 'off' == youzify_social_share_option( 'yzss_enable_md_social_share', 'on' ) ) {
        return;
    }

	add_action( 'youzify_user_tools', 'yzss_get_user_social_share_tool', 10, 2 );

}

/**
 * Get Social Share User Tool.
 */
function yzss_get_user_social_share_tool( $user_id = null, $icons = null ) {

	// Get Button Title.
	$button_title = __( 'Share Profile', 'youzify-social-share' );

	?>

	<div class="youzify-tool-btn youzify-social-share-btn" <?php if ( 'only-icons' == $icons ) { ?> data-youzify-tooltip="<?php echo $button_title; ?>"<?php } ?>>
		<div class="youzify-tool-icon"><i class="fas fa-share-alt"></i></div><?php if ( 'full-btns' == $icons ) : ?><div class="youzify-tool-name"><?php echo $button_title; ?></div><?php endif; ?>
	</div>

	<?php
}

/**
 * Add Groups Report Button
 */
add_action( 'bp_before_groups_loop','youzify_ss_add_groups_report_button' );
add_action( 'youzify_group_before_group', 'youzify_ss_add_groups_report_button' );

function youzify_ss_add_groups_report_button() {

    if ( bp_is_group() && 'off' == youzify_social_share_option( 'yzss_enable_groups_social_share', 'on' ) ) {
        return;
    }

    if ( bp_is_groups_directory() && 'off' == youzify_social_share_option( 'yzss_enable_gd_social_share', 'on' ) ) {
        return;
    }

	add_action( 'youzify_group_tools', 'yzss_get_group_social_share_tool', 10, 2 );

}

/**
 * Get Social Share - Group Tool.
 */
function yzss_get_group_social_share_tool( $group_id = null, $icons = null ) {

    if ( 'hidden' == bp_get_group_status() ) {
        return;
    }

   	// Get Button Title.
	$button_title = __( 'Share Group', 'youzify-social-share' );

	?>

	<div class="youzify-tool-btn youzify-social-share-btn" <?php if ( 'only-icons' == $icons ) { ?> data-youzify-tooltip="<?php echo $button_title; ?>"<?php } ?>>
		<div class="youzify-tool-icon"><i class="fas fa-share-alt"></i></div><?php if ( 'full-btns' == $icons ) : ?><div class="youzify-tool-name"><?php echo $button_title; ?></div><?php endif; ?>
	</div>

	<?php
}