<?php

/**
 * Legacy Theme - Add Activity Report Button
 */
function youzify_ss_add_legacy_activity_share_button() { ?>

    <a href="#" class="button item-button bp-secondary-action youzify-social-share-activity" rel="nofollow"><span class="youzify-spinner"></span><?php echo youzify_social_share_option( 'yzss_share_btn_title', __( 'Social Share', 'youzify-social-share' ) ); ?></a>

    <?php

}

/**
 * Legacy Theme - Add Profile Report Button
 */
add_action( 'bp_before_members_loop', 'youzify_ss_add_members_share_button' );
add_action( 'bp_before_member_header', 'youzify_ss_add_members_share_button' );

function youzify_ss_add_members_share_button() {

    // Add Profiles Buttons
    if ( 'on' == youzify_social_share_option( 'yzss_enable_profiles_social_share', 'on' ) ) {
        add_action( 'bp_member_header_actions', 'youzify_ss_add_legacy_profile_share_button', 99 );
    }

    // Add Members Directory Buttons
    if ( 'on' == youzify_social_share_option( 'yzss_enable_md_social_share', 'on' ) ) {
        add_action( 'bp_directory_members_actions', 'youzify_ss_add_legacy_md_share_button', 99 );
    }

}

function youzify_ss_add_legacy_profile_share_button() {

    ?>

    <div class="generic-button youzify-tools" data-component="profile" data-user-id="<?php echo bp_displayed_user_id(); ?>"><a class="youzify-social-share-user youzify-social-share-btn"><span class="youzify-spinner"></span><?php _e( 'Share Profile', 'youzify-social-share' ); ?></a></div>


    <?php

}

/**
 * Legacy Theme - Add Members Directory Report Button
 */

function youzify_ss_add_legacy_md_share_button() { ?>

    <div class="generic-button youzify-tools" data-component="profile" data-user-id="<?php echo bp_get_member_user_id(); ?>"><a class="youzify-social-share-user youzify-social-share-btn" ><span class="youzify-spinner"></span><?php _e( 'Share Profile', 'youzify-social-share' ); ?></a></div>

    <?php

}

/**
 * Legacy Theme - Add Group Report Button
 */
function youzify_ss_add_legacy_group_share_button() {

    if ( 'on' != youzify_social_share_option( 'yzss_enable_groups_social_share', 'on' ) ) {
        return;
    }

    if ( 'hidden' == bp_get_group_status() ) {
        return;
    }

    ?>

    <div class="generic-button youzify-tools" data-group-id="<?php echo bp_get_group_id(); ?>" data-component="group"><a class="youzify-social-share-group youzify-social-share-btn"><span class="youzify-spinner"></span><?php _e( 'Share Group', 'youzify-social-share' ); ?></a></div>
    <?php

}

/**
 * Add Group Report Button.
 */
add_action( 'bp_group_header_actions', 'youzify_ss_add_legacy_group_share_button', 99 );

add_action( 'bp_before_groups_loop', 'youzify_ss_add_groups_share_button' );
add_action( 'youzify_group_before_group', 'youzify_ss_add_groups_share_button' );

function youzify_ss_add_groups_share_button() {

    if ( 'on' == youzify_social_share_option( 'yzss_enable_gd_social_share', 'on' ) ) {
        add_action( 'bp_directory_groups_actions', 'youzify_ss_add_legacy_group_share_button', 99 );
    }

}

/**
 * Add Activity & Comment Report Button.
 */

add_action( 'init', 'youzify_ss_add_legacy_buttons' );

function youzify_ss_add_legacy_buttons() {

    if ( wp_doing_ajax() ) {

        if ( 'on' == youzify_social_share_option( 'yzss_enable_posts_social_share', 'on' ) ) {
            add_action( 'bp_activity_entry_meta', 'youzify_ss_add_legacy_activity_share_button', 99 );
        }

    }
}

add_action( 'bp_before_activity_loop', 'youzify_ss_add_activity_share_button' );

function youzify_ss_add_activity_share_button() {

    if ( 'on' == youzify_social_share_option( 'yzss_enable_posts_social_share', 'on' ) ) {
        add_action( 'bp_activity_entry_meta', 'youzify_ss_add_legacy_activity_share_button', 99 );
    }

}

/**
 * Add Single Activity Report Buttons.
 */
add_action( 'bp_before_activity_entry', 'youzify_ss_add_single_activity_share_button' );

function youzify_ss_add_single_activity_share_button() {

    if ( ! bp_is_single_activity() ) {
        return;
    }

    if ( 'on' == youzify_social_share_option( 'yzss_enable_posts_social_share', 'on' ) ) {
        add_action( 'bp_activity_entry_meta', 'youzify_ss_add_legacy_activity_share_button', 999 );
    }

}


/**
 * Show Meta For Non Logged-In Users
 */
add_action( 'bp_activity_entry_content', 'yzss_non_logged_in_meta' );
function yzss_non_logged_in_meta() {

    if ( is_user_logged_in() ) {
        return;
    }

    ?>

    <div class="activity-meta"><?php do_action( 'bp_activity_entry_meta' ); ?></div>

    <?php
}