<?php

/**
 * Add Activity and Report Buttons.
 */
add_action( 'init', 'youzify_ss_add_activity_share_button' );

function youzify_ss_add_activity_share_button() {

    if ( yzss_is_posts_sharable() ) {
        add_filter( 'bp_nouveau_get_activity_entry_buttons', 'youzify_ss_add_nouveau_activity_share_button', 999 );
    }

}

/**
 * Add Activity Report Button.
 */
function youzify_ss_add_nouveau_activity_share_button( $buttons ) {

    // Get Button.
    $buttons['activity_social_share'] = array(
        'id'          => 'activity_social_share',
        'position'    => 90,
        'must_be_logged_in' => false,
        'component'   => 'activity',
        'link_text'   => '<span><span class="youzify-spinner"></span>' . youzify_social_share_option( 'yzss_share_btn_title', __( 'Social Share', 'youzify-social-share' ) ) . '</span>',
        'button_attr' => array(
            'class'   => 'button bp-secondary-action youzify-social-share-activity',
        )
    );

    return $buttons;
}

/**
 * Add Members Report Button.
 */
add_action( 'bp_before_members_loop', 'youzify_ss_add_members_share_button' );
add_action( 'bp_before_member_header', 'youzify_ss_add_members_share_button' );

function youzify_ss_add_members_share_button() {

    // Add Profiles Buttons
    if ( 'on' == youzify_social_share_option( 'yzss_enable_profiles_social_share', 'on' ) ) {
        add_filter( 'bp_nouveau_get_members_buttons', 'youzify_ss_add_nouveau_members_share_button', 99, 3 );
    }

    // Add Members Directory Buttons
    if ( 'on' == youzify_social_share_option( 'yzss_enable_md_social_share', 'on' ) ) {

        add_action( 'bp_directory_members_actions', 'youzify_ss_add_nouveau_md_share_button' );

        if ( function_exists( 'buddyboss_theme' ) ) {
            add_action( 'bp_member_members_list_item', 'youzify_ss_add_buddyboss_md_share_button' );
        }

    }

}

function youzify_ss_add_nouveau_members_share_button( $buttons, $user_id, $type ) {

    if ( $type == 'loop' ) {
        return $buttons;
    }

    // Get Button.
    $buttons['user_social_share'] = array(
        'id'                => 'user_social_share',
        'position'          => 99,
        'component'         => 'members',
        'block_self'        => false,
        'parent_element'    => 'li',
        'must_be_logged_in' => false,
        'button_element'    => 'button',
        'link_text'  => '<span class="youzify-spinner"></span>' . __( 'Share Profile', 'youzify-social-share' ),
        'parent_attr'       => array(
            'id'    => 'youzify-social-share-user-' . $user_id,
            'data-user-id'    => $user_id,
            'data-component'    => 'profile',
            'class' => 'generic-button youzify-tools',
        ),
        'button_attr' => array(
            'class'   => 'button youzify-social-share-user youzify-social-share-btn',
        )
    );

    return $buttons;
}

function youzify_ss_add_nouveau_md_share_button() { ?>

    <li class="generic-button youzify-tools" data-component="profile" data-user-id="<?php echo bp_get_member_user_id(); ?>"><button class="youzify-social-share-user youzify-social-share-btn" ><span class="youzify-spinner"></span><?php _e( 'Share Profile', 'youzify-social-share' ); ?></button></li>

    <?php

}

/**
 * BuddyBoss - Members Directory
 */
function youzify_ss_add_buddyboss_md_share_button() { ?>

    <div class="generic-button youzify-tools" data-component="profile" data-user-id="<?php echo bp_get_member_user_id(); ?>"><button class="youzify-social-share-user youzify-social-share-btn" ><i class="bb-icon-share-small"></i><span class="youzify-spinner"></span><?php _e( 'Share Profile', 'youzify-social-share' ); ?></button></div>

    <?php
}

/**
 * Add Groups Report Button.
 */
add_action( 'bp_before_group_header_meta', 'youzify_ss_add_groups_report_button' );
add_action( 'bp_before_groups_loop', 'youzify_ss_add_groups_report_button' );

function youzify_ss_add_groups_report_button() {

    if ( 'on' == youzify_social_share_option( 'yzss_enable_groups_social_share', 'on' ) ) {
        add_filter( 'bp_nouveau_get_groups_buttons', 'youzify_ss_add_nouveau_groups_share_button', 99, 3 );
    }

    if ( 'on' == youzify_social_share_option( 'yzss_enable_gd_social_share', 'on' ) ) {
        add_action( 'bp_directory_groups_actions', 'youzify_ss_add_nouveau_gd_share_button' );
    }

}

function youzify_ss_add_nouveau_groups_share_button( $buttons, $group, $type ) {

    if ( $type == 'loop' || $group->status == 'hidden' ) {
        return $buttons;
    }

    // Get Button.
    $buttons['group_social_share'] = array(
        'id'             => 'group_social_share',
        'position'       => 97,
        'component'      => 'groups',
        'parent_element' => 'div',
        'must_be_logged_in' => false,
        'button_element' => 'button',
        'link_text'      => '<span class="youzify-spinner"></span>' . __( 'Share Group', 'youzify-social-share' ),
        'parent_attr'    => array(
            'data-component' => 'group',

            'id'         => 'youzify-social-share-group-' . $group->id,
            'data-group-id' => $group->id,
            'class'         => 'generic-button youzify-tools',
        ),
        'button_attr' => array(
            'class'   => 'button group-button youzify-social-share-group youzify-social-share-btn'
        )
    );

    return $buttons;
}

function youzify_ss_add_nouveau_gd_share_button() {

    if ( 'hidden' == bp_get_group_status() ) {
        return;
    }

    ?>

    <div class="generic-button youzify-tools" data-group-id="<?php echo bp_get_group_id(); ?>" data-component="group"><button class="group-button youzify-social-share-group youzify-social-share-btn"><span class="youzify-spinner"></span><?php _e( 'Share Group', 'youzify-social-share' ); ?></button></div>

    <?php
}

/**
 * BuddyBoss CSS.
 */
add_action( 'wp_head', 'yzss_buddyboss_css' );

function yzss_buddyboss_css() {

    if ( ! defined( 'BP_PLATFORM_VERSION' ) ) {
        return;
    }

    ?>

    <style type="text/css">

        .activity-list .activity-item .bp-generic-meta.action .youzify-social-share-activity:before {
            content: "\e830";
        }

        .buddyboss-theme #members-list.item-list li .bp-members-list-hook .youzify-tools {
            text-align: center;
        }
        .youzify-social-share-group.loading span:before,
        .youzify-social-share-activity.youzify-loading-share-btns:before {
            content: "" !important;
        }

        .buddyboss-theme .youzify-tools .youzify-social-share-user {
            color: #898989;
            background: #fff;
            text-align: center;
            border: 1px solid #eee;
            background: transparent;
        }

        .buddyboss-theme .youzify-social-share-user i {
            margin-right: 5px;
            font-size: 18px;
        }

        .buddyboss-theme .youzify-share-buttons {
            padding: 8px 0;
        }

    </style>

    <?php

}