<?php

/**
 * Get Option
 */
function youzify_social_share_option( $option, $default = null ) {

    if ( ! is_multisite() ) {
        $option_value = get_option( $option, $default );
    } else {
        if ( apply_filters( 'youzify_activate_blog_mode', true, $option ) ) {
            $option_value = get_blog_option( null, $option, $default );
        } else {
            $option_value = get_site_option( $option, $default );
        }
    }

    return $option_value;

}

/**
 * Youzify Options
 */
function youzify_social_share_options( $option_id ) {

    // Get Option Value.
    $option_value = ! is_multisite() ? get_option( $option_id ) : get_blog_option( null, $option_id );

    if ( empty( $option_value ) ) {

        // Get Default Options.
        $default_options = apply_filters( 'youzify_default_options', array() );

        // Check if option exists.
        if ( isset( $default_options[ $option_id ] ) ) {
            $option_value = $default_options[ $option_id ];
        }

    }

    return $option_value;
}

/**
 * # Default Options
 */
function yzss_default_options( $options ) {

    // Options.
    $youzify_social_share_options = array(
        'yzss_enable_facebook' => 'on',
        'yzss_enable_twitter' => 'on',
        'yzss_enable_whatsapp' => 'on',
        'yzss_enable_linkedin' => 'on',
        'yzss_enable_renren' => 'on',
        'yzss_enable_xing' => 'on',
        'yzss_enable_pinterest' => 'on',
        'yzss_enable_line' => 'on',
        'yzss_enable_copy_link' => 'on',
        'yzss_enable_email' => 'on',
        'yzss_enable_yahoo' => 'on',
        'yzss_enable_skype' => 'on',
        'yzss_enable_gmail' => 'on',
        'yzss_enable_delicious' => 'on',
        'yzss_enable_getpocket' => 'on',
        'yzss_enable_livejournal' => 'on',
        'yzss_enable_flattr' => 'on',
        'yzss_enable_telegram' => 'on',
        'yzss_enable_weibo' => 'on',
        'yzss_enable_vk' => 'on',
        'yzss_enable_stumbleupon' => 'on',
        'yzss_enable_evernote' => 'on',
        'yzss_enable_blogger' => 'on',
        'yzss_enable_digg' => 'on',
        'yzss_enable_buffer' => 'on',
        'yzss_enable_tumblr' => 'on',
        'yzss_enable_reddit' => 'on',
        'yzss_enable_odnoklassniki' => 'on',
        'yzss_enable_flipboard' => 'on',
        'yzss_enable_nonloggedin_social_share' => 'on',
        'yzss_enable_md_social_share' => 'on',
        'yzss_enable_gd_social_share' => 'on',
        'yzss_enable_groups_social_share' => 'on',
        'yzss_enable_posts_social_share' => 'on',
        'yzss_enable_profiles_social_share' => 'on',
        'yzss_enable_social_share' => 'on',
        'yzss_networks_bg_type' => 'colorful',
        'yzss_networks_border_style' => 'radius',
        'yzss_is_activity_link_sharable' => 'on',
        'yzss_is_activity_video_sharable' => 'on',
        'yzss_is_activity_photo_sharable' => 'on',
        'yzss_is_activity_quote_sharable' => 'on',
        'yzss_is_activity_audio_sharable' => 'on',
        'yzss_is_activity_file_sharable' => 'on',
        'yzss_is_activity_status_sharable' => 'on',
        'yzss_is_activity_slideshow_sharable' => 'on',
        'yzss_is_joined_group_sharable' => 'on',
        'yzss_is_created_group_sharable' => 'on',
        'yzss_is_friendship_created_sharable' => 'on',
        'yzss_is_friendship_accepted_sharable' => 'on',
        'yzss_is_new_cover_sharable' => 'on',
        'yzss_is_new_member_sharable' => 'on',
        'yzss_is_new_avatar_sharable' => 'on',
        'yzss_is_new_blog_post_sharable' => 'on',
        'yzss_is_new_blog_comment_sharable' => 'on',
        'yzss_share_btn_title' => __( 'Social Share', 'youzify-social-share' ),
        'yzss_default_thumb_friendship' => YZ_SOCIAL_SHARE_URL . 'assets/images/frienship.png',
        'yzss_default_thumb_group' => YZ_SOCIAL_SHARE_URL . 'assets/images/group-thumbnail.png',
        'yzss_default_thumb_group_created' => YZ_SOCIAL_SHARE_URL . 'assets/images/joined-group.png',
        'yzss_default_thumb_profile' => YZ_SOCIAL_SHARE_URL . 'assets/images/profile-thumbnail.png',
        'yzss_default_thumb_activity_link' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-link.png',
        'yzss_default_thumb_new_blog_post' => YZ_SOCIAL_SHARE_URL . 'assets/images/post-thumbnail.png',
        'yzss_default_thumb_activity_file' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-file.png',
        'yzss_default_thumb_activity_audio' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-audio.png',
        'yzss_default_thumb_activity_quote' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-quote.png',
        'yzss_default_thumb_activity_video' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-video.png',
        'yzss_default_thumb_activity_status' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-status.png',
        'yzss_default_thumb_new_blog_comment' => YZ_SOCIAL_SHARE_URL . 'assets/images/activity-comment.png',
    );

    $options = array_merge( $options, $youzify_social_share_options );

    return $options;
}

add_filter( 'youzify_default_options', 'yzss_default_options' );

/**
 * Get Profiles/Groups Share Buttons
 */

add_action( 'wp_ajax_nopriv_yzss_get_profile_social_share_buttons', 'yzss_get_component_share_buttons' );
add_action( 'wp_ajax_yzss_get_profile_social_share_buttons', 'yzss_get_component_share_buttons' );

function yzss_get_component_share_buttons() {

    // Get Data.
    $item_id = $_POST['item_id'];
    $component = $_POST['component'];

    if ( empty( $item_id ) || empty( $component ) ) {
        die( '0' );
    }
    // Get Modal Target.
    $target = $component == 'profile' ? 'user' : $component;

    // Get Title.
    $title = $component == 'profile' ? __( 'Share Profile' , 'youzify-social-share' ) : __( 'Share Group' , 'youzify-social-share' );

    ?>

    <div class="youzify-social-share-modal" data-<?php echo $target; ?>-id="<?php echo $item_id; ?>">
        <div class="youzify-modal" >
            <div class="youzify-dialog-container">
                <div class="youzify-dialog-header"><i class="fas fa-share-alt"></i><?php echo $title; ?></div>
                <div class="youzify-dialog-msg">
                    <div class="youzify-dialog-desc">
                        <?php yzss_share_buttons( $item_id, $component ); ?>
                    </div>
                </div>
                <ul class="youzify-dialog-buttons">
                    <li><a class="youzify-close-dialog"><?php _e( 'Cancel', 'youzify-social-share' ); ?></a></li>
                </ul>
            </div>
        </div>
    </div>

    <?php

    die();

}

/**
 * Get Share Button Url Title.
 */
function yzss_get_share_button_url_title( $component, $item_id ) {

    // Init Var.
    $title = null;

    if ( 'profile' == $component ) {

        // Get User Display Name .
        $display_name = bp_core_get_user_displayname( $item_id);

        // Set Title.
        $title = sprintf( __( "%s's Profile", 'youzify-social-share' ), $display_name );

    } else if ( 'group' == $component ) {

        // Get Group.
        $group = groups_get_group( array( 'group_id' => $item_id ) );

        // Set Title.
        $title = sprintf( __( "%s Group", 'youzify-social-share' ), bp_get_group_name( $group ) );

    } else if ( 'activity' == $component ) {

        // Get Acitivty.
        $activity = $activity = new BP_Activity_Activity( $item_id );

        // Get User Display Name .
        $display_name = bp_core_get_user_displayname( $activity->user_id );

        switch ( $activity->type ) {

            case 'friendship_accepted':
            case 'friendship_created':
            case 'new_blog_comment':
            case 'new_blog_post':
            case 'created_group':
            case 'joined_group':
            case 'new_avatar':
            case 'new_cover':
                $title = $activity->action;
                break;

            case 'activity_quote':
                $title = sprintf( __( "%s's posted a new quote", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_video':
                $title = sprintf( __( "%s's posted a new video", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_audio':
                $title = sprintf( __( "%s's posted a new audio", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_link':
                $title = sprintf( __( "%s's posted a new link", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_photo':
                $title = sprintf( __( "%s's posted a new photos", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_file':
                $title = sprintf( __( "%s's posted a new file", 'youzify-social-share' ), $display_name );
                break;

            case 'activity_slideshow':
                $title = sprintf( __( "%s's posted a new slideshow", 'youzify-social-share' ), $display_name );
                break;

            default:
                $title = $activity->action;
                break;
        }
    }

    // Remove Html Tags.
    $title = wp_strip_all_tags( $title );

    return apply_filters( 'yzss_get_share_button_url_title', $title, $component, $item_id );
}

/**
 * Check if Post is Sharable
 */
function yzss_is_post_type_sharable( $post_type = null ) {

    // Init Var.
    $is_sharable = true;

    // Get Option Value.
    $share_visibility = youzify_social_share_option( 'yzss_is_' . $post_type . '_sharable', 'on' );

    if ( ! empty( $share_visibility ) && 'off' == $share_visibility ) {
        $is_sharable = false;
    }

    return apply_filters( 'yzss_is_post_type_sharable', $is_sharable , $post_type );
}

/**
 * Call Social Sharing Assets.
 */
function yzss_share_buttons( $item_id = null, $component = null ) {

    // Get Data.
    $item_id = ! empty( $item_id ) ? $item_id : $_POST['item_id'];
    $component =  ! empty( $component ) ? $component : $_POST['component'];

    // Get Activity.
    $activity = new BP_Activity_Activity( $item_id );

    if ( empty( $item_id ) || empty( $component ) ) {
        return;
    }

    $media = '';
    $description = '';

    // Get Networks.
    $networks = yzss_share_networks();

    switch ( $component ) {

        case 'activity':

            // Get Post Link.
            $link = bp_get_root_domain() . '/' . bp_get_activity_root_slug() . '/p/' . $item_id . '/';

            // Get Media.
            $media = yzss_get_default_activity_image( $activity );

            // Get Description.
            $description = yzss_get_activity_description( $activity );

            break;

        case 'profile':
            // Get Profile Link.
            $link = bp_core_get_user_domain( $item_id );
            break;

        case 'group':
            // Get Group Link.
            $group = groups_get_group( array( 'group_id' => $item_id ) );
            $link = bp_get_group_permalink( $group );
            break;

    }

    if ( empty( $description ) ) {
        // Get Url Title Value.
        $description = yzss_get_share_button_url_title( $component, $item_id );
    }


    ?>

    <div class="youzify-share-buttons" <?php if ( ! class_exists('Youzify') ) { echo 'style="display: inline-block;"'; } ?>>

        <?php foreach ( $networks as $network => $data ) : ?>
            <?php if ( $data['visibility'] == 'off' ) continue; ?>
            <?php $href = yzss_get_share_url( $component, $data['href'], $link, $description, $media, $activity, $network ); ?>
            <a href="<?php echo $href; ?>" class="youzify-share-btn youzify-<?php echo $network; ?>-sbtn" data-youzify-tooltip="<?php echo $data['description']; ?>" target="_blank" <?php if ( $network == 'copy_link' ) echo 'data-copied="' . __( 'Copied', 'youzify-social-share' ) . '"'; ?>><?php if ( isset( $data['icon'] ) ) : ?><i class="<?php echo $data['icon']; ?>"></i><?php else : echo $data['svg'] ; endif;?></a>
        <?php endforeach; ?>

    </div>

    <?php

}

add_action( 'wp_ajax_nopriv_yzss_get_post_social_share_buttons', 'yzss_share_buttons' );
add_action( 'wp_ajax_yzss_get_post_social_share_buttons', 'yzss_share_buttons' );

/**
 * Generate Share Url
 */
function yzss_get_share_url( $component, $scheme, $link, $text, $media = false,  $activity, $network ) {

    // Replace Data.
    if ( $component == 'activity' ) {

        $scheme = str_replace( '{media}', $media, $scheme );

        if ( $network == 'twitter' ) {

            // Extract Hashtags.
            preg_match_all( '/[#]([\p{L}_0-9a-zA-Z-]{1,100})\b(?!;)/iu', $activity->content, $hashtags );

            if ( isset( $hashtags[1] ) && ! empty( $hashtags[1] ) ) {

                // Remove hashtags from text & Left space if found.
                $text = ltrim( str_replace( $hashtags[0], '', $text ) );

                // Add link hashtags.
                $scheme .= '&amp;hashtags=' .  implode( $hashtags[1], ',' );
            }

        }
    }

    $scheme = str_replace( '{url}', $link, $scheme );
    $scheme = str_replace( '{text}', $text, $scheme );

    return $scheme;
}

/**
 * Check if Profile is Sharable.
 */
function yzss_is_posts_sharable() {

    // Init Var.
    $sharable = true;

    // Get Social Share Buttons Visibility.
    if ( 'off' == youzify_social_share_option( 'yzss_enable_posts_social_share', 'on' ) ) {
        $sharable = false;
    }

    return apply_filters( 'yzss_is_profiles_sharable', $sharable );

}

/**
 * Check if Profile is Sharable.
 */
function yzss_is_profiles_sharable() {

    // Init Var.
    $sharable = true;

    // Get Buttons Visibility.
    $share_md = youzify_social_share_option( 'yzss_enable_md_social_share', 'on' );
    $share_profile = youzify_social_share_option( 'yzss_enable_profiles_social_share', 'on' );

    if ( bp_is_user() && 'off' == $share_profile ) {
        $sharable = false;
    }

    if ( bp_is_members_directory() && 'off' == $share_md ) {
        $sharable = false;
    }

    return apply_filters( 'yzss_is_profiles_sharable', $sharable );

}

/**
 * Check if Group is Sharable.
 */
function yzss_is_groups_sharable() {

    // Init Var.
    $sharable = true;

    // Get Buttons Visibility.
    $share_gd = youzify_social_share_option( 'yzss_enable_gd_social_share', 'on' );
    $share_group = youzify_social_share_option( 'yzss_enable_groups_social_share', 'on' );

    if ( bp_is_group() && 'off' == $share_group ) {
        $sharable = false;
    }

    if ( bp_is_groups_directory() && 'off' == $share_gd ) {
        $sharable = false;
    }

    return apply_filters( 'yzss_is_groups_sharable', $sharable );

}

/**
 * Call Social Sharing Assets.
 */
function yzss_scripts() {

    // Call CSS.
    // wp_enqueue_style( 'youzify-social-share', YZ_SOCIAL_SHARE_URL . 'assets/css/youzify-social-share.min.css' );

    // Call JS.
    wp_enqueue_script( 'youzify-social-share', YZ_SOCIAL_SHARE_URL . 'assets/js/youzify-social-share.min.js' );

    wp_localize_script( 'youzify-social-share', 'Youzify_Social_Share',
        array(
            'path' => YZ_SOCIAL_SHARE_URL
        )
    );

}

add_action( 'wp_enqueue_scripts', 'yzss_scripts' );

/**
 * Allow Non Logged-In Users to share posts, profiles ...
 */
function yzss_allow_nonloggedin_users_to_share() {

    // Check if non logged-in users are allowed to share posts.
    $display_share_btns = youzify_social_share_option( 'yzss_enable_nonloggedin_social_share', 'on' );

    if ( ! is_user_logged_in() && 'on' == $display_share_btns ) {
        return true;
    }

    return false;

}

/**
 * Call Social Sharing Assets.
 */
function yzss_share_networks() {
    $networks = array(
        'facebook' => array(
            'icon'        => 'fab fa-facebook',
            'title'       => __( 'Facebook', 'youzify-social-share' ),
            'description' => __( 'Share On Facebook', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_facebook', 'on' ),
            'href'        => 'https://www.facebook.com/sharer/sharer.php?u={url}',
        ),
        'twitter' => array(
            'icon'        => 'fab fa-twitter',
            'title'       => __( 'Twitter', 'youzify-social-share' ),
            'description' => __( 'Share On Twitter', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_twitter', 'on' ),
            'href'        => 'https://twitter.com/intent/tweet?text={text}&amp;url={url}',
        ),
        'whatsapp' => array(
            'icon'        => 'fab fa-whatsapp',
            'title'       => __( 'Whatsapp', 'youzify-social-share' ),
            'description' => __( 'Share On Whatsapp', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_whatsapp', 'on' ),
            'href'        => 'whatsapp://send?text={text} {url}',
        ),
        'linkedin' => array(
            'icon'        => 'fab fa-linkedin-in',
            'title'       => __( 'Linked In', 'youzify-social-share' ),
            'description' => __( 'Share On LinkedIn', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_linkedin', 'on' ),
            'href'        => 'https://www.linkedin.com/shareArticle?mini=true&url={url}&amp;title={text}',
        ),
        'pinterest' => array(
            'icon'        => 'fab fa-pinterest',
            'title'       => __( 'Pinterest', 'youzify-social-share' ),
            'description' => __( 'Pin it', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_pinterest', 'on' ),
            'href'        => 'http://pinterest.com/pin/create/button/?url={url}m&description={text}&media={media}',
        ),
        'tumblr' => array(
            'icon'        => 'fab fa-tumblr',
            'title'       => __( 'Tumblr', 'youzify-social-share' ),
            'description' => __( 'Share On Tumblr', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_tumblr', 'on' ),
            'href'        => 'https://www.tumblr.com/widgets/share/tool?canonicalUrl={url}&title={text}',
        ),
        'blogger' => array(
            'icon'        => 'fab fa-blogger-b',
            'title'       => __( 'Blogger', 'youzify-social-share' ),
            'description' => __( 'Share On Blogger', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_blogger', 'on' ),
            'href'        => 'https://www.blogger.com/blog-this.g?u={url}&t={text}',
        ),
        'reddit' => array(
            'icon'        => 'fab fa-reddit',
            'title'       => __( 'Reddit', 'youzify-social-share' ),
            'description' => __( 'Share On Reddit', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_reddit', 'on' ),
            'href'        => 'https://reddit.com/submit?url={url}&title={text}',
        ),
        'evernote' => array(
            'title'       => __( 'Evernote', 'youzify-social-share' ),
            'description' => __( 'Share On Evernote', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_evernote', 'on' ),
            'href'        => 'http://www.evernote.com/clip.action?url={url}&title={text}',
            'icon'        => 'fab fa-evernote',
        ),
        // 'stumbleupon' => array(
        //     'icon'        => 'fab fa-stumbleupon',
        //     'title'       => __( 'Stumbleupon', 'youzify-social-share' ),
        //     'description' => __( 'Share On Stumbleupon', 'youzify-social-share' ),
        //     'visibility'  => youzify_social_share_option( 'yzss_enable_stumbleupon', 'on' ),
        //     'href'        => 'http://www.stumbleupon.com/submit?url={url}',
        // ),
        'digg' => array(
            'icon'        => 'fab fa-digg',
            'title'       => __( 'Digg', 'youzify-social-share' ),
            'description' => __( 'Share On Digg', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_digg', 'on' ),
            'href'        => 'http://digg.com/submit?url={url}',
        ),
        'vk' => array(
            'icon'        => 'fab fa-vk',
            'title'       => __( 'VK', 'youzify-social-share' ),
            'description' => __( 'Share On VK', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_vk', 'on' ),
            'href'        => 'http://vk.com/share.php?url={url}&comment={text}',
        ),
        'weibo' => array(
            'icon'        => 'fab fa-weibo',
            'title'       => __( 'Weibo', 'youzify-social-share' ),
            'description' => __( 'Share On Weibo', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_weibo', 'on' ),
            'href'        => 'http://service.weibo.com/share/share.php?url={url}&appkey=&title={text}&pic=&ralateUid=',
        ),
        'xing' => array(
            'icon'        => 'fab fa-xing',
            'title'       => __( 'Xing', 'youzify-social-share' ),
            'description' => __( 'Share On Xing', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_xing', 'on' ),
            'href'        => 'https://www.xing.com/app/user?op=share&url={url}',
        ),
        'skype' => array(
            'icon'        => 'fab fa-skype',
            'title'       => __( 'Skype', 'youzify-social-share' ),
            'description' => __( 'Share On Skype', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_skype', 'on' ),
            'href'        => 'https://web.skype.com/share?url={url}&text={text}',
        ),
        'odnoklassniki' => array(
            'icon'        => 'fab fa-odnoklassniki',
            'title'       => __( 'Odnoklassniki', 'youzify-social-share' ),
            'description' => __( 'Share On Odnoklassniki', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_odnoklassniki', 'on' ),
            'href'        => 'http://www.odnoklassniki.ru/dk?st.cmd=addShare&st.s=1&st._surl={url}',
        ),
        'delicious' => array(
            'icon'        => 'fab fa-delicious',
            'title'       => __( 'Delicious', 'youzify-social-share' ),
            'description' => __( 'Share On Delicious', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_delicious', 'on' ),
            'href'        => 'https://del.icio.us/login?log=out&provider=essb&title={text}&url={url}',
        ),
        'buffer' => array(
            'title'       => __( 'Buffer', 'youzify-social-share' ),
            'description' => __( 'Share On Buffer', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_buffer', 'on' ),
            'href'        => 'https://buffer.com/add?text={text}&url={url}',
            'icon'         => 'fab fa-buffer',
        ),
        'yahoo' => array(
            'icon'        => 'fab fa-yahoo',
            'title'       => __( 'Yahoo', 'youzify-social-share' ),
            'description' => __( 'Send On Yahoo', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_yahoo', 'on' ),
            'href'        => 'http://compose.mail.yahoo.com/?body={text} {url}',
        ),
        'getpocket' => array(
            'icon'        => 'fab fa-get-pocket',
            'title'       => __( 'GetPocket', 'youzify-social-share' ),
            'description' => __( 'Share On GetPocket', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_getpocket', 'on' ),
            'href'        => 'https://getpocket.com/edit?url={url}',
        ),
        'telegram' => array(
            'icon'        => 'fab fa-telegram',
            'title'       => __( 'Telegram', 'youzify-social-share' ),
            'description' => __( 'Share On Telegram', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_telegram', 'on' ),
            'href'        => 'https://telegram.me/share/url?url={url}&text={text}',
        ),
        'gmail' => array(
            'icon'        => 'fas fa-envelope',
            'title'       => __( 'Gmail', 'youzify-social-share' ),
            'description' => __( 'Send On Gmail', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_gmail', 'on' ),
            'href'        => 'https://mail.google.com/mail/?view=cm&su={text}&body={url}',
        ),
        'flipboard' => array(
            'title'       => __( 'Flipboard', 'youzify-social-share' ),
            'description' => __( 'Share On Flipboard', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_flipboard', 'on' ),
            'href'        => 'https://share.flipboard.com/bookmarklet/popout?v=2&title={text}&url={url}',
            'icon'         => 'fab fa-flipboard',
        ),
        'flattr' => array(
            'title'       => __( 'Flattr', 'youzify-social-share' ),
            'description' => __( 'Share On Flattr', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_flattr', 'on' ),
            'href'        => 'https://flattr.com/submit/auto?user_id=&url={url}&description={text}&hidden=HIDDEN',
            'svg'         => '<svg height="60px" version="1.1" viewBox="0 0 60 60" width="60px" xmlns="http://www.w3.org/2000/svg" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns" xmlns:xlink="http://www.w3.org/1999/xlink"><title/><desc/><defs/><g fill="none" fill-rule="evenodd" id="black" stroke="none" stroke-width="1"><g id="slice" transform="translate(-600.000000, -600.000000)"/><g fill="#000000" id="flattr" transform="translate(14.000000, 14.000000)"><path d="M25.3406335,19.5040754 C25.3406335,22.4368639 24.8542772,25.0783682 17.1430281,25.3013343 L17.1594713,20.1342308 C17.1594713,20.0935577 17.1534134,20.02 17.1430285,19.9827885 C17.0919692,19.8019231 16.9284064,19.6686538 16.7336888,19.6686538 C16.6237815,19.6686538 16.5216629,19.7257692 16.4152173,19.8304808 L5.24275278,30.9982692 L12.7424102,31 L21.0598817,31 C27.6404719,31 31,27.2096154 31,20.1325 L31,15.1885577 L31,5.28509615 L25.3406335,11.4053205 L25.3406335,19.5040754 Z M6.6597992,12.4959246 C6.6597992,9.56313614 7.14615549,6.92163183 14.8574046,6.69866571 L14.8409614,11.8657692 C14.8409614,11.9064423 14.8470193,11.98 14.8574042,12.0172115 C14.9084635,12.1980769 15.0720263,12.3313462 15.2667439,12.3313462 C15.3766512,12.3313462 15.4787698,12.2742308 15.5852154,12.1695192 L26.7576799,1.00173077 L19.2580225,1 L10.940551,1 C4.35996077,1 1.00043271,4.79038462 1.00043271,11.8675 L1.00043271,16.8114423 L1.00043271,26.7149038 L6.6597992,20.5946795 L6.6597992,12.4959246 Z"/></g></g></svg>',
        ),
        'renren' => array(
            'icon'        => 'fab fa-renren',
            'title'       => __( 'Renren', 'youzify-social-share' ),
            'description' => __( 'Share On Renren', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_renren', 'on' ),
            'href'        => 'http://widget.renren.com/dialog/share?resourceUrl={url}&srcUrl={url}&description={text}',
        ),
        'line' => array(
            'icon'         => 'fab fa-line',
            'title'       => __( 'Line', 'youzify-social-share' ),
            'description' => __( 'Share On Line', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_line', 'on' ),
            'href'        => 'https://social-plugins.line.me/lineit/share?url={url}&text={text}',
        ),
        'livejournal' => array(
            'title'       => __( 'LiveJournal', 'youzify-social-share' ),
            'description' => __( 'Share On LiveJournal', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_livejournal', 'on' ),
            'href'        => 'http://www.livejournal.com/update.bml?subject={text}&event={url}',
            'svg'         => '<svg enable-background="new 0 0 512 512" height="512px" id="Слой_1" version="1.1" viewBox="0 0 512 512" width="512px" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"><path d="M464.526,314.746l-0.063,0.031L245.193,22.29l-0.031,0.031C233.037,7.353,213.757,0.008,191.508,0.008  c-27.03,0-58.372,10.844-86.402,32.093c-51.154,38.749-72.278,97.59-47.966,132.62l-0.031,0.031l219.272,292.458l0.063-0.031  l188.491,54.813L464.526,314.746z M401.279,427.055c-7.25,5.5-12.063,13.031-14.281,21.221l-80.496-23.406  c19.344-29.623,25.719-66.061,17.844-100.371c30.654,17.063,67.246,20.969,100.935,10.404l0.219,84.217  C417.06,418.992,408.528,421.555,401.279,427.055z M233.068,71.693l20.624,27.53c-24.093,2.625-50.591,13.187-74.652,31.405  c-24.124,18.28-41.561,40.999-50.716,63.591l-20.593-27.499c0.75-3.5,1.718-6.625,2.593-9.218  c3.531-10.125,9.094-20.187,16.5-29.999c7.875-10.437,17.53-19.968,28.592-28.374c11.062-8.375,22.843-15.031,34.998-19.781  c11.406-4.468,22.593-7.062,33.249-7.656C226.381,71.538,229.568,71.475,233.068,71.693z M301.754,275.811L201.476,142.035  c8.344-5.406,17.031-9.906,25.936-13.375c11.375-4.469,22.593-7.031,33.25-7.688c2.688-0.125,5.874-0.156,9.374,0.031  l145.212,193.679c-13.874,3.814-28.499,4.814-43.153,2.75C343.876,313.434,318.908,298.652,301.754,275.811z M144.698,216.032  c0.75-3.468,1.719-6.593,2.594-9.188c3.562-10.125,9.093-20.218,16.53-29.999c5.75-7.656,12.468-14.812,19.937-21.374  l100.245,133.746l-0.031,0.031c17.156,22.842,24.438,51.061,20.47,79.402c-2.063,14.781-7.095,28.656-14.563,41L144.698,216.032z   M128.73,63.601c10.593-8,21.811-14.218,33.342-18.437c10.25-3.719,20.437-5.687,29.436-5.687c10.75,0,19.218,2.812,23.187,7.75  l2.031,2.656c-24.093,2.656-50.591,13.218-74.653,31.436c-24.124,18.25-41.561,40.999-50.685,63.592l-2.063-2.75  C80.294,129.161,91.137,92.067,128.73,63.601z" id="Livejournal_1_"/></svg>',
        ),
        'copy_link' => array(
            'icon'         => 'far fa-copy',
            'title'       => __( 'Copy Link', 'youzify-social-share' ),
            'description' => __( 'Copy Link', 'youzify-social-share' ),
            'visibility'  => youzify_social_share_option( 'yzss_enable_copy_link', 'on' ),
            'href'        => '{url}'
        ),
    );

    return apply_filters( 'yzss_share_networks', $networks );

}

/*
 * Get Social Share Body
 */
function yzss_social_share_body_class( $classes ) {

    // Get Styling
    $classes[] = 'youzify-share-btns-' . youzify_social_share_option( 'yzss_networks_bg_type', 'colorful' );
    $classes[] = 'youzify-share-btns-' . youzify_social_share_option( 'yzss_networks_border_style', 'radius' );

    return $classes;
}

/**
 * Get Open Graph Tags
 */
function youzify_ss_get_open_graph_tags( $type = null, $url = null,  $title = nul, $description = null, $image = null, $size = null ) {

    if ( ! apply_filters( 'youzify_display_open_graph_tags', true ) ) {
        return;
    }

    $type = ! empty( $type ) ? $type : 'profile';

    ?>

    <!-- Youzify - BuddyPress Social Share Open Graph Tags -->

    <meta property="twitter:card" content="summary_large_image">
    <meta property="og:type" content="<?php echo $type; ?>">

    <?php if ( ! empty( $title ) ) : ?>
        <meta property="twitter:title" content="<?php echo $title; ?>">
        <meta property="og:title" content="<?php echo $title; ?>">
    <?php endif; ?>

    <meta property="og:url" content="<?php echo $url; ?>">

    <?php if ( ! empty( $image ) ) : ?>
        <meta property="og:image" content="<?php echo $image; ?>">
        <meta property="twitter:image" content="<?php echo $image; ?>">
    <?php endif; ?>

    <?php if ( ! empty( $description ) ) : $description = wp_strip_all_tags( $description ); ?>
        <meta property="og:description" content="<?php echo $description; ?>">
        <meta property="twitter:description" content="<?php echo $description; ?>">
    <?php endif; ?>

    <!-- End of Tags -->

    <?php

}
