<?php

/***
 * Get Wall Post Opengraph
 */
function youzify_social_share_get_wall_post_open_graph() {

	if ( ! bp_is_user_activity() ) {
		return false;
	}

	global $bp;

	$activity = new BP_Activity_Activity( $bp->current_action );

	if ( empty( $activity ) ) {
		return false;
	}

	// Init Vars.
	$title = null;
	$image = null;
	$audio = null;
	$video = null;
	$type = 'profile';
	$description = null;
	$url = is_ssl() ? 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']: 'http://'. $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];

	$post_type = bp_activity_get_meta( $activity->id, 'post-type' );

	// Get Attachments.
	$attachments = bp_activity_get_meta( $activity->id, 'youzify_attachments' );

	switch ( $activity->type ) {

		case 'activity_update':
			$image = yzss_get_buddyboss_image( $activity );
			break;

		case 'new_avatar':
		case 'new_cover':
		case 'activity_slideshow':
		case 'activity_photo':

			if ( ! empty( $attachments ) ) {
				$image = wp_get_attachment_url( key( $attachments ) );
			}

		break;

        case 'created_group':
        case 'joined_group':
			$image = youzify_social_share_options( 'yzss_default_thumb_group_created' );
		break;

        case 'activity_giphy':
			$image = bp_activity_get_meta( $activity->id, 'giphy_image' );;
		break;

        case 'activity_status':

			// Get Url Data.
			$url_data = bp_activity_get_meta( $activity->id, 'url_preview' );

			if ( ! empty( $url_data ) ) {

				// Unserialize data.
				$url_data = is_serialized( $url_data ) ? unserialize( $url_data ) : maybe_unserialize( base64_decode( $url_data ) );

				if ( isset( $url_data['image'] ) && ! empty( $url_data['image'] ) ) {
					$image = $url_data['image'];
				}

				if ( isset( $url_data['title'] ) && ! empty( $url_data['title'] ) ) {
					$title = $url_data['title'];
				}

				if ( empty( $activity->content) && isset( $url_data['description'] ) && ! empty( $url_data['description'] ) ) {
					$description = $url_data['description'];
				}

			}

			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_activity_status' );
			}

		break;

        case 'friendship_accepted':
        case 'friendship_created':
			$image = youzify_social_share_options( 'yzss_default_thumb_friendship' );
		break;

		case 'activity_link':

			if ( ! empty( $attachments ) ) {
				$image = wp_get_attachment_url( key( $attachments ) );
			}

			$description = bp_activity_get_meta( $activity->id, 'yz-link-desc' );
			$title = bp_activity_get_meta( $activity->id, 'yz-link-title' );

			// Get Default Image.
			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_activity_link' );
			}

		break;

		case 'activity_quote':

			$image = ! empty( $attachments ) ? wp_get_attachment_url( key( $attachments ) ): false;
			$description = bp_activity_get_meta( $activity->id, 'yz-quote-text' );
			$title = bp_activity_get_meta( $activity->id, 'yz-quote-owner' );

			// Get Default Image.
			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_activity_quote' );
			}

		break;

		case 'activity_video':

			foreach ( $attachments as $media_id => $data ) {

				$show_default = true;

	        	if ( $data['provider'] == 'local' ) {

	                if ( isset( $data['thumbnail'] ) && ! empty( $data['thumbnail'] ) ) {
	                    $image = wp_get_attachment_url( $media_id );
	                }

	        	} else {

	                if ( isset( $data['thumbnail']['large'] ) ) {
	                    $image = $data['thumbnail']['large'];
	                }

	                if ( empty( $thumbnail ) ) {
	                    $image = yz_get_embed_video_thumbnails( $data['provider'], $data['id'], 'large' );
	                }

	        	}

			}

        	if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_activity_video' );
        	}

		break;

		case 'activity_audio':
			$image = youzify_social_share_options( 'yzss_default_thumb_activity_audio' );
		break;

		case 'activity_file':
			$image = youzify_social_share_options( 'yzss_default_thumb_activity_file' );
		break;

		case 'activity_comment':
		case 'new_blog_comment':

			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_new_blog_comment' );
			}

		break;

		case 'new_blog_post':

			$blogs_ids = is_multisite() ? get_sites() : array( (object) array( 'blog_id' => 1 ) );

			foreach( $blogs_ids as $b ) {

		    	switch_to_blog( $b->blog_id );

			    // Get Post Data.
			    $post = get_post( $activity->secondary_item_id );

			    $title = $post->post_title;

			    $description = get_the_excerpt() ? get_the_excerpt() : youzify_ss_get_excerpt( $post->post_content, 40 );

		    	// Get Image ID.
				$img_id = get_post_thumbnail_id( $activity->secondary_item_id );

				// Get Image Url.
			    $image = wp_get_attachment_image_src( $img_id , 'large' );

			    restore_current_blog();

			    if ( $post ) {
			    	break;
			    }

			}

			// Get Permalink.
			$image = isset( $image[0] ) && !empty( $image[0] ) ? $image[0] : null;

			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_new_blog_post' );
			}

		break;

	}

	if ( empty( $description ) && ! empty( $activity->content ) ) {

		// Remove html tags.
		$description = wp_strip_all_tags( $activity->content );

		// Delete Slashes.
		$description = stripslashes_deep( $description );

		if ( empty( $description ) ) {
			$description = apply_filters( 'yzss_open_graph_default_description', $activity->action );
		}

	}

	if ( empty( $title ) ) {
		$title = yzss_open_graph_title( $activity );
	}

    // Get Open Graph Tags.
    youzify_ss_get_open_graph_tags( $type, $url, $title, $description, $image );

}

add_action( 'bp_head', 'youzify_social_share_get_wall_post_open_graph' );

/**
 * Get Open Graph Title.
 */
function yzss_open_graph_title( $activity ) {

	// Get User Display Name.
	$display_name = bp_core_get_user_displayname( $activity->user_id );

	// Get Default Action.
	$action = $display_name;

	// Get Post Action.
	switch ( $activity->type ) {

		case 'activity_status':
		case 'activity_update':
			$action = sprintf( __( '%1s added a new post', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_slideshow':
			$action = sprintf( __( '%1s posted a new slideshow', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_giphy':
			$action = sprintf( __( '%1s posted a new GIF', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_quote':
			$action = sprintf( __( '%1s posted a new quote', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_video':
			$action = sprintf( __( '%1s posted a new video', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_audio':
			$action = sprintf( __( '%1s posted a new audio', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_link':
			$action = sprintf( __( '%1s posted a new link', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_file':
			$action = sprintf( __( '%1s posted a new file', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_cover':
			$action = sprintf( __( '%1s uploaded a new profile cover', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_avatar':
			$action = sprintf( __( '%1s uploaded a new avatar', 'youzify-social-share' ), $display_name );
			break;

		case 'activity_photo':

			// Get Attachments.
			$attachments = bp_activity_get_meta( $activity->id, 'youzify_attachments' );

			if ( ! empty( $attachments ) ) {

				// Get Attchments Number.
				$photos_nbr = count( $attachments );

				$action = sprintf( _n( '%1$s posted a new photo', '%1$s posted %2$s new photos', $photos_nbr, 'youzify-social-share' ), $display_name, $photos_nbr );

			}

			break;

		}

		// $action = sprintf( '',  );
		// if ( $photos_nbr < 2 ) {

		// 	// Add Group Post Action.
		// 	if ( yz_wall_is_group_post( $activity ) ) {
		// 		$action = sprintf( __( '%1s posted', 'youzer' ), $user_link );
		// 	} else {
		// 		$action = $user_link;
		// 	}

		// } else {

		// 	// Get Action Label.
		// 	$action_label = sprintf( _n( 'a new photo', '%s new photos', $photos_nbr, 'youzer' ), $photos_nbr );

		// 	// Get Wall Post Action.
		// 	$action = sprintf( __( '%1s added <a href="%2s">%3s</a>', 'youzer' ), $user_link, $post_link, $action_label );

		// }

		// Add Group Description.
		// if ( yz_wall_is_group_post( $activity ) ) {
		// 	$action =  sprintf( __( '%1s posted', 'youzify-social-share' ), $user_link );
		// } else {
		// 	$action = $user_link;
		// }

		// Add Group Description.
		// $hide_group_description = array( 'joined_group', 'created_group' );
		// if (
		// 	bp_is_active( 'groups' ) && 'groups' == $activity->component && ! bp_is_groups_component() &&
		// 	! in_array( $activity->type, $hide_group_description ) ) {
		// 	$group = groups_get_group( $activity->item_id );
		// 	$action .= sprintf( __( ' in the group %1s', 'youzer' ), '<a href="' . bp_get_group_permalink( $group ) . '">' . esc_attr( $group->name ) . '</a>' );
		// }

		return apply_filters( 'yzss_get_og_title', $action );
}

/**
 * Get Default Activity Image.
 */
function yzss_get_default_activity_image( $activity ) {

	$image = '';

    // Get User Media.
    $attachments = class_exists( 'Youzify' ) ? bp_activity_get_meta( $activity->id, 'youzify_attachments' ) : '';

	switch ( $activity->type ) {

		case 'activity_update':
			$image = yzss_get_buddyboss_image( $activity );
			break;

		case 'new_avatar':
		case 'new_cover':
		case 'activity_quote':
		case 'activity_link':
		case 'activity_slideshow':
		case 'activity_photo':

			if ( ! empty( $attachments ) ) {
				$image = wp_get_attachment_url( key( $attachments ) );
			}

		break;

        case 'activity_status':

			// Get Url Data.
			$url_data = bp_activity_get_meta( $activity->id, 'url_preview' );

			if ( ! empty( $url_data ) ) {

				// Unserialize data.
				$url_data = is_serialized( $url_data ) ? unserialize( $url_data ) : maybe_unserialize( base64_decode( $url_data ) );

				if ( isset( $url_data['image'] ) && ! empty( $url_data['image'] ) ) {
					$image = $url_data['image'];
				}

			}

		break;

        case 'friendship_accepted':
        case 'friendship_created':
			$image = youzify_social_share_options( 'yzss_default_thumb_friendship' );
		break;

		case 'activity_giphy':
			$image = bp_activity_get_meta( $activity->id, 'giphy_image' );
			break;

		case 'activity_video':

			if ( ! empty( $attachments ) ) {

				foreach ( $attachments as $media_id => $data ) {

					$show_default = true;

		        	if ( $data['provider'] == 'local' ) {

		                $data = array();

		                if ( isset( $data['thumbnail'] ) && ! empty( $data['thumbnail'] ) ) {
		                    $image = wp_get_attachment_url( $media_id );
		                }

		        	} else {

		                if ( isset( $data['thumbnail']['large'] ) ) {
		                    $image = $data['thumbnail']['large'];
		                }

		                if ( empty( $thumbnail ) ) {
		                    $image = youzify_get_embed_video_thumbnails( $data['provider'], $data['id'], 'large' );
		                }

		        	}
		        }
			}

		break;

		case 'new_blog_post':

			$blogs_ids = is_multisite() ? get_sites() : array( (object) array( 'blog_id' => 1 ) );

			foreach ( $blogs_ids as $b ) {

		    	switch_to_blog( $b->blog_id );

			    // Get Post Data.
			    $post = get_post( $activity->secondary_item_id );

			    $title = $post->post_title;

			    $description = get_the_excerpt() ? get_the_excerpt() : youzify_ss_get_excerpt( $post->post_content, 40 );

		    	// Get Image ID.
				$img_id = get_post_thumbnail_id( $activity->secondary_item_id );

				// Get Image Url.
			    $image = wp_get_attachment_image_src( $img_id , 'large' );

			    restore_current_blog();

			    if ( $post ) {
			    	break;
			    }
			}

			// Get Permalink.
			$image = isset( $image[0] ) && ! empty( $image[0] ) ? $image[0] : null;

			if ( empty( $image ) ) {
				$image = youzify_social_share_options( 'yzss_default_thumb_new_blog_post' );
			}

		break;

	}

	if ( empty( $image ) ) {
		$image = youzify_social_share_options( 'yzss_default_thumb_' . $activity->type );
	}

	return $image;
}

/**
 * Get Default Activity Image.
 */
function yzss_get_activity_description( $activity ) {

	// Get Content.
	$description = $activity->content;

	switch ( $activity->type ) {

		case 'activity_status':

			// Get Url Data.
			$url_data = bp_activity_get_meta( $activity->id, 'url_preview' );

			if ( ! empty( $url_data ) ) {

				// Unserialize data.
				$url_data = is_serialized( $url_data ) ? unserialize( $url_data ) : maybe_unserialize( base64_decode( $url_data ) );

				if ( empty( $activity->content) && isset( $url_data['description'] ) && ! empty( $url_data['description'] ) ) {
					$description = $url_data['description'];
				}

			}
			break;

		case 'activity_link':
			$description = bp_activity_get_meta( $activity->id, 'yz-link-desc' );

			if ( empty( $description ) ) {
				$description = bp_activity_get_meta( $activity->id, 'yz-link-title' );
			}

		break;

		case 'activity_quote':
			$description = bp_activity_get_meta( $activity->id, 'yz-quote-text' );
		break;

	}

	if ( empty( $description ) ) {
		$description = $activity->action;
	}

	// Remove html tags.
	$description = stripslashes_deep( wp_strip_all_tags( $description, true ) );

	return $description;
}

/**
 * Set Profile Default Thumbnail.
 */
function yzss_set_og_profile_default_thumbnail( $profile_avatar = null ) {

    // Get Profile Photo.
    $default_thumb = youzify_social_share_options( 'yzss_default_thumb_profile' );

    if ( ! empty( $default_thumb ) ) {
        return $default_thumb;
    }

    return $profile_avatar;
}

add_filter( 'youzify_og_profile_default_thumbnail', 'yzss_set_og_profile_default_thumbnail' );

/**
 * Set Group Default Thumbnail.
 */
function yzss_set_og_group_default_thumbnail( $group_avatar = null ) {

    // Get Profile Photo.
    $default_thumb = youzify_social_share_options( 'yzss_default_thumb_group' );

    if ( ! empty( $default_thumb ) ) {
        return $default_thumb;
    }

    return $group_avatar;
}

add_filter( 'youzify_og_group_default_thumbnail', 'yzss_set_og_group_default_thumbnail' );


/**
 * Get Posts Excerpt.
 */
function youzify_ss_get_excerpt( $content, $limit = 12 ) {

    $limit = apply_filters( 'youzify_excerpt_limit', $limit );

    // Strip Shortcodes
    $excerpt = do_shortcode( $content );

    // Strip Remaining shortcodes.
    $excerpt = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $excerpt );

    // Strip Tag.
    $excerpt = wp_strip_all_tags( $excerpt );

    $excerpt = explode( ' ', $excerpt, $limit );

    if ( count( $excerpt ) >= $limit ) {
        array_pop( $excerpt );
        $excerpt = implode( " ", $excerpt ) . '...';
    } else {
        $excerpt = implode( " ", $excerpt );
    }

    $excerpt = preg_replace( '`\[[^\]]*\]`', '', $excerpt );

    return apply_filters( 'youzify_get_excerpt', $excerpt, $content, $limit );
}

/**
 * Add Groups Open Graph Support.
 */

function youzify_social_share_groups_open_graph() {

    if ( ! bp_is_group() ) {
        return false;
    }

   	global $bp;

   	// Get Current Group Data.
	$group = $bp->groups->current_group;

    // Get Group Cover Image
    $group_img = bp_attachments_get_attachment(
    	'url', array( 'item_id' => $group->id, 'object_dir' => 'groups' )
    );

    // Get Avatar if Cover Not found.
    if ( empty( $group_img ) ) {
        $group_avatar = bp_core_fetch_avatar( array(
			'avatar_dir' => 'group-avatars',
			'item_id'    => $group->id,
			'object' 	 => 'group',
			'type'	  	 => 'full',
			'html' 	  	 => false
			)
		);

        $group_img = apply_filters( 'youzify_og_group_default_thumbnail', $group_avatar );

    }

    // Get Group Link.
    $url = bp_get_group_permalink( $group );

    // Get Group Description.
    $group_description = esc_html( $group->description );

    youzify_ss_get_open_graph_tags( 'profile', $url, $group->name, $group_description, $group_img );

}

/**
 * Add Profile
 */
function youzify_social_share_add_profile_open_graph() {

    if ( bp_is_single_activity() ) {
        return false;
    }

    // Get Displayed Profile user id.
    $user_id = bp_displayed_user_id();

    // Get Username
    $user_name = bp_core_get_user_displayname( $user_id );

    // Get User Cover Image
    $user_image = apply_filters( 'youzify_og_profile_cover_image', bp_attachments_get_attachment( 'url', array( 'object_dir' => 'members', 'item_id' => $user_id ) ) );

    // Get Avatar if Cover Not found.
    if ( empty( $user_image ) ) {
        $user_image = apply_filters( 'youzify_og_profile_default_thumbnail', null );
    }

    // Get User Description.
    $user_desc = get_the_author_meta( 'description', $user_id );

    // Get Page Url!
    $url = bp_core_get_user_domain( $user_id );

    // if description empty get about me description.
    if ( empty( $user_desc ) ) {
        $user_desc = get_the_author_meta( 'youzify_wg_about_me_bio', $user_id );
    }

    youzify_ss_get_open_graph_tags( 'profile', $url, $user_name, $user_desc, $user_image );

}

/**
 * Get BuddyBoss Media
 */
function yzss_get_buddyboss_image( $activity ) {

    if ( ! defined( 'BP_PLATFORM_VERSION' ) || ! bp_is_active( 'media' ) ) {
        return;
    }

    $image = '';

    // Get Activity Media.
    $media_ids = bp_activity_get_meta( $activity->id, 'bp_media_ids', true );

    if ( ! empty( $media_ids )  ) {

    	$media_ids = explode( ',', $media_ids );

    	$media = BP_Media::get( array( 'in' => $media_ids[0] ) );

    	if ( ! empty( $media ) ) {
    		$image = wp_get_attachment_url( $media['medias'][0]->attachment_id );
    	}

    }

    if ( empty( $image ) ) {

        $document_ids = bp_activity_get_meta( $activity->id, 'bp_document_ids', true );

        if ( ! empty( $document_ids ) ) {

        	$document_ids = explode( ',', $document_ids );

        	if ( bp_has_document( array( 'include'  => $document_ids, 'order_by' => 'menu_order', 'sort' => 'ASC' ) ) ) {

	            while ( bp_document() ) {

	                bp_the_document();

	                // Get Data.
	                $attachment_id = bp_get_document_attachment_id();
	                $extension  = bp_document_extension( $attachment_id );

	                if ( in_array( $extension, bp_get_document_preview_music_extensions(), true ) ) {
	                	$image = youzify_social_share_options( 'yzss_default_thumb_activity_audio' );
	                }


	                if ( empty( $image ) ) {
	                    $image = youzify_social_share_options( 'yzss_default_thumb_activity_file' );
	                }

	            }

        	}
        }


    }

    if ( empty( $image ) & bp_is_messages_gif_support_enabled() ) {

		$gif_data = bp_activity_get_meta( $activity->id, '_gif_data', true );

        if ( ! empty( $gif_data ) ) {
        	$image = $gif_data['still'];
        }

    }

    return $image;
}
