<?php
/**
 * Plugin Name: Youzify - BuddyPress Social Share
 * Plugin URI:  https://youzify.com
 * Description: Allow users and visitors to share activities, profiles and groups and allow your content to reach a wider audience and gain more exposure for your brand.
 * Version:     2.0.0
 * Author:      Youssef Kaine
 * Author URI:  https://www.kainelabs.com
 * License:     GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: youzify-social-share
 * Domain Path: /languages/
 */
if ( ! defined( 'WPINC' ) ) {
    die;
}

if ( ! class_exists( 'BuddyPress' ) ) {
    add_action( 'admin_notices', function() {
        echo '<div class="error"><p><strong>' . sprintf( esc_html__( 'Youzify - BuddyPress Social Share requires BuddyPress to be installed and active. You can download %s here.', 'youzify-social-share' ), '<a href="https://wordpress.org/plugins/buddypress/" target="_blank">BuddyPress</a>' ) . '</strong></p></div>';
    } );
    return;
}

// Version.
define( 'YZSS_VERSION', '2.0.0' );

// File
define( 'YZSS_FILE', __FILE__ );

// Basename
define( 'YZSS_BASENAME', plugin_basename( __FILE__ ) );

// Path.
define( 'YZ_SOCIAL_SHARE_PATH', plugin_dir_path( __FILE__ ) );
define( 'YZ_SOCIAL_SHARE_URL', plugin_dir_url( __FILE__ ) );

/**
 * Init Functions
 */
add_action( 'plugins_loaded', 'youzify_social_share_init', 15 );

function youzify_social_share_init() {

    if ( ! apply_filters( 'yzss_is_social_share_active', true ) ) {
        return;
    }

    // Include Files.
    include YZ_SOCIAL_SHARE_PATH . 'youzify-general-functions.php';
    include YZ_SOCIAL_SHARE_PATH . 'youzify-open-graph-functions.php';

    if ( is_user_logged_in() || yzss_allow_nonloggedin_users_to_share() ) {

        // Add Body Class Filter.
        add_filter( 'body_class','yzss_social_share_body_class' );

        if ( class_exists( 'Youzify' ) ) {
            include YZ_SOCIAL_SHARE_PATH . 'functions/youzify-functions.php';
        } else {

            // Add BuddyPress Css.
            add_action( 'wp_head', 'yzss_add_buddypress_css' );

            // Add Profile And Groups Open Graph.
            add_action( 'wp_head', 'youzify_social_share_groups_open_graph' );
            add_action( 'wp_head', 'youzify_social_share_add_profile_open_graph' );

            // Call BuddyPress
            if ( bp_get_theme_package_id() == 'legacy' ) {
                include YZ_SOCIAL_SHARE_PATH . 'functions/youzify-legacy-functions.php';
            } else {
                include YZ_SOCIAL_SHARE_PATH . 'functions/youzify-nouveau-functions.php';
            }

        }

    }

    // Init Admin
    if ( is_admin() ) {

        if ( ! class_exists( 'Youzify_Admin' ) ) {
            include YZ_SOCIAL_SHARE_PATH . 'admin/panel/youzify-admin.php';
        }

        require YZ_SOCIAL_SHARE_PATH . 'admin/class-social-share-admin.php';

    }

    // Load Text Domain
    load_plugin_textdomain( 'youzify-social-share', FALSE, dirname( YZSS_BASENAME ) . '/languages' );
}

/**
 * Custom CSS.
 */
function yzss_add_buddypress_css() { ?>

    <style type="text/css">

    .youzify-social-share-activity.youzify-loading-share-btns .youzify-spinner,
    .youzify-social-share-group.loading .youzify-spinner,
    .youzify-social-share-user.loading .youzify-spinner {
        display: inline-block !important;
        vertical-align: middle;
    }

    .bp-user .youzify-spinner,
    .youzify-spinner {
      width: 16px;
      height: 16px;
      margin-right: 5px;
      position: relative;
      vertical-align: middle;
      display: none !important;
    }

    .youzify-spinner:after {
        content: " ";
        display: block;
        top: -4px;
        width: 15px;
        height: 15px;
        margin: 4px 0 0 0;
        border-radius: 50%;
        border: 2px dotted #a9a9a9;
        position: absolute;
        animation: youzify-loader-icon 2s linear infinite;
    }

    .youzify-modal-button .youzify-spinner:after {
        border: 2px dotted #fff;
        margin-right: 12px;
    }

    @keyframes youzify-loader-icon {
      0% {
        transform: rotate(0deg);
      }
      100% {
        transform: rotate(360deg);
      }
    }

    </style>
    <?php

}
