<?php

/**
 * Author : DeipGroup
 * Date: 8/11/2016
 * Time: 4:15 PM
 *
 * @package dflip
 *
 * @since   dflip 1.2
 */
class DFlip_Settings {
  
  /**
   * Holds the singleton class object.
   *
   * @since 1.2.0
   *
   * @var object
   */
  public static $instance;
  
  public $hook;
  
  /**
   * Holds the base DFlip class object.
   *
   * @since 1.2.0
   *
   * @var object
   */
  public $base;
  
  /**
   * Holds the base DFlip class fields.
   *
   * @since 1.2.0
   *
   * @var object
   */
  public $fields;
  
  /**
   * Primary class constructor.
   *
   * @since 1.2.0
   */
  public function __construct() {
    
    // Load the base class object.
    $this->base = DFlip::get_instance();
    
    add_action( 'admin_menu', array( $this, 'settings_menu' ) );
    
    $this->fields = array_merge( array(), $this->base->defaults );
    
    foreach ( $this->fields as $key => $value ) {
      
      if ( isset( $value['choices'] ) && is_array( $value['choices'] ) && isset( $value['choices']['global'] ) ) {
        unset( $this->fields[ $key ]['choices']['global'] );
      }
      
    }
    
    // Load the metabox hooks and filters.
    //		add_action('add_meta_boxes', array($this, 'add_meta_boxes'), 100);
    
    // Add action to save metabox config options.
    //		add_action('save_post', array($this, 'save_meta_boxes'), 10, 2);
  }
  
  /**
   * Creates menu for the settings page
   *
   * @since 1.2
   */
  public function settings_menu() {
    
    $this->hook = add_submenu_page( 'edit.php?post_type=dflip', __( 'dFlip Global Settings', 'DFLIP' ), __( 'Global Settings', 'DFLIP' ), 'manage_options', $this->base->plugin_slug . '-settings',
        array( $this, 'settings_page' ) );
    
    //The resulting page's hook_suffix, or false if the user does not have the capability required.
    if ( $this->hook ) {
      add_action( 'load-' . $this->hook, array( $this, 'update_settings' ) );
      // Load metabox assets.
      add_action( 'load-' . $this->hook, array( $this, 'hook_page_assets' ) );
    }
  }
  
  /**
   * Callback to create the settings page
   *
   * @since 1.2
   */
  public function settings_page() {
    
    $tabs = array(
        'general'   => __( 'General', 'DFLIP' ),
        'layout'    => __( 'Layout', 'DFLIP' ),
        'controls'  => __( 'Controls', 'DFLIP' ),
        'flipbook'  => __( 'Flipbook', 'DFLIP' ),
        'popup'     => __( 'Popup/LightBox', 'DFLIP' ),
        'pdf'       => __( 'PDF', 'DFLIP' ),
        'advanced'  => __( 'Advanced', 'DFLIP' ),
        //        'post'      => __( 'Posts/ShortCode', 'DFLIP' ),
        'translate' => __( 'Translate', 'DFLIP' ),
        //			'controls'  => __( 'Controls' , 'DFLIP' )
    );
    
    //create tabs and content
    ?>

      <h2><?php echo esc_html( get_admin_page_title() ); ?></h2>
      <form id="dflip-settings" method="post" class="dflip-settings postbox">
        
        <?php
        wp_nonce_field( 'dflip_settings_nonce', 'dflip_settings_nonce' );
        submit_button( __( 'Update Settings', 'DFLIP' ), 'primary', 'dflip_settings_submit', false );
        ?>

          <div class="dflip-tabs">
              <ul class="dflip-tabs-list">
                <?php
                //create tabs
                $active_set = false;
                foreach ( (array) $tabs as $id => $title ) {
                  ?>
                    <li class="dflip-update-hash dflip-tab <?php echo( $active_set == false ? 'dflip-active' : '' ) ?>">
                        <a href="#dflip-tab-content-<?php echo $id ?>"><?php echo $title ?></a></li>
                  <?php $active_set = true;
                }
                ?>
              </ul>
            <?php
            
            $active_set = false;
            foreach ( (array) $tabs as $id => $title ) {
              ?>
                <div id="dflip-tab-content-<?php echo $id ?>"
                     class="dflip-tab-content <?php echo( $active_set == false ? "dflip-active" : "" ) ?>">
                  
                  <?php
                  $active_set = true;
                  
                  //create content for tab
                  $function = $id . "_tab";
                  if ( method_exists( $this, $function ) ) {
                    call_user_func( array( $this, $function ) );
                  };
                  
                  ?>
                </div>
            <?php } ?>
          </div>
      </form>
    <?php
    
  }
  
  public function hook_page_assets() {
    add_action( 'admin_enqueue_scripts', array( $this, 'meta_box_styles_scripts' ) );
  }
  
  /**
   * Loads styles and scripts for our metaboxes.
   *
   * @return null Bail out if not on the proper screen.
   * @since 1.0.0
   *
   */
  public function meta_box_styles_scripts() {
    
    
    // Load necessary metabox styles.
    wp_register_style( $this->base->plugin_slug . '-setting-metabox-style', plugins_url( '../assets/css/metaboxes.css', __FILE__ ), array(), $this->base->version );
    wp_enqueue_style( $this->base->plugin_slug . '-setting-metabox-style' );
    wp_enqueue_style( 'wp-color-picker' );
    
    // Load necessary metabox scripts.
    wp_register_script( $this->base->plugin_slug . '-setting-metabox-script', plugins_url( '../assets/js/metaboxes.js', __FILE__ ), array( 'jquery', 'jquery-ui-tabs', 'wp-color-picker' ),
        $this->base->version );
    wp_enqueue_script( $this->base->plugin_slug . '-setting-metabox-script' );
    
    wp_enqueue_media();
    
  }
  
  /**
   * Creates the UI for General tab
   *
   * @since 1.0.0
   *
   */
  public function general_tab() {
    
    $this->base->create_setting( 'viewerType' );
    $this->base->create_setting( 'mobileViewerType' );
    
    $this->base->create_separator( 'Page Size / Zoom' );
    $this->base->create_setting( 'texture_size' );
    $this->base->create_setting( 'zoom_ratio' );
    
    $this->base->create_separator( 'Page Links' );
    $this->base->create_setting( 'linkColor' );
    $this->base->create_setting( 'linkColorOpacity' );
    $this->base->create_setting( 'linkColorHover' );
    $this->base->create_setting( 'linkColorHoverOpacity' );
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  public function layout_tab() {
    
    $this->base->create_setting( 'padding_top' );
    $this->base->create_setting( 'padding_bottom' );
    $this->base->create_setting( 'padding_left' );
    $this->base->create_setting( 'padding_right' );
    $this->base->create_setting( 'height' );
    $this->base->create_setting( 'sideMenuOverlay' );
    
    $this->base->create_setting( 'bg_color' );
    $this->base->create_setting( 'bg_image' );
    
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  public function post_tab() {
    
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  
  public function flipbook_tab() {
    
    unset( $this->base->defaults['webgl']['condition'] );
    $this->base->create_setting( 'webgl' );
    unset( $this->base->defaults['hard']['condition'] );
    $this->base->create_setting( 'hard' );
    
    unset( $this->base->defaults['duration']['condition'] );
    $this->base->create_setting( 'duration' );
    $this->base->create_setting( 'page_mode' );
    $this->base->create_setting( 'single_page_mode' );
    unset( $this->base->defaults['direction']['condition'] );
    $this->base->create_setting( 'direction' );
    
    $this->base->create_separator( '3D Settings' );
    $this->base->create_setting( 'hasSpiral' );
    $this->base->create_setting( 'spiralColor' );
    $this->base->create_setting( 'cover3DType' );
    $this->base->create_setting( 'color3DCover' );
    $this->base->create_setting( 'color3DSheets' );
    $this->base->create_setting( 'flexibility' );
    $this->base->create_setting( 'flipbook3DTiltAngleUp' );
    $this->base->create_setting( 'flipbook3DTiltAngleLeft' );
    
    
    $this->base->create_separator( 'Misc' );
    $this->base->create_setting( 'autoplay' );
    $this->base->create_setting( 'autoplay_duration' );
    $this->base->create_setting( 'autoplay_start' );
    $this->base->create_setting( '2dFlipbookMidShadowOpacity' );
    $this->base->create_setting( 'scroll_wheel' );
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  
  /**
   * Creates the UI for Popup tab
   *
   * @since 2.1.23
   *
   */
  public function popup_tab() {
    
    $this->base->create_setting( 'buttonClass' );
    $this->base->create_setting( 'targetWindow' );
    
    $this->base->create_separator( 'Thumb Popup' );
    $this->base->create_setting( 'popupThumbPlaceholder' );
    $this->base->create_setting( 'thumbLayout' );
    
    $this->base->create_setting( 'displayLightboxPlayIcon' );
    $this->base->create_setting( 'lightboxPlayIconBGColor' );
    $this->base->create_setting( 'lightboxPlayIconColor' );
    
    $this->base->create_separator( 'Lightbox Settings' );
    $this->base->create_setting( 'popupBackGroundColor' );
    $this->base->create_setting( 'popupBackgroundColorOpacity' );
    
    $this->base->create_separator( 'Book Shelf Settings' );
    $this->base->create_setting( 'shelfImage' );
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  
  /**
   * Creates the UI for Controls tab
   *
   * @since 2.1.40
   *
   */
  public function controls_tab() {
    
    unset( $this->base->defaults['auto_sound']['condition'] );
    $this->base->create_setting( 'auto_sound' );
    unset( $this->base->defaults['enable_download']['condition'] );
    unset( $this->base->defaults['enable_search']['condition'] );
    unset( $this->base->defaults['enable_print']['condition'] );
    $this->base->create_setting( 'enable_download' );
    $this->base->create_setting( 'enable_search' );
    $this->base->create_setting( 'enable_print' );
    $this->base->create_setting( 'controls_position' );
    $this->base->create_setting( 'controlsFloating' );
    $this->base->create_setting( 'more_controls' );
    $this->base->create_setting( 'hide_controls' );
    //    $this->base->create_setting( 'leftControls' );
    //    $this->base->create_setting( 'rightControls' );
    $this->base->create_setting( 'hideShareControls' );
    
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  /**
   * Creates the UI for Advanced tab
   *
   * @since 2.1.23
   *
   */
  public function advanced_tab() {
    
    $this->base->create_setting( 'share_prefix' );
    $this->base->create_setting( 'share_slug' );
    $this->base->create_setting( 'enable_analytics' );
    
    $this->base->create_separator( 'Posts/Shortcode' );
    $this->base->create_setting( 'enablePostPages' );
    $this->base->create_setting( 'attachment_lightbox' );
    $this->base->create_setting( 'multiplePostLimit' );
    $this->base->create_setting( 'selectiveScriptLoading' );
    $this->base->create_setting( 'autoPDFLinktoViewer' );
    
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  /**
   * Creates the UI for PDF tab
   *
   * @since 2.1.23
   *
   */
  public function pdf_tab() {
    
    $this->base->create_setting( 'disable_range' );
    $this->base->create_setting( 'range_size' );
//    $this->base->create_setting( 'canvasWillReadFrequently' );
    $this->base->create_setting( 'pdf_version' );
    $this->base->create_setting( 'link_target' );
    $this->base->create_setting( 'enableAutoLinks' );
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    
    <?php
  }
  
  /**
   * Creates the UI for Translate tab
   *
   * @since 1.0.0
   *
   */
  public function translate_tab() {
    
    $this->base->create_setting( 'external_translate' );
    $this->base->create_setting( 'text_open_book' );
    $this->base->create_setting( 'text_loading' );
    $this->base->create_setting( 'text_toggle_sound' );
    $this->base->create_setting( 'text_toggle_thumbnails' );
    $this->base->create_setting( 'text_toggle_outline' );
    $this->base->create_setting( 'text_previous_page' );
    $this->base->create_setting( 'text_next_page' );
    $this->base->create_setting( 'text_toggle_fullscreen' );
    $this->base->create_setting( 'text_zoom_in' );
    $this->base->create_setting( 'text_zoom_out' );
    $this->base->create_setting( 'text_toggle_help' );
    $this->base->create_setting( 'text_single_page_mode' );
    $this->base->create_setting( 'text_double_page_mode' );
    $this->base->create_setting( 'text_download_PDF_file' );
    $this->base->create_setting( 'text_goto_first_page' );
    $this->base->create_setting( 'text_goto_last_page' );
    $this->base->create_setting( 'text_share' );
    $this->base->create_setting( 'text_mail_subject' );
    $this->base->create_setting( 'text_mail_body' );
    ?>

      <!--Clear-fix-->
      <div class="dflip-box"></div>
    <?php
    
  }
  
  /**
   * Update settings
   *
   * @return null Invalid nonce / no need to save
   * @since 1.2.0.1
   *
   */
  public function update_settings() {
    
    // Check form was submitted
    if ( !isset( $_POST['dflip_settings_submit'] ) ) {
      return;
    }
    
    // Check nonce is valid
    if ( !wp_verify_nonce( $_POST['dflip_settings_nonce'], 'dflip_settings_nonce' ) ) {
      return;
    }
    
    $data = $_POST['_dflip'];
    
    if ( is_multisite() ) {
      // Update options
      update_blog_option( null, '_dflip_settings', $data );
    } else {
      // Update options
      update_option( '_dflip_settings', $data );
    }
    // Show confirmation
    add_action( 'admin_notices', array( $this, 'updated_settings' ) );
    
  }
  
  /**
   * display a saved notice
   *
   * @since 1.2.0.1
   */
  public function updated_settings() {
    ?>
      <div class="updated">
          <p><?php _e( 'Settings updated.', 'DFLIP' ); ?></p>
      </div>
    <?php
    
  }
  
  /**
   * Returns the singleton instance of the class.
   *
   * @return object DFlip_Settings object.
   * @since 1.2.0
   *
   */
  public static function get_instance() {
    
    if ( !isset( self::$instance )
        && !( self::$instance instanceof DFlip_Settings ) ) {
      self::$instance = new DFlip_Settings();
    }
    
    return self::$instance;
    
  }
}

// Load the DFlip_Settings class.
$dflip_settings = DFlip_Settings::get_instance();
