<?php

/**
 * Plugin Name:       Winter Feeding Rations and Estimated Costs
 * Plugin URI:        https://www.nonfiction.ca/
 * Description:       Use shortcode [Winter_Feeding_Rations]  to render calculator in your Wordpress post/page
 * Version:           2.2
 * Author:            Paul Dinh
 * Author URI:        https://www.nonfiction.ca/
 */
// If this file is called directly, abort.
if (!defined('WPINC')) {
    die;
}
function general_calcs_enqueue_script()
{
    wp_enqueue_script('General_calcs_scripts', 'https://cdn.jsdelivr.net/combine/npm/vue@2.6.14/dist/vue.min.js,npm/accounting-js@1.1.1,npm/vue@2.5.16,npm/vue-numeric@2.3.0,npm/@vue/composition-api@1.4.3,npm/echarts@5.2.2,npm/vue-echarts@6.0.2', array(), false, true);
    $t = time();
    $t -= $t % 60;
    wp_enqueue_script('General_calcs_script', plugins_url('script.js', __FILE__), array('General_calcs_scripts', 'jquery'), $t, true);
    wp_enqueue_style('General_calcs_styles', plugin_dir_url(__FILE__) . 'bootstrap-iso.min.css', array(), 'v1', 'all');
    wp_enqueue_style('General_calcs_style', plugin_dir_url(__FILE__) . 'style.css', array('General_calcs_styles'), 'v1', 'all');
}
function general_calcs_demo($atts, $content = null)
{
    ob_start();
    include('shortcode_General_Calc.php');
    return ob_get_clean();
}  function general_calcs_cart_home($atts, $content = null)
{
    ob_start();
    include('shortcode_General_Calc.php');
    return ob_get_clean();
}
if (!function_exists('General_calcs')) {

    add_action('plugins_loaded', function () {
        add_action('wp_enqueue_scripts', 'general_calcs_enqueue_script', 25);
        add_shortcode('Winter_Feeding_Rations', 'General_calcs_cart_tugger');
        add_shortcode('PALLET_MOVER', 'General_calcs_pallet_mover');
    });
    function General_calcs_cart_tugger($atts, $content = null)
    {
        ob_start();
        include('shortcode_General_Calc.php');
        return ob_get_clean();
    }
    function General_calcs_pallet_mover($atts, $content = null)
    {
        ob_start();
        include('shortcode_pallet_mover.php');
        return ob_get_clean();
    }
}

