<?php 
	if ( ! defined( 'ABSPATH' ) ) exit;

  $crud     = new RealtyPress_DDF_CRUD( date('Y-m-d') );
  $listings = new RealtyPress_Listings();

  $property = $template_args['property'];
  ?>

<div class="row" style="margin-top:15px;padding-bottom:8px;">
    <div class="col-sm-3">
        
        <!-- Realtor.ca Powered by Badge -->
        <a href="https://www.realtor.ca/en" rel="nofollow" alt="Powered by: REALTOR.ca" target="_blank"><img width="125" src="https://www.realtor.ca/images/en-ca/powered_by_realtor.svg"/></a>

        <!-- Realtor.ca required statement of listing content ownership and licensing -->
        <div style="padding-top:15px;">This <a href="<?php echo $property['common']['MoreInformationLink']; ?>" rel="nofollow" target="_blank">REALTOR.ca</a> listing content is owned and licensed by REALTOR® members of The <a href="https://crea.ca" rel="nofollow" target="_blank">Canadian Real Estate Association</a></div>

    </div>
    <div class="col-sm-9">

        <!-- Required trademarks -->
        <p>The trademarks REALTOR&reg;, REALTORS®, and the REALTOR&reg; logo are controlled by The Canadian Real Estate Association (CREA) and identify real estate professionals who are members of CREA. The trademarks MLS&reg;, Multiple Listing Service&reg; and the associated logos are owned by The Canadian Real Estate Association (CREA) and identify the quality of services provided by real estate professionals who are members of CREA. The trademark DDF&reg; is owned by The Canadian Real Estate Association (CREA) and identifies CREA's Data Distribution Facility (DDF&reg;)</p>

        <div class="rps-listing-stats pt-0">

            <div class="row">
                <div class="col-sm-3 col-xs-12">
                    
                    <!-- Listing Board -->
                    <?php $listing_board = $listings->get_listing_board( $property['private']['Board'] ); ?>
                    <label>Data Provider</label><br>
                    <?php echo $listing_board['LongName'] ?><br>


                </div>
                <div class="col-sm-3 col-xs-12">

                    <!-- Listing Office -->
                    <?php
                    if( !empty( $property['property-agent'] ) ) {
                    
                        // Create comma separated string of agent
                        $offices = array();
                    
                        foreach( $property['property-agent'] as $agent_id => $values ) {
                            $office = $crud->get_local_listing_office( $values['OfficeID'] );
                            if ( !empty( $office['Name'] ) ) {
                                $offices[] = rps_fix_case( $office['Name'] );
                            }
                        }
                        $offices = array_unique($offices);
                        $offices = implode(', ', $offices);
                        ?>

                        <label>Listing Office</label><br>
                        <?php echo rps_fix_case( $offices ); ?><br>
                    <?php } ?>

                </div><!-- /.col-sm-9 -->
                <div class="col-sm-3 col-xs-12">
                    
                    <!-- Listing Last Updated -->
                    <label>Listing Updated</label><br>
                    <?php echo date('F d Y h:i:s', strtotime( $property['common']['LastUpdated'] ) ); ?><br>

                </div>
                <div class="col-sm-3 col-xs-12 text-right">

                    <!-- Required MLS & REALTOR logos -->
                    <img src="<?php echo REALTYPRESS_IMAGE_URL ?>/mls-realtor-logos.png">

                </div>
            </div><!-- /.row -->
            
        </div>
    </div>
</div><!-- /.row -->