<?php
if ( ! defined('ABSPATH'))
    exit;

    $property      = $template_args['property'];
    $shortcode     = $template_args['shortcode'];
    $missing_image = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
    
    $ddf_cdn = get_option('rps-system-options-enable-ddf-cdn', 0);

?>
<!-- Property Images -->
<div class="row rps-property-photo-row">
    
    <?php if (empty($shortcode['view']) && get_option('rps-single-page-layout', 'page-sidebar-right') == 'page-sidebar-left' ||
        ! empty($shortcode['view']) && $shortcode['view'] == 'sidebar-left') { ?>

        <!-- ============ -->
        <!-- Sidebar Left -->
        <!-- ============ -->

        <div class="col-md-3">

            <div class="bx-pager-wrap clearfix">
                <ul class="bx-pager">

                    <?php
                    if ( ! empty($property['property-photos'][0]['Photos'])) {

                        $i = 0;
                        foreach ($property['property-photos'] as $img) {
                            
                            $photos = json_decode($img['Photos'], true);

                            foreach ($photos as $size => $values) {

                                $use_large = get_option('rps-system-options-download-medium-photos', 0);
                                if (($use_large == 1 && $size == 'LargePhoto') || ($use_large == 0 && $size == 'Photo')) {

                                    $id          = $values['id'];
                                    $filename    = $values['filename'];
                                    $sequence_id = $values['sequence_id'] - 1;
    
                                    if ($ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
                                        $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $id . '/' . $filename;
                                    }
                                    elseif ($ddf_cdn == true) {
                                        $img = $filename;
                                    }

	                                if ( ( rps_use_amazon_s3_storage() == true || rps_use_lw_object_storage() == true ) && $ddf_cdn == false ) {
                                        if ( ! rps_remote_file_exists($img)) {
                                            $img = $missing_image;
                                        }
                                    }
                                    
                                    echo '<li class="slide">';
                                        if ($use_large == 1 && $size == 'LargePhoto') {
                                            echo '<a data-slide-index="' . $i . '" href="" rel="nofollow" style="display:block;width:100%;background:url(' . $img . ') no-repeat center !important;background-size:contain !important;">';
                                            echo '<img src="' . REALTYPRESS_PUBLIC_URL . '/img/trans-256x200.png">';
                                            echo '</a>';
                                        }
                                        elseif ($use_large == 0 && $size == 'Photo') {
                                            echo '<a data-slide-index="' . $i . '" href="" rel="nofollow">';
                                            echo '<img src="' . $img . '" onerror="if (this.src != \'' . $missing_image . '\') this.src = \'' . $missing_image . '\';">';
                                            echo '</a>';
                                        }
                                    echo '</li>';
                                    
                                    $i ++;
                                }
                                
                            }
                            
                        }
                    }
                    else {
                        $photo = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
                        echo '<li class="slide">';
                        echo '<a data-slide-index="0"  href="0">';
                        echo '<img src="' . $photo . '">';
                        echo '</a>';
                        echo '</li>';
                    }
                    ?>
                </ul><!-- /.bx-pager -->
            </div><!-- ./bx-thumbnails -->

        </div><!-- /.col-md-3 -->
    <?php } ?>
    
    <?php
    if (empty($shortcode['view']) && get_option('rps-single-page-layout', 'page-sidebar-right') == 'page-full-width' ||
        ! empty($shortcode['view']) && $shortcode['view'] == 'full-width') {
        echo '<div class="col-md-12">';
    }
    else {
        echo '<div class="col-md-9 col-xs-12">';
    }
    ?>
    <div class="bx-wrapper">
        <ul class="bx-slider" style="visibility:hidden;">
            <?php
            if ( ! empty($property['property-photos'][0]['Photos'])) {
                foreach ($property['property-photos'] as $img) {
                    
                    $photos = json_decode($img['Photos'], true);
                    if(!empty($photos)) {

	                    foreach ($photos as $size => $values) {

		                    if ($size == 'LargePhoto') {

			                    $id          = $values['id'];
			                    $filename    = $values['filename'];
			                    $sequence_id = $values['sequence_id'];
			                    $alt         = rps_fix_case($property['address']['StreetAddress']) . ', ' . rps_fix_case($property['address']['City'] . ', ' . $property['address']['Province']) . '  ' . rps_format_postal_code($property['address']['PostalCode']) . ' - Photo ' . $sequence_id . ' - ' . $property['common']['DdfListingID'];

			                    if ($ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
				                    $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $id . '/' . $filename;
			                    }
                                elseif ($ddf_cdn == true) {
				                    $img = $filename;
			                    }

			                    echo '<li class="slide">';
			                    // echo '<a href="' . REALTYPRESS_LISTING_PHOTO_URL . '/' . $id . '/' . $filename.'" rel="gallery-' . $id . '" class="swipebox">';

			                    // Jquery 3 Swipebox fix (no rel tag)
			                    echo '<a href="' . $img . '" class="swipebox">';
			                    echo '<img src="' . $img . '" alt="' . $alt . '" onerror="if (this.src != \'' . $missing_image . '\') this.src = \'' . $missing_image . '\';">';
			                    echo '</a>';
			                    echo '</li>';
		                    }

	                    }

                    }

                }
            }
            else {
                
                $photo = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
                echo '<li class="slide">';
                echo '<a href="' . $photo . '" rel="gallery-1" class="swipebox">';
                echo '<img src="' . $photo . '">';
                echo '</a>';
                echo '</li>';
            }
            ?>
        </ul><!-- /.bx-slider -->
        
        <?php if ($property['private']['Sold'] == 1) { ?>
            <?php if ($property['transaction']['TransactionType']) { ?>
                <?php if (strtolower($property['transaction']['TransactionType']) == 'for sale') { ?>
                    <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
                <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for lease') { ?>
                    <div class="rps-ribbon rps-ribbon-sold"><span>LEASED</span></div>
                <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for rent') { ?>
                    <div class="rps-ribbon rps-ribbon-sold"><span>RENTED</span></div>
                <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for sale or rent') { ?>
                    <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
                <?php } ?>
            <?php } else { ?>
                <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
            <?php } ?>
        <?php } ?>

    </div><!-- /bx-wrapper -->
    
    <?php if (empty($shortcode['view']) && get_option('rps-single-page-layout', 'page-sidebar-right') == 'page-full-width' ||
        ! empty($shortcode['view']) && $shortcode['view'] == 'full-width') { ?>

        <!-- ========== -->
        <!-- Full Width -->
        <!-- ========== -->

        <!-- Full Width BxPager -->
        <div class="bx-pager-wrap horizontal">
            <ul class="bx-pager horizontal" style="visibility:hidden;">
                
                <?php
                if ( ! empty($property['property-photos'][0]['Photos'])) {
                    
                    $i = 0;
                    foreach ($property['property-photos'] as $img) {
                        
                        $photos = json_decode($img['Photos'], true);
                        if(!empty($photos)) {

	                        $use_large = get_option( 'rps-system-options-download-medium-photos', 0 );
	                        if ( $use_large == 1 && $size == 'LargePhoto' ) {
		                        $index_adjust = ( isset( $photos[0]['LargePhoto']['sequence_id'] ) && $photos[0]['LargePhoto']['sequence_id'] == 0 ) ? 0 : 1;
	                        } else {
		                        $index_adjust = ( isset( $photos[0]['Photo']['sequence_id'] ) && $photos[0]['Photo']['sequence_id'] == 0 ) ? 0 : 1;
	                        }

	                        foreach ( $photos as $size => $values ) {

		                        if ( ( $use_large == 1 && $size == 'LargePhoto' ) || ( $use_large == 0 && $size == 'Photo' ) ) {

			                        $id          = $values['id'];
			                        $filename    = $values['filename'];
			                        $sequence_id = $values['sequence_id'] - $index_adjust;

			                        if ( $ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
				                        $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $id . '/' . $filename;
			                        } elseif ( $ddf_cdn == true ) {
				                        $img = $filename;
			                        }

			                        if ( ( rps_use_amazon_s3_storage() == true || rps_use_lw_object_storage() == true ) && $ddf_cdn == false ) {
				                        if ( ! rps_remote_file_exists( $img ) ) {
					                        $img = $missing_image;
				                        }
			                        }

			                        echo '<li class="slide">';
			                        if ( $use_large == 1 && $size == 'LargePhoto' ) {

				                        // Loading large image
				                        echo '<a data-slide-index="' . $i . '" href="" rel="nofollow" style="display:block;width:100%;background:url(' . $img . ') no-repeat center !important;background-size:contain !important;">';
				                        echo '<img src="' . REALTYPRESS_PUBLIC_URL . '/img/trans-256x200.png">';
				                        echo '</a>';
			                        } elseif ( $use_large == 0 && $size == 'Photo' ) {

				                        // Loading medium image
				                        echo '<a data-slide-index="' . $i . '" href="" rel="nofollow">';
				                        echo '<img src="' . $img . '" onerror="if (this.src != \'' . $missing_image . '\') this.src = \'' . $missing_image . '\';">';
				                        echo '</a>';
			                        }
			                        echo '</li>';

			                        $i ++;
		                        }

	                        }

                        }
                        
                    }
                }
                else {
                    $photo = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
                    echo '<li class="slide">';
                    echo '<a data-slide-index="0"  href="" rel="nofollow">';
                    echo '<img src="' . $photo . '">';
                    echo '</a>';
                    echo '</li>';
                }
                ?>
            </ul><!-- /.bx-pager -->
        </div><!-- ./bx-thumbnails -->
    
    <?php } ?>

</div><!-- /.col-md-9 -->

<?php if (empty($shortcode['view']) && get_option('rps-single-page-layout', 'page-sidebar-right') == 'page-sidebar-right' ||
    ! empty($shortcode['view']) && $shortcode['view'] == 'sidebar-right') { ?>

    <!-- ============= -->
    <!-- Sidebar Right -->
    <!-- ============= -->

    <div class="col-md-3 col-xs-12">

        <!-- Right Sidebar BxPager -->
        <div class="bx-pager-wrap">
            <ul class="bx-pager">
                
                <?php
                if ( ! empty($property['property-photos'][0]['Photos'])) {
                    
                    $i = 0;
                    foreach ($property['property-photos'] as $img) {
                        
                        $photos = json_decode($img['Photos'], true);
                        if(!empty($photos)) {
	                        foreach ( $photos as $size => $values ) {

		                        $use_large = get_option( 'rps-system-options-download-medium-photos', 0 );

		                        if ( ( $use_large == 1 && $size == 'LargePhoto' ) || ( $use_large == false && $size == 'Photo' ) ) {

			                        $id          = $values['id'];
			                        $filename    = $values['filename'];
			                        $sequence_id = $values['sequence_id'] - 1;

			                        if ( $ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
				                        $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $id . '/' . $filename;
			                        } elseif ( $ddf_cdn == true ) {
				                        $img = $filename;
			                        }

			                        if ( ( rps_use_amazon_s3_storage() == true || rps_use_lw_object_storage() == true ) && $ddf_cdn == false ) {
				                        if ( ! rps_remote_file_exists( $img ) ) {
					                        $img = $missing_image;
				                        }
			                        }

			                        echo '<li class="slide">';
			                        if ( $use_large == 1 && $size == 'LargePhoto' ) {

				                        // Loading large image slide
				                        echo '<a data-slide-index="' . $i . '" href="" rel="nofollow" style="display:block;width:100%;background:url(' . $img . ') no-repeat center !important;background-size:contain !important;">';
				                        echo '<img src="' . REALTYPRESS_PUBLIC_URL . '/img/trans-256x200.png">';
				                        echo '</a>';

			                        } elseif ( $use_large == 0 && $size == 'Photo' ) {

				                        // Loading medium image slide
				                        echo '<a data-slide-index="' . $i . '" href="" rel="nofollow">';
				                        echo '<img src="' . $img . '" onerror="if (this.src != \'' . $missing_image . '\') this.src = \'' . $missing_image . '\';">';
				                        echo '</a>';
			                        }
			                        echo '</li>';

			                        $i ++;
		                        }
	                        }
                        }
                    }
                }
                else {
                    $photo = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
                    echo '<li class="slide">';
                    echo '<a data-slide-index="0" href="" rel="nofollow">';
                    echo '<img src="' . $photo . '">';
                    echo '</a>';
                    echo '</li>';
                }
                ?>
            </ul><!-- /.bx-pager -->
        </div><!-- ./bx-thumbnails -->

    </div><!-- /.col-md-3 -->

<?php } ?>

</div><!-- /.row -->