<?php
if ( ! defined('ABSPATH'))
    exit;

    $tpl      = new RealtyPress_Template();
    $crud     = new RealtyPress_DDF_CRUD(date('Y-m-d'));
    $listings = new RealtyPress_Listings();
    $fav      = new RealtyPress_Favorites();
    
    $query     = $template_args['query'];
    $paged     = $template_args['paged'];
    $shortcode = $template_args['shortcode'];
    
    // If page layout is set to full width, display horizontal search form.
    if (empty($shortcode['style']) && get_option('rps-result-page-layout', 'page-sidebar-right') == 'page-full-width' ||
        ! empty($shortcode['style']) && $shortcode['style'] == 'full-width') {
        echo $tpl->get_template_part('partials/property-result-search-form-h', $template_args);
    }
    
    $show_listing_office = get_option('rps-result-listing-office', 1);
    
    $ddf_cdn = get_option('rps-system-options-enable-ddf-cdn', 0);

?>
<!--  Results | Grid Format  -->
<div id="rps-result-wrap">
    <div class="rps-result rps-grid-result">

        <!-- Overlay -->
        <div class="rps-result-overlay">
            <h2 class="text-center loading-text">
                <i class="fa fa-circle-o-notch fa-spin"></i><br>
                LOADING
            </h2>
        </div>

        <!-- Results -->
        <!-- <div class="row"> -->
        
        <?php if ($query->found_posts == 0) { ?>

            <!-- No Properties Found Notice -->
            <p>&nbsp;</p>
            <h2 class="text-center">No Properties Found!</h2>
            <p class="text-muted text-center">Try to broaden your current search criteria</p>
            <p>&nbsp;</p>
            <p>&nbsp;</p>
        
        <?php }
        else {

	        $grid_cols = ( !empty( $shortcode['num_columns'] ) ) ? explode( ',', $shortcode['num_columns'] ) : explode( ',', get_option('rps-result-grid-columns', '12,4,3')) ;
            ?>

            <div class="row">
                
                <?php $i = 1; ?>
                <?php foreach ($query->posts as $post) : ?>
                    
                    <?php
                    $property_cols               = "TransactionType, PostID, ListingID, BusinessType, StreetAddress, City, Province, BedroomsTotal, BathroomTotal, SizeInterior, OpenHouse, OwnershipType, Price, PricePerTime, PricePerUnit, Lease, LeasePerTime, LeasePerUnit, LeaseTermRemaining, LeaseTermRemainingFreq, LastUpdated, LastUpdated, CustomListing, Sold";
                    $property                    = $crud->rps_get_post_listing_details($post->ID, $property_cols);
                    $property['property-photos'] = $crud->get_local_listing_photos($property['ListingID']);
                    if ($show_listing_office == true) {
                        $property['property-agent'] = $crud->get_local_listing_agents($property['ListingID']);
                    }
                    $property  = $crud->categorize_listing_details_array($property);
                    $permalink = get_permalink($post->ID);
                    ?>

                    <section
                            class="col-xs-<?php echo $grid_cols[0] ?> col-sm-<?php echo $grid_cols[1] ?> col-md-<?php echo $grid_cols[2] ?> listing-container">
                        <div class="rps-property-result">
                            <div class="image-holder">
                                
                                <?php if ($property['private']['Sold'] != 1) { ?>
                                    
                                    <?php if ($property['transaction']['TransactionType']) { ?>
                                        <?php if (strtolower($property['transaction']['TransactionType']) == 'for sale') { ?>
                                            <span class="rps-ribbon rps-ribbon-info top-ribbon"><?php echo $property['transaction']['TransactionType'] ?></span>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for lease') { ?>
                                            <span class="rps-ribbon rps-ribbon-danger top-ribbon"><?php echo $property['transaction']['TransactionType'] ?></span>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for rent') { ?>
                                            <span class="rps-ribbon rps-ribbon-warning top-ribbon"><?php echo $property['transaction']['TransactionType'] ?></span>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for sale or rent') { ?>
                                            <span class="rps-ribbon rps-ribbon-success top-ribbon"><?php echo str_replace('sale or', 'sale<br>or', $property['transaction']['TransactionType']) ?></span>
                                        <?php } ?>
                                    <?php } ?>
                                    
                                    <?php if ( ! empty($property['open-house']['OpenHouse'])) { ?>
                                        <span class="rps-ribbon rps-ribbon-open-house right">OPEN HOUSE</span>
                                    <?php } ?>

                                    <!-- Price -->
                                    <?php if ($property['transaction']) { ?>
                                        <span class="rps-price rps-price-default"><?php echo rps_format_price($property['transaction']) ?></span>
                                    <?php } ?>
                                
                                <?php } else { ?>
                                    
                                    <?php if ($property['transaction']['TransactionType']) { ?>
                                        <?php if (strtolower($property['transaction']['TransactionType']) == 'for sale') { ?>
                                            <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for lease') { ?>
                                            <div class="rps-ribbon rps-ribbon-sold"><span>LEASED</span></div>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for rent') { ?>
                                            <div class="rps-ribbon rps-ribbon-sold"><span>RENTED</span></div>
                                        <?php } elseif (strtolower($property['transaction']['TransactionType']) == 'for sale or rent') { ?>
                                            <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
                                        <?php } ?>
                                    <?php } else { ?>
                                        <div class="rps-ribbon rps-ribbon-sold"><span>SOLD</span></div>
                                    <?php } ?>
                                
                                <?php } ?>
                                
                                <?php if ($fav->rps_check_favorited($property['private']['PostID'])) { ?>
                                    <!-- Favorite -->
                                    <span class="rps-favorited-heart pull-right">
                  <i class="fa fa-heart" style=""></i>
                </span>
                                <?php } ?>

                                <!-- Image -->
                                <figure>
                                    <a href="<?php echo $permalink ?>">
                                        <?php
                                        
                                        $missing_image = get_option('rps-general-default-image-property', REALTYPRESS_DEFAULT_LISTING_IMAGE);
                                        $img           = $missing_image;
                                        
                                        $use_large = get_option('rps-system-options-download-medium-photos', 0);
                                        if ($use_large == 1) {
                                            
                                            // ----------------------------------------------
                                            //    Use LargePhoto ONLY
                                            // ----------------------------------------------
                                            
                                            if ( ! empty($property['property-photos'][0]['Photos'])) {
                                                
                                                $photos = json_decode($property['property-photos'][0]['Photos'], true);
                                                
                                                if ( $ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
                                                    $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $photos['LargePhoto']['id'] . '/' . $photos['LargePhoto']['filename'];
                                                }
                                                elseif ( $ddf_cdn == true) {
                                                    $img = $photos['LargePhoto']['filename'];
                                                }
                                                
                                            }
                                            
                                            if ( ( rps_use_amazon_s3_storage() == true || rps_use_lw_object_storage() == true ) && $ddf_cdn == false ) {
                                                if ( ! rps_remote_file_exists($img)) {
                                                    $img = $missing_image;
                                                }
                                            }
                                            //                            else {
                                            //                                if(!file_exists($img)) {
                                            //                                    $img = $missing_image;
                                            //                                }
                                            //                            }
                                            
                                            echo '<a href="' . $permalink . '" style="display:block;width:100%;background:url(' . $img . ') no-repeat center !important;background-size:contain !important;">';
                                            echo '<img src="' . REALTYPRESS_PUBLIC_URL . '/img/trans-256x200.png" class="img-responsive rps-m-auto img-zoom" alt="' . $property['address']['StreetAddress'] . ', ' . $property['address']['City'] . ', ' . $property['address']['Province'] . '">';
                                            echo '</a>';
                                            
                                        }
                                        else {
                                            
                                            // ----------------------------------------------
                                            //    Default Photo Handling
                                            // ----------------------------------------------
                                            
                                            if ( ! empty($property['property-photos'][0]['Photos'])) {
                                                $photos = json_decode($property['property-photos'][0]['Photos'], true);
                                                if ( $ddf_cdn == false || $property['private']['CustomListing'] == 1 ) {
                                                    $img = REALTYPRESS_LISTING_PHOTO_URL . '/' . $photos['Photo']['id'] . '/' . $photos['Photo']['filename'];
                                                }
                                                elseif ( $ddf_cdn == true ) {
                                                    $img = $photos['Photo']['filename'];
                                                }
                                            }
                                            
                                            echo '<img src="' . $img . '" class="img-responsive rps-m-auto img-zoom" alt="' . $property['address']['StreetAddress'] . ', ' . $property['address']['City'] . ', ' . $property['address']['Province'] . '" onerror="if (this.src != \'' . $missing_image . '\') this.src = \'' . $missing_image . '\';">';
                                            
                                        }
                                        
                                        ?>
                                    </a>
                                </figure>

                            </div><!-- .image-holder -->
                            <div class="rps-property-info rps-text-center-sm">
                                
                                <?php
                                
                                // Business Type
                                if (get_option('rps-listing-result-show-business-type', 0) == 1) {
                                    if ( ! empty($property['business']['BusinessType'])) {
                                        echo '<div class="rps-result-grid-business-type">' . $property['business']['BusinessType'] . '</div>';
                                    }
                                }
                                ?>

                                <!-- Street Address -->
                                <a href="<?php echo $permalink ?>">
                                    <h4><?php echo rps_fix_case($property['address']['StreetAddress']) ?></h4></a>

                                <!-- City, Province, Postal Code -->
                                <p class="city-province-postalcode">
                                    <strong><?php echo rps_fix_case($property['address']['City']) ?>, <?php echo $property['address']['Province'] ?> <?php echo rps_format_postal_code($property['address']['PostalCode']) ?></strong>
                                </p>

                                <!-- Property Features -->
                                <div class="rps-result-features rps-text-center-sm clearfix">
                                    <?php if ( ! empty($property['building']['BedroomsTotal'])) { ?>
                                        <span class="rps-result-feature-label-sm"
                                              style=""><?php echo $property['building']['BedroomsTotal'] . ' ' . __('Bedroom', 'realtypress-premium') ?></span>
                                    <?php } ?>
                                    
                                    <?php if ( ! empty($property['building']['BathroomTotal'])) { ?>
                                        <span class="rps-result-feature-label-sm"><?php echo $property['building']['BathroomTotal'] . ' ' . __('Bathroom', 'realtypress-premium') ?></span>
                                    <?php } ?>
                                    
                                    <?php if ( ! empty($property['building']['SizeInterior'])) { ?>
                                        <span class="rps-result-feature-label-sm"><?php echo rps_format_size_interior($property['building']['SizeInterior']) ?></span>
                                    <?php } ?>
                                </div>
                                
                                <?php if ($show_listing_office == true) { ?>

                                    <div style="height:1px;margin-bottom:5px;"></div>
                                    
                                    <?php
                                    if ( ! empty($property['property-agent'])) {
                                        $offices = [];
                                        foreach ($property['property-agent'] as $agent_id => $values) {
                                            $office    = $crud->get_local_listing_office($values['OfficeID']);
                                            $ex_office = explode(',', $office['Name']);
                                            $offices[] = $ex_office[0];
                                        }
                                        $offices = rps_array_iunique($offices);
                                        $offices = implode('<br> ', $offices);
                                    }
                                    ?>

                                    <div class="rps-text-center-sm text-muted">
                                        <small><?php echo rps_fix_case($offices); ?></small>
                                    </div>
                                
                                <?php } ?>

                            </div><!-- /.info-holder -->
                        </div><!-- /.listing-holder -->
                    </section><!-- /.col-md-3 -->
                    
                    <?php if ($i % (12 / $grid_cols[0]) == 0) { ?>
                        <!-- Extra Small -->
                        <span class="clearfix visible-xs"></span>
                    <?php } ?>
                    
                    <?php if ($i % (12 / $grid_cols[1]) == 0) { ?>
                        <!-- Small -->
                        <span class="clearfix visible-sm"></span>
                    <?php } ?>
                    
                    <?php if ($i % (12 / $grid_cols[2]) == 0) { ?>
                        <!-- Desktop -->
                        <span class="clearfix visible-md visible-lg"></span>
                    <?php } ?>
                    
                    <?php clean_post_cache($post->ID) ?>
                    
                    <?php $i ++ ?>
                <?php endforeach; ?>
            </div><!-- /.row -->
        <?php } ?>
        <!-- </div> --><!-- /.row -->
    </div><!-- /.rps-grid-result -->
</div><!-- /.rps-result-wrap -->

<?php echo rps_pagination($query, $paged, 'result-pagination'); ?>