/*!
 * jQuery.localScroll
 * Copyright (c) 2007-2015 Ariel Flesler - aflesler<a>gmail<d>com | http://flesler.blogspot.com
 * Licensed under MIT
 * http://flesler.blogspot.com/2007/10/jquerylocalscroll-10.html
 * @author Ariel Flesler
 * @version 1.4.0
 */
 ;(function(plugin) {
    // AMD Support
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], plugin);
    } else {
        plugin(jQuery);
    }
}(function($) {
  var URI = location.href.replace(/#.*/, ''); // local url without hash

  var $localScroll = $.localScroll = function(settings) {
    $('body').localScroll(settings);
  };

  // Many of these defaults, belong to jQuery.ScrollTo, check it's demo for an example of each option.
  // @see http://demos.flesler.com/jquery/scrollTo/
  // The defaults are public and can be overriden.
  $localScroll.defaults = {
    duration: 1000, // How long to animate.
    axis: 'y', // Which of top and left should be modified.
    event: 'click', // On which event to react.
    stop: true, // Avoid queuing animations 
    target: window // What to scroll (selector or element). The whole window by default.
    /*
    lock: false, // ignore events if already animating
    lazy: false, // if true, links can be added later, and will still work.
    filter: null, // filter some anchors out of the matched elements.
    hash: false // if true, the hash of the selected link, will appear on the address bar.
    */
  };

  $.fn.localScroll = function(settings) {
    settings = $.extend({}, $localScroll.defaults, settings);

    if (settings.hash && location.hash) {
      if (settings.target) window.scrollTo(0, 0);
      scroll(0, location, settings);
    }

    return settings.lazy ?
      // use event delegation, more links can be added later.   
      this.on(settings.event, 'a,area', function(e) {
        if (filter.call(this)) {
          scroll(e, this, settings); 
        }
      }) :
      // bind concretely, to each matching link
      this.find('a,area')
        .filter(filter).bind(settings.event, function(e) {
          scroll(e, this, settings);
        }).end()
      .end();

    function filter() {// is this a link that points to an anchor and passes a possible filter ? href is checked to avoid a bug in FF.
      return !!this.href && !!this.hash && this.href.replace(this.hash,'') === URI && (!settings.filter || $(this).is(settings.filter));
    }
  };

  // Not needed anymore, kept for backwards compatibility
  $localScroll.hash = function() {};

  function scroll(e, link, settings) {
    var id = link.hash.slice(1),
      elem = document.getElementById(id) || document.getElementsByName(id)[0];

    if (!elem) return;

    if (e) e.preventDefault();

    var $target = $(settings.target);

    if (settings.lock && $target.is(':animated') ||
      settings.onBefore && settings.onBefore(e, elem, $target) === false) 
      return;

    if (settings.stop) {
      $target.stop(true); // remove all its animations
    }

    if (settings.hash) {
      var attr = elem.id === id ? 'id' : 'name',
        $a = $('<a> </a>').attr(attr, id).css({
          position:'absolute',
          top: $(window).scrollTop(),
          left: $(window).scrollLeft()
        });

      elem[attr] = '';
      $('body').prepend($a);
      location.hash = link.hash;
      $a.remove();
      elem[attr] = id;
    }
      
    $target
      .scrollTo(elem, settings) // do scroll
      .trigger('notify.serialScroll',[elem]); // notify serialScroll about this change
  }

  // AMD requirement
  return $localScroll;

}));