# Itinerator Templates WordPress Plugin

## Overview

The Itinerator Templates plugin is designed to enhance the functionality of the Itinerator plugin by creating a symlink to the active WordPress theme. This symlink allows the plugin to store and manage template files directly within the theme directory. Additionally, the plugin provides the capability to enqueue custom CSS, JavaScript, and PHP functions to ensure seamless integration and operation of the Itinerator plugin on websites not developed or maintained by The Number.

## Features

- **Symlink Creation**: Automatically creates a symlink in the active theme directory to store Itinerator template files.
- **Custom Script and Style Enqueuing**: Enqueue custom JavaScript and CSS files to enhance the plugin's functionality.
- **PHP Functionality**: Add custom PHP functions to extend the plugin's capabilities.
- **Google Maps API Management**: Dequeues additional Google Maps API scripts if multiple instances are detected to prevent conflicts.

## Installation

1. **Zip this Folder**: Zip the folder that contains this README.md file.
2. **Upload the Plugin**: Upload the zip file to the `/wp-content/plugins/` directory via ftp or using the WordPress plugin manager. Extract the zip file if using ftp.
3. **Activate the Plugin**: Activate the plugin through the 'Plugins' menu in WordPress.
3. **Symlink Creation**: Upon activation, the plugin will automatically create a symlink in the active theme directory.

## Usage

- **Custom Scripts and Styles**: The plugin enqueues `app.js` and `app.css` files. Modify these files to add custom JavaScript and CSS as needed.
- **PHP Functions**: Add or modify PHP functions within the plugin to extend its functionality. For example, the `convertDateTimeRange` function is used to format event date and time ranges.
- **Symlink Recreation**: If the symlink is ever removed from the main theme directory by accident, simply deactivate and activate this plugin to recreate it.

## Code Snippets

### Symlink Creation and Removal