document.addEventListener('DOMContentLoaded', function () {
    // jQuery(document).ready(function ($) {
    //   if ($('#itinerary-nav-pills').length) {
    //     var $navPills = $('#itinerary-nav-pills');
    //     var navPillsHeight = $navPills.outerHeight();
    //     var navPillsTop = $navPills.offset().top - 90;

    //     $(window).on('scroll', function () {
    //       var scrollTop = $(window).scrollTop();

    //       if (scrollTop >= navPillsTop) {
    //         $navPills.addClass('sticky');
    //         $navPills.css('top', '120');
    //       } else {
    //         $navPills.removeClass('sticky');
    //         $navPills.css('top', '');
    //       }
    //     });
    //   }
    // });

    // Function to get completed stops from cookie
    function getCompletedStops() {
        const cookieValue = document.cookie
            .split('; ')
            .find(row => row.startsWith('itinerator_completed_stops='));

        if (cookieValue) {
            try {
                return JSON.parse(decodeURIComponent(cookieValue.split('=')[1]));
            } catch (e) {
                console.error('Error parsing completed stops cookie:', e);
                return [];
            }
        }
        return [];
    }

    // Add visual indicators for completed stops
    const completedStops = getCompletedStops();
    // console.log('Completed stops:', completedStops); // Debug line

    // Add completed class to list items
    document.querySelectorAll('.list-group-item').forEach(item => {
        const stopId = item.dataset.stopId; // Using stop ID instead of position
        // console.log('Checking POI:', stopId); // Debug line
        if (completedStops.includes(stopId)) {
            item.classList.add('completed-stop');
        }
    });

    // Add completed class to map markers
    document.querySelectorAll('.marker').forEach(marker => {
        const stopId = marker.dataset.stopId; // Using stop ID instead of position
        if (completedStops.includes(stopId)) {
            marker.querySelector('.badge').classList.add('completed-stop');
        }
    });

    // Dialog functionality
    const modal = document.querySelector('#stopModal');
    const modalTitle = document.querySelector('#stopModalLabel');
    const modalContent = document.querySelector('#stopModalContent');
    const closeButton = modal.querySelector('.close-button');

    // Function to show modal with specific content
    function showModal(stopId) {
        // console.log('Attempting to show modal for stop:', stopId); // Debug
        // console.log('Available modal content:', modalContent); // Debug
        // console.log('Window modalContent object:', window.modalContent); // Debug

        if (window.modalContent && window.modalContent[stopId]) {
            // console.log('Found content for stop:', window.modalContent[stopId]); // Debug
            modalTitle.textContent = window.modalContent[stopId].title;
            modalContent.innerHTML = window.modalContent[stopId].content;
            modal.showModal();
        } else {
            console.error('No content found for stop:', stopId); // Debug
        }
    }

    // Close handlers
    closeButton.addEventListener('click', () => {
        modal.close();
        const url = new URL(window.location);
        url.searchParams.delete('complete_stop');
        window.history.replaceState({}, '', url);
    });

    modal.addEventListener('click', (e) => {
        const rect = modal.getBoundingClientRect();
        const isInDialog = (rect.top <= e.clientY && e.clientY <= rect.top + rect.height
            && rect.left <= e.clientX && e.clientX <= rect.left + rect.width);
        if (!isInDialog) {
            modal.close();
        }
    });

    // Check URL parameter on load
    const urlParams = new URLSearchParams(window.location.search);
    const completeStop = urlParams.get('complete_stop');
    if (completeStop) {
        showModal(completeStop);
    }

  });
