<?php
/**
 * Generated stub declarations for WooCommerce.
 * @see https://woocommerce.com
 * @see https://github.com/php-stubs/woocommerce-stubs
 */

namespace {
    /**
     * An interface for registering integrations with WordPress.
     */
    interface WPSEO_WordPress_Integration
    {
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * A WordPress integration that listens for whether the SEO changes have been saved successfully.
     */
    class WPSEO_Admin_Settings_Changed_Listener implements \WPSEO_WordPress_Integration
    {
        /**
         * Have the Yoast SEO settings been saved.
         *
         * @var bool
         */
        private static $settings_saved = \false;
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Checks and overwrites the wp_settings_errors global to determine whether the Yoast SEO settings have been saved.
         */
        public function intercept_save_update_notification()
        {
        }
        /**
         * Checks whether the settings notification is a settings_updated notification.
         *
         * @param array $wp_settings_error The settings object.
         *
         * @return bool Whether this is a settings updated settings notification.
         */
        public function is_settings_updated_notification($wp_settings_error)
        {
        }
        /**
         * Get whether the settings have successfully been saved
         *
         * @return bool Whether the settings have successfully been saved.
         */
        public function have_settings_been_saved()
        {
        }
        /**
         * Renders a success message if the Yoast SEO settings have been saved.
         */
        public function show_success_message()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Ajax
     */
    /**
     * Class WPSEO_Shortcode_Filter.
     *
     * Used for parsing WP shortcodes with AJAX.
     */
    class WPSEO_Shortcode_Filter
    {
        /**
         * Initialize the AJAX hooks.
         */
        public function __construct()
        {
        }
        /**
         * Parse the shortcodes.
         */
        public function do_filter()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Ajax
     */
    /**
     * This class will catch the request to dismiss the target notice (set by notice_name)
     * and will store the dismiss status as an user meta in the database.
     */
    class Yoast_Dismissable_Notice_Ajax
    {
        /**
         * Notice type toggle value for user notices.
         *
         * @var string
         */
        const FOR_USER = 'user_meta';
        /**
         * Notice type toggle value for network notices.
         *
         * @var string
         */
        const FOR_NETWORK = 'site_option';
        /**
         * Notice type toggle value for site notices.
         *
         * @var string
         */
        const FOR_SITE = 'option';
        /**
         * Name of the notice that will be dismissed.
         *
         * @var string
         */
        private $notice_name;
        /**
         * The type of the current notice.
         *
         * @var string
         */
        private $notice_type;
        /**
         * Initialize the hooks for the AJAX request.
         *
         * @param string $notice_name The name for the hook to catch the notice.
         * @param string $notice_type The notice type.
         */
        public function __construct($notice_name, $notice_type = self::FOR_USER)
        {
        }
        /**
         * Handles the dismiss notice request.
         */
        public function dismiss_notice()
        {
        }
        /**
         * Storing the dismissed value in the database. The target location is based on the set notification type.
         */
        private function save_dismissed()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Ajax
     */
    /**
     * Class Yoast_Plugin_Conflict_Ajax.
     */
    class Yoast_Plugin_Conflict_Ajax
    {
        /**
         * Option identifier where dismissed conflicts are stored.
         *
         * @var string
         */
        private $option_name = 'wpseo_dismissed_conflicts';
        /**
         * List of notification identifiers that have been dismissed.
         *
         * @var array
         */
        private $dismissed_conflicts = [];
        /**
         * Initialize the hooks for the AJAX request.
         */
        public function __construct()
        {
        }
        /**
         * Handles the dismiss notice request.
         */
        public function dismiss_notice()
        {
        }
        /**
         * Getting the user option from the database.
         *
         * @return bool|array
         */
        private function get_dismissed_option()
        {
        }
        /**
         * Getting the dismissed conflicts from the database
         *
         * @param string $plugin_section Type of conflict group (such as Open Graph or sitemap).
         *
         * @return array
         */
        private function get_dismissed_conflicts($plugin_section)
        {
        }
        /**
         * Storing the conflicting plugins as an user option in the database.
         *
         * @param string $plugin_section Plugin conflict type (such as Open Graph or sitemap).
         */
        private function save_dismissed_conflicts($plugin_section)
        {
        }
        /**
         * Loop through the plugins to compare them with the already stored dismissed plugin conflicts.
         *
         * @param array $posted_plugins Plugin set to check.
         */
        public function compare_plugins(array $posted_plugins)
        {
        }
        /**
         * Check if plugin is already dismissed, if not store it in the array that will be saved later.
         *
         * @param string $posted_plugin Plugin to check against dismissed conflicts.
         */
        private function compare_plugin($posted_plugin)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Capability Manager interface.
     */
    interface WPSEO_Capability_Manager
    {
        /**
         * Registers a capability.
         *
         * @param string $capability Capability to register.
         * @param array  $roles      Roles to add the capability to.
         * @param bool   $overwrite  Optional. Use add or overwrite as registration method.
         */
        public function register($capability, array $roles, $overwrite = \false);
        /**
         * Adds the registerd capabilities to the system.
         */
        public function add();
        /**
         * Removes the registered capabilities from the system.
         */
        public function remove();
        /**
         * Returns the list of registered capabilities.
         *
         * @return string[] List of registered capabilities.
         */
        public function get_capabilities();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Abstract Capability Manager shared code.
     */
    abstract class WPSEO_Abstract_Capability_Manager implements \WPSEO_Capability_Manager
    {
        /**
         * Registered capabilities.
         *
         * @var array
         */
        protected $capabilities = [];
        /**
         * Registers a capability.
         *
         * @param string $capability Capability to register.
         * @param array  $roles      Roles to add the capability to.
         * @param bool   $overwrite  Optional. Use add or overwrite as registration method.
         */
        public function register($capability, array $roles, $overwrite = \false)
        {
        }
        /**
         * Returns the list of registered capabilitities.
         *
         * @return string[] Registered capabilities.
         */
        public function get_capabilities()
        {
        }
        /**
         * Returns a list of WP_Role roles.
         *
         * The string array of role names are converted to actual WP_Role objects.
         * These are needed to be able to use the API on them.
         *
         * @param array $roles Roles to retrieve the objects for.
         *
         * @return WP_Role[] List of WP_Role objects.
         */
        protected function get_wp_roles(array $roles)
        {
        }
        /**
         * Filter capability roles.
         *
         * @param string $capability Capability to filter roles for.
         * @param array  $roles      List of roles which can be filtered.
         *
         * @return array Filtered list of roles for the capability.
         */
        protected function filter_roles($capability, array $roles)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Capability Manager Factory.
     */
    class WPSEO_Capability_Manager_Factory
    {
        /**
         * Returns the Manager to use.
         *
         * @param string $plugin_type Whether it's Free or Premium.
         *
         * @return WPSEO_Capability_Manager Manager to use.
         */
        public static function get($plugin_type = 'free')
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Integrates Yoast SEO capabilities with third party role manager plugins.
     *
     * Integrates with: Members
     * Integrates with: User Role Editor
     */
    class WPSEO_Capability_Manager_Integration implements \WPSEO_WordPress_Integration
    {
        /**
         * Capability manager to use.
         *
         * @var WPSEO_Capability_Manager
         */
        public $manager;
        /**
         * WPSEO_Capability_Manager_Integration constructor.
         *
         * @param WPSEO_Capability_Manager $manager The capability manager to use.
         */
        public function __construct(\WPSEO_Capability_Manager $manager)
        {
        }
        /**
         * Registers the hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Get the Yoast SEO capabilities.
         * Optionally append them to an existing array.
         *
         * @param  array $caps Optional existing capability list.
         * @return array
         */
        public function get_capabilities(array $caps = [])
        {
        }
        /**
         * Add capabilities to its own group in the Members plugin.
         *
         * @see members_register_cap_group()
         */
        public function action_members_register_cap_group()
        {
        }
        /**
         * Adds Yoast SEO capability group in the User Role Editor plugin.
         *
         * @see URE_Capabilities_Groups_Manager::get_groups_tree()
         *
         * @param array $groups Current groups.
         *
         * @return array Filtered list of capabilty groups.
         */
        public function filter_ure_capabilities_groups_tree($groups = [])
        {
        }
        /**
         * Adds capabilities to the Yoast SEO group in the User Role Editor plugin.
         *
         * @see URE_Capabilities_Groups_Manager::get_cap_groups()
         *
         * @param array  $groups Current capability groups.
         * @param string $cap_id Capability identifier.
         *
         * @return array List of filtered groups.
         */
        public function filter_ure_custom_capability_groups($groups = [], $cap_id = '')
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * VIP implementation of the Capability Manager.
     */
    final class WPSEO_Capability_Manager_VIP extends \WPSEO_Abstract_Capability_Manager
    {
        /**
         * Adds the registered capabilities to the system.
         *
         * @return void
         */
        public function add()
        {
        }
        /**
         * Removes the registered capabilities from the system
         *
         * @return void
         */
        public function remove()
        {
        }
        /**
         * Returns the roles which the capability is registered on.
         *
         * @param array  $role_capabilities List of all roles with their capabilities.
         * @param string $capability        Capability to filter roles for.
         * @param array  $roles             List of default roles.
         *
         * @return array List of capabilities.
         */
        protected function get_role_capabilities($role_capabilities, $capability, $roles)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Default WordPress capability manager implementation.
     */
    final class WPSEO_Capability_Manager_WP extends \WPSEO_Abstract_Capability_Manager
    {
        /**
         * Adds the capabilities to the roles.
         *
         * @return void
         */
        public function add()
        {
        }
        /**
         * Unregisters the capabilities from the system.
         *
         * @return void
         */
        public function remove()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Capability Utils collection.
     */
    class WPSEO_Capability_Utils
    {
        /**
         * Checks if the user has the proper capabilities.
         *
         * @param string $capability Capability to check.
         *
         * @return bool True if the user has the proper rights.
         */
        public static function current_user_can($capability)
        {
        }
        /**
         * Retrieves the users that have the specified capability.
         *
         * @param string $capability The name of the capability.
         *
         * @return array The users that have the capability.
         */
        public static function get_applicable_users($capability)
        {
        }
        /**
         * Retrieves the roles that have the specified capability.
         *
         * @param string $capability The name of the capability.
         *
         * @return array The names of the roles that have the capability.
         */
        public static function get_applicable_roles($capability)
        {
        }
        /**
         * Checks if the current user has at least one of the supplied capabilities.
         *
         * @param array $capabilities Capabilities to check against.
         *
         * @return bool True if the user has at least one capability.
         */
        protected static function has_any(array $capabilities)
        {
        }
        /**
         * Checks if the user has a certain capability.
         *
         * @param string $capability Capability to check against.
         *
         * @return bool True if the user has the capability.
         */
        protected static function has($capability)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Capabilities
     */
    /**
     * Capabilities registration class.
     */
    class WPSEO_Register_Capabilities implements \WPSEO_WordPress_Integration
    {
        /**
         * Registers the hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Registers the capabilities.
         *
         * @return void
         */
        public function register()
        {
        }
        /**
         * Revokes the 'wpseo_manage_options' capability from administrator users if it should
         * only be granted to network administrators.
         *
         * @param array   $allcaps An array of all the user's capabilities.
         * @param array   $caps    Actual capabilities being checked.
         * @param array   $args    Optional parameters passed to has_cap(), typically object ID.
         * @param WP_User $user    The user object.
         *
         * @return array Possibly modified array of the user's capabilities.
         */
        public function filter_user_has_wpseo_manage_options_cap($allcaps, $caps, $args, $user)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents a way to determine an assets location.
     */
    interface WPSEO_Admin_Asset_Location
    {
        /**
         * Determines the URL of the asset on the dev server.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset. Usually JS or CSS.
         *
         * @return string The URL of the asset.
         */
        public function get_url(\WPSEO_Admin_Asset $asset, $type);
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents a way to determine the analysis worker asset location.
     */
    final class WPSEO_Admin_Asset_Analysis_Worker_Location implements \WPSEO_Admin_Asset_Location
    {
        /**
         * Holds the asset's location.
         *
         * @var WPSEO_Admin_Asset_Location
         */
        private $asset_location;
        /**
         * Holds the asset itself.
         *
         * @var WPSEO_Admin_Asset
         */
        private $asset;
        /**
         * Constructs the location of the analysis worker asset.
         *
         * @param string $flat_version The flat version of the asset.
         * @param string $name         The name of the analysis worker asset.
         */
        public function __construct($flat_version = '', $name = 'analysis-worker')
        {
        }
        /**
         * Retrieves the analysis worker asset.
         *
         * @return WPSEO_Admin_Asset The analysis worker asset.
         */
        public function get_asset()
        {
        }
        /**
         * Determines the URL of the asset on the dev server.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset. Usually JS or CSS.
         *
         * @return string The URL of the asset.
         */
        public function get_url(\WPSEO_Admin_Asset $asset, $type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Changes the asset paths to dev server paths.
     */
    final class WPSEO_Admin_Asset_Dev_Server_Location implements \WPSEO_Admin_Asset_Location
    {
        /**
         * Holds the dev server's default URL.
         *
         * @var string
         */
        const DEFAULT_URL = 'http://localhost:8080';
        /**
         * Holds the url where the server is located.
         *
         * @var string
         */
        private $url;
        /**
         * Class constructor.
         *
         * @param string|null $url Where the dev server is located.
         */
        public function __construct($url = \null)
        {
        }
        /**
         * Determines the URL of the asset on the dev server.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset. Usually JS or CSS.
         *
         * @return string The URL of the asset.
         */
        public function get_url(\WPSEO_Admin_Asset $asset, $type)
        {
        }
        /**
         * Determines the URL of the asset not using the dev server.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset.
         *
         * @return string The URL of the asset file.
         */
        public function get_default_url(\WPSEO_Admin_Asset $asset, $type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class registers all the necessary styles and scripts.
     *
     * Also has methods for the enqueing of scripts and styles.
     * It automatically adds a prefix to the handle.
     */
    class WPSEO_Admin_Asset_Manager
    {
        /**
         * Prefix for naming the assets.
         *
         * @var string
         */
        const PREFIX = 'yoast-seo-';
        /**
         * Class that manages the assets' location.
         *
         * @var WPSEO_Admin_Asset_Location
         */
        protected $asset_location;
        /**
         * Prefix for naming the assets.
         *
         * @var string
         */
        private $prefix;
        /**
         * Constructs a manager of assets. Needs a location to know where to register assets at.
         *
         * @param WPSEO_Admin_Asset_Location|null $asset_location The provider of the asset location.
         * @param string                          $prefix         The prefix for naming assets.
         */
        public function __construct(\WPSEO_Admin_Asset_Location $asset_location = \null, $prefix = self::PREFIX)
        {
        }
        /**
         * Enqueues scripts.
         *
         * @param string $script The name of the script to enqueue.
         */
        public function enqueue_script($script)
        {
        }
        /**
         * Enqueues styles.
         *
         * @param string $style The name of the style to enqueue.
         */
        public function enqueue_style($style)
        {
        }
        /**
         * Enqueues the appropriate language for the user.
         */
        public function enqueue_user_language_script()
        {
        }
        /**
         * Registers scripts based on it's parameters.
         *
         * @param WPSEO_Admin_Asset $script The script to register.
         */
        public function register_script(\WPSEO_Admin_Asset $script)
        {
        }
        /**
         * Registers styles based on it's parameters.
         *
         * @param WPSEO_Admin_Asset $style The style to register.
         */
        public function register_style(\WPSEO_Admin_Asset $style)
        {
        }
        /**
         * Calls the functions that register scripts and styles with the scripts and styles to be registered as arguments.
         */
        public function register_assets()
        {
        }
        /**
         * Registers all the scripts passed to it.
         *
         * @param array $scripts The scripts passed to it.
         */
        public function register_scripts($scripts)
        {
        }
        /**
         * Registers all the styles it receives.
         *
         * @param array $styles Styles that need to be registered.
         */
        public function register_styles($styles)
        {
        }
        /**
         * Localizes the script.
         *
         * @param string $handle      The script handle.
         * @param string $object_name The object name.
         * @param array  $data        The l10n data.
         */
        public function localize_script($handle, $object_name, $data)
        {
        }
        /**
         * A list of styles that shouldn't be registered but are needed in other locations in the plugin.
         *
         * @return array
         */
        public function special_styles()
        {
        }
        /**
         * Flattens a version number for use in a filename.
         *
         * @param string $version The original version number.
         *
         * @return string The flattened version number.
         */
        public function flatten_version($version)
        {
        }
        /**
         * Creates a default location object for use in the admin asset manager.
         *
         * @return WPSEO_Admin_Asset_Location The location to use in the asset manager.
         */
        public static function create_default_location()
        {
        }
        /**
         * Checks if the given script is enqueued.
         *
         * @param string $script The script to check.
         *
         * @return bool True when the script is enqueued.
         */
        public function is_script_enqueued($script)
        {
        }
        /**
         * Returns the scripts that need to be registered.
         *
         * @todo Data format is not self-documenting. Needs explanation inline. R.
         *
         * @return array The scripts that need to be registered.
         */
        protected function scripts_to_be_registered()
        {
        }
        /**
         * Loads a generated asset file.
         *
         * @param array $args {
         *     The arguments.
         *
         *     @type string                  $asset_file      The asset file to load.
         *     @type int                     $ext_length      The length of the extension, including suffix, of the filename.
         *     @type string                  $suffix          Optional. The suffix of the asset name.
         *     @type array<string, string[]> $additional_deps Optional. The additional dependencies assets may have.
         *     @type string                  $base_dir        Optional. The base directory of the asset.
         *     @type string[]                $header_scripts  Optional. The script names that should be in the header.
         * }
         *
         * @return array {
         *     The scripts to be registered.
         *
         *     @type string   $name      The name of the asset.
         *     @type string   $src       The src of the asset.
         *     @type string[] $deps      The dependenies of the asset.
         *     @type bool     $in_footer Whether or not the asset should be in the footer.
         * }
         */
        protected function load_generated_asset_file($args)
        {
        }
        /**
         * Loads the select2 scripts.
         *
         * @return array {
         *     The scripts to be registered.
         *
         *     @type string   $name      The name of the asset.
         *     @type string   $src       The src of the asset.
         *     @type string[] $deps      The dependenies of the asset.
         *     @type bool     $in_footer Whether or not the asset should be in the footer.
         * }
         */
        protected function load_select2_scripts()
        {
        }
        /**
         * Loads the scripts that should be renamed for BC.
         *
         * @return array {
         *     The scripts to be registered.
         *
         *     @type string   $name      The name of the asset.
         *     @type string   $src       The src of the asset.
         *     @type string[] $deps      The dependenies of the asset.
         *     @type bool     $in_footer Whether or not the asset should be in the footer.
         * }
         */
        protected function load_renamed_scripts()
        {
        }
        /**
         * Returns the styles that need to be registered.
         *
         * @todo Data format is not self-documenting. Needs explanation inline. R.
         *
         * @return array Styles that need to be registered.
         */
        protected function styles_to_be_registered()
        {
        }
        /**
         * Determines the URL of the asset.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset. Usually JS or CSS.
         *
         * @return string The URL of the asset.
         */
        protected function get_url(\WPSEO_Admin_Asset $asset, $type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Determines the location of an asset within the SEO plugin.
     */
    final class WPSEO_Admin_Asset_SEO_Location implements \WPSEO_Admin_Asset_Location
    {
        /**
         * Path to the plugin file.
         *
         * @var string
         */
        protected $plugin_file;
        /**
         * Whether or not to add the file suffix to the asset.
         *
         * @var boolean
         */
        protected $add_suffix = \true;
        /**
         * The plugin file to base the asset location upon.
         *
         * @param string  $plugin_file The plugin file string.
         * @param boolean $add_suffix  Optional. Whether or not a file suffix should be added.
         */
        public function __construct($plugin_file, $add_suffix = \true)
        {
        }
        /**
         * Determines the URL of the asset on the dev server.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the URL for.
         * @param string            $type  The type of asset. Usually JS or CSS.
         *
         * @return string The URL of the asset.
         */
        public function get_url(\WPSEO_Admin_Asset $asset, $type)
        {
        }
        /**
         * Determines the path relative to the plugin folder of an asset.
         *
         * @param WPSEO_Admin_Asset $asset The asset to determine the path for.
         * @param string            $type  The type of asset.
         *
         * @return string The path to the asset file.
         */
        protected function get_path(\WPSEO_Admin_Asset $asset, $type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Localizes JavaScript files.
     */
    final class WPSEO_Admin_Asset_Yoast_Components_L10n
    {
        /**
         * Represents the asset manager.
         *
         * @var WPSEO_Admin_Asset_Manager
         */
        protected $asset_manager;
        /**
         * WPSEO_Admin_Asset_Yoast_Components_L10n constructor.
         */
        public function __construct()
        {
        }
        /**
         * Localizes the given script with the JavaScript translations.
         *
         * @param string $script_handle The script handle to localize for.
         *
         * @return void
         */
        public function localize_script($script_handle)
        {
        }
        /**
         * Returns translations necessary for JS files.
         *
         * @param string $component The component to retrieve the translations for.
         * @return object|null The translations in a Jed format for JS files.
         */
        protected function get_translations($component)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Determines the editor specific replacement variables.
     */
    class WPSEO_Admin_Editor_Specific_Replace_Vars
    {
        /**
         * Holds the editor specific replacements variables.
         *
         * @var array The editor specific replacement variables.
         */
        protected $replacement_variables = [
            // Posts types.
            'page' => ['id', 'pt_single', 'pt_plural', 'parent_title'],
            'post' => ['id', 'term404', 'pt_single', 'pt_plural'],
            // Custom post type.
            'custom_post_type' => ['id', 'term404', 'pt_single', 'pt_plural', 'parent_title'],
            // Settings - archive pages.
            'custom-post-type_archive' => ['pt_single', 'pt_plural'],
            // Taxonomies.
            'category' => ['term_title', 'term_description', 'category_description', 'parent_title', 'term_hierarchy'],
            'post_tag' => ['term_title', 'term_description', 'tag_description'],
            'post_format' => ['term_title'],
            // Custom taxonomy.
            'term-in-custom-taxonomy' => ['term_title', 'term_description', 'category_description', 'parent_title', 'term_hierarchy'],
            // Settings - special pages.
            'search' => ['searchphrase'],
        ];
        /**
         * WPSEO_Admin_Editor_Specific_Replace_Vars constructor.
         */
        public function __construct()
        {
        }
        /**
         * Retrieves the editor specific replacement variables.
         *
         * @return array The editor specific replacement variables.
         */
        public function get()
        {
        }
        /**
         * Retrieves the generic replacement variable names.
         *
         * Which are the replacement variables without the editor specific ones.
         *
         * @param array $replacement_variables Possibly generic replacement variables.
         *
         * @return array The generic replacement variable names.
         */
        public function get_generic($replacement_variables)
        {
        }
        /**
         * Determines the page type of the current term.
         *
         * @param string $taxonomy The taxonomy name.
         *
         * @return string The page type.
         */
        public function determine_for_term($taxonomy)
        {
        }
        /**
         * Determines the page type of the current post.
         *
         * @param WP_Post $post A WordPress post instance.
         *
         * @return string The page type.
         */
        public function determine_for_post($post)
        {
        }
        /**
         * Determines the page type for a post type.
         *
         * @param string $post_type The name of the post_type.
         * @param string $fallback  The page type to fall back to.
         *
         * @return string The page type.
         */
        public function determine_for_post_type($post_type, $fallback = 'custom_post_type')
        {
        }
        /**
         * Determines the page type for an archive page.
         *
         * @param string $name     The name of the archive.
         * @param string $fallback The page type to fall back to.
         *
         * @return string The page type.
         */
        public function determine_for_archive($name, $fallback = 'custom-post-type_archive')
        {
        }
        /**
         * Adds the replavement variables for the given page types.
         *
         * @param array $page_types                   Page types to add variables for.
         * @param array $replacement_variables_to_add The variables to add.
         *
         * @return void
         */
        protected function add_for_page_types(array $page_types, array $replacement_variables_to_add)
        {
        }
        /**
         * Extracts the names from the given replacements variables.
         *
         * @param array $replacement_variables Replacement variables to extract the name from.
         *
         * @return array Extracted names.
         */
        protected function extract_names($replacement_variables)
        {
        }
        /**
         * Returns whether the given page type has editor specific replace vars.
         *
         * @param string $page_type The page type to check.
         *
         * @return bool True if there are associated editor specific replace vars.
         */
        protected function has_for_page_type($page_type)
        {
        }
        /**
         * Merges all editor specific replacement variables into one array and removes duplicates.
         *
         * @return array The list of unique editor specific replacement variables.
         */
        protected function get_unique_replacement_variables()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Handles the Gutenberg Compatibility notification showing and hiding.
     */
    class WPSEO_Admin_Gutenberg_Compatibility_Notification implements \WPSEO_WordPress_Integration
    {
        /**
         * Notification ID to use.
         *
         * @var string
         */
        private $notification_id = 'wpseo-outdated-gutenberg-plugin';
        /**
         * Instance of gutenberg compatibility checker.
         *
         * @var WPSEO_Gutenberg_Compatibility
         */
        protected $compatibility_checker;
        /**
         * Instance of Yoast Notification Center.
         *
         * @var Yoast_Notification_Center
         */
        protected $notification_center;
        /**
         * WPSEO_Admin_Gutenberg_Compatibility_Notification constructor.
         */
        public function __construct()
        {
        }
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Manages if the notification should be shown or removed.
         *
         * @return void
         */
        public function manage_notification()
        {
        }
        /**
         * Adds the notification to the notificaton center.
         *
         * @return void
         */
        protected function add_notification()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates the HTML for an inline Help Button and Panel.
     */
    class WPSEO_Admin_Help_Panel
    {
        /**
         * Unique identifier of the element the inline help refers to, used as an identifier in the html.
         *
         * @var string
         */
        private $id;
        /**
         * The Help Button text. Needs a properly escaped string.
         *
         * @var string
         */
        private $help_button_text;
        /**
         * The Help Panel content. Needs a properly escaped string (might contain HTML).
         *
         * @var string
         */
        private $help_content;
        /**
         * Optional Whether to print out a container div element for the Help Panel, used for styling.
         *
         * @var string
         */
        private $wrapper;
        /**
         * Constructor.
         *
         * @param string $id               Unique identifier of the element the inline help refers to, used as
         *                                 an identifier in the html.
         * @param string $help_button_text The Help Button text. Needs a properly escaped string.
         * @param string $help_content     The Help Panel content. Needs a properly escaped string (might contain HTML).
         * @param string $wrapper          Optional Whether to print out a container div element for the Help Panel,
         *                                 used for styling.
         *                                 Pass a `has-wrapper` value to print out the container. Default: no container.
         */
        public function __construct($id, $help_button_text, $help_content, $wrapper = '')
        {
        }
        /**
         * Returns the html for the Help Button.
         *
         * @return string
         */
        public function get_button_html()
        {
        }
        /**
         * Returns the html for the Help Panel.
         *
         * @return string
         */
        public function get_panel_html()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Performs the load on admin side.
     */
    class WPSEO_Admin_Init
    {
        /**
         * Holds the global `$pagenow` variable's value.
         *
         * @var string
         */
        private $pagenow;
        /**
         * Holds the asset manager.
         *
         * @var WPSEO_Admin_Asset_Manager
         */
        private $asset_manager;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Enqueue our styling for dismissible yoast notifications.
         */
        public function enqueue_dismissible()
        {
        }
        /**
         * Creates an unsupported PHP version notification in the notification center.
         *
         * @return void
         */
        public function unsupported_php_notice()
        {
        }
        /**
         * Gets the latest released major WordPress version from the WordPress stable-check api.
         *
         * @return float|int The latest released major WordPress version. 0 when the stable-check API doesn't respond.
         */
        private function get_latest_major_wordpress_version()
        {
        }
        /**
         * Helper to verify if the user is currently visiting one of our admin pages.
         *
         * @return bool
         */
        private function on_wpseo_admin_page()
        {
        }
        /**
         * Determine whether we should load the meta box class and if so, load it.
         */
        private function load_meta_boxes()
        {
        }
        /**
         * Determine if we should load our taxonomy edit class and if so, load it.
         */
        private function load_taxonomy_class()
        {
        }
        /**
         * Determine if we should load our admin pages class and if so, load it.
         *
         * Loads admin page class for all admin pages starting with `wpseo_`.
         */
        private function load_admin_user_class()
        {
        }
        /**
         * Determine if we should load our admin pages class and if so, load it.
         *
         * Loads admin page class for all admin pages starting with `wpseo_`.
         */
        private function load_admin_page_class()
        {
        }
        /**
         * Loads the plugin suggestions.
         */
        private function load_plugin_suggestions()
        {
        }
        /**
         * Registers the Premium Upsell Admin Block.
         *
         * @return void
         */
        private function register_premium_upsell_admin_block()
        {
        }
        /**
         * Registers the promotion class for our GlotPress instance, then creates a notification with the i18n promo.
         *
         * @link https://github.com/Yoast/i18n-module
         */
        private function register_i18n_promo_class()
        {
        }
        /**
         * See if we should start our XML Sitemaps Admin class.
         */
        private function load_xml_sitemaps_admin()
        {
        }
        /**
         * Checks whether search engines are discouraged from indexing the site.
         *
         * @return bool Whether search engines are discouraged from indexing the site.
         */
        private function are_search_engines_discouraged()
        {
        }
        /**
         * Shows deprecation warnings to the user if a plugin has registered a filter we have deprecated.
         */
        public function show_hook_deprecation_warnings()
        {
        }
        /**
         * Check if the permalink uses %postname%.
         *
         * @return bool
         */
        private function has_postname_in_permalink()
        {
        }
        /**
         * Shows a notice on the permalink settings page.
         */
        public function permalink_settings_notice()
        {
        }
        /**
         * Determines whether and where the "search engines discouraged" admin notice should be displayed.
         *
         * @return bool Whether the "search engines discouraged" admin notice should be displayed.
         */
        private function should_display_search_engines_discouraged_notice()
        {
        }
        /**
         * Displays an admin notice when WordPress is set to discourage search engines from indexing the site.
         *
         * @return void
         */
        public function search_engines_discouraged_notice()
        {
        }
        /**
         * Adds a custom Yoast section within the Classic Editor publish box.
         *
         * @param \WP_Post $post The current post object.
         *
         * @return void
         */
        public function add_publish_box_section($post)
        {
        }
        /* ********************* DEPRECATED METHODS ********************* */
        /**
         * Notify about the default tagline if the user hasn't changed it.
         *
         * @deprecated 13.2
         * @codeCoverageIgnore
         */
        public function tagline_notice()
        {
        }
        /**
         * Returns whether or not the site has the default tagline.
         *
         * @deprecated 13.2
         * @codeCoverageIgnore
         *
         * @return bool
         */
        public function has_default_tagline()
        {
        }
        /**
         * Shows an alert when the permalink doesn't contain %postname%.
         *
         * @deprecated 13.2
         * @codeCoverageIgnore
         */
        public function permalink_notice()
        {
        }
        /**
         * Add an alert if the blog is not publicly visible.
         *
         * @deprecated 14.1
         * @codeCoverageIgnore
         */
        public function blog_public_notice()
        {
        }
        /**
         * Handles the notifiers for the dashboard page.
         *
         * @deprecated 14.1
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function handle_notifications()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Determines the recommended replacement variables based on the context.
     */
    class WPSEO_Admin_Recommended_Replace_Vars
    {
        /**
         * The recommended replacement variables.
         *
         * @var array
         */
        protected $recommended_replace_vars = [
            // Posts types.
            'page' => ['sitename', 'title', 'sep', 'primary_category'],
            'post' => ['sitename', 'title', 'sep', 'primary_category'],
            // Homepage.
            'homepage' => ['sitename', 'sitedesc', 'sep'],
            // Custom post type.
            'custom_post_type' => ['sitename', 'title', 'sep'],
            // Taxonomies.
            'category' => ['sitename', 'term_title', 'sep', 'term_hierarchy'],
            'post_tag' => ['sitename', 'term_title', 'sep'],
            'post_format' => ['sitename', 'term_title', 'sep', 'page'],
            // Custom taxonomy.
            'term-in-custom-taxomomy' => ['sitename', 'term_title', 'sep', 'term_hierarchy'],
            // Settings - archive pages.
            'author_archive' => ['sitename', 'title', 'sep', 'page'],
            'date_archive' => ['sitename', 'sep', 'date', 'page'],
            'custom-post-type_archive' => ['sitename', 'title', 'sep', 'page'],
            // Settings - special pages.
            'search' => ['sitename', 'searchphrase', 'sep', 'page'],
            '404' => ['sitename', 'sep'],
        ];
        /**
         * Determines the page type of the current term.
         *
         * @param string $taxonomy The taxonomy name.
         *
         * @return string The page type.
         */
        public function determine_for_term($taxonomy)
        {
        }
        /**
         * Determines the page type of the current post.
         *
         * @param WP_Post $post A WordPress post instance.
         *
         * @return string The page type.
         */
        public function determine_for_post($post)
        {
        }
        /**
         * Determines the page type for a post type.
         *
         * @param string $post_type The name of the post_type.
         * @param string $fallback  The page type to fall back to.
         *
         * @return string The page type.
         */
        public function determine_for_post_type($post_type, $fallback = 'custom_post_type')
        {
        }
        /**
         * Determines the page type for an archive page.
         *
         * @param string $name     The name of the archive.
         * @param string $fallback The page type to fall back to.
         *
         * @return string The page type.
         */
        public function determine_for_archive($name, $fallback = 'custom-post-type_archive')
        {
        }
        /**
         * Retrieves the recommended replacement variables for the given page type.
         *
         * @param string $page_type The page type.
         *
         * @return array The recommended replacement variables.
         */
        public function get_recommended_replacevars_for($page_type)
        {
        }
        /**
         * Retrieves the recommended replacement variables.
         *
         * @return array The recommended replacement variables.
         */
        public function get_recommended_replacevars()
        {
        }
        /**
         * Returns whether the given page type has recommended replace vars.
         *
         * @param array  $recommended_replace_vars The recommended replace vars
         *                                         to check in.
         * @param string $page_type                The page type to check.
         *
         * @return bool True if there are associated recommended replace vars.
         */
        private function has_recommended_replace_vars($recommended_replace_vars, $page_type)
        {
        }
        /**
         * Determines whether or not a post is the homepage.
         *
         * @param WP_Post $post The WordPress global post object.
         *
         * @return bool True if the given post is the homepage.
         */
        private function is_homepage($post)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     * @since   1.8.0
     */
    /**
     * Customizes user profile.
     */
    class WPSEO_Admin_User_Profile
    {
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Clear author sitemap cache when settings are changed.
         *
         * @since 3.1
         *
         * @param int    $meta_id   The ID of the meta option changed.
         * @param int    $object_id The ID of the user.
         * @param string $meta_key  The key of the meta field changed.
         */
        public function clear_author_sitemap_cache($meta_id, $object_id, $meta_key)
        {
        }
        /**
         * Filter POST variables.
         *
         * @param string $var_name Name of the variable to filter.
         *
         * @return mixed
         */
        private function filter_input_post($var_name)
        {
        }
        /**
         * Updates the user metas that (might) have been set on the user profile page.
         *
         * @param int $user_id User ID of the updated user.
         */
        public function process_user_option_update($user_id)
        {
        }
        /**
         * Add the inputs needed for SEO values to the User Profile page.
         *
         * @param WP_User $user User instance to output for.
         */
        public function user_profile($user)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents the utils for the admin.
     */
    class WPSEO_Admin_Utils
    {
        /**
         * Gets the install URL for the passed plugin slug.
         *
         * @param string $slug The slug to create an install link for.
         *
         * @return string The install URL. Empty string if the current user doesn't have the proper capabilities.
         */
        public static function get_install_url($slug)
        {
        }
        /**
         * Gets the activation URL for the passed plugin slug.
         *
         * @param string $slug The slug to create an activation link for.
         *
         * @return string The activation URL. Empty string if the current user doesn't have the proper capabilities.
         */
        public static function get_activation_url($slug)
        {
        }
        /**
         * Creates a link if the passed plugin is deemend a directly-installable plugin.
         *
         * @param array $plugin The plugin to create the link for.
         *
         * @return string The link to the plugin install. Returns the title if the plugin is deemed a Premium product.
         */
        public static function get_install_link($plugin)
        {
        }
        /**
         * Gets a visually hidden accessible message for links that open in a new browser tab.
         *
         * @return string The visually hidden accessible message.
         */
        public static function get_new_tab_message()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class that holds most of the admin functionality for Yoast SEO.
     */
    class WPSEO_Admin
    {
        /**
         * The page identifier used in WordPress to register the admin page.
         *
         * !DO NOT CHANGE THIS!
         *
         * @var string
         */
        const PAGE_IDENTIFIER = 'wpseo_dashboard';
        /**
         * Array of classes that add admin functionality.
         *
         * @var array
         */
        protected $admin_features;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Schedules a rewrite flush to happen at shutdown.
         */
        public function schedule_rewrite_flush()
        {
        }
        /**
         * Returns all the classes for the admin features.
         *
         * @return array
         */
        public function get_admin_features()
        {
        }
        /**
         * Register assets needed on admin pages.
         */
        public function enqueue_assets()
        {
        }
        /**
         * Returns the manage_options capability.
         *
         * @return string The capability to use.
         */
        public function get_manage_options_cap()
        {
        }
        /**
         * Maps the manage_options cap on saving an options page to wpseo_manage_options.
         */
        public function map_manage_options_cap()
        {
        }
        /**
         * Adds the ability to choose how many posts are displayed per page
         * on the bulk edit pages.
         */
        public function bulk_edit_options()
        {
        }
        /**
         * Saves the posts per page limit for bulk edit pages.
         *
         * @param int    $status Status value to pass through.
         * @param string $option Option name.
         * @param int    $value  Count value to check.
         *
         * @return int
         */
        public function save_bulk_edit_options($status, $option, $value)
        {
        }
        /**
         * Adds links to Premium Support and FAQ under the plugin in the plugin overview page.
         *
         * @param array  $links Array of links for the plugins, adapted when the current plugin is found.
         * @param string $file  The filename for the current plugin, which the filter loops through.
         *
         * @return array
         */
        public function add_action_link($links, $file)
        {
        }
        /**
         * Enqueues the (tiny) global JS needed for the plugin.
         */
        public function config_page_scripts()
        {
        }
        /**
         * Enqueues the (tiny) global stylesheet needed for the plugin.
         */
        public function enqueue_global_style()
        {
        }
        /**
         * Filter the $contactmethods array and add a set of social profiles.
         *
         * These are used with the Facebook author, rel="author" and Twitter cards implementation.
         *
         * @param array $contactmethods Currently set contactmethods.
         *
         * @return array Contactmethods with added contactmethods.
         */
        public function update_contactmethods($contactmethods)
        {
        }
        /**
         * Log the updated timestamp for user profiles when theme is changed.
         */
        public function switch_theme()
        {
        }
        /**
         * Localization for the dismiss urls.
         *
         * @return array
         */
        private function localize_admin_global_script()
        {
        }
        /**
         * Sets the upsell notice.
         */
        protected function set_upsell_notice()
        {
        }
        /**
         * Whether we are on the admin dashboard page.
         *
         * @return bool
         */
        protected function on_dashboard_page()
        {
        }
        /**
         * Loads the cornerstone filter.
         *
         * @return WPSEO_WordPress_Integration[] The integrations to initialize.
         */
        protected function initialize_cornerstone_content()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents a WPSEO asset
     */
    class WPSEO_Admin_Asset
    {
        /**
         * Constant used to identify file type as a JS file.
         *
         * @var string
         */
        const TYPE_JS = 'js';
        /**
         * Constant used to identify file type as a CSS file.
         *
         * @var string
         */
        const TYPE_CSS = 'css';
        /**
         * The name option identifier.
         *
         * @var string
         */
        const NAME = 'name';
        /**
         * The source option identifier.
         *
         * @var string
         */
        const SRC = 'src';
        /**
         * The dependencies option identifier.
         *
         * @var string
         */
        const DEPS = 'deps';
        /**
         * The version option identifier.
         *
         * @var string
         */
        const VERSION = 'version';
        /* Style specific. */
        /**
         * The media option identifier.
         *
         * @var string
         */
        const MEDIA = 'media';
        /**
         * The rtl option identifier.
         *
         * @var string
         */
        const RTL = 'rtl';
        /* Script specific. */
        /**
         * The "in footer" option identifier.
         *
         * @var string
         */
        const IN_FOOTER = 'in_footer';
        /**
         * Asset identifier.
         *
         * @var string
         */
        protected $name;
        /**
         * Path to the asset.
         *
         * @var string
         */
        protected $src;
        /**
         * Asset dependencies.
         *
         * @var string|array
         */
        protected $deps;
        /**
         * Asset version.
         *
         * @var string
         */
        protected $version;
        /**
         * For CSS Assets. The type of media for which this stylesheet has been defined.
         *
         * See https://www.w3.org/TR/CSS2/media.html#media-types.
         *
         * @var string
         */
        protected $media;
        /**
         * For JS Assets. Whether or not the script should be loaded in the footer.
         *
         * @var bool
         */
        protected $in_footer;
        /**
         * For CSS Assets. Whether this stylesheet is a right-to-left stylesheet.
         *
         * @var bool
         */
        protected $rtl;
        /**
         * File suffix.
         *
         * @var string
         */
        protected $suffix;
        /**
         * Default asset arguments.
         *
         * @var array
         */
        private $defaults = ['deps' => [], 'in_footer' => \true, 'rtl' => \true, 'media' => 'all', 'version' => '', 'suffix' => ''];
        /**
         * Constructs an instance of the WPSEO_Admin_Asset class.
         *
         * @param array $args The arguments for this asset.
         *
         * @throws InvalidArgumentException Throws when no name or src has been provided.
         */
        public function __construct(array $args)
        {
        }
        /**
         * Returns the asset identifier.
         *
         * @return string
         */
        public function get_name()
        {
        }
        /**
         * Returns the path to the asset.
         *
         * @return string
         */
        public function get_src()
        {
        }
        /**
         * Returns the asset dependencies.
         *
         * @return array|string
         */
        public function get_deps()
        {
        }
        /**
         * Returns the asset version.
         *
         * @return string|null
         */
        public function get_version()
        {
        }
        /**
         * Returns the media type for CSS assets.
         *
         * @return string
         */
        public function get_media()
        {
        }
        /**
         * Returns whether a script asset should be loaded in the footer of the page.
         *
         * @return bool
         */
        public function is_in_footer()
        {
        }
        /**
         * Returns whether this CSS has a RTL counterpart.
         *
         * @return bool
         */
        public function has_rtl()
        {
        }
        /**
         * Returns the file suffix.
         *
         * @return string
         */
        public function get_suffix()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Bulk Editor
     * @since   1.5.0
     */
    /**
     * Implements table for bulk editing.
     */
    class WPSEO_Bulk_List_Table extends \WP_List_Table
    {
        /**
         * The nonce that was passed with the request.
         *
         * @var string
         */
        private $nonce;
        /**
         * Array of post types for which the current user has `edit_others_posts` capabilities.
         *
         * @var array
         */
        private $all_posts;
        /**
         * Array of post types for which the current user has `edit_posts` capabilities, but not `edit_others_posts`.
         *
         * @var array
         */
        private $own_posts;
        /**
         * Saves all the metadata into this array.
         *
         * @var array
         */
        protected $meta_data = [];
        /**
         * The current requested page_url.
         *
         * @var string
         */
        private $request_url = '';
        /**
         * The current page (depending on $_GET['paged']) if current tab is for current page_type, else it will be 1.
         *
         * @var int
         */
        private $current_page;
        /**
         * The current post filter, if is used (depending on $_GET['post_type_filter']).
         *
         * @var string
         */
        private $current_filter;
        /**
         * The current post status, if is used (depending on $_GET['post_status']).
         *
         * @var string
         */
        private $current_status;
        /**
         * The current sorting, if used (depending on $_GET['order'] and $_GET['orderby']).
         *
         * @var string
         */
        private $current_order;
        /**
         * The page_type for current class instance (for example: title / description).
         *
         * @var string
         */
        protected $page_type;
        /**
         * Based on the page_type ($this->page_type) there will be constructed an url part, for subpages and
         * navigation.
         *
         * @var string
         */
        protected $page_url;
        /**
         * The settings which will be used in the __construct.
         *
         * @var array
         */
        protected $settings;
        /**
         * Holds the pagination config.
         *
         * @var array
         */
        protected $pagination = [];
        /**
         * Holds the sanitized data from the user input.
         *
         * @var array
         */
        protected $input_fields = [];
        /**
         * Class constructor.
         *
         * @param array $args The arguments.
         */
        public function __construct($args = [])
        {
        }
        /**
         * Prepares the data and renders the page.
         */
        public function show_page()
        {
        }
        /**
         * Used in the constructor to build a reference list of post types the current user can edit.
         */
        protected function populate_editable_post_types()
        {
        }
        /**
         * Will show the navigation for the table like pagenavigation and pagefilter.
         *
         * @param string $which Table nav location (such as top).
         */
        public function display_tablenav($which)
        {
        }
        /**
         * This function builds the base sql subquery used in this class.
         *
         * This function takes into account the post types in which the current user can
         * edit all posts, and the ones the current user can only edit his/her own.
         *
         * @return string The subquery, which should always be used in $wpdb->prepare(),
         *                passing the current user_id in as the first parameter.
         */
        public function get_base_subquery()
        {
        }
        /**
         * Gets the views.
         *
         * @return array The views.
         */
        public function get_views()
        {
        }
        /**
         * Outputs extra table navigation.
         *
         * @param string $which Table nav location (such as top).
         */
        public function extra_tablenav($which)
        {
        }
        /**
         * Gets a list of sortable columns.
         *
         * The format is: 'internal-name' => array( 'orderby', bool ).
         *
         * @return array
         */
        public function get_sortable_columns()
        {
        }
        /**
         * Sets the correct pagenumber and pageurl for the navigation.
         */
        public function prepare_page_navigation()
        {
        }
        /**
         * Preparing the requested pagerows and setting the needed variables.
         */
        public function prepare_items()
        {
        }
        /**
         * Getting the columns for first row.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Setting the column headers.
         */
        protected function set_column_headers()
        {
        }
        /**
         * Counting total items.
         *
         * @param string $subquery         SQL FROM part.
         * @param string $all_states       SQL IN part.
         * @param string $post_type_clause SQL post type part.
         *
         * @return mixed
         */
        protected function count_items($subquery, $all_states, $post_type_clause)
        {
        }
        /**
         * Getting the post_type_clause filter.
         *
         * @return string
         */
        protected function get_post_type_clause()
        {
        }
        /**
         * Setting the pagination.
         *
         * Total items is the number of all visible items.
         *
         * @param int $total_items Total items counts.
         */
        protected function set_pagination($total_items)
        {
        }
        /**
         * Parse the query to get items from database.
         *
         * Based on given parameters there will be parse a query which will get all the pages/posts and other post_types
         * from the database.
         *
         * @param string $subquery         SQL FROM part.
         * @param string $all_states       SQL IN part.
         * @param string $post_type_clause SQL post type part.
         *
         * @return string
         */
        protected function parse_item_query($subquery, $all_states, $post_type_clause)
        {
        }
        /**
         * Heavily restricts the possible columns by which a user can order the table
         * in the bulk editor, thereby preventing a possible CSRF vulnerability.
         *
         * @param string $orderby The column by which we want to order.
         *
         * @return string
         */
        protected function sanitize_orderby($orderby)
        {
        }
        /**
         * Makes sure the order clause is always ASC or DESC for the bulk editor table,
         * thereby preventing a possible CSRF vulnerability.
         *
         * @param string $order Whether we want to sort ascending or descending.
         *
         * @return string SQL order string (ASC, DESC).
         */
        protected function sanitize_order($order)
        {
        }
        /**
         * Getting all the items.
         *
         * @param string $query SQL query to use.
         */
        protected function get_items($query)
        {
        }
        /**
         * Getting all the states.
         *
         * @return string
         */
        protected function get_all_states()
        {
        }
        /**
         * Based on $this->items and the defined columns, the table rows will be displayed.
         */
        public function display_rows()
        {
        }
        /**
         * Getting the attributes for each table cell.
         *
         * @param string $column_name         Column name string.
         * @param array  $hidden              Set of hidden columns.
         * @param string $classes             Additional CSS classes.
         * @param string $column_display_name Column display name string.
         *
         * @return string
         */
        protected function column_attributes($column_name, $hidden, $classes, $column_display_name)
        {
        }
        /**
         * Parsing the title.
         *
         * @param WP_Post $rec Post object.
         *
         * @return string
         */
        protected function parse_page_title_column($rec)
        {
        }
        /**
         * Parsing the column based on the $column_name.
         *
         * @param string  $column_name Column name.
         * @param WP_Post $rec         Post object.
         *
         * @return string
         */
        protected function parse_column($column_name, $rec)
        {
        }
        /**
         * Parse the field where the existing meta-data value is displayed.
         *
         * @param int        $record_id  Record ID.
         * @param string     $attributes HTML attributes.
         * @param bool|array $values     Optional values data array.
         *
         * @return string
         */
        protected function parse_meta_data_field($record_id, $attributes, $values = \false)
        {
        }
        /**
         * Method for setting the meta data, which belongs to the records that will be shown on the current page.
         *
         * This method will loop through the current items ($this->items) for getting the post_id. With this data
         * ($needed_ids) the method will query the meta-data table for getting the title.
         */
        protected function get_meta_data()
        {
        }
        /**
         * Getting all post_ids from to $this->items.
         *
         * @return array
         */
        protected function get_post_ids()
        {
        }
        /**
         * Getting the meta_data from database.
         *
         * @param array $post_ids Post IDs for SQL IN part.
         *
         * @return mixed
         */
        protected function get_meta_data_result(array $post_ids)
        {
        }
        /**
         * Setting $this->meta_data.
         *
         * @param array $meta_data Meta data set.
         */
        protected function parse_meta_data($meta_data)
        {
        }
        /**
         * This method will merge general array with given parameter $columns.
         *
         * @param array $columns Optional columns set.
         *
         * @return array
         */
        protected function merge_columns($columns = [])
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Bulk Editor
     * @since   1.5.0
     */
    /**
     * Implements table for bulk description editing.
     */
    class WPSEO_Bulk_Description_List_Table extends \WPSEO_Bulk_List_Table
    {
        /**
         * Current type for this class will be (meta) description.
         *
         * @var string
         */
        protected $page_type = 'description';
        /**
         * Settings with are used in __construct.
         *
         * @var array
         */
        protected $settings = ['singular' => 'wpseo_bulk_description', 'plural' => 'wpseo_bulk_descriptions', 'ajax' => \true];
        /**
         * The field in the database where meta field is saved.
         *
         * @var string
         */
        protected $target_db_field = 'metadesc';
        /**
         * The columns shown on the table.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Parse the metadescription.
         *
         * @param string $column_name Column name.
         * @param object $record      Data object.
         * @param string $attributes  HTML attributes.
         *
         * @return string
         */
        protected function parse_page_specific_column($column_name, $record, $attributes)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Bulk Editor
     * @since   1.5.0
     */
    /**
     * Implements table for bulk title editing.
     */
    class WPSEO_Bulk_Title_Editor_List_Table extends \WPSEO_Bulk_List_Table
    {
        /**
         * Current type for this class will be title.
         *
         * @var string
         */
        protected $page_type = 'title';
        /**
         * Settings with are used in __construct.
         *
         * @var array
         */
        protected $settings = ['singular' => 'wpseo_bulk_title', 'plural' => 'wpseo_bulk_titles', 'ajax' => \true];
        /**
         * The field in the database where meta field is saved.
         *
         * @var string
         */
        protected $target_db_field = 'title';
        /**
         * The columns shown on the table.
         *
         * @return array
         */
        public function get_columns()
        {
        }
        /**
         * Parse the title columns.
         *
         * @param string $column_name Column name.
         * @param object $record      Data object.
         * @param string $attributes  HTML attributes.
         *
         * @return string
         */
        protected function parse_page_specific_column($column_name, $record, $attributes)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Collects the data from the added collection objects.
     */
    class WPSEO_Collector
    {
        /**
         * Holds the collections.
         *
         * @var WPSEO_Collection[]
         */
        protected $collections = [];
        /**
         * Adds a collection object to the collections.
         *
         * @param WPSEO_Collection $collection The collection object to add.
         */
        public function add_collection(\WPSEO_Collection $collection)
        {
        }
        /**
         * Collects the data from the collection objects.
         *
         * @return array The collected data.
         */
        public function collect()
        {
        }
        /**
         * Returns the collected data as a JSON encoded string.
         *
         * @return false|string The encode string.
         */
        public function get_as_json()
        {
        }
    }
    /**
     * Class WPSEO_Admin_Pages.
     *
     * Class with functionality for the Yoast SEO admin pages.
     */
    class WPSEO_Admin_Pages
    {
        /**
         * The option in use for the current admin page.
         *
         * @var string
         */
        public $currentoption = 'wpseo';
        /**
         * Holds the asset manager.
         *
         * @var WPSEO_Admin_Asset_Manager
         */
        private $asset_manager;
        /**
         * Class constructor, which basically only hooks the init function on the init hook.
         */
        public function __construct()
        {
        }
        /**
         * Make sure the needed scripts are loaded for admin pages.
         */
        public function init()
        {
        }
        /**
         * Loads the required styles for the config page.
         */
        public function config_page_styles()
        {
        }
        /**
         * Loads the required scripts for the config page.
         */
        public function config_page_scripts()
        {
        }
        /**
         * Retrieves some variables that are needed for replacing variables in JS.
         *
         * @return array The replacement and recommended replacement variables.
         */
        public function get_replace_vars_script_data()
        {
        }
        /**
         * Determines whether the Local SEO upsell should be shown.
         *
         * The Local SEO upsell should:
         * - Only be shown in Free, not when Premium is active.
         * - Not be shown when Local SEO is active.
         *
         * @return bool Whether the Local SEO upsell should be shown.
         */
        private function should_show_local_seo_upsell()
        {
        }
        /**
         * Enqueues and handles all the tool dependencies.
         */
        private function enqueue_tools_scripts()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Customizer
     */
    /**
     * Class with functionality to support WP SEO settings in WordPress Customizer.
     */
    class WPSEO_Customizer
    {
        /**
         * Holds the customize manager.
         *
         * @var WP_Customize_Manager
         */
        protected $wp_customize;
        /**
         * Template for the setting IDs used for the customizer.
         *
         * @var string
         */
        private $setting_template = 'wpseo_titles[%s]';
        /**
         * Default arguments for the breadcrumbs customizer settings object.
         *
         * @var array
         */
        private $default_setting_args = ['default' => '', 'type' => 'option', 'transport' => 'refresh'];
        /**
         * Default arguments for the breadcrumbs customizer control object.
         *
         * @var array
         */
        private $default_control_args = ['label' => '', 'type' => 'text', 'section' => 'wpseo_breadcrumbs_customizer_section', 'settings' => '', 'context' => ''];
        /**
         * Construct Method.
         */
        public function __construct()
        {
        }
        /**
         * Function to support WordPress Customizer.
         *
         * @param WP_Customize_Manager $wp_customize Manager class instance.
         */
        public function wpseo_customize_register($wp_customize)
        {
        }
        /**
         * Add the breadcrumbs section to the customizer.
         */
        private function breadcrumbs_section()
        {
        }
        /**
         * Returns whether or not the breadcrumbs are active.
         *
         * @return bool
         */
        public function breadcrumbs_active_callback()
        {
        }
        /**
         * Adds the breadcrumbs show blog checkbox.
         */
        private function breadcrumbs_blog_show_setting()
        {
        }
        /**
         * Returns whether or not to show the breadcrumbs blog show option.
         *
         * @return bool
         */
        public function breadcrumbs_blog_show_active_cb()
        {
        }
        /**
         * Adds the breadcrumbs separator text field.
         */
        private function breadcrumbs_separator_setting()
        {
        }
        /**
         * Adds the breadcrumbs home anchor text field.
         */
        private function breadcrumbs_home_setting()
        {
        }
        /**
         * Adds the breadcrumbs prefix text field.
         */
        private function breadcrumbs_prefix_setting()
        {
        }
        /**
         * Adds the breadcrumbs archive prefix text field.
         */
        private function breadcrumbs_archiveprefix_setting()
        {
        }
        /**
         * Adds the breadcrumbs search prefix text field.
         */
        private function breadcrumbs_searchprefix_setting()
        {
        }
        /**
         * Adds the breadcrumb 404 prefix text field.
         */
        private function breadcrumbs_404_setting()
        {
        }
        /**
         * Adds the customizer setting and control.
         *
         * @param string      $index           Array key index to use for the customizer setting.
         * @param array       $control_args    Customizer control object arguments.
         *                                     Only those different from the default need to be passed.
         * @param string|null $id              Optional. Customizer control object ID.
         *                                     Will default to 'wpseo-' . $index.
         * @param array       $custom_settings Optional. Customizer setting arguments.
         *                                     Only those different from the default need to be passed.
         */
        private function add_setting_and_control($index, $control_args, $id = \null, $custom_settings = [])
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents the proxy for communicating with the database.
     */
    class WPSEO_Database_Proxy
    {
        /**
         * Holds the table name.
         *
         * @var string
         */
        protected $table_name;
        /**
         * Determines whether to suppress errors or not.
         *
         * @var bool
         */
        protected $suppress_errors = \true;
        /**
         * Determines if this table is multisite.
         *
         * @var bool
         */
        protected $is_multisite_table = \false;
        /**
         * Holds the last suppressed state.
         *
         * @var bool
         */
        protected $last_suppressed_state;
        /**
         * Holds the WordPress database object.
         *
         * @var wpdb
         */
        protected $database;
        /**
         * Sets the class attributes and registers the table.
         *
         * @param wpdb   $database           The database object.
         * @param string $table_name         The table name that is represented.
         * @param bool   $suppress_errors    Should the errors be suppressed.
         * @param bool   $is_multisite_table Should the table be global in multisite.
         */
        public function __construct($database, $table_name, $suppress_errors = \true, $is_multisite_table = \false)
        {
        }
        /**
         * Inserts data into the database.
         *
         * @param array $data   Data to insert.
         * @param null  $format Formats for the data.
         *
         * @return false|int Total amount of inserted rows or false on error.
         */
        public function insert(array $data, $format = \null)
        {
        }
        /**
         * Updates data in the database.
         *
         * @param array $data         Data to update on the table.
         * @param array $where        Where condition as key => value array.
         * @param null  $format       Optional. Data prepare format.
         * @param null  $where_format Optional. Where prepare format.
         *
         * @return false|int False when the update request is invalid, int on number of rows changed.
         */
        public function update(array $data, array $where, $format = \null, $where_format = \null)
        {
        }
        /**
         * Upserts data in the database.
         *
         * Performs an insert into and if key is duplicate it will update the existing record.
         *
         * @param array      $data         Data to update on the table.
         * @param array|null $where        Unused. Where condition as key => value array.
         * @param null       $format       Optional. Data prepare format.
         * @param null       $where_format Deprecated. Where prepare format.
         *
         * @return false|int False when the upsert request is invalid, int on number of rows changed.
         */
        public function upsert(array $data, array $where = \null, $format = \null, $where_format = \null)
        {
        }
        /**
         * Deletes a record from the database.
         *
         * @param array      $where  Where clauses for the query.
         * @param array|null $format Formats for the data.
         *
         * @return false|int
         */
        public function delete(array $where, $format = \null)
        {
        }
        /**
         * Executes the given query and returns the results.
         *
         * @param string $query The query to execute.
         *
         * @return array|object|null The resultset
         */
        public function get_results($query)
        {
        }
        /**
         * Creates a table to the database.
         *
         * @param array $columns The columns to create.
         * @param array $indexes The indexes to use.
         *
         * @return bool True when creation is successful.
         */
        public function create_table(array $columns, array $indexes = [])
        {
        }
        /**
         * Checks if there is an error.
         *
         * @return bool Returns true when there is an error.
         */
        public function has_error()
        {
        }
        /**
         * Executed before a query will be ran.
         */
        protected function pre_execution()
        {
        }
        /**
         * Executed after a query has been ran.
         */
        protected function post_execution()
        {
        }
        /**
         * Returns the full table name.
         *
         * @return string Full table name including prefix.
         */
        public function get_table_name()
        {
        }
        /**
         * Returns the prefix to use for the table.
         *
         * @return string The table prefix depending on the database context.
         */
        protected function get_table_prefix()
        {
        }
        /**
         * Registers the table with WordPress.
         *
         * @return void
         */
        protected function register_table()
        {
        }
        /**
         * Checks if the table has been registered with WordPress.
         *
         * @return bool True if the table is registered, false otherwise.
         */
        protected function is_table_registered()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Export
     */
    /**
     * Class WPSEO_Export.
     *
     * Class with functionality to export the WP SEO settings.
     */
    class WPSEO_Export
    {
        /**
         * Holds the nonce action.
         *
         * @var string
         */
        const NONCE_ACTION = 'wpseo_export';
        /**
         * Holds the export data.
         *
         * @var string
         */
        private $export = '';
        /**
         * Holds whether the export was a success.
         *
         * @var bool
         */
        public $success;
        /**
         * Handles the export request.
         */
        public function export()
        {
        }
        /**
         * Outputs the export.
         */
        public function output()
        {
        }
        /**
         * Exports the current site's WP SEO settings.
         */
        private function export_settings()
        {
        }
        /**
         * Writes the header of the export.
         */
        private function export_header()
        {
        }
        /**
         * Writes a line to the export.
         *
         * @param string $line          Line string.
         * @param bool   $newline_first Boolean flag whether to prepend with new line.
         */
        private function write_line($line, $newline_first = \false)
        {
        }
        /**
         * Writes an entire option group to the export.
         *
         * @param string $opt_group Option group name.
         */
        private function write_opt_group($opt_group)
        {
        }
        /**
         * Writes a settings line to the export.
         *
         * @param string $key Key string.
         * @param string $val Value string.
         */
        private function write_setting($key, $val)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Exposes shortlinks in a global, so that we can pass them to our Javascript components.
     */
    class WPSEO_Expose_Shortlinks implements \WPSEO_WordPress_Integration
    {
        /**
         * Array containing the keys and shortlinks.
         *
         * @var array
         */
        private $shortlinks = ['shortlinks.advanced.allow_search_engines' => 'https://yoa.st/allow-search-engines', 'shortlinks.advanced.follow_links' => 'https://yoa.st/follow-links', 'shortlinks.advanced.meta_robots' => 'https://yoa.st/meta-robots-advanced', 'shortlinks.advanced.breadcrumbs_title' => 'https://yoa.st/breadcrumbs-title', 'shortlinks.metabox.schema.explanation' => 'https://yoa.st/400', 'shortlinks.metabox.schema.page_type' => 'https://yoa.st/402', 'shortlinks.sidebar.schema.explanation' => 'https://yoa.st/401', 'shortlinks.sidebar.schema.page_type' => 'https://yoa.st/403', 'shortlinks.focus_keyword_info' => 'https://yoa.st/focus-keyword', 'shortlinks.nofollow_sponsored' => 'https://yoa.st/nofollow-sponsored', 'shortlinks.snippet_preview_info' => 'https://yoa.st/snippet-preview', 'shortlinks.cornerstone_content_info' => 'https://yoa.st/1i9', 'shortlinks.upsell.social_previews' => 'https://yoa.st/social-preview-cta', 'shortlinks.upsell.sidebar.focus_keyword_synonyms_link' => 'https://yoa.st/textlink-synonyms-popup-sidebar', 'shortlinks.upsell.sidebar.focus_keyword_synonyms_button' => 'https://yoa.st/keyword-synonyms-popup-sidebar', 'shortlinks.upsell.sidebar.focus_keyword_additional_link' => 'https://yoa.st/textlink-keywords-popup-sidebar', 'shortlinks.upsell.sidebar.focus_keyword_additional_button' => 'https://yoa.st/add-keywords-popup-sidebar', 'shortlinks.upsell.sidebar.additional_link' => 'https://yoa.st/textlink-keywords-sidebar', 'shortlinks.upsell.sidebar.additional_button' => 'https://yoa.st/add-keywords-sidebar', 'shortlinks.upsell.metabox.go_premium' => 'https://yoa.st/pe-premium-page', 'shortlinks.upsell.metabox.focus_keyword_synonyms_link' => 'https://yoa.st/textlink-synonyms-popup-metabox', 'shortlinks.upsell.metabox.focus_keyword_synonyms_button' => 'https://yoa.st/keyword-synonyms-popup', 'shortlinks.upsell.metabox.focus_keyword_additional_link' => 'https://yoa.st/textlink-keywords-popup-metabox', 'shortlinks.upsell.metabox.focus_keyword_additional_button' => 'https://yoa.st/add-keywords-popup', 'shortlinks.upsell.metabox.additional_link' => 'https://yoa.st/textlink-keywords-metabox', 'shortlinks.upsell.metabox.additional_button' => 'https://yoa.st/add-keywords-metabox', 'shortlinks.upsell.gsc.create_redirect_button' => 'https://yoa.st/redirects', 'shortlinks.readability_analysis_info' => 'https://yoa.st/readability-analysis', 'shortlinks.activate_premium_info' => 'https://yoa.st/activate-subscription', 'shortlinks.upsell.sidebar.morphology_upsell_metabox' => 'https://yoa.st/morphology-upsell-metabox', 'shortlinks.upsell.sidebar.morphology_upsell_sidebar' => 'https://yoa.st/morphology-upsell-sidebar', 'shortlinks.semrush.volume_help' => 'https://yoa.st/3-v', 'shortlinks.semrush.trend_help' => 'https://yoa.st/3-v', 'shortlinks.semrush.prices' => 'https://yoa.st/semrush-prices', 'shortlinks.semrush.premium_landing_page' => 'https://yoa.st/413'];
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Adds shortlinks to the passed array.
         *
         * @param array $input The array to add shortlinks to.
         *
         * @return array The passed array with the additional shortlinks.
         */
        public function expose_shortlinks($input)
        {
        }
        /**
         * Retrieves the shortlinks.
         *
         * @return array The shortlinks.
         */
        private function get_shortlinks()
        {
        }
        /**
         * Checks if the current page is a term edit page.
         *
         * @return bool True when page is term edit.
         */
        private function is_term_edit()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Gutenberg_Compatibility
     */
    /**
     * Class WPSEO_Gutenberg_Compatibility
     */
    class WPSEO_Gutenberg_Compatibility
    {
        /**
         * The currently released version of Gutenberg.
         *
         * @var string
         */
        const CURRENT_RELEASE = '11.5.0';
        /**
         * The minimally supported version of Gutenberg by the plugin.
         *
         * @var string
         */
        const MINIMUM_SUPPORTED = '11.5.0';
        /**
         * Holds the current version.
         *
         * @var string
         */
        protected $current_version;
        /**
         * WPSEO_Gutenberg_Compatibility constructor.
         */
        public function __construct()
        {
        }
        /**
         * Determines whether or not Gutenberg is installed.
         *
         * @return bool Whether or not Gutenberg is installed.
         */
        public function is_installed()
        {
        }
        /**
         * Determines whether or not the currently installed version of Gutenberg is below the minimum supported version.
         *
         * @return bool True if the currently installed version is below the minimum supported version. False otherwise.
         */
        public function is_below_minimum()
        {
        }
        /**
         * Gets the currently installed version.
         *
         * @return string The currently installed version.
         */
        public function get_installed_version()
        {
        }
        /**
         * Determines whether or not the currently installed version of Gutenberg is the latest, fully compatible version.
         *
         * @return bool Whether or not the currently installed version is fully compatible.
         */
        public function is_fully_compatible()
        {
        }
        /**
         * Gets the latest released version of Gutenberg.
         *
         * @return string The latest release.
         */
        protected function get_latest_release()
        {
        }
        /**
         * Gets the minimum supported version of Gutenberg.
         *
         * @return string The minumum supported release.
         */
        protected function get_minimum_supported_version()
        {
        }
        /**
         * Detects the currently installed Gutenberg version.
         *
         * @return string The currently installed Gutenberg version. Empty if the version couldn't be detected.
         */
        protected function detect_installed_gutenberg_version()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_HelpScout
     */
    class WPSEO_HelpScout implements \WPSEO_WordPress_Integration
    {
        /**
         * The id for the beacon.
         *
         * @var string
         */
        protected $beacon_id;
        /**
         * The pages where the beacon is loaded.
         *
         * @var array
         */
        protected $pages;
        /**
         * The products the beacon is loaded for.
         *
         * @var array
         */
        protected $products;
        /**
         * Whether to asks the user's consent before loading in HelpScout.
         *
         * @var bool
         */
        protected $ask_consent;
        /**
         * WPSEO_HelpScout constructor.
         *
         * @param string $beacon_id   The beacon id.
         * @param array  $pages       The pages where the beacon is loaded.
         * @param array  $products    The products the beacon is loaded for.
         * @param bool   $ask_consent Optional. Whether to ask for consent before loading in HelpScout.
         */
        public function __construct($beacon_id, array $pages, array $products, $ask_consent = \false)
        {
        }
        /**
         * {@inheritDoc}
         */
        public function register_hooks()
        {
        }
        /**
         * Enqueues the HelpScout script.
         */
        public function enqueue_help_scout_script()
        {
        }
        /**
         * Outputs a small piece of javascript for the beacon.
         */
        public function output_beacon_js()
        {
        }
        /**
         * Checks if the current page is a page containing the beacon.
         *
         * @return bool
         */
        private function is_beacon_page()
        {
        }
        /**
         * Retrieves the value of the current page.
         *
         * @return string The current page.
         */
        private function get_current_page()
        {
        }
        /**
         * Retrieves the identifying data.
         *
         * @return string The data to pass as identifying data.
         */
        protected function get_session_data()
        {
        }
        /**
         * Returns basic info about the server software.
         *
         * @return string
         */
        private function get_server_info()
        {
        }
        /**
         * Returns info about the Yoast SEO plugin version and license.
         *
         * @param object $plugin The plugin.
         *
         * @return string The product info.
         */
        private function get_product_info($plugin)
        {
        }
        /**
         * Returns the WordPress version + a suffix if current WP is multi site.
         *
         * @return string The WordPress version string.
         */
        private function get_wordpress_version()
        {
        }
        /**
         * Returns a formatted HTML string for the current theme.
         *
         * @return string The theme info as string.
         */
        private function get_theme_info()
        {
        }
        /**
         * Returns a formatted HTML list of all active plugins.
         *
         * @return string The active plugins.
         */
        private function get_active_plugins()
        {
        }
    }
    /**
     * Class WPSEO_Meta_Columns.
     */
    class WPSEO_Meta_Columns
    {
        /**
         * Holds the context objects for each indexable.
         *
         * @var Meta_Tags_Context[]
         */
        protected $context = [];
        /**
         * Holds the SEO analysis.
         *
         * @var WPSEO_Metabox_Analysis_SEO
         */
        private $analysis_seo;
        /**
         * Holds the readability analysis.
         *
         * @var WPSEO_Metabox_Analysis_Readability
         */
        private $analysis_readability;
        /**
         * Admin columns cache.
         *
         * @var Admin_Columns_Cache_Integration
         */
        private $admin_columns_cache;
        /**
         * When page analysis is enabled, just initialize the hooks.
         */
        public function __construct()
        {
        }
        /**
         * Sets up up the hooks.
         */
        public function setup_hooks()
        {
        }
        /**
         * Adds the column headings for the SEO plugin for edit posts / pages overview.
         *
         * @param array $columns Already existing columns.
         *
         * @return array Array containing the column headings.
         */
        public function column_heading($columns)
        {
        }
        /**
         * Displays the column content for the given column.
         *
         * @param string $column_name Column to display the content for.
         * @param int    $post_id     Post to display the column content for.
         */
        public function column_content($column_name, $post_id)
        {
        }
        /**
         * Indicates which of the SEO columns are sortable.
         *
         * @param array $columns Appended with their orderby variable.
         *
         * @return array Array containing the sortable columns.
         */
        public function column_sort($columns)
        {
        }
        /**
         * Hides the SEO title, meta description and focus keyword columns if the user hasn't chosen which columns to hide.
         *
         * @param array $hidden The hidden columns.
         *
         * @return array Array containing the columns to hide.
         */
        public function column_hidden($hidden)
        {
        }
        /**
         * Adds a dropdown that allows filtering on the posts SEO Quality.
         */
        public function posts_filter_dropdown()
        {
        }
        /**
         * Adds a dropdown that allows filtering on the posts Readability Quality.
         *
         * @return void
         */
        public function posts_filter_dropdown_readability()
        {
        }
        /**
         * Generates an <option> element.
         *
         * @param string $value    The option's value.
         * @param string $label    The option's label.
         * @param string $selected HTML selected attribute for an option.
         *
         * @return string The generated <option> element.
         */
        protected function generate_option($value, $label, $selected = '')
        {
        }
        /**
         * Returns the meta object for a given post ID.
         *
         * @param int $post_id The post ID.
         *
         * @return Meta The meta object.
         */
        protected function get_meta($post_id)
        {
        }
        /**
         * Determines the SEO score filter to be later used in the meta query, based on the passed SEO filter.
         *
         * @param string $seo_filter The SEO filter to use to determine what further filter to apply.
         *
         * @return array The SEO score filter.
         */
        protected function determine_seo_filters($seo_filter)
        {
        }
        /**
         * Determines the Readability score filter to the meta query, based on the passed Readability filter.
         *
         * @param string $readability_filter The Readability filter to use to determine what further filter to apply.
         *
         * @return array The Readability score filter.
         */
        protected function determine_readability_filters($readability_filter)
        {
        }
        /**
         * Creates a keyword filter for the meta query, based on the passed Keyword filter.
         *
         * @param string $keyword_filter The keyword filter to use.
         *
         * @return array The keyword filter.
         */
        protected function get_keyword_filter($keyword_filter)
        {
        }
        /**
         * Determines whether the passed filter is considered to be valid.
         *
         * @param mixed $filter The filter to check against.
         *
         * @return bool Whether or not the filter is considered valid.
         */
        protected function is_valid_filter($filter)
        {
        }
        /**
         * Collects the filters and merges them into a single array.
         *
         * @return array Array containing all the applicable filters.
         */
        protected function collect_filters()
        {
        }
        /**
         * Modify the query based on the filters that are being passed.
         *
         * @param array $vars Query variables that need to be modified based on the filters.
         *
         * @return array Array containing the meta query to use for filtering the posts overview.
         */
        public function column_sort_orderby($vars)
        {
        }
        /**
         * Retrieves the meta robots query values to be used within the meta query.
         *
         * @return array Array containing the query parameters regarding meta robots.
         */
        protected function get_meta_robots_query_values()
        {
        }
        /**
         * Determines the score filters to be used. If more than one is passed, it created an AND statement for the query.
         *
         * @param array $score_filters Array containing the score filters.
         *
         * @return array Array containing the score filters that need to be applied to the meta query.
         */
        protected function determine_score_filters($score_filters)
        {
        }
        /**
         * Retrieves the post type from the $_GET variable.
         *
         * @return string The current post type.
         */
        public function get_current_post_type()
        {
        }
        /**
         * Retrieves the SEO filter from the $_GET variable.
         *
         * @return string The current post type.
         */
        public function get_current_seo_filter()
        {
        }
        /**
         * Retrieves the Readability filter from the $_GET variable.
         *
         * @return string The current post type.
         */
        public function get_current_readability_filter()
        {
        }
        /**
         * Retrieves the keyword filter from the $_GET variable.
         *
         * @return string The current post type.
         */
        public function get_current_keyword_filter()
        {
        }
        /**
         * Uses the vars to create a complete filter query that can later be executed to filter out posts.
         *
         * @param array $vars    Array containing the variables that will be used in the meta query.
         * @param array $filters Array containing the filters that we need to apply in the meta query.
         *
         * @return array Array containing the complete filter query.
         */
        protected function build_filter_query($vars, $filters)
        {
        }
        /**
         * Creates a Readability score filter.
         *
         * @param number $low  The lower boundary of the score.
         * @param number $high The higher boundary of the score.
         *
         * @return array The Readability Score filter.
         */
        protected function create_readability_score_filter($low, $high)
        {
        }
        /**
         * Creates an SEO score filter.
         *
         * @param number $low  The lower boundary of the score.
         * @param number $high The higher boundary of the score.
         *
         * @return array The SEO score filter.
         */
        protected function create_seo_score_filter($low, $high)
        {
        }
        /**
         * Creates a filter to retrieve posts that were set to no-index.
         *
         * @return array Array containin the no-index filter.
         */
        protected function create_no_index_filter()
        {
        }
        /**
         * Creates a filter to retrieve posts that have no keyword set.
         *
         * @return array Array containing the no focus keyword filter.
         */
        protected function create_no_focus_keyword_filter()
        {
        }
        /**
         * Determines whether a particular post_id is of an indexable post type.
         *
         * @param string $post_id The post ID to check.
         *
         * @return bool Whether or not it is indexable.
         */
        protected function is_indexable($post_id)
        {
        }
        /**
         * Determines whether the given post ID uses the default indexing settings.
         *
         * @param int $post_id The post ID to check.
         *
         * @return bool Whether or not the default indexing is being used for the post.
         */
        protected function uses_default_indexing($post_id)
        {
        }
        /**
         * Returns filters when $order_by is matched in the if-statement.
         *
         * @param string $order_by The ID of the column by which to order the posts.
         *
         * @return array Array containing the order filters.
         */
        private function filter_order_by($order_by)
        {
        }
        /**
         * Parses the score column.
         *
         * @param int $post_id The ID of the post for which to show the score.
         *
         * @return string The HTML for the SEO score indicator.
         */
        private function parse_column_score($post_id)
        {
        }
        /**
         * Parsing the readability score column.
         *
         * @param int $post_id The ID of the post for which to show the readability score.
         *
         * @return string The HTML for the readability score indicator.
         */
        private function parse_column_score_readability($post_id)
        {
        }
        /**
         * Sets up the hooks for the post_types.
         */
        private function set_post_type_hooks()
        {
        }
        /**
         * Wraps the WPSEO_Metabox check to determine whether the metabox should be displayed either by
         * choice of the admin or because the post type is not a public post type.
         *
         * @since 7.0
         *
         * @param string|null $post_type Optional. The post type to test, defaults to the current post post_type.
         *
         * @return bool Whether or not the meta box (and associated columns etc) should be hidden.
         */
        private function display_metabox($post_type = \null)
        {
        }
        /**
         * Renders the score indicator.
         *
         * @param WPSEO_Rank $rank  The rank this indicator should have.
         * @param string     $title Optional. The title for this rank, defaults to the title of the rank.
         *
         * @return string The HTML for a score indicator.
         */
        private function render_score_indicator($rank, $title = '')
        {
        }
        /**
         * Determines whether or not filter dropdowns should be displayed.
         *
         * @return bool Whether or the current page can display the filter drop downs.
         */
        public function can_display_filter()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Loads the MyYoast proxy.
     *
     * This class registers a proxy page on `admin.php`. Which is reached with the `page=PAGE_IDENTIFIER` parameter.
     * It will read external files and serves them like they are located locally.
     */
    class WPSEO_MyYoast_Proxy implements \WPSEO_WordPress_Integration
    {
        /**
         * The page identifier used in WordPress to register the MyYoast proxy page.
         *
         * @var string
         */
        const PAGE_IDENTIFIER = 'wpseo_myyoast_proxy';
        /**
         * The cache control's max age. Used in the header of a successful proxy response.
         *
         * @var int
         */
        const CACHE_CONTROL_MAX_AGE = \DAY_IN_SECONDS;
        /**
         * Registers the hooks when the user is on the right page.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Registers the proxy page. It does not actually add a link to the dashboard.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function add_proxy_page()
        {
        }
        /**
         * Renders the requested proxy page and exits to prevent the WordPress UI from loading.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function handle_proxy_page()
        {
        }
        /**
         * Renders the requested proxy page.
         *
         * This is separated from the exits to be able to test it.
         *
         * @return void
         */
        public function render_proxy_page()
        {
        }
        /**
         * Tries to load the given url via `wp_remote_get`.
         *
         * @codeCoverageIgnore
         *
         * @param string $url The url to load.
         *
         * @return string The body of the response.
         *
         * @throws Exception When `wp_remote_get` returned an error.
         * @throws Exception When the response code is not 200.
         */
        protected function get_remote_url_body($url)
        {
        }
        /**
         * Determines the proxy options based on the file and plugin version arguments.
         *
         * When the file is known it returns an array like this:
         * <code>
         * $array = array(
         *  'content_type' => 'the content type'
         *  'url'          => 'the url, possibly with the plugin version'
         * )
         * </code>
         *
         * @return array Empty for an unknown file. See format above for known files.
         */
        protected function determine_proxy_options()
        {
        }
        /**
         * Checks if the current page is the MyYoast proxy page.
         *
         * @codeCoverageIgnore
         *
         * @return bool True when the page request parameter equals the proxy page.
         */
        protected function is_proxy_page()
        {
        }
        /**
         * Returns the proxy file from the HTTP request parameters.
         *
         * @codeCoverageIgnore
         *
         * @return string The sanitized file request parameter.
         */
        protected function get_proxy_file()
        {
        }
        /**
         * Returns the plugin version from the HTTP request parameters.
         *
         * @codeCoverageIgnore
         *
         * @return string The sanitized plugin_version request parameter.
         */
        protected function get_plugin_version()
        {
        }
        /**
         * Sets the HTTP header.
         *
         * This is a tiny helper function to enable better testing.
         *
         * @codeCoverageIgnore
         *
         * @param string $header The header to set.
         *
         * @return void
         */
        protected function set_header($header)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Options\Tabs
     */
    /**
     * Class WPSEO_Option_Tab.
     */
    class WPSEO_Option_Tab
    {
        /**
         * Name of the tab.
         *
         * @var string
         */
        private $name;
        /**
         * Label of the tab.
         *
         * @var string
         */
        private $label;
        /**
         * Optional arguments.
         *
         * @var array
         */
        private $arguments;
        /**
         * WPSEO_Option_Tab constructor.
         *
         * @param string $name      Name of the tab.
         * @param string $label     Localized label of the tab.
         * @param array  $arguments Optional arguments.
         */
        public function __construct($name, $label, array $arguments = [])
        {
        }
        /**
         * Gets the name.
         *
         * @return string The name.
         */
        public function get_name()
        {
        }
        /**
         * Gets the label.
         *
         * @return string The label.
         */
        public function get_label()
        {
        }
        /**
         * Retrieves whether the tab needs a save button.
         *
         * @return bool True whether the tabs needs a save button.
         */
        public function has_save_button()
        {
        }
        /**
         * Gets the option group.
         *
         * @return string The option group.
         */
        public function get_opt_group()
        {
        }
        /**
         * Retrieves the variable from the supplied arguments.
         *
         * @param string       $variable Variable to retrieve.
         * @param string|mixed $default  Default to use when variable not found.
         *
         * @return mixed|string The retrieved variable.
         */
        protected function get_argument($variable, $default = '')
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Options\Tabs
     */
    /**
     * Class WPSEO_Option_Tabs_Formatter.
     */
    class WPSEO_Option_Tabs_Formatter
    {
        /**
         * Retrieves the path to the view of the tab.
         *
         * @param WPSEO_Option_Tabs $option_tabs Option Tabs to get base from.
         * @param WPSEO_Option_Tab  $tab         Tab to get name from.
         *
         * @return string
         */
        public function get_tab_view(\WPSEO_Option_Tabs $option_tabs, \WPSEO_Option_Tab $tab)
        {
        }
        /**
         * Outputs the option tabs.
         *
         * @param WPSEO_Option_Tabs $option_tabs Option Tabs to get tabs from.
         */
        public function run(\WPSEO_Option_Tabs $option_tabs)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Options\Tabs
     */
    /**
     * Class WPSEO_Option_Tabs.
     */
    class WPSEO_Option_Tabs
    {
        /**
         * Tabs base.
         *
         * @var string
         */
        private $base;
        /**
         * The tabs in this group.
         *
         * @var array
         */
        private $tabs = [];
        /**
         * Name of the active tab.
         *
         * @var string
         */
        private $active_tab = '';
        /**
         * WPSEO_Option_Tabs constructor.
         *
         * @codeCoverageIgnore
         *
         * @param string $base       Base of the tabs.
         * @param string $active_tab Currently active tab.
         */
        public function __construct($base, $active_tab = '')
        {
        }
        /**
         * Get the base.
         *
         * @return string
         */
        public function get_base()
        {
        }
        /**
         * Add a tab.
         *
         * @param WPSEO_Option_Tab $tab Tab to add.
         *
         * @return $this
         */
        public function add_tab(\WPSEO_Option_Tab $tab)
        {
        }
        /**
         * Get active tab.
         *
         * @return WPSEO_Option_Tab|null Get the active tab.
         */
        public function get_active_tab()
        {
        }
        /**
         * Is the tab the active tab.
         *
         * @param WPSEO_Option_Tab $tab Tab to check for active tab.
         *
         * @return bool
         */
        public function is_active_tab(\WPSEO_Option_Tab $tab)
        {
        }
        /**
         * Get all tabs.
         *
         * @return WPSEO_Option_Tab[]
         */
        public function get_tabs()
        {
        }
        /**
         * Display the tabs.
         *
         * @param Yoast_Form $yform Yoast Form needed in the views.
         */
        public function display(\Yoast_Form $yform)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_presenter_paper.
     */
    class WPSEO_Paper_Presenter
    {
        /**
         * Title of the paper.
         *
         * @var string
         */
        private $title;
        /**
         * The view variables.
         *
         * @var array
         */
        private $settings;
        /**
         * The path to the view file.
         *
         * @var string
         */
        private $view_file;
        /**
         * WPSEO_presenter_paper constructor.
         *
         * @param string      $title     The title of the paper.
         * @param string|null $view_file Optional. The path to the view file. Use the content setting
         *                               if do not wish to use a view file.
         * @param array       $settings  Optional. Settings for the paper.
         */
        public function __construct($title, $view_file = \null, array $settings = [])
        {
        }
        /**
         * Renders the collapsible paper and returns it as a string.
         *
         * @return string The rendered paper.
         */
        public function get_output()
        {
        }
        /**
         * Retrieves the view variables.
         *
         * @return array The view variables.
         */
        private function get_view_variables()
        {
        }
        /**
         * Retrieves the collapsible config based on the settings.
         *
         * @return array The config.
         */
        protected function collapsible_config()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Plugin_Availability
     */
    /**
     * Class WPSEO_Plugin_Availability
     */
    class WPSEO_Plugin_Availability
    {
        /**
         * Holds the plugins.
         *
         * @var array
         */
        protected $plugins = [];
        /**
         * Registers the plugins so we can access them.
         */
        public function register()
        {
        }
        /**
         * Registers all the available Yoast SEO plugins.
         */
        protected function register_yoast_plugins()
        {
        }
        /**
         * Sets certain plugin properties based on WordPress' status.
         */
        protected function register_yoast_plugins_status()
        {
        }
        /**
         * Checks whether or not a plugin is known within the Yoast SEO collection.
         *
         * @param string $plugin The plugin to search for.
         *
         * @return bool Whether or not the plugin is exists.
         */
        protected function plugin_exists($plugin)
        {
        }
        /**
         * Gets all the possibly available plugins.
         *
         * @return array Array containing the information about the plugins.
         */
        public function get_plugins()
        {
        }
        /**
         * Gets a specific plugin. Returns an empty array if it cannot be found.
         *
         * @param string $plugin The plugin to search for.
         *
         * @return array The plugin properties.
         */
        public function get_plugin($plugin)
        {
        }
        /**
         * Gets the version of the plugin.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return string The version associated with the plugin.
         */
        public function get_version($plugin)
        {
        }
        /**
         * Checks if there are dependencies available for the plugin.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return bool Whether or not there is a dependency present.
         */
        public function has_dependencies($plugin)
        {
        }
        /**
         * Gets the dependencies for the plugin.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return array Array containing all the dependencies associated with the plugin.
         */
        public function get_dependencies($plugin)
        {
        }
        /**
         * Checks if all dependencies are satisfied.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return bool Whether or not the dependencies are satisfied.
         */
        public function dependencies_are_satisfied($plugin)
        {
        }
        /**
         * Checks whether or not one of the plugins is properly installed and usable.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return bool Whether or not the plugin is properly installed.
         */
        public function is_installed($plugin)
        {
        }
        /**
         * Gets all installed plugins.
         *
         * @return array The installed plugins.
         */
        public function get_installed_plugins()
        {
        }
        /**
         * Checks for the availability of the plugin.
         *
         * @param array $plugin The information available about the plugin.
         *
         * @return bool Whether or not the plugin is available.
         */
        public function is_available($plugin)
        {
        }
        /**
         * Checks whether a dependency is available.
         *
         * @param array $dependency The information about the dependency to look for.
         *
         * @return bool Whether or not the dependency is available.
         */
        public function is_dependency_available($dependency)
        {
        }
        /**
         * Gets the names of the dependencies.
         *
         * @param array $plugin The plugin to get the dependency names from.
         *
         * @return array Array containing the names of the associated dependencies.
         */
        public function get_dependency_names($plugin)
        {
        }
        /**
         * Gets an array of plugins that have defined dependencies.
         *
         * @return array Array of the plugins that have dependencies.
         */
        public function get_plugins_with_dependencies()
        {
        }
        /**
         * Determines whether or not a plugin is active.
         *
         * @param string $plugin The plugin slug to check.
         *
         * @return bool Whether or not the plugin is active.
         */
        public function is_active($plugin)
        {
        }
        /**
         * Determines whether or not a plugin is a Premium product.
         *
         * @param array $plugin The plugin to check.
         *
         * @return bool Whether or not the plugin is a Premium product.
         */
        public function is_premium($plugin)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     * @since   1.7.0
     */
    /**
     * Base class for handling plugin conflicts.
     */
    class Yoast_Plugin_Conflict
    {
        /**
         * The plugins must be grouped per section.
         *
         * It's possible to check for each section if there are conflicting plugins.
         *
         * @var array
         */
        protected $plugins = [];
        /**
         * All the current active plugins will be stored in this private var.
         *
         * @var array
         */
        protected $all_active_plugins = [];
        /**
         * After searching for active plugins that are in $this->plugins the active plugins will be stored in this
         * property.
         *
         * @var array
         */
        protected $active_plugins = [];
        /**
         * Property for holding instance of itself.
         *
         * @var Yoast_Plugin_Conflict
         */
        protected static $instance;
        /**
         * For the use of singleton pattern. Create instance of itself and return this instance.
         *
         * @param string $class_name Give the classname to initialize. If classname is
         *                           false (empty) it will use it's own __CLASS__.
         *
         * @return Yoast_Plugin_Conflict
         */
        public static function get_instance($class_name = '')
        {
        }
        /**
         * Setting instance, all active plugins and search for active plugins.
         *
         * Protected constructor to prevent creating a new instance of the
         * *Singleton* via the `new` operator from outside of this class.
         */
        protected function __construct()
        {
        }
        /**
         * Check if there are conflicting plugins for given $plugin_section.
         *
         * @param string $plugin_section Type of plugin conflict (such as Open Graph or sitemap).
         *
         * @return bool
         */
        public function check_for_conflicts($plugin_section)
        {
        }
        /**
         * Getting all the conflicting plugins and return them as a string.
         *
         * This method will loop through all conflicting plugins to get the details of each plugin. The plugin name
         * will be taken from the details to parse a comma separated string, which can be use for by example a notice
         *
         * @param string $plugin_section Plugin conflict type (such as Open Graph or sitemap).
         *
         * @return string
         */
        public function get_conflicting_plugins_as_string($plugin_section)
        {
        }
        /**
         * Checks for given $plugin_sections for conflicts.
         *
         * @param array $plugin_sections Set of sections.
         */
        public function check_plugin_conflicts($plugin_sections)
        {
        }
        /**
         * Setting an error on the screen.
         *
         * @param string $plugin_section          Type of conflict group (such as Open Graph or sitemap).
         * @param string $readable_plugin_section This is the value for the translation.
         */
        protected function set_error($plugin_section, $readable_plugin_section)
        {
        }
        /**
         * Clear the notification for a plugin.
         *
         * @param string $plugin_file Clear the optional notification for this plugin.
         */
        public function clear_error($plugin_file)
        {
        }
        /**
         * Loop through the $this->plugins to check if one of the plugins is active.
         *
         * This method will store the active plugins in $this->active_plugins.
         */
        protected function search_active_plugins()
        {
        }
        /**
         * Loop through plugins and check if each plugin is active.
         *
         * @param array  $plugins        Set of plugins.
         * @param string $plugin_section Type of conflict group (such as Open Graph or sitemap).
         */
        protected function check_plugins_active($plugins, $plugin_section)
        {
        }
        /**
         * Check if given plugin exists in array with all_active_plugins.
         *
         * @param string $plugin Plugin basename string.
         *
         * @return bool
         */
        protected function check_plugin_is_active($plugin)
        {
        }
        /**
         * Add plugin to the list of active plugins.
         *
         * This method will check first if key $plugin_section exists, if not it will create an empty array
         * If $plugin itself doesn't exist it will be added.
         *
         * @param string $plugin_section Type of conflict group (such as Open Graph or sitemap).
         * @param string $plugin         Plugin basename string.
         */
        protected function add_active_plugin($plugin_section, $plugin)
        {
        }
        /**
         * Search in $this->plugins for the given $plugin.
         *
         * If there is a result it will return the plugin category.
         *
         * @param string $plugin Plugin basename string.
         *
         * @return int|string
         */
        protected function find_plugin_category($plugin)
        {
        }
        /**
         * Get plugin name from file.
         *
         * @param string $plugin Plugin path relative to plugins directory.
         *
         * @return string|bool Plugin name or false when no name is set.
         */
        protected function get_plugin_name($plugin)
        {
        }
        /**
         * When being in the deactivation process the currently deactivated plugin has to be removed.
         */
        private function remove_deactivated_plugin()
        {
        }
        /**
         * Get the identifier from the plugin file.
         *
         * @param string $plugin_file Plugin file to get Identifier from.
         *
         * @return string
         */
        private function get_notification_identifier($plugin_file)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     * @since   1.7.0
     */
    /**
     * Contains list of conflicting plugins.
     */
    class WPSEO_Plugin_Conflict extends \Yoast_Plugin_Conflict
    {
        /**
         * The plugins must be grouped per section.
         *
         * It's possible to check for each section if there are conflicting plugin
         *
         * @var array
         */
        protected $plugins = [
            // The plugin which are writing OG metadata.
            'open_graph' => [
                '2-click-socialmedia-buttons/2-click-socialmedia-buttons.php',
                // 2 Click Social Media Buttons.
                'add-link-to-facebook/add-link-to-facebook.php',
                // Add Link to Facebook.
                'add-meta-tags/add-meta-tags.php',
                // Add Meta Tags.
                'easy-facebook-share-thumbnails/esft.php',
                // Easy Facebook Share Thumbnail.
                'facebook/facebook.php',
                // Facebook (official plugin).
                'facebook-awd/AWD_facebook.php',
                // Facebook AWD All in one.
                'facebook-featured-image-and-open-graph-meta-tags/fb-featured-image.php',
                // Facebook Featured Image & OG Meta Tags.
                'facebook-meta-tags/facebook-metatags.php',
                // Facebook Meta Tags.
                'wonderm00ns-simple-facebook-open-graph-tags/wonderm00n-open-graph.php',
                // Facebook Open Graph Meta Tags for WordPress.
                'facebook-revised-open-graph-meta-tag/index.php',
                // Facebook Revised Open Graph Meta Tag.
                'facebook-thumb-fixer/_facebook-thumb-fixer.php',
                // Facebook Thumb Fixer.
                'facebook-and-digg-thumbnail-generator/facebook-and-digg-thumbnail-generator.php',
                // Fedmich's Facebook Open Graph Meta.
                'network-publisher/networkpub.php',
                // Network Publisher.
                'nextgen-facebook/nextgen-facebook.php',
                // NextGEN Facebook OG.
                'opengraph/opengraph.php',
                // Open Graph.
                'open-graph-protocol-framework/open-graph-protocol-framework.php',
                // Open Graph Protocol Framework.
                'seo-facebook-comments/seofacebook.php',
                // SEO Facebook Comments.
                'sexybookmarks/sexy-bookmarks.php',
                // Shareaholic.
                'shareaholic/sexy-bookmarks.php',
                // Shareaholic.
                'sharepress/sharepress.php',
                // SharePress.
                'simple-facebook-connect/sfc.php',
                // Simple Facebook Connect.
                'social-discussions/social-discussions.php',
                // Social Discussions.
                'social-sharing-toolkit/social_sharing_toolkit.php',
                // Social Sharing Toolkit.
                'socialize/socialize.php',
                // Socialize.
                'only-tweet-like-share-and-google-1/tweet-like-plusone.php',
                // Tweet, Like, Google +1 and Share.
                'wordbooker/wordbooker.php',
                // Wordbooker.
                'wpsso/wpsso.php',
                // WordPress Social Sharing Optimization.
                'wp-caregiver/wp-caregiver.php',
                // WP Caregiver.
                'wp-facebook-like-send-open-graph-meta/wp-facebook-like-send-open-graph-meta.php',
                // WP Facebook Like Send & Open Graph Meta.
                'wp-facebook-open-graph-protocol/wp-facebook-ogp.php',
                // WP Facebook Open Graph protocol.
                'wp-ogp/wp-ogp.php',
                // WP-OGP.
                'zoltonorg-social-plugin/zosp.php',
            ],
            'xml_sitemaps' => [
                'google-sitemap-plugin/google-sitemap-plugin.php',
                // Google Sitemap (BestWebSoft).
                'xml-sitemaps/xml-sitemaps.php',
                // XML Sitemaps (Denis de Bernardy and Mike Koepke).
                'bwp-google-xml-sitemaps/bwp-simple-gxs.php',
                // Better WordPress Google XML Sitemaps (Khang Minh).
                'google-sitemap-generator/sitemap.php',
                // Google XML Sitemaps (Arne Brachhold).
                'xml-sitemap-feed/xml-sitemap.php',
                // XML Sitemap & Google News feeds (RavanH).
                'google-monthly-xml-sitemap/monthly-xml-sitemap.php',
                // Google Monthly XML Sitemap (Andrea Pernici).
                'simple-google-sitemap-xml/simple-google-sitemap-xml.php',
                // Simple Google Sitemap XML (iTx Technologies).
                'another-simple-xml-sitemap/another-simple-xml-sitemap.php',
                // Another Simple XML Sitemap.
                'xml-maps/google-sitemap.php',
                // Xml Sitemap (Jason Martens).
                'google-xml-sitemap-generator-by-anton-dachauer/adachauer-google-xml-sitemap.php',
                // Google XML Sitemap Generator by Anton Dachauer (Anton Dachauer).
                'wp-xml-sitemap/wp-xml-sitemap.php',
                // WP XML Sitemap (Team Vivacity).
                'sitemap-generator-for-webmasters/sitemap.php',
                // Sitemap Generator for Webmasters (iwebslogtech).
                'xml-sitemap-xml-sitemapcouk/xmls.php',
                // XML Sitemap - XML-Sitemap.co.uk (Simon Hancox).
                'sewn-in-xml-sitemap/sewn-xml-sitemap.php',
                // Sewn In XML Sitemap (jcow).
                'rps-sitemap-generator/rps-sitemap-generator.php',
            ],
            'cloaking' => [
                'rs-head-cleaner/rs-head-cleaner.php',
                // RS Head Cleaner Plus https://wordpress.org/plugins/rs-head-cleaner/.
                'rs-head-cleaner-lite/rs-head-cleaner-lite.php',
            ],
            'seo' => [
                'all-in-one-seo-pack/all_in_one_seo_pack.php',
                // All in One SEO Pack.
                'seo-ultimate/seo-ultimate.php',
                // SEO Ultimate.
                'seo-by-rank-math/rank-math.php',
            ],
        ];
        /**
         * Overrides instance to set with this class as class.
         *
         * @param string $class_name Optional class name.
         *
         * @return Yoast_Plugin_Conflict
         */
        public static function get_instance($class_name = __CLASS__)
        {
        }
        /**
         * After activating any plugin, this method will be executed by a hook.
         *
         * If the activated plugin is conflicting with ours a notice will be shown.
         *
         * @param string|bool $plugin Optional plugin basename to check.
         */
        public static function hook_check_for_plugin_conflicts($plugin = \false)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_Premium_popup.
     */
    class WPSEO_Premium_Popup
    {
        /**
         * An unique identifier for the popup
         *
         * @var string
         */
        private $identifier = '';
        /**
         * The heading level of the title of the popup.
         *
         * @var string
         */
        private $heading_level = '';
        /**
         * The title of the popup.
         *
         * @var string
         */
        private $title = '';
        /**
         * The content of the popup.
         *
         * @var string
         */
        private $content = '';
        /**
         * The URL for where the button should link to.
         *
         * @var string
         */
        private $url = '';
        /**
         * Wpseo_Premium_Popup constructor.
         *
         * @param string $identifier    An unique identifier for the popup.
         * @param string $heading_level The heading level for the title of the popup.
         * @param string $title         The title of the popup.
         * @param string $content       The content of the popup.
         * @param string $url           The URL for where the button should link to.
         */
        public function __construct($identifier, $heading_level, $title, $content, $url)
        {
        }
        /**
         * Returns the premium popup as an HTML string.
         *
         * @param bool $popup Show this message as a popup show it straight away.
         *
         * @return string
         */
        public function get_premium_message($popup = \true)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_Premium_Upsell_Admin_Block
     */
    class WPSEO_Premium_Upsell_Admin_Block
    {
        /**
         * Hook to display the block on.
         *
         * @var string
         */
        protected $hook;
        /**
         * Identifier to use in the dismissal functionality.
         *
         * @var string
         */
        protected $identifier = 'premium_upsell';
        /**
         * Registers which hook the block will be displayed on.
         *
         * @param string $hook Hook to display the block on.
         */
        public function __construct($hook)
        {
        }
        /**
         * Registers WordPress hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Renders the upsell block.
         *
         * @return void
         */
        public function render()
        {
        }
        /**
         * Formats the argument to a HTML list item.
         *
         * @param string $argument The argument to format.
         *
         * @return string Formatted argument in HTML.
         */
        protected function get_argument_html($argument)
        {
        }
        /**
         * Returns the HTML base class to use.
         *
         * @return string The HTML base class.
         */
        protected function get_html_class()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Adds the UI to change the primary term for a post.
     */
    class WPSEO_Primary_Term_Admin implements \WPSEO_WordPress_Integration
    {
        /**
         * Constructor.
         */
        public function register_hooks()
        {
        }
        /**
         * Gets the current post ID.
         *
         * @return int The post ID.
         */
        protected function get_current_id()
        {
        }
        /**
         * Adds hidden fields for primary taxonomies.
         *
         * @param string $content The metabox content.
         *
         * @return string The HTML content.
         */
        public function add_input_fields($content)
        {
        }
        /**
         * Generates the HTML for a hidden field for a primary taxonomy.
         *
         * @param string $taxonomy_name The taxonomy's slug.
         *
         * @return string The HTML for a hidden primary taxonomy field.
         */
        protected function primary_term_field($taxonomy_name)
        {
        }
        /**
         * Generates an id for a primary taxonomy's hidden field.
         *
         * @param string $taxonomy_name The taxonomy's slug.
         *
         * @return string The field id.
         */
        protected function generate_field_id($taxonomy_name)
        {
        }
        /**
         * Generates a name for a primary taxonomy's hidden field.
         *
         * @param string $taxonomy_name The taxonomy's slug.
         *
         * @return string The field id.
         */
        protected function generate_field_name($taxonomy_name)
        {
        }
        /**
         * Adds primary term templates.
         */
        public function wp_footer()
        {
        }
        /**
         * Enqueues all the assets needed for the primary term interface.
         *
         * @return void
         */
        public function enqueue_assets()
        {
        }
        /**
         * Gets the id of the primary term.
         *
         * @param string $taxonomy_name Taxonomy name for the term.
         *
         * @return int primary term id
         */
        protected function get_primary_term($taxonomy_name)
        {
        }
        /**
         * Returns all the taxonomies for which the primary term selection is enabled.
         *
         * @param int|null $post_id Default current post ID.
         * @return array
         */
        protected function get_primary_term_taxonomies($post_id = \null)
        {
        }
        /**
         * Includes templates file.
         */
        protected function include_js_templates()
        {
        }
        /**
         * Generates the primary term taxonomies.
         *
         * @param int $post_id ID of the post.
         *
         * @return array
         */
        protected function generate_primary_term_taxonomies($post_id)
        {
        }
        /**
         * Creates a map of taxonomies for localization.
         *
         * @param array $taxonomies The taxononmies that should be mapped.
         *
         * @return array The mapped taxonomies.
         */
        protected function get_mapped_taxonomies_for_js($taxonomies)
        {
        }
        /**
         * Returns an array suitable for use in the javascript.
         *
         * @param stdClass $taxonomy The taxonomy to map.
         *
         * @return array The mapped taxonomy.
         */
        private function map_taxonomies_for_js($taxonomy)
        {
        }
        /**
         * Returns whether or not a taxonomy is hierarchical.
         *
         * @param stdClass $taxonomy Taxonomy object.
         *
         * @return bool
         */
        private function filter_hierarchical_taxonomies($taxonomy)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents the upsell notice.
     */
    class WPSEO_Product_Upsell_Notice
    {
        /**
         * Holds the name of the user meta key.
         *
         * The value of this database field holds whether the user has dismissed this notice or not.
         *
         * @var string
         */
        const USER_META_DISMISSED = 'wpseo-remove-upsell-notice';
        /**
         * Holds the option name.
         *
         * @var string
         */
        const OPTION_NAME = 'wpseo';
        /**
         * Holds the options.
         *
         * @var array
         */
        protected $options;
        /**
         * Sets the options, because they always have to be there on instance.
         */
        public function __construct()
        {
        }
        /**
         * Checks if the notice should be added or removed.
         */
        public function initialize()
        {
        }
        /**
         * Sets the upgrade notice.
         */
        public function set_upgrade_notice()
        {
        }
        /**
         * Listener for the upsell notice.
         */
        public function dismiss_notice_listener()
        {
        }
        /**
         * When the notice should be shown.
         *
         * @return bool
         */
        protected function should_add_notification()
        {
        }
        /**
         * Checks if the options has a first activated on date value.
         *
         * @return bool
         */
        protected function has_first_activated_on()
        {
        }
        /**
         * Sets the first activated on.
         */
        protected function set_first_activated_on()
        {
        }
        /**
         * Adds a notification to the notification center.
         */
        protected function add_notification()
        {
        }
        /**
         * Removes a notification to the notification center.
         */
        protected function remove_notification()
        {
        }
        /**
         * Returns a premium upsell section if using the free plugin.
         *
         * @return string
         */
        protected function get_premium_upsell_section()
        {
        }
        /**
         * Gets the notification value.
         *
         * @return Yoast_Notification
         */
        protected function get_notification()
        {
        }
        /**
         * Dismisses the notice.
         *
         * @return bool
         */
        protected function is_notice_dismissed()
        {
        }
        /**
         * Dismisses the notice.
         */
        protected function dismiss_notice()
        {
        }
        /**
         * Returns the set options.
         *
         * @return mixed
         */
        protected function get_options()
        {
        }
        /**
         * Saves the options to the database.
         */
        protected function save_options()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class handles a post request being send to a given endpoint.
     */
    class WPSEO_Remote_Request
    {
        /**
         * Holds the post method.
         *
         * @var string
         */
        const METHOD_POST = 'post';
        /**
         * Holds the get method.
         *
         * @var string
         */
        const METHOD_GET = 'get';
        /**
         * Holds the endpoint to send the request to.
         *
         * @var string
         */
        protected $endpoint = '';
        /**
         * Holds the arguments to use in this request.
         *
         * @var array
         */
        protected $args = ['blocking' => \false, 'timeout' => 2];
        /**
         * Holds the response error.
         *
         * @var WP_Error|null
         */
        protected $response_error;
        /**
         * Holds the response body.
         *
         * @var mixed
         */
        protected $response_body;
        /**
         * Sets the endpoint and arguments.
         *
         * @param string $endpoint The endpoint to send the request to.
         * @param array  $args     The arguments to use in this request.
         */
        public function __construct($endpoint, array $args = [])
        {
        }
        /**
         * Sets the request body.
         *
         * @param mixed $body The body to set.
         */
        public function set_body($body)
        {
        }
        /**
         * Sends the data to the given endpoint.
         *
         * @param string $method The type of request to send.
         *
         * @return bool True when sending data has been successful.
         */
        public function send($method = self::METHOD_POST)
        {
        }
        /**
         * Returns the value of the response error.
         *
         * @return WP_Error|null The response error.
         */
        public function get_response_error()
        {
        }
        /**
         * Returns the response body.
         *
         * @return mixed The response body.
         */
        public function get_response_body()
        {
        }
        /**
         * Processes the given response.
         *
         * @param mixed $response The response to process.
         *
         * @return bool True when response is valid.
         */
        protected function process_response($response)
        {
        }
        /**
         * Performs a post request to the specified endpoint with set arguments.
         *
         * @return WP_Error|array The response or WP_Error on failure.
         */
        protected function post()
        {
        }
        /**
         * Performs a post request to the specified endpoint with set arguments.
         *
         * @return WP_Error|array The response or WP_Error on failure.
         */
        protected function get()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Notifies the user to update the Person on the publish entity in the Configuration Wizard.
     */
    class WPSEO_Schema_Person_Upgrade_Notification implements \WPSEO_WordPress_Integration
    {
        /**
         * Registers all hooks to WordPress
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Handles if the notification should be added or removed.
         */
        public function handle_notification()
        {
        }
        /**
         * Adds a notification to the notification center.
         */
        protected function add_notification()
        {
        }
        /**
         * Removes a notification to the notification center.
         */
        protected function remove_notification()
        {
        }
        /**
         * Gets the notification object.
         *
         * @return Yoast_Notification
         */
        protected function get_notification()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Suggested_Plugins
     */
    /**
     * Class WPSEO_Suggested_Plugins
     */
    class WPSEO_Suggested_Plugins implements \WPSEO_WordPress_Integration
    {
        /**
         * Holds the availability checker.
         *
         * @var WPSEO_Plugin_Availability
         */
        protected $availability_checker;
        /**
         * Holds the notification center.
         *
         * @var Yoast_Notification_Center
         */
        protected $notification_center;
        /**
         * WPSEO_Suggested_Plugins constructor.
         *
         * @param WPSEO_Plugin_Availability $availability_checker The availability checker to use.
         * @param Yoast_Notification_Center $notification_center  The notification center to add notifications to.
         */
        public function __construct(\WPSEO_Plugin_Availability $availability_checker, \Yoast_Notification_Center $notification_center)
        {
        }
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Adds notifications (when necessary).
         *
         * @return void
         */
        public function add_notifications()
        {
        }
        /**
         * Build Yoast SEO suggested plugins notification.
         *
         * @param string $name            The plugin name to use for the unique ID.
         * @param array  $plugin          The plugin to retrieve the data from.
         *
         * @return Yoast_Notification The notification containing the suggested plugin.
         */
        protected function get_yoast_seo_suggested_plugins_notification($name, $plugin)
        {
        }
        /**
         * Creates a message to suggest the installation of a particular plugin.
         *
         * @param array $suggested_plugin   The suggested plugin.
         *
         * @return string The install suggested plugin message.
         */
        protected function create_install_suggested_plugin_message($suggested_plugin)
        {
        }
        /**
         * Creates a more information link that directs the user to WordPress.org Plugin repository.
         *
         * @param string $url  The URL to the plugin's page.
         * @param string $name The name of the plugin.
         *
         * @return string The more information link.
         */
        protected function create_more_information_link($url, $name)
        {
        }
        /**
         * Creates a message to suggest the activation of a particular plugin.
         *
         * @param array $suggested_plugin   The suggested plugin.
         *
         * @return string The activate suggested plugin message.
         */
        protected function create_activate_suggested_plugin_message($suggested_plugin)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents the yoast columns.
     */
    class WPSEO_Yoast_Columns implements \WPSEO_WordPress_Integration
    {
        /**
         * Registers all hooks to WordPress.
         */
        public function register_hooks()
        {
        }
        /**
         * Adds the help tab to the help center for current screen.
         */
        public function add_help_tab()
        {
        }
        /**
         * Retrieves the post type from the $_GET variable.
         *
         * @return string The current post type.
         */
        private function get_current_post_type()
        {
        }
        /**
         * Whether or not we are showing link columns on this overview page.
         * This depends on the post being accessible or not.
         *
         * @return bool Whether or not the linking columns are shown
         */
        private function display_links()
        {
        }
        /**
         * Wraps the WPSEO_Metabox check to determine whether the metabox should be displayed either by
         * choice of the admin or because the post type is not a public post type.
         *
         * @return bool Whether or not the meta box (and associated columns etc) should be hidden.
         */
        private function display_meta_columns()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class to change or add WordPress dashboard widgets.
     */
    class Yoast_Dashboard_Widget implements \WPSEO_WordPress_Integration
    {
        /**
         * Holds the cache transient key.
         *
         * @var string
         */
        const CACHE_TRANSIENT_KEY = 'wpseo-dashboard-totals';
        /**
         * Holds an instance of the admin asset manager.
         *
         * @var WPSEO_Admin_Asset_Manager
         */
        protected $asset_manager;
        /**
         * Holds the dashboard statistics.
         *
         * @var WPSEO_Statistics
         */
        protected $statistics;
        /**
         * Yoast_Dashboard_Widget constructor.
         *
         * @param WPSEO_Statistics|null $statistics WPSEO_Statistics instance.
         */
        public function __construct(\WPSEO_Statistics $statistics = \null)
        {
        }
        /**
         * Register WordPress hooks.
         */
        public function register_hooks()
        {
        }
        /**
         * Adds the dashboard widget if it should be shown.
         *
         * @return void
         */
        public function queue_dashboard_widget()
        {
        }
        /**
         * Adds dashboard widget to WordPress.
         */
        public function add_dashboard_widget()
        {
        }
        /**
         * Adds CSS classes to the dashboard widget.
         *
         * @param array $classes An array of postbox CSS classes.
         *
         * @return array
         */
        public function wpseo_dashboard_overview_class($classes)
        {
        }
        /**
         * Displays the dashboard widget.
         */
        public function display_dashboard_widget()
        {
        }
        /**
         * Enqueues assets for the dashboard if the current page is the dashboard.
         */
        public function enqueue_dashboard_assets()
        {
        }
        /**
         * Translates strings used in the dashboard widget.
         *
         * @return array The translated strings.
         */
        public function localize_dashboard_script()
        {
        }
        /**
         * Checks if the current screen is the dashboard screen.
         *
         * @return bool Whether or not this is the dashboard screen.
         */
        private function is_dashboard_screen()
        {
        }
        /**
         * Returns true when the dashboard widget should be shown.
         *
         * @return bool
         */
        private function show_widget()
        {
        }
    }
    /**
     * Admin form class.
     *
     * @since 2.0
     */
    class Yoast_Form
    {
        /**
         * Instance of this class
         *
         * @var Yoast_Form
         * @since 2.0
         */
        public static $instance;
        /**
         * The short name of the option to use for the current page.
         *
         * @var string
         * @since 2.0
         */
        public $option_name;
        /**
         * Option instance.
         *
         * @since 8.4
         * @var WPSEO_Option|null
         */
        protected $option_instance = \null;
        /**
         * Get the singleton instance of this class.
         *
         * @since 2.0
         *
         * @return Yoast_Form
         */
        public static function get_instance()
        {
        }
        /**
         * Generates the header for admin pages.
         *
         * @since 2.0
         *
         * @param bool   $form             Whether or not the form start tag should be included.
         * @param string $option           The short name of the option to use for the current page.
         * @param bool   $contains_files   Whether the form should allow for file uploads.
         * @param bool   $option_long_name Group name of the option.
         */
        public function admin_header($form = \true, $option = 'wpseo', $contains_files = \false, $option_long_name = \false)
        {
        }
        /**
         * Set the option used in output for form elements.
         *
         * @since 2.0
         *
         * @param string $option_name Option key.
         */
        public function set_option($option_name)
        {
        }
        /**
         * Generates the footer for admin pages.
         *
         * @since 2.0
         *
         * @param bool $submit       Whether or not a submit button and form end tag should be shown.
         * @param bool $show_sidebar Whether or not to show the banner sidebar - used by premium plugins to disable it.
         */
        public function admin_footer($submit = \true, $show_sidebar = \true)
        {
        }
        /**
         * Generates the sidebar for admin pages.
         *
         * @since 2.0
         */
        public function admin_sidebar()
        {
        }
        /**
         * Output a label element.
         *
         * @since 2.0
         *
         * @param string $text Label text string.
         * @param array  $attr HTML attributes set.
         */
        public function label($text, $attr)
        {
        }
        /**
         * Output a legend element.
         *
         * @since 3.4
         *
         * @param string $text Legend text string.
         * @param array  $attr HTML attributes set.
         */
        public function legend($text, $attr)
        {
        }
        /**
         * Create a Checkbox input field.
         *
         * @since 2.0
         *
         * @param string $var        The variable within the option to create the checkbox for.
         * @param string $label      The label to show for the variable.
         * @param bool   $label_left Whether the label should be left (true) or right (false).
         * @param array  $attr       Extra attributes to add to the checkbox.
         */
        public function checkbox($var, $label, $label_left = \false, $attr = [])
        {
        }
        /**
         * Creates a Checkbox input field list.
         *
         * @since 12.8
         *
         * @param string $variable The variables within the option to create the checkbox list for.
         * @param string $labels   The labels to show for the variable.
         * @param array  $attr     Extra attributes to add to the checkbox list.
         */
        public function checkbox_list($variable, $labels, $attr = [])
        {
        }
        /**
         * Create a light switch input field using a single checkbox.
         *
         * @since 3.1
         *
         * @param string $var     The variable within the option to create the checkbox for.
         * @param string $label   The visual label text for the toggle.
         * @param array  $buttons Array of two visual labels for the buttons (defaults Disabled/Enabled).
         * @param bool   $reverse Reverse order of buttons (default true).
         * @param string $help    Inline Help that will be printed out before the toggle.
         * @param bool   $strong  Whether the visual label is displayed in strong text. Default is false.
         *                        Starting from Yoast SEO 16.5, the visual label is forced to bold via CSS.
         * @param array  $attr    Extra attributes to add to the light switch.
         */
        public function light_switch($var, $label, $buttons = [], $reverse = \true, $help = '', $strong = \false, $attr = [])
        {
        }
        /**
         * Create a Text input field.
         *
         * @since 2.0
         * @since 2.1 Introduced the `$attr` parameter.
         *
         * @param string       $var   The variable within the option to create the text input field for.
         * @param string       $label The label to show for the variable.
         * @param array|string $attr  Extra attributes to add to the input field. Can be class, disabled, autocomplete.
         */
        public function textinput($var, $label, $attr = [])
        {
        }
        /**
         * Creates a text input field with with the ability to add content after the label.
         *
         * @param string $var   The variable within the option to create the text input field for.
         * @param string $label The label to show for the variable.
         * @param array  $attr  Extra attributes to add to the input field.
         *
         * @return void
         */
        public function textinput_extra_content($var, $label, $attr = [])
        {
        }
        /**
         * Create a textarea.
         *
         * @since 2.0
         *
         * @param string       $var   The variable within the option to create the textarea for.
         * @param string       $label The label to show for the variable.
         * @param string|array $attr  The CSS class or an array of attributes to assign to the textarea.
         */
        public function textarea($var, $label, $attr = [])
        {
        }
        /**
         * Create a hidden input field.
         *
         * @since 2.0
         *
         * @param string $var The variable within the option to create the hidden input for.
         * @param string $id  The ID of the element.
         */
        public function hidden($var, $id = '')
        {
        }
        /**
         * Create a Select Box.
         *
         * @since 2.0
         *
         * @param string $var            The variable within the option to create the select for.
         * @param string $label          The label to show for the variable.
         * @param array  $select_options The select options to choose from.
         * @param string $styled         The select style. Use 'styled' to get a styled select. Default 'unstyled'.
         * @param bool   $show_label     Whether or not to show the label, if not, it will be applied as an aria-label.
         * @param array  $attr           Extra attributes to add to the select.
         * @param string $help           Optional. Inline Help HTML that will be printed after the label. Default is empty.
         */
        public function select($var, $label, array $select_options, $styled = 'unstyled', $show_label = \true, $attr = [], $help = '')
        {
        }
        /**
         * Create a File upload field.
         *
         * @since 2.0
         *
         * @param string $var   The variable within the option to create the file upload field for.
         * @param string $label The label to show for the variable.
         * @param array  $attr  Extra attributes to add to the file upload input.
         */
        public function file_upload($var, $label, $attr = [])
        {
        }
        /**
         * Media input.
         *
         * @since 2.0
         *
         * @param string $var   Option name.
         * @param string $label Label message.
         * @param array  $attr  Extra attributes to add to the media input and buttons.
         */
        public function media_input($var, $label, $attr = [])
        {
        }
        /**
         * Create a Radio input field.
         *
         * @since 2.0
         *
         * @param string $var         The variable within the option to create the radio button for.
         * @param array  $values      The radio options to choose from.
         * @param string $legend      Optional. The legend to show for the field set, if any.
         * @param array  $legend_attr Optional. The attributes for the legend, if any.
         * @param array  $attr        Extra attributes to add to the radio button.
         */
        public function radio($var, $values, $legend = '', $legend_attr = [], $attr = [])
        {
        }
        /**
         * Create a toggle switch input field using two radio buttons.
         *
         * @since 3.1
         *
         * @param string $var    The variable within the option to create the radio buttons for.
         * @param array  $values Associative array of on/off keys and their values to be used as
         *                       the label elements text for the radio buttons. Optionally, each
         *                       value can be an array of visible label text and screen reader text.
         * @param string $label  The visual label for the radio buttons group, used as the fieldset legend.
         * @param string $help   Inline Help that will be printed out before the visible toggles text.
         * @param array  $attr   Extra attributes to add to the toggle switch.
         */
        public function toggle_switch($var, $values, $label, $help = '', $attr = [])
        {
        }
        /**
         * Creates a toggle switch to define whether an indexable should be indexed or not.
         *
         * @param string $var   The variable within the option to create the radio buttons for.
         * @param string $label The visual label for the radio buttons group, used as the fieldset legend.
         * @param string $help  Inline Help that will be printed out before the visible toggles text.
         * @param array  $attr  Extra attributes to add to the index switch.
         *
         * @return void
         */
        public function index_switch($var, $label, $help = '', $attr = [])
        {
        }
        /**
         * Creates a toggle switch to show hide certain options.
         *
         * @param string $var          The variable within the option to create the radio buttons for.
         * @param string $label        The visual label for the radio buttons group, used as the fieldset legend.
         * @param bool   $inverse_keys Whether or not the option keys need to be inverted to support older functions.
         * @param string $help         Inline Help that will be printed out before the visible toggles text.
         * @param array  $attr         Extra attributes to add to the show-hide switch.
         *
         * @return void
         */
        public function show_hide_switch($var, $label, $inverse_keys = \false, $help = '', $attr = [])
        {
        }
        /**
         * Retrieves the value for the form field.
         *
         * @param string      $field_name    The field name to retrieve the value for.
         * @param string|null $default_value The default value, when field has no value.
         *
         * @return mixed|null The retrieved value.
         */
        protected function get_field_value($field_name, $default_value = \null)
        {
        }
        /**
         * Checks whether a given control should be disabled.
         *
         * @param string $var The variable within the option to check whether its control should be disabled.
         *
         * @return bool True if control should be disabled, false otherwise.
         */
        protected function is_control_disabled($var)
        {
        }
        /**
         * Gets the explanation note to print if a given control is disabled.
         *
         * @param string $var The variable within the option to print a disabled note for.
         *
         * @return string Explanation note HTML string, or empty string if no note necessary.
         */
        protected function get_disabled_note($var)
        {
        }
        /**
         * Determines whether we are dealing with the Usage tracking feature on a multisite subsite.
         * This feature requires specific behavior for the toggle switch.
         *
         * @param string $feature_setting The feature setting.
         *
         * @return bool True if we are dealing with the Usage tracking feature on a multisite subsite.
         */
        protected function is_tracking_on_subsite($feature_setting)
        {
        }
        /**
         * Returns the disabled attribute HTML.
         *
         * @param string $var  The variable within the option of the related form element.
         * @param array  $attr Extra attributes added to the form element.
         *
         * @return string The disabled attribute HTML.
         */
        protected function get_disabled_attribute($var, $attr)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Implements server-side user input validation.
     *
     * @since 12.0
     */
    class Yoast_Input_Validation
    {
        /**
         * The error descriptions.
         *
         * @since 12.1
         *
         * @var array
         */
        private static $error_descriptions = [];
        /**
         * Check whether an option group is a Yoast SEO setting.
         *
         * The normal pattern is 'yoast' . $option_name . 'options'.
         *
         * @since 12.0
         *
         * @param string $group_name The option group name.
         *
         * @return bool Whether or not it's an Yoast SEO option group.
         */
        public static function is_yoast_option_group_name($group_name)
        {
        }
        /**
         * Adds an error message to the document title when submitting a settings
         * form and errors are returned.
         *
         * Uses the WordPress `admin_title` filter in the WPSEO_Option subclasses.
         *
         * @since 12.0
         *
         * @param string $admin_title The page title, with extra context added.
         *
         * @return string The modified or original admin title.
         */
        public static function add_yoast_admin_document_title_errors($admin_title)
        {
        }
        /**
         * Checks whether a specific form input field was submitted with an invalid value.
         *
         * @since 12.1
         *
         * @param string $error_code Must be the same slug-name used for the field variable and for `add_settings_error()`.
         *
         * @return bool Whether or not the submitted input field contained an invalid value.
         */
        public static function yoast_form_control_has_error($error_code)
        {
        }
        /**
         * Sets the error descriptions.
         *
         * @since 12.1
         *
         * @param array $descriptions An associative array of error descriptions.
         *                            For each entry, the key must be the setting variable.
         */
        public static function set_error_descriptions($descriptions = [])
        {
        }
        /**
         * Gets all the error descriptions.
         *
         * @since 12.1
         *
         * @return array An associative array of error descriptions.
         */
        public static function get_error_descriptions()
        {
        }
        /**
         * Gets a specific error description.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string|null The error description.
         */
        public static function get_error_description($error_code)
        {
        }
        /**
         * Gets the aria-invalid HTML attribute based on the submitted invalid value.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string The aria-invalid HTML attribute or empty string.
         */
        public static function get_the_aria_invalid_attribute($error_code)
        {
        }
        /**
         * Gets the aria-describedby HTML attribute based on the submitted invalid value.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string The aria-describedby HTML attribute or empty string.
         */
        public static function get_the_aria_describedby_attribute($error_code)
        {
        }
        /**
         * Gets the error description wrapped in a HTML paragraph.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string The error description HTML or empty string.
         */
        public static function get_the_error_description($error_code)
        {
        }
        /**
         * Adds the submitted invalid value to the WordPress `$wp_settings_errors` global.
         *
         * @since 12.1
         *
         * @param string $error_code  Code of the error set via `add_settings_error()`, normally the variable name.
         * @param string $dirty_value The submitted invalid value.
         *
         * @return void
         */
        public static function add_dirty_value_to_settings_errors($error_code, $dirty_value)
        {
        }
        /**
         * Gets an invalid submitted value.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string The submitted invalid input field value.
         */
        public static function get_dirty_value($error_code)
        {
        }
        /**
         * Gets a specific invalid value message.
         *
         * @since 12.1
         *
         * @param string $error_code Code of the error set via `add_settings_error()`, normally the variable name.
         *
         * @return string The error invalid value message or empty string.
         */
        public static function get_dirty_value_message($error_code)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * An interface for registering AJAX integrations with WordPress.
     */
    interface WPSEO_WordPress_AJAX_Integration
    {
        /**
         * Registers all AJAX hooks to WordPress.
         *
         * @return void
         */
        public function register_ajax_hooks();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Multisite utility class for network admin functionality.
     */
    class Yoast_Network_Admin implements \WPSEO_WordPress_AJAX_Integration, \WPSEO_WordPress_Integration
    {
        /**
         * Action identifier for updating plugin network options.
         *
         * @var string
         */
        const UPDATE_OPTIONS_ACTION = 'yoast_handle_network_options';
        /**
         * Action identifier for restoring a site.
         *
         * @var string
         */
        const RESTORE_SITE_ACTION = 'yoast_restore_site';
        /**
         * Gets the available sites as choices, e.g. for a dropdown.
         *
         * @param bool $include_empty Optional. Whether to include an initial placeholder choice.
         *                            Default false.
         * @param bool $show_title    Optional. Whether to show the title for each site. This requires
         *                            switching through the sites, so has performance implications for
         *                            sites that do not use a persistent cache.
         *                            Default false.
         *
         * @return array Choices as $site_id => $site_label pairs.
         */
        public function get_site_choices($include_empty = \false, $show_title = \false)
        {
        }
        /**
         * Gets the states of a site.
         *
         * @param WP_Site $site Site object.
         *
         * @return array Array of $state_slug => $state_label pairs.
         */
        public function get_site_states($site)
        {
        }
        /**
         * Handles a request to update plugin network options.
         *
         * This method works similar to how option updates are handled in `wp-admin/options.php` and
         * `wp-admin/network/settings.php`.
         *
         * @return void
         */
        public function handle_update_options_request()
        {
        }
        /**
         * Handles a request to restore a site's default settings.
         *
         * @return void
         */
        public function handle_restore_site_request()
        {
        }
        /**
         * Outputs nonce, action and option group fields for a network settings page in the plugin.
         *
         * @param string $option_group Option group name for the current page.
         *
         * @return void
         */
        public function settings_fields($option_group)
        {
        }
        /**
         * Enqueues network admin assets.
         *
         * @return void
         */
        public function enqueue_assets()
        {
        }
        /**
         * Hooks in the necessary actions and filters.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Hooks in the necessary AJAX actions.
         *
         * @return void
         */
        public function register_ajax_hooks()
        {
        }
        /**
         * Checks whether the requirements to use this class are met.
         *
         * @return bool True if requirements are met, false otherwise.
         */
        public function meets_requirements()
        {
        }
        /**
         * Verifies that the current request is valid.
         *
         * @param string $action    Nonce action.
         * @param string $query_arg Optional. Nonce query argument. Default '_wpnonce'.
         *
         * @return void
         */
        public function verify_request($action, $query_arg = '_wpnonce')
        {
        }
        /**
         * Terminates the current request by either redirecting back or sending an AJAX response.
         *
         * @return void
         */
        public function terminate_request()
        {
        }
        /**
         * Persists settings errors.
         *
         * Settings errors are stored in a transient for 30 seconds so that this transient
         * can be retrieved on the next page load.
         *
         * @return void
         */
        protected function persist_settings_errors()
        {
        }
        /**
         * Redirects back to the referer URL, with optional query arguments.
         *
         * @param array $query_args Optional. Query arguments to add to the redirect URL. Default none.
         *
         * @return void
         */
        protected function redirect_back($query_args = [])
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Network
     */
    /**
     * Implements a network settings API for the plugin's multisite settings.
     */
    class Yoast_Network_Settings_API
    {
        /**
         * Registered network settings.
         *
         * @var array
         */
        private $registered_settings = [];
        /**
         * Options whitelist, keyed by option group.
         *
         * @var array
         */
        private $whitelist_options = [];
        /**
         * The singleton instance of this class.
         *
         * @var Yoast_Network_Settings_API
         */
        private static $instance = \null;
        /**
         * Registers a network setting and its data.
         *
         * @param string $option_group The group the network option is part of.
         * @param string $option_name  The name of the network option to sanitize and save.
         * @param array  $args         {
         *     Optional. Data used to describe the network setting when registered.
         *
         *     @type callable $sanitize_callback A callback function that sanitizes the network option's value.
         *     @type mixed    $default           Default value when calling `get_network_option()`.
         * }
         *
         * @return void
         */
        public function register_setting($option_group, $option_name, $args = [])
        {
        }
        /**
         * Gets the registered settings and their data.
         *
         * @return array Array of $option_name => $data pairs.
         */
        public function get_registered_settings()
        {
        }
        /**
         * Gets the whitelisted options for a given option group.
         *
         * @param string $option_group Option group.
         *
         * @return array List of option names, or empty array if unknown option group.
         */
        public function get_whitelist_options($option_group)
        {
        }
        /**
         * Filters sanitization for a network option value.
         *
         * This method is added as a filter to `sanitize_option_{$option}` for network options that are
         * registered with a sanitize callback.
         *
         * @param string $value  The sanitized option value.
         * @param string $option The option name.
         *
         * @return string The filtered sanitized option value.
         */
        public function filter_sanitize_option($value, $option)
        {
        }
        /**
         * Filters the default value for a network option.
         *
         * This function is added as a filter to `default_site_option_{$option}` for network options that
         * are registered with a default.
         *
         * @param mixed  $default Existing default value to return.
         * @param string $option  The option name.
         *
         * @return mixed The filtered default value.
         */
        public function filter_default_option($default, $option)
        {
        }
        /**
         * Checks whether the requirements to use this class are met.
         *
         * @return bool True if requirements are met, false otherwise.
         */
        public function meets_requirements()
        {
        }
        /**
         * Gets the singleton instance of this class.
         *
         * @return Yoast_Network_Settings_API The singleton instance.
         */
        public static function get()
        {
        }
    }
    /**
     * Handles notifications storage and display.
     */
    class Yoast_Notification_Center
    {
        /**
         * Option name to store notifications on.
         *
         * @var string
         */
        const STORAGE_KEY = 'yoast_notifications';
        /**
         * The singleton instance of this object.
         *
         * @var \Yoast_Notification_Center
         */
        private static $instance = \null;
        /**
         * Holds the notifications.
         *
         * @var \Yoast_Notification[][]
         */
        private $notifications = [];
        /**
         * Notifications there are newly added.
         *
         * @var array
         */
        private $new = [];
        /**
         * Notifications that were resolved this execution.
         *
         * @var int
         */
        private $resolved = 0;
        /**
         * Internal storage for transaction before notifications have been retrieved from storage.
         *
         * @var array
         */
        private $queued_transactions = [];
        /**
         * Internal flag for whether notifications have been retrieved from storage.
         *
         * @var bool
         */
        private $notifications_retrieved = \false;
        /**
         * Internal flag for whether notifications need to be updated in storage.
         *
         * @var bool
         */
        private $notifications_need_storage = \false;
        /**
         * Construct.
         */
        private function __construct()
        {
        }
        /**
         * Singleton getter.
         *
         * @return Yoast_Notification_Center
         */
        public static function get()
        {
        }
        /**
         * Dismiss a notification.
         */
        public static function ajax_dismiss_notification()
        {
        }
        /**
         * Check if the user has dismissed a notification.
         *
         * @param Yoast_Notification $notification The notification to check for dismissal.
         * @param int|null           $user_id      User ID to check on.
         *
         * @return bool
         */
        public static function is_notification_dismissed(\Yoast_Notification $notification, $user_id = \null)
        {
        }
        /**
         * Checks if the notification is being dismissed.
         *
         * @param Yoast_Notification $notification Notification to check dismissal of.
         * @param string             $meta_value   Value to set the meta value to if dismissed.
         *
         * @return bool True if dismissed.
         */
        public static function maybe_dismiss_notification(\Yoast_Notification $notification, $meta_value = 'seen')
        {
        }
        /**
         * Dismisses a notification.
         *
         * @param Yoast_Notification $notification Notification to dismiss.
         * @param string             $meta_value   Value to save in the dismissal.
         *
         * @return bool True if dismissed, false otherwise.
         */
        public static function dismiss_notification(\Yoast_Notification $notification, $meta_value = 'seen')
        {
        }
        /**
         * Restores a notification.
         *
         * @param Yoast_Notification $notification Notification to restore.
         *
         * @return bool True if restored, false otherwise.
         */
        public static function restore_notification(\Yoast_Notification $notification)
        {
        }
        /**
         * Clear dismissal information for the specified Notification.
         *
         * When a cause is resolved, the next time it is present we want to show
         * the message again.
         *
         * @param string|Yoast_Notification $notification Notification to clear the dismissal of.
         *
         * @return bool
         */
        public function clear_dismissal($notification)
        {
        }
        /**
         * Retrieves notifications from the storage and merges in previous notification changes.
         *
         * The current user in WordPress is not loaded shortly before the 'init' hook, but the plugin
         * sometimes needs to add or remove notifications before that. In such cases, the transactions
         * are not actually executed, but added to a queue. That queue is then handled in this method,
         * after notifications for the current user have been set up.
         *
         * @return void
         */
        public function setup_current_notifications()
        {
        }
        /**
         * Add notification to the cookie.
         *
         * @param Yoast_Notification $notification Notification object instance.
         */
        public function add_notification(\Yoast_Notification $notification)
        {
        }
        /**
         * Get the notification by ID and user ID.
         *
         * @param string   $notification_id The ID of the notification to search for.
         * @param int|null $user_id         The ID of the user.
         *
         * @return Yoast_Notification|null
         */
        public function get_notification_by_id($notification_id, $user_id = \null)
        {
        }
        /**
         * Display the notifications.
         *
         * @param bool $echo_as_json True when notifications should be printed directly.
         *
         * @return void
         */
        public function display_notifications($echo_as_json = \false)
        {
        }
        /**
         * Remove notification after it has been displayed.
         *
         * @param Yoast_Notification $notification Notification to remove.
         * @param bool               $resolve      Resolve as fixed.
         */
        public function remove_notification(\Yoast_Notification $notification, $resolve = \true)
        {
        }
        /**
         * Removes a notification by its ID.
         *
         * @param string $notification_id The notification id.
         * @param bool   $resolve         Resolve as fixed.
         *
         * @return void
         */
        public function remove_notification_by_id($notification_id, $resolve = \true)
        {
        }
        /**
         * Get the notification count.
         *
         * @param bool $dismissed Count dismissed notifications.
         *
         * @return int Number of notifications
         */
        public function get_notification_count($dismissed = \false)
        {
        }
        /**
         * Get the number of notifications resolved this execution.
         *
         * These notifications have been resolved and should be counted when active again.
         *
         * @return int
         */
        public function get_resolved_notification_count()
        {
        }
        /**
         * Return the notifications sorted on type and priority.
         *
         * @return array|Yoast_Notification[] Sorted Notifications
         */
        public function get_sorted_notifications()
        {
        }
        /**
         * AJAX display notifications.
         */
        public function ajax_get_notifications()
        {
        }
        /**
         * Remove storage when the plugin is deactivated.
         */
        public function deactivate_hook()
        {
        }
        /**
         * Returns the given user ID if it exists.
         * Otherwise, this function returns the ID of the current user.
         *
         * @param int $user_id The user ID to check.
         *
         * @return int The user ID to use.
         */
        private static function get_user_id($user_id)
        {
        }
        /**
         * Splits the notifications on user ID.
         *
         * In other terms, it returns an associative array,
         * mapping user ID to a list of notifications for this user.
         *
         * @param array|Yoast_Notification[] $notifications The notifications to split.
         *
         * @return array The notifications, split on user ID.
         */
        private function split_on_user_id($notifications)
        {
        }
        /**
         * Save persistent notifications to storage.
         *
         * We need to be able to retrieve these so they can be dismissed at any time during the execution.
         *
         * @since 3.2
         *
         * @return void
         */
        public function update_storage()
        {
        }
        /**
         * Stores the notifications to its respective user's storage.
         *
         * @param array|Yoast_Notification[] $notifications The notifications to store.
         * @param int                        $user_id       The ID of the user for which to store the notifications.
         *
         * @return void
         */
        private function store_notifications_for_user($notifications, $user_id)
        {
        }
        /**
         * Provide a way to verify present notifications.
         *
         * @return array|Yoast_Notification[] Registered notifications.
         */
        public function get_notifications()
        {
        }
        /**
         * Returns the notifications for the given user.
         *
         * @param int $user_id The id of the user to check.
         *
         * @return Yoast_Notification[] The notifications for the user with the given ID.
         */
        public function get_notifications_for_user($user_id)
        {
        }
        /**
         * Get newly added notifications.
         *
         * @return array
         */
        public function get_new_notifications()
        {
        }
        /**
         * Get information from the User input.
         *
         * @param string $key Key to retrieve.
         *
         * @return mixed value of key if set.
         */
        private static function get_user_input($key)
        {
        }
        /**
         * Retrieve the notifications from storage and fill the relevant property.
         *
         * @param int $user_id The ID of the user to retrieve notifications for.
         *
         * @return void
         */
        private function retrieve_notifications_from_storage($user_id)
        {
        }
        /**
         * Sort on type then priority.
         *
         * @param Yoast_Notification $a Compare with B.
         * @param Yoast_Notification $b Compare with A.
         *
         * @return int 1, 0 or -1 for sorting offset.
         */
        private function sort_notifications(\Yoast_Notification $a, \Yoast_Notification $b)
        {
        }
        /**
         * Clear local stored notifications.
         */
        private function clear_notifications()
        {
        }
        /**
         * Filter out non-persistent notifications.
         *
         * @since 3.2
         *
         * @param Yoast_Notification $notification Notification to test for persistent.
         *
         * @return bool
         */
        private function filter_persistent_notifications(\Yoast_Notification $notification)
        {
        }
        /**
         * Filter out dismissed notifications.
         *
         * @param Yoast_Notification $notification Notification to check.
         *
         * @return bool
         */
        private function filter_dismissed_notifications(\Yoast_Notification $notification)
        {
        }
        /**
         * Convert Notification to array representation.
         *
         * @since 3.2
         *
         * @param Yoast_Notification $notification Notification to convert.
         *
         * @return array
         */
        private function notification_to_array(\Yoast_Notification $notification)
        {
        }
        /**
         * Convert stored array to Notification.
         *
         * @param array $notification_data Array to convert to Notification.
         *
         * @return Yoast_Notification
         */
        private function array_to_notification($notification_data)
        {
        }
        /**
         * Filter notifications that should not be displayed for the current user.
         *
         * @param Yoast_Notification $notification Notification to test.
         *
         * @return bool
         */
        private function filter_notification_current_user(\Yoast_Notification $notification)
        {
        }
        /**
         * Checks if given notification is persistent.
         *
         * @param Yoast_Notification $notification The notification to check.
         *
         * @return bool True when notification is not persistent.
         */
        private function is_notification_persistent(\Yoast_Notification $notification)
        {
        }
        /**
         * Queues a notification transaction for later execution if notifications are not yet set up.
         *
         * @param callable $callback Callback that performs the transaction.
         * @param array    $args     Arguments to pass to the callback.
         *
         * @return bool True if transaction was queued, false if it can be performed immediately.
         */
        private function queue_transaction($callback, $args)
        {
        }
        /**
         * Adds a notification transaction to the queue for later execution.
         *
         * @param callable $callback Callback that performs the transaction.
         * @param array    $args     Arguments to pass to the callback.
         */
        private function add_transaction_to_queue($callback, $args)
        {
        }
        /**
         * Removes all notifications from storage.
         *
         * @return bool True when notifications got removed.
         */
        protected function remove_storage()
        {
        }
        /**
         * Checks if there are stored notifications.
         *
         * @return bool True when there are stored notifications.
         */
        protected function has_stored_notifications()
        {
        }
        /**
         * Retrieves the stored notifications.
         *
         * @codeCoverageIgnore
         *
         * @return array|false Array with notifications or false when not set.
         */
        protected function get_stored_notifications()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Notifications
     * @since   1.5.3
     */
    /**
     * Implements individual notification.
     */
    class Yoast_Notification
    {
        /**
         * Type of capability check.
         *
         * @var string
         */
        const MATCH_ALL = 'all';
        /**
         * Type of capability check.
         *
         * @var string
         */
        const MATCH_ANY = 'any';
        /**
         * Notification type.
         *
         * @var string
         */
        const ERROR = 'error';
        /**
         * Notification type.
         *
         * @var string
         */
        const WARNING = 'warning';
        /**
         * Notification type.
         *
         * @var string
         */
        const UPDATED = 'updated';
        /**
         * Options of this Notification.
         *
         * Contains optional arguments:
         *
         * -             type: The notification type, i.e. 'updated' or 'error'
         * -               id: The ID of the notification
         * -            nonce: Security nonce to use in case of dismissible notice.
         * -         priority: From 0 to 1, determines the order of Notifications.
         * -    dismissal_key: Option name to save dismissal information in, ID will be used if not supplied.
         * -     capabilities: Capabilities that a user must have for this Notification to show.
         * - capability_check: How to check capability pass: all or any.
         * -  wpseo_page_only: Only display on wpseo page or on every page.
         *
         * @var array
         */
        private $options = [];
        /**
         * Contains default values for the optional arguments.
         *
         * @var array
         */
        private $defaults = ['type' => self::UPDATED, 'id' => '', 'user' => \null, 'nonce' => \null, 'priority' => 0.5, 'data_json' => [], 'dismissal_key' => \null, 'capabilities' => [], 'capability_check' => self::MATCH_ALL, 'yoast_branding' => \false];
        /**
         * The message for the notification.
         *
         * @var string
         */
        private $message;
        /**
         * Notification class constructor.
         *
         * @param string $message Message string.
         * @param array  $options Set of options.
         */
        public function __construct($message, $options = [])
        {
        }
        /**
         * Retrieve notification ID string.
         *
         * @return string
         */
        public function get_id()
        {
        }
        /**
         * Retrieve the user to show the notification for.
         *
         * @return WP_User The user to show this notification for.
         */
        public function get_user()
        {
        }
        /**
         * Retrieve the is of the user to show the notification for.
         *
         * Returns the id of the current user if not user has been sent.
         *
         * @return int The user id
         */
        public function get_user_id()
        {
        }
        /**
         * Retrieve nonce identifier.
         *
         * @return string|null Nonce for this Notification.
         */
        public function get_nonce()
        {
        }
        /**
         * Make sure the nonce is up to date.
         */
        public function refresh_nonce()
        {
        }
        /**
         * Get the type of the notification.
         *
         * @return string
         */
        public function get_type()
        {
        }
        /**
         * Priority of the notification.
         *
         * Relative to the type.
         *
         * @return float Returns the priority between 0 and 1.
         */
        public function get_priority()
        {
        }
        /**
         * Get the User Meta key to check for dismissal of notification.
         *
         * @return string User Meta Option key that registers dismissal.
         */
        public function get_dismissal_key()
        {
        }
        /**
         * Is this Notification persistent.
         *
         * @return bool True if persistent, False if fire and forget.
         */
        public function is_persistent()
        {
        }
        /**
         * Check if the notification is relevant for the current user.
         *
         * @return bool True if a user needs to see this notification, false if not.
         */
        public function display_for_current_user()
        {
        }
        /**
         * Does the current user match required capabilities.
         *
         * @return bool
         */
        public function match_capabilities()
        {
        }
        /**
         * Array filter function to find matched capabilities.
         *
         * @param string $capability Capability to test.
         *
         * @return bool
         */
        private function has_capability($capability)
        {
        }
        /**
         * Return the object properties as an array.
         *
         * @return array
         */
        public function to_array()
        {
        }
        /**
         * Adds string (view) behaviour to the notification.
         *
         * @return string
         */
        public function __toString()
        {
        }
        /**
         * Renders the notification as a string.
         *
         * @return string The rendered notification.
         */
        public function render()
        {
        }
        /**
         * Wraps the message with a Yoast SEO icon.
         *
         * @param string $message The message to wrap.
         *
         * @return string The wrapped message.
         */
        private function wrap_yoast_seo_icon($message)
        {
        }
        /**
         * Get the JSON if provided.
         *
         * @return false|string
         */
        public function get_json()
        {
        }
        /**
         * Make sure we only have values that we can work with.
         *
         * @param array $options Options to normalize.
         *
         * @return array
         */
        private function normalize_options($options)
        {
        }
        /**
         * Format HTML element attributes.
         *
         * @param string $value Attribute value.
         * @param string $key   Attribute name.
         */
        private function parse_attributes(&$value, $key)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Notifications
     */
    /**
     * Class Yoast_Notifications.
     */
    class Yoast_Notifications
    {
        /**
         * Holds the admin page's ID.
         *
         * @var string
         */
        const ADMIN_PAGE = 'wpseo_dashboard';
        /**
         * Total notifications count.
         *
         * @var int
         */
        private static $notification_count = 0;
        /**
         * All error notifications.
         *
         * @var array
         */
        private static $errors = [];
        /**
         * Active errors.
         *
         * @var array
         */
        private static $active_errors = [];
        /**
         * Dismissed errors.
         *
         * @var array
         */
        private static $dismissed_errors = [];
        /**
         * All warning notifications.
         *
         * @var array
         */
        private static $warnings = [];
        /**
         * Active warnings.
         *
         * @var array
         */
        private static $active_warnings = [];
        /**
         * Dismissed warnings.
         *
         * @var array
         */
        private static $dismissed_warnings = [];
        /**
         * Yoast_Notifications constructor.
         */
        public function __construct()
        {
        }
        /**
         * Add hooks
         */
        private function add_hooks()
        {
        }
        /**
         * Enqueue assets.
         */
        public function enqueue_assets()
        {
        }
        /**
         * Deprecated: Handle ajax request to dismiss a alert.
         * Renamed to ajax_dismiss_notification
         *
         * @deprecated 14.0
         *
         * @codeCoverageIgnore
         */
        public function ajax_dismiss_alert()
        {
        }
        /**
         * Handle ajax request to dismiss a notification.
         */
        public function ajax_dismiss_notification()
        {
        }
        /**
         * Deprecated: Handle ajax request to restore a notification.
         * Renamed to ajax_restore_notification
         *
         * @deprecated 14.0
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function ajax_restore_alert()
        {
        }
        /**
         * Handle ajax request to restore a notification.
         */
        public function ajax_restore_notification()
        {
        }
        /**
         * Create AJAX response data.
         *
         * @param string $type Notification type.
         */
        private function output_ajax_response($type)
        {
        }
        /**
         * Get the HTML to return in the AJAX request.
         *
         * @param string $type Notification type.
         *
         * @return bool|string
         */
        private function get_view_html($type)
        {
        }
        /**
         * Extract the Yoast Notification from the AJAX request.
         *
         * @return Yoast_Notification|null
         */
        private function get_notification_from_ajax_request()
        {
        }
        /**
         * Collect the notifications and group them together.
         */
        public static function collect_notifications()
        {
        }
        /**
         * Get the variables needed in the views.
         *
         * @return array
         */
        public static function get_template_variables()
        {
        }
        /**
         * Deprecated: Get the number of active notifications.
         * Renamed to get_active_notification_count
         *
         * @deprecated 14.0
         * @codeCoverageIgnore
         *
         * @return int
         */
        public function get_active_alert_count()
        {
        }
        /**
         * Get the number of active notifications.
         *
         * @return int
         */
        public static function get_active_notification_count()
        {
        }
        /**
         * Deprecated: Filter out any non-errors. Renamed to filter_error_notifications
         *
         * @deprecated 14.0
         * @codeCoverageIgnore
         *
         * @param Yoast_Notification $notification Notification to test.
         * @return bool
         */
        public function filter_error_alerts(\Yoast_Notification $notification)
        {
        }
        /**
         * Filter out any non-errors.
         *
         * @param Yoast_Notification $notification Notification to test.
         *
         * @return bool
         */
        private static function filter_error_notifications(\Yoast_Notification $notification)
        {
        }
        /**
         * Deprecated: Filter out any non-warnings. Renamed to filter_warning_notifications
         *
         * @deprecated 14.0
         * @codeCoverageIgnore
         *
         * @param Yoast_Notification $notification Notification to test.
         * @return bool
         */
        public function filter_warning_alerts(\Yoast_Notification $notification)
        {
        }
        /**
         * Filter out any non-warnings.
         *
         * @param Yoast_Notification $notification Notification to test.
         *
         * @return bool
         */
        private static function filter_warning_notifications(\Yoast_Notification $notification)
        {
        }
        /**
         * Deprecated: Filter out any dismissed notifications. Renamed to filter_dismissed_alerts.
         *
         * @deprecated 14.0
         * @codeCoverageIgnore
         *
         * @param Yoast_Notification $notification Notification to test.
         * @return bool
         */
        public function filter_dismissed_alerts(\Yoast_Notification $notification)
        {
        }
        /**
         * Filter out any dismissed notifications.
         *
         * @param Yoast_Notification $notification Notification to test.
         *
         * @return bool
         */
        private static function filter_dismissed_notifications(\Yoast_Notification $notification)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Components.
     */
    class WPSEO_Configuration_Components
    {
        /**
         * List of registered components.
         *
         * @var WPSEO_Config_Component[]
         */
        protected $components = [];
        /**
         * Adapter.
         *
         * @var WPSEO_Configuration_Options_Adapter
         */
        protected $adapter;
        /**
         * Add default components.
         */
        public function initialize()
        {
        }
        /**
         * Add a component.
         *
         * @param WPSEO_Config_Component $component Component to add.
         */
        public function add_component(\WPSEO_Config_Component $component)
        {
        }
        /**
         * Sets the storage to use.
         *
         * @param WPSEO_Configuration_Storage $storage Storage to use.
         */
        public function set_storage(\WPSEO_Configuration_Storage $storage)
        {
        }
        /**
         * Sets the adapter to use.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to use.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Endpoint.
     */
    class WPSEO_Configuration_Endpoint
    {
        /**
         * Holds the REST namespace.
         *
         * @var string
         */
        const REST_NAMESPACE = 'yoast/v1';
        /**
         * Holds the endpoint to retrieve from.
         *
         * @var string
         */
        const ENDPOINT_RETRIEVE = 'configurator';
        /**
         * Holds the endpoint to store to.
         *
         * @var string
         */
        const ENDPOINT_STORE = 'configurator';
        /**
         * Holds the capability that can retrieve from the endpoint.
         *
         * @var string
         */
        const CAPABILITY_RETRIEVE = 'wpseo_manage_options';
        /**
         * Holds the capability that can store to the endpoint.
         *
         * @var string
         */
        const CAPABILITY_STORE = 'wpseo_manage_options';
        /**
         * Service to use.
         *
         * @var WPSEO_Configuration_Service
         */
        protected $service;
        /**
         * Sets the service to use.
         *
         * @param WPSEO_Configuration_Service $service Service to use.
         */
        public function set_service(\WPSEO_Configuration_Service $service)
        {
        }
        /**
         * Register REST routes.
         */
        public function register()
        {
        }
        /**
         * Permission callback implementation.
         *
         * @return bool
         */
        public function can_retrieve_data()
        {
        }
        /**
         * Permission callback implementation.
         *
         * @return bool
         */
        public function can_save_data()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Options_Adapter.
     *
     * Convert Configuration settings to WPSEO Options.
     *
     * @since 3.6
     */
    class WPSEO_Configuration_Options_Adapter
    {
        /**
         * Holds the option type value that indicates: WordPress.
         *
         * @var string
         */
        const OPTION_TYPE_WORDPRESS = 'wordpress';
        /**
         * Holds the option type value that indicates: Yoast.
         *
         * @var string
         */
        const OPTION_TYPE_YOAST = 'yoast';
        /**
         * Holds the option type value that indicates: Custom.
         *
         * @var string
         */
        const OPTION_TYPE_CUSTOM = 'custom';
        /**
         * List of registered lookups.
         *
         * @var array
         */
        protected $lookup = [];
        /**
         * Add a lookup for a WordPress native option.
         *
         * @param string $class_name Class to bind to an option.
         * @param string $option     Option name to use.
         *
         * @throws InvalidArgumentException Thrown when invalid input is provided.
         */
        public function add_wordpress_lookup($class_name, $option)
        {
        }
        /**
         * Add a lookup for a Yoast option.
         *
         * @param string $class_name Class to bind to the lookup.
         * @param string $key        Key in the option group to bind to.
         *
         * @throws InvalidArgumentException Thrown when invalid input is provided.
         */
        public function add_option_lookup($class_name, $key)
        {
        }
        /**
         * Add a lookup for a custom implementation.
         *
         * @param string   $class_name   Class to bind to the lookup.
         * @param callable $callback_get Callback to retrieve data.
         * @param callable $callback_set Callback to save data.
         *
         * @throws InvalidArgumentException Thrown when invalid input is provided.
         */
        public function add_custom_lookup($class_name, $callback_get, $callback_set)
        {
        }
        /**
         * Add a field lookup.
         *
         * @param string       $class_name Class to add lookup for.
         * @param string       $type       Type of lookup.
         * @param string|array $option     Implementation of the lookup.
         *
         * @throws Exception Thrown when invalid input is provided.
         */
        protected function add_lookup($class_name, $type, $option)
        {
        }
        /**
         * Get the data for the provided field.
         *
         * @param WPSEO_Config_Field $field Field to get data for.
         *
         * @return mixed
         */
        public function get(\WPSEO_Config_Field $field)
        {
        }
        /**
         * Save data from a field.
         *
         * @param WPSEO_Config_Field $field Field to use for lookup.
         * @param mixed              $value Value to save to the lookup of the field.
         *
         * @return bool
         */
        public function set(\WPSEO_Config_Field $field, $value)
        {
        }
        /**
         * Get the lookup type for a specific class.
         *
         * @param string $class_name Class to get the type of.
         *
         * @return string|null
         */
        protected function get_option_type($class_name)
        {
        }
        /**
         * Get the option for a specific class.
         *
         * @param string $class_name Class to get the option of.
         *
         * @return string|array|null
         */
        protected function get_option($class_name)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Loads the Yoast configuration wizard.
     */
    class WPSEO_Configuration_Page
    {
        /**
         * Admin page identifier.
         *
         * @var string
         */
        const PAGE_IDENTIFIER = 'wpseo_configurator';
        /**
         * Sets the hooks when the user has enough rights and is on the right page.
         */
        public function set_hooks()
        {
        }
        /**
         * Check if the configuration is finished. If so, just remove the notification.
         */
        public function catch_configuration_request()
        {
        }
        /**
         * Registers the page for the wizard.
         */
        public function add_wizard_page()
        {
        }
        /**
         * Renders the wizard page and exits to prevent the WordPress UI from loading.
         */
        public function render_wizard_page()
        {
        }
        /**
         * Enqueues the assets needed for the wizard.
         */
        public function enqueue_assets()
        {
        }
        /**
         * Setup Wizard Header.
         */
        public function show_wizard()
        {
        }
        /**
         * Get the API config for the wizard.
         *
         * @return array The API endpoint config.
         */
        public function get_config()
        {
        }
        /**
         * Checks if the current page is the configuration page.
         *
         * @return bool
         */
        protected function is_config_page()
        {
        }
        /**
         * Adds a notification to the notification center.
         */
        private function add_notification()
        {
        }
        /**
         * Removes the notification from the notification center.
         */
        private function remove_notification()
        {
        }
        /**
         * Gets the notification.
         *
         * @return Yoast_Notification
         */
        private static function get_notification()
        {
        }
        /**
         * When the notice should be shown.
         *
         * @return bool
         */
        private function should_add_notification()
        {
        }
        /**
         * Remove the options that triggers the notice for the configuration wizard.
         */
        private function remove_notification_option()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Service.
     */
    class WPSEO_Configuration_Service
    {
        /**
         * Class holding the onboarding wizard configuration.
         *
         * @var WPSEO_Configuration_Structure
         */
        protected $structure;
        /**
         * Class holding the onboarding wizard components.
         *
         * @var WPSEO_Configuration_Components
         */
        protected $components;
        /**
         * Class handling the onboarding wizard persistence.
         *
         * @var WPSEO_Configuration_Storage
         */
        protected $storage;
        /**
         * Class handling the onboarding wizard endpoint.
         *
         * @var WPSEO_Configuration_Endpoint
         */
        protected $endpoint;
        /**
         * Adapter that converts onboarding wizard configuration to WordPress options.
         *
         * @var WPSEO_Configuration_Options_Adapter
         */
        protected $adapter;
        /**
         * Class handling the onboarding wizard endpoint.
         *
         * @var WPSEO_Configuration_Translations
         */
        protected $translations;
        /**
         * Hook into the REST API and switch language.
         */
        public function initialize()
        {
        }
        /**
         * Set default handlers.
         */
        public function set_default_providers()
        {
        }
        /**
         * Set storage handler.
         *
         * @param WPSEO_Configuration_Storage $storage Storage handler to use.
         */
        public function set_storage(\WPSEO_Configuration_Storage $storage)
        {
        }
        /**
         * Set endpoint handler.
         *
         * @param WPSEO_Configuration_Endpoint $endpoint Endpoint implementation to use.
         */
        public function set_endpoint(\WPSEO_Configuration_Endpoint $endpoint)
        {
        }
        /**
         * Set the options adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to use.
         */
        public function set_options_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Set components provider.
         *
         * @param WPSEO_Configuration_Components $components Component provider to use.
         */
        public function set_components(\WPSEO_Configuration_Components $components)
        {
        }
        /**
         * Set structure provider.
         *
         * @param WPSEO_Configuration_Structure $structure Structure provider to use.
         */
        public function set_structure(\WPSEO_Configuration_Structure $structure)
        {
        }
        /**
         * Sets the translations object.
         *
         * @param WPSEO_Configuration_Translations $translations The translations object.
         */
        public function set_translations(\WPSEO_Configuration_Translations $translations)
        {
        }
        /**
         * Populate the configuration.
         */
        protected function populate_configuration()
        {
        }
        /**
         * Used by endpoint to retrieve configuration.
         *
         * @return array List of settings.
         */
        public function get_configuration()
        {
        }
        /**
         * Used by endpoint to store changes.
         *
         * @param WP_REST_Request $request Request from the REST API.
         *
         * @return array List of feedback per option if saving succeeded.
         */
        public function set_configuration(\WP_REST_Request $request)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Storage.
     */
    class WPSEO_Configuration_Storage
    {
        /**
         * Holds the configuration options adapter.
         *
         * @var \WPSEO_Configuration_Options_Adapter
         */
        protected $adapter;
        /**
         * Holds the configuration fields.
         *
         * @var \WPSEO_Config_Field[]
         */
        protected $fields = [];
        /**
         * Add default fields.
         */
        public function add_default_fields()
        {
        }
        /**
         * Allow for field injections.
         *
         * @param WPSEO_Config_Field $field Field to add to the stack.
         */
        public function add_field(\WPSEO_Config_Field $field)
        {
        }
        /**
         * Set the adapter to use.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to use.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Retrieve the current adapter.
         *
         * @return WPSEO_Configuration_Options_Adapter
         */
        public function get_adapter()
        {
        }
        /**
         * Retrieve the registered fields.
         *
         * @return array List of settings.
         */
        public function retrieve()
        {
        }
        /**
         * Save the data.
         *
         * @param array $data_to_store Data provided by the API which needs to be processed for saving.
         *
         * @return string Results
         */
        public function store($data_to_store)
        {
        }
        /**
         * Filter out null input values.
         *
         * @param mixed $input Input to test against.
         *
         * @return bool
         */
        protected function is_not_null($input)
        {
        }
        /**
         * Get data from a specific field.
         *
         * @param WPSEO_Config_Field $field Field to get data for.
         *
         * @return array|mixed
         */
        protected function get_field_data(\WPSEO_Config_Field $field)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Structure
     */
    class WPSEO_Configuration_Structure
    {
        /**
         * Registered steps.
         *
         * @var array
         */
        protected $steps = [];
        /**
         * List of fields for each configuration step.
         *
         * This list does not include the fields for the 'postTypeVisibility'
         * step as that list will be generated on the fly.
         *
         * @var array
         */
        private $fields = ['environment_type' => ['environment_type'], 'siteType' => ['siteType'], 'publishingEntity' => ['publishingEntity', 'publishingEntityType', 'publishingEntityCompanyInfo', 'publishingEntityCompanyName', 'publishingEntityCompanyLogo', 'publishingEntityPersonId', 'profileUrlFacebook', 'profileUrlTwitter', 'profileUrlInstagram', 'profileUrlLinkedIn', 'profileUrlMySpace', 'profileUrlPinterest', 'profileUrlYouTube', 'profileUrlWikipedia'], 'multipleAuthors' => ['multipleAuthors'], 'titleTemplate' => ['titleIntro', 'siteName', 'separator'], 'tracking' => ['trackingIntro', 'tracking'], 'newsletter' => ['mailchimpSignup', 'suggestions'], 'success' => ['successMessage']];
        /**
         * WPSEO_Configuration_Structure constructor.
         */
        public function initialize()
        {
        }
        /**
         * Add a step to the structure
         *
         * @param string $identifier Identifier for this step.
         * @param string $title      Title to display for this step.
         * @param array  $fields     Fields to use on the step.
         * @param bool   $navigation Show navigation buttons.
         * @param bool   $full_width Wheter the step content is full width or not.
         */
        protected function add_step($identifier, $title, $fields, $navigation = \true, $full_width = \false)
        {
        }
        /**
         * Retrieve the registered steps.
         *
         * @return array
         */
        public function retrieve()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Configuration_Structure.
     */
    class WPSEO_Configuration_Translations
    {
        /**
         * Registered steps.
         *
         * @var array
         */
        protected $translations = [];
        /**
         * The locale.
         *
         * @var string
         */
        protected $locale;
        /**
         * Sets the translations based on the file.
         *
         * @param string $locale The locale to retrieve the translations for.
         */
        public function __construct($locale)
        {
        }
        /**
         * Retrieve the translations.
         *
         * @return array
         */
        public function retrieve()
        {
        }
        /**
         * Retrieves the translations from the JSON-file.
         *
         * @return array Array with the translations.
         */
        protected function get_translations_from_file()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Config Component interface.
     */
    interface WPSEO_Config_Component
    {
        /**
         * Get onboarding wizard component identifier.
         *
         * @return string
         */
        public function get_identifier();
        /**
         * Get onboarding wizard component data.
         *
         * @return mixed
         */
        public function get_data();
        /**
         * Save changes.
         *
         * @param array $data Data provided by the API.
         *
         * @return mixed
         */
        public function set_data($data);
        /**
         * Get onboarding wizard component field.
         *
         * @return WPSEO_Config_Field
         */
        public function get_field();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Represents the mailchimp signup components.
     */
    class WPSEO_Config_Component_Mailchimp_Signup implements \WPSEO_Config_Component
    {
        /**
         * The name of the mailchimp signup meta key.
         *
         * @var string
         */
        const META_NAME = 'wpseo-has-mailchimp-signup';
        /**
         * Gets the component identifier.
         *
         * @return string
         */
        public function get_identifier()
        {
        }
        /**
         * Gets the field.
         *
         * @return WPSEO_Config_Field_Mailchimp_Signup
         */
        public function get_field()
        {
        }
        /**
         * Get the data for the field.
         *
         * @return mixed
         */
        public function get_data()
        {
        }
        /**
         * Save data.
         *
         * @param array $data Data containing changes.
         *
         * @return mixed
         */
        public function set_data($data)
        {
        }
        /**
         * Checks if the user has entered their email for mailchimp already.
         *
         * @return bool
         */
        protected function has_mailchimp_signup()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Represents the configuration suggestions component.
     */
    class WPSEO_Config_Component_Suggestions implements \WPSEO_Config_Component
    {
        /**
         * Gets the component identifier.
         *
         * @return string
         */
        public function get_identifier()
        {
        }
        /**
         * Gets the field.
         *
         * @return WPSEO_Config_Field
         */
        public function get_field()
        {
        }
        /**
         * Get the data for the field.
         *
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Save data.
         *
         * @param array $data Data containing changes.
         *
         * @return bool
         */
        public function set_data($data)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Factory_Post_Type.
     */
    class WPSEO_Config_Factory_Post_Type
    {
        /**
         * List of fields.
         *
         * @var WPSEO_Config_Field_Choice_Post_Type[]
         */
        protected static $fields = [];
        /**
         * Retrieves a list of fields.
         *
         * @return WPSEO_Config_Field_Choice_Post_Type[] List of fields.
         */
        public function get_fields()
        {
        }
        /**
         * Add custom properties for specific post types.
         *
         * @param string             $post_type Post type of field that is being added.
         * @param WPSEO_Config_Field $field     Field that corresponds to the post type.
         */
        private function add_custom_properties($post_type, $field)
        {
        }
        /**
         * Replaces the HTML entity with it's actual symbol.
         *
         * Because we do not not know what consequences it will have if we convert every HTML entity,
         * we will only replace the characters that we have known problems with in text's.
         *
         * @param string $text The text to decode.
         *
         * @return string String with decoded HTML entities.
         */
        private function decode_html_entities($text)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field.
     */
    class WPSEO_Config_Field
    {
        /**
         * Field name.
         *
         * @var string
         */
        protected $field;
        /**
         * Component to use.
         *
         * @var string
         */
        protected $component;
        /**
         * Properties of this field.
         *
         * @var array
         */
        protected $properties = [];
        /**
         * Field requirements.
         *
         * @var array
         */
        protected $requires = [];
        /**
         * Value of this field.
         *
         * @var array|mixed
         */
        protected $data = [];
        /**
         * WPSEO_Config_Field constructor.
         *
         * @param string $field     The field name.
         * @param string $component The component to use.
         */
        public function __construct($field, $component)
        {
        }
        /**
         * Get the identifier.
         *
         * @return string
         */
        public function get_identifier()
        {
        }
        /**
         * Get the component.
         *
         * @return string
         */
        public function get_component()
        {
        }
        /**
         * Set a property value.
         *
         * @param string $name  Property to set.
         * @param mixed  $value Value to apply.
         */
        public function set_property($name, $value)
        {
        }
        /**
         * Get all the properties.
         *
         * @return array
         */
        public function get_properties()
        {
        }
        /**
         * Get the data.
         *
         * @return mixed
         */
        public function get_data()
        {
        }
        /**
         * Array representation of this object.
         *
         * @return array
         */
        public function to_array()
        {
        }
        /**
         * Set the adapter to use.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Requires another field to have a certain value.
         *
         * @param string $field Field to check for a certain value.
         * @param mixed  $value Value of the field.
         */
        public function set_requires($field, $value)
        {
        }
        /**
         * Get the required field settings (if present).
         *
         * @return array
         */
        public function get_requires()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Choice.
     */
    class WPSEO_Config_Field_Choice extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Choice constructor.
         *
         * @param string $field Field name to use.
         */
        public function __construct($field)
        {
        }
        /**
         * Add a choice to the properties.
         *
         * @param string $value      Value op the option.
         * @param string $label      Label to display for the value.
         * @param string $aria_label Optional. Aria label text to use.
         */
        public function add_choice($value, $label, $aria_label = '')
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Choice_Post_Type.
     */
    class WPSEO_Config_Field_Choice_Post_Type extends \WPSEO_Config_Field_Choice
    {
        /**
         * Post type.
         *
         * @var string
         */
        protected $post_type;
        /**
         * WPSEO_Config_Field_Choice_Post_Type constructor.
         *
         * @param string $post_type The post type to add.
         * @param string $label     Label to show (translated post type).
         */
        public function __construct($post_type, $label)
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Get the post type of this field.
         *
         * @return string Post type.
         */
        public function get_post_type()
        {
        }
        /**
         * Retrieves the data.
         *
         * @return bool
         */
        public function get_data()
        {
        }
        /**
         * Set new data.
         *
         * @param string $visible Visible (true) or hidden (false).
         *
         * @return bool
         */
        public function set_data($visible)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Field_Company_Info_Missing.
     */
    class WPSEO_Config_Field_Company_Info_Missing extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Company_Info_Missing constructor.
         *
         * @codeCoverageIgnore This is only using WPSEO_Config_Field and WPSEO_Utils functionality.
         */
        public function __construct()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Field_Company_Logo.
     */
    class WPSEO_Config_Field_Company_Logo extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Company_Logo constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets the adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Field_Company_Name.
     */
    class WPSEO_Config_Field_Company_Name extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Company_Name constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets the adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Field_Company_Or_Person.
     */
    class WPSEO_Config_Field_Company_Or_Person extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Company_Or_Person constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets the adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Environment.
     */
    class WPSEO_Config_Field_Environment extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Environment constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Gets the option that is set for this field.
         *
         * @return string The value for the environment_type wpseo option.
         */
        public function get_data()
        {
        }
        /**
         * Set new data.
         *
         * @param string $environment_type The site's environment type.
         *
         * @return bool Returns whether the value is successfully set.
         */
        public function set_data($environment_type)
        {
        }
        /**
         * Set the WordPress Search Engine Visibility option based on the environment type.
         *
         * @param string $environment_type The environment the site is running in.
         *
         * @return bool Returns if the options is set successfully.
         */
        protected function set_indexation($environment_type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Mailchimp_Signup.
     */
    class WPSEO_Config_Field_Mailchimp_Signup extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Mailchimp_Signup constructor.
         */
        public function __construct()
        {
        }
        /**
         * Get the data.
         *
         * @return array
         */
        public function get_data()
        {
        }
        /**
         * Checks if the user has entered their email for mailchimp already.
         *
         * @return bool
         */
        protected function has_mailchimp_signup()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Multiple_Authors.
     */
    class WPSEO_Config_Field_Multiple_Authors extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Multiple_Authors constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Get the data from the stored options.
         *
         * @return string|null
         */
        public function get_data()
        {
        }
        /**
         * Set the data in the options.
         *
         * @param string $data The data to set for the field.
         *
         * @return bool Returns true or false for successful storing the data.
         */
        public function set_data($data)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Configurator
     */
    /**
     * Class WPSEO_Config_Field_Person_Name.
     */
    class WPSEO_Config_Field_Person extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Company_Or_Person constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets the adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Post_Type_Visibility.
     */
    class WPSEO_Config_Field_Post_Type_Visibility extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Post_Type_Visibility constructor.
         */
        public function __construct()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_Facebook.
     */
    class WPSEO_Config_Field_Profile_URL_Facebook extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_Facebook constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_Instagram.
     */
    class WPSEO_Config_Field_Profile_URL_Instagram extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_Instagram constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_LinkedIn.
     */
    class WPSEO_Config_Field_Profile_URL_LinkedIn extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_LinkedIn constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_MySpace.
     */
    class WPSEO_Config_Field_Profile_URL_MySpace extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_MySpace constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_Pinterest.
     */
    class WPSEO_Config_Field_Profile_URL_Pinterest extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_Pinterest constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_Twitter.
     */
    class WPSEO_Config_Field_Profile_URL_Twitter extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_Twitter constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_YouTube
     */
    class WPSEO_Config_Field_Profile_URL_Wikipedia extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_YouTube constructor.
         */
        public function __construct()
        {
        }
        /**
         * Sets the adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         *
         * @return void
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Profile_URL_YouTube.
     */
    class WPSEO_Config_Field_Profile_URL_YouTube extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Profile_URL_YouTube constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Separator.
     */
    class WPSEO_Config_Field_Separator extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Separator constructor.
         */
        public function __construct()
        {
        }
        /**
         * Adds the title separator choices.
         */
        protected function add_choices()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Site_Name.
     */
    class WPSEO_Config_Field_Site_Name extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Site_Name constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Get the data from the stored options.
         *
         * @return string|null
         */
        public function get_data()
        {
        }
        /**
         * Set the data in the options.
         *
         * @param string $data The data to set for the field.
         *
         * @return bool Returns true or false for successful storing the data.
         */
        public function set_data($data)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Site_Type.
     */
    class WPSEO_Config_Field_Site_Type extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Site_Type constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Success_Message.
     */
    class WPSEO_Config_Field_Success_Message extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Success_Message constructor.
         */
        public function __construct()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Holds the suggestions for the 'You might also like' page in the wizard.
     */
    class WPSEO_Config_Field_Suggestions extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Suggestions constructor.
         */
        public function __construct()
        {
        }
        /**
         * Adds a suggestion to the properties.
         *
         * @param string $title  The title of the choice.
         * @param string $copy   The text explaining the choice.
         * @param array  $button The button details.
         * @param array  $video  URL and title of the video accompanying the choice.
         */
        public function add_suggestion($title, $copy, $button, array $video = [])
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Title_Intro.
     */
    class WPSEO_Config_Field_Title_Intro extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Social_Profiles_Intro constructor.
         */
        public function __construct()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Tracking_Intro.
     */
    class WPSEO_Config_Field_Tracking_Intro extends \WPSEO_Config_Field
    {
        /**
         * WPSEO_Config_Field_Tracking_Intro constructor.
         */
        public function __construct()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\ConfigurationUI
     */
    /**
     * Class WPSEO_Config_Field_Tracking.
     */
    class WPSEO_Config_Field_Tracking extends \WPSEO_Config_Field_Choice
    {
        /**
         * WPSEO_Config_Field_Tracking constructor.
         */
        public function __construct()
        {
        }
        /**
         * Set adapter.
         *
         * @param WPSEO_Configuration_Options_Adapter $adapter Adapter to register lookup on.
         */
        public function set_adapter(\WPSEO_Configuration_Options_Adapter $adapter)
        {
        }
        /**
         * Gets the option that is set for this field.
         *
         * @return string The value for the environment_type wpseo option.
         */
        public function get_data()
        {
        }
        /**
         * Set new data.
         *
         * @param string $tracking The site's environment type.
         *
         * @return bool Returns whether the value is successfully set.
         */
        public function set_data($tracking)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Endpoints
     */
    /**
     * Dictates the required methods for an Endpoint implementation.
     */
    interface WPSEO_Endpoint
    {
        /**
         * Registers the routes for the endpoints.
         *
         * @return void
         */
        public function register();
        /**
         * Determines whether or not data can be retrieved for the registered endpoints.
         *
         * @return bool Whether or not data can be retrieved.
         */
        public function can_retrieve_data();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Endpoints
     */
    /**
     * Represents an implementation of the WPSEO_Endpoint interface to register one or multiple endpoints.
     */
    class WPSEO_Endpoint_File_Size implements \WPSEO_Endpoint
    {
        /**
         * The namespace of the REST route.
         *
         * @var string
         */
        const REST_NAMESPACE = 'yoast/v1';
        /**
         * The route of the endpoint to retrieve the file size.
         *
         * @var string
         */
        const ENDPOINT_SINGULAR = 'file_size';
        /**
         * The name of the capability needed to retrieve data using the endpoints.
         *
         * @var string
         */
        const CAPABILITY_RETRIEVE = 'manage_options';
        /**
         * The service provider.
         *
         * @var WPSEO_File_Size_Service
         */
        private $service;
        /**
         * Sets the service provider.
         *
         * @param WPSEO_File_Size_Service $service The service provider.
         */
        public function __construct(\WPSEO_File_Size_Service $service)
        {
        }
        /**
         * Registers the routes for the endpoints.
         *
         * @return void
         */
        public function register()
        {
        }
        /**
         * Determines whether or not data can be retrieved for the registered endpoints.
         *
         * @return bool Whether or not data can be retrieved.
         */
        public function can_retrieve_data()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Statistics
     */
    /**
     * Represents an implementation of the WPSEO_Endpoint interface to register one or multiple endpoints.
     */
    class WPSEO_Endpoint_Statistics implements \WPSEO_Endpoint
    {
        /**
         * The namespace of the REST route.
         *
         * @var string
         */
        const REST_NAMESPACE = 'yoast/v1';
        /**
         * The route of the statistics endpoint.
         *
         * @var string
         */
        const ENDPOINT_RETRIEVE = 'statistics';
        /**
         * The name of the capability needed to retrieve data using the endpoints.
         *
         * @var string
         */
        const CAPABILITY_RETRIEVE = 'read';
        /**
         * Service to use.
         *
         * @var WPSEO_Statistics_Service
         */
        protected $service;
        /**
         * Constructs the WPSEO_Endpoint_Statistics class and sets the service to use.
         *
         * @param WPSEO_Statistics_Service $service Service to use.
         */
        public function __construct(\WPSEO_Statistics_Service $service)
        {
        }
        /**
         * Registers the REST routes that are available on the endpoint.
         */
        public function register()
        {
        }
        /**
         * Determines whether or not data can be retrieved for the registered endpoints.
         *
         * @return bool Whether or not data can be retrieved.
         */
        public function can_retrieve_data()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Exceptions
     */
    /**
     * Represents named methods for exceptions.
     */
    class WPSEO_File_Size_Exception extends \Exception
    {
        /**
         * Gets the exception for an externally hosted file.
         *
         * @param string $file_url The file url.
         *
         * @return WPSEO_File_Size_Exception Instance of the exception.
         */
        public static function externally_hosted($file_url)
        {
        }
        /**
         * Gets the exception for when a unknown error occurs.
         *
         * @param string $file_url The file url.
         *
         * @return WPSEO_File_Size_Exception Instance of the exception.
         */
        public static function unknown_error($file_url)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Filters
     */
    /**
     * Class WPSEO_Abstract_Post_Filter.
     */
    abstract class WPSEO_Abstract_Post_Filter implements \WPSEO_WordPress_Integration
    {
        /**
         * The filter's query argument.
         *
         * @var string
         */
        const FILTER_QUERY_ARG = 'yoast_filter';
        /**
         * Modify the query based on the FILTER_QUERY_ARG variable in $_GET.
         *
         * @param string $where Query variables.
         *
         * @return string The modified query.
         */
        public abstract function filter_posts($where);
        /**
         * Returns the query value this filter uses.
         *
         * @return string The query value this filter uses.
         */
        public abstract function get_query_val();
        /**
         * Returns the total number of posts that match this filter.
         *
         * @return int The total number of posts that match this filter.
         */
        protected abstract function get_post_total();
        /**
         * Returns the label for this filter.
         *
         * @return string The label for this filter.
         */
        protected abstract function get_label();
        /**
         * Registers the hooks.
         */
        public function register_hooks()
        {
        }
        /**
         * Adds the filter links to the view_edit screens to give the user a filter link.
         *
         * @return void
         */
        public function add_filter_links()
        {
        }
        /**
         * Enqueues the necessary assets to display a filter explanation.
         *
         * @return void
         */
        public function enqueue_explanation_assets()
        {
        }
        /**
         * Adds a filter link to the views.
         *
         * @param array $views Array with the views.
         *
         * @return array Array of views including the added view.
         */
        public function add_filter_link(array $views)
        {
        }
        /**
         * Returns a text explaining this filter. Null if no explanation is necessary.
         *
         * @return string|null The explanation or null.
         */
        protected function get_explanation()
        {
        }
        /**
         * Renders a hidden input to preserve this filter's state when using sub-filters.
         *
         * @return void
         */
        public function render_hidden_input()
        {
        }
        /**
         * Returns an url to edit.php with post_type and this filter as the query arguments.
         *
         * @return string The url to activate this filter.
         */
        protected function get_filter_url()
        {
        }
        /**
         * Returns true when the filter is active.
         *
         * @return bool Whether or not the filter is active.
         */
        protected function is_filter_active()
        {
        }
        /**
         * Returns the current post type.
         *
         * @return string The current post type.
         */
        protected function get_current_post_type()
        {
        }
        /**
         * Returns the post types to which this filter should be added.
         *
         * @return array The post types to which this filter should be added.
         */
        protected function get_post_types()
        {
        }
        /**
         * Checks if the post type is supported.
         *
         * @param string $post_type Post type to check against.
         *
         * @return bool True when it is supported.
         */
        protected function is_supported_post_type($post_type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Registers the filter for filtering posts by cornerstone content.
     */
    class WPSEO_Cornerstone_Filter extends \WPSEO_Abstract_Post_Filter
    {
        /**
         * Name of the meta value.
         *
         * @var string
         */
        const META_NAME = 'is_cornerstone';
        /**
         * Registers the hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Returns the query value this filter uses.
         *
         * @return string The query value this filter uses.
         */
        public function get_query_val()
        {
        }
        /**
         * Modify the query based on the seo_filter variable in $_GET.
         *
         * @param string $where Query variables.
         *
         * @return string The modified query.
         */
        public function filter_posts($where)
        {
        }
        /**
         * Filters the post types that have the metabox disabled.
         *
         * @param array $post_types The post types to filter.
         *
         * @return array The filtered post types.
         */
        public function filter_metabox_disabled($post_types)
        {
        }
        /**
         * Returns the label for this filter.
         *
         * @return string The label for this filter.
         */
        protected function get_label()
        {
        }
        /**
         * Returns a text explaining this filter.
         *
         * @return string|null The explanation.
         */
        protected function get_explanation()
        {
        }
        /**
         * Returns the total amount of articles marked as cornerstone content.
         *
         * @return int
         */
        protected function get_post_total()
        {
        }
        /**
         * Returns the post types to which this filter should be added.
         *
         * @return array The post types to which this filter should be added.
         */
        protected function get_post_types()
        {
        }
    }
    /**
     * This class forces needed methods for the metabox localization.
     */
    class WPSEO_Metabox_Formatter
    {
        /**
         * Object that provides formatted values.
         *
         * @var WPSEO_Metabox_Formatter_Interface
         */
        private $formatter;
        /**
         * Setting the formatter property.
         *
         * @param WPSEO_Metabox_Formatter_Interface $formatter Object that provides the formatted values.
         */
        public function __construct(\WPSEO_Metabox_Formatter_Interface $formatter)
        {
        }
        /**
         * Returns the values.
         *
         * @return array
         */
        public function get_values()
        {
        }
        /**
         * Returns array with all the values always needed by a scraper object.
         *
         * @return array Default settings for the metabox.
         */
        private function get_defaults()
        {
        }
        /**
         * Returns required yoast-component translations.
         *
         * @return array
         */
        private function get_content_analysis_component_translations()
        {
        }
        /**
         * Returns Jed compatible YoastSEO.js translations.
         *
         * @return array
         */
        private function get_translations()
        {
        }
        /**
         * Checks if Jetpack's markdown module is enabled.
         * Can be extended to work with other plugins that parse markdown in the content.
         *
         * @return bool
         */
        private function is_markdown_enabled()
        {
        }
        /**
         * Checks if the user is logged in to SEMrush.
         *
         * @return bool The SEMrush login status.
         */
        private function get_semrush_login_status()
        {
        }
        /* ********************* DEPRECATED METHODS ********************* */
        /**
         * Returns the translations for the Add Keyword modal.
         *
         * These strings are not escaped because they're meant to be used with React
         * which already takes care of that. If used in PHP, they should be escaped.
         *
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @return array Translated text strings for the Add Keyword modal.
         */
        public function get_add_keyword_upsell_translations()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Formatter
     */
    /**
     * Interface to force get_values.
     */
    interface WPSEO_Metabox_Formatter_Interface
    {
        /**
         * Returns formatter values.
         *
         * @return array
         */
        public function get_values();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Formatter
     */
    /**
     * This class provides data for the post metabox by return its values for localization.
     */
    class WPSEO_Post_Metabox_Formatter implements \WPSEO_Metabox_Formatter_Interface
    {
        /**
         * Holds the WordPress Post.
         *
         * @var WP_Post
         */
        private $post;
        /**
         * The permalink to follow.
         *
         * @var string
         */
        private $permalink;
        /**
         * Whether we must return social templates values.
         *
         * @var bool
         */
        private $use_social_templates = \false;
        /**
         * Constructor.
         *
         * @param WP_Post|array $post      Post object.
         * @param array         $options   Title options to use.
         * @param string        $structure The permalink to follow.
         */
        public function __construct($post, array $options, $structure)
        {
        }
        /**
         * Determines whether the social templates should be used.
         *
         * @return bool Whether the social templates should be used.
         */
        public function use_social_templates()
        {
        }
        /**
         * Returns the translated values.
         *
         * @return array
         */
        public function get_values()
        {
        }
        /**
         * Gets the image URL for the post's social preview.
         *
         * @return string|null The image URL for the social preview.
         */
        protected function get_image_url()
        {
        }
        /**
         * Returns the url to search for keyword for the post.
         *
         * @return string
         */
        private function search_url()
        {
        }
        /**
         * Returns the url to edit the taxonomy.
         *
         * @return string
         */
        private function edit_url()
        {
        }
        /**
         * Returns a base URL for use in the JS, takes permalink structure into account.
         *
         * @return string
         */
        private function base_url_for_js()
        {
        }
        /**
         * Counts the number of given keywords used for other posts other than the given post_id.
         *
         * @return array The keyword and the associated posts that use it.
         */
        private function get_focus_keyword_usage()
        {
        }
        /**
         * Retrieves the additional keywords from Premium, that are associated with the post.
         *
         * @param array $usage The original keyword usage for the main keyword.
         *
         * @return array The keyword usage, including the additional keywords.
         */
        protected function get_premium_keywords($usage)
        {
        }
        /**
         * Gets the keyword usage for the current post and the specified keyword.
         *
         * @param string $keyword The keyword to check the usage of.
         *
         * @return array The post IDs which use the passed keyword.
         */
        protected function get_keyword_usage_for_current_post($keyword)
        {
        }
        /**
         * Retrieves the title template.
         *
         * @param bool $fallback Whether to return the hardcoded fallback if the template value is empty.
         *
         * @return string The title template.
         */
        private function get_title_template($fallback = \true)
        {
        }
        /**
         * Retrieves the metadesc template.
         *
         * @return string The metadesc template.
         */
        private function get_metadesc_template()
        {
        }
        /**
         * Retrieves the social title template.
         *
         * @return string The social title template.
         */
        private function get_social_title_template()
        {
        }
        /**
         * Retrieves the social description template.
         *
         * @return string The social description template.
         */
        private function get_social_description_template()
        {
        }
        /**
         * Retrieves the social image template.
         *
         * @return string The social description template.
         */
        private function get_social_image_template()
        {
        }
        /**
         * Retrieves a template.
         *
         * @param string $template_option_name The name of the option in which the template you want to get is saved.
         *
         * @return string
         */
        private function get_template($template_option_name)
        {
        }
        /**
         * Determines the date to be displayed in the snippet preview.
         *
         * @return string
         */
        private function get_metadesc_date()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Formatter
     */
    /**
     * This class provides data for the term metabox by return its values for localization.
     */
    class WPSEO_Term_Metabox_Formatter implements \WPSEO_Metabox_Formatter_Interface
    {
        /**
         * The term the metabox formatter is for.
         *
         * @var WP_Term|stdClass
         */
        private $term;
        /**
         * The term's taxonomy.
         *
         * @var stdClass
         */
        private $taxonomy;
        /**
         * Whether we must return social templates values.
         *
         * @var bool
         */
        private $use_social_templates = \false;
        /**
         * Array with the WPSEO_Titles options.
         *
         * @var array
         */
        protected $options;
        /**
         * WPSEO_Taxonomy_Scraper constructor.
         *
         * @param stdClass         $taxonomy Taxonomy.
         * @param WP_Term|stdClass $term     Term.
         */
        public function __construct($taxonomy, $term)
        {
        }
        /**
         * Determines whether the social templates should be used.
         *
         * @return bool Whether the social templates should be used.
         */
        public function use_social_templates()
        {
        }
        /**
         * Returns the translated values.
         *
         * @return array
         */
        public function get_values()
        {
        }
        /**
         * Gets the image URL for the term's social preview.
         *
         * @return string|null The image URL for the social preview.
         */
        protected function get_image_url()
        {
        }
        /**
         * Returns the url to search for keyword for the taxonomy.
         *
         * @return string
         */
        private function search_url()
        {
        }
        /**
         * Returns the url to edit the taxonomy.
         *
         * @return string
         */
        private function edit_url()
        {
        }
        /**
         * Returns a base URL for use in the JS, takes permalink structure into account.
         *
         * @return string
         */
        private function base_url_for_js()
        {
        }
        /**
         * Counting the number of given keyword used for other term than given term_id.
         *
         * @return array
         */
        private function get_focus_keyword_usage()
        {
        }
        /**
         * Retrieves the title template.
         *
         * @param bool $fallback Whether to return the hardcoded fallback if the template value is empty.
         *
         * @return string The title template.
         */
        private function get_title_template($fallback = \true)
        {
        }
        /**
         * Retrieves the metadesc template.
         *
         * @return string The metadesc template.
         */
        private function get_metadesc_template()
        {
        }
        /**
         * Retrieves the social title template.
         *
         * @return string The social title template.
         */
        private function get_social_title_template()
        {
        }
        /**
         * Retrieves the social description template.
         *
         * @return string The social description template.
         */
        private function get_social_description_template()
        {
        }
        /**
         * Retrieves the social image template.
         *
         * @return string The social description template.
         */
        private function get_social_image_template()
        {
        }
        /**
         * Retrieves a template.
         *
         * @param string $template_option_name The name of the option in which the template you want to get is saved.
         *
         * @return string
         */
        private function get_template($template_option_name)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\admin\google_search_console
     */
    /**
     * Class WPSEO_GSC.
     */
    class WPSEO_GSC
    {
        /**
         * The option where data will be stored.
         *
         * @var string
         */
        const OPTION_WPSEO_GSC = 'wpseo-gsc';
        /**
         * Outputs the HTML for the redirect page.
         *
         * @return void
         */
        public function display()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_Plugins_Detector.
     *
     * Class with functionality to detect whether we should import from another SEO plugin.
     */
    class WPSEO_Import_Plugins_Detector
    {
        /**
         * Plugins we need to import from.
         *
         * @var array
         */
        public $needs_import = [];
        /**
         * Detects whether we need to import anything.
         */
        public function detect()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_Plugin.
     *
     * Class with functionality to import Yoast SEO settings from other plugins.
     */
    class WPSEO_Import_Plugin
    {
        /**
         * Holds the status of and message about imports.
         *
         * @var WPSEO_Import_Status
         */
        public $status;
        /**
         * Class with functionality to import meta data from other plugins.
         *
         * @var WPSEO_Plugin_Importer
         */
        protected $importer;
        /**
         * Import class constructor.
         *
         * @param WPSEO_Plugin_Importer $importer The importer that needs to perform this action.
         * @param string                $action   The action to perform.
         */
        public function __construct(\WPSEO_Plugin_Importer $importer, $action)
        {
        }
        /**
         * Convenience function to replace %s with plugin name in import message.
         *
         * @param string $msg Message string.
         *
         * @return string Returns message with plugin name instead of replacement variables.
         */
        protected function complete_msg($msg)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Import
     */
    /**
     * Class WPSEO_Import_Settings.
     *
     * Class with functionality to import the Yoast SEO settings.
     */
    class WPSEO_Import_Settings
    {
        /**
         * Nonce action key.
         *
         * @var string
         */
        const NONCE_ACTION = 'wpseo-import-settings';
        /**
         * Holds the import status instance.
         *
         * @var WPSEO_Import_Status
         */
        public $status;
        /**
         * Holds the old WPSEO version.
         *
         * @var string
         */
        private $old_wpseo_version;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Imports the data submitted by the user.
         *
         * @return void
         */
        public function import()
        {
        }
        /**
         * Parse the options.
         *
         * @param string $raw_options The content to parse.
         *
         * @return void
         */
        protected function parse_options($raw_options)
        {
        }
        /**
         * Parse the option group and import it.
         *
         * @param string $name         Name string.
         * @param array  $option_group Option group data.
         * @param array  $options      Options data.
         */
        protected function parse_option_group($name, $option_group, $options)
        {
        }
        /**
         * Imports the options if found.
         *
         * @param array $options The options parsed from the provided settings.
         */
        protected function import_options($options)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Import
     */
    /**
     * Class WPSEO_ImportStatus.
     *
     * Holds the status of and message about imports.
     */
    class WPSEO_Import_Status
    {
        /**
         * The import status.
         *
         * @var bool
         */
        public $status = \false;
        /**
         * The import message.
         *
         * @var string
         */
        private $msg = '';
        /**
         * The type of action performed.
         *
         * @var string
         */
        private $action;
        /**
         * WPSEO_Import_Status constructor.
         *
         * @param string $action The type of import action.
         * @param bool   $status The status of the import.
         * @param string $msg    Extra messages about the status.
         */
        public function __construct($action, $status, $msg = '')
        {
        }
        /**
         * Get the import message.
         *
         * @return string Message about current status.
         */
        public function get_msg()
        {
        }
        /**
         * Get the import action.
         *
         * @return string Import action type.
         */
        public function get_action()
        {
        }
        /**
         * Set the import action, set status to false.
         *
         * @param string $action The type of action to set as import action.
         *
         * @return void
         */
        public function set_action($action)
        {
        }
        /**
         * Sets the importer status message.
         *
         * @param string $msg The message to set.
         *
         * @return void
         */
        public function set_msg($msg)
        {
        }
        /**
         * Sets the importer status.
         *
         * @param bool $status The status to set.
         *
         * @return WPSEO_Import_Status The current object.
         */
        public function set_status($status)
        {
        }
        /**
         * Returns a success message depending on the action.
         *
         * @return string Returns a success message for the current action.
         */
        private function get_default_success_message()
        {
        }
    }
    /**
     * This file holds the abstract class for dealing with imports from other plugins.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Plugin_Importer.
     *
     * Class with functionality to import meta data from other plugins.
     */
    abstract class WPSEO_Plugin_Importer
    {
        /**
         * Holds the import status object.
         *
         * @var WPSEO_Import_Status
         */
        protected $status;
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name;
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key;
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Returns the string for the plugin we're importing from.
         *
         * @return string Plugin name.
         */
        public function get_plugin_name()
        {
        }
        /**
         * Imports the settings and post meta data from another SEO plugin.
         *
         * @return WPSEO_Import_Status Import status object.
         */
        public function run_import()
        {
        }
        /**
         * Handles post meta data to import.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Removes the plugin data from the database.
         *
         * @return WPSEO_Import_Status Import status object.
         */
        public function run_cleanup()
        {
        }
        /**
         * Removes the plugin data from the database.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
        /**
         * Sets the status message for when a cleanup has gone bad.
         *
         * @return void
         */
        protected function cleanup_error_msg()
        {
        }
        /**
         * Detects whether an import for this plugin is needed.
         *
         * @return WPSEO_Import_Status Import status object.
         */
        public function run_detect()
        {
        }
        /**
         * Detects whether there is post meta data to import.
         *
         * @return bool Boolean indicating whether there is something to import.
         */
        protected function detect()
        {
        }
        /**
         * Helper function to clone meta keys and (optionally) change their values in bulk.
         *
         * @param string $old_key        The existing meta key.
         * @param string $new_key        The new meta key.
         * @param array  $replace_values An array, keys old value, values new values.
         *
         * @return bool Clone status.
         */
        protected function meta_key_clone($old_key, $new_key, $replace_values = [])
        {
        }
        /**
         * Clones multiple meta keys.
         *
         * @param array $clone_keys The keys to clone.
         *
         * @return bool Success status.
         */
        protected function meta_keys_clone($clone_keys)
        {
        }
        /**
         * Sets the import status to false and returns a message about why it failed.
         */
        protected function set_missing_db_rights_status()
        {
        }
        /**
         * Helper function to search for a key in an array and maybe save it as a meta field.
         *
         * @param string $plugin_key The key in the $data array to check.
         * @param string $yoast_key  The identifier we use in our meta settings.
         * @param array  $data       The array of data for this post to sift through.
         * @param int    $post_id    The post ID.
         *
         * @return void
         */
        protected function import_meta_helper($plugin_key, $yoast_key, $data, $post_id)
        {
        }
        /**
         * Saves a post meta value if it doesn't already exist.
         *
         * @param string $new_key The key to save.
         * @param mixed  $value   The value to set the key to.
         * @param int    $post_id The Post to save the meta for.
         */
        protected function maybe_save_post_meta($new_key, $value, $post_id)
        {
        }
        /**
         * Replaces values in our temporary table according to our settings.
         *
         * @param array $replace_values Key value pair of values to replace with other values.
         *
         * @return void
         */
        protected function meta_key_clone_replace($replace_values)
        {
        }
    }
    /**
     * File with the class to handle data from All in One SEO Pack.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean All in One SEO Pack post metadata.
     */
    class WPSEO_Import_AIOSEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'All In One SEO Pack';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_aioseop_%';
        /**
         * OpenGraph keys to import.
         *
         * @var array
         */
        protected $import_keys = ['aioseop_opengraph_settings_title' => 'opengraph-title', 'aioseop_opengraph_settings_desc' => 'opengraph-description', 'aioseop_opengraph_settings_customimg' => 'opengraph-image', 'aioseop_opengraph_settings_customimg_twitter' => 'twitter-image'];
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_aioseop_title', 'new_key' => 'title'], ['old_key' => '_aioseop_description', 'new_key' => 'metadesc'], ['old_key' => '_aioseop_noindex', 'new_key' => 'meta-robots-noindex', 'convert' => ['on' => 1]], ['old_key' => '_aioseop_nofollow', 'new_key' => 'meta-robots-nofollow', 'convert' => ['on' => 1]]];
        /**
         * Import All In One SEO meta values.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Imports the OpenGraph and Twitter settings for all posts.
         *
         * @return bool
         */
        protected function import_opengraph()
        {
        }
        /**
         * Imports the OpenGraph and Twitter settings for a single post.
         *
         * @param int $post_id Post ID.
         */
        private function import_post_opengraph($post_id)
        {
        }
    }
    /**
     * File with the class to handle data from Ultimate SEO.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Ultimate SEO post metadata.
     */
    class WPSEO_Import_Greg_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = "Greg's High Performance SEO";
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_ghpseo_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_ghpseo_alternative_description', 'new_key' => 'metadesc'], ['old_key' => '_ghpseo_secondary_title', 'new_key' => 'title']];
    }
    /**
     * File with the class to handle data from HeadSpace.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_HeadSpace.
     *
     * Class with functionality to import & clean HeadSpace SEO post metadata.
     */
    class WPSEO_Import_HeadSpace extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'HeadSpace SEO';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_headspace_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_headspace_description', 'new_key' => 'metadesc'], ['old_key' => '_headspace_page_title', 'new_key' => 'title'], ['old_key' => '_headspace_noindex', 'new_key' => 'meta-robots-noindex', 'convert' => ['on' => 1]], ['old_key' => '_headspace_nofollow', 'new_key' => 'meta-robots-nofollow', 'convert' => ['on' => 1]]];
    }
    /**
     * File with the class to handle data from Jetpack's Advanced SEO settings.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_Jetpack_SEO.
     *
     * Class with functionality to import & clean Jetpack SEO post metadata.
     */
    class WPSEO_Import_Jetpack_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Jetpack';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = 'advanced_seo_description';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => 'advanced_seo_description', 'new_key' => 'metadesc']];
    }
    /**
     * File with the class to handle data from Platinum SEO Pack.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Ultimate SEO post metadata.
     */
    class WPSEO_Import_Platinum_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Platinum SEO Pack';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = 'title';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => 'description', 'new_key' => 'metadesc'], ['old_key' => 'title', 'new_key' => 'title']];
        /**
         * Runs the import of post meta keys stored by Platinum SEO Pack.
         *
         * @return bool
         */
        protected function import()
        {
        }
        /**
         * Cleans up all the meta values Platinum SEO pack creates.
         *
         * @return bool
         */
        protected function cleanup()
        {
        }
        /**
         * Finds all the robotsmeta fields to import and deals with them.
         *
         * There are four potential values that Platinum SEO stores:
         * - index,folllow
         * - index,nofollow
         * - noindex,follow
         * - noindex,nofollow
         *
         * We only have to deal with the latter 3, the first is our default.
         *
         * @return void
         */
        protected function import_robots_meta()
        {
        }
        /**
         * Imports the values for all index, nofollow posts.
         *
         * @param string $value The meta robots value to find posts for.
         * @param array  $metas The meta field(s) to save.
         *
         * @return void
         */
        protected function import_by_meta_robots($value, $metas)
        {
        }
        /**
         * Finds posts by a given meta robots value.
         *
         * @param string $meta_value Robots meta value.
         *
         * @return array|bool Array of Post IDs on success, false on failure.
         */
        protected function find_posts_by_robots_meta($meta_value)
        {
        }
    }
    /**
     * File with the class to handle data from Squirrly.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Squirrly post metadata.
     */
    class WPSEO_Import_Squirrly extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Squirrly SEO';
        /**
         * Holds the name of the table Squirrly uses to store data.
         *
         * @var string
         */
        protected $table_name;
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_sq_post_keyword';
        /**
         * Data to import from (and the target to field) the serialized array stored in the SEO field in the Squirrly table.
         *
         * @var array
         */
        protected $seo_field_keys = ['noindex' => 'meta-robots-noindex', 'nofollow' => 'meta-robots-nofollow', 'title' => 'title', 'description' => 'metadesc', 'canonical' => 'canonical', 'cornerstone' => '_yst_is_cornerstone', 'tw_media' => 'twitter-image', 'tw_title' => 'twitter-title', 'tw_description' => 'twitter-description', 'og_title' => 'opengraph-title', 'og_description' => 'opengraph-description', 'og_media' => 'opengraph-image', 'focuskw' => 'focuskw'];
        /**
         * WPSEO_Import_Squirrly constructor.
         */
        public function __construct()
        {
        }
        /**
         * Imports the post meta values to Yoast SEO.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Retrieve the posts from the Squirrly Database.
         *
         * @return array Array of post IDs from the DB.
         */
        protected function retrieve_posts()
        {
        }
        /**
         * Returns the query to return an identifier for the posts to import.
         *
         * @return string Query to get post ID's from the DB.
         */
        protected function retrieve_posts_query()
        {
        }
        /**
         * Removes the DB table and the post meta field Squirrly creates.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
        /**
         * Detects whether there is post meta data to import.
         *
         * @return bool Boolean indicating whether there is something to import.
         */
        protected function detect()
        {
        }
        /**
         * Imports the data of a post out of Squirrly's DB table.
         *
         * @param mixed $post_identifier Post identifier, can be ID or string.
         *
         * @return bool Import status.
         */
        private function import_post_values($post_identifier)
        {
        }
        /**
         * Retrieves the Squirrly SEO data for a post from the DB.
         *
         * @param int $post_identifier Post ID.
         *
         * @return array|bool Array of data or false.
         */
        private function retrieve_post_data($post_identifier)
        {
        }
        /**
         * Squirrly stores the focus keyword in post meta.
         *
         * @param int $post_id Post ID.
         *
         * @return string The focus keyword.
         */
        private function maybe_add_focus_kw($post_id)
        {
        }
    }
    /**
     * File with the class to handle data from Premium SEO Pack.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Premium SEO Pack post metadata.
     */
    class WPSEO_Import_Premium_SEO_Pack extends \WPSEO_Import_Squirrly
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Premium SEO Pack';
        /**
         * WPSEO_Import_Premium_SEO_Pack constructor.
         */
        public function __construct()
        {
        }
        /**
         * Returns the query to return an identifier for the posts to import.
         *
         * @return string
         */
        protected function retrieve_posts_query()
        {
        }
    }
    /**
     * File with the class to handle data from RankMath.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import RankMath post metadata.
     */
    class WPSEO_Import_RankMath extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'RankMath';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = 'rank_math_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => 'rank_math_description', 'new_key' => 'metadesc'], ['old_key' => 'rank_math_title', 'new_key' => 'title'], ['old_key' => 'rank_math_canonical_url', 'new_key' => 'canonical'], ['old_key' => 'rank_math_primary_category', 'new_key' => 'primary_category'], ['old_key' => 'rank_math_facebook_title', 'new_key' => 'opengraph-title'], ['old_key' => 'rank_math_facebook_description', 'new_key' => 'opengraph-description'], ['old_key' => 'rank_math_facebook_image', 'new_key' => 'opengraph-image'], ['old_key' => 'rank_math_facebook_image_id', 'new_key' => 'opengraph-image-id'], ['old_key' => 'rank_math_twitter_title', 'new_key' => 'twitter-title'], ['old_key' => 'rank_math_twitter_description', 'new_key' => 'twitter-description'], ['old_key' => 'rank_math_twitter_image', 'new_key' => 'twitter-image'], ['old_key' => 'rank_math_twitter_image_id', 'new_key' => 'twitter-image-id'], ['old_key' => 'rank_math_focus_keyword', 'new_key' => 'focuskw']];
        /**
         * Handles post meta data to import.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * RankMath stores robots meta quite differently, so we have to parse it out.
         */
        private function import_meta_robots()
        {
        }
        /**
         * Imports some of the RankMath settings.
         */
        private function import_settings()
        {
        }
        /**
         * Removes the plugin data from the database.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
    }
    /**
     * File with the class to handle data from SEO Framework.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean SEO Framework post metadata.
     */
    class WPSEO_Import_SEO_Framework extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'SEO Framework';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_genesis_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_genesis_description', 'new_key' => 'metadesc'], ['old_key' => '_genesis_title', 'new_key' => 'title'], ['old_key' => '_genesis_noindex', 'new_key' => 'meta-robots-noindex'], ['old_key' => '_genesis_nofollow', 'new_key' => 'meta-robots-nofollow'], ['old_key' => '_genesis_canonical_uri', 'new_key' => 'canonical'], ['old_key' => '_open_graph_title', 'new_key' => 'opengraph-title'], ['old_key' => '_open_graph_description', 'new_key' => 'opengraph-description'], ['old_key' => '_social_image_url', 'new_key' => 'opengraph-image'], ['old_key' => '_twitter_title', 'new_key' => 'twitter-title'], ['old_key' => '_twitter_description', 'new_key' => 'twitter-description']];
        /**
         * Removes all the metadata set by the SEO Framework plugin.
         *
         * @return bool
         */
        protected function cleanup()
        {
        }
    }
    /**
     * File with the class to handle data from SEOPressor.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_SEOPressor.
     *
     * Class with functionality to import & clean SEOPressor post metadata.
     */
    class WPSEO_Import_SEOPressor extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'SEOpressor';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_seop_settings';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_seop_settings']];
        /**
         * Imports the post meta values to Yoast SEO.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Removes all the post meta fields SEOpressor creates.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
        /**
         * Imports the data. SEOpressor stores most of the data in one post array, this loops over it.
         *
         * @param int $post_id Post ID.
         *
         * @return void
         */
        private function import_seopressor_post_settings($post_id)
        {
        }
        /**
         * Imports the focus keywords, and stores them for later use.
         *
         * @param int $post_id Post ID.
         *
         * @return void
         */
        private function import_post_focus_keywords($post_id)
        {
        }
        /**
         * Retrieves the SEOpressor robot value and map this to Yoast SEO values.
         *
         * @param string $meta_rules The meta rules taken from the SEOpressor settings array.
         * @param int    $post_id    The post id of the current post.
         *
         * @return void
         */
        private function import_post_robots($meta_rules, $post_id)
        {
        }
        /**
         * Gets the robot config by given SEOpressor robots value.
         *
         * @param array $seopressor_robots The value in SEOpressor that needs to be converted to the Yoast format.
         *
         * @return array The robots values in Yoast format.
         */
        private function get_robot_value($seopressor_robots)
        {
        }
    }
    /**
     * File with the class to handle data from Smartcrawl SEO.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Smartcrawl SEO post metadata.
     */
    class WPSEO_Import_Smartcrawl_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Smartcrawl SEO';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_wds_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_wds_metadesc', 'new_key' => 'metadesc'], ['old_key' => '_wds_title', 'new_key' => 'title'], ['old_key' => '_wds_canonical', 'new_key' => 'canonical'], ['old_key' => '_wds_focus-keywords', 'new_key' => 'focuskw'], ['old_key' => '_wds_meta-robots-noindex', 'new_key' => 'meta-robots-noindex'], ['old_key' => '_wds_meta-robots-nofollow', 'new_key' => 'meta-robots-nofollow']];
        /**
         * Used for importing Twitter and Facebook meta's.
         *
         * @var array
         */
        protected $social_keys = [];
        /**
         * Handles post meta data to import.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Imports the OpenGraph meta keys saved by Smartcrawl.
         *
         * @return bool Import status.
         */
        protected function import_opengraph()
        {
        }
        /**
         * Imports the Twitter meta keys saved by Smartcrawl.
         *
         * @return bool Import status.
         */
        protected function import_twitter()
        {
        }
        /**
         * Imports a post's serialized post meta values.
         *
         * @param int    $post_id Post ID.
         * @param string $key     The meta key to import.
         *
         * @return void
         */
        protected function import_serialized_post_meta($post_id, $key)
        {
        }
        /**
         * Finds all the posts with a certain meta key and imports its values.
         *
         * @param string $key The meta key to search for.
         *
         * @return bool Import status.
         */
        protected function post_find_import($key)
        {
        }
    }
    /**
     * File with the class to handle data from Ultimate SEO.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean Ultimate SEO post metadata.
     */
    class WPSEO_Import_Ultimate_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'Ultimate SEO';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_su_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_su_description', 'new_key' => 'metadesc'], ['old_key' => '_su_title', 'new_key' => 'title'], ['old_key' => '_su_og_title', 'new_key' => 'opengraph-title'], ['old_key' => '_su_og_description', 'new_key' => 'opengraph-description'], ['old_key' => '_su_og_image', 'new_key' => 'opengraph-image'], ['old_key' => '_su_meta_robots_noindex', 'new_key' => 'meta-robots-noindex', 'convert' => ['on' => 1]], ['old_key' => '_su_meta_robots_nofollow', 'new_key' => 'meta-robots-nofollow', 'convert' => ['on' => 1]]];
    }
    /**
     * File with the class to handle data from WooThemes SEO.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_WooThemes_SEO
     *
     * Class with functionality to import & clean WooThemes SEO post metadata.
     */
    class WPSEO_Import_WooThemes_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'WooThemes SEO';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = 'seo_title';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => 'seo_description', 'new_key' => 'metadesc'], ['old_key' => 'seo_title', 'new_key' => 'title'], ['old_key' => 'seo_noindex', 'new_key' => 'meta-robots-noindex'], ['old_key' => 'seo_follow', 'new_key' => 'meta-robots-nofollow']];
        /**
         * Holds the meta fields we can delete after import.
         *
         * @var array
         */
        protected $cleanup_metas = ['seo_follow', 'seo_noindex', 'seo_title', 'seo_description', 'seo_keywords'];
        /**
         * Holds the options we can delete after import.
         *
         * @var array
         */
        protected $cleanup_options = ['seo_woo_archive_layout', 'seo_woo_single_layout', 'seo_woo_page_layout', 'seo_woo_wp_title', 'seo_woo_meta_single_desc', 'seo_woo_meta_single_key', 'seo_woo_home_layout'];
        /**
         * Cleans up the WooThemes SEO settings.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
        /**
         * Removes the Woo Options from the database.
         *
         * @return void
         */
        private function cleanup_options()
        {
        }
        /**
         * Removes the post meta fields from the database.
         *
         * @return bool Cleanup status.
         */
        private function cleanup_meta()
        {
        }
        /**
         * Removes a single meta field from the postmeta table in the database.
         *
         * @param string $key The meta_key to delete.
         *
         * @return bool Cleanup status.
         */
        private function cleanup_meta_key($key)
        {
        }
    }
    /**
     * File with the class to handle data from WP Meta SEO.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class with functionality to import & clean WP Meta SEO post metadata.
     */
    class WPSEO_Import_WP_Meta_SEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'WP Meta SEO';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_metaseo_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_metaseo_metadesc', 'new_key' => 'metadesc'], ['old_key' => '_metaseo_metatitle', 'new_key' => 'title'], ['old_key' => '_metaseo_metaopengraph-title', 'new_key' => 'opengraph-title'], ['old_key' => '_metaseo_metaopengraph-desc', 'new_key' => 'opengraph-description'], ['old_key' => '_metaseo_metaopengraph-image', 'new_key' => 'opengraph-image'], ['old_key' => '_metaseo_metatwitter-title', 'new_key' => 'twitter-title'], ['old_key' => '_metaseo_metatwitter-desc', 'new_key' => 'twitter-description'], ['old_key' => '_metaseo_metatwitter-image', 'new_key' => 'twitter-image'], ['old_key' => '_metaseo_metaindex', 'new_key' => 'meta-robots-noindex', 'convert' => ['index' => 0, 'noindex' => 1]], ['old_key' => '_metaseo_metafollow', 'new_key' => 'meta-robots-nofollow', 'convert' => ['follow' => 0, 'nofollow' => 1]]];
    }
    /**
     * File with the class to handle data from wpSEO.de.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Import_WPSEO.
     *
     * Class with functionality to import & clean wpSEO.de post metadata.
     */
    class WPSEO_Import_WPSEO extends \WPSEO_Plugin_Importer
    {
        /**
         * The plugin name.
         *
         * @var string
         */
        protected $plugin_name = 'wpSEO.de';
        /**
         * Meta key, used in SQL LIKE clause for delete query.
         *
         * @var string
         */
        protected $meta_key = '_wpseo_edit_%';
        /**
         * Array of meta keys to detect and import.
         *
         * @var array
         */
        protected $clone_keys = [['old_key' => '_wpseo_edit_description', 'new_key' => 'metadesc'], ['old_key' => '_wpseo_edit_title', 'new_key' => 'title'], ['old_key' => '_wpseo_edit_canonical', 'new_key' => 'canonical'], ['old_key' => '_wpseo_edit_og_title', 'new_key' => 'opengraph-title'], ['old_key' => '_wpseo_edit_og_description', 'new_key' => 'opengraph-description'], ['old_key' => '_wpseo_edit_og_image', 'new_key' => 'opengraph-image'], ['old_key' => '_wpseo_edit_twittercard_title', 'new_key' => 'twitter-title'], ['old_key' => '_wpseo_edit_twittercard_description', 'new_key' => 'twitter-description'], ['old_key' => '_wpseo_edit_twittercard_image', 'new_key' => 'twitter-image']];
        /**
         * The values 1 - 6 are the configured values from wpSEO. This array will map the values of wpSEO to our values.
         *
         * There are some double array like 1-6 and 3-4. The reason is they only set the index value. The follow value is
         * the default we use in the cases there isn't a follow value present.
         *
         * @var array
         */
        private $robot_values = [
            // In wpSEO: index, follow.
            1 => ['index' => 2, 'follow' => 0],
            // In wpSEO: index, nofollow.
            2 => ['index' => 2, 'follow' => 1],
            // In wpSEO: noindex.
            3 => ['index' => 1, 'follow' => 0],
            // In wpSEO: noindex, follow.
            4 => ['index' => 1, 'follow' => 0],
            // In wpSEO: noindex, nofollow.
            5 => ['index' => 1, 'follow' => 1],
            // In wpSEO: index.
            6 => ['index' => 2, 'follow' => 0],
        ];
        /**
         * Imports wpSEO settings.
         *
         * @return bool Import success status.
         */
        protected function import()
        {
        }
        /**
         * Removes wpseo.de post meta's.
         *
         * @return bool Cleanup status.
         */
        protected function cleanup()
        {
        }
        /**
         * Detects whether there is post meta data to import.
         *
         * @return bool Boolean indicating whether there is something to import.
         */
        protected function detect()
        {
        }
        /**
         * Imports the robot values from WPSEO plugin. These have to be converted to the Yoast format.
         *
         * @return void
         */
        private function import_post_robots()
        {
        }
        /**
         * Gets the wpSEO robot value and map this to Yoast SEO values.
         *
         * @param int $post_id The post id of the current post.
         *
         * @return void
         */
        private function import_post_robot($post_id)
        {
        }
        /**
         * Imports the taxonomy metas from wpSEO.
         *
         * @return void
         */
        private function import_taxonomy_metas()
        {
        }
        /**
         * Imports the meta description to Yoast SEO.
         *
         * @param array  $tax_meta The array with the current metadata.
         * @param string $taxonomy String with the name of the taxonomy.
         * @param string $term_id  The ID of the current term.
         *
         * @return void
         */
        private function import_taxonomy_description(&$tax_meta, $taxonomy, $term_id)
        {
        }
        /**
         * Imports the robot value to Yoast SEO.
         *
         * @param array  $tax_meta The array with the current metadata.
         * @param string $taxonomy String with the name of the taxonomy.
         * @param string $term_id  The ID of the current term.
         *
         * @return void
         */
        private function import_taxonomy_robots(&$tax_meta, $taxonomy, $term_id)
        {
        }
        /**
         * Deletes the wpSEO taxonomy meta data.
         *
         * @param string $taxonomy String with the name of the taxonomy.
         * @param string $term_id  The ID of the current term.
         *
         * @return void
         */
        private function delete_taxonomy_metas($taxonomy, $term_id)
        {
        }
        /**
         * Gets the robot config by given wpSEO robots value.
         *
         * @param string $wpseo_robots The value in wpSEO that needs to be converted to the Yoast format.
         *
         * @return string The correct robot value.
         */
        private function get_robot_value($wpseo_robots)
        {
        }
        /**
         * Deletes wpSEO postmeta from the database.
         *
         * @return bool Cleanup status.
         */
        private function cleanup_post_meta()
        {
        }
        /**
         * Cleans up the wpSEO term meta.
         *
         * @return void
         */
        private function cleanup_term_meta()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Import\Plugins
     */
    /**
     * Class WPSEO_Plugin_Importers.
     *
     * Object which contains all importers.
     */
    class WPSEO_Plugin_Importers
    {
        /**
         * List of supported importers.
         *
         * @var array
         */
        private static $importers = ['WPSEO_Import_AIOSEO', 'WPSEO_Import_Greg_SEO', 'WPSEO_Import_HeadSpace', 'WPSEO_Import_Jetpack_SEO', 'WPSEO_Import_WP_Meta_SEO', 'WPSEO_Import_Platinum_SEO', 'WPSEO_Import_Premium_SEO_Pack', 'WPSEO_Import_RankMath', 'WPSEO_Import_SEOPressor', 'WPSEO_Import_SEO_Framework', 'WPSEO_Import_Smartcrawl_SEO', 'WPSEO_Import_Squirrly', 'WPSEO_Import_Ultimate_SEO', 'WPSEO_Import_WooThemes_SEO', 'WPSEO_Import_WPSEO'];
        /**
         * Returns an array of importers available.
         *
         * @return array Available importers.
         */
        public static function get()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Interface that represents a collection.
     */
    interface WPSEO_Collection
    {
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Represents the interface for an installable object.
     */
    interface WPSEO_Installable
    {
        /**
         * Runs the installation routine.
         *
         * @return void
         */
        public function install();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Listeners
     */
    /**
     * Dictates the required methods for a Listener implementation.
     */
    interface WPSEO_Listener
    {
        /**
         * Listens to an argument in the request URL and triggers an action.
         *
         * @return void
         */
        public function listen();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Admin menu base class.
     */
    abstract class WPSEO_Base_Menu implements \WPSEO_WordPress_Integration
    {
        /**
         * A menu.
         *
         * @var WPSEO_Menu
         */
        protected $menu;
        /**
         * Constructs the Admin Menu.
         *
         * @param WPSEO_Menu $menu Menu to use.
         */
        public function __construct(\WPSEO_Menu $menu)
        {
        }
        /**
         * Returns the list of registered submenu pages.
         *
         * @return array List of registered submenu pages.
         */
        public abstract function get_submenu_pages();
        /**
         * Creates a submenu formatted array.
         *
         * @param string          $page_title Page title to use.
         * @param string          $page_slug  Page slug to use.
         * @param callable|null   $callback   Optional. Callback which handles the page request.
         * @param callable[]|null $hook       Optional. Hook to trigger when the page is registered.
         *
         * @return array Formatted submenu.
         */
        protected function get_submenu_page($page_title, $page_slug, $callback = \null, $hook = \null)
        {
        }
        /**
         * Registers submenu pages as menu pages.
         *
         * This method should only be used if the user does not have the required capabilities
         * to access the parent menu page.
         *
         * @param array $submenu_pages List of submenu pages to register.
         *
         * @return void
         */
        protected function register_menu_pages($submenu_pages)
        {
        }
        /**
         * Registers submenu pages.
         *
         * @param array $submenu_pages List of submenu pages to register.
         *
         * @return void
         */
        protected function register_submenu_pages($submenu_pages)
        {
        }
        /**
         * Registers a submenu page as a menu page.
         *
         * This method should only be used if the user does not have the required capabilities
         * to access the parent menu page.
         *
         * @param array $submenu_page {
         *     Submenu page definition.
         *
         *     @type string   $0 Parent menu page slug.
         *     @type string   $1 Page title, currently unused.
         *     @type string   $2 Title to display in the menu.
         *     @type string   $3 Required capability to access the page.
         *     @type string   $4 Page slug.
         *     @type callable $5 Callback to run when the page is rendered.
         *     @type array    $6 Optional. List of callbacks to run when the page is loaded.
         * }
         *
         * @return void
         */
        protected function register_menu_page($submenu_page)
        {
        }
        /**
         * Registers a submenu page.
         *
         * This method will override the capability of the page to automatically use the
         * general manage capability. Use the `register_menu_page()` method if the submenu
         * page should actually use a different capability.
         *
         * @param array $submenu_page {
         *     Submenu page definition.
         *
         *     @type string   $0 Parent menu page slug.
         *     @type string   $1 Page title, currently unused.
         *     @type string   $2 Title to display in the menu.
         *     @type string   $3 Required capability to access the page.
         *     @type string   $4 Page slug.
         *     @type callable $5 Callback to run when the page is rendered.
         *     @type array    $6 Optional. List of callbacks to run when the page is loaded.
         * }
         *
         * @return void
         */
        protected function register_submenu_page($submenu_page)
        {
        }
        /**
         * Adds hook callbacks for a given admin page hook suffix.
         *
         * @param string $hook_suffix Admin page hook suffix, as returned by `add_menu_page()`
         *                            or `add_submenu_page()`.
         * @param array  $callbacks   Callbacks to add.
         *
         * @return void
         */
        protected function add_page_hooks($hook_suffix, array $callbacks)
        {
        }
        /**
         * Gets the main admin page identifier.
         *
         * @return string Admin page identifier.
         */
        protected function get_page_identifier()
        {
        }
        /**
         * Checks whether the current user has capabilities to manage all options.
         *
         * @return bool True if capabilities are sufficient, false otherwise.
         */
        protected function check_manage_capability()
        {
        }
        /**
         * Returns the capability that is required to manage all options.
         *
         * @return string Capability to check against.
         */
        protected abstract function get_manage_capability();
        /**
         * Returns the page handler callback.
         *
         * @return array Callback page handler.
         */
        protected function get_admin_page_callback()
        {
        }
        /**
         * Returns the page title to use for the licenses page.
         *
         * @return string The title for the license page.
         */
        protected function get_license_page_title()
        {
        }
        /**
         * Returns a base64 URL for the svg for use in the menu.
         *
         * @param bool $base64 Whether or not to return base64'd output.
         *
         * @return string SVG icon.
         */
        public function get_icon_svg($base64 = \true)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Registers the admin menu on the left of the admin area.
     */
    class WPSEO_Admin_Menu extends \WPSEO_Base_Menu
    {
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Registers the menu item submenus.
         */
        public function register_settings_page()
        {
        }
        /**
         * Returns the list of registered submenu pages.
         *
         * @return array List of registered submenu pages.
         */
        public function get_submenu_pages()
        {
        }
        /**
         * Returns the notification count in HTML format.
         *
         * @return string The notification count in HTML format.
         */
        protected function get_notification_counter()
        {
        }
        /**
         * Returns the capability that is required to manage all options.
         *
         * @return string Capability to check against.
         */
        protected function get_manage_capability()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Registers the regular admin menu and network admin menu implementations.
     */
    class WPSEO_Menu implements \WPSEO_WordPress_Integration
    {
        /**
         * The page identifier used in WordPress to register the admin page.
         *
         * !DO NOT CHANGE THIS!
         *
         * @var string
         */
        const PAGE_IDENTIFIER = 'wpseo_dashboard';
        /**
         * List of classes that add admin functionality.
         *
         * @var array
         */
        protected $admin_features;
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Returns the main menu page identifier.
         *
         * @return string Page identifier to use.
         */
        public function get_page_identifier()
        {
        }
        /**
         * Loads the requested admin settings page.
         *
         * @return void
         */
        public function load_page()
        {
        }
        /**
         * Shows an admin settings page.
         *
         * @param string $page Page to display.
         *
         * @return void
         */
        protected function show_page($page)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Network Admin Menu handler.
     */
    class WPSEO_Network_Admin_Menu extends \WPSEO_Base_Menu
    {
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Register the settings page for the Network settings.
         *
         * @return void
         */
        public function register_settings_page()
        {
        }
        /**
         * Returns the list of registered submenu pages.
         *
         * @return array List of registered submenu pages.
         */
        public function get_submenu_pages()
        {
        }
        /**
         * Loads the form for the network configuration page.
         *
         * @return void
         */
        public function network_config_page()
        {
        }
        /**
         * Checks whether the current user has capabilities to manage all options.
         *
         * @return bool True if capabilities are sufficient, false otherwise.
         */
        protected function check_manage_capability()
        {
        }
        /**
         * Returns the capability that is required to manage all options.
         *
         * @return string Capability to check against.
         */
        protected function get_manage_capability()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Renders a replacement variable editor.
     */
    class WPSEO_Replacevar_Editor
    {
        /**
         * Yoast Forms instance.
         *
         * @var Yoast_Form
         */
        private $yform;
        /**
         * The arguments required for the div to render.
         *
         * @var array {
         *      @type string $title                   The title field id.
         *      @type string $description             The description field id.
         *      @type string $page_type_recommended   The page type for the context of the recommended replace vars.
         *      @type string $page_type_specific      The page type for the context of the editor specific replace vars.
         *      @type bool   $paper_style             Optional. Whether the editor has paper style.
         *      @type string $label_title             Optional. The label to use for the title field.
         *      @type string $label_description       Optional. The label to use for the description field.
         *      @type string $description_placeholder Optional. The placeholder text to use for the description field.
         *      @type bool   $has_new_badge           Optional. Whether to show the "New" badge.
         *      @type bool   $has_premium_badge       Optional. Whether to show the "Premium" badge.
         * }
         */
        private $arguments;
        /**
         * Constructs the object.
         *
         * @param Yoast_Form $yform     Yoast forms.
         * @param array      $arguments {
         *      The arguments that can be given.
         *
         *      @type string $title                   The title field id.
         *      @type string $description             The description field id.
         *      @type string $page_type_recommended   The page type for the context of the recommended replace vars.
         *      @type string $page_type_specific      The page type for the context of the editor specific replace vars.
         *      @type bool   $paper_style             Optional. Whether the editor has paper style.
         *      @type string $label_title             Optional. The label to use for the title field.
         *      @type string $label_description       Optional. The label to use for the description field.
         *      @type string $description_placeholder Optional. The placeholder text to use for the description field.
         *      @type bool   $has_new_badge           Optional. Whether to show the "New" badge.
         *      @type bool   $has_premium_badge       Optional. Whether to show the "Premium" badge.
         * }
         */
        public function __construct(\Yoast_Form $yform, $arguments)
        {
        }
        /**
         * Renders a div for the react application to mount to, and hidden inputs where
         * the app should store it's value so they will be properly saved when the form
         * is submitted.
         *
         * @return void
         */
        public function render()
        {
        }
        /**
         * Validates the replacement variable editor arguments.
         *
         * @param array $arguments The arguments to validate.
         *
         * @throws InvalidArgumentException Thrown when not all required arguments are present.
         */
        protected function validate_arguments(array $arguments)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Renders a single replacement variable field.
     */
    class WPSEO_Replacevar_Field
    {
        /**
         * Forms instance.
         *
         * @var Yoast_Form Yoast
         */
        private $yform;
        /**
         * The id for the hidden field.
         *
         * @var string
         */
        private $field_id;
        /**
         * The label for the field.
         *
         * @var string
         */
        private $label;
        /**
         * The page type for the context of the recommended replace vars.
         *
         * @var string
         */
        private $page_type_recommended;
        /**
         * The page type for the context of the editor specific replace vars.
         *
         * @var string
         */
        private $page_type_specific;
        /**
         * Constructs the object.
         *
         * @param Yoast_Form $yform                 Yoast forms.
         * @param string     $field_id              The field id.
         * @param string     $label                 The field label.
         * @param string     $page_type_recommended The page type for the context of the recommended replace vars.
         * @param string     $page_type_specific    The page type for the context of the editor specific replace vars.
         */
        public function __construct(\Yoast_Form $yform, $field_id, $label, $page_type_recommended, $page_type_specific)
        {
        }
        /**
         * Renders a div for the react application to mount to, and hidden inputs where
         * the app should store it's value so they will be properly saved when the form
         * is submitted.
         *
         * @return void
         */
        public function render()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Menu
     */
    /**
     * Normalize submenu capabilities to `wpseo_manage_options`.
     */
    class WPSEO_Submenu_Capability_Normalize implements \WPSEO_WordPress_Integration
    {
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Normalizes any `manage_options` to `wpseo_manage_options`.
         *
         * This is needed as the module plugins are not updated with the new capabilities directly,
         * but they should not be shown as main menu items.
         *
         * @param array $submenu_pages List of subpages to convert.
         *
         * @return array Converted subpages.
         */
        public function normalize_submenus_capability($submenu_pages)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates and displays the HTML for a metabox section.
     */
    interface WPSEO_Metabox_Section
    {
        /**
         * Outputs the section link.
         */
        public function display_link();
        /**
         * Outputs the section content.
         */
        public function display_content();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Base class for metabox that consist of multiple sections.
     */
    abstract class WPSEO_Abstract_Metabox_Tab_With_Sections implements \WPSEO_Metabox_Section
    {
        /**
         * Holds the name of the tab.
         *
         * @var string
         */
        public $name;
        /**
         * Holds the HTML of the tab header.
         *
         * @var string
         */
        protected $link_content;
        /**
         * Holds the name of the tab header.
         *
         * @var string
         */
        protected $link_title;
        /**
         * Holds the classname of the tab header.
         *
         * @var string
         */
        protected $link_class;
        /**
         * Holds the aria label of the tab header.
         *
         * @var string
         */
        protected $link_aria_label;
        /**
         * Constructor.
         *
         * @param string $name         The name of the section, used as an identifier in the html.
         *                             Can only contain URL safe characters.
         * @param string $link_content The text content of the section link.
         * @param array  $options      Optional link attributes.
         */
        public function __construct($name, $link_content, array $options = [])
        {
        }
        /**
         * Outputs the section link if any section has been added.
         */
        public function display_link()
        {
        }
        /**
         * Checks whether the tab has any sections.
         *
         * @return bool Whether the tab has any sections
         */
        protected abstract function has_sections();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Metabox
     */
    /**
     * Describes an interface for an analysis that can either be enabled or disabled.
     */
    interface WPSEO_Metabox_Analysis
    {
        /**
         * Whether this analysis is enabled.
         *
         * @return bool Whether or not this analysis is enabled.
         */
        public function is_enabled();
        /**
         * Whether or not this analysis is enabled by the user.
         *
         * @return bool Whether or not this analysis is enabled by the user.
         */
        public function is_user_enabled();
        /**
         * Whether or not this analysis is enabled globally.
         *
         * @return bool Whether or not this analysis is enabled globally.
         */
        public function is_globally_enabled();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Metabox
     */
    /**
     * Represents the readability analysis.
     */
    class WPSEO_Metabox_Analysis_Readability implements \WPSEO_Metabox_Analysis
    {
        /**
         * Whether this analysis is enabled.
         *
         * @return bool Whether or not this analysis is enabled.
         */
        public function is_enabled()
        {
        }
        /**
         * Whether or not this analysis is enabled by the user.
         *
         * @return bool Whether or not this analysis is enabled by the user.
         */
        public function is_user_enabled()
        {
        }
        /**
         * Whether or not this analysis is enabled globally.
         *
         * @return bool Whether or not this analysis is enabled globally.
         */
        public function is_globally_enabled()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Metabox
     */
    /**
     * Represents the SEO analysis.
     */
    class WPSEO_Metabox_Analysis_SEO implements \WPSEO_Metabox_Analysis
    {
        /**
         * Whether this analysis is enabled.
         *
         * @return bool Whether or not this analysis is enabled.
         */
        public function is_enabled()
        {
        }
        /**
         * Whether or not this analysis is enabled by the user.
         *
         * @return bool Whether or not this analysis is enabled by the user.
         */
        public function is_user_enabled()
        {
        }
        /**
         * Whether or not this analysis is enabled globally.
         *
         * @return bool Whether or not this analysis is enabled globally.
         */
        public function is_globally_enabled()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates the HTML for a metabox tab.
     */
    interface WPSEO_Metabox_Tab
    {
        /**
         * Returns the html for the tab link.
         *
         * @return string
         */
        public function link();
        /**
         * Returns the html for the tab content.
         *
         * @return string
         */
        public function content();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates the HTML for a metabox tab.
     */
    class WPSEO_Metabox_Collapsible implements \WPSEO_Metabox_Tab
    {
        /**
         * The collapsible's unique identifier.
         *
         * @var string
         */
        private $name;
        /**
         * The content to be displayed inside the collapsible.
         *
         * @var string
         */
        private $content;
        /**
         * The label.
         *
         * @var string
         */
        private $link_content;
        /**
         * Constructor.
         *
         * @param string $name         The name of the tab, used as an identifier in the html.
         * @param string $content      The tab content.
         * @param string $link_content The text content of the tab link.
         */
        public function __construct($name, $content, $link_content)
        {
        }
        /**
         * Returns the html for the tab link.
         *
         * @return string
         */
        public function link()
        {
        }
        /**
         * Returns the html for the tab content.
         *
         * @return string
         */
        public function content()
        {
        }
        /**
         * Returns the collapsible's unique identifier.
         *
         * @return string
         */
        public function get_name()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates and displays a metabox tab that consists of collapsible sections.
     */
    class WPSEO_Metabox_Collapsibles_Sections extends \WPSEO_Abstract_Metabox_Tab_With_Sections
    {
        /**
         * Holds the tab's collapsibles.
         *
         * @var WPSEO_Metabox_Collapsible[]
         */
        private $collapsibles = [];
        /**
         * Constructor.
         *
         * @param string $name         The name of the section, used as an identifier in the html.
         *                             Can only contain URL safe characters.
         * @param string $link_content The text content of the section link.
         * @param array  $collapsibles The metabox collapsibles (`WPSEO_Metabox_Collapsible[]`) to be included in the section.
         * @param array  $options      Optional link attributes.
         */
        public function __construct($name, $link_content, array $collapsibles = [], array $options = [])
        {
        }
        /**
         * Outputs the section content if any tab has been added.
         */
        public function display_content()
        {
        }
        /**
         * Checks whether the tab has any sections.
         *
         * @return bool Whether the tab has any sections
         */
        protected function has_sections()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Metabox
     */
    /**
     * Handles all things with the metabox in combination with the WordPress editor.
     */
    class WPSEO_Metabox_Editor
    {
        /**
         * Registers hooks to WordPress.
         *
         * @codeCoverageIgnore
         */
        public function register_hooks()
        {
        }
        /**
         * Adds our inside the editor CSS file to the list of CSS files to be loaded inside the editor.
         *
         * @param string $css_files The CSS files that WordPress wants to load inside the editor.
         * @return string The CSS files WordPress wants to load and our CSS file.
         */
        public function add_css_inside_editor($css_files)
        {
        }
        /**
         * Adds a custom element to the tinyMCE editor that we need for marking the content.
         *
         * @param array $tinymce_config The tinyMCE config as configured by WordPress.
         *
         * @return array The new tinyMCE config with our added custom elements.
         */
        public function add_custom_element($tinymce_config)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates the HTML for a metabox tab.
     */
    class WPSEO_Metabox_Form_Tab implements \WPSEO_Metabox_Tab
    {
        /**
         * The tab identifier.
         *
         * @var string
         */
        private $name;
        /**
         * The tab content.
         *
         * @var string
         */
        private $content;
        /**
         * The tab link content.
         *
         * @var string
         */
        private $link_content;
        /**
         * Additional tab content class.
         *
         * @var string
         */
        private $tab_class;
        /**
         * Additional tab link class.
         *
         * @var string
         */
        private $link_class;
        /**
         * Title attribute on the link span.
         *
         * @var string
         */
        private $link_title;
        /**
         * Arial label attribute on the link span.
         *
         * @var string
         */
        private $link_aria_label;
        /**
         * Does it contain a single tab.
         *
         * @var bool
         */
        private $single;
        /**
         * Constructor.
         *
         * @param string $name         The name of the tab, used as an identifier in the html.
         * @param string $content      The tab content.
         * @param string $link_content The text content of the tab link.
         * @param array  $options      Optional link attributes.
         */
        public function __construct($name, $content, $link_content, array $options = [])
        {
        }
        /**
         * Returns the html for the tab link.
         *
         * @return string
         */
        public function link()
        {
        }
        /**
         * Returns the html for the tab content.
         *
         * @return string
         */
        public function content()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates the HTML for a metabox tab.
     */
    class WPSEO_Metabox_Null_Tab implements \WPSEO_Metabox_Tab
    {
        /**
         * Returns the html for the tab link.
         *
         * @return string|null
         */
        public function link()
        {
        }
        /**
         * Returns the html for the tab content.
         *
         * @return string|null
         */
        public function content()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Metabox
     */
    /**
     * Generates and displays an additional metabox section.
     */
    class WPSEO_Metabox_Section_Additional implements \WPSEO_Metabox_Section
    {
        /**
         * Name of the section, used as an identifier in the HTML.
         *
         * @var string
         */
        public $name;
        /**
         * Content of the tab's section.
         *
         * @var string
         */
        public $content;
        /**
         * HTML to use in the tab header.
         *
         * @var string
         */
        private $link_content;
        /**
         * Class to add to the link.
         *
         * @var string
         */
        private $link_class;
        /**
         * Aria label to use for the link.
         *
         * @var string
         */
        private $link_aria_label;
        /**
         * Represents the content class.
         *
         * @var string
         */
        private $content_class;
        /**
         * Constructor.
         *
         * @param string $name         The name of the section, used as an identifier in the html.
         *                             Can only contain URL safe characters.
         * @param string $link_content The text content of the section link.
         * @param string $content      Optional. Content to use above the React root element.
         * @param array  $options      Optional link attributes.
         */
        public function __construct($name, $link_content, $content = '', array $options = [])
        {
        }
        /**
         * Outputs the section link.
         *
         * @return void
         */
        public function display_link()
        {
        }
        /**
         * Outputs the section content.
         *
         * @return void
         */
        public function display_content()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates and displays the React root element for a metabox section.
     */
    class WPSEO_Metabox_Section_React implements \WPSEO_Metabox_Section
    {
        /**
         * Name of the section, used as an identifier in the HTML.
         *
         * @var string
         */
        public $name;
        /**
         * Content to use before the React root node.
         *
         * @var string
         */
        public $content;
        /**
         * Content to use to display the button to open this content block.
         *
         * @var string
         */
        private $link_content;
        /**
         * Class to add to the link.
         *
         * @var string
         */
        private $link_class;
        /**
         * Aria label to use for the link.
         *
         * @var string
         */
        private $link_aria_label;
        /**
         * Additional html content to be displayed within the section.
         *
         * @var string
         */
        private $html_after;
        /**
         * Constructor.
         *
         * @param string $name         The name of the section, used as an identifier in the html.
         *                             Can only contain URL safe characters.
         * @param string $link_content The text content of the section link.
         * @param string $content      Optional. Content to use above the React root element.
         * @param array  $options      Optional link attributes.
         */
        public function __construct($name, $link_content, $content = '', array $options = [])
        {
        }
        /**
         * Outputs the section link.
         *
         * @return void
         */
        public function display_link()
        {
        }
        /**
         * Outputs the section content.
         *
         * @return void
         */
        public function display_content()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generates and displays the React root element for a metabox section.
     */
    class WPSEO_Metabox_Section_Readability implements \WPSEO_Metabox_Section
    {
        /**
         * Name of the section, used as an identifier in the HTML.
         *
         * @var string
         */
        public $name = 'readability';
        /**
         * Outputs the section link.
         */
        public function display_link()
        {
        }
        /**
         * Outputs the section content.
         */
        public function display_content()
        {
        }
    }
    /**
     * This class implements defaults and value validation for all WPSEO Post Meta values.
     *
     * Some guidelines:
     * - To update a meta value, you can just use update_post_meta() with the full (prefixed) meta key
     *   or the convenience method WPSEO_Meta::set_value() with the internal key.
     *   All updates will be automatically validated.
     *   Meta values will only be saved to the database if they are *not* the same as the default to
     *   keep database load low.
     * - To retrieve a WPSEO meta value, you **must** use WPSEO_Meta::get_value() which will always return a
     *   string value, either the saved value or the default.
     *   This method can also retrieve a complete set of WPSEO meta values for one specific post, see
     *   the method documentation for the parameters.
     *
     * {@internal Unfortunately there isn't a filter available to hook into before returning the results
     *            for get_post_meta(), get_post_custom() and the likes. That would have been the
     *            preferred solution.}}
     *
     * {@internal All WP native get_meta() results get cached internally, so no need to cache locally.}}
     * {@internal Use $key when the key is the WPSEO internal name (without prefix), $meta_key when it
     *            includes the prefix.}}
     */
    class WPSEO_Meta
    {
        /**
         * Prefix for all WPSEO meta values in the database.
         *
         * {@internal If at any point this would change, quite apart from an upgrade routine,
         *            this also will need to be changed in the wpml-config.xml file.}}
         *
         * @var string
         */
        public static $meta_prefix = '_yoast_wpseo_';
        /**
         * Prefix for all WPSEO meta value form field names and ids.
         *
         * @var string
         */
        public static $form_prefix = 'yoast_wpseo_';
        /**
         * Allowed length of the meta description.
         *
         * @var int
         */
        public static $meta_length = 156;
        /**
         * Reason the meta description is not the default length.
         *
         * @var string
         */
        public static $meta_length_reason = '';
        /**
         * Meta box field definitions for the meta box form.
         *
         * {@internal
         * - Titles, help texts, description text and option labels are added via a translate_meta_boxes() method
         *   in the relevant child classes (WPSEO_Metabox and WPSEO_Social_admin) as they are only needed there.
         * - Beware: even though the meta keys are divided into subsets, they still have to be uniquely named!}}
         *
         * @var array
         *            Array format:
         *                (required)       'type'          => (string) field type. i.e. text / textarea / checkbox /
         *                                                    radio / select / multiselect / upload etc.
         *                (required)       'title'         => (string) table row title.
         *                (recommended)    'default_value' => (string|array) default value for the field.
         *                                                    IMPORTANT:
         *                                                    - if the field has options, the default has to be the
         *                                                      key of one of the options.
         *                                                    - if the field is a text field, the default **has** to be
         *                                                      an empty string as otherwise the user can't save
         *                                                      an empty value/delete the meta value.
         *                                                    - if the field is a checkbox, the only valid values
         *                                                      are 'on' or 'off'.
         *                (semi-required)   'options'      => (array) options for used with (multi-)select and radio
         *                                                    fields, required if that's the field type.
         *                                                    key = (string) value which will be saved to db.
         *                                                    value = (string) text label for the option.
         *                (optional)        'autocomplete' => (bool) whether autocomplete is on for text fields,
         *                                                    defaults to true.
         *                (optional)        'class'        => (string) classname(s) to add to the actual <input> tag.
         *                (optional)        'description'  => (string) description to show underneath the field.
         *                (optional)        'expl'         => (string) label for a checkbox.
         *                (optional)        'help'         => (string) help text to show on mouse over ? image.
         *                (optional)        'rows'         => (int) number of rows for a textarea, defaults to 3.
         *                (optional)        'placeholder'  => (string) Currently only used by add-on plugins.
         *                (optional)        'serialized'   => (bool) whether the value is expected to be serialized,
         *                                                     i.e. an array or object, defaults to false.
         *                                                     Currently only used by add-on plugins.
         */
        public static $meta_fields = [
            'general' => ['focuskw' => ['type' => 'hidden', 'title' => ''], 'title' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'description' => '',
                // Translation added later.
                'help' => '',
            ], 'metadesc' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'class' => 'metadesc',
                'rows' => 2,
                'description' => '',
                // Translation added later.
                'help' => '',
            ], 'linkdex' => ['type' => 'hidden', 'title' => 'linkdex', 'default_value' => '0', 'description' => ''], 'content_score' => ['type' => 'hidden', 'title' => 'content_score', 'default_value' => '0', 'description' => ''], 'is_cornerstone' => ['type' => 'hidden', 'title' => 'is_cornerstone', 'default_value' => 'false', 'description' => '']],
            'advanced' => ['meta-robots-noindex' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '0',
                // = post-type default.
                'options' => [
                    '0' => '',
                    // Post type default - translation added later.
                    '2' => '',
                    // Index - translation added later.
                    '1' => '',
                ],
            ], 'meta-robots-nofollow' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '0',
                // = follow.
                'options' => [
                    '0' => '',
                    // Follow - translation added later.
                    '1' => '',
                ],
            ], 'meta-robots-adv' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'description' => '',
                // Translation added later.
                'options' => [
                    'noimageindex' => '',
                    // Translation added later.
                    'noarchive' => '',
                    // Translation added later.
                    'nosnippet' => '',
                ],
            ], 'bctitle' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'description' => '',
            ], 'canonical' => [
                'type' => 'hidden',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'description' => '',
            ], 'redirect' => [
                'type' => 'url',
                'title' => '',
                // Translation added later.
                'default_value' => '',
                'description' => '',
            ]],
            'social' => [],
            'schema' => ['schema_page_type' => ['type' => 'hidden', 'title' => '', 'options' => \Yoast\WP\SEO\Config\Schema_Types::PAGE_TYPES], 'schema_article_type' => ['type' => 'hidden', 'title' => '', 'hide_on_pages' => \true, 'options' => \Yoast\WP\SEO\Config\Schema_Types::ARTICLE_TYPES]],
            /* Fields we should validate & save, but not show on any form. */
            'non_form' => ['linkdex' => ['type' => \null, 'default_value' => '0'], 'zapier_trigger_sent' => ['type' => \null, 'default_value' => '0']],
        ];
        /**
         * Helper property - reverse index of the definition array.
         *
         * Format: [full meta key including prefix]    => array
         *         ['subset']    => (string) primary index
         *         ['key']       => (string) internal key
         *
         * @var array
         */
        public static $fields_index = [];
        /**
         * Helper property - array containing only the defaults in the format:
         * [full meta key including prefix]    => (string) default value
         *
         * @var array
         */
        public static $defaults = [];
        /**
         * Helper property to define the social network meta field definitions - networks.
         *
         * @var array
         */
        private static $social_networks = ['opengraph' => 'opengraph', 'twitter' => 'twitter'];
        /**
         * Helper property to define the social network meta field definitions - fields and their type.
         *
         * @var array
         */
        private static $social_fields = ['title' => 'hidden', 'description' => 'hidden', 'image' => 'hidden', 'image-id' => 'hidden'];
        /**
         * Register our actions and filters.
         *
         * @return void
         */
        public static function init()
        {
        }
        /**
         * Retrieve the meta box form field definitions for the given tab and post type.
         *
         * @param string $tab       Tab for which to retrieve the field definitions.
         * @param string $post_type Post type of the current post.
         *
         * @return array Array containing the meta box field definitions.
         */
        public static function get_meta_field_defs($tab, $post_type = 'post')
        {
        }
        /**
         * Validate the post meta values.
         *
         * @param mixed  $meta_value The new value.
         * @param string $meta_key   The full meta key (including prefix).
         *
         * @return string Validated meta value.
         */
        public static function sanitize_post_meta($meta_value, $meta_key)
        {
        }
        /**
         * Validate a meta-robots-adv meta value.
         *
         * @todo [JRF => Yoast] Verify that this logic for the prioritisation is correct.
         *
         * @param array|string $meta_value The value to validate.
         *
         * @return string Clean value.
         */
        public static function validate_meta_robots_adv($meta_value)
        {
        }
        /**
         * Prevent saving of default values and remove potential old value from the database if replaced by a default.
         *
         * @param bool   $check      The current status to allow updating metadata for the given type.
         * @param int    $object_id  ID of the current object for which the meta is being updated.
         * @param string $meta_key   The full meta key (including prefix).
         * @param string $meta_value New meta value.
         * @param string $prev_value The old meta value.
         *
         * @return bool|null True = stop saving, null = continue saving.
         */
        public static function remove_meta_if_default($check, $object_id, $meta_key, $meta_value, $prev_value = '')
        {
        }
        /**
         * Prevent adding of default values to the database.
         *
         * @param bool   $check      The current status to allow adding metadata for the given type.
         * @param int    $object_id  ID of the current object for which the meta is being added.
         * @param string $meta_key   The full meta key (including prefix).
         * @param string $meta_value New meta value.
         *
         * @return bool|null True = stop saving, null = continue saving.
         */
        public static function dont_save_meta_if_default($check, $object_id, $meta_key, $meta_value)
        {
        }
        /**
         * Is the given meta value the same as the default value ?
         *
         * @param string $meta_key   The full meta key (including prefix).
         * @param mixed  $meta_value The value to check.
         *
         * @return bool
         */
        public static function meta_value_is_default($meta_key, $meta_value)
        {
        }
        /**
         * Get a custom post meta value.
         *
         * Returns the default value if the meta value has not been set.
         *
         * {@internal Unfortunately there isn't a filter available to hook into before returning
         *            the results for get_post_meta(), get_post_custom() and the likes. That
         *            would have been the preferred solution.}}
         *
         * @param string $key    Internal key of the value to get (without prefix).
         * @param int    $postid Post ID of the post to get the value for.
         *
         * @return string All 'normal' values returned from get_post_meta() are strings.
         *                Objects and arrays are possible, but not used by this plugin
         *                and therefore discarted (except when the special 'serialized' field def
         *                value is set to true - only used by add-on plugins for now).
         *                Will return the default value if no value was found.
         *                Will return empty string if no default was found (not one of our keys) or
         *                if the post does not exist.
         */
        public static function get_value($key, $postid = 0)
        {
        }
        /**
         * Update a meta value for a post.
         *
         * @param string $key        The internal key of the meta value to change (without prefix).
         * @param mixed  $meta_value The value to set the meta to.
         * @param int    $post_id    The ID of the post to change the meta for.
         *
         * @return bool Whether the value was changed.
         */
        public static function set_value($key, $meta_value, $post_id)
        {
        }
        /**
         * Deletes a meta value for a post.
         *
         * @param string $key     The internal key of the meta value to change (without prefix).
         * @param int    $post_id The ID of the post to change the meta for.
         *
         * @return bool Whether the value was changed.
         */
        public static function delete($key, $post_id)
        {
        }
        /**
         * Used for imports, this functions imports the value of $old_metakey into $new_metakey for those post
         * where no WPSEO meta data has been set.
         * Optionally deletes the $old_metakey values.
         *
         * @param string $old_metakey The old key of the meta value.
         * @param string $new_metakey The new key, usually the WPSEO meta key (including prefix).
         * @param bool   $delete_old  Whether to delete the old meta key/value-sets.
         *
         * @return void
         */
        public static function replace_meta($old_metakey, $new_metakey, $delete_old = \false)
        {
        }
        /**
         * General clean-up of the saved meta values.
         * - Remove potentially lingering old meta keys;
         * - Remove all default and invalid values.
         *
         * @return void
         */
        public static function clean_up()
        {
        }
        /**
         * Recursively merge a variable number of arrays, using the left array as base,
         * giving priority to the right array.
         *
         * Difference with native array_merge_recursive():
         * array_merge_recursive converts values with duplicate keys to arrays rather than
         * overwriting the value in the first array with the duplicate value in the second array.
         *
         * array_merge_recursive_distinct does not change the data types of the values in the arrays.
         * Matching keys' values in the second array overwrite those in the first array, as is the
         * case with array_merge.
         *
         * Freely based on information found on http://www.php.net/manual/en/function.array-merge-recursive.php
         *
         * {@internal Should be moved to a general utility class.}}
         *
         * @return array
         */
        public static function array_merge_recursive_distinct()
        {
        }
        /**
         * Counts the total of all the keywords being used for posts except the given one.
         *
         * @param string $keyword The keyword to be counted.
         * @param int    $post_id The id of the post to which the keyword belongs.
         *
         * @return array
         */
        public static function keyword_usage($keyword, $post_id)
        {
        }
    }
    /**
     * This class generates the metabox on the edit post / page as well as contains all page analysis functionality.
     */
    class WPSEO_Metabox extends \WPSEO_Meta
    {
        /**
         * Whether or not the social tab is enabled.
         *
         * @var bool
         */
        private $social_is_enabled;
        /**
         * Helper to determine whether or not the SEO analysis is enabled.
         *
         * @var WPSEO_Metabox_Analysis_SEO
         */
        protected $seo_analysis;
        /**
         * Helper to determine whether or not the readability analysis is enabled.
         *
         * @var WPSEO_Metabox_Analysis_Readability
         */
        protected $readability_analysis;
        /**
         * The metabox editor object.
         *
         * @var WPSEO_Metabox_Editor
         */
        protected $editor;
        /**
         * The Metabox post.
         *
         * @var WP_Post
         */
        protected $post = \null;
        /**
         * Whether or not the advanced metadata is enabled.
         *
         * @var bool
         */
        protected $is_advanced_metadata_enabled;
        /**
         * Represents the estimated_reading_time_conditional.
         *
         * @var Estimated_Reading_Time_Conditional
         */
        protected $estimated_reading_time_conditional;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Checks whether the request comes from an IE 11 browser.
         *
         * @return bool Whether the request comes from an IE 11 browser.
         */
        public static function is_internet_explorer()
        {
        }
        /**
         * Adds an alternative metabox for internet explorer users.
         */
        public function internet_explorer_metabox()
        {
        }
        /**
         * Renders the content for the internet explorer metabox.
         *
         * @return void
         */
        public function render_internet_explorer_notice()
        {
        }
        /**
         * Translates text strings for use in the meta box.
         *
         * IMPORTANT: if you want to add a new string (option) somewhere, make sure you add that array key to
         * the main meta box definition array in the class WPSEO_Meta() as well!!!!
         */
        public static function translate_meta_boxes()
        {
        }
        /**
         * Determines whether the metabox should be shown for the passed identifier.
         *
         * By default the check is done for post types, but can also be used for taxonomies.
         *
         * @param string|null $identifier The identifier to check.
         * @param string      $type       The type of object to check. Defaults to post_type.
         *
         * @return bool Whether or not the metabox should be displayed.
         */
        public function display_metabox($identifier = \null, $type = 'post_type')
        {
        }
        /**
         * Adds the Yoast SEO meta box to the edit boxes in the edit post, page,
         * attachment, and custom post types pages.
         *
         * @return void
         */
        public function add_meta_box()
        {
        }
        /**
         * Adds CSS classes to the meta box.
         *
         * @param array $classes An array of postbox CSS classes.
         *
         * @return array List of classes that will be applied to the editbox container.
         */
        public function wpseo_metabox_class($classes)
        {
        }
        /**
         * Passes variables to js for use with the post-scraper.
         *
         * @return array
         */
        public function get_metabox_script_data()
        {
        }
        /**
         * Determines whether or not the current post type has registered taxonomies.
         *
         * @return bool Whether the current post type has taxonomies.
         */
        private function current_post_type_has_taxonomies()
        {
        }
        /**
         * Determines the scope based on the post type.
         * This can be used by the replacevar plugin to determine if a replacement needs to be executed.
         *
         * @return string String describing the current scope.
         */
        private function determine_scope()
        {
        }
        /**
         * Outputs the meta box.
         */
        public function meta_box()
        {
        }
        /**
         * Renders the metabox hidden fields.
         *
         * @return void
         */
        protected function render_hidden_fields()
        {
        }
        /**
         * Renders the metabox tabs.
         *
         * @return void
         */
        protected function render_tabs()
        {
        }
        /**
         * Returns the relevant metabox tabs for the current view.
         *
         * @return WPSEO_Metabox_Section[]
         */
        private function get_tabs()
        {
        }
        /**
         * Returns the metabox tabs that have been added by other plugins.
         *
         * @return WPSEO_Metabox_Section_Additional[]
         */
        protected function get_additional_tabs()
        {
        }
        /**
         * Adds a line in the meta box.
         *
         * @todo [JRF] Check if $class is added appropriately everywhere.
         *
         * @param array  $meta_field_def Contains the vars based on which output is generated.
         * @param string $key            Internal key (without prefix).
         *
         * @return string
         */
        public function do_meta_box($meta_field_def, $key = '')
        {
        }
        /**
         * Saves the WP SEO metadata for posts.
         *
         * {@internal $_POST parameters are validated via sanitize_post_meta().}}
         *
         * @param int $post_id Post ID.
         *
         * @return bool|void Boolean false if invalid save post request.
         */
        public function save_postdata($post_id)
        {
        }
        /**
         * Determines if the given meta value key is disabled.
         *
         * @param string $key The key of the meta value.
         *
         * @return bool Whether the given meta value key is disabled.
         */
        public function is_meta_value_disabled($key)
        {
        }
        /**
         * Enqueues all the needed JS and CSS.
         *
         * @todo [JRF => whomever] Create css/metabox-mp6.css file and add it to the below allowed colors array when done.
         */
        public function enqueue()
        {
        }
        /**
         * Returns post in metabox context.
         *
         * @return WP_Post|array
         */
        protected function get_metabox_post()
        {
        }
        /**
         * Returns an array with shortcode tags for all registered shortcodes.
         *
         * @return array
         */
        private function get_valid_shortcode_tags()
        {
        }
        /**
         * Prepares the replace vars for localization.
         *
         * @return array Replace vars.
         */
        private function get_replace_vars()
        {
        }
        /**
         * Prepares the recommended replace vars for localization.
         *
         * @return array Recommended replacement variables.
         */
        private function get_recommended_replace_vars()
        {
        }
        /**
         * Gets the custom replace variables for custom taxonomies and fields.
         *
         * @param WP_Post $post The post to check for custom taxonomies and fields.
         *
         * @return array Array containing all the replacement variables.
         */
        private function get_custom_replace_vars($post)
        {
        }
        /**
         * Gets the custom replace variables for custom taxonomies.
         *
         * @param WP_Post $post The post to check for custom taxonomies.
         *
         * @return array Array containing all the replacement variables.
         */
        private function get_custom_taxonomies_replace_vars($post)
        {
        }
        /**
         * Gets the custom replace variables for custom fields.
         *
         * @param WP_Post $post The post to check for custom fields.
         *
         * @return array Array containing all the replacement variables.
         */
        private function get_custom_fields_replace_vars($post)
        {
        }
        /**
         * Checks if the page is the post overview page.
         *
         * @param string $page The page to check for the post overview page.
         *
         * @return bool Whether or not the given page is the post overview page.
         */
        public static function is_post_overview($page)
        {
        }
        /**
         * Checks if the page is the post edit page.
         *
         * @param string $page The page to check for the post edit page.
         *
         * @return bool Whether or not the given page is the post edit page.
         */
        public static function is_post_edit($page)
        {
        }
        /**
         * Retrieves the product title.
         *
         * @return string The product title.
         */
        protected function get_product_title()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Notifiers
     */
    /**
     * Represents the logic for showing the notification.
     */
    class WPSEO_Configuration_Notifier implements \WPSEO_Listener
    {
        /**
         * Option name use to determine whether the notice has been dismissed.
         *
         * @var string
         */
        const META_NAME = 'wpseo-dismiss-configuration-notice';
        /**
         * Default value.
         *
         * @var string
         */
        const META_VALUE = 'yes';
        /**
         * Should the notification be shown.
         *
         * @var bool
         */
        protected $show_notification;
        /**
         * Constructs the object by setting the show notification property based the given options.
         */
        public function __construct()
        {
        }
        /**
         * Returns the content of the notification.
         *
         * @return string A string with the notification HTML, or empty string when no notification is needed.
         */
        public function notify()
        {
        }
        /**
         * Listens to an argument in the request URL. When triggered just set the notification to dismissed.
         *
         * @return void
         */
        public function listen()
        {
        }
        /**
         * Checks if the dismissal should be triggered.
         *
         * @return bool True when action has been triggered.
         */
        protected function dismissal_is_triggered()
        {
        }
        /**
         * Checks if the current user has dismissed the notification.
         *
         * @return bool True when the notification has been dismissed.
         */
        protected function is_dismissed()
        {
        }
        /**
         * Sets the dismissed state for the current user.
         *
         * @return void
         */
        protected function set_dismissed()
        {
        }
        /**
         * Checks if the notification should be shown.
         *
         * @return bool True when notification should be shown.
         */
        protected function show_notification()
        {
        }
        /**
         * Returns the notification to re-run the config wizard.
         *
         * @return string The notification.
         */
        private function re_run_notification()
        {
        }
        /**
         * Returns the notification to start the config wizard for the first time.
         *
         * @return string The notification.
         */
        private function first_time_notification()
        {
        }
        /**
         * Returns a styled notification.
         *
         * @param string $title          Title for the notification.
         * @param string $content        Content for the notification.
         * @param bool   $show_dismissal Whether to show the dismiss button or not.
         *
         * @return string The styled notification.
         */
        private function notification($title, $content, $show_dismissal = \false)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Notifiers
     */
    /**
     * Dictates the required methods for a Notification Handler implementation.
     */
    interface WPSEO_Notification_Handler
    {
        /**
         * Handles the notification object.
         *
         * @param Yoast_Notification_Center $notification_center The notification center object.
         *
         * @return void
         */
        public function handle(\Yoast_Notification_Center $notification_center);
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Notifiers
     */
    /**
     * Abstract class representing a dismissible notification.
     */
    abstract class WPSEO_Dismissible_Notification implements \WPSEO_Listener, \WPSEO_Notification_Handler
    {
        /**
         * The identifier for the notification.
         *
         * @var string
         */
        protected $notification_identifier = '';
        /**
         * Retrieves instance of a notification.
         *
         * @return Yoast_Notification The notification.
         */
        protected abstract function get_notification();
        /**
         * Listens to an argument in the request URL and triggers an action.
         *
         * @return void
         */
        public function listen()
        {
        }
        /**
         * Adds the notification if applicable, otherwise removes it.
         *
         * @param Yoast_Notification_Center $notification_center The notification center object.
         *
         * @return void
         */
        public function handle(\Yoast_Notification_Center $notification_center)
        {
        }
        /**
         * Listens to an argument in the request URL and triggers an action.
         *
         * @return void
         */
        protected function dismiss()
        {
        }
        /**
         * Checks if a notice is applicable.
         *
         * @return bool Whether a notice should be shown or not.
         */
        protected function is_applicable()
        {
        }
        /**
         * Checks whether the notification has been dismissed.
         *
         * @codeCoverageIgnore
         *
         * @return bool True when notification is dismissed.
         */
        protected function is_notice_dismissed()
        {
        }
        /**
         * Retrieves the value where listener is listening for.
         *
         * @codeCoverageIgnore
         *
         * @return string The listener value.
         */
        protected function get_listener_value()
        {
        }
        /**
         * Dismisses the notification.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        protected function set_dismissal_state()
        {
        }
        /**
         * Redirects the user back to the dashboard.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        protected function redirect_to_dashboard()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * Role Manager interface.
     */
    interface WPSEO_Role_Manager
    {
        /**
         * Registers a role.
         *
         * @param string      $role         Role to register.
         * @param string      $display_name Display name to use.
         * @param string|null $template     Optional. Role to base the new role on.
         *
         * @return void
         */
        public function register($role, $display_name, $template = \null);
        /**
         * Adds the registered roles.
         *
         * @return void
         */
        public function add();
        /**
         * Removes the registered roles.
         *
         * @return void
         */
        public function remove();
        /**
         * Returns the list of registered roles.
         *
         * @return string[] List or registered roles.
         */
        public function get_roles();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * Abstract Role Manager template.
     */
    abstract class WPSEO_Abstract_Role_Manager implements \WPSEO_Role_Manager
    {
        /**
         * Registered roles.
         *
         * @var array
         */
        protected $roles = [];
        /**
         * Registers a role.
         *
         * @param string      $role         Role to register.
         * @param string      $display_name Display name to use.
         * @param string|null $template     Optional. Role to base the new role on.
         *
         * @return void
         */
        public function register($role, $display_name, $template = \null)
        {
        }
        /**
         * Returns the list of registered roles.
         *
         * @return string[] List or registered roles.
         */
        public function get_roles()
        {
        }
        /**
         * Adds the registered roles.
         *
         * @return void
         */
        public function add()
        {
        }
        /**
         * Removes the registered roles.
         *
         * @return void
         */
        public function remove()
        {
        }
        /**
         * Returns the capabilities for the specified role.
         *
         * @param string $role Role to fetch capabilities from.
         *
         * @return array List of capabilities.
         */
        protected function get_capabilities($role)
        {
        }
        /**
         * Returns true if the capability exists on the role.
         *
         * @param WP_Role $role       Role to check capability against.
         * @param string  $capability Capability to check.
         *
         * @return bool True if the capability is defined for the role.
         */
        protected function capability_exists(\WP_Role $role, $capability)
        {
        }
        /**
         * Filters out capabilities that are already set for the role.
         *
         * This makes sure we don't override configurations that have been previously set.
         *
         * @param string $role         The role to check against.
         * @param array  $capabilities The capabilities that should be set.
         *
         * @return array Capabilties that can be safely set.
         */
        protected function filter_existing_capabilties($role, array $capabilities)
        {
        }
        /**
         * Adds a role to the system.
         *
         * @param string $role         Role to add.
         * @param string $display_name Name to display for the role.
         * @param array  $capabilities Capabilities to add to the role.
         *
         * @return void
         */
        protected abstract function add_role($role, $display_name, array $capabilities = []);
        /**
         * Removes a role from the system.
         *
         * @param string $role Role to remove.
         *
         * @return void
         */
        protected abstract function remove_role($role);
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * Role registration class.
     */
    class WPSEO_Register_Roles implements \WPSEO_WordPress_Integration
    {
        /**
         * Adds hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Registers the roles.
         *
         * @return void
         */
        public function register()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * Role Manager Factory.
     */
    class WPSEO_Role_Manager_Factory
    {
        /**
         * Retrieves the Role manager to use.
         *
         * @return WPSEO_Role_Manager
         */
        public static function get()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * VIP implementation of the Role Manager.
     */
    final class WPSEO_Role_Manager_VIP extends \WPSEO_Abstract_Role_Manager
    {
        /**
         * Adds a role to the system.
         *
         * @param string $role         Role to add.
         * @param string $display_name Name to display for the role.
         * @param array  $capabilities Capabilities to add to the role.
         *
         * @return void
         */
        protected function add_role($role, $display_name, array $capabilities = [])
        {
        }
        /**
         * Removes a role from the system.
         *
         * @param string $role Role to remove.
         *
         * @return void
         */
        protected function remove_role($role)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Roles
     */
    /**
     * WordPress' default implementation of the Role Manager.
     */
    final class WPSEO_Role_Manager_WP extends \WPSEO_Abstract_Role_Manager
    {
        /**
         * Adds a role to the system.
         *
         * @param string $role         Role to add.
         * @param string $display_name Name to display for the role.
         * @param array  $capabilities Capabilities to add to the role.
         *
         * @return void
         */
        protected function add_role($role, $display_name, array $capabilities = [])
        {
        }
        /**
         * Removes a role from the system.
         *
         * @param string $role Role to remove.
         *
         * @return void
         */
        protected function remove_role($role)
        {
        }
        /**
         * Formats the capabilities to the required format.
         *
         * @param array $capabilities Capabilities to format.
         * @param bool  $enabled      Whether these capabilities should be enabled or not.
         *
         * @return array Formatted capabilities.
         */
        protected function format_capabilities(array $capabilities, $enabled = \true)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class handles the data for the option where the Ryte data is stored.
     */
    class WPSEO_Ryte_Option
    {
        /**
         * Indicates the data is not fetched.
         *
         * @var int
         */
        const NOT_FETCHED = 99;
        /**
         * Indicates the option is indexable.
         *
         * @var int
         */
        const IS_INDEXABLE = 1;
        /**
         * Indicates the option is not indexable.
         *
         * @var int
         */
        const IS_NOT_INDEXABLE = 0;
        /**
         * Indicates the data could not be fetched.
         *
         * @var int
         */
        const CANNOT_FETCH = -1;
        /**
         * The name of the option where data will be stored.
         *
         * @var string
         */
        const OPTION_NAME = 'wpseo_ryte';
        /**
         * The key of the status in the option.
         *
         * @var string
         */
        const STATUS = 'status';
        /**
         * The key of the last fetch date in the option.
         *
         * @var string
         */
        const LAST_FETCH = 'last_fetch';
        /**
         * The limit for fetching the status manually.
         *
         * @var int
         */
        const FETCH_LIMIT = 15;
        /**
         * The Ryte option stored in the database.
         *
         * @var array
         */
        private $ryte_option;
        /**
         * Setting the object by setting the properties.
         */
        public function __construct()
        {
        }
        /**
         * Getting the status from the option.
         *
         * @return string
         */
        public function get_status()
        {
        }
        /**
         * Saving the status to the options.
         *
         * @param string $status The status to save.
         */
        public function set_status($status)
        {
        }
        /**
         * Saving the last fetch timestamp to the options.
         *
         * @param int $timestamp Timestamp with the new value.
         */
        public function set_last_fetch($timestamp)
        {
        }
        /**
         * Determines whether the indexability status should be fetched.
         *
         * If LAST_FETCH isn't set, we assume the indexability status hasn't been fetched
         * yet and return true. Then, we check whether the last fetch is within the
         * FETCH_LIMIT time interval (15 seconds) to avoid too many consecutive API calls.
         *
         * @return bool Whether the indexability status should be fetched.
         */
        public function should_be_fetched()
        {
        }
        /**
         * Saving the option with the current data.
         */
        public function save_option()
        {
        }
        /**
         * Returns the value of the onpage_enabled status.
         *
         * @return bool
         */
        public function is_enabled()
        {
        }
        /**
         * Getting the option with the Ryte data.
         *
         * @return array
         */
        private function get_option()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class will fetch a new status from Ryte and if it's necessary it will
     * notify the site admin by email and remove the current meta value to hide the
     * notice for all admin users.
     */
    class WPSEO_Ryte_Request
    {
        /**
         * The endpoint where the request will be send to.
         *
         * @var string
         */
        private $ryte_endpoint = 'https://indexability.yoast.onpage.org/';
        /**
         * Gets the response from the Ryte API and returns the body.
         *
         * @param string $target_url The URL to check indexability for.
         * @param array  $parameters Array of extra parameters to send to the Ryte API.
         *
         * @return array The successful response or the error details.
         */
        protected function get_remote($target_url, $parameters = [])
        {
        }
        /**
         * Sends a request to the Ryte API to check whether a URL is indexable.
         *
         * @param string $target_url The URL to check indexability for.
         * @param array  $parameters Array of extra parameters to send to the Ryte API.
         *
         * @return array
         */
        public function do_request($target_url, $parameters = [])
        {
        }
        /**
         * Processes the given Ryte response.
         *
         * @param array|WP_Error $response The response or WP_Error to process.
         *
         * @return array The response body or the error detaiils on failure.
         */
        protected function process_response($response)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Handles the request for getting the Ryte status.
     */
    class WPSEO_Ryte implements \WPSEO_WordPress_Integration
    {
        /**
         * Is the request started by pressing the fetch button.
         *
         * @var bool
         */
        private $is_manual_request = \false;
        /**
         * Holds the Ryte API response.
         *
         * @var array
         */
        private $ryte_response = \null;
        /**
         * Constructs the object.
         */
        public function __construct()
        {
        }
        /**
         * Sets up the hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Determines if we can use the functionality.
         *
         * @return bool True if this functionality can be used.
         */
        public static function is_active()
        {
        }
        /**
         * Hooks to run on plugin activation.
         */
        public function activate_hooks()
        {
        }
        /**
         * Determines whether to add a custom cron weekly schedule.
         *
         * @return void
         */
        public function maybe_add_weekly_schedule()
        {
        }
        /**
         * Adds a custom weekly cron schedule.
         *
         * @param array $schedules The existing custom cron schedules.
         *
         * @return array Enriched list of custom cron schedules.
         */
        public function add_weekly_schedule($schedules)
        {
        }
        /**
         * Fetches the data from Ryte.
         *
         * @return bool|null Whether the request ran.
         */
        public function fetch_from_ryte()
        {
        }
        /**
         * Retrieves the option to use.
         *
         * @return WPSEO_Ryte_Option The option.
         */
        protected function get_option()
        {
        }
        /**
         * Sends a request to Ryte to get the indexability status.
         *
         * @return int The indexability status value.
         */
        protected function request_indexability()
        {
        }
        /**
         * Schedules the cronjob to get the new indexability status.
         *
         * @return void
         */
        private function schedule_cron()
        {
        }
        /**
         * Unschedules the cronjob to get the new indexability status.
         *
         * @return void
         */
        private function unschedule_cron()
        {
        }
        /**
         * Checks if WordFence protects the site against 'fake' Google crawlers.
         *
         * @return bool True if WordFence protects the site.
         */
        private function wordfence_protection_enabled()
        {
        }
        /**
         * Retrieves the Ryte API response property.
         *
         * @return array|WP_Error The response or WP_Error on failure.
         */
        public function get_response()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Services
     */
    /**
     * Represents the file size service.
     */
    class WPSEO_File_Size_Service
    {
        /**
         * Retrieves an indexable.
         *
         * @param WP_REST_Request $request The request object.
         *
         * @return WP_REST_Response The response.
         */
        public function get(\WP_REST_Request $request)
        {
        }
        /**
         * Retrieves the file url.
         *
         * @param WP_REST_Request $request The request to retrieve file url from.
         *
         * @return string The file url.
         * @throws WPSEO_File_Size_Exception The file is hosted externally.
         */
        protected function get_file_url(\WP_REST_Request $request)
        {
        }
        /**
         * Checks if the file is hosted externally.
         *
         * @param string $file_url The file url.
         *
         * @return bool True if it is hosted externally.
         */
        protected function is_externally_hosted($file_url)
        {
        }
        /**
         * Returns the file size.
         *
         * @param string $file_url The file url to get the size for.
         *
         * @return int The file size.
         * @throws WPSEO_File_Size_Exception Retrieval of file size went wrong for unknown reasons.
         */
        protected function get_file_size($file_url)
        {
        }
        /**
         * Calculates the file size using the Utils class.
         *
         * @param string $file_url The file to retrieve the size for.
         *
         * @return int|bool The file size or False if it could not be retrieved.
         */
        protected function calculate_file_size($file_url)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Statistics
     */
    /**
     * Class WPSEO_Statistic_Integration.
     */
    class WPSEO_Statistic_Integration implements \WPSEO_WordPress_Integration
    {
        /**
         * Adds hooks to clear the cache.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Clears the dashboard widget items cache.
         *
         * @return void
         */
        public function clear_cache()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Statistics
     */
    /**
     * Class WPSEO_Statistics_Service.
     */
    class WPSEO_Statistics_Service
    {
        /**
         * Cache transient id.
         *
         * @var string
         */
        const CACHE_TRANSIENT_KEY = 'wpseo-statistics-totals';
        /**
         * Class that generates interesting statistics about things.
         *
         * @var WPSEO_Statistics
         */
        protected $statistics;
        /**
         * Statistics labels.
         *
         * @var string[]
         */
        protected $labels;
        /**
         * WPSEO_Statistics_Service contructor.
         *
         * @param WPSEO_Statistics $statistics The statistics class to retrieve statistics from.
         */
        public function __construct(\WPSEO_Statistics $statistics)
        {
        }
        /**
         * Fetches statistics by REST request.
         *
         * @return WP_REST_Response The response object.
         */
        public function get_statistics()
        {
        }
        /**
         * Gets a header summarizing the given statistics results.
         *
         * @param array $statistics The statistics results.
         *
         * @return string The header summing up the statistics results.
         */
        private function get_header_from_statistics(array $statistics)
        {
        }
        /**
         * An array representing items to be added to the At a Glance dashboard widget.
         *
         * @return array The statistics for the current user.
         */
        private function statistic_items()
        {
        }
        /**
         * Gets the statistics transient value. Returns array if transient wasn't set.
         *
         * @return array|mixed Returns the transient or an empty array if the transient doesn't exist.
         */
        private function get_transient()
        {
        }
        /**
         * Set the statistics transient cache for a specific user.
         *
         * @param array $transient The current stored transient with the cached data.
         * @param int   $user      The user's ID to assign the retrieved values to.
         *
         * @return array The statistics transient for the user.
         */
        private function set_statistic_items_for_user($transient, $user)
        {
        }
        /**
         * Gets the division of SEO scores.
         *
         * @param array $scores The SEO scores.
         *
         * @return array|bool The division of SEO scores, false if there are no posts.
         */
        private function get_seo_score_division(array $scores)
        {
        }
        /**
         * Get all SEO ranks and data associated with them.
         *
         * @return array An array of SEO scores and associated data.
         */
        private function get_seo_scores_with_post_count()
        {
        }
        /**
         * Converts a rank to data usable in the dashboard widget.
         *
         * @param WPSEO_Rank $rank The rank to map.
         *
         * @return array The mapped rank.
         */
        private function map_rank_to_widget(\WPSEO_Rank $rank)
        {
        }
        /**
         * Returns a dashboard widget label to use for a certain rank.
         *
         * @param WPSEO_Rank $rank The rank to return a label for.
         *
         * @return string The label for the rank.
         */
        private function get_label_for_rank(\WPSEO_Rank $rank)
        {
        }
        /**
         * Determines the labels for the various scoring ranks that are known within Yoast SEO.
         *
         * @return array Array containing the translatable labels.
         */
        private function labels()
        {
        }
        /**
         * Filter items if they have a count of zero.
         *
         * @param array $item The item to potentially filter out.
         *
         * @return bool Whether or not the count is zero.
         */
        private function filter_items($item)
        {
        }
        /**
         * Returns a link for the overview of posts of a certain rank.
         *
         * @param WPSEO_Rank $rank The rank to return a link for.
         *
         * @return string The link that shows an overview of posts with that rank.
         */
        private function get_link_for_rank(\WPSEO_Rank $rank)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class adds columns to the taxonomy table.
     */
    class WPSEO_Taxonomy_Columns
    {
        /**
         * The SEO analysis.
         *
         * @var WPSEO_Metabox_Analysis_SEO
         */
        private $analysis_seo;
        /**
         * The readability analysis.
         *
         * @var WPSEO_Metabox_Analysis_Readability
         */
        private $analysis_readability;
        /**
         * The current taxonomy.
         *
         * @var string
         */
        private $taxonomy;
        /**
         * WPSEO_Taxonomy_Columns constructor.
         */
        public function __construct()
        {
        }
        /**
         * Adds an SEO score column to the terms table, right after the description column.
         *
         * @param array $columns Current set columns.
         *
         * @return array
         */
        public function add_columns(array $columns)
        {
        }
        /**
         * Parses the column.
         *
         * @param string $content     The current content of the column.
         * @param string $column_name The name of the column.
         * @param int    $term_id     ID of requested taxonomy.
         *
         * @return string
         */
        public function parse_column($content, $column_name, $term_id)
        {
        }
        /**
         * Retrieves the taxonomy from the $_GET variable.
         *
         * @return string The current taxonomy.
         */
        public function get_current_taxonomy()
        {
        }
        /**
         * Returns the posted/get taxonomy value if it is set.
         *
         * @return string|null
         */
        private function get_taxonomy()
        {
        }
        /**
         * Parses the value for the score column.
         *
         * @param int $term_id ID of requested term.
         *
         * @return string
         */
        private function get_score_value($term_id)
        {
        }
        /**
         * Parses the value for the readability score column.
         *
         * @param int $term_id ID of the requested term.
         *
         * @return string The HTML for the readability score indicator.
         */
        private function get_score_readability_value($term_id)
        {
        }
        /**
         * Creates an icon by the given values.
         *
         * @param WPSEO_Rank $rank  The ranking object.
         * @param string     $title Optional. The title to show. Defaults to the rank label.
         *
         * @return string The HTML for a score icon.
         */
        private function create_score_icon(\WPSEO_Rank $rank, $title = '')
        {
        }
        /**
         * Check if the taxonomy is indexable.
         *
         * @param mixed $term The current term.
         *
         * @return bool Whether or not the term is indexable.
         */
        private function is_indexable($term)
        {
        }
        /**
         * Returns the focus keyword if this is set, otherwise it will give the term name.
         *
         * @param stdClass|WP_Term $term The current term.
         *
         * @return string
         */
        private function get_focus_keyword($term)
        {
        }
        /**
         * Checks if a taxonomy is being added via a POST method. If not, it defaults to a GET request.
         *
         * @return int
         */
        private function get_taxonomy_input_type()
        {
        }
        /**
         * Wraps the WPSEO_Metabox check to determine whether the metabox should be displayed either by
         * choice of the admin or because the taxonomy is not public.
         *
         * @since 7.0
         *
         * @param string|null $taxonomy Optional. The taxonomy to test, defaults to the current taxonomy.
         *
         * @return bool Whether or not the meta box (and associated columns etc) should be hidden.
         */
        private function display_metabox($taxonomy = \null)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_Taxonomy_Presenter.
     */
    class WPSEO_Taxonomy_Fields_Presenter
    {
        /**
         * The taxonomy meta data for the current term.
         *
         * @var array
         */
        private $tax_meta;
        /**
         * Constructs the WPSEO_Taxonomy_Fields_Presenter class.
         *
         * @param stdClass $term The current term.
         */
        public function __construct($term)
        {
        }
        /**
         * Displaying the form fields.
         *
         * @param array $fields Array with the fields that will be displayed.
         *
         * @return string
         */
        public function html(array $fields)
        {
        }
        /**
         * Create a row in the form table.
         *
         * @param string $field_name          Variable the row controls.
         * @param array  $field_configuration Array with the field configuration.
         *
         * @return string
         */
        private function form_row($field_name, array $field_configuration)
        {
        }
        /**
         * Generates the html for the given field config.
         *
         * @param string $field_type  The fieldtype, e.g: text, checkbox, etc.
         * @param string $field_name  The name of the field.
         * @param string $field_value The value of the field.
         * @param array  $options     Array with additional options.
         *
         * @return string
         */
        private function get_field($field_type, $field_name, $field_value, array $options)
        {
        }
        /**
         * Getting the value for given field_name.
         *
         * @param string $field_name The fieldname to get the value for.
         *
         * @return string
         */
        private function get_field_value($field_name)
        {
        }
        /**
         * Getting the class attributes if $options contains a class key.
         *
         * @param array $options The array with field options.
         *
         * @return string
         */
        private function get_class(array $options)
        {
        }
        /**
         * Getting the label HTML.
         *
         * @param string $label      The label value.
         * @param string $field_name The target field.
         *
         * @return string
         */
        private function get_label($label, $field_name)
        {
        }
        /**
         * Returns the HTML for the row which contains label, help and the field.
         *
         * @param string                 $label The html for the label if there was a label set.
         * @param WPSEO_Admin_Help_Panel $help  The help panel to render in this row.
         * @param string                 $field The html for the field.
         *
         * @return string
         */
        private function parse_row($label, \WPSEO_Admin_Help_Panel $help, $field)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class WPSEO_Taxonomy_Tab.
     *
     * Contains the basics for each class extending this one.
     */
    class WPSEO_Taxonomy_Fields
    {
        /**
         * Returns the taxonomy fields.
         *
         * @param string $field_group The field group.
         *
         * @return array
         */
        public function get($field_group)
        {
        }
        /**
         * Returns array with the fields for the general tab.
         *
         * @return array
         */
        protected function get_content_fields()
        {
        }
        /**
         * Returns array with the fields for the settings tab.
         *
         * @return array
         */
        protected function get_settings_fields()
        {
        }
        /**
         * Returning the fields for the social media tab.
         *
         * @return array
         */
        protected function get_social_fields()
        {
        }
        /**
         * Filter the hidden fields.
         *
         * @param array $fields Array with the form fields that has will be filtered.
         *
         * @return array
         */
        protected function filter_hidden_fields(array $fields)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * This class generates the metabox on the edit term page.
     */
    class WPSEO_Taxonomy_Metabox
    {
        /**
         * The term currently being edited.
         *
         * @var WP_Term
         */
        private $term;
        /**
         * The term's taxonomy.
         *
         * @var string
         */
        private $taxonomy;
        /**
         * Whether or not the social tab is enabled for this metabox.
         *
         * @var bool
         */
        private $is_social_enabled;
        /**
         * Helper to determine whether or not the SEO analysis is enabled.
         *
         * @var WPSEO_Metabox_Analysis_SEO
         */
        protected $seo_analysis;
        /**
         * Helper to determine whether or not the readability analysis is enabled.
         *
         * @var WPSEO_Metabox_Analysis_Readability
         */
        protected $readability_analysis;
        /**
         * The constructor.
         *
         * @param string   $taxonomy The taxonomy.
         * @param stdClass $term     The term.
         */
        public function __construct($taxonomy, $term)
        {
        }
        /**
         * Shows the Yoast SEO metabox for the term.
         */
        public function display()
        {
        }
        /**
         * Renders the metabox hidden fields.
         *
         * @return void
         */
        protected function render_hidden_fields()
        {
        }
        /**
         * Renders the metabox tabs.
         *
         * @return void
         */
        protected function render_tabs()
        {
        }
        /**
         * Returns the relevant metabox sections for the current view.
         *
         * @return WPSEO_Metabox_Section[]
         */
        private function get_tabs()
        {
        }
        /**
         * Retrieves the product title.
         *
         * @return string The product title.
         */
        protected function get_product_title()
        {
        }
    }
    /**
     * Class that handles the edit boxes on taxonomy edit pages.
     */
    class WPSEO_Taxonomy
    {
        /**
         * The current active taxonomy.
         *
         * @var string
         */
        private $taxonomy = '';
        /**
         * Holds the metabox SEO analysis instance.
         *
         * @var WPSEO_Metabox_Analysis_SEO
         */
        private $analysis_seo;
        /**
         * Holds the metabox readability analysis instance.
         *
         * @var WPSEO_Metabox_Analysis_Readability
         */
        private $analysis_readability;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Add hooks late enough for taxonomy object to be available for checks.
         */
        public function admin_init()
        {
        }
        /**
         * Show the SEO inputs for term.
         *
         * @param stdClass|WP_Term $term Term to show the edit boxes for.
         */
        public function term_metabox($term)
        {
        }
        /**
         * Renders the content for the internet explorer metabox.
         *
         * @return void
         */
        private function show_internet_explorer_notice()
        {
        }
        /**
         * Queue assets for taxonomy screens.
         *
         * @since 1.5.0
         */
        public function admin_enqueue_scripts()
        {
        }
        /**
         * Update the taxonomy meta data on save.
         *
         * @param int    $term_id  ID of the term to save data for.
         * @param int    $tt_id    The taxonomy_term_id for the term.
         * @param string $taxonomy The taxonomy the term belongs to.
         */
        public function update_term($term_id, $tt_id, $taxonomy)
        {
        }
        /**
         * Determines if the given meta value key is disabled.
         *
         * @param string $key The key of the meta value.
         * @return bool Whether the given meta value key is disabled.
         */
        public function is_meta_value_disabled($key)
        {
        }
        /**
         * Allows post-kses-filtered HTML in term descriptions.
         */
        public function custom_category_descriptions_allow_html()
        {
        }
        /**
         * Output the WordPress editor.
         */
        public function custom_category_description_editor()
        {
        }
        /**
         * Pass variables to js for use with the term-scraper.
         *
         * @return array
         */
        public function localize_term_scraper_script()
        {
        }
        /**
         * Pass some variables to js for replacing variables.
         *
         * @return array
         */
        public function localize_replace_vars_script()
        {
        }
        /**
         * Determines the scope based on the current taxonomy.
         * This can be used by the replacevar plugin to determine if a replacement needs to be executed.
         *
         * @return string String decribing the current scope.
         */
        private function determine_scope()
        {
        }
        /**
         * Determines if a given page is the term overview page.
         *
         * @param string $page The string to check for the term overview page.
         *
         * @return bool
         */
        public static function is_term_overview($page)
        {
        }
        /**
         * Determines if a given page is the term edit page.
         *
         * @param string $page The string to check for the term edit page.
         *
         * @return bool
         */
        public static function is_term_edit($page)
        {
        }
        /**
         * Function to get the labels for the current taxonomy.
         *
         * @return object Labels for the current taxonomy.
         */
        public static function get_labels()
        {
        }
        /**
         * Retrieves a template.
         * Check if metabox for current taxonomy should be displayed.
         *
         * @return bool
         */
        private function show_metabox()
        {
        }
        /**
         * Getting the taxonomy from the URL.
         *
         * @return string
         */
        private function get_taxonomy()
        {
        }
        /**
         * Prepares the replace vars for localization.
         *
         * @return array The replacement variables.
         */
        private function get_replace_vars()
        {
        }
        /**
         * Prepares the recommended replace vars for localization.
         *
         * @return array The recommended replacement variables.
         */
        private function get_recommended_replace_vars()
        {
        }
        /**
         * Adds custom category description editor.
         * Needs a hook that runs before the description field. Prior to WP version 4.5 we need to use edit_form as
         * term_edit_form_top was introduced in WP 4.5. This can be removed after <4.5 is no longer supported.
         *
         * @return void
         */
        private function insert_description_field_editor()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * Represents the default data.
     */
    class WPSEO_Tracking_Default_Data implements \WPSEO_Collection
    {
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get()
        {
        }
        /**
         * Returns the WordPress version.
         *
         * @return string The version.
         */
        protected function get_wordpress_version()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * Represents the plugin data.
     */
    class WPSEO_Tracking_Plugin_Data implements \WPSEO_Collection
    {
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get()
        {
        }
        /**
         * Returns all plugins.
         *
         * @return array The formatted plugins.
         */
        protected function get_plugin_data()
        {
        }
        /**
         * Formats the plugin array.
         *
         * @param array $plugin The plugin details.
         *
         * @return array The formatted array.
         */
        protected function format_plugin(array $plugin)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * Represents the server data.
     */
    class WPSEO_Tracking_Server_Data implements \WPSEO_Collection
    {
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get()
        {
        }
        /**
         * Returns the values with server details.
         *
         * @return array Array with the value.
         */
        protected function get_server_data()
        {
        }
        /**
         * Returns details about the curl version.
         *
         * @return array|null The curl info. Or null when curl isn't available..
         */
        protected function get_curl_info()
        {
        }
        /**
         * Returns a list with php extensions.
         *
         * @return array Returns the state of the php extensions.
         */
        protected function get_php_extensions()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * Collects anonymized settings data.
     */
    class WPSEO_Tracking_Settings_Data implements \WPSEO_Collection
    {
        /**
         * The options that need to be anonymized before they can be sent elsewhere.
         *
         * @var array All of the option_names which need to be
         * anonymized before they can be sent elsewhere.
         */
        private $anonymous_settings = ['baiduverify', 'googleverify', 'msverify', 'yandexverify', 'myyoast-oauth', 'website_name', 'alternate_website_name', 'company_logo', 'company_name', 'person_name', 'person_logo', 'person_logo_id', 'company_logo_id', 'facebook_site', 'instagram_url', 'linkedin_url', 'myspace_url', 'og_default_image', 'og_default_image_id', 'og_frontpage_title', 'og_frontpage_desc', 'og_frontpage_image', 'og_frontpage_image_id', 'open_graph_frontpage_title', 'open_graph_frontpage_desc', 'open_graph_frontpage_image', 'open_graph_frontpage_image_id', 'pinterest_url', 'pinterestverify', 'twitter_site', 'youtube_url', 'wikipedia_url', 'semrush_tokens', 'zapier_api_key'];
        /**
         * The options we want to track.
         *
         * @var array The option_names for the options we want to track.
         */
        private $include_list = ['ms_defaults_set', 'version', 'disableadvanced_meta', 'ryte_indexability', 'baiduverify', 'googleverify', 'msverify', 'yandexverify', 'site_type', 'has_multiple_authors', 'environment_type', 'content_analysis_active', 'keyword_analysis_active', 'enable_admin_bar_menu', 'enable_cornerstone_content', 'enable_xml_sitemap', 'enable_text_link_counter', 'show_onboarding_notice', 'first_activated_on', 'myyoast-oauth', 'dynamic_permalinks', 'website_name', 'alternate_website_name', 'company_logo', 'company_name', 'company_or_person', 'person_name', 'forcerewritetitle', 'separator', 'title-home-wpseo', 'title-author-wpseo', 'title-archive-wpseo', 'title-search-wpseo', 'title-404-wpseo', 'metadesc-home-wpseo', 'metadesc-author-wpseo', 'metadesc-archive-wpseo', 'rssbefore', 'rssafter', 'noindex-author-wpseo', 'noindex-author-noposts-wpseo', 'noindex-archive-wpseo', 'disable-author', 'disable-date', 'disable-post_format', 'disable-attachment', 'breadcrumbs-404crumb', 'breadcrumbs-display-blog-page', 'breadcrumbs-boldlast', 'breadcrumbs-archiveprefix', 'breadcrumbs-enable', 'breadcrumbs-home', 'breadcrumbs-prefix', 'breadcrumbs-searchprefix', 'breadcrumbs-sep', 'person_logo', 'person_logo_id', 'company_logo_id', 'company_or_person_user_id', 'stripcategorybase', 'noindex-post', 'display-metabox-pt-post', 'noindex-page', 'display-metabox-pt-page', 'noindex-attachment', 'display-metabox-pt-attachment', 'display-metabox-tax-category', 'noindex-tax-category', 'display-metabox-tax-post_tag', 'noindex-tax-post_tag', 'display-metabox-tax-post_format', 'noindex-tax-post_format', 'taxonomy-category-ptparent', 'taxonomy-post_tag-ptparent', 'taxonomy-post_format-ptparent', 'breadcrumbs-blog-remove', 'hideeditbox-post', 'hideeditbox-page', 'hideeditbox-attachment', 'hideeditbox-tax-category', 'hideeditbox-tax-post_tag', 'hideeditbox-tax-post_format', 'facebook_site', 'instagram_url', 'linkedin_url', 'myspace_url', 'og_default_image', 'og_default_image_id', 'og_frontpage_title', 'og_frontpage_desc', 'og_frontpage_image', 'og_frontpage_image_id', 'open_graph_frontpage_title', 'open_graph_frontpage_desc', 'open_graph_frontpage_image', 'open_graph_frontpage_image_id', 'opengraph', 'pinterest_url', 'pinterestverify', 'twitter', 'twitter_site', 'twitter_card_type', 'youtube_url', 'wikipedia_url', 'indexables_indexing_completed', 'semrush_integration_active', 'semrush_tokens', 'semrush_country_code', 'enable_enhanced_slack_sharing', 'zapier_integration_active', 'zapier_api_key', 'enable_metabox_insights', 'enable_link_suggestions', 'workouts'];
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get()
        {
        }
        /**
         * Anonimizes the WPSEO_Options array by replacing all $anonymous_settings values to 'used'.
         *
         * @param array $settings The settings.
         *
         * @return array The anonymized settings.
         */
        private function anonymize_settings($settings)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * Represents the theme data.
     */
    class WPSEO_Tracking_Theme_Data implements \WPSEO_Collection
    {
        /**
         * Returns the collection data.
         *
         * @return array The collection data.
         */
        public function get()
        {
        }
        /**
         * Returns the name of the parent theme.
         *
         * @param WP_Theme $theme The theme object.
         *
         * @return string|null The name of the parent theme or null.
         */
        private function get_parent_theme(\WP_Theme $theme)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Tracking
     */
    /**
     * This class handles the tracking routine.
     */
    class WPSEO_Tracking implements \WPSEO_WordPress_Integration
    {
        /**
         * The tracking option name.
         *
         * @var string
         */
        protected $option_name = 'wpseo_tracking_last_request';
        /**
         * The limit for the option.
         *
         * @var int
         */
        protected $threshold = 0;
        /**
         * The endpoint to send the data to.
         *
         * @var string
         */
        protected $endpoint = '';
        /**
         * The current time.
         *
         * @var int
         */
        private $current_time;
        /**
         * WPSEO_Tracking constructor.
         *
         * @param string $endpoint  The endpoint to send the data to.
         * @param int    $threshold The limit for the option.
         */
        public function __construct($endpoint, $threshold)
        {
        }
        /**
         * Registers all hooks to WordPress.
         */
        public function register_hooks()
        {
        }
        /**
         * Schedules a new sending of the tracking data after a WordPress core update.
         *
         * @param bool|WP_Upgrader $upgrader Optional. WP_Upgrader instance or false.
         *                                   Depending on context, it might be a Theme_Upgrader,
         *                                   Plugin_Upgrader, Core_Upgrade, or Language_Pack_Upgrader.
         *                                   instance. Default false.
         * @param array            $data     Array of update data.
         *
         * @return void
         */
        public function schedule_tracking_data_sending($upgrader = \false, $data = [])
        {
        }
        /**
         * Sends the tracking data.
         *
         * @param bool $force Whether to send the tracking data ignoring the two
         *                    weeks time treshhold. Default false.
         */
        public function send($force = \false)
        {
        }
        /**
         * Determines whether to send the tracking data.
         *
         * Returns false if tracking is disabled or the current page is one of the
         * admin plugins pages. Returns true when there's no tracking data stored or
         * the data was sent more than two weeks ago. The two weeks interval is set
         * when instantiating the class.
         *
         * @param bool $ignore_time_treshhold Whether to send the tracking data ignoring
         *                                    the two weeks time treshhold. Default false.
         *
         * @return bool True when tracking data should be sent.
         */
        protected function should_send_tracking($ignore_time_treshhold = \false)
        {
        }
        /**
         * Checks if the given amount of seconds exceeds the set threshold.
         *
         * @param int $seconds The amount of seconds to check.
         *
         * @return bool True when seconds is bigger than threshold.
         */
        protected function exceeds_treshhold($seconds)
        {
        }
        /**
         * Returns the collector for collecting the data.
         *
         * @return WPSEO_Collector The instance of the collector.
         */
        public function get_collector()
        {
        }
        /**
         * See if we should run tracking at all.
         *
         * @return bool True when we can track, false when we can't.
         */
        private function tracking_enabled()
        {
        }
    }
    /**
     * Class Yoast_View_Utils.
     */
    class Yoast_View_Utils
    {
        /**
         * Form to use.
         *
         * @var Yoast_Form
         */
        protected $form;
        /**
         * Yoast_View_Utils constructor.
         */
        public function __construct()
        {
        }
        /**
         * Shows the search results help question mark and help section.
         *
         * Used for all the Help sections for indexable objects like post types, taxonomies, or archives.
         *
         * @param string|object $post_type        The post type to show the search results help for.
         * @param string        $help_text_switch Switch the help text to one that's more appropriate
         *                                        for the indexable object type the help section is for.
         *
         * @return object The help panel instance.
         */
        public function search_results_setting_help($post_type, $help_text_switch = '')
        {
        }
        /**
         * Generates the OpenGraph disabled alert, depending on whether the OpenGraph feature is disabled.
         *
         * @param string $type The type of message. Can be altered to homepage, taxonomies or archives. Empty string by default.
         *
         * @return string The alert. Returns an empty string if the setting is enabled.
         */
        public function generate_opengraph_disabled_alert($type = '')
        {
        }
        /**
         * Generates the OpenGraph disabled alert text.
         *
         * @param string $type The type of message. Can be altered to homepage, taxonomies or archives. Empty string by default.
         *
         * @return string The alert. Returns an empty string if the setting is enabled.
         */
        private function generate_opengraph_disabled_alert_text($type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class representing a feature toggle.
     */
    class Yoast_Feature_Toggle
    {
        /**
         * Feature toggle identifier.
         *
         * @var string
         */
        protected $name = '';
        /**
         * Name of the setting the feature toggle is associated with.
         *
         * @var string
         */
        protected $setting = '';
        /**
         * Whether the feature is premium or not.
         *
         * @var boolean
         */
        protected $premium = \false;
        /**
         * Feature toggle label.
         *
         * @var string
         */
        protected $label = '';
        /**
         * URL to learn more about the feature.
         *
         * @var string
         */
        protected $read_more_url = '';
        /**
         * URL to learn more about the premium feature.
         *
         * @var string
         */
        protected $premium_url = '';
        /**
         * Label for the learn more link.
         *
         * @var string
         */
        protected $read_more_label = '';
        /**
         * Additional help content for the feature.
         *
         * @var string
         */
        protected $extra = '';
        /**
         * Additional content to be rendered after the toggle.
         *
         * @var string
         */
        protected $after = '';
        /**
         * Value to specify the feature toggle order.
         *
         * @var string
         */
        protected $order = 100;
        /**
         * Constructor.
         *
         * Sets the feature toggle arguments.
         *
         * @param array $args {
         *     Feature toggle arguments.
         *
         *     @type string $name            Required. Feature toggle identifier.
         *     @type string $setting         Required. Name of the setting the feature toggle is associated with.
         *     @type string $label           Feature toggle label.
         *     @type string $read_more_url   URL to learn more about the feature. Default empty string.
         *     @type string $read_more_label Label for the learn more link. Default empty string.
         *     @type string $extra           Additional help content for the feature. Default empty string.
         *     @type int    $order           Value to specify the feature toggle order. A lower value indicates
         *                                   a higher priority. Default 100.
         * }
         *
         * @throws InvalidArgumentException Thrown when a required argument is missing.
         */
        public function __construct(array $args)
        {
        }
        /**
         * Magic isset-er.
         *
         * @param string $key Key to check whether a value for it is set.
         *
         * @return bool True if set, false otherwise.
         */
        public function __isset($key)
        {
        }
        /**
         * Magic getter.
         *
         * @param string $key Key to get the value for.
         *
         * @return mixed Value for the key, or null if not set.
         */
        public function __get($key)
        {
        }
        /**
         * Checks whether the feature for this toggle is enabled.
         *
         * @return bool True if the feature is enabled, false otherwise.
         */
        public function is_enabled()
        {
        }
    }
    /**
     * Class for managing feature toggles.
     */
    class Yoast_Feature_Toggles
    {
        /**
         * Available feature toggles.
         *
         * @var array
         */
        protected $toggles;
        /**
         * Instance holder.
         *
         * @var self|null
         */
        protected static $instance = \null;
        /**
         * Gets the main feature toggles manager instance used.
         *
         * This essentially works like a Singleton, but for its drawbacks does not restrict
         * instantiation otherwise.
         *
         * @return self Main instance.
         */
        public static function instance()
        {
        }
        /**
         * Gets all available feature toggles.
         *
         * @return array List of sorted Yoast_Feature_Toggle instances.
         */
        public function get_all()
        {
        }
        /**
         * Loads the available feature toggles.
         *
         * Also ensures that the toggles are all Yoast_Feature_Toggle instances and sorted by their order value.
         *
         * @return array List of sorted Yoast_Feature_Toggle instances.
         */
        protected function load_toggles()
        {
        }
        /**
         * Returns html for a warning that core sitemaps are enabled when yoast seo sitemaps are disabled.
         *
         * @return string HTML string for the warning.
         */
        protected function sitemaps_toggle_after()
        {
        }
        /**
         * Ensures that the passed value is a Yoast_Feature_Toggle.
         *
         * @param Yoast_Feature_Toggle|object|array $toggle_data Feature toggle instance, or raw object or array
         *                                                       containing feature toggle data.
         * @return Yoast_Feature_Toggle Feature toggle instance based on $toggle_data.
         */
        protected function ensure_toggle($toggle_data)
        {
        }
        /**
         * Callback for sorting feature toggles by their order.
         *
         * {@internal Once the minimum PHP version goes up to PHP 7.0, the logic in the function
         * can be replaced with the spaceship operator `<=>`.}
         *
         * @param Yoast_Feature_Toggle $feature_a Feature A.
         * @param Yoast_Feature_Toggle $feature_b Feature B.
         *
         * @return int An integer less than, equal to, or greater than zero indicating respectively
         *             that feature A is considered to be less than, equal to, or greater than feature B.
         */
        protected function sort_toggles_callback(\Yoast_Feature_Toggle $feature_a, \Yoast_Feature_Toggle $feature_b)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class for generating a html select.
     */
    class Yoast_Input_Select
    {
        /**
         * The id attribute value.
         *
         * @var string
         */
        private $select_id;
        /**
         * The name attribute value.
         *
         * @var string
         */
        private $select_name;
        /**
         * Additional select attributes.
         *
         * @var array
         */
        private $select_attributes = [];
        /**
         * Array with the options to parse.
         *
         * @var array
         */
        private $select_options;
        /**
         * The current selected option.
         *
         * @var string
         */
        private $selected_option;
        /**
         * Constructor.
         *
         * @param string $select_id       ID for the select.
         * @param string $select_name     Name for the select.
         * @param array  $select_options  Array with the options to parse.
         * @param string $selected_option The current selected option.
         */
        public function __construct($select_id, $select_name, array $select_options, $selected_option)
        {
        }
        /**
         * Print the rendered view.
         */
        public function output_html()
        {
        }
        /**
         * Return the rendered view.
         *
         * @return string
         */
        public function get_html()
        {
        }
        /**
         * Add an attribute to the attributes property.
         *
         * @param string $attribute The name of the attribute to add.
         * @param string $value     The value of the attribute.
         */
        public function add_attribute($attribute, $value)
        {
        }
        /**
         * Return the set fields for the select.
         *
         * @return array
         */
        private function get_select_values()
        {
        }
        /**
         * Return the attribute string, when there are attributes set.
         *
         * @return string
         */
        private function get_attributes()
        {
        }
        /**
         * Get an attribute from the attributes.
         *
         * @param string $value     The value of the attribute.
         * @param string $attribute The attribute to look for.
         */
        private function parse_attribute(&$value, $attribute)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Class for managing integration toggles.
     */
    class Yoast_Integration_Toggles
    {
        /**
         * Available integration toggles.
         *
         * @var array
         */
        protected $toggles;
        /**
         * Instance holder.
         *
         * @var self|null
         */
        protected static $instance = \null;
        /**
         * Gets the main integration toggles manager instance used.
         *
         * This essentially works like a Singleton, but for its drawbacks does not restrict
         * instantiation otherwise.
         *
         * @return self Main instance.
         */
        public static function instance()
        {
        }
        /**
         * Gets all available integration toggles.
         *
         * @return array List of sorted Yoast_Feature_Toggle instances.
         */
        public function get_all()
        {
        }
        /**
         * Loads the available integration toggles.
         *
         * Also ensures that the toggles are all Yoast_Feature_Toggle instances and sorted by their order value.
         *
         * @return array List of sorted Yoast_Feature_Toggle instances.
         */
        protected function load_toggles()
        {
        }
        /**
         * Ensures that the passed value is a Yoast_Feature_Toggle.
         *
         * @param Yoast_Feature_Toggle|object|array $toggle_data Feature toggle instance, or raw object or array
         *                                                       containing integration toggle data.
         * @return Yoast_Feature_Toggle Feature toggle instance based on $toggle_data.
         */
        protected function ensure_toggle($toggle_data)
        {
        }
        /**
         * Callback for sorting integration toggles by their order.
         *
         * {@internal Once the minimum PHP version goes up to PHP 7.0, the logic in the function
         * can be replaced with the spaceship operator `<=>`.}
         *
         * @param Yoast_Feature_Toggle $feature_a Feature A.
         * @param Yoast_Feature_Toggle $feature_b Feature B.
         *
         * @return int An integer less than, equal to, or greater than zero indicating respectively
         *             that feature A is considered to be less than, equal to, or greater than feature B.
         */
        protected function sort_toggles_callback(\Yoast_Feature_Toggle $feature_a, \Yoast_Feature_Toggle $feature_b)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin
     */
    /**
     * Generate the HTML for a form element.
     */
    interface Yoast_Form_Element
    {
        /**
         * Return the HTML for the form element.
         *
         * @return string
         */
        public function get_html();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\Watchers
     */
    /**
     * Class WPSEO_Slug_Change_Watcher.
     */
    class WPSEO_Slug_Change_Watcher implements \WPSEO_WordPress_Integration
    {
        /**
         * Registers all hooks to WordPress.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Enqueues the quick edit handler.
         *
         * @return void
         */
        public function enqueue_assets()
        {
        }
        /**
         * Shows an message when a post is about to get trashed.
         *
         * @param int $post_id The current post ID.
         *
         * @return void
         */
        public function detect_post_trash($post_id)
        {
        }
        /**
         * Shows an message when a post is about to get trashed.
         *
         * @param int $post_id The current post ID.
         *
         * @return void
         */
        public function detect_post_delete($post_id)
        {
        }
        /**
         * Shows a message when a term is about to get deleted.
         *
         * @param int $term_id The term ID that will be deleted.
         *
         * @return void
         */
        public function detect_term_delete($term_id)
        {
        }
        /**
         * Checks if the post is viewable.
         *
         * @param string $post_id The post id to check.
         *
         * @return bool Whether the post is viewable or not.
         */
        protected function is_post_viewable($post_id)
        {
        }
        /**
         * Checks if the term is viewable.
         *
         * @param string $term_id The term ID to check.
         *
         * @return bool Whether the term is viewable or not.
         */
        protected function is_term_viewable($term_id)
        {
        }
        /**
         * Gets the taxonomy label to use for a term.
         *
         * @param int $term_id The term ID.
         *
         * @return string The taxonomy's singular label.
         */
        protected function get_taxonomy_label_for_term($term_id)
        {
        }
        /**
         * Retrieves the singular post type label.
         *
         * @param string $post_type Post type to retrieve label from.
         *
         * @return string The singular post type name.
         */
        protected function get_post_type_label($post_type)
        {
        }
        /**
         * Checks whether the given post status is visible or not.
         *
         * @param string $post_status The post status to check.
         *
         * @return bool Whether or not the post is visible.
         */
        protected function check_visible_post_status($post_status)
        {
        }
        /**
         * Returns the message around changed URLs.
         *
         * @param string $first_sentence The first sentence of the notification.
         *
         * @return string The full notification.
         */
        protected function get_message($first_sentence)
        {
        }
        /**
         * Adds a notification to be shown on the next page request since posts are updated in an ajax request.
         *
         * @param string $message The message to add to the notification.
         *
         * @return void
         */
        protected function add_notification($message)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Inc
     */
    /**
     * Represents the addon manager.
     */
    class WPSEO_Addon_Manager
    {
        /**
         * Holds the name of the transient.
         *
         * @var string
         */
        const SITE_INFORMATION_TRANSIENT = 'wpseo_site_information';
        /**
         * Holds the name of the transient.
         *
         * @var string
         */
        const SITE_INFORMATION_TRANSIENT_QUICK = 'wpseo_site_information_quick';
        /**
         * Holds the slug for YoastSEO free.
         *
         * @var string
         */
        const FREE_SLUG = 'yoast-seo-wordpress';
        /**
         * Holds the slug for YoastSEO Premium.
         *
         * @var string
         */
        const PREMIUM_SLUG = 'yoast-seo-wordpress-premium';
        /**
         * Holds the slug for Yoast News.
         *
         * @var string
         */
        const NEWS_SLUG = 'yoast-seo-news';
        /**
         * Holds the slug for Video.
         *
         * @var string
         */
        const VIDEO_SLUG = 'yoast-seo-video';
        /**
         * Holds the slug for WooCommerce.
         *
         * @var string
         */
        const WOOCOMMERCE_SLUG = 'yoast-seo-woocommerce';
        /**
         * Holds the slug for Local.
         *
         * @var string
         */
        const LOCAL_SLUG = 'yoast-seo-local';
        /**
         * The expected addon data.
         *
         * @var array
         */
        protected static $addons = ['wp-seo-premium.php' => self::PREMIUM_SLUG, 'wpseo-news.php' => self::NEWS_SLUG, 'video-seo.php' => self::VIDEO_SLUG, 'wpseo-woocommerce.php' => self::WOOCOMMERCE_SLUG, 'local-seo.php' => self::LOCAL_SLUG];
        /**
         * Holds the site information data.
         *
         * @var stdClass
         */
        private $site_information;
        /**
         * Hooks into WordPress.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Gets the subscriptions for current site.
         *
         * @return stdClass The subscriptions.
         */
        public function get_subscriptions()
        {
        }
        /**
         * Provides a list of addon filenames.
         *
         * @return string[] List of addon filenames with their slugs.
         */
        public function get_addon_filenames()
        {
        }
        /**
         * Finds the plugin file.
         *
         * @param string $plugin_slug The plugin slug to search.
         *
         * @return boolean|string Plugin file when installed, False when plugin isn't installed.
         **/
        public function get_plugin_file($plugin_slug)
        {
        }
        /**
         * Retrieves the subscription for the given slug.
         *
         * @param string $slug The plugin slug to retrieve.
         *
         * @return stdClass|false Subscription data when found, false when not found.
         */
        public function get_subscription($slug)
        {
        }
        /**
         * Retrieves a list of (subscription) slugs by the active addons.
         *
         * @return array The slugs.
         */
        public function get_subscriptions_for_active_addons()
        {
        }
        /**
         * Retrieves a list of versions for each addon.
         *
         * @return array The addon versions.
         */
        public function get_installed_addons_versions()
        {
        }
        /**
         * Retrieves the plugin information from the subscriptions.
         *
         * @param stdClass|false $data   The result object. Default false.
         * @param string         $action The type of information being requested from the Plugin Installation API.
         * @param stdClass       $args   Plugin API arguments.
         *
         * @return object Extended plugin data.
         */
        public function get_plugin_information($data, $action, $args)
        {
        }
        /**
         * Retrieves information from MyYoast about which addons are connected to the current site.
         *
         * @return stdClass The list of addons activated for this site.
         */
        public function get_myyoast_site_information()
        {
        }
        /**
         * Checks if the subscription for the given slug is valid.
         *
         * @param string $slug The plugin slug to retrieve.
         *
         * @return bool True when the subscription is valid.
         */
        public function has_valid_subscription($slug)
        {
        }
        /**
         * Checks if there are addon updates.
         *
         * @param stdClass|mixed $data The current data for update_plugins.
         *
         * @return stdClass Extended data for update_plugins.
         */
        public function check_for_updates($data)
        {
        }
        /**
         * If the plugin is lacking an active subscription, throw a warning.
         *
         * @param array $plugin_data The data for the plugin in this row.
         */
        public function expired_subscription_warning($plugin_data)
        {
        }
        /**
         * Checks if there are any installed addons.
         *
         * @return bool True when there are installed Yoast addons.
         */
        public function has_installed_addons()
        {
        }
        /**
         * Checks if the plugin is installed and activated in WordPress.
         *
         * @param string $slug The class' slug.
         *
         * @return bool True when installed and activated.
         */
        public function is_installed($slug)
        {
        }
        /**
         * Validates the addons and show a notice for the ones that are invalid.
         */
        public function validate_addons()
        {
        }
        /**
         * Removes the site information transients.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        public function remove_site_information_transients()
        {
        }
        /**
         * Creates an instance of Yoast_Notification.
         *
         * @param string $product_name The product to create the notification for.
         *
         * @return Yoast_Notification The created notification.
         */
        protected function create_notification($product_name)
        {
        }
        /**
         * Checks whether a plugin expiry date has been passed.
         *
         * @param stdClass $subscription Plugin subscription.
         *
         * @return bool Has the plugin expired.
         */
        protected function has_subscription_expired($subscription)
        {
        }
        /**
         * Converts a subscription to plugin based format.
         *
         * @param stdClass $subscription The subscription to convert.
         *
         * @return stdClass The converted subscription.
         */
        protected function convert_subscription_to_plugin($subscription)
        {
        }
        /**
         * Returns the plugin's icon URL.
         *
         * @param string $slug The plugin slug.
         *
         * @return string The icon URL for this plugin.
         */
        protected function get_icon($slug)
        {
        }
        /**
         * Return an array of plugin banner URLs.
         *
         * @param string $slug The plugin slug.
         *
         * @return string[]
         */
        protected function get_banners($slug)
        {
        }
        /**
         * Checks if the given plugin_file belongs to a Yoast addon.
         *
         * @param string $plugin_file Path to the plugin.
         *
         * @return bool True when plugin file is for a Yoast addon.
         */
        protected function is_yoast_addon($plugin_file)
        {
        }
        /**
         * Retrieves the addon slug by given plugin file path.
         *
         * @param string $plugin_file The file path to the plugin.
         *
         * @return string The slug when found or empty string when not.
         */
        protected function get_slug_by_plugin_file($plugin_file)
        {
        }
        /**
         * Retrieves the installed Yoast addons.
         *
         * @return array The installed plugins.
         */
        protected function get_installed_addons()
        {
        }
        /**
         * Retrieves a list of active addons.
         *
         * @return array The active addons.
         */
        protected function get_active_addons()
        {
        }
        /**
         * Retrieves the current sites from the API.
         *
         * @codeCoverageIgnore
         *
         * @return bool|stdClass Object when request is successful. False if not.
         */
        protected function request_current_sites()
        {
        }
        /**
         * Retrieves the transient value with the site information.
         *
         * @codeCoverageIgnore
         *
         * @return stdClass|false The transient value.
         */
        protected function get_site_information_transient()
        {
        }
        /**
         * Returns the current page.
         *
         * @codeCoverageIgnore
         *
         * @return string The current page.
         */
        protected function get_current_page()
        {
        }
        /**
         * Sets the site information transient.
         *
         * @codeCoverageIgnore
         *
         * @param stdClass $site_information The site information to save.
         *
         * @return void
         */
        protected function set_site_information_transient($site_information)
        {
        }
        /**
         * Retrieves all installed WordPress plugins.
         *
         * @codeCoverageIgnore
         *
         * @return array The plugins.
         */
        protected function get_plugins()
        {
        }
        /**
         * Checks if the given plugin file belongs to an active plugin.
         *
         * @codeCoverageIgnore
         *
         * @param string $plugin_file The file path to the plugin.
         *
         * @return bool True when plugin is active.
         */
        protected function is_plugin_active($plugin_file)
        {
        }
        /**
         * Returns an object with no subscriptions.
         *
         * @codeCoverageIgnore
         *
         * @return stdClass Site information.
         */
        protected function get_site_information_default()
        {
        }
        /**
         * Maps the plugin API response.
         *
         * @param object $site_information Site information as received from the API.
         *
         * @return stdClass Mapped site information.
         */
        protected function map_site_information($site_information)
        {
        }
        /**
         * Maps a plugin subscription.
         *
         * @param object $subscription Subscription information as received from the API.
         *
         * @return stdClass Mapped subscription.
         */
        protected function map_subscription($subscription)
        {
        }
        /**
         * Retrieves the site information.
         *
         * @return stdClass The site information.
         */
        private function get_site_information()
        {
        }
        /**
         * Retrieves the contents for the support section.
         *
         * @return string The support section content.
         */
        protected function get_support_section()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Inc
     */
    /**
     * Handles requests to MyYoast.
     */
    class WPSEO_MyYoast_Api_Request
    {
        /**
         * The Request URL.
         *
         * @var string
         */
        protected $url;
        /**
         * The request parameters.
         *
         * @var array
         */
        protected $args = ['method' => 'GET', 'timeout' => 5, 'headers' => ['Accept-Encoding' => '*', 'Expect' => '']];
        /**
         * Contains the fetched response.
         *
         * @var stdClass
         */
        protected $response;
        /**
         * Contains the error message when request went wrong.
         *
         * @var string
         */
        protected $error_message = '';
        /**
         * Constructor.
         *
         * @codeCoverageIgnore
         *
         * @param string $url  The request url.
         * @param array  $args The request arguments.
         */
        public function __construct($url, array $args = [])
        {
        }
        /**
         * Fires the request.
         *
         * @return bool True when request is successful.
         */
        public function fire()
        {
        }
        /**
         * Retrieves the error message.
         *
         * @return string The set error message.
         */
        public function get_error_message()
        {
        }
        /**
         * Retrieves the response.
         *
         * @return stdClass The response object.
         */
        public function get_response()
        {
        }
        /**
         * Performs the request using WordPress internals.
         *
         * @codeCoverageIgnore
         *
         * @param string $url               The request URL.
         * @param array  $request_arguments The request arguments.
         *
         * @return string                                 The retrieved body.
         * @throws WPSEO_MyYoast_Bad_Request_Exception    When request is invalid.
         */
        protected function do_request($url, $request_arguments)
        {
        }
        /**
         * Decodes the JSON encoded response.
         *
         * @param string $response The response to decode.
         *
         * @return stdClass                             The json decoded response.
         * @throws WPSEO_MyYoast_Invalid_JSON_Exception When decoded string is not a JSON object.
         */
        protected function decode_response($response)
        {
        }
        /**
         * Checks if MyYoast tokens are allowed and adds the token to the request body.
         *
         * When tokens are disallowed it will add the url to the request body.
         *
         * @param array $request_arguments The arguments to enrich.
         *
         * @return array The enriched arguments.
         */
        protected function enrich_request_arguments(array $request_arguments)
        {
        }
        /**
         * Retrieves the request body based on URL or access token support.
         *
         * @codeCoverageIgnore
         *
         * @return array The request body.
         */
        public function get_request_body()
        {
        }
        /**
         * Wraps the get current user id function.
         *
         * @codeCoverageIgnore
         *
         * @return int The user id.
         */
        protected function get_current_user_id()
        {
        }
        /**
         * Retrieves the installed addons as http headers.
         *
         * @codeCoverageIgnore
         *
         * @return array The installed addon versions.
         */
        protected function get_installed_addon_versions()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Inc
     */
    /**
     * Represents the post type utils.
     */
    class WPSEO_Post_Type
    {
        /**
         * Returns an array with the accessible post types.
         *
         * An accessible post type is a post type that is public and isn't set as no-index (robots).
         *
         * @return array Array with all the accessible post_types.
         */
        public static function get_accessible_post_types()
        {
        }
        /**
         * Returns whether the passed post type is considered accessible.
         *
         * @param string $post_type The post type to check.
         *
         * @return bool Whether or not the post type is considered accessible.
         */
        public static function is_post_type_accessible($post_type)
        {
        }
        /**
         * Checks if the request post type is public and indexable.
         *
         * @param string $post_type_name The name of the post type to lookup.
         *
         * @return bool True when post type is set to index.
         */
        public static function is_post_type_indexable($post_type_name)
        {
        }
        /**
         * Filters the attachment post type from an array with post_types.
         *
         * @param array $post_types The array to filter the attachment post type from.
         *
         * @return array The filtered array.
         */
        public static function filter_attachment_post_type(array $post_types)
        {
        }
        /**
         * Checks if the post type is enabled in the REST API.
         *
         * @param string $post_type The post type to check.
         *
         * @return bool Whether or not the post type is available in the REST API.
         */
        public static function is_rest_enabled($post_type)
        {
        }
        /**
         * Checks if the current post type has an archive.
         *
         * Context: The has_archive value can be a string or a boolean. In most case it will be a boolean,
         * but it can be defined as a string. When it is a string the archive_slug will be overwritten to
         * define another endpoint.
         *
         * @param WP_Post_Type $post_type The post type object.
         *
         * @return bool True whether the post type has an archive.
         */
        public static function has_archive($post_type)
        {
        }
        /**
         * Checks if the Yoast Metabox has been enabled for the post type.
         *
         * @param string $post_type The post type name.
         *
         * @return bool True whether the metabox is enabled.
         */
        public static function has_metabox_enabled($post_type)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Frontend
     */
    /**
     * This code handles the category rewrites.
     */
    class WPSEO_Rewrite
    {
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Save an option that triggers a flush on the next init.
         *
         * @since 1.2.8
         */
        public function schedule_flush()
        {
        }
        /**
         * If the flush option is set, flush the rewrite rules.
         *
         * @since 1.2.8
         *
         * @return bool
         */
        public function flush()
        {
        }
        /**
         * Override the category link to remove the category base.
         *
         * @param string  $link     Term link, overridden by the function for categories.
         * @param WP_Term $term     Unused, term object.
         * @param string  $taxonomy Taxonomy slug.
         *
         * @return string
         */
        public function no_category_base($link, $term, $taxonomy)
        {
        }
        /**
         * Update the query vars with the redirect var when stripcategorybase is active.
         *
         * @param array $query_vars Main query vars to filter.
         *
         * @return array
         */
        public function query_vars($query_vars)
        {
        }
        /**
         * Checks whether the redirect needs to be created.
         *
         * @param array $query_vars Query vars to check for existence of redirect var.
         *
         * @return array|void The query vars.
         */
        public function request($query_vars)
        {
        }
        /**
         * This function taken and only slightly adapted from WP No Category Base plugin by Saurabh Gupta.
         *
         * @return array
         */
        public function category_rewrite_rules()
        {
        }
        /**
         * Adds required category rewrites rules.
         *
         * @param array  $rewrites        The current set of rules.
         * @param string $category_name   Category nicename.
         * @param string $blog_prefix     Multisite blog prefix.
         * @param string $pagination_base WP_Query pagination base.
         *
         * @return array The added set of rules.
         */
        protected function add_category_rewrites($rewrites, $category_name, $blog_prefix, $pagination_base)
        {
        }
        /**
         * Walks through category nicename and convert encoded parts
         * into uppercase using $this->encode_to_upper().
         *
         * @param string $name The encoded category URI string.
         *
         * @return string The convered URI string.
         */
        protected function convert_encoded_to_upper($name)
        {
        }
        /**
         * Converts the encoded URI string to uppercase.
         *
         * @param string $encoded The encoded string.
         *
         * @return string The uppercased string.
         */
        public function encode_to_upper($encoded)
        {
        }
        /**
         * Redirect the "old" category URL to the new one.
         *
         * @codeCoverageIgnore
         *
         * @param string $category_redirect The category page to redirect to.
         * @return void
         */
        protected function redirect($category_redirect)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internal
     */
    /**
     * This class handles storing the current options for future reference.
     *
     * This should only be used during an upgrade routine.
     */
    class WPSEO_Upgrade_History
    {
        /**
         * Option to use to store/retrieve data from.
         *
         * @var string
         */
        protected $option_name = 'wpseo_upgrade_history';
        /**
         * WPSEO_Upgrade_History constructor.
         *
         * @param string|null $option_name Optional. Custom option to use to store/retrieve history from.
         */
        public function __construct($option_name = \null)
        {
        }
        /**
         * Retrieves the content of the history items currently stored.
         *
         * @return array The contents of the history option.
         */
        public function get()
        {
        }
        /**
         * Adds a new history entry in the storage.
         *
         * @param string $old_version  The version we are upgrading from.
         * @param string $new_version  The version we are upgrading to.
         * @param array  $option_names The options that need to be stored.
         */
        public function add($old_version, $new_version, array $option_names)
        {
        }
        /**
         * Retrieves the data for the specified option names from the database.
         *
         * @param array $option_names The option names to retrieve.
         *
         * @return array
         */
        protected function get_options_data(array $option_names)
        {
        }
        /**
         * Stores the new history state.
         *
         * @param array $data The data to store.
         *
         * @return void
         */
        protected function set(array $data)
        {
        }
        /**
         * Retrieves the WPDB object.
         *
         * @return wpdb The WPDB object to use.
         */
        protected function get_wpdb()
        {
        }
        /**
         * Retrieves the option name to store the history in.
         *
         * @return string The option name to store the history in.
         */
        protected function get_option_name()
        {
        }
    }
    /**
     * This code handles the option upgrades.
     */
    class WPSEO_Upgrade
    {
        /**
         * The taxonomy helper.
         *
         * @var \Yoast\WP\SEO\Helpers\Taxonomy_Helper
         */
        private $taxonomy_helper;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Runs the upgrade routine.
         *
         * @param string $routine         The method to call.
         * @param string $version         The new version.
         * @param string $current_version The current set version.
         *
         * @return void
         */
        protected function run_upgrade_routine($routine, $version, $current_version)
        {
        }
        /**
         * Adds a new upgrade history entry.
         *
         * @param string $current_version The old version from which we are upgrading.
         * @param string $new_version     The version we are upgrading to.
         */
        protected function add_upgrade_history($current_version, $new_version)
        {
        }
        /**
         * Runs the needed cleanup after an update, setting the DB version to latest version, flushing caches etc.
         *
         * @param string|null $previous_version The previous version.
         *
         * @return void
         */
        protected function finish_up($previous_version = \null)
        {
        }
        /**
         * Run the Yoast SEO 1.5 upgrade routine.
         *
         * @param string $version Current plugin version.
         */
        private function upgrade_15($version)
        {
        }
        /**
         * Moves options that moved position in WPSEO 2.0.
         */
        private function upgrade_20()
        {
        }
        /**
         * Detects if taxonomy terms were split and updates the corresponding taxonomy meta's accordingly.
         */
        private function upgrade_21()
        {
        }
        /**
         * Performs upgrade functions to Yoast SEO 2.2.
         */
        private function upgrade_22()
        {
        }
        /**
         * Schedules upgrade function to Yoast SEO 2.3.
         */
        private function upgrade_23()
        {
        }
        /**
         * Performs upgrade query to Yoast SEO 2.3.
         */
        public function upgrade_23_query()
        {
        }
        /**
         * Performs upgrade functions to Yoast SEO 3.0.
         */
        private function upgrade_30()
        {
        }
        /**
         * Performs upgrade functions to Yoast SEO 3.3.
         */
        private function upgrade_33()
        {
        }
        /**
         * Performs upgrade functions to Yoast SEO 3.6.
         */
        private function upgrade_36()
        {
        }
        /**
         * Removes the about notice when its still in the database.
         */
        private function upgrade_40()
        {
        }
        /**
         * Moves the content-analysis-active and keyword-analysis-acive options from wpseo-titles to wpseo.
         */
        private function upgrade_44()
        {
        }
        /**
         * Renames the meta name for the cornerstone content. It was a public meta field and it has to be private.
         */
        private function upgrade_47()
        {
        }
        /**
         * Removes the 'wpseo-dismiss-about' notice for every user that still has it.
         */
        private function upgrade_49()
        {
        }
        /**
         * Removes the wpseo-dismiss-about notice from a list of notifications.
         *
         * @param Yoast_Notification[] $notifications The notifications to filter.
         *
         * @return Yoast_Notification[] The filtered list of notifications. Excluding the wpseo-dismiss-about notification.
         */
        public function remove_about_notice($notifications)
        {
        }
        /**
         * Adds the yoast_seo_links table to the database.
         */
        private function upgrade_50()
        {
        }
        /**
         * Register new capabilities and roles.
         */
        private function upgrade_55()
        {
        }
        /**
         * Removes some no longer used options for noindexing subpages and for meta keywords and its associated templates.
         *
         * @return void
         */
        private function upgrade_63()
        {
        }
        /**
         * Perform the 7.0 upgrade, moves settings around, deletes several options.
         *
         * @return void
         */
        private function upgrade_70()
        {
        }
        /**
         * Perform the 7.1 upgrade.
         *
         * @return void
         */
        private function upgrade_71()
        {
        }
        /**
         * Perform the 7.3 upgrade.
         *
         * @return void
         */
        private function upgrade_73()
        {
        }
        /**
         * Performs the 7.4 upgrade.
         *
         * @return void
         */
        private function upgrade_74()
        {
        }
        /**
         * Performs the 7.5.3 upgrade.
         *
         * When upgrading purging media is potentially relevant.
         *
         * @return void
         */
        private function upgrade_753()
        {
        }
        /**
         * Performs the 7.7 upgrade.
         *
         * @return void
         */
        private function upgrade_77()
        {
        }
        /**
         * Performs the 7.7.2 upgrade.
         *
         * @return void
         */
        private function upgrade_772()
        {
        }
        /**
         * Performs the 9.0 upgrade.
         *
         * @return void
         */
        private function upgrade_90()
        {
        }
        /**
         * Performs the 10.0 upgrade.
         *
         * @return void
         */
        private function upgrade_100()
        {
        }
        /**
         * Performs the 11.1 upgrade.
         *
         * @return void
         */
        private function upgrade_111()
        {
        }
        /**
         * Performs the 12.3 upgrade.
         *
         * Removes the about notice when its still in the database.
         */
        private function upgrade_123()
        {
        }
        /**
         * Performs the 12.4 upgrade.
         *
         * Removes the Google plus defaults from the database.
         */
        private function upgrade_124()
        {
        }
        /**
         * Performs the 12.5 upgrade.
         */
        public function upgrade_125()
        {
        }
        /**
         * Performs the 12.8 upgrade.
         */
        private function upgrade_128()
        {
        }
        /**
         * Performs the 13.2 upgrade.
         */
        private function upgrade_132()
        {
        }
        /**
         * Perform the 14.0.3 upgrade.
         */
        private function upgrade_1403()
        {
        }
        /**
         * Performs the 14.1 upgrade.
         */
        private function upgrade_141()
        {
        }
        /**
         * Performs the 14.2 upgrade.
         *
         * Removes the yoast-acf-analysis notice when it's still in the database.
         */
        private function upgrade_142()
        {
        }
        /**
         * Performs the 14.5 upgrade.
         */
        private function upgrade_145()
        {
        }
        /**
         * Performs the 14.9 upgrade.
         */
        private function upgrade_149()
        {
        }
        /**
         * Performs the 15.1 upgrade.
         *
         * @return void
         */
        private function upgrade_151()
        {
        }
        /**
         * Performs the 15.3 upgrade.
         *
         * @return void
         */
        private function upgrade_153()
        {
        }
        /**
         * Performs the 15.5 upgrade.
         *
         * @return void
         */
        private function upgrade_155()
        {
        }
        /**
         * Performs the 15.7 upgrade.
         *
         * @return void
         */
        private function upgrade_157()
        {
        }
        /**
         * Performs the 15.9.1 upgrade routine.
         */
        private function upgrade_1591()
        {
        }
        /**
         * Performs the 16.2 upgrade routine.
         */
        private function upgrade_162()
        {
        }
        /**
         * Performs the 16.5 upgrade.
         *
         * @return void
         */
        private function upgrade_165()
        {
        }
        /**
         * Performs the 17.2 upgrade. Cleans out any unnecessary indexables. See $cleanup_integration->get_cleanup_tasks() to see what will be cleaned out.
         *
         * @return void
         */
        private function upgrade_172()
        {
        }
        /**
         * Performs the 17.1 upgrade. Removes the pipe and tilde separators and replaces them with the dash separator.
         *
         * @return void
         */
        private function upgrade_171()
        {
        }
        /**
         * Sets the home_url option for the 15.1 upgrade routine.
         *
         * @return void
         */
        protected function set_home_url_for_151()
        {
        }
        /**
         * Moves the `indexables_indexation_reason` option to the
         * renamed `indexing_reason` option.
         *
         * @return void
         */
        protected function move_indexables_indexation_reason_for_151()
        {
        }
        /**
         * Checks if the indexable indexation is completed.
         * If so, sets the `indexables_indexation_completed` option to `true`,
         * else to `false`.
         */
        public function set_indexation_completed_option_for_145()
        {
        }
        /**
         * Cleans up the private taxonomies from the indexables table for the upgrade routine to 14.1.
         */
        public function clean_up_private_taxonomies_for_141()
        {
        }
        /**
         * Resets the permalinks of attachments to `null` in the indexable table for the upgrade routine to 14.1.
         */
        private function reset_permalinks_of_attachments_for_141()
        {
        }
        /**
         * Removes notifications from the Notification center for the 14.1 upgrade.
         *
         * @return void
         */
        public function remove_notifications_for_141()
        {
        }
        /**
         * Removes the wpseo-suggested-plugin-yoast-acf-analysis notification from the Notification center for the 14.2 upgrade.
         *
         * @return void
         */
        public function remove_acf_notification_for_142()
        {
        }
        /**
         * Removes the wpseo-plugin-updated notification from the Notification center for the 15.7 upgrade.
         *
         * @return void
         */
        public function remove_plugin_updated_notification_for_157()
        {
        }
        /**
         * Removes all notifications saved in the database under 'wp_yoast_notifications'.
         *
         * @return void
         */
        private function clean_all_notifications()
        {
        }
        /**
         * Removes the post meta fields for a given meta key.
         *
         * @param string $meta_key The meta key.
         *
         * @return void
         */
        private function delete_post_meta($meta_key)
        {
        }
        /**
         * Removes all sitemap validators.
         *
         * This should be executed on every upgrade routine until we have removed the sitemap caching in the database.
         *
         * @return void
         */
        private function remove_sitemap_validators()
        {
        }
        /**
         * Retrieves the option value directly from the database.
         *
         * @param string $option_name Option to retrieve.
         *
         * @return array|mixed The content of the option if exists, otherwise an empty array.
         */
        protected function get_option_from_database($option_name)
        {
        }
        /**
         * Cleans the option to make sure only relevant settings are there.
         *
         * @param string $option_name Option name save.
         *
         * @return void
         */
        protected function cleanup_option_data($option_name)
        {
        }
        /**
         * Saves an option setting to where it should be stored.
         *
         * @param array       $source_data    The option containing the value to be migrated.
         * @param string      $source_setting Name of the key in the "from" option.
         * @param string|null $target_setting Name of the key in the "to" option.
         *
         * @return void
         */
        protected function save_option_setting($source_data, $source_setting, $target_setting = \null)
        {
        }
        /**
         * Migrates WooCommerce archive settings to the WooCommerce Shop page meta-data settings.
         *
         * If no Shop page is defined, nothing will be migrated.
         *
         * @return void
         */
        private function migrate_woocommerce_archive_setting_to_shop_page()
        {
        }
        /**
         * Stores the initial `permalink_structure` option.
         *
         * @return void
         */
        public function set_permalink_structure_option_for_151()
        {
        }
        /**
         * Stores the initial slugs of custom taxonomies.
         *
         * @return void
         */
        public function store_custom_taxonomy_slugs_for_151()
        {
        }
        /**
         * Copies the frontpage social settings to the titles options.
         *
         * @return void
         */
        public function copy_og_settings_from_social_to_titles()
        {
        }
        /**
         * Reset the social options with the correct default values.
         *
         * @return void
         */
        public function reset_og_settings_to_default_values()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * Class for the Yoast SEO admin bar menu.
     */
    class WPSEO_Admin_Bar_Menu implements \WPSEO_WordPress_Integration
    {
        /**
         * The identifier used for the menu.
         *
         * @var string
         */
        const MENU_IDENTIFIER = 'wpseo-menu';
        /**
         * The identifier used for the Keyword Research submenu.
         *
         * @var string
         */
        const KEYWORD_RESEARCH_SUBMENU_IDENTIFIER = 'wpseo-kwresearch';
        /**
         * The identifier used for the Analysis submenu.
         *
         * @var string
         */
        const ANALYSIS_SUBMENU_IDENTIFIER = 'wpseo-analysis';
        /**
         * The identifier used for the Settings submenu.
         *
         * @var string
         */
        const SETTINGS_SUBMENU_IDENTIFIER = 'wpseo-settings';
        /**
         * The identifier used for the Network Settings submenu.
         *
         * @var string
         */
        const NETWORK_SETTINGS_SUBMENU_IDENTIFIER = 'wpseo-network-settings';
        /**
         * Asset manager instance.
         *
         * @var WPSEO_Admin_Asset_Manager
         */
        protected $asset_manager;
        /**
         * Constructor.
         *
         * Sets the asset manager to use.
         *
         * @param WPSEO_Admin_Asset_Manager|null $asset_manager Optional. Asset manager to use.
         */
        public function __construct(\WPSEO_Admin_Asset_Manager $asset_manager = \null)
        {
        }
        /**
         * Adds the admin bar menu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        public function add_menu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Enqueues admin bar assets.
         *
         * @return void
         */
        public function enqueue_assets()
        {
        }
        /**
         * Registers the hooks.
         *
         * @return void
         */
        public function register_hooks()
        {
        }
        /**
         * Checks whether the requirements to use this class are met.
         *
         * @return bool True if requirements are met, false otherwise.
         */
        public function meets_requirements()
        {
        }
        /**
         * Adds the admin bar root menu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        protected function add_root_menu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Adds the admin bar keyword research submenu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        protected function add_keyword_research_submenu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Adds the admin bar analysis submenu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        protected function add_analysis_submenu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Adds the admin bar settings submenu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        protected function add_settings_submenu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Adds the admin bar network settings submenu.
         *
         * @param WP_Admin_Bar $wp_admin_bar Admin bar instance to add the menu to.
         *
         * @return void
         */
        protected function add_network_settings_submenu(\WP_Admin_Bar $wp_admin_bar)
        {
        }
        /**
         * Gets the menu title markup.
         *
         * @return string Admin bar title markup.
         */
        protected function get_title()
        {
        }
        /**
         * Gets the current post if in a singular post context.
         *
         * @global string       $pagenow Current page identifier.
         * @global WP_Post|null $post    Current post object, or null if none available.
         *
         * @return WP_Post|null Post object, or null if not in singular context.
         */
        protected function get_singular_post()
        {
        }
        /**
         * Gets the focus keyword for a given post.
         *
         * @param WP_Post $post Post object to get its focus keyword.
         *
         * @return string Focus keyword, or empty string if none available.
         */
        protected function get_post_focus_keyword($post)
        {
        }
        /**
         * Gets the score for a given post.
         *
         * @param WP_Post $post Post object to get its score.
         *
         * @return string Score markup, or empty string if none available.
         */
        protected function get_post_score($post)
        {
        }
        /**
         * Gets the current term if in a singular term context.
         *
         * @global string       $pagenow  Current page identifier.
         * @global WP_Query     $wp_query Current query object.
         * @global WP_Term|null $tag      Current term object, or null if none available.
         *
         * @return WP_Term|null Term object, or null if not in singular context.
         */
        protected function get_singular_term()
        {
        }
        /**
         * Gets the score for a given term.
         *
         * @param WP_Term $term Term object to get its score.
         *
         * @return string Score markup, or empty string if none available.
         */
        protected function get_term_score($term)
        {
        }
        /**
         * Takes the SEO score and makes the score icon for the admin bar for it.
         *
         * @param int $score The 0-100 rating of the score. Can be either SEO score or content score.
         *
         * @return string Score markup.
         */
        protected function get_score($score)
        {
        }
        /**
         * Gets the URL to the main admin settings page.
         *
         * @return string Admin settings page URL.
         */
        protected function get_settings_page_url()
        {
        }
        /**
         * Gets the notification counter if in a valid context.
         *
         * @return string Notification counter markup, or empty string if not available.
         */
        protected function get_notification_counter()
        {
        }
        /**
         * Gets the notification popup if in a valid context.
         *
         * @return string Notification popup markup, or empty string if not available.
         */
        protected function get_notification_popup()
        {
        }
        /**
         * Checks whether the current user can manage options in the current context.
         *
         * @return bool True if capabilities are sufficient, false otherwise.
         */
        protected function can_manage_options()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * WPSEO_Custom_Fields.
     */
    class WPSEO_Custom_Fields
    {
        /**
         * Custom fields cache.
         *
         * @var array
         */
        protected static $custom_fields = \null;
        /**
         * Retrieves the custom field names as an array.
         *
         * @link WordPress core: wp-admin/includes/template.php. Reused query from it.
         *
         * @return array The custom fields.
         */
        public static function get_custom_fields()
        {
        }
        /**
         * Adds the cf_ prefix to a field.
         *
         * @param string $field The field to prefix.
         *
         * @return string The prefixed field.
         */
        private static function add_custom_field_prefix($field)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * WPSEO_Custom_Taxonomies.
     */
    class WPSEO_Custom_Taxonomies
    {
        /**
         * Custom taxonomies cache.
         *
         * @var array
         */
        protected static $custom_taxonomies = \null;
        /**
         * Gets the names of the custom taxonomies, prepends 'ct_' and 'ct_desc', and returns them in an array.
         *
         * @return array The custom taxonomy prefixed names.
         */
        public static function get_custom_taxonomies()
        {
        }
        /**
         * Adds the ct_ prefix to a taxonomy.
         *
         * @param string $taxonomy The taxonomy to prefix.
         *
         * @return string The prefixed taxonomy.
         */
        private static function add_custom_taxonomies_prefix($taxonomy)
        {
        }
        /**
         * Adds the ct_desc_ prefix to a taxonomy.
         *
         * @param string $taxonomy The taxonomy to prefix.
         *
         * @return string The prefixed taxonomy.
         */
        private static function add_custom_taxonomies_description_prefix($taxonomy)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internal
     */
    /**
     * Class containing method for WPSEO Features.
     *
     * @deprecated 16.0
     */
    class WPSEO_Features
    {
        /**
         * Checks if the premium constant exists to make sure if plugin is the premium one.
         *
         * @deprecated 16.0
         * @codeCoverageIgnore
         *
         * @return bool
         */
        public function is_premium()
        {
        }
        /**
         * Checks if using the free version of the plugin.
         *
         * @deprecated 16.0
         * @codeCoverageIgnore
         *
         * @return bool
         */
        public function is_free()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * WPSEO_Image_Utils.
     */
    class WPSEO_Image_Utils
    {
        /**
         * Find an attachment ID for a given URL.
         *
         * @param string $url The URL to find the attachment for.
         *
         * @return int The found attachment ID, or 0 if none was found.
         */
        public static function get_attachment_by_url($url)
        {
        }
        /**
         * Implements the attachment_url_to_postid with use of WP Cache.
         *
         * @param string $url The attachment URL for which we want to know the Post ID.
         *
         * @return int The Post ID belonging to the attachment, 0 if not found.
         */
        protected static function attachment_url_to_postid($url)
        {
        }
        /**
         * Retrieves the image data.
         *
         * @param array $image         Image array with URL and metadata.
         * @param int   $attachment_id Attachment ID.
         *
         * @return false|array {
         *     Array of image data
         *
         *     @type string $alt      Image's alt text.
         *     @type string $path     Path of image.
         *     @type int    $width    Width of image.
         *     @type int    $height   Height of image.
         *     @type string $type     Image's MIME type.
         *     @type string $size     Image's size.
         *     @type string $url      Image's URL.
         *     @type int    $filesize The file size in bytes, if already set.
         * }
         */
        public static function get_data($image, $attachment_id)
        {
        }
        /**
         * Checks a size version of an image to see if it's not too heavy.
         *
         * @param array $image Image to check the file size of.
         *
         * @return bool True when the image is within limits, false if not.
         */
        public static function has_usable_file_size($image)
        {
        }
        /**
         * Find the right version of an image based on size.
         *
         * @param int    $attachment_id Attachment ID.
         * @param string $size          Size name.
         *
         * @return array|false Returns an array with image data on success, false on failure.
         */
        public static function get_image($attachment_id, $size)
        {
        }
        /**
         * Returns the image data for the full size image.
         *
         * @param int $attachment_id Attachment ID.
         *
         * @return array|false Array when there is a full size image. False if not.
         */
        protected static function get_full_size_image_data($attachment_id)
        {
        }
        /**
         * Finds the full file path for a given image file.
         *
         * @param string $path The relative file path.
         *
         * @return string The full file path.
         */
        public static function get_absolute_path($path)
        {
        }
        /**
         * Get the relative path of the image.
         *
         * @param string $img Image URL.
         *
         * @return string The expanded image URL.
         */
        public static function get_relative_path($img)
        {
        }
        /**
         * Get the image file size.
         *
         * @param array $image An image array object.
         *
         * @return int The file size in bytes.
         */
        public static function get_file_size($image)
        {
        }
        /**
         * Returns the different image variations for consideration.
         *
         * @param int $attachment_id The attachment to return the variations for.
         *
         * @return array The different variations possible for this attachment ID.
         */
        public static function get_variations($attachment_id)
        {
        }
        /**
         * Check original size of image. If original image is too small, return false, else return true.
         *
         * Filters a list of variations by a certain set of usable dimensions.
         *
         * @param array $usable_dimensions {
         *    The parameters to check against.
         *
         *    @type int    $min_width     Minimum width of image.
         *    @type int    $max_width     Maximum width of image.
         *    @type int    $min_height    Minimum height of image.
         *    @type int    $max_height    Maximum height of image.
         * }
         * @param array $variations        The variations that should be considered.
         *
         * @return array Whether a variation is fit for display or not.
         */
        public static function filter_usable_dimensions($usable_dimensions, $variations)
        {
        }
        /**
         * Filters a list of variations by (disk) file size.
         *
         * @param array $variations The variations to consider.
         *
         * @return array The validations that pass the required file size limits.
         */
        public static function filter_usable_file_size($variations)
        {
        }
        /**
         * Retrieve the internal WP image file sizes.
         *
         * @return array An array of image sizes.
         */
        public static function get_sizes()
        {
        }
        /**
         * Grabs an image alt text.
         *
         * @param int $attachment_id The attachment ID.
         *
         * @return string The image alt text.
         */
        public static function get_alt_tag($attachment_id)
        {
        }
        /**
         * Checks whether an img sizes up to the parameters.
         *
         * @param array $dimensions        The image values.
         * @param array $usable_dimensions The parameters to check against.
         *
         * @return bool True if the image has usable measurements, false if not.
         */
        private static function has_usable_dimensions($dimensions, $usable_dimensions)
        {
        }
        /**
         * Gets the post's first usable content image. Null if none is available.
         *
         * @param int|null $post_id The post id.
         *
         * @return string|null The image URL.
         */
        public static function get_first_usable_content_image_for_post($post_id = \null)
        {
        }
        /**
         * Gets the term's first usable content image. Null if none is available.
         *
         * @param int $term_id The term id.
         *
         * @return string|null The image URL.
         */
        public static function get_first_content_image_for_term($term_id)
        {
        }
        /**
         * Retrieves an attachment ID for an image uploaded in the settings.
         *
         * Due to self::get_attachment_by_url returning 0 instead of false.
         * 0 is also a possibility when no ID is available.
         *
         * @param string $setting The setting the image is stored in.
         *
         * @return int|bool The attachment id, or false or 0 if no ID is available.
         */
        public static function get_attachment_id_from_settings($setting)
        {
        }
        /**
         * Retrieves the first possible image url from an array of images.
         *
         * @param array $images The array to extract image url from.
         *
         * @return string|null The extracted image url when found, null when not found.
         */
        protected static function get_first_image($images)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     * @since   3.6
     */
    /**
     * This class checks if the wpseo option doesn't exists. In the case it doesn't it will set a property that is
     * accessible via a method to check if the installation is fresh.
     */
    class WPSEO_Installation
    {
        /**
         * Checks if Yoast SEO is installed for the first time.
         */
        public function __construct()
        {
        }
        /**
         * When the option doesn't exist, it should be a new install.
         *
         * @return bool
         */
        private function is_first_install()
        {
        }
        /**
         * Sets the options on first install for showing the installation notice and disabling of the settings pages.
         */
        public function set_first_install_options()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * Represents a post's primary term.
     */
    class WPSEO_Primary_Term
    {
        /**
         * Taxonomy name for the term.
         *
         * @var string
         */
        protected $taxonomy_name;
        /**
         * Post ID for the term.
         *
         * @var int
         */
        protected $post_ID;
        /**
         * The taxonomy this term is part of.
         *
         * @param string $taxonomy_name Taxonomy name for the term.
         * @param int    $post_id       Post ID for the term.
         */
        public function __construct($taxonomy_name, $post_id)
        {
        }
        /**
         * Returns the primary term ID.
         *
         * @return int|bool
         */
        public function get_primary_term()
        {
        }
        /**
         * Sets the new primary term ID.
         *
         * @param int $new_primary_term New primary term ID.
         */
        public function set_primary_term($new_primary_term)
        {
        }
        /**
         * Get the terms for the current post ID.
         * When $terms is not an array, set $terms to an array.
         *
         * @return array
         */
        protected function get_terms()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Holder for SEO Rank information.
     */
    class WPSEO_Rank
    {
        /**
         * Constant used for determining a bad SEO rating.
         *
         * @var string
         */
        const BAD = 'bad';
        /**
         * Constant used for determining an OK SEO rating.
         *
         * @var string
         */
        const OK = 'ok';
        /**
         * Constant used for determining a good SEO rating.
         *
         * @var string
         */
        const GOOD = 'good';
        /**
         * Constant used for determining that no focus keyphrase is set.
         *
         * @var string
         */
        const NO_FOCUS = 'na';
        /**
         * Constant used for determining that this content is not indexed.
         *
         * @var string
         */
        const NO_INDEX = 'noindex';
        /**
         * All possible ranks.
         *
         * @var array
         */
        protected static $ranks = [self::BAD, self::OK, self::GOOD, self::NO_FOCUS, self::NO_INDEX];
        /**
         * Holds the translation from seo score slug to actual score range.
         *
         * @var array
         */
        protected static $ranges = [self::NO_FOCUS => ['start' => 0, 'end' => 0], self::BAD => ['start' => 1, 'end' => 40], self::OK => ['start' => 41, 'end' => 70], self::GOOD => ['start' => 71, 'end' => 100]];
        /**
         * The current rank.
         *
         * @var int
         */
        protected $rank;
        /**
         * WPSEO_Rank constructor.
         *
         * @param int $rank The actual rank.
         */
        public function __construct($rank)
        {
        }
        /**
         * Returns the saved rank for this rank.
         *
         * @return string
         */
        public function get_rank()
        {
        }
        /**
         * Returns a CSS class for this rank.
         *
         * @return string
         */
        public function get_css_class()
        {
        }
        /**
         * Returns a label for this rank.
         *
         * @return string
         */
        public function get_label()
        {
        }
        /**
         * Returns a label for use in a drop down.
         *
         * @return mixed
         */
        public function get_drop_down_label()
        {
        }
        /**
         * Gets the drop down labels for the readability score.
         *
         * @return string The readability rank label.
         */
        public function get_drop_down_readability_labels()
        {
        }
        /**
         * Get the starting score for this rank.
         *
         * @return int The start score.
         */
        public function get_starting_score()
        {
        }
        /**
         * Get the ending score for this rank.
         *
         * @return int The end score.
         */
        public function get_end_score()
        {
        }
        /**
         * Returns a rank for a specific numeric score.
         *
         * @param int $score The score to determine a rank for.
         *
         * @return self
         */
        public static function from_numeric_score($score)
        {
        }
        /**
         * Returns a list of all possible SEO Ranks.
         *
         * @return WPSEO_Rank[]
         */
        public static function get_all_ranks()
        {
        }
        /**
         * Returns a list of all possible Readability Ranks.
         *
         * @return WPSEO_Rank[]
         */
        public static function get_all_readability_ranks()
        {
        }
        /**
         * Converts a numeric rank into a WPSEO_Rank object, for use in functional array_* functions.
         *
         * @param string $rank SEO Rank.
         *
         * @return WPSEO_Rank
         */
        private static function create_rank($rank)
        {
        }
    }
    /**
     * Class: WPSEO_Replace_Vars.
     *
     * This class implements the replacing of `%%variable_placeholders%%` with their real value based on the current
     * requested page/post/cpt/etc in text strings.
     */
    class WPSEO_Replace_Vars
    {
        /**
         * Default post/page/cpt information.
         *
         * @var array
         */
        protected $defaults = ['ID' => '', 'name' => '', 'post_author' => '', 'post_content' => '', 'post_date' => '', 'post_excerpt' => '', 'post_modified' => '', 'post_title' => '', 'taxonomy' => '', 'term_id' => '', 'term404' => ''];
        /**
         * Current post/page/cpt information.
         *
         * @var stdClass
         */
        protected $args;
        /**
         * Help texts for use in WPSEO -> Search appearance tabs.
         *
         * @var array
         */
        protected static $help_texts = [];
        /**
         * Register of additional variable replacements registered by other plugins/themes.
         *
         * @var array
         */
        protected static $external_replacements = [];
        /**
         * Setup the help texts and external replacements as statics so they will be available to all instances.
         */
        public static function setup_statics_once()
        {
        }
        /**
         * Register new replacement %%variables%%.
         * For use by other plugins/themes to register extra variables.
         *
         * @see wpseo_register_var_replacement() for a usage example.
         *
         * @param string $var              The name of the variable to replace, i.e. '%%var%%'.
         *                                 Note: the surrounding %% are optional.
         * @param mixed  $replace_function Function or method to call to retrieve the replacement value for the variable.
         *                                 Uses the same format as add_filter/add_action function parameter and
         *                                 should *return* the replacement value. DON'T echo it.
         * @param string $type             Type of variable: 'basic' or 'advanced', defaults to 'advanced'.
         * @param string $help_text        Help text to be added to the help tab for this variable.
         *
         * @return bool Whether the replacement function was succesfully registered.
         */
        public static function register_replacement($var, $replace_function, $type = 'advanced', $help_text = '')
        {
        }
        /**
         * Replace `%%variable_placeholders%%` with their real value based on the current requested page/post/cpt/etc.
         *
         * @param string $string The string to replace the variables in.
         * @param array  $args   The object some of the replacement values might come from,
         *                       could be a post, taxonomy or term.
         * @param array  $omit   Variables that should not be replaced by this function.
         *
         * @return string
         */
        public function replace($string, $args, $omit = [])
        {
        }
        /**
         * Register a new replacement variable if it has not been registered already.
         *
         * @param string $var              The name of the variable to replace, i.e. '%%var%%'.
         *                                 Note: the surrounding %% are optional.
         * @param mixed  $replace_function Function or method to call to retrieve the replacement value for the variable.
         *                                 Uses the same format as add_filter/add_action function parameter and
         *                                 should *return* the replacement value. DON'T echo it.
         * @param string $type             Type of variable: 'basic' or 'advanced', defaults to 'advanced'.
         * @param string $help_text        Help text to be added to the help tab for this variable.
         *
         * @return bool `true` if the replace var has been registered, `false` if not.
         */
        public function safe_register_replacement($var, $replace_function, $type = 'advanced', $help_text = '')
        {
        }
        /**
         * Checks whether the given replacement variable has already been registered or not.
         *
         * @param string $replacement_variable The replacement variable to check, including the variable delimiter (e.g. `%%var%%`).
         *
         * @return bool `true` if the replacement variable has already been registered.
         */
        public function has_been_registered($replacement_variable)
        {
        }
        /**
         * Retrieve the replacements for the variables found.
         *
         * @param array $matches Variables found in the original string - regex result.
         * @param array $omit    Variables that should not be replaced by this function.
         *
         * @return array Retrieved replacements - this might be a smaller array as some variables
         *               may not yield a replacement in certain contexts.
         */
        private function set_up_replacements($matches, $omit)
        {
        }
        /* *********************** BASIC VARIABLES ************************** */
        /**
         * Retrieve the post/cpt categories (comma separated) for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_category()
        {
        }
        /**
         * Retrieve the category description for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_category_description()
        {
        }
        /**
         * Retrieve the date of the post/page/cpt for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_date()
        {
        }
        /**
         * Retrieve the post/page/cpt excerpt for use as replacement string.
         * The excerpt will be auto-generated if it does not exist.
         *
         * @return string|null
         */
        private function retrieve_excerpt()
        {
        }
        /**
         * Retrieve the post/page/cpt excerpt for use as replacement string (without auto-generation).
         *
         * @return string|null
         */
        private function retrieve_excerpt_only()
        {
        }
        /**
         * Retrieve the title of the parent page of the current page/cpt for use as replacement string.
         * Only applicable for hierarchical post types.
         *
         * @todo Check: shouldn't this use $this->args as well ?
         *
         * @return string|null
         */
        private function retrieve_parent_title()
        {
        }
        /**
         * Retrieve the current search phrase for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_searchphrase()
        {
        }
        /**
         * Retrieve the separator for use as replacement string.
         *
         * @return string Retrieves the title separator.
         */
        private function retrieve_sep()
        {
        }
        /**
         * Retrieve the site's tag line / description for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string|null
         */
        private function retrieve_sitedesc()
        {
        }
        /**
         * Retrieve the site's name for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string|null
         */
        private function retrieve_sitename()
        {
        }
        /**
         * Retrieve the current tag/tags for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_tag()
        {
        }
        /**
         * Retrieve the tag description for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_tag_description()
        {
        }
        /**
         * Retrieve the term description for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_term_description()
        {
        }
        /**
         * Retrieve the term name for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_term_title()
        {
        }
        /**
         * Retrieve the title of the post/page/cpt for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_title()
        {
        }
        /**
         * Retrieve primary category for use as replacement string.
         *
         * @return bool|int|null
         */
        private function retrieve_primary_category()
        {
        }
        /**
         * Retrieve the string generated by get_the_archive_title().
         *
         * @return string|null
         */
        private function retrieve_archive_title()
        {
        }
        /* *********************** ADVANCED VARIABLES ************************** */
        /**
         * Determine the page numbering of the current post/page/cpt.
         *
         * @param string $request Either 'nr'|'max' - whether to return the page number or the max number of pages.
         *
         * @return int|null
         */
        private function determine_pagenumbering($request = 'nr')
        {
        }
        /**
         * Determine the post type names for the current post/page/cpt.
         *
         * @param string $request Either 'single'|'plural' - whether to return the single or plural form.
         *
         * @return string|null
         */
        private function determine_pt_names($request = 'single')
        {
        }
        /**
         * Retrieve the attachment caption for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_caption()
        {
        }
        /**
         * Retrieve a post/page/cpt's custom field value for use as replacement string.
         *
         * @param string $var The complete variable to replace which includes the name of
         *                    the custom field which value is to be retrieved.
         *
         * @return string|null
         */
        private function retrieve_cf_custom_field_name($var)
        {
        }
        /**
         * Retrieve a post/page/cpt's custom taxonomies for use as replacement string.
         *
         * @param string $var    The complete variable to replace which includes the name of
         *                       the custom taxonomy which value(s) is to be retrieved.
         * @param bool   $single Whether to retrieve only the first or all values for the taxonomy.
         *
         * @return string|null
         */
        private function retrieve_ct_custom_tax_name($var, $single = \false)
        {
        }
        /**
         * Retrieve a post/page/cpt's custom taxonomies description for use as replacement string.
         *
         * @param string $var The complete variable to replace which includes the name of
         *                    the custom taxonomy which description is to be retrieved.
         *
         * @return string|null
         */
        private function retrieve_ct_desc_custom_tax_name($var)
        {
        }
        /**
         * Retrieve the current date for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string The formatted current date.
         */
        private function retrieve_currentdate()
        {
        }
        /**
         * Retrieve the current day for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string The current day.
         */
        private function retrieve_currentday()
        {
        }
        /**
         * Retrieve the current month for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string The current month.
         */
        private function retrieve_currentmonth()
        {
        }
        /**
         * Retrieve the current time for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string The formatted current time.
         */
        private function retrieve_currenttime()
        {
        }
        /**
         * Retrieve the current year for use as replacement string.
         *
         * The `$replacement` variable is static because it doesn't change depending
         * on the context. See https://github.com/Yoast/wordpress-seo/pull/1172#issuecomment-46019482.
         *
         * @return string The current year.
         */
        private function retrieve_currentyear()
        {
        }
        /**
         * Retrieve the post/page/cpt's focus keyword for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_focuskw()
        {
        }
        /**
         * Retrieve the post/page/cpt ID for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_id()
        {
        }
        /**
         * Retrieve the post/page/cpt modified time for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_modified()
        {
        }
        /**
         * Retrieve the post/page/cpt author's "nice name" for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_name()
        {
        }
        /**
         * Retrieve the post/page/cpt author's users description for use as a replacement string.
         *
         * @return string|null
         */
        private function retrieve_user_description()
        {
        }
        /**
         * Retrieve the current page number with context (i.e. 'page 2 of 4') for use as replacement string.
         *
         * @return string
         */
        private function retrieve_page()
        {
        }
        /**
         * Retrieve the current page number for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_pagenumber()
        {
        }
        /**
         * Retrieve the current page total for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_pagetotal()
        {
        }
        /**
         * Retrieve the post type plural label for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_pt_plural()
        {
        }
        /**
         * Retrieve the post type single label for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_pt_single()
        {
        }
        /**
         * Retrieve the slug which caused the 404 for use as replacement string.
         *
         * @return string|null
         */
        private function retrieve_term404()
        {
        }
        /**
         * Retrieve the post/page/cpt author's user id for use as replacement string.
         *
         * @return string
         */
        private function retrieve_userid()
        {
        }
        /* *********************** HELP TEXT RELATED ************************** */
        /**
         * Set the help text for a user/plugin/theme defined extra variable.
         *
         * @param string                     $type                 Type of variable: 'basic' or 'advanced'.
         * @param WPSEO_Replacement_Variable $replacement_variable The replacement variable to register.
         */
        private static function register_help_text($type, \WPSEO_Replacement_Variable $replacement_variable)
        {
        }
        /**
         * Generates a list of replacement variables based on the help texts.
         *
         * @return array List of replace vars.
         */
        public function get_replacement_variables_list()
        {
        }
        /**
         * Creates a merged associative array of both the basic and advanced help texts.
         *
         * @return array Array with the replacement variables.
         */
        private function get_replacement_variables()
        {
        }
        /**
         * Checks whether the replacement variable contains a `ct_` or `cf_` prefix, because they follow different logic.
         *
         * @param string $replacement_variable The replacement variable.
         *
         * @return bool True when the replacement variable is not prefixed.
         */
        private function is_not_prefixed($replacement_variable)
        {
        }
        /**
         * Strip the prefix from a replacement variable name.
         *
         * @param string $replacement_variable The replacement variable.
         *
         * @return string The replacement variable name without the prefix.
         */
        private function strip_prefix($replacement_variable)
        {
        }
        /**
         * Gets the prefix from a replacement variable name.
         *
         * @param string $replacement_variable The replacement variable.
         *
         * @return string The prefix of the replacement variable.
         */
        private function get_prefix($replacement_variable)
        {
        }
        /**
         * Strips 'desc_' if present, and appends ' description' at the end.
         *
         * @param string $label The replacement variable.
         *
         * @return string The altered replacement variable name.
         */
        private function handle_description($label)
        {
        }
        /**
         * Creates a label for prefixed replacement variables that matches the format in the editors.
         *
         * @param string $replacement_variable The replacement variable.
         *
         * @return string The replacement variable label.
         */
        private function get_label($replacement_variable)
        {
        }
        /**
         * Formats the replacement variables.
         *
         * @param string $replacement_variable The replacement variable to format.
         *
         * @return array The formatted replacement variable.
         */
        private function format_replacement_variable($replacement_variable)
        {
        }
        /**
         * Set/translate the help texts for the WPSEO standard basic variables.
         */
        private static function set_basic_help_texts()
        {
        }
        /**
         * Set/translate the help texts for the WPSEO standard advanced variables.
         */
        private static function set_advanced_help_texts()
        {
        }
        /* *********************** GENERAL HELPER METHODS ************************** */
        /**
         * Remove the '%%' delimiters from a variable string.
         *
         * @param string $string Variable string to be cleaned.
         *
         * @return string
         */
        private static function remove_var_delimiter($string)
        {
        }
        /**
         * Add the '%%' delimiters to a variable string.
         *
         * @param string $string Variable string to be delimited.
         *
         * @return string
         */
        private static function add_var_delimiter($string)
        {
        }
        /**
         * Retrieve a post's terms, comma delimited.
         *
         * @param int    $id            ID of the post to get the terms for.
         * @param string $taxonomy      The taxonomy to get the terms for this post from.
         * @param bool   $return_single If true, return the first term.
         *
         * @return string Either a single term or a comma delimited string of terms.
         */
        public function get_terms($id, $taxonomy, $return_single = \false)
        {
        }
        /**
         * Gets a taxonomy term hierarchy including the term to get the parents for.
         *
         * @return string
         */
        private function get_term_hierarchy()
        {
        }
        /**
         * Retrieves the term ancestors hierarchy.
         *
         * @return string|null The term ancestors hierarchy.
         */
        private function retrieve_term_hierarchy()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     * @since   7.7
     */
    /**
     * Class WPSEO_Replacement_Variable.
     *
     * This class stores the data of a single snippet variable.
     */
    class WPSEO_Replacement_Variable
    {
        /**
         * The variable to use.
         *
         * @var string
         */
        protected $variable;
        /**
         * The label of the replacement variable.
         *
         * @var string
         */
        protected $label;
        /**
         * The description of the replacement variable.
         *
         * @var string
         */
        protected $description;
        /**
         * WPSEO_Replacement_Variable constructor.
         *
         * @param string $variable    The variable that is replaced.
         * @param string $label       The label of the replacement variable.
         * @param string $description The description of the replacement variable.
         */
        public function __construct($variable, $label, $description)
        {
        }
        /**
         * Returns the variable to use.
         *
         * @return string
         */
        public function get_variable()
        {
        }
        /**
         * Returns the label of the replacement variable.
         *
         * @return string
         */
        public function get_label()
        {
        }
        /**
         * Returns the description of the replacement variable.
         *
         * @return string
         */
        public function get_description()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO
     */
    /**
     * Helps with creating shortlinks in the plugin.
     */
    class WPSEO_Shortlinker
    {
        /**
         * Collects the additional data necessary for the shortlink.
         *
         * @return array The shortlink data.
         */
        protected function collect_additional_shortlink_data()
        {
        }
        /**
         * Builds a URL to use in the plugin as shortlink.
         *
         * @param string $url The URL to build upon.
         *
         * @return string The final URL.
         */
        public function build_shortlink($url)
        {
        }
        /**
         * Returns a version of the URL with a utm_content with the current version.
         *
         * @param string $url The URL to build upon.
         *
         * @return string The final URL.
         */
        public static function get($url)
        {
        }
        /**
         * Echoes a version of the URL with a utm_content with the current version.
         *
         * @param string $url The URL to build upon.
         */
        public static function show($url)
        {
        }
        /**
         * Gets the shortlink's query params.
         *
         * @return array The shortlink's query params.
         */
        public static function get_query_params()
        {
        }
        /**
         * Gets the current site's PHP version, without the extra info.
         *
         * @return string The PHP version.
         */
        private function get_php_version()
        {
        }
        /**
         * Gets the current site's platform version.
         *
         * @return string The wp_version.
         */
        protected function get_platform_version()
        {
        }
        /**
         * Get our software and whether it's active or not.
         *
         * @return string The software name + activation state.
         */
        private function get_software()
        {
        }
        /**
         * Gets the number of days the plugin has been active.
         *
         * @return int The number of days the plugin is active.
         */
        private function get_days_active()
        {
        }
        /**
         * Gets the user's language.
         *
         * @return string|false The user's language or `false` when it couldn't be retrieved.
         */
        private function get_user_language()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Class that generates interesting statistics about things.
     */
    class WPSEO_Statistics
    {
        /**
         * Returns the post count for a certain SEO rank.
         *
         * @todo Merge/DRY this with the logic virtually the same in WPSEO_Metabox::column_sort_orderby().
         *
         * @param WPSEO_Rank $rank The SEO rank to get the post count for.
         *
         * @return int
         */
        public function get_post_count($rank)
        {
        }
    }
    /**
     * Group of utility methods for use by WPSEO.
     * All methods are static, this is just a sort of namespacing class wrapper.
     */
    class WPSEO_Utils
    {
        /**
         * Whether the PHP filter extension is enabled.
         *
         * @since 1.8.0
         *
         * @var bool
         */
        public static $has_filters;
        /**
         * Check whether file editing is allowed for the .htaccess and robots.txt files.
         *
         * {@internal current_user_can() checks internally whether a user is on wp-ms and adjusts accordingly.}}
         *
         * @since 1.8.0
         *
         * @return bool
         */
        public static function allow_system_file_edit()
        {
        }
        /**
         * Check if the web server is running on Apache or compatible (LiteSpeed).
         *
         * @since 1.8.0
         *
         * @return bool
         */
        public static function is_apache()
        {
        }
        /**
         * Check if the web server is running on Nginx.
         *
         * @since 1.8.0
         *
         * @return bool
         */
        public static function is_nginx()
        {
        }
        /**
         * Check whether a url is relative.
         *
         * @since 1.8.0
         *
         * @param string $url URL string to check.
         *
         * @return bool
         */
        public static function is_url_relative($url)
        {
        }
        /**
         * Recursively trim whitespace round a string value or of string values within an array.
         * Only trims strings to avoid typecasting a variable (to string).
         *
         * @since 1.8.0
         *
         * @param mixed $value Value to trim or array of values to trim.
         *
         * @return mixed Trimmed value or array of trimmed values.
         */
        public static function trim_recursive($value)
        {
        }
        /**
         * Translates a decimal analysis score into a textual one.
         *
         * @since 1.8.0
         *
         * @param int  $val       The decimal score to translate.
         * @param bool $css_value Whether to return the i18n translated score or the CSS class value.
         *
         * @return string
         */
        public static function translate_score($val, $css_value = \true)
        {
        }
        /**
         * Emulate the WP native sanitize_text_field function in a %%variable%% safe way.
         *
         * Sanitize a string from user input or from the db.
         *
         * - Check for invalid UTF-8;
         * - Convert single < characters to entity;
         * - Strip all tags;
         * - Remove line breaks, tabs and extra white space;
         * - Strip octets - BUT DO NOT REMOVE (part of) VARIABLES WHICH WILL BE REPLACED.
         *
         * @link https://core.trac.wordpress.org/browser/trunk/src/wp-includes/formatting.php for the original.
         *
         * @since 1.8.0
         *
         * @param string $value String value to sanitize.
         *
         * @return string
         */
        public static function sanitize_text_field($value)
        {
        }
        /**
         * Sanitize a url for saving to the database.
         * Not to be confused with the old native WP function.
         *
         * @since 1.8.0
         *
         * @param string $value             String URL value to sanitize.
         * @param array  $allowed_protocols Optional set of allowed protocols.
         *
         * @return string
         */
        public static function sanitize_url($value, $allowed_protocols = ['http', 'https'])
        {
        }
        /**
         * Decode, sanitize and encode the array of strings or the string.
         *
         * @since 13.3
         *
         * @param array|string $value The value to sanitize and encode.
         *
         * @return array|string The sanitized value.
         */
        public static function sanitize_encoded_text_field($value)
        {
        }
        /**
         * Validate a value as boolean.
         *
         * @since 1.8.0
         *
         * @param mixed $value Value to validate.
         *
         * @return bool
         */
        public static function validate_bool($value)
        {
        }
        /**
         * Cast a value to bool.
         *
         * @since 1.8.0
         *
         * @param mixed $value Value to cast.
         *
         * @return bool
         */
        public static function emulate_filter_bool($value)
        {
        }
        /**
         * Validate a value as integer.
         *
         * @since 1.8.0
         *
         * @param mixed $value Value to validate.
         *
         * @return int|bool Int or false in case of failure to convert to int.
         */
        public static function validate_int($value)
        {
        }
        /**
         * Cast a value to integer.
         *
         * @since 1.8.0
         *
         * @param mixed $value Value to cast.
         *
         * @return int|bool
         */
        public static function emulate_filter_int($value)
        {
        }
        /**
         * Clears the WP or W3TC cache depending on which is used.
         *
         * @since 1.8.0
         */
        public static function clear_cache()
        {
        }
        /**
         * Clear rewrite rules.
         *
         * @since 1.8.0
         */
        public static function clear_rewrites()
        {
        }
        /**
         * Do simple reliable math calculations without the risk of wrong results.
         *
         * In the rare case that the bcmath extension would not be loaded, it will return the normal calculation results.
         *
         * @link http://floating-point-gui.de/
         * @link http://php.net/language.types.float.php See the big red warning.
         *
         * @since 1.5.0
         * @since 1.8.0 Moved from stand-alone function to this class.
         *
         * @param mixed  $number1   Scalar (string/int/float/bool).
         * @param string $action    Calculation action to execute. Valid input:
         *                          '+' or 'add' or 'addition',
         *                          '-' or 'sub' or 'subtract',
         *                          '*' or 'mul' or 'multiply',
         *                          '/' or 'div' or 'divide',
         *                          '%' or 'mod' or 'modulus'
         *                          '=' or 'comp' or 'compare'.
         * @param mixed  $number2   Scalar (string/int/float/bool).
         * @param bool   $round     Whether or not to round the result. Defaults to false.
         *                          Will be disregarded for a compare operation.
         * @param int    $decimals  Decimals for rounding operation. Defaults to 0.
         * @param int    $precision Calculation precision. Defaults to 10.
         *
         * @return mixed Calculation Result or false if either or the numbers isn't scalar or
         *               an invalid operation was passed.
         *               - For compare the result will always be an integer.
         *               - For all other operations, the result will either be an integer (preferred)
         *                 or a float.
         */
        public static function calc($number1, $action, $number2, $round = \false, $decimals = 0, $precision = 10)
        {
        }
        /**
         * Trim whitespace and NBSP (Non-breaking space) from string.
         *
         * @since 2.0.0
         *
         * @param string $string String input to trim.
         *
         * @return string
         */
        public static function trim_nbsp_from_string($string)
        {
        }
        /**
         * Check if a string is a valid datetime.
         *
         * @since 2.0.0
         *
         * @param string $datetime String input to check as valid input for DateTime class.
         *
         * @return bool
         */
        public static function is_valid_datetime($datetime)
        {
        }
        /**
         * Format the URL to be sure it is okay for using as a redirect url.
         *
         * This method will parse the URL and combine them in one string.
         *
         * @since 2.3.0
         *
         * @param string $url URL string.
         *
         * @return mixed
         */
        public static function format_url($url)
        {
        }
        /**
         * Retrieves the sitename.
         *
         * @since 3.0.0
         *
         * @return string
         */
        public static function get_site_name()
        {
        }
        /**
         * Check if the current opened page is a Yoast SEO page.
         *
         * @since 3.0.0
         *
         * @return bool
         */
        public static function is_yoast_seo_page()
        {
        }
        /**
         * Check if the current opened page belongs to Yoast SEO Free.
         *
         * @since 3.3.0
         *
         * @param string $current_page The current page the user is on.
         *
         * @return bool
         */
        public static function is_yoast_seo_free_page($current_page)
        {
        }
        /**
         * Checks if we are in the premium or free plugin.
         *
         * @deprecated 16.0
         * @codeCoverageIgnore
         *
         * @return bool True when we are in the premium plugin.
         */
        public static function is_yoast_seo_premium()
        {
        }
        /**
         * Determine if Yoast SEO is in development mode?
         *
         * Inspired by JetPack (https://github.com/Automattic/jetpack/blob/master/class.jetpack.php#L1383-L1406).
         *
         * @since 3.0.0
         *
         * @return bool
         */
        public static function is_development_mode()
        {
        }
        /**
         * Retrieve home URL with proper trailing slash.
         *
         * @since 3.3.0
         *
         * @param string      $path   Path relative to home URL.
         * @param string|null $scheme Scheme to apply.
         *
         * @return string Home URL with optional path, appropriately slashed if not.
         */
        public static function home_url($path = '', $scheme = \null)
        {
        }
        /**
         * Checks if the WP-REST-API is available.
         *
         * @since 3.6
         * @since 3.7 Introduced the $minimum_version parameter.
         *
         * @param string $minimum_version The minimum version the API should be.
         *
         * @return bool Returns true if the API is available.
         */
        public static function is_api_available($minimum_version = '2.0')
        {
        }
        /**
         * Determine whether or not the metabox should be displayed for a post type.
         *
         * @param string|null $post_type Optional. The post type to check the visibility of the metabox for.
         *
         * @return bool Whether or not the metabox should be displayed.
         */
        protected static function display_post_type_metabox($post_type = \null)
        {
        }
        /**
         * Determine whether or not the metabox should be displayed for a taxonomy.
         *
         * @param string|null $taxonomy Optional. The post type to check the visibility of the metabox for.
         *
         * @return bool Whether or not the metabox should be displayed.
         */
        protected static function display_taxonomy_metabox($taxonomy = \null)
        {
        }
        /**
         * Determines whether the metabox is active for the given identifier and type.
         *
         * @param string $identifier The identifier to check for.
         * @param string $type       The type to check for.
         *
         * @return bool Whether or not the metabox is active.
         */
        public static function is_metabox_active($identifier, $type)
        {
        }
        /**
         * Determines whether the plugin is active for the entire network.
         *
         * @return bool Whether or not the plugin is network-active.
         */
        public static function is_plugin_network_active()
        {
        }
        /**
         * Gets the type of the current post.
         *
         * @return string The post type, or an empty string.
         */
        public static function get_post_type()
        {
        }
        /**
         * Gets the type of the current page.
         *
         * @return string Returns 'post' if the current page is a post edit page. Taxonomy in other cases.
         */
        public static function get_page_type()
        {
        }
        /**
         * Getter for the Adminl10n array. Applies the wpseo_admin_l10n filter.
         *
         * @return array The Adminl10n array.
         */
        public static function get_admin_l10n()
        {
        }
        /**
         * Retrieves the analysis worker log level. Defaults to errors only.
         *
         * Uses bool YOAST_SEO_DEBUG as flag to enable logging. Off equals ERROR.
         * Uses string YOAST_SEO_DEBUG_ANALYSIS_WORKER as log level for the Analysis
         * Worker. Defaults to INFO.
         * Can be: TRACE, DEBUG, INFO, WARN or ERROR.
         *
         * @return string The log level to use.
         */
        public static function get_analysis_worker_log_level()
        {
        }
        /**
         * Returns the unfiltered home URL.
         *
         * In case WPML is installed, returns the original home_url and not the WPML version.
         * In case of a multisite setup we return the network_home_url.
         *
         * @codeCoverageIgnore
         *
         * @return string The home url.
         */
        public static function get_home_url()
        {
        }
        /**
         * Prepares data for outputting as JSON.
         *
         * @param array $data The data to format.
         *
         * @return false|string The prepared JSON string.
         */
        public static function format_json_encode($data)
        {
        }
        /**
         * Extends the allowed post tags with accessibility-related attributes.
         *
         * @codeCoverageIgnore
         *
         * @param array $allowed_post_tags The allowed post tags.
         *
         * @return array The allowed tags including post tags, input tags and select tags.
         */
        public static function extend_kses_post_with_a11y($allowed_post_tags)
        {
        }
        /**
         * Extends the allowed post tags with input, select and option tags.
         *
         * @codeCoverageIgnore
         *
         * @param array $allowed_post_tags The allowed post tags.
         *
         * @return array The allowed tags including post tags, input tags, select tags and option tags.
         */
        public static function extend_kses_post_with_forms($allowed_post_tags)
        {
        }
        /**
         * Gets an array of enabled features.
         *
         * @return string[] The array of enabled features.
         */
        public static function retrieve_enabled_features()
        {
        }
        /* ********************* DEPRECATED METHODS ********************* */
        /**
         * List all the available user roles.
         *
         * @since      1.8.0
         * @deprecated 15.0
         * @codeCoverageIgnore
         *
         * @return array
         */
        public static function get_roles()
        {
        }
        /**
         * Checks if the current installation supports MyYoast access tokens.
         *
         * @deprecated 15.0
         * @codeCoverageIgnore
         *
         * @return bool True if access_tokens are supported.
         */
        public static function has_access_token_support()
        {
        }
        /**
         * Standardize whitespace in a string.
         *
         * Replace line breaks, carriage returns, tabs with a space, then remove double spaces.
         *
         * @since      1.8.0
         * @deprecated 15.2
         * @codeCoverageIgnore
         *
         * @param string $string String input to standardize.
         *
         * @return string
         */
        public static function standardize_whitespace($string)
        {
        }
        /**
         * First strip out registered and enclosing shortcodes using native WordPress strip_shortcodes function.
         * Then strip out the shortcodes with a filthy regex, because people don't properly register their shortcodes.
         *
         * @since      1.8.0
         * @deprecated 15.2
         * @codeCoverageIgnore
         *
         * @param string $text Input string that might contain shortcodes.
         *
         * @return string String without shortcodes.
         */
        public static function strip_shortcode($text)
        {
        }
        /**
         * Retrieves the title separator.
         *
         * @since      3.0.0
         * @deprecated 15.2
         * @codeCoverageIgnore
         *
         * @return string
         */
        public static function get_title_separator()
        {
        }
        /**
         * Flush W3TC cache after successful update/add of taxonomy meta option.
         *
         * @since      1.8.0
         * @deprecated 15.3
         * @codeCoverageIgnore
         */
        public static function flush_w3tc_cache()
        {
        }
        /**
         * Determines whether or not WooCommerce is active.
         *
         * @deprecated 15.3
         * @codeCoverageIgnore
         *
         * @return bool Whether or not WooCommerce is active.
         */
        public static function is_woocommerce_active()
        {
        }
        /**
         * Outputs a Schema blob.
         *
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @param array  $graph The Schema graph array to output.
         * @param string $class The (optional) class to add to the script tag.
         *
         * @return bool
         */
        public static function schema_output($graph, $class = 'yoast-schema-graph')
        {
        }
        /**
         * Returns a script tag with Schema blob.
         *
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @param array  $graph The Schema graph array to output.
         * @param string $class The (optional) class to add to the script tag.
         *
         * @return false|string A schema blob with script tags.
         */
        public static function schema_tag($graph, $class = 'yoast-schema-graph')
        {
        }
        /**
         * Returns the SVG for the traffic light in the metabox.
         *
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @return string
         */
        public static function traffic_light_svg()
        {
        }
        /**
         * Gets the plugin name from file.
         *
         * @since      2.3.3
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @param string $plugin Plugin path relative to plugins directory.
         *
         * @return string|bool
         */
        public static function get_plugin_name($plugin)
        {
        }
        /**
         * Returns a base64 URL for the svg for use in the menu.
         *
         * @since      3.3.0
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @param bool $base64 Whether or not to return base64'd output.
         *
         * @return string
         */
        public static function get_icon_svg($base64 = \true)
        {
        }
        /**
         * Checks whether the current user is allowed to access the configuration.
         *
         * @since      1.8.0
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @return bool
         */
        public static function grant_access()
        {
        }
    }
    /**
     * Date helper class.
     *
     * @package WPSEO\Internals
     */
    /**
     * Class WPSEO_Date_Helper
     *
     * Note: Move this class with namespace to the src/helpers directory and add a class_alias for BC.
     */
    class WPSEO_Date_Helper
    {
        /**
         * Formats a given date in UTC TimeZone format.
         *
         * @param string $date   String representing the date / time.
         * @param string $format The format that the passed date should be in.
         *
         * @return string The formatted date.
         */
        public function format($date, $format = \DATE_W3C)
        {
        }
        /**
         * Formats the given timestamp to the needed format.
         *
         * @param int    $timestamp The timestamp to use for the formatting.
         * @param string $format    The format that the passed date should be in.
         *
         * @return string The formatted date.
         */
        public function format_timestamp($timestamp, $format = \DATE_W3C)
        {
        }
        /**
         * Formats a given date in UTC TimeZone format and translate it to the set language.
         *
         * @param string $date   String representing the date / time.
         * @param string $format The format that the passed date should be in.
         *
         * @return string The formatted and translated date.
         */
        public function format_translated($date, $format = \DATE_W3C)
        {
        }
        /**
         * Check if a string is a valid datetime.
         *
         * @param string $datetime String input to check as valid input for DateTime class.
         *
         * @return bool True when datatime is valid.
         */
        public function is_valid_datetime($datetime)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Class WPSEO_MyYoast_Bad_Request_Exception.
     */
    class WPSEO_MyYoast_Bad_Request_Exception extends \Exception
    {
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Represents the abstract class for the health check.
     */
    abstract class WPSEO_Health_Check
    {
        /**
         * The health check section in which 'good' results should be shown.
         *
         * @var string
         */
        const STATUS_GOOD = 'good';
        /**
         * The health check section in which 'recommended' results should be shown.
         *
         * @var string
         */
        const STATUS_RECOMMENDED = 'recommended';
        /**
         * The health check section in which 'critical' results should be shown.
         *
         * @var string
         */
        const STATUS_CRITICAL = 'critical';
        /**
         * The value of the section header in the Health check.
         *
         * @var string
         */
        protected $label = '';
        /**
         * Section the result should be displayed in.
         *
         * @var string
         */
        protected $status = '';
        /**
         * What the badge should say with a color.
         *
         * @var array
         */
        protected $badge = ['label' => '', 'color' => ''];
        /**
         * Additional details about the results of the test.
         *
         * @var string
         */
        protected $description = '';
        /**
         * A link or button to allow the end user to take action on the result.
         *
         * @var string
         */
        protected $actions = '';
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = '';
        /**
         * Whether or not the test should be ran on AJAX as well.
         *
         * @var bool True when is async, default false.
         */
        protected $async = \false;
        /**
         * Runs the test and returns the result.
         */
        public abstract function run();
        /**
         * Registers the test to WordPress.
         */
        public function register_test()
        {
        }
        /**
         * Runs the test.
         *
         * @param array $tests Array with the current tests.
         *
         * @return array The extended array.
         */
        public function add_test($tests)
        {
        }
        /**
         * Runs the test in async mode.
         *
         * @param array $tests Array with the current tests.
         *
         * @return array The extended array.
         */
        public function add_async_test($tests)
        {
        }
        /**
         * Formats the test result as an array.
         *
         * @return array The formatted test result.
         */
        public function get_test_result()
        {
        }
        /**
         * Formats the test result as an array.
         */
        public function get_async_test_result()
        {
        }
        /**
         * Retrieves the badge and ensure usable values are set.
         *
         * @return array The proper formatted badge.
         */
        protected function get_badge()
        {
        }
        /**
         * WordPress converts the underscores to dashes. To prevent issues we have
         * to do it as well.
         *
         * @return string The formatted testname.
         */
        protected function get_test_name()
        {
        }
        /**
         * Checks if the health check is async.
         *
         * @return bool True when check is async.
         */
        protected function is_async()
        {
        }
        /**
         * Adds a text to the bottom of the Site Health check to indicate it is a Yoast SEO Site Health Check.
         */
        protected function add_yoast_signature()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Represents the health check for the cURL version.
     */
    class WPSEO_Health_Check_Curl_Version extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-curl-version';
        /**
         * Runs the test.
         *
         * @return void
         */
        public function run()
        {
        }
        /**
         * Gets the current cURL version.
         *
         * @return string|bool The cURL version as a string or false if cURL is not installed.
         */
        protected function get_curl_version()
        {
        }
        /**
         * Checks if the cURL version is a recent one.
         *
         * @return bool Whether the cURL version is a recent one.
         */
        protected function is_recent_curl_version()
        {
        }
        /**
         * Checks whether Yoast SEO Premium or premium add-ons are installed.
         *
         * @return bool Whether Yoast SEO Premium or premium add-ons are installed.
         */
        protected function has_premium_plugins_installed()
        {
        }
        /**
         * Checks whether the MyYoast API is reachable.
         *
         * @return bool Whether the MyYoast API is reachable.
         */
        protected function is_my_yoast_api_reachable()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Represents the health check for the default tagline.
     */
    class WPSEO_Health_Check_Default_Tagline extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-default-tagline';
        /**
         * Runs the test.
         */
        public function run()
        {
        }
        /**
         * Returns whether or not the site has the default tagline.
         *
         * @return bool
         */
        public function has_default_tagline()
        {
        }
    }
    /**
     * Represents the health check when the links table is not accessible.
     */
    class WPSEO_Health_Check_Link_Table_Not_Accessible extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-links-table-not-accessible';
        /**
         * Runs the test.
         */
        public function run()
        {
        }
        /**
         * Checks whether the text link counter feature is enabled.
         *
         * @return bool Whether the text link counter feature is enabled.
         */
        protected function is_text_link_counter_enabled()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Represents the health check for paginated comments.
     */
    class WPSEO_Health_Check_Page_Comments extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-page-comments';
        /**
         * Runs the test.
         */
        public function run()
        {
        }
        /**
         * Are page comments enabled.
         *
         * @return bool True when page comments are enabled.
         */
        protected function has_page_comments()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     */
    /**
     * Represents the health check for the postname in the permalink.
     */
    class WPSEO_Health_Check_Postname_Permalink extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-postname-permalink';
        /**
         * Runs the test.
         */
        public function run()
        {
        }
        /**
         * Check if the permalink uses %postname%.
         *
         * @return bool
         */
        private function has_postname_in_permalink()
        {
        }
    }
    /**
     * Represents the health check for Ryte.
     */
    class WPSEO_Health_Check_Ryte extends \WPSEO_Health_Check
    {
        /**
         * The name of the test.
         *
         * @var string
         */
        protected $test = 'yoast-health-check-ryte';
        /**
         * Runs the test.
         *
         * @return void
         */
        public function run()
        {
        }
        /**
         * Checks whether the Ryte Site Health check should run.
         *
         * Checks for the WordPress environment type, checks if Ryte integration is
         * enabled, the blog is public, and the Yoast SEO environment is not development mode.
         *
         * @return bool Whether the Ryte Site Health check should run.
         */
        protected function should_run()
        {
        }
        /**
         * Checks if debug mode is on but Yoast development mode is not on (i.e. for non-Yoast developers).
         *
         * @return bool True when debug mode is on and Yoast development mode is not on.
         */
        protected function is_development_mode()
        {
        }
        /**
         * Returns a new instance of WPSEO_Ryte_Option.
         *
         * @return WPSEO_Ryte_Option New Ryte Option.
         */
        protected function get_ryte_option()
        {
        }
        /**
         * Adds the content for a failed Ryte API request.
         *
         * @param array $response The error details.
         *
         * @return void
         */
        protected function response_error($response)
        {
        }
        /**
         * Adds the content for the "Cannot be indexed" response.
         *
         * @return void
         */
        protected function is_not_indexable_response()
        {
        }
        /**
         * Adds the content for the "Cannot tell if it can be indexed" response.
         *
         * @return void
         */
        protected function unknown_indexability_response()
        {
        }
        /**
         * Adds the content for the "Can be indexed" response.
         *
         * @return void
         */
        protected function is_indexable_response()
        {
        }
        /**
         * Adds the link to the Ryte site to the actions.
         *
         * @return void
         */
        protected function add_ryte_link()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals
     * @since   5.9.0
     */
    /**
     * Group of language utility methods for use by WPSEO.
     * All methods are static, this is just a sort of namespacing class wrapper.
     */
    class WPSEO_Language_Utils
    {
        /**
         * Returns the language part of a given locale, defaults to english when the $locale is empty.
         *
         * @param string|null $locale The locale to get the language of.
         *
         * @return string The language part of the locale.
         */
        public static function get_language($locale = \null)
        {
        }
        /**
         * Returns the user locale for the language to be used in the admin.
         *
         * WordPress 4.7 introduced the ability for users to specify an Admin language
         * different from the language used on the front end. This checks if the feature
         * is available and returns the user's language, with a fallback to the site's language.
         * Can be removed when support for WordPress 4.6 will be dropped, in favor
         * of WordPress get_user_locale() that already fallbacks to the site's locale.
         *
         * @deprecated 15.6
         * @codeCoverageIgnore
         *
         * @return string The locale.
         */
        public static function get_user_locale()
        {
        }
        /**
         * Returns the full name for the sites' language.
         *
         * @return string The language name.
         */
        public static function get_site_language_name()
        {
        }
        /**
         * Returns the l10n array for the knowledge graph company info missing.
         *
         * @return array The l10n array.
         */
        public static function get_knowledge_graph_company_info_missing_l10n()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * This abstract class and it's concrete classes implement defaults and value validation for
     * all WPSEO options and subkeys within options.
     *
     * Some guidelines:
     * [Retrieving options]
     * - Use the normal get_option() to retrieve an option. You will receive a complete array for the option.
     *   Any subkeys which were not set, will have their default values in place.
     * - In other words, you will normally not have to check whether a subkey isset() as they will *always* be set.
     *   They will also *always* be of the correct variable type.
     *   The only exception to this are the options with variable option names based on post_type or taxonomy
     *   as those will not always be available before the taxonomy/post_type is registered.
     *   (they will be available if a value was set, they won't be if it wasn't as the class won't know
     *   that a default needs to be injected).
     *
     * [Updating/Adding options]
     * - For multisite site_options, please use the WPSEO_Options::update_site_option() method.
     * - For normal options, use the normal add/update_option() functions. As long a the classes here
     *   are instantiated, validation for all options and their subkeys will be automatic.
     * - On (succesfull) update of a couple of options, certain related actions will be run automatically.
     *   Some examples:
     *   - on change of wpseo[yoast_tracking], the cron schedule will be adjusted accordingly
     *   - on change of wpseo and wpseo_title, some caches will be cleared
     *
     * [Important information about add/updating/changing these classes]
     * - Make sure that option array key names are unique across options. The WPSEO_Options::get_all()
     *   method merges most options together. If any of them have non-unique names, even if they
     *   are in a different option, they *will* overwrite each other.
     * - When you add a new array key in an option: make sure you add proper defaults and add the key
     *   to the validation routine in the proper place or add a new validation case.
     *   You don't need to do any upgrading as any option returned will always be merged with the
     *   defaults, so new options will automatically be available.
     *   If the default value is a string which need translating, add this to the concrete class
     *   translate_defaults() method.
     * - When you remove an array key from an option: if it's important that the option is really removed,
     *   add the WPSEO_Option::clean_up( $option_name ) method to the upgrade run.
     *   This will re-save the option and automatically remove the array key no longer in existance.
     * - When you rename a sub-option: add it to the clean_option() routine and run that in the upgrade run.
     * - When you change the default for an option sub-key, make sure you verify that the validation routine will
     *   still work the way it should.
     *   Example: changing a default from '' (empty string) to 'text' with a validation routine with tests
     *   for an empty string will prevent a user from saving an empty string as the real value. So the
     *   test for '' with the validation routine would have to be removed in that case.
     * - If an option needs specific actions different from defined in this abstract class, you can just overrule
     *   a method by defining it in the concrete class.
     *
     * @todo [JRF => testers] Double check that validation will not cause errors when called
     *       from upgrade routine (some of the WP functions may not yet be available).
     */
    abstract class WPSEO_Option
    {
        /**
         * Prefix for override option keys that allow or disallow the option key of the same name.
         *
         * @var string
         */
        const ALLOW_KEY_PREFIX = 'allow_';
        /**
         * Option name - MUST be set in concrete class and set to public.
         *
         * @var string
         */
        protected $option_name;
        /**
         * Option group name for use in settings forms.
         *
         * Will be set automagically if not set in concrete class (i.e.
         * if it confirm to the normal pattern 'yoast' . $option_name . 'options',
         * only set in conrete class if it doesn't).
         *
         * @var string
         */
        public $group_name;
        /**
         * Whether to include the option in the return for WPSEO_Options::get_all().
         *
         * Also determines which options are copied over for ms_(re)set_blog().
         *
         * @var bool
         */
        public $include_in_all = \true;
        /**
         * Whether this option is only for when the install is multisite.
         *
         * @var bool
         */
        public $multisite_only = \false;
        /**
         * Array of defaults for the option - MUST be set in concrete class.
         *
         * Shouldn't be requested directly, use $this->get_defaults();
         *
         * @var array
         */
        protected $defaults;
        /**
         * Array of variable option name patterns for the option - if any -.
         *
         * Set this when the option contains array keys which vary based on post_type
         * or taxonomy.
         *
         * @var array
         */
        protected $variable_array_key_patterns;
        /**
         * Array of sub-options which should not be overloaded with multi-site defaults.
         *
         * @var array
         */
        public $ms_exclude = [];
        /**
         * Name for an option higher in the hierarchy to override setting access.
         *
         * @var string
         */
        protected $override_option_name;
        /**
         * Instance of this class.
         *
         * @var WPSEO_Option
         */
        protected static $instance;
        /* *********** INSTANTIATION METHODS *********** */
        /**
         * Add all the actions and filters for the option.
         */
        protected function __construct()
        {
        }
        /*
         * All concrete classes *must* contain the get_instance method.
         *
         * {@internal Unfortunately I can't define it as an abstract as it also *has* to be static...}}
         *
         * ```
         * abstract protected static function get_instance();
         * ```
         * ---------------
         *
         * Concrete classes *may* contain a translate_defaults method.
         * ```
         * abstract public function translate_defaults();
         * ```
         * ---------------
         *
         * Concrete classes *may* contain a enrich_defaults method to add additional defaults once
         * all post_types and taxonomies have been registered.
         *
         * ```
         * abstract public function enrich_defaults();
         * ```
         */
        /* *********** METHODS INFLUENCING get_option() *********** */
        /**
         * Add filters to make sure that the option default is returned if the option is not set.
         *
         * @return void
         */
        public function add_default_filters()
        {
        }
        /**
         * Adds back the default filters that were removed during validation if the option was changed.
         * Checks if this option was changed to prevent constantly checking if filters are present.
         *
         * @param string $option_name The option name.
         *
         * @return void
         */
        public function add_default_filters_if_same_option($option_name)
        {
        }
        /**
         * Adds back the default filters that were removed during validation if the option was not changed.
         * This is because in that case the latter actions are not called and thus the filters are never
         * added back.
         *
         * @param mixed  $value       The current value.
         * @param string $option_name The option name.
         * @param mixed  $old_value   The old value.
         *
         * @return string The current value.
         */
        public function add_default_filters_if_not_changed($value, $option_name, $old_value)
        {
        }
        /**
         * Validate webmaster tools & Pinterest verification strings.
         *
         * @param string $key   Key to check, by type of service.
         * @param array  $dirty Dirty data with the new values.
         * @param array  $old   Old data.
         * @param array  $clean Clean data by reference, normally the default values.
         */
        public function validate_verification_string($key, $dirty, $old, &$clean)
        {
        }
        /**
         * Validates an option as a valid URL. Prints out a WordPress settings error
         * notice if the URL is invalid.
         *
         * @param string $key   Key to check, by type of URL setting.
         * @param array  $dirty Dirty data with the new values.
         * @param array  $old   Old data.
         * @param array  $clean Clean data by reference, normally the default values.
         */
        public function validate_url($key, $dirty, $old, &$clean)
        {
        }
        /**
         * Validates a Facebook App ID.
         *
         * @deprecated 15.5
         * @codeCoverageIgnore
         *
         * @param string $key   Key to check, in this case: the Facebook App ID field name.
         * @param array  $dirty Dirty data with the new values.
         * @param array  $old   Old data.
         * @param array  $clean Clean data by reference, normally the default values.
         */
        public function validate_facebook_app_id($key, $dirty, $old, &$clean)
        {
        }
        /**
         * Remove the default filters.
         * Called from the validate() method to prevent failure to add new options.
         *
         * @return void
         */
        public function remove_default_filters()
        {
        }
        /**
         * Get the enriched default value for an option.
         *
         * Checks if the concrete class contains an enrich_defaults() method and if so, runs it.
         *
         * {@internal The enrich_defaults method is used to set defaults for variable array keys
         *            in an option, such as array keys depending on post_types and/or taxonomies.}}
         *
         * @return array
         */
        public function get_defaults()
        {
        }
        /**
         * Add filters to make sure that the option is merged with its defaults before being returned.
         *
         * @return void
         */
        public function add_option_filters()
        {
        }
        /**
         * Remove the option filters.
         * Called from the clean_up methods to make sure we retrieve the original old option.
         *
         * @return void
         */
        public function remove_option_filters()
        {
        }
        /**
         * Merge an option with its default values.
         *
         * This method should *not* be called directly!!! It is only meant to filter the get_option() results.
         *
         * @param mixed $options Option value.
         *
         * @return mixed Option merged with the defaults for that option.
         */
        public function get_option($options = \null)
        {
        }
        /* *********** METHODS influencing add_uption(), update_option() and saving from admin pages. *********** */
        /**
         * Register (whitelist) the option for the configuration pages.
         * The validation callback is already registered separately on the sanitize_option hook,
         * so no need to double register.
         *
         * @return void
         */
        public function register_setting()
        {
        }
        /**
         * Validate the option
         *
         * @param mixed $option_value The unvalidated new value for the option.
         *
         * @return array Validated new value for the option.
         */
        public function validate($option_value)
        {
        }
        /**
         * Checks whether a specific option key is disabled.
         *
         * This is determined by whether an override option is available with a key that equals the given key prefixed
         * with 'allow_'.
         *
         * @param string $key Option key.
         *
         * @return bool True if option key is disabled, false otherwise.
         */
        public function is_disabled($key)
        {
        }
        /**
         * All concrete classes must contain a validate_option() method which validates all
         * values within the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         */
        protected abstract function validate_option($dirty, $clean, $old);
        /* *********** METHODS for ADDING/UPDATING/UPGRADING the option. *********** */
        /**
         * Retrieve the real old value (unmerged with defaults).
         *
         * @return array|bool The original option value (which can be false if the option doesn't exist).
         */
        protected function get_original_option()
        {
        }
        /**
         * Add the option if it doesn't exist for some strange reason.
         *
         * @uses WPSEO_Option::get_original_option()
         *
         * @return void
         */
        public function maybe_add_option()
        {
        }
        /**
         * Update a site_option.
         *
         * {@internal This special method is only needed for multisite options, but very needed indeed there.
         *            The order in which certain functions and hooks are run is different between
         *            get_option() and get_site_option() which means in practice that the removing
         *            of the default filters would be done too late and the re-adding of the default
         *            filters might not be done at all.
         *            Aka: use the WPSEO_Options::update_site_option() method (which calls this method)
         *            for safely adding/updating multisite options.}}
         *
         * @param mixed $value The new value for the option.
         *
         * @return bool Whether the update was succesfull.
         */
        public function update_site_option($value)
        {
        }
        /**
         * Retrieve the real old value (unmerged with defaults), clean and re-save the option.
         *
         * @uses WPSEO_Option::get_original_option()
         * @uses WPSEO_Option::import()
         *
         * @param string|null $current_version Optional. Version from which to upgrade, if not set,
         *                                     version specific upgrades will be disregarded.
         *
         * @return void
         */
        public function clean($current_version = \null)
        {
        }
        /**
         * Clean and re-save the option.
         *
         * @uses clean_option() method from concrete class if it exists.
         *
         * @todo [JRF/whomever] Figure out a way to show settings error during/after the upgrade - maybe
         * something along the lines of:
         * -> add them to a property in this class
         * -> if that property isset at the end of the routine and add_settings_error function does not exist,
         *    save as transient (or update the transient if one already exists)
         * -> next time an admin is in the WP back-end, show the errors and delete the transient or only delete it
         *    once the admin has dismissed the message (add ajax function)
         * Important: all validation routines which add_settings_errors would need to be changed for this to work
         *
         * @param array       $option_value          Option value to be imported.
         * @param string|null $current_version       Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         * @param array|null  $all_old_option_values Optional. Only used when importing old options to
         *                                           have access to the real old values, in contrast to
         *                                           the saved ones.
         *
         * @return void
         */
        public function import($option_value, $current_version = \null, $all_old_option_values = \null)
        {
        }
        /**
         * Returns the variable array key patterns for an options class.
         *
         * @return array
         */
        public function get_patterns()
        {
        }
        /**
         * Retrieves the option name.
         *
         * @return string The set option name.
         */
        public function get_option_name()
        {
        }
        /*
         * Concrete classes *may* contain a clean_option method which will clean out old/renamed
         * values within the option.
         *
         * ```
         * abstract public function clean_option( $option_value, $current_version = null, $all_old_option_values = null );
         * ```
         */
        /* *********** HELPER METHODS for internal use. *********** */
        /**
         * Helper method - Combines a fixed array of default values with an options array
         * while filtering out any keys which are not in the defaults array.
         *
         * @todo [JRF] - shouldn't this be a straight array merge ? at the end of the day, the validation
         * removes any invalid keys on save.
         *
         * @param array|null $options Optional. Current options. If not set, the option defaults
         *                            for the $option_key will be returned.
         *
         * @return array Combined and filtered options array.
         */
        protected function array_filter_merge($options = \null)
        {
        }
        /**
         * Sets updated values for variables that are disabled via the override option back to their previous values.
         *
         * @param array $updated Updated option value.
         * @param array $old     Old option value.
         *
         * @return array Updated option value, with all disabled variables set to their old values.
         */
        protected function prevent_disabled_options_update($updated, $old)
        {
        }
        /**
         * Retrieves the value of the override option, if available.
         *
         * An override option contains values that may determine access to certain sub-variables
         * of this option.
         *
         * Only regular options in multisite can have override options, which in that case
         * would be network options.
         *
         * @return array Override option value, or empty array if unavailable.
         */
        protected function get_override_option()
        {
        }
        /**
         * Make sure that any set option values relating to post_types and/or taxonomies are retained,
         * even when that post_type or taxonomy may not yet have been registered.
         *
         * {@internal The wpseo_titles concrete class overrules this method. Make sure that any
         *            changes applied here, also get ported to that version.}}
         *
         * @param array $dirty Original option as retrieved from the database.
         * @param array $clean Filtered option where any options which shouldn't be in our option
         *                     have already been removed and any options which weren't set
         *                     have been set to their defaults.
         *
         * @return array
         */
        protected function retain_variable_keys($dirty, $clean)
        {
        }
        /**
         * Check whether a given array key conforms to one of the variable array key patterns for this option.
         *
         * @usedby validate_option() methods for options with variable array keys.
         *
         * @param string $key Array key to check.
         *
         * @return string Pattern if it conforms, original array key if it doesn't or if the option
         *                does not have variable array keys.
         */
        protected function get_switch_key($key)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * Site option for Multisite installs only
     *
     * Overloads a number of methods of the abstract class to ensure the use of the correct site_option
     * WP functions.
     */
    class WPSEO_Option_MS extends \WPSEO_Option
    {
        /**
         * Option name.
         *
         * @var string
         */
        public $option_name = 'wpseo_ms';
        /**
         * Option group name for use in settings forms.
         *
         * @var string
         */
        public $group_name = 'yoast_wpseo_multisite_options';
        /**
         * Whether to include the option in the return for WPSEO_Options::get_all().
         *
         * @var bool
         */
        public $include_in_all = \false;
        /**
         * Whether this option is only for when the install is multisite.
         *
         * @var bool
         */
        public $multisite_only = \true;
        /**
         * Array of defaults for the option.
         *
         * Shouldn't be requested directly, use $this->get_defaults();
         *
         * @var array
         */
        protected $defaults = [];
        /**
         * Available options for the 'access' setting. Used for input validation.
         *
         * {@internal Important: Make sure the options added to the array here are in line
         *            with the keys for the options set for the select box in the
         *            admin/pages/network.php file.}}
         *
         * @var array
         */
        public static $allowed_access_options = ['admin', 'superadmin'];
        /**
         * Get the singleton instance of this class.
         *
         * @return object
         */
        public static function get_instance()
        {
        }
        /**
         * Only run parent constructor in multisite context.
         */
        public function __construct()
        {
        }
        /**
         * Add filters to make sure that the option default is returned if the option is not set
         *
         * @return void
         */
        public function add_default_filters()
        {
        }
        /**
         * Remove the default filters.
         * Called from the validate() method to prevent failure to add new options.
         *
         * @return void
         */
        public function remove_default_filters()
        {
        }
        /**
         * Add filters to make sure that the option is merged with its defaults before being returned.
         *
         * @return void
         */
        public function add_option_filters()
        {
        }
        /**
         * Remove the option filters.
         * Called from the clean_up methods to make sure we retrieve the original old option.
         *
         * @return void
         */
        public function remove_option_filters()
        {
        }
        /* *********** METHODS influencing add_uption(), update_option() and saving from admin pages *********** */
        /**
         * Validate the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         *
         * @return array Validated clean value for the option to be saved to the database.
         */
        protected function validate_option($dirty, $clean, $old)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * Option: wpseo_social.
     */
    class WPSEO_Option_Social extends \WPSEO_Option
    {
        /**
         * Option name.
         *
         * @var string
         */
        public $option_name = 'wpseo_social';
        /**
         * Array of defaults for the option.
         *
         * Shouldn't be requested directly, use $this->get_defaults();
         *
         * @var array
         */
        protected $defaults = [
            // Form fields.
            'facebook_site' => '',
            // Text field.
            'instagram_url' => '',
            'linkedin_url' => '',
            'myspace_url' => '',
            'og_default_image' => '',
            // Text field.
            'og_default_image_id' => '',
            'og_frontpage_title' => '',
            // Text field.
            'og_frontpage_desc' => '',
            // Text field.
            'og_frontpage_image' => '',
            // Text field.
            'og_frontpage_image_id' => '',
            'opengraph' => \true,
            'pinterest_url' => '',
            'pinterestverify' => '',
            'twitter' => \true,
            'twitter_site' => '',
            // Text field.
            'twitter_card_type' => 'summary_large_image',
            'youtube_url' => '',
            'wikipedia_url' => '',
        ];
        /**
         * Array of sub-options which should not be overloaded with multi-site defaults.
         *
         * @var array
         */
        public $ms_exclude = [
            /* Privacy. */
            'pinterestverify',
        ];
        /**
         * Array of allowed twitter card types.
         *
         * While we only have the options summary and summary_large_image in the
         * interface now, we might change that at some point.
         *
         * {@internal Uncomment any of these to allow them in validation *and* automatically
         *            add them as a choice in the options page.}}
         *
         * @var array
         */
        public static $twitter_card_types = ['summary' => '', 'summary_large_image' => ''];
        /**
         * Add the actions and filters for the option.
         */
        protected function __construct()
        {
        }
        /**
         * Get the singleton instance of this class.
         *
         * @return object
         */
        public static function get_instance()
        {
        }
        /**
         * Translate/set strings used in the option defaults.
         *
         * @return void
         */
        public function translate_defaults()
        {
        }
        /**
         * Validate the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         *
         * @return array Validated clean value for the option to be saved to the database.
         */
        protected function validate_option($dirty, $clean, $old)
        {
        }
        /**
         * Clean a given option value.
         *
         * @param array       $option_value          Old (not merged with defaults or filtered) option value to
         *                                           clean according to the rules for this option.
         * @param string|null $current_version       Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         * @param array|null  $all_old_option_values Optional. Only used when importing old options to have
         *                                           access to the real old values, in contrast to the saved ones.
         *
         * @return array Cleaned option.
         */
        protected function clean_option($option_value, $current_version = \null, $all_old_option_values = \null)
        {
        }
    }
    /**
     * Option: wpseo_titles.
     */
    class WPSEO_Option_Titles extends \WPSEO_Option
    {
        /**
         * Option name.
         *
         * @var string
         */
        public $option_name = 'wpseo_titles';
        /**
         * Array of defaults for the option.
         *
         * Shouldn't be requested directly, use $this->get_defaults();
         *
         * {@internal Note: Some of the default values are added via the translate_defaults() method.}}
         *
         * @var array
         */
        protected $defaults = [
            // Form fields.
            'forcerewritetitle' => \false,
            'separator' => 'sc-dash',
            'title-home-wpseo' => '%%sitename%% %%page%% %%sep%% %%sitedesc%%',
            // Text field.
            'title-author-wpseo' => '',
            // Text field.
            'title-archive-wpseo' => '%%date%% %%page%% %%sep%% %%sitename%%',
            // Text field.
            'title-search-wpseo' => '',
            // Text field.
            'title-404-wpseo' => '',
            // Text field.
            'social-title-author-wpseo' => '%%name%%',
            // Text field.
            'social-title-archive-wpseo' => '%%date%%',
            // Text field.
            'social-description-author-wpseo' => '',
            // Text area.
            'social-description-archive-wpseo' => '',
            // Text area.
            'social-image-url-author-wpseo' => '',
            // Hidden input field.
            'social-image-url-archive-wpseo' => '',
            // Hidden input field.
            'social-image-id-author-wpseo' => 0,
            // Hidden input field.
            'social-image-id-archive-wpseo' => 0,
            // Hidden input field.
            'metadesc-home-wpseo' => '',
            // Text area.
            'metadesc-author-wpseo' => '',
            // Text area.
            'metadesc-archive-wpseo' => '',
            // Text area.
            'rssbefore' => '',
            // Text area.
            'rssafter' => '',
            // Text area.
            'noindex-author-wpseo' => \false,
            'noindex-author-noposts-wpseo' => \true,
            'noindex-archive-wpseo' => \true,
            'disable-author' => \false,
            'disable-date' => \false,
            'disable-post_format' => \false,
            'disable-attachment' => \true,
            'breadcrumbs-404crumb' => '',
            // Text field.
            'breadcrumbs-display-blog-page' => \true,
            'breadcrumbs-boldlast' => \false,
            'breadcrumbs-archiveprefix' => '',
            // Text field.
            'breadcrumbs-enable' => \true,
            'breadcrumbs-home' => '',
            // Text field.
            'breadcrumbs-prefix' => '',
            // Text field.
            'breadcrumbs-searchprefix' => '',
            // Text field.
            'breadcrumbs-sep' => '&raquo;',
            // Text field.
            'website_name' => '',
            'person_name' => '',
            'person_logo' => '',
            'person_logo_id' => 0,
            'alternate_website_name' => '',
            'company_logo' => '',
            'company_logo_id' => 0,
            'company_logo_meta' => \false,
            'person_logo_meta' => \false,
            'company_name' => '',
            'company_or_person' => 'company',
            'company_or_person_user_id' => \false,
            'stripcategorybase' => \false,
            'open_graph_frontpage_title' => '%%sitename%%',
            // Text field.
            'open_graph_frontpage_desc' => '',
            // Text field.
            'open_graph_frontpage_image' => '',
            // Text field.
            'open_graph_frontpage_image_id' => 0,
        ];
        /**
         * Used for "caching" during pageload.
         *
         * @var array
         */
        protected $enriched_defaults = \null;
        /**
         * Array of variable option name patterns for the option.
         *
         * @var array
         */
        protected $variable_array_key_patterns = ['title-', 'metadesc-', 'noindex-', 'display-metabox-pt-', 'bctitle-ptarchive-', 'post_types-', 'taxonomy-', 'schema-page-type-', 'schema-article-type-', 'social-title-', 'social-description-', 'social-image-url-', 'social-image-id-'];
        /**
         * Array of sub-options which should not be overloaded with multi-site defaults.
         *
         * @var array
         */
        public $ms_exclude = ['forcerewritetitle'];
        /**
         * Add the actions and filters for the option.
         *
         * @todo [JRF => testers] Check if the extra actions below would run into problems if an option
         * is updated early on and if so, change the call to schedule these for a later action on add/update
         * instead of running them straight away.
         */
        protected function __construct()
        {
        }
        /**
         * Make sure we can recognize the right action for the double cleaning.
         */
        public function end_of_init()
        {
        }
        /**
         * Get the singleton instance of this class.
         *
         * @return self
         */
        public static function get_instance()
        {
        }
        /**
         * Get the available separator options.
         *
         * @return array
         */
        public function get_separator_options()
        {
        }
        /**
         * Get the available separator options aria-labels.
         *
         * @return array Array with the separator options aria-labels.
         */
        public function get_separator_options_for_display()
        {
        }
        /**
         * Translate strings used in the option defaults.
         *
         * @return void
         */
        public function translate_defaults()
        {
        }
        /**
         * Add dynamically created default options based on available post types and taxonomies.
         *
         * @return  void
         */
        public function enrich_defaults()
        {
        }
        /**
         * Invalidates enrich_defaults() cache.
         *
         * Called from actions:
         * - (un)registered_post_type
         * - (un)registered_taxonomy
         *
         * @return void
         */
        public function invalidate_enrich_defaults_cache()
        {
        }
        /**
         * Validate the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         *
         * @return array Validated clean value for the option to be saved to the database.
         */
        protected function validate_option($dirty, $clean, $old)
        {
        }
        /**
         * Retrieve a list of the allowed post types as breadcrumb parent for a taxonomy.
         * Helper method for validation.
         *
         * {@internal Don't make static as new types may still be registered.}}
         *
         * @return array
         */
        protected function get_allowed_post_types()
        {
        }
        /**
         * Clean a given option value.
         *
         * @param array       $option_value          Old (not merged with defaults or filtered) option value to
         *                                           clean according to the rules for this option.
         * @param string|null $current_version       Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         * @param array|null  $all_old_option_values Optional. Only used when importing old options to have
         *                                           access to the real old values, in contrast to the saved ones.
         *
         * @return array Cleaned option.
         */
        protected function clean_option($option_value, $current_version = \null, $all_old_option_values = \null)
        {
        }
        /**
         * Make sure that any set option values relating to post_types and/or taxonomies are retained,
         * even when that post_type or taxonomy may not yet have been registered.
         *
         * {@internal Overrule the abstract class version of this to make sure one extra renamed
         *            variable key does not get removed. IMPORTANT: keep this method in line with
         *            the parent on which it is based!}}
         *
         * @param array $dirty Original option as retrieved from the database.
         * @param array $clean Filtered option where any options which shouldn't be in our option
         *                     have already been removed and any options which weren't set
         *                     have been set to their defaults.
         *
         * @return array
         */
        protected function retain_variable_keys($dirty, $clean)
        {
        }
        /**
         * Retrieves a list of separator options.
         *
         * @return array An array of the separator options.
         */
        protected static function get_separator_option_list()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * Option: wpseo.
     */
    class WPSEO_Option_Wpseo extends \WPSEO_Option
    {
        /**
         * Option name.
         *
         * @var string
         */
        public $option_name = 'wpseo';
        /**
         * Array of defaults for the option.
         *
         * {@internal Shouldn't be requested directly, use $this->get_defaults();}}
         *
         * @var array
         */
        protected $defaults = [
            // Non-form fields, set via (ajax) function.
            'tracking' => \null,
            'license_server_version' => \false,
            'ms_defaults_set' => \false,
            'ignore_search_engines_discouraged_notice' => \false,
            'indexing_first_time' => \true,
            'indexing_started' => \null,
            'indexing_reason' => '',
            'indexables_indexing_completed' => \false,
            // Non-form field, should only be set via validation routine.
            'version' => '',
            // Leave default as empty to ensure activation/upgrade works.
            'previous_version' => '',
            // Form fields.
            'disableadvanced_meta' => \true,
            'enable_headless_rest_endpoints' => \true,
            'ryte_indexability' => \true,
            'baiduverify' => '',
            // Text field.
            'googleverify' => '',
            // Text field.
            'msverify' => '',
            // Text field.
            'yandexverify' => '',
            'site_type' => '',
            // List of options.
            'has_multiple_authors' => '',
            'environment_type' => '',
            'content_analysis_active' => \true,
            'keyword_analysis_active' => \true,
            'enable_admin_bar_menu' => \true,
            'enable_cornerstone_content' => \true,
            'enable_xml_sitemap' => \true,
            'enable_text_link_counter' => \true,
            'show_onboarding_notice' => \false,
            'first_activated_on' => \false,
            'myyoast-oauth' => ['config' => ['clientId' => \null, 'secret' => \null], 'access_tokens' => []],
            'semrush_integration_active' => \true,
            'semrush_tokens' => [],
            'semrush_country_code' => 'us',
            'permalink_structure' => '',
            'home_url' => '',
            'dynamic_permalinks' => \false,
            'category_base_url' => '',
            'tag_base_url' => '',
            'custom_taxonomy_slugs' => [],
            'enable_enhanced_slack_sharing' => \true,
            'zapier_integration_active' => \false,
            'zapier_subscription' => [],
            'zapier_api_key' => '',
            'enable_metabox_insights' => \true,
            'enable_link_suggestions' => \true,
            'algolia_integration_active' => \false,
        ];
        /**
         * Sub-options which should not be overloaded with multi-site defaults.
         *
         * @var array
         */
        public $ms_exclude = [
            'ignore_search_engines_discouraged_notice',
            /* Privacy. */
            'baiduverify',
            'googleverify',
            'msverify',
            'yandexverify',
        ];
        /**
         * Possible values for the site_type option.
         *
         * @var array
         */
        protected $site_types = ['', 'blog', 'shop', 'news', 'smallBusiness', 'corporateOther', 'personalOther'];
        /**
         * Possible environment types.
         *
         * @var array
         */
        protected $environment_types = ['', 'production', 'staging', 'development'];
        /**
         * Possible has_multiple_authors options.
         *
         * @var array
         */
        protected $has_multiple_authors_options = ['', \true, \false];
        /**
         * Name for an option higher in the hierarchy to override setting access.
         *
         * @var string
         */
        protected $override_option_name = 'wpseo_ms';
        /**
         * Add the actions and filters for the option.
         *
         * @todo [JRF => testers] Check if the extra actions below would run into problems if an option
         *       is updated early on and if so, change the call to schedule these for a later action on add/update
         *       instead of running them straight away.
         */
        protected function __construct()
        {
        }
        /**
         * Get the singleton instance of this class.
         *
         * @return object
         */
        public static function get_instance()
        {
        }
        /**
         * Add filters to make sure that the option is merged with its defaults before being returned.
         *
         * @return void
         */
        public function add_option_filters()
        {
        }
        /**
         * Remove the option filters.
         * Called from the clean_up methods to make sure we retrieve the original old option.
         *
         * @return void
         */
        public function remove_option_filters()
        {
        }
        /**
         * Add filters to make sure that the option default is returned if the option is not set.
         *
         * @return void
         */
        public function add_default_filters()
        {
        }
        /**
         * Remove the default filters.
         * Called from the validate() method to prevent failure to add new options.
         *
         * @return void
         */
        public function remove_default_filters()
        {
        }
        /**
         * Validate the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         *
         * @return array Validated clean value for the option to be saved to the database.
         */
        protected function validate_option($dirty, $clean, $old)
        {
        }
        /**
         * Verifies that the feature variables are turned off if the network is configured so.
         *
         * @param mixed $options Value of the option to be returned. Typically an array.
         *
         * @return mixed Filtered $options value.
         */
        public function verify_features_against_network($options = [])
        {
        }
        /**
         * Gets the filter hook name and callback for adjusting the retrieved option value
         * against the network-allowed features.
         *
         * @return array Array where the first item is the hook name, the second is the hook callback,
         *               and the third is the hook priority.
         */
        protected function get_verify_features_option_filter_hook()
        {
        }
        /**
         * Gets the filter hook name and callback for adjusting the default option value against the network-allowed features.
         *
         * @return array Array where the first item is the hook name, the second is the hook callback,
         *               and the third is the hook priority.
         */
        protected function get_verify_features_default_option_filter_hook()
        {
        }
        /**
         * Clean a given option value.
         *
         * @param array       $option_value          Old (not merged with defaults or filtered) option value to
         *                                           clean according to the rules for this option.
         * @param string|null $current_version       Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         * @param array|null  $all_old_option_values Optional. Only used when importing old options to have
         *                                           access to the real old values, in contrast to the saved ones.
         *
         * @return array Cleaned option.
         */
        protected function clean_option($option_value, $current_version = \null, $all_old_option_values = \null)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * Overall Option Management class.
     *
     * Instantiates all the options and offers a number of utility methods to work with the options.
     */
    class WPSEO_Options
    {
        /**
         * The option values.
         *
         * @var null
         */
        protected static $option_values = \null;
        /**
         * Options this class uses.
         *
         * @var array Array format: (string) option_name  => (string) name of concrete class for the option.
         */
        public static $options = ['wpseo' => 'WPSEO_Option_Wpseo', 'wpseo_titles' => 'WPSEO_Option_Titles', 'wpseo_social' => 'WPSEO_Option_Social', 'wpseo_ms' => 'WPSEO_Option_MS', 'wpseo_taxonomy_meta' => 'WPSEO_Taxonomy_Meta'];
        /**
         * Array of instantiated option objects.
         *
         * @var array
         */
        protected static $option_instances = [];
        /**
         * Array with the option names.
         *
         * @var array
         */
        protected static $option_names = [];
        /**
         * Instance of this class.
         *
         * @var WPSEO_Options
         */
        protected static $instance;
        /**
         * Instantiate all the WPSEO option management classes.
         */
        protected function __construct()
        {
        }
        /**
         * Register our hooks.
         */
        public function register_hooks()
        {
        }
        /**
         * Get the singleton instance of this class.
         *
         * @return object
         */
        public static function get_instance()
        {
        }
        /**
         * Registers an option to the options list.
         *
         * @param WPSEO_Option $option_instance Instance of the option.
         */
        public static function register_option(\WPSEO_Option $option_instance)
        {
        }
        /**
         * Get the group name of an option for use in the settings form.
         *
         * @param string $option_name The option for which you want to retrieve the option group name.
         *
         * @return string|bool
         */
        public static function get_group_name($option_name)
        {
        }
        /**
         * Get a specific default value for an option.
         *
         * @param string $option_name The option for which you want to retrieve a default.
         * @param string $key         The key within the option who's default you want.
         *
         * @return mixed
         */
        public static function get_default($option_name, $key)
        {
        }
        /**
         * Update a site_option.
         *
         * @param string $option_name The option name of the option to save.
         * @param mixed  $value       The new value for the option.
         *
         * @return bool
         */
        public static function update_site_option($option_name, $value)
        {
        }
        /**
         * Get the instantiated option instance.
         *
         * @param string $option_name The option for which you want to retrieve the instance.
         *
         * @return object|bool
         */
        public static function get_option_instance($option_name)
        {
        }
        /**
         * Retrieve an array of the options which should be included in get_all() and reset().
         *
         * @return array Array of option names.
         */
        public static function get_option_names()
        {
        }
        /**
         * Retrieve all the options for the SEO plugin in one go.
         *
         * @return array Array combining the values of all the options.
         */
        public static function get_all()
        {
        }
        /**
         * Retrieve one or more options for the SEO plugin.
         *
         * @param array $option_names An array of option names of the options you want to get.
         *
         * @return array Array combining the values of the requested options.
         */
        public static function get_options(array $option_names)
        {
        }
        /**
         * Retrieve a single option for the SEO plugin.
         *
         * @param string $option_name The name of the option you want to get.
         *
         * @return array Array containing the requested option.
         */
        public static function get_option($option_name)
        {
        }
        /**
         * Retrieve a single field from any option for the SEO plugin. Keys are always unique.
         *
         * @param string $key     The key it should return.
         * @param mixed  $default The default value that should be returned if the key isn't set.
         *
         * @return mixed|null Returns value if found, $default if not.
         */
        public static function get($key, $default = \null)
        {
        }
        /**
         * Resets the cache to null.
         */
        public static function clear_cache()
        {
        }
        /**
         * Primes our cache.
         */
        private static function prime_cache()
        {
        }
        /**
         * Retrieve a single field from an option for the SEO plugin.
         *
         * @param string $key   The key to set.
         * @param mixed  $value The value to set.
         *
         * @return mixed|null Returns value if found, $default if not.
         */
        public static function set($key, $value)
        {
        }
        /**
         * Get an option only if it's been auto-loaded.
         *
         * @param string     $option  The option to retrieve.
         * @param bool|mixed $default A default value to return.
         *
         * @return bool|mixed
         */
        public static function get_autoloaded_option($option, $default = \false)
        {
        }
        /**
         * Run the clean up routine for one or all options.
         *
         * @param array|string|null $option_name     Optional. the option you want to clean or an array of
         *                                           option names for the options you want to clean.
         *                                           If not set, all options will be cleaned.
         * @param string|null       $current_version Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         *
         * @return void
         */
        public static function clean_up($option_name = \null, $current_version = \null)
        {
        }
        /**
         * Check that all options exist in the database and add any which don't.
         *
         * @return void
         */
        public static function ensure_options_exist()
        {
        }
        /**
         * Initialize some options on first install/activate/reset.
         *
         * @return void
         */
        public static function initialize()
        {
        }
        /**
         * Reset all options to their default values and rerun some tests.
         *
         * @return void
         */
        public static function reset()
        {
        }
        /**
         * Initialize default values for a new multisite blog.
         *
         * @param bool $force_init Whether to always do the initialization routine (title/desc test).
         *
         * @return void
         */
        public static function maybe_set_multisite_defaults($force_init = \false)
        {
        }
        /**
         * Reset all options for a specific multisite blog to their default values based upon a
         * specified default blog if one was chosen on the network page or the plugin defaults if it was not.
         *
         * @param int|string $blog_id Blog id of the blog for which to reset the options.
         *
         * @return void
         */
        public static function reset_ms_blog($blog_id)
        {
        }
        /**
         * Saves the option to the database.
         *
         * @param string $wpseo_options_group_name The name for the wpseo option group in the database.
         * @param string $option_name              The name for the option to set.
         * @param mixed  $option_value             The value for the option.
         *
         * @return bool Returns true if the option is successfully saved in the database.
         */
        public static function save_option($wpseo_options_group_name, $option_name, $option_value)
        {
        }
        /**
         * Adds the multisite options to the option stack if relevant.
         *
         * @param array $option The currently present options settings.
         *
         * @return array Options possibly including multisite.
         */
        protected static function add_ms_option($option)
        {
        }
        /**
         * Checks if installation is multisite.
         *
         * @return bool True when is multisite.
         */
        protected static function is_multisite()
        {
        }
        /**
         * Retrieves a lookup table to find in which option_group a key is stored.
         *
         * @return array The lookup table.
         */
        private static function get_lookup_table()
        {
        }
        /**
         * Retrieves a lookup table to find in which option_group a key is stored.
         *
         * @return array The lookup table.
         */
        private static function get_pattern_table()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Internals\Options
     */
    /**
     * Option: wpseo_taxonomy_meta.
     */
    class WPSEO_Taxonomy_Meta extends \WPSEO_Option
    {
        /**
         * Option name.
         *
         * @var string
         */
        public $option_name = 'wpseo_taxonomy_meta';
        /**
         * Whether to include the option in the return for WPSEO_Options::get_all().
         *
         * @var bool
         */
        public $include_in_all = \false;
        /**
         * Array of defaults for the option.
         *
         * Shouldn't be requested directly, use $this->get_defaults();
         *
         * {@internal Important: in contrast to most defaults, the below array format is
         *            very bare. The real option is in the format [taxonomy_name][term_id][...]
         *            where [...] is any of the $defaults_per_term options shown below.
         *            This is of course taken into account in the below methods.}}
         *
         * @var array
         */
        protected $defaults = [];
        /**
         * Option name - same as $option_name property, but now also available to static methods.
         *
         * @var string
         */
        public static $name;
        /**
         * Array of defaults for individual taxonomy meta entries.
         *
         * @var array
         */
        public static $defaults_per_term = [
            'wpseo_title' => '',
            'wpseo_desc' => '',
            'wpseo_canonical' => '',
            'wpseo_bctitle' => '',
            'wpseo_noindex' => 'default',
            'wpseo_focuskw' => '',
            'wpseo_linkdex' => '',
            'wpseo_content_score' => '',
            'wpseo_focuskeywords' => '[]',
            'wpseo_keywordsynonyms' => '[]',
            'wpseo_is_cornerstone' => '0',
            // Social fields.
            'wpseo_opengraph-title' => '',
            'wpseo_opengraph-description' => '',
            'wpseo_opengraph-image' => '',
            'wpseo_opengraph-image-id' => '',
            'wpseo_twitter-title' => '',
            'wpseo_twitter-description' => '',
            'wpseo_twitter-image' => '',
            'wpseo_twitter-image-id' => '',
        ];
        /**
         * Available index options.
         *
         * Used for form generation and input validation.
         *
         * {@internal Labels (translation) added on admin_init via WPSEO_Taxonomy::translate_meta_options().}}
         *
         * @var array
         */
        public static $no_index_options = ['default' => '', 'index' => '', 'noindex' => ''];
        /**
         * Add the actions and filters for the option.
         *
         * @todo [JRF => testers] Check if the extra actions below would run into problems if an option
         * is updated early on and if so, change the call to schedule these for a later action on add/update
         * instead of running them straight away.
         */
        protected function __construct()
        {
        }
        /**
         * Get the singleton instance of this class.
         *
         * @return object
         */
        public static function get_instance()
        {
        }
        /**
         * Add extra default options received from a filter.
         */
        public function enrich_defaults()
        {
        }
        /**
         * Validate the option.
         *
         * @param array $dirty New value for the option.
         * @param array $clean Clean value for the option, normally the defaults.
         * @param array $old   Old value of the option.
         *
         * @return array Validated clean value for the option to be saved to the database.
         */
        protected function validate_option($dirty, $clean, $old)
        {
        }
        /**
         * Validate the meta data for one individual term and removes default values (no need to save those).
         *
         * @param array $meta_data New values.
         * @param array $old_meta  The original values.
         *
         * @return array Validated and filtered value.
         */
        public static function validate_term_meta_data($meta_data, $old_meta)
        {
        }
        /**
         * Clean a given option value.
         * - Convert old option values to new
         * - Fixes strings which were escaped (should have been sanitized - escaping is for output)
         *
         * @param array       $option_value          Old (not merged with defaults or filtered) option value to
         *                                           clean according to the rules for this option.
         * @param string|null $current_version       Optional. Version from which to upgrade, if not set,
         *                                           version specific upgrades will be disregarded.
         * @param array|null  $all_old_option_values Optional. Only used when importing old options to have
         *                                           access to the real old values, in contrast to the saved ones.
         *
         * @return array Cleaned option.
         */
        protected function clean_option($option_value, $current_version = \null, $all_old_option_values = \null)
        {
        }
        /**
         * Retrieve a taxonomy term's meta value(s).
         *
         * @param mixed       $term     Term to get the meta value for
         *                              either (string) term name, (int) term id or (object) term.
         * @param string      $taxonomy Name of the taxonomy to which the term is attached.
         * @param string|null $meta     Optional. Meta value to get (without prefix).
         *
         * @return mixed|bool Value for the $meta if one is given, might be the default.
         *                    If no meta is given, an array of all the meta data for the term.
         *                    False if the term does not exist or the $meta provided is invalid.
         */
        public static function get_term_meta($term, $taxonomy, $meta = \null)
        {
        }
        /**
         * Get the current queried object and return the meta value.
         *
         * @param string $meta The meta field that is needed.
         *
         * @return bool|mixed
         */
        public static function get_meta_without_term($meta)
        {
        }
        /**
         * Saving the values for the given term_id.
         *
         * @param int    $term_id     ID of the term to save data for.
         * @param string $taxonomy    The taxonomy the term belongs to.
         * @param array  $meta_values The values that will be saved.
         */
        public static function set_values($term_id, $taxonomy, array $meta_values)
        {
        }
        /**
         * Setting a single value to the term meta.
         *
         * @param int    $term_id    ID of the term to save data for.
         * @param string $taxonomy   The taxonomy the term belongs to.
         * @param string $meta_key   The target meta key to store the value in.
         * @param string $meta_value The value of the target meta key.
         */
        public static function set_value($term_id, $taxonomy, $meta_key, $meta_value)
        {
        }
        /**
         * Find the keyword usages in the metas for the taxonomies/terms.
         *
         * @param string $keyword          The keyword to look for.
         * @param string $current_term_id  The current term id.
         * @param string $current_taxonomy The current taxonomy name.
         *
         * @return array
         */
        public static function get_keyword_usage($keyword, $current_term_id, $current_taxonomy)
        {
        }
        /**
         * Saving the values for the given term_id.
         *
         * @param int    $term_id  ID of the term to save data for.
         * @param string $taxonomy The taxonomy the term belongs to.
         * @param array  $clean    Array with clean values.
         */
        private static function save_clean_values($term_id, $taxonomy, array $clean)
        {
        }
        /**
         * Getting the meta from the options.
         *
         * @return void|array
         */
        private static function get_tax_meta()
        {
        }
        /**
         * Saving the tax meta values to the database.
         *
         * @param array $tax_meta Array with the meta values for taxonomy.
         */
        private static function save_tax_meta($tax_meta)
        {
        }
        /**
         * Getting the taxonomy meta for the given term_id and taxonomy.
         *
         * @param int    $term_id  The id of the term.
         * @param string $taxonomy Name of the taxonomy to which the term is attached.
         *
         * @return array
         */
        private static function get_term_tax_meta($term_id, $taxonomy)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Sitemap Provider interface.
     */
    interface WPSEO_Sitemap_Provider
    {
        /**
         * Check if provider supports given item type.
         *
         * @param string $type Type string to check for.
         *
         * @return bool
         */
        public function handles_type($type);
        /**
         * Get set of sitemaps index link data.
         *
         * @param int $max_entries Entries per sitemap.
         *
         * @return array
         */
        public function get_index_links($max_entries);
        /**
         * Get set of sitemap link data.
         *
         * @param string $type         Sitemap type.
         * @param int    $max_entries  Entries per sitemap.
         * @param int    $current_page Current page of the sitemap.
         *
         * @return array
         */
        public function get_sitemap_links($type, $max_entries, $current_page);
    }
    /**
     * Sitemap provider for author archives.
     */
    class WPSEO_Author_Sitemap_Provider implements \WPSEO_Sitemap_Provider
    {
        /**
         * Check if provider supports given item type.
         *
         * @param string $type Type string to check for.
         *
         * @return bool
         */
        public function handles_type($type)
        {
        }
        /**
         * Get the links for the sitemap index.
         *
         * @param int $max_entries Entries per sitemap.
         *
         * @return array
         */
        public function get_index_links($max_entries)
        {
        }
        /**
         * Retrieve users, taking account of all necessary exclusions.
         *
         * @param array $arguments Arguments to add.
         *
         * @return array
         */
        protected function get_users($arguments = [])
        {
        }
        /**
         * Get set of sitemap link data.
         *
         * @param string $type         Sitemap type.
         * @param int    $max_entries  Entries per sitemap.
         * @param int    $current_page Current page of the sitemap.
         *
         * @return array
         *
         * @throws OutOfBoundsException When an invalid page is requested.
         */
        public function get_sitemap_links($type, $max_entries, $current_page)
        {
        }
        /**
         * Update any users that don't have last profile update timestamp.
         *
         * @return int Count of users updated.
         */
        protected function update_user_meta()
        {
        }
        /**
         * Wrap legacy filter to deduplicate calls.
         *
         * @param array $users Array of user objects to filter.
         *
         * @return array
         */
        protected function exclude_users($users)
        {
        }
    }
    /**
     * Sitemap provider for author archives.
     */
    class WPSEO_Post_Type_Sitemap_Provider implements \WPSEO_Sitemap_Provider
    {
        /**
         * Holds image parser instance.
         *
         * @var WPSEO_Sitemap_Image_Parser
         */
        protected static $image_parser;
        /**
         * Holds the parsed home url.
         *
         * @var array
         */
        protected static $parsed_home_url;
        /**
         * Determines whether images should be included in the XML sitemap.
         *
         * @var bool
         */
        private $include_images;
        /**
         * Set up object properties for data reuse.
         */
        public function __construct()
        {
        }
        /**
         * Get the Image Parser.
         *
         * @return WPSEO_Sitemap_Image_Parser
         */
        protected function get_image_parser()
        {
        }
        /**
         * Gets the parsed home url.
         *
         * @return array The home url, as parsed by wp_parse_url.
         */
        protected function get_parsed_home_url()
        {
        }
        /**
         * Check if provider supports given item type.
         *
         * @param string $type Type string to check for.
         *
         * @return bool
         */
        public function handles_type($type)
        {
        }
        /**
         * Retrieves the sitemap links.
         *
         * @param int $max_entries Entries per sitemap.
         *
         * @return array
         */
        public function get_index_links($max_entries)
        {
        }
        /**
         * Get set of sitemap link data.
         *
         * @param string $type         Sitemap type.
         * @param int    $max_entries  Entries per sitemap.
         * @param int    $current_page Current page of the sitemap.
         *
         * @return array
         *
         * @throws OutOfBoundsException When an invalid page is requested.
         */
        public function get_sitemap_links($type, $max_entries, $current_page)
        {
        }
        /**
         * Check for relevant post type before invalidation.
         *
         * @param int $post_id Post ID to possibly invalidate for.
         */
        public function save_post($post_id)
        {
        }
        /**
         * Check if post type should be present in sitemaps.
         *
         * @param string $post_type Post type string to check for.
         *
         * @return bool
         */
        public function is_valid_post_type($post_type)
        {
        }
        /**
         * Retrieves a list with the excluded post ids.
         *
         * @param string $post_type Post type.
         *
         * @return array Array with post ids to exclude.
         */
        protected function get_excluded_posts($post_type)
        {
        }
        /**
         * Get count of posts for post type.
         *
         * @param string $post_type Post type to retrieve count for.
         *
         * @return int
         */
        protected function get_post_type_count($post_type)
        {
        }
        /**
         * Produces set of links to prepend at start of first sitemap page.
         *
         * @param string $post_type Post type to produce links for.
         *
         * @return array
         */
        protected function get_first_links($post_type)
        {
        }
        /**
         * Get URL for a post type archive.
         *
         * @since 5.3
         *
         * @param string $post_type Post type.
         *
         * @return string|bool URL or false if it should be excluded.
         */
        protected function get_post_type_archive_link($post_type)
        {
        }
        /**
         * Determines whether a post type archive is indexable.
         *
         * @since 11.5
         *
         * @param string $post_type       Post type.
         * @param int    $archive_page_id The page id.
         *
         * @return bool True when post type archive is indexable.
         */
        protected function is_post_type_archive_indexable($post_type, $archive_page_id = -1)
        {
        }
        /**
         * Retrieve set of posts with optimized query routine.
         *
         * @param string $post_type Post type to retrieve.
         * @param int    $count     Count of posts to retrieve.
         * @param int    $offset    Starting offset.
         *
         * @return object[]
         */
        protected function get_posts($post_type, $count, $offset)
        {
        }
        /**
         * Constructs an SQL where clause for a given post type.
         *
         * @param string $post_type Post type slug.
         *
         * @return string
         */
        protected function get_sql_where_clause($post_type)
        {
        }
        /**
         * Produce array of URL parts for given post object.
         *
         * @param object $post Post object to get URL parts for.
         *
         * @return array|bool
         */
        protected function get_url($post)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Cache Data interface.
     */
    interface WPSEO_Sitemap_Cache_Data_Interface
    {
        /**
         * Status for normal, usable sitemap.
         *
         * @var string
         */
        const OK = 'ok';
        /**
         * Status for unusable sitemap.
         *
         * @var string
         */
        const ERROR = 'error';
        /**
         * Status for unusable sitemap because it cannot be identified.
         *
         * @var string
         */
        const UNKNOWN = 'unknown';
        /**
         * Set the content of the sitemap.
         *
         * @param string $sitemap The XML content of the sitemap.
         *
         * @return void
         */
        public function set_sitemap($sitemap);
        /**
         * Set the status of the sitemap.
         *
         * @param bool|string $usable True/False or 'ok'/'error' for status.
         *
         * @return void
         */
        public function set_status($usable);
        /**
         * Builds the sitemap.
         *
         * @return string The XML content of the sitemap.
         */
        public function get_sitemap();
        /**
         * Get the status of this sitemap.
         *
         * @return string Status 'ok', 'error' or 'unknown'.
         */
        public function get_status();
        /**
         * Is the sitemap content usable ?
         *
         * @return bool True if the sitemap is usable, False if not.
         */
        public function is_usable();
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Sitemap Cache Data object, manages sitemap data stored in cache.
     */
    class WPSEO_Sitemap_Cache_Data implements \Serializable, \WPSEO_Sitemap_Cache_Data_Interface
    {
        /**
         * Sitemap XML data.
         *
         * @var string
         */
        private $sitemap = '';
        /**
         * Status of the sitemap, usable or not.
         *
         * @var string
         */
        private $status = self::UNKNOWN;
        /**
         * Set the sitemap XML data
         *
         * @param string $sitemap XML Content of the sitemap.
         */
        public function set_sitemap($sitemap)
        {
        }
        /**
         * Set the status of the sitemap, is it usable.
         *
         * @param bool|string $valid Is the sitemap valid or not.
         *
         * @return void
         */
        public function set_status($valid)
        {
        }
        /**
         * Is the sitemap usable.
         *
         * @return bool True if usable, False if bad or unknown.
         */
        public function is_usable()
        {
        }
        /**
         * Get the XML content of the sitemap.
         *
         * @return string The content of the sitemap.
         */
        public function get_sitemap()
        {
        }
        /**
         * Get the status of the sitemap.
         *
         * @return string Status of the sitemap, 'ok'/'error'/'unknown'.
         */
        public function get_status()
        {
        }
        /**
         * String representation of object.
         *
         * @link http://php.net/manual/en/serializable.serialize.php
         *
         * @since 5.1.0
         *
         * @return string The string representation of the object or null.
         */
        public function serialize()
        {
        }
        /**
         * Constructs the object.
         *
         * @link http://php.net/manual/en/serializable.unserialize.php
         *
         * @since 5.1.0
         *
         * @param string $serialized The string representation of the object.
         *
         * @return void
         */
        public function unserialize($serialized)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Parses images from the given post.
     */
    class WPSEO_Sitemap_Image_Parser
    {
        /**
         * Holds the home_url() value to speed up loops.
         *
         * @var string
         */
        protected $home_url = '';
        /**
         * Holds site URL hostname.
         *
         * @var string
         */
        protected $host = '';
        /**
         * Holds site URL protocol.
         *
         * @var string
         */
        protected $scheme = 'http';
        /**
         * Cached set of attachments for multiple posts.
         *
         * @var array
         */
        protected $attachments = [];
        /**
         * Holds blog charset value for use in DOM parsing.
         *
         * @var string
         */
        protected $charset = 'UTF-8';
        /**
         * Set up URL properties for reuse.
         */
        public function __construct()
        {
        }
        /**
         * Get set of image data sets for the given post.
         *
         * @param object $post Post object to get images for.
         *
         * @return array
         */
        public function get_images($post)
        {
        }
        /**
         * Get the images in the term description.
         *
         * @param object $term Term to get images from description for.
         *
         * @return array
         */
        public function get_term_images($term)
        {
        }
        /**
         * Parse `<img />` tags in content.
         *
         * @param string $content Content string to parse.
         *
         * @return array
         */
        private function parse_html_images($content)
        {
        }
        /**
         * Parse gallery shortcodes in a given content.
         *
         * @param string $content Content string.
         * @param int    $post_id Optional. ID of post being parsed.
         *
         * @return array Set of attachment objects.
         */
        protected function parse_galleries($content, $post_id = 0)
        {
        }
        /**
         * Retrieves galleries from the passed content.
         *
         * Forked from core to skip executing shortcodes for performance.
         *
         * @param string $content Content to parse for shortcodes.
         *
         * @return array A list of arrays, each containing gallery data.
         */
        protected function get_content_galleries($content)
        {
        }
        /**
         * Get image item array with filters applied.
         *
         * @param WP_Post $post  Post object for the context.
         * @param string  $src   Image URL.
         * @param string  $title Optional image title.
         * @param string  $alt   Optional image alt text.
         *
         * @return array
         */
        protected function get_image_item($post, $src, $title = '', $alt = '')
        {
        }
        /**
         * Get attached image URL with filters applied. Adapted from core for speed.
         *
         * @param int $post_id ID of the post.
         *
         * @return string
         */
        private function image_url($post_id)
        {
        }
        /**
         * Make absolute URL for domain or protocol-relative one.
         *
         * @param string $src URL to process.
         *
         * @return string
         */
        protected function get_absolute_url($src)
        {
        }
        /**
         * Returns the attachments for a gallery.
         *
         * @param int   $id      The post ID.
         * @param array $gallery The gallery config.
         *
         * @return array The selected attachments.
         */
        protected function get_gallery_attachments($id, $gallery)
        {
        }
        /**
         * Returns the attachments for the given ID.
         *
         * @param int   $id      The post ID.
         * @param array $gallery The gallery config.
         *
         * @return array The selected attachments.
         */
        protected function get_gallery_attachments_for_parent($id, $gallery)
        {
        }
        /**
         * Returns an array with attachments for the post IDs that will be included.
         *
         * @param array $include Array with IDs to include.
         *
         * @return array The found attachments.
         */
        protected function get_gallery_attachments_for_included($include)
        {
        }
        /**
         * Returns the attachments.
         *
         * @param array $args Array with query args.
         *
         * @return array The found attachments.
         */
        protected function get_attachments($args)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\Admin\XML Sitemaps
     */
    /**
     * Class that handles the Admin side of XML sitemaps.
     */
    class WPSEO_Sitemaps_Admin
    {
        /**
         * Post_types that are being imported.
         *
         * @var array
         */
        private $importing_post_types = [];
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Hooked into transition_post_status. Will initiate search engine pings
         * if the post is being published, is a post type that a sitemap is built for
         * and is a post that is included in sitemaps.
         *
         * @param string   $new_status New post status.
         * @param string   $old_status Old post status.
         * @param \WP_Post $post       Post object.
         */
        public function status_transition($new_status, $old_status, $post)
        {
        }
        /**
         * While bulk importing, just save unique post_types.
         *
         * When importing is done, if we have a post_type that is saved in the sitemap
         * try to ping the search engines.
         *
         * @param string   $new_status New post status.
         * @param string   $old_status Old post status.
         * @param \WP_Post $post       Post object.
         */
        private function status_transition_bulk($new_status, $old_status, $post)
        {
        }
        /**
         * After import finished, walk through imported post_types and update info.
         */
        public function status_transition_bulk_finished()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Handles storage keys for sitemaps caching and invalidation.
     *
     * @since 3.2
     */
    class WPSEO_Sitemaps_Cache_Validator
    {
        /**
         * Prefix of the transient key for sitemap caches.
         *
         * @var string
         */
        const STORAGE_KEY_PREFIX = 'yst_sm_';
        /**
         * Name of the option that holds the global validation value.
         *
         * @var string
         */
        const VALIDATION_GLOBAL_KEY = 'wpseo_sitemap_cache_validator_global';
        /**
         * The format which creates the key of the option that holds the type validation value.
         *
         * @var string
         */
        const VALIDATION_TYPE_KEY_FORMAT = 'wpseo_sitemap_%s_cache_validator';
        /**
         * Get the cache key for a certain type and page.
         *
         * A type of cache would be something like 'page', 'post' or 'video'.
         *
         * Example key format for sitemap type "post", page 1: wpseo_sitemap_post_1:akfw3e_23azBa .
         *
         * @since 3.2
         *
         * @param string|null $type The type to get the key for. Null or self::SITEMAP_INDEX_TYPE for index cache.
         * @param int         $page The page of cache to get the key for.
         *
         * @return bool|string The key where the cache is stored on. False if the key could not be generated.
         */
        public static function get_storage_key($type = \null, $page = 1)
        {
        }
        /**
         * If the type is over length make sure we compact it so we don't have any database problems.
         *
         * When there are more 'extremely long' post types, changes are they have variations in either the start or ending.
         * Because of this, we cut out the excess in the middle which should result in less chance of collision.
         *
         * @since 3.2
         *
         * @param string $type    The type of sitemap to be used.
         * @param string $prefix  The part before the type in the cache key. Only the length is used.
         * @param string $postfix The part after the type in the cache key. Only the length is used.
         *
         * @return string The type with a safe length to use
         *
         * @throws OutOfRangeException When there is less than 15 characters of space for a key that is originally longer.
         */
        public static function truncate_type($type, $prefix = '', $postfix = '')
        {
        }
        /**
         * Invalidate sitemap cache.
         *
         * @since 3.2
         *
         * @param string|null $type The type to get the key for. Null for all caches.
         *
         * @return void
         */
        public static function invalidate_storage($type = \null)
        {
        }
        /**
         * Cleanup invalidated database cache.
         *
         * @since 3.2
         *
         * @param string|null $type      The type of sitemap to clear cache for.
         * @param string|null $validator The validator to clear cache of.
         *
         * @return void
         */
        public static function cleanup_database($type = \null, $validator = \null)
        {
        }
        /**
         * Get the current cache validator.
         *
         * Without the type the global validator is returned.
         * This can invalidate -all- keys in cache at once.
         *
         * With the type parameter the validator for that specific type can be invalidated.
         *
         * @since 3.2
         *
         * @param string $type Provide a type for a specific type validator, empty for global validator.
         *
         * @return string|null The validator for the supplied type.
         */
        public static function get_validator($type = '')
        {
        }
        /**
         * Get the cache validator option key for the specified type.
         *
         * @since 3.2
         *
         * @param string $type Provide a type for a specific type validator, empty for global validator.
         *
         * @return string Validator to be used to generate the cache key.
         */
        public static function get_validator_key($type = '')
        {
        }
        /**
         * Refresh the cache validator value.
         *
         * @since 3.2
         *
         * @param string $type Provide a type for a specific type validator, empty for global validator.
         *
         * @return bool True if validator key has been saved as option.
         */
        public static function create_validator($type = '')
        {
        }
        /**
         * Encode to base61 format.
         *
         * This is base64 (numeric + alpha + alpha upper case) without the 0.
         *
         * @since 3.2
         *
         * @param int $base10 The number that has to be converted to base 61.
         *
         * @return string Base 61 converted string.
         *
         * @throws InvalidArgumentException When the input is not an integer.
         */
        public static function convert_base10_to_base61($base10)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Handles sitemaps caching and invalidation.
     *
     * @since 3.2
     */
    class WPSEO_Sitemaps_Cache
    {
        /**
         * Holds the options that, when updated, should cause the cache to clear.
         *
         * @var array
         */
        protected static $cache_clear = [];
        /**
         * Mirror of enabled status for static calls.
         *
         * @var bool
         */
        protected static $is_enabled = \false;
        /**
         * Holds the flag to clear all cache.
         *
         * @var bool
         */
        protected static $clear_all = \false;
        /**
         * Holds the array of types to clear.
         *
         * @var array
         */
        protected static $clear_types = [];
        /**
         * Hook methods for invalidation on necessary events.
         */
        public function __construct()
        {
        }
        /**
         * Setup context for static calls.
         */
        public function init()
        {
        }
        /**
         * If cache is enabled.
         *
         * @since 3.2
         *
         * @return bool
         */
        public function is_enabled()
        {
        }
        /**
         * Retrieve the sitemap page from cache.
         *
         * @since 3.2
         *
         * @param string $type Sitemap type.
         * @param int    $page Page number to retrieve.
         *
         * @return string|bool
         */
        public function get_sitemap($type, $page)
        {
        }
        /**
         * Get the sitemap that is cached.
         *
         * @param string $type Sitemap type.
         * @param int    $page Page number to retrieve.
         *
         * @return WPSEO_Sitemap_Cache_Data|null Null on no cache found otherwise object containing sitemap and meta data.
         */
        public function get_sitemap_data($type, $page)
        {
        }
        /**
         * Store the sitemap page from cache.
         *
         * @since 3.2
         *
         * @param string $type    Sitemap type.
         * @param int    $page    Page number to store.
         * @param string $sitemap Sitemap body to store.
         * @param bool   $usable  Is this a valid sitemap or a cache of an invalid sitemap.
         *
         * @return bool
         */
        public function store_sitemap($type, $page, $sitemap, $usable = \true)
        {
        }
        /**
         * Delete cache transients for index and specific type.
         *
         * Always deletes the main index sitemaps cache, as that's always invalidated by any other change.
         *
         * @since 1.5.4
         * @since 3.2   Changed from function wpseo_invalidate_sitemap_cache() to method in this class.
         *
         * @param string $type Sitemap type to invalidate.
         *
         * @return void
         */
        public static function invalidate($type)
        {
        }
        /**
         * Helper to invalidate in hooks where type is passed as second argument.
         *
         * @since 3.2
         *
         * @param int    $unused Unused term ID value.
         * @param string $type   Taxonomy to invalidate.
         *
         * @return void
         */
        public static function invalidate_helper($unused, $type)
        {
        }
        /**
         * Invalidate sitemap cache for authors.
         *
         * @param int $user_id User ID.
         *
         * @return bool True if the sitemap was properly invalidated. False otherwise.
         */
        public static function invalidate_author($user_id)
        {
        }
        /**
         * Invalidate sitemap cache for the post type of a post.
         *
         * Don't invalidate for revisions.
         *
         * @since 1.5.4
         * @since 3.2   Changed from function wpseo_invalidate_sitemap_cache_on_save_post() to method in this class.
         *
         * @param int $post_id Post ID to invalidate type for.
         *
         * @return void
         */
        public static function invalidate_post($post_id)
        {
        }
        /**
         * Delete cache transients for given sitemaps types or all by default.
         *
         * @since 1.8.0
         * @since 3.2   Moved from WPSEO_Utils to this class.
         *
         * @param array $types Set of sitemap types to delete cache transients for.
         *
         * @return void
         */
        public static function clear($types = [])
        {
        }
        /**
         * Invalidate storage for cache types queued to clear.
         */
        public static function clear_queued()
        {
        }
        /**
         * Adds a hook that when given option is updated, the cache is cleared.
         *
         * @since 3.2
         *
         * @param string $option Option name.
         * @param string $type   Sitemap type.
         */
        public static function register_clear_on_option_update($option, $type = '')
        {
        }
        /**
         * Clears the transient cache when a given option is updated, if that option has been registered before.
         *
         * @since 3.2
         *
         * @param string $option The option name that's being updated.
         *
         * @return void
         */
        public static function clear_on_option_update($option)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Renders XML output for sitemaps.
     */
    class WPSEO_Sitemaps_Renderer
    {
        /**
         * XSL stylesheet for styling a sitemap for web browsers.
         *
         * @var string
         */
        protected $stylesheet = '';
        /**
         * Holds the get_bloginfo( 'charset' ) value to reuse for performance.
         *
         * @var string
         */
        protected $charset = 'UTF-8';
        /**
         * Holds charset of output, might be converted.
         *
         * @var string
         */
        protected $output_charset = 'UTF-8';
        /**
         * If data encoding needs to be converted for output.
         *
         * @var bool
         */
        protected $needs_conversion = \false;
        /**
         * Set up object properties.
         */
        public function __construct()
        {
        }
        /**
         * Builds the sitemap index.
         *
         * @param array $links Set of sitemaps index links.
         *
         * @return string
         */
        public function get_index($links)
        {
        }
        /**
         * Builds the sitemap.
         *
         * @param array  $links        Set of sitemap links.
         * @param string $type         Sitemap type.
         * @param int    $current_page Current sitemap page number.
         *
         * @return string
         */
        public function get_sitemap($links, $type, $current_page)
        {
        }
        /**
         * Produce final XML output with debug information.
         *
         * @param string $sitemap   Sitemap XML.
         * @param bool   $transient Transient cache flag.
         *
         * @return string
         */
        public function get_output($sitemap, $transient)
        {
        }
        /**
         * Get charset for the output.
         *
         * @return string
         */
        public function get_output_charset()
        {
        }
        /**
         * Set a custom stylesheet for this sitemap. Set to empty to just remove the default stylesheet.
         *
         * @param string $stylesheet Full XML-stylesheet declaration.
         */
        public function set_stylesheet($stylesheet)
        {
        }
        /**
         * Build the `<sitemap>` tag for a given URL.
         *
         * @param array $url Array of parts that make up this entry.
         *
         * @return string
         */
        protected function sitemap_index_url($url)
        {
        }
        /**
         * Build the `<url>` tag for a given URL.
         *
         * Public access for backwards compatibility reasons.
         *
         * @param array $url Array of parts that make up this entry.
         *
         * @return string
         */
        public function sitemap_url($url)
        {
        }
        /**
         * Apply some best effort conversion to comply with RFC3986.
         *
         * @param string $url URL to encode.
         *
         * @return string
         */
        protected function encode_url_rfc3986($url)
        {
        }
        /**
         * Retrieves the XSL URL that should be used in the current environment
         *
         * When home_url and site_url are not the same, the home_url should be used.
         * This is because the XSL needs to be served from the same domain, protocol and port
         * as the XML file that is loading it.
         *
         * @return string The XSL URL that needs to be used.
         */
        protected function get_xsl_url()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Rewrite setup and handling for sitemaps functionality.
     */
    class WPSEO_Sitemaps_Router
    {
        /**
         * Sets up init logic.
         */
        public function __construct()
        {
        }
        /**
         * Sets up rewrite rules.
         */
        public function init()
        {
        }
        /**
         * Stop trailing slashes on sitemap.xml URLs.
         *
         * @param string $redirect The redirect URL currently determined.
         *
         * @return bool|string
         */
        public function redirect_canonical($redirect)
        {
        }
        /**
         * Redirects sitemap.xml to sitemap_index.xml.
         */
        public function template_redirect()
        {
        }
        /**
         * Checks whether the current request needs to be redirected to sitemap_index.xml.
         *
         * @global WP_Query $wp_query Current query.
         *
         * @return bool True if redirect is needed, false otherwise.
         */
        public function needs_sitemap_index_redirect()
        {
        }
        /**
         * Create base URL for the sitemap.
         *
         * @param string $page Page to append to the base URL.
         *
         * @return string base URL (incl page)
         */
        public static function get_base_url($page)
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Class WPSEO_Sitemaps.
     *
     * @todo This class could use a general description with some explanation on sitemaps. OR.
     */
    class WPSEO_Sitemaps
    {
        /**
         * Sitemap index identifier.
         *
         * @var string
         */
        const SITEMAP_INDEX_TYPE = '1';
        /**
         * Content of the sitemap to output.
         *
         * @var string
         */
        protected $sitemap = '';
        /**
         * Flag to indicate if this is an invalid or empty sitemap.
         *
         * @var bool
         */
        public $bad_sitemap = \false;
        /**
         * Whether or not the XML sitemap was served from a transient or not.
         *
         * @var bool
         */
        private $transient = \false;
        /**
         * HTTP protocol to use in headers.
         *
         * @since 3.2
         *
         * @var string
         */
        protected $http_protocol = 'HTTP/1.1';
        /**
         * Holds the n variable.
         *
         * @var int
         */
        private $current_page = 1;
        /**
         * The sitemaps router.
         *
         * @since 3.2
         *
         * @var WPSEO_Sitemaps_Router
         */
        public $router;
        /**
         * The sitemap renderer.
         *
         * @since 3.2
         *
         * @var WPSEO_Sitemaps_Renderer
         */
        public $renderer;
        /**
         * The sitemap cache.
         *
         * @since 3.2
         *
         * @var WPSEO_Sitemaps_Cache
         */
        public $cache;
        /**
         * The sitemap providers.
         *
         * @since 3.2
         *
         * @var WPSEO_Sitemap_Provider[]
         */
        public $providers;
        /**
         * Class constructor.
         */
        public function __construct()
        {
        }
        /**
         * Initialize sitemap providers classes.
         *
         * @since 5.3
         */
        public function init_sitemaps_providers()
        {
        }
        /**
         * Check the current request URI, if we can determine it's probably an XML sitemap, kill loading the widgets.
         */
        public function reduce_query_load()
        {
        }
        /**
         * Register your own sitemap. Call this during 'init'.
         *
         * @param string   $name     The name of the sitemap.
         * @param callback $function Function to build your sitemap.
         * @param string   $rewrite  Optional. Regular expression to match your sitemap with.
         */
        public function register_sitemap($name, $function, $rewrite = '')
        {
        }
        /**
         * Register your own XSL file. Call this during 'init'.
         *
         * @since 1.4.23
         *
         * @param string   $name     The name of the XSL file.
         * @param callback $function Function to build your XSL file.
         * @param string   $rewrite  Optional. Regular expression to match your sitemap with.
         */
        public function register_xsl($name, $function, $rewrite = '')
        {
        }
        /**
         * Set the sitemap current page to allow creating partial sitemaps with WP-CLI
         * in a one-off process.
         *
         * @param int $current_page The part that should be generated.
         */
        public function set_n($current_page)
        {
        }
        /**
         * Set the sitemap content to display after you have generated it.
         *
         * @param string $sitemap The generated sitemap to output.
         */
        public function set_sitemap($sitemap)
        {
        }
        /**
         * Set as true to make the request 404. Used stop the display of empty sitemaps or invalid requests.
         *
         * @param bool $bool Is this a bad request. True or false.
         */
        public function set_bad_sitemap($bool)
        {
        }
        /**
         * Prevent stupid plugins from running shutdown scripts when we're obviously not outputting HTML.
         *
         * @since 1.4.16
         */
        public function sitemap_close()
        {
        }
        /**
         * Hijack requests for potential sitemaps and XSL files.
         *
         * @param \WP_Query $query Main query instance.
         */
        public function redirect($query)
        {
        }
        /**
         * Try to get the sitemap from cache.
         *
         * @param string $type        Sitemap type.
         * @param int    $page_number The page number to retrieve.
         *
         * @return bool If the sitemap has been retrieved from cache.
         */
        private function get_sitemap_from_cache($type, $page_number)
        {
        }
        /**
         * Build and save sitemap to cache.
         *
         * @param string $type        Sitemap type.
         * @param int    $page_number The page number to save to.
         *
         * @return bool
         */
        private function refresh_sitemap_cache($type, $page_number)
        {
        }
        /**
         * Attempts to build the requested sitemap.
         *
         * Sets $bad_sitemap if this isn't for the root sitemap, a post type or taxonomy.
         *
         * @param string $type The requested sitemap's identifier.
         */
        public function build_sitemap($type)
        {
        }
        /**
         * Build the root sitemap (example.com/sitemap_index.xml) which lists sub-sitemaps for other content types.
         */
        public function build_root_map()
        {
        }
        /**
         * Spits out the XSL for the XML sitemap.
         *
         * @since 1.4.13
         *
         * @param string $type Type to output.
         */
        public function xsl_output($type)
        {
        }
        /**
         * Spit out the generated sitemap.
         */
        public function output()
        {
        }
        /**
         * Makes a request to the sitemap index to cache it before the arrival of the search engines.
         *
         * @return void
         */
        public function hit_sitemap_index()
        {
        }
        /**
         * Get the GMT modification date for the last modified post in the post type.
         *
         * @since 3.2
         *
         * @param string|array $post_types Post type or array of types.
         * @param bool         $return_all Flag to return array of values.
         *
         * @return string|array|false
         */
        public static function get_last_modified_gmt($post_types, $return_all = \false)
        {
        }
        /**
         * Get the modification date for the last modified post in the post type.
         *
         * @param array $post_types Post types to get the last modification date for.
         *
         * @return string
         */
        public function get_last_modified($post_types)
        {
        }
        /**
         * Notify search engines of the updated sitemap.
         *
         * @param string|null $url Optional URL to make the ping for.
         */
        public static function ping_search_engines($url = \null)
        {
        }
        /**
         * Get the maximum number of entries per XML sitemap.
         *
         * @return int The maximum number of entries.
         */
        protected function get_entries_per_page()
        {
        }
        /**
         * Get post statuses for post_type or the root sitemap.
         *
         * @since 10.2
         *
         * @param string $type Provide a type for a post_type sitemap, SITEMAP_INDEX_TYPE for the root sitemap.
         *
         * @return array List of post statuses.
         */
        public static function get_post_statuses($type = self::SITEMAP_INDEX_TYPE)
        {
        }
        /**
         * Sends all the required HTTP Headers.
         */
        private function send_headers()
        {
        }
    }
    /**
     * WPSEO plugin file.
     *
     * @package WPSEO\XML_Sitemaps
     */
    /**
     * Sitemap provider for author archives.
     */
    class WPSEO_Taxonomy_Sitemap_Provider implements \WPSEO_Sitemap_Provider
    {
        /**
         * Holds image parser instance.
         *
         * @var WPSEO_Sitemap_Image_Parser
         */
        protected static $image_parser;
        /**
         * Determines whether images should be included in the XML sitemap.
         *
         * @var bool
         */
        private $include_images;
        /**
         * Set up object properties for data reuse.
         */
        public function __construct()
        {
        }
        /**
         * Check if provider supports given item type.
         *
         * @param string $type Type string to check for.
         *
         * @return bool
         */
        public function handles_type($type)
        {
        }
        /**
         * Retrieves the links for the sitemap.
         *
         * @param int $max_entries Entries per sitemap.
         *
         * @return array
         */
        public function get_index_links($max_entries)
        {
        }
        /**
         * Get set of sitemap link data.
         *
         * @param string $type         Sitemap type.
         * @param int    $max_entries  Entries per sitemap.
         * @param int    $current_page Current page of the sitemap.
         *
         * @return array
         *
         * @throws OutOfBoundsException When an invalid page is requested.
         */
        public function get_sitemap_links($type, $max_entries, $current_page)
        {
        }
        /**
         * Check if taxonomy by name is valid to appear in sitemaps.
         *
         * @param string $taxonomy_name Taxonomy name to check.
         *
         * @return bool
         */
        public function is_valid_taxonomy($taxonomy_name)
        {
        }
        /**
         * Get the Image Parser.
         *
         * @return WPSEO_Sitemap_Image_Parser
         */
        protected function get_image_parser()
        {
        }
    }
}
namespace Yoast\WP\Lib {
    /**
     * Abstract class to extend for the main class in a plugin.
     */
    abstract class Abstract_Main
    {
        /**
         * The DI container.
         *
         * @var ContainerInterface|null
         */
        protected $container;
        /**
         * Loads the plugin.
         *
         * @throws Exception If loading fails and YOAST_ENVIRONMENT is development.
         */
        public function load()
        {
        }
        /**
         * Magic getter for retrieving a property.
         *
         * @param string $property The property to retrieve.
         *
         * @return string The value of the property.
         *
         * @throws Exception When the property doesn't exist.
         */
        public function __get($property)
        {
        }
        /**
         * Checks if the given property exists as a surface.
         *
         * @param string $property The property to retrieve.
         *
         * @return bool True when property is set.
         */
        public function __isset($property)
        {
        }
        /**
         * Loads the DI container.
         *
         * @return ContainerInterface|null The DI container.
         *
         * @throws Exception If something goes wrong generating the DI container.
         */
        protected abstract function get_container();
        /**
         * Gets the name of the plugin.
         *
         * @return string The name.
         */
        protected abstract function get_name();
        /**
         * Gets the surfaces of this plugin.
         *
         * @return array A mapping of surface name to the responsible class.
         */
        protected abstract function get_surfaces();
        /**
         * Returns whether or not we're in an environment for Yoast development.
         *
         * @return bool Whether or not to load in development mode.
         */
        protected function is_development()
        {
        }
    }
}
namespace Yoast\WP\Lib\Dependency_Injection {
    /**
     * Container_Registry class.
     */
    class Container_Registry
    {
        /**
         * The registered containers.
         *
         * @var ContainerInterface[]
         */
        private static $containers = [];
        /**
         * Register a container.
         *
         * @param string             $name      The name of the container.
         * @param ContainerInterface $container The container.
         *
         * @return void
         */
        public static function register($name, \YoastSEO_Vendor\Symfony\Component\DependencyInjection\ContainerInterface $container)
        {
        }
        // phpcs:disable Squiz.Commenting.FunctionCommentThrowTag.WrongNumber -- PHPCS doesn't take into account exceptions thrown in called methods.
        /**
         * Get an instance from a specific container.
         *
         * @param string $name              The name of the container.
         * @param string $id                The ID of the service.
         * @param int    $invalid_behaviour The behaviour when the service could not be found.
         *
         * @return object|null The service.
         *
         * @throws ServiceCircularReferenceException When a circular reference is detected.
         * @throws ServiceNotFoundException          When the service is not defined.
         */
        public static function get($name, $id, $invalid_behaviour = 1)
        {
        }
        // phpcs:enable Squiz.Commenting.FunctionCommentThrowTag.WrongNumber
        /**
         * Attempts to find a given service ID in all registered containers.
         *
         * @param string $id The service ID.
         *
         * @return string|null The name of the container if the service was found.
         */
        public static function find($id)
        {
        }
    }
}
namespace Yoast\WP\Lib {
    /**
     * Make Model compatible with WordPress.
     *
     * Model base class. Your model objects should extend
     * this class. A minimal subclass would look like:
     *
     * class Widget extends Model {
     * }
     */
    class Model implements \JsonSerializable
    {
        /**
         * Default ID column for all models. Can be overridden by adding
         * a public static $id_column property to your model classes.
         *
         * @var string
         */
        const DEFAULT_ID_COLUMN = 'id';
        /**
         * Default foreign key suffix used by relationship methods.
         *
         * @var string
         */
        const DEFAULT_FOREIGN_KEY_SUFFIX = '_id';
        /**
         * Set a prefix for model names. This can be a namespace or any other
         * abitrary prefix such as the PEAR naming convention.
         *
         * @example Model::$auto_prefix_models = 'MyProject_MyModels_'; //PEAR
         * @example Model::$auto_prefix_models = '\MyProject\MyModels\'; //Namespaces
         *
         * @var string
         */
        public static $auto_prefix_models = '\\Yoast\\WP\\SEO\\Models\\';
        /**
         * Set true to to ignore namespace information when computing table names
         * from class names.
         *
         * @example Model::$short_table_names = true;
         * @example Model::$short_table_names = false; // default
         *
         * @var bool
         */
        public static $short_table_names = false;
        /**
         * The ORM instance used by this model instance to communicate with the database.
         *
         * @var ORM
         */
        public $orm;
        /**
         * The table name for the implemented Model.
         *
         * @var string
         */
        public static $table;
        /**
         * Whether or not this model uses timestamps.
         *
         * @var bool
         */
        protected $uses_timestamps = false;
        /**
         * Which columns contain boolean values.
         *
         * @var array
         */
        protected $boolean_columns = [];
        /**
         * Which columns contain int values.
         *
         * @var array
         */
        protected $int_columns = [];
        /**
         * Which columns contain float values.
         *
         * @var array
         */
        protected $float_columns = [];
        /**
         * Hacks around the Model to provide WordPress prefix to tables.
         *
         * @param string $class_name   Type of Model to load.
         * @param bool   $yoast_prefix Optional. True to prefix the table name with the Yoast prefix.
         *
         * @return ORM Wrapper to use.
         */
        public static function of_type($class_name, $yoast_prefix = true)
        {
        }
        /**
         * Creates a model without the Yoast prefix.
         *
         * @param string $class_name Type of Model to load.
         *
         * @return ORM
         */
        public static function of_wp_type($class_name)
        {
        }
        /**
         * Exposes method to get the table name to use.
         *
         * @param string $table_name   Simple table name.
         * @param bool   $yoast_prefix Optional. True to prefix the table name with the Yoast prefix.
         *
         * @return string Prepared full table name.
         */
        public static function get_table_name($table_name, $yoast_prefix = true)
        {
        }
        /**
         * Sets the table name for the given class name.
         *
         * @param string $class_name The class to set the table name for.
         *
         * @return void
         */
        protected function set_table_name($class_name)
        {
        }
        /**
         * Retrieve the value of a static property on a class. If the
         * class or the property does not exist, returns the default
         * value supplied as the third argument (which defaults to null).
         *
         * @param string      $class_name The target class name.
         * @param string      $property   The property to get the value for.
         * @param string|null $default    Default value when property does not exist.
         *
         * @return string The value of the property.
         */
        protected static function get_static_property($class_name, $property, $default = null)
        {
        }
        /**
         * Static method to get a table name given a class name.
         * If the supplied class has a public static property
         * named $table, the value of this property will be
         * returned.
         *
         * If not, the class name will be converted using
         * the class_name_to_table_name() method.
         *
         * If Model::$short_table_names == true or public static
         * property $table_use_short_name == true then $class_name passed
         * to class_name_to_table_name() is stripped of namespace information.
         *
         * @param string $class_name The class name to get the table name for.
         *
         * @return string The table name.
         */
        protected static function get_table_name_for_class($class_name)
        {
        }
        /**
         * Should short table names, disregarding class namespaces, be computed?
         *
         * $class_property overrides $global_option, unless $class_property is null.
         *
         * @param string $class_name The class name to get short name for.
         *
         * @return bool True when short table name should be used.
         */
        protected static function use_short_table_name($class_name)
        {
        }
        /**
         * Convert a namespace to the standard PEAR underscore format.
         *
         * Then convert a class name in CapWords to a table name in
         * lowercase_with_underscores.
         *
         * Finally strip doubled up underscores.
         *
         * For example, CarTyre would be converted to car_tyre. And
         * Project\Models\CarTyre would be project_models_car_tyre.
         *
         * @param string $class_name The class name to get the table name for.
         *
         * @return string The table name.
         */
        protected static function class_name_to_table_name($class_name)
        {
        }
        /**
         * Return the ID column name to use for this class. If it is
         * not set on the class, returns null.
         *
         * @param string $class_name The class name to get the ID column for.
         *
         * @return string|null The ID column name.
         */
        protected static function get_id_column_name($class_name)
        {
        }
        /**
         * Build a foreign key based on a table name. If the first argument
         * (the specified foreign key column name) is null, returns the second
         * argument (the name of the table) with the default foreign key column
         * suffix appended.
         *
         * @param string $specified_foreign_key_name The keyname to build.
         * @param string $table_name                 The table name to build the key name for.
         *
         * @return string The built foreign key name.
         */
        protected static function build_foreign_key_name($specified_foreign_key_name, $table_name)
        {
        }
        /**
         * Factory method used to acquire instances of the given class.
         * The class name should be supplied as a string, and the class
         * should already have been loaded by PHP (or a suitable autoloader
         * should exist). This method actually returns a wrapped ORM object
         * which allows a database query to be built. The wrapped ORM object is
         * responsible for returning instances of the correct class when
         * its find_one or find_many methods are called.
         *
         * @param string $class_name The target class name.
         *
         * @return ORM Instance of the ORM wrapper.
         */
        public static function factory($class_name)
        {
        }
        /**
         * Internal method to construct the queries for both the has_one and
         * has_many methods. These two types of association are identical; the
         * only difference is whether find_one or find_many is used to complete
         * the method chain.
         *
         * @param string      $associated_class_name                    The associated class name.
         * @param string|null $foreign_key_name                         The foreign key name in the associated table.
         * @param string|null $foreign_key_name_in_current_models_table The foreign key in the current models table.
         *
         * @return ORM Instance of the ORM.
         *
         * @throws \Exception When ID of current model has a null value.
         */
        protected function has_one_or_many($associated_class_name, $foreign_key_name = null, $foreign_key_name_in_current_models_table = null)
        {
        }
        /**
         * Helper method to manage one-to-one relations where the foreign
         * key is on the associated table.
         *
         * @param string      $associated_class_name                    The associated class name.
         * @param string|null $foreign_key_name                         The foreign key name in the associated table.
         * @param string|null $foreign_key_name_in_current_models_table The foreign key in the current models table.
         *
         * @return ORM Instance of the ORM.
         *
         * @throws \Exception  When ID of current model has a null value.
         */
        protected function has_one($associated_class_name, $foreign_key_name = null, $foreign_key_name_in_current_models_table = null)
        {
        }
        /**
         * Helper method to manage one-to-many relations where the foreign
         * key is on the associated table.
         *
         * @param string      $associated_class_name                    The associated class name.
         * @param string|null $foreign_key_name                         The foreign key name in the associated table.
         * @param string|null $foreign_key_name_in_current_models_table The foreign key in the current models table.
         *
         * @return ORM Instance of the ORM.
         *
         * @throws \Exception When ID has a null value.
         */
        protected function has_many($associated_class_name, $foreign_key_name = null, $foreign_key_name_in_current_models_table = null)
        {
        }
        /**
         * Helper method to manage one-to-one and one-to-many relations where
         * the foreign key is on the base table.
         *
         * @param string      $associated_class_name                       The associated class name.
         * @param string|null $foreign_key_name                            The foreign key in the current models table.
         * @param string|null $foreign_key_name_in_associated_models_table The foreign key in the associated table.
         *
         * @return $this|null Instance of the foreign model.
         */
        protected function belongs_to($associated_class_name, $foreign_key_name = null, $foreign_key_name_in_associated_models_table = null)
        {
        }
        /**
         * Helper method to manage many-to-many relationships via an intermediate model. See
         * README for a full explanation of the parameters.
         *
         * @param string      $associated_class_name   The associated class name.
         * @param string|null $join_class_name         The class name to join.
         * @param string|null $key_to_base_table       The key to the the current models table.
         * @param string|null $key_to_associated_table The key to the associated table.
         * @param string|null $key_in_base_table       The key in the current models table.
         * @param string|null $key_in_associated_table The key in the associated table.
         *
         * @return ORM Instance of the ORM.
         */
        protected function has_many_through($associated_class_name, $join_class_name = null, $key_to_base_table = null, $key_to_associated_table = null, $key_in_base_table = null, $key_in_associated_table = null)
        {
        }
        /**
         * Set the wrapped ORM instance associated with this Model instance.
         *
         * @param ORM $orm The ORM instance to set.
         *
         * @return void
         */
        public function set_orm($orm)
        {
        }
        /**
         * Magic getter method, allows $model->property access to data.
         *
         * @param string $property The property to get.
         *
         * @return mixed The value of the property
         */
        public function __get($property)
        {
        }
        /**
         * Magic setter method, allows $model->property = 'value' access to data.
         *
         * @param string $property The property to set.
         * @param string $value    The value to set.
         *
         * @return void
         */
        public function __set($property, $value)
        {
        }
        /**
         * Magic unset method, allows unset($model->property)
         *
         * @param string $property The property to unset.
         *
         * @return void
         */
        public function __unset($property)
        {
        }
        /**
         * JSON serializer.
         *
         * @return array The data of this object.
         */
        public function jsonSerialize()
        {
        }
        /**
         * Strips all nested dependencies from the debug info.
         *
         * @return array
         */
        public function __debugInfo()
        {
        }
        /**
         * Magic isset method, allows isset($model->property) to work correctly.
         *
         * @param string $property The property to check.
         *
         * @return bool True when value is set.
         */
        public function __isset($property)
        {
        }
        /**
         * Getter method, allows $model->get('property') access to data
         *
         * @param string $property The property to get.
         *
         * @return string The value of a property.
         */
        public function get($property)
        {
        }
        /**
         * Setter method, allows $model->set('property', 'value') access to data.
         *
         * @param string|array $property The property to set.
         * @param string|null  $value    The value to give.
         *
         * @return static Current object.
         */
        public function set($property, $value = null)
        {
        }
        /**
         * Setter method, allows $model->set_expr('property', 'value') access to data.
         *
         * @param string|array $property The property to set.
         * @param string|null  $value    The value to give.
         *
         * @return static Current object.
         */
        public function set_expr($property, $value = null)
        {
        }
        /**
         * Check whether the given property has changed since the object was created or saved.
         *
         * @param string $property The property to check.
         *
         * @return bool True when field is changed.
         */
        public function is_dirty($property)
        {
        }
        /**
         * Check whether the model was the result of a call to create() or not.
         *
         * @return bool True when is new.
         */
        public function is_new()
        {
        }
        /**
         * Wrapper for Idiorm's as_array method.
         *
         * @return array The models data as array.
         */
        public function as_array()
        {
        }
        /**
         * Save the data associated with this model instance to the database.
         *
         * @return null Nothing.
         */
        public function save()
        {
        }
        /**
         * Delete the database row associated with this model instance.
         *
         * @return null Nothing.
         */
        public function delete()
        {
        }
        /**
         * Get the database ID of this model instance.
         *
         * @return int The database ID of the models instance.
         *
         * @throws \Exception When the ID is a null value.
         */
        public function id()
        {
        }
        /**
         * Hydrate this model instance with an associative array of data.
         * WARNING: The keys in the array MUST match with columns in the
         * corresponding database table. If any keys are supplied which
         * do not match up with columns, the database will throw an error.
         *
         * @param array $data The data to pass to the ORM.
         *
         * @return void
         */
        public function hydrate($data)
        {
        }
        /**
         * Calls static methods directly on the ORM
         *
         * @param string $method    The method to call.
         * @param array  $arguments The arguments to use.
         *
         * @return array Result of the static call.
         */
        public static function __callStatic($method, $arguments)
        {
        }
    }
    /**
     * Yoast ORM class.
     *
     * Based on Idiorm
     *
     * URL: http://github.com/j4mie/idiorm/
     *
     * A single-class super-simple database abstraction layer for PHP.
     * Provides (nearly) zero-configuration object-relational mapping
     * and a fluent interface for building basic, commonly-used queries.
     *
     * BSD Licensed.
     *
     * Copyright (c) 2010, Jamie Matthews
     * All rights reserved.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions are met:
     *
     * * Redistributions of source code must retain the above copyright notice, this
     *   list of conditions and the following disclaimer.
     *
     * * Redistributions in binary form must reproduce the above copyright notice,
     *   this list of conditions and the following disclaimer in the documentation
     *   and/or other materials provided with the distribution.
     *
     * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
     * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
     * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
     * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
     * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
     * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
     * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
     * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
     * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
     * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     *
     * The methods documented below are magic methods that conform to PSR-1.
     * This documentation exposes these methods to doc generators and IDEs.
     *
     * @see http://www.php-fig.org/psr/psr-1/
     */
    class ORM implements \ArrayAccess
    {
        /*
         * --- CLASS CONSTANTS ---
         */
        const CONDITION_FRAGMENT = 0;
        const CONDITION_VALUES = 1;
        /*
         * --- INSTANCE PROPERTIES ---
         */
        /**
         * Holds the class name. Wrapped find_one and find_many classes will return an instance or instances of this class.
         *
         * @var string
         */
        protected $class_name;
        /**
         * Holds the name of the table the current ORM instance is associated with.
         *
         * @var string
         */
        protected $table_name;
        /**
         * Holds the alias for the table to be used in SELECT queries.
         *
         * @var string
         */
        protected $table_alias = null;
        /**
         * Values to be bound to the query.
         *
         * @var array
         */
        protected $values = [];
        /**
         * Columns to select in the result.
         *
         * @var array
         */
        protected $result_columns = ['*'];
        /**
         * Are we using the default result column or have these been manually changed?
         *
         * @var bool
         */
        protected $using_default_result_columns = true;
        /**
         * Holds the join sources.
         *
         * @var array
         */
        protected $join_sources = [];
        /**
         * Should the query include a DISTINCT keyword?
         *
         * @var bool
         */
        protected $distinct = false;
        /**
         * Is this a raw query?
         *
         * @var bool
         */
        protected $is_raw_query = false;
        /**
         * The raw query.
         *
         * @var string
         */
        protected $raw_query = '';
        /**
         * The raw query parameters.
         *
         * @var array
         */
        protected $raw_parameters = [];
        /**
         * Array of WHERE clauses.
         *
         * @var array
         */
        protected $where_conditions = [];
        /**
         * LIMIT.
         *
         * @var int
         */
        protected $limit = null;
        /**
         * OFFSET.
         *
         * @var int
         */
        protected $offset = null;
        /**
         * ORDER BY.
         *
         * @var array
         */
        protected $order_by = [];
        /**
         * GROUP BY.
         *
         * @var array
         */
        protected $group_by = [];
        /**
         * HAVING.
         *
         * @var array
         */
        protected $having_conditions = [];
        /**
         * The data for a hydrated instance of the class.
         *
         * @var array
         */
        protected $data = [];
        /**
         * Lifetime of the object.
         *
         * @var array
         */
        protected $dirty_fields = [];
        /**
         * Fields that are to be inserted in the DB raw.
         *
         * @var array
         */
        protected $expr_fields = [];
        /**
         * Is this a new object (has create() been called)?
         *
         * @var bool
         */
        protected $is_new = false;
        /**
         * Name of the column to use as the primary key for
         * this instance only. Overrides the config settings.
         *
         * @var string
         */
        protected $instance_id_column = null;
        /*
         * --- STATIC METHODS ---
         */
        /**
         * Factory method, return an instance of this class bound to the supplied
         * table name.
         *
         * A repeat of content in parent::for_table, so that created class is ORM.
         *
         * @param string $table_name The table to create instance for.
         *
         * @return ORM Instance of the ORM.
         */
        public static function for_table($table_name)
        {
        }
        /**
         * Executes a raw query as a wrapper for wpdb::query.
         * Useful for queries that can't be accomplished through Idiorm,
         * particularly those using engine-specific features.
         *
         * @example raw_execute('INSERT OR REPLACE INTO `widget` (`id`, `name`) SELECT `id`, `name` FROM `other_table`')
         * @example raw_execute('SELECT `name`, AVG(`order`) FROM `customer` GROUP BY `name` HAVING AVG(`order`) > 10')
         *
         * @param string $query      The raw SQL query.
         * @param array  $parameters Optional bound parameters.
         *
         * @return bool Success.
         */
        public static function raw_execute($query, $parameters = [])
        {
        }
        /**
         * Internal helper method for executing statements.
         *
         * @param string $query      The query.
         * @param array  $parameters An array of parameters to be bound in to the query.
         *
         * @return bool|int Response of wpdb::query
         */
        protected static function execute($query, $parameters = [])
        {
        }
        /*
         * --- INSTANCE METHODS ---
         */
        /**
         * "Private" constructor; shouldn't be called directly.
         * Use the ORM::for_table factory method instead.
         *
         * @param string $table_name Table name.
         * @param array  $data       Data to populate table.
         */
        protected function __construct($table_name, $data = [])
        {
        }
        /**
         * Sets the name of the class which the wrapped methods should return instances of.
         *
         * @param string $class_name The classname to set.
         *
         * @return void
         */
        public function set_class_name($class_name)
        {
        }
        /**
         * Creates a new, empty instance of the class. Used to add a new row to your database. May optionally be passed an
         * associative array of data to populate the instance. If so, all fields will be flagged as dirty so all will be
         * saved to the database when save() is called.
         *
         * @param array|null $data Data to populate table.
         *
         * @return bool|Model|ORM
         */
        public function create($data = null)
        {
        }
        /**
         * Specifies the ID column to use for this instance or array of instances only.
         * This overrides the id_column and id_column_overrides settings.
         *
         * This is mostly useful for libraries built on top of Idiorm, and will not normally be used in manually built
         * queries. If you don't know why you would want to use this, you should probably just ignore it.
         *
         * @param string $id_column The ID column.
         *
         * @return ORM
         */
        public function use_id_column($id_column)
        {
        }
        /**
         * Creates an ORM instance from the given row (an associative array of data fetched from the database).
         *
         * @param array $row A row from the database.
         *
         * @return bool|Model
         */
        protected function create_instance_from_row($row)
        {
        }
        /**
         * Tells the ORM that you are expecting a single result back from your query, and execute it. Will return a single
         * instance of the ORM class, or false if no rows were returned. As a shortcut, you may supply an ID as a parameter
         * to this method. This will perform a primary key lookup on the table.
         *
         * @param int|null $id An (optional) ID.
         *
         * @return bool|Model
         */
        public function find_one($id = null)
        {
        }
        /**
         * Tells the ORM that you are expecting multiple results from your query, and execute it. Will return an array of
         * instances of the ORM class, or an empty array if no rows were returned.
         *
         * @return array
         */
        public function find_many()
        {
        }
        /**
         * Creates an instance of the model class associated with this wrapper and populate it with the supplied Idiorm
         * instance.
         *
         * @param ORM $orm The ORM used by model.
         *
         * @return bool|Model Instance of the model class.
         */
        protected function create_model_instance($orm)
        {
        }
        /**
         * Tells the ORM that you are expecting multiple results from your query, and execute it. Will return an array, or
         * an empty array if no rows were returned.
         *
         * @return array The query results.
         */
        public function find_array()
        {
        }
        /**
         * Tells the ORM that you wish to execute a COUNT query.
         *
         * @param string $column The table column.
         *
         * @return float|int An integer representing the number of rows returned.
         */
        public function count($column = '*')
        {
        }
        /**
         * Tells the ORM that you wish to execute a MAX query.
         *
         * @param string $column The table column.
         *
         * @return float|int The max value of the chosen column.
         */
        public function max($column)
        {
        }
        /**
         * Tells the ORM that you wish to execute a MIN query.
         *
         * @param string $column The table column.
         *
         * @return float|int The min value of the chosen column.
         */
        public function min($column)
        {
        }
        /**
         * Tells the ORM that you wish to execute a AVG query.
         *
         * @param string $column The table column.
         *
         * @return float|int The average value of the chosen column.
         */
        public function avg($column)
        {
        }
        /**
         * Tells the ORM that you wish to execute a SUM query.
         *
         * @param string $column The table column.
         *
         * @return float|int The sum of the chosen column.
         */
        public function sum($column)
        {
        }
        /**
         * Returns the select query as SQL.
         *
         * @return string The select query in SQL.
         */
        public function get_sql()
        {
        }
        /**
         * Returns the update query as SQL.
         *
         * @return string The update query in SQL.
         */
        public function get_update_sql()
        {
        }
        /**
         * Executes an aggregate query on the current connection.
         *
         * @param string $sql_function The aggregate function to call eg. MIN, COUNT, etc.
         * @param string $column       The column to execute the aggregate query against.
         *
         * @return int
         */
        protected function call_aggregate_db_function($sql_function, $column)
        {
        }
        /**
         * Hydrates (populate) this instance of the class from an associative array of data. This will usually be called
         * only from inside the class, but it's public in case you need to call it directly.
         *
         * @param array $data Data to populate table.
         *
         * @return ORM
         */
        public function hydrate($data = [])
        {
        }
        /**
         * Forces the ORM to flag all the fields in the $data array as "dirty" and therefore update them when save() is
         * called.
         *
         * @return ORM
         */
        public function force_all_dirty()
        {
        }
        /**
         * Performs a raw query. The query can contain placeholders in either named or question mark style. If placeholders
         * are used, the parameters should be an array of values which will be bound to the placeholders in the query.
         * If this method is called, all other query building methods will be ignored.
         *
         * @param array $query      The query.
         * @param array $parameters The parameters. Defaults to an empty array.
         *
         * @return ORM
         */
        public function raw_query($query, $parameters = [])
        {
        }
        /**
         * Adds an alias for the main table to be used in SELECT queries.
         *
         * @param string $alias The alias.
         *
         * @return ORM
         */
        public function table_alias($alias)
        {
        }
        /**
         * Adds an unquoted expression to the set of columns returned by the SELECT query. Internal method.
         *
         * @param string      $expr  The expression.
         * @param string|null $alias The alias to return the expression as. Defaults to null.
         *
         * @return ORM
         */
        protected function add_result_column($expr, $alias = null)
        {
        }
        /**
         * Counts the number of columns that belong to the primary key and their value is null.
         *
         * @return int The amount of null columns.
         *
         * @throws \Exception Primary key ID contains null value(s).
         * @throws \Exception Primary key ID missing from row or is null.
         */
        public function count_null_id_columns()
        {
        }
        /**
         * Adds a column to the list of columns returned by the SELECT query.
         *
         * @param string      $column The column. Defaults to '*'.
         * @param string|null $alias  The alias to return the column as. Defaults to null.
         *
         * @return ORM
         */
        public function select($column, $alias = null)
        {
        }
        /**
         * Adds an unquoted expression to the list of columns returned by the SELECT query.
         *
         * @param string      $expr  The expression.
         * @param string|null $alias The alias to return the column as. Defaults to null.
         *
         * @return ORM
         */
        public function select_expr($expr, $alias = null)
        {
        }
        /**
         * Adds columns to the list of columns returned by the SELECT query.
         *
         * This defaults to '*'.
         * Many columns can be supplied as either an array or as a list of parameters to the method.
         * Note that the alias must not be numeric - if you want a numeric alias then prepend it with some alpha chars. eg.
         * a1.
         *
         * @example select_many(array('column', 'column2', 'column3'), 'column4', 'column5');
         * @example select_many(array('alias' => 'column', 'column2', 'alias2' => 'column3'), 'column4', 'column5');
         * @example select_many('column', 'column2', 'column3');
         *
         * @return ORM
         */
        public function select_many()
        {
        }
        /**
         * Adds an unquoted expression to the list of columns returned by the SELECT query.
         *
         * Many columns can be supplied as either an array or as a list of parameters to the method.
         * Note that the alias must not be numeric - if you want a numeric alias then prepend it with some alpha chars. eg.
         * a1
         *
         * @example select_many_expr(array('alias' => 'column', 'column2', 'alias2' => 'column3'), 'column4', 'column5')
         * @example select_many_expr('column', 'column2', 'column3')
         * @example select_many_expr(array('column', 'column2', 'column3'), 'column4', 'column5')
         *
         * @return ORM
         */
        public function select_many_expr()
        {
        }
        /**
         * Takes a column specification for the select many methods and convert it into a normalised array of columns and
         * aliases.
         *
         * It is designed to turn the following styles into a normalised array:
         * array(array('alias' => 'column', 'column2', 'alias2' => 'column3'), 'column4', 'column5'))
         *
         * @param array $columns The columns.
         *
         * @return array
         */
        protected function normalise_select_many_columns($columns)
        {
        }
        /**
         * Adds a DISTINCT keyword before the list of columns in the SELECT query.
         *
         * @return ORM
         */
        public function distinct()
        {
        }
        /**
         * Add a JOIN source to the query. Internal method.
         *
         * The join_operator should be one of INNER, LEFT OUTER, CROSS etc - this
         * will be prepended to JOIN.
         *
         * The table should be the name of the table to join to.
         *
         * The constraint may be either a string or an array with three elements. If it
         * is a string, it will be compiled into the query as-is, with no escaping. The
         * recommended way to supply the constraint is as an array with three elements:
         *
         * first_column, operator, second_column
         *
         * Example: array('user.id', '=', 'profile.user_id')
         *
         * will compile to
         *
         * ON `user`.`id` = `profile`.`user_id`
         *
         * The final (optional) argument specifies an alias for the joined table.
         *
         * @param string      $join_operator The join_operator should be one of INNER, LEFT OUTER, CROSS etc - this will be
         *                                   prepended to JOIN.
         * @param string      $table         The table should be the name of the table to join to.
         * @param string      $constraint    The constraint.
         * @param string|null $table_alias   The alias for the joined table. Defaults to null.
         *
         * @return ORM
         */
        protected function add_join_source($join_operator, $table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds a RAW JOIN source to the query.
         *
         * @param string $table       The table name.
         * @param string $constraint  The constraint.
         * @param string $table_alias The table alias.
         * @param array  $parameters  The parameters. Defaults to an empty array.
         *
         * @return ORM
         */
        public function raw_join($table, $constraint, $table_alias, $parameters = [])
        {
        }
        /**
         * Adds a simple JOIN source to the query.
         *
         * @param string      $table       The table name.
         * @param string      $constraint  The constraint.
         * @param string|null $table_alias The table alias. Defaults to null.
         *
         * @return ORM
         */
        public function join($table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds an INNER JOIN source to the query.
         *
         * @param string      $table       The table name.
         * @param string      $constraint  The constraint.
         * @param string|null $table_alias The table alias. Defaults to null.
         *
         * @return ORM
         */
        public function inner_join($table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds a LEFT OUTER JOIN source to the query.
         *
         * @param string      $table       The table name.
         * @param string      $constraint  The constraint.
         * @param string|null $table_alias The table alias. Defaults to null.
         *
         * @return ORM
         */
        public function left_outer_join($table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds a RIGHT OUTER JOIN source to the query.
         *
         * @param string      $table       The table name.
         * @param string      $constraint  The constraint.
         * @param string|null $table_alias The table alias. Defaults to null.
         *
         * @return ORM
         */
        public function right_outer_join($table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds a FULL OUTER JOIN source to the query.
         *
         * @param string      $table       The table name.
         * @param string      $constraint  The constraint.
         * @param string|null $table_alias The table alias. Defaults to null.
         *
         * @return ORM
         */
        public function full_outer_join($table, $constraint, $table_alias = null)
        {
        }
        /**
         * Adds a HAVING condition to the query. Internal method.
         *
         * @param string $fragment The fragment.
         * @param array  $values   The values. Defaults to an empty array.
         *
         * @return ORM
         */
        protected function add_having($fragment, $values = [])
        {
        }
        /**
         * Adds a HAVING condition to the query. Internal method.
         *
         * @param string $column_name The table column.
         * @param string $separator   The separator.
         * @param mixed  $value       The value.
         *
         * @return ORM
         */
        protected function add_simple_having($column_name, $separator, $value)
        {
        }
        /**
         * Adds a HAVING clause with multiple values (like IN and NOT IN). Internal method.
         *
         * @param string|array $column_name The table column.
         * @param string       $separator   The separator.
         * @param array        $values      The values.
         *
         * @return ORM
         */
        public function add_having_placeholder($column_name, $separator, $values)
        {
        }
        /**
         * Adds a HAVING clause with no parameters(like IS NULL and IS NOT NULL). Internal method.
         *
         * @param string $column_name The column name.
         * @param string $operator    The operator.
         *
         * @return ORM
         */
        public function add_having_no_value($column_name, $operator)
        {
        }
        /**
         * Adds a WHERE condition to the query. Internal method.
         *
         * @param string $fragment The fragment.
         * @param array  $values   The values. Defaults to an empty array.
         *
         * @return ORM
         */
        protected function add_where($fragment, $values = [])
        {
        }
        /**
         * Adds a WHERE condition to the query. Internal method.
         *
         * @param string|array $column_name The table column.
         * @param string       $separator   The separator.
         * @param mixed        $value       The value.
         *
         * @return ORM
         */
        protected function add_simple_where($column_name, $separator, $value)
        {
        }
        /**
         * Adds a WHERE clause with multiple values (like IN and NOT IN).
         *
         * @param string|array $column_name The table column.
         * @param string       $separator   The separator.
         * @param array        $values      The values.
         *
         * @return ORM
         */
        public function add_where_placeholder($column_name, $separator, $values)
        {
        }
        /**
         * Adds a WHERE clause with no parameters(like IS NULL and IS NOT NULL).
         *
         * @param string $column_name The column name.
         * @param string $operator    The operator.
         *
         * @return ORM
         */
        public function add_where_no_value($column_name, $operator)
        {
        }
        /**
         * Adds a HAVING or WHERE condition to the query. Internal method.
         *
         * @param string $type     The type.
         * @param string $fragment The fragment.
         * @param array  $values   The values. Defaults to empty array.
         *
         * @return ORM
         */
        protected function add_condition($type, $fragment, $values = [])
        {
        }
        /**
         * Compiles a simple COLUMN SEPARATOR VALUE style HAVING or WHERE condition into a string and value ready to be
         * passed to the add_condition method.
         *
         * Avoids duplication of the call to quote_identifier.
         * If column_name is an associative array, it will add a condition for each column.
         *
         * @param string       $type        The type.
         * @param string|array $column_name The table column.
         * @param string       $separator   The separator.
         * @param mixed        $value       The value.
         *
         * @return ORM
         */
        protected function add_simple_condition($type, $column_name, $separator, $value)
        {
        }
        /**
         * Returns a string containing the given number of question marks, separated by commas. Eg "?, ?, ?".
         *
         * @param array $fields Fields to create placeholder for.
         *
         * @return string
         */
        protected function create_placeholders($fields)
        {
        }
        /**
         * Filters a column/value array returning only those columns that belong to a compound primary key.
         *
         * If the key contains a column that does not exist in the given array, a null value will be returned for it.
         *
         * @param mixed $value The value.
         *
         * @return array
         */
        protected function get_compound_id_column_values($value)
        {
        }
        /**
         * Filters an array containing compound column/value arrays.
         *
         * @param array $values The values.
         *
         * @return array
         */
        protected function get_compound_id_column_values_array($values)
        {
        }
        /**
         * Add a WHERE column = value clause to your query. Each time this is called in the chain, an additional WHERE will
         * be added, and these will be ANDed together when the final query is built.
         *
         * If you use an array in $column_name, a new clause will be added for each element. In this case, $value is
         * ignored.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where($column_name, $value = null)
        {
        }
        /**
         * More explicitly named version of for the where() method. Can be used if preferred.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_equal($column_name, $value = null)
        {
        }
        /**
         * Add a WHERE column != value clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_not_equal($column_name, $value = null)
        {
        }
        /**
         * Queries the table by its primary key. Special method.
         *
         * If primary key is compound, only the columns that belong to they key will be used for the query.
         *
         * @param string $id The ID.
         *
         * @return ORM
         */
        public function where_id_is($id)
        {
        }
        /**
         * Allows adding a WHERE clause that matches any of the conditions specified in the array. Each element in the
         * associative array will be a different condition, where the key will be the column name.
         *
         * By default, an equal operator will be used against all columns, but it can be overriden for any or every column
         * using the second parameter.
         *
         * Each condition will be ORed together when added to the final query.
         *
         * @param array  $values   The values.
         * @param string $operator The operator.
         *
         * @return ORM
         */
        public function where_any_is($values, $operator = '=')
        {
        }
        /**
         * Queries the table by its primary key.
         *
         * Similar to where_id_is() but allowing multiple primary keys.
         * If primary key is compound, only the columns that belong to they key will be used for the query.
         *
         * @param string[] $ids The IDs.
         *
         * @return ORM
         */
        public function where_id_in($ids)
        {
        }
        /**
         * Adds a WHERE ... LIKE clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_like($column_name, $value = null)
        {
        }
        /**
         * Adds where WHERE ... NOT LIKE clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_not_like($column_name, $value = null)
        {
        }
        /**
         * Adds a WHERE ... > clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_gt($column_name, $value = null)
        {
        }
        /**
         * Adds a WHERE ... < clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_lt($column_name, $value = null)
        {
        }
        /**
         * Adds a WHERE ... >= clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_gte($column_name, $value = null)
        {
        }
        /**
         * Adds a WHERE ... <= clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function where_lte($column_name, $value = null)
        {
        }
        /**
         * Adds a WHERE ... IN clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param array        $values      The values.
         *
         * @return ORM
         */
        public function where_in($column_name, $values)
        {
        }
        /**
         * Adds a WHERE ... NOT IN clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param array        $values      The values.
         *
         * @return ORM
         */
        public function where_not_in($column_name, $values)
        {
        }
        /**
         * Adds a WHERE column IS NULL clause to your query.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function where_null($column_name)
        {
        }
        /**
         * Adds a WHERE column IS NOT NULL clause to your query.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function where_not_null($column_name)
        {
        }
        /**
         * Adds a raw WHERE clause to the query. The clause should contain question mark placeholders, which will be bound
         * to the parameters supplied in the second argument.
         *
         * @param string $clause     The clause that should contain question mark placeholders.
         * @param array  $parameters The parameters to include in the query.
         *
         * @return ORM
         */
        public function where_raw($clause, $parameters = [])
        {
        }
        /**
         * Adds a LIMIT to the query.
         *
         * @param int $limit The limit.
         *
         * @return ORM
         */
        public function limit($limit)
        {
        }
        /**
         * Adds an OFFSET to the query.
         *
         * @param int $offset The offset.
         *
         * @return ORM
         */
        public function offset($offset)
        {
        }
        /**
         * Adds an ORDER BY clause to the query.
         *
         * @param string $column_name The column name.
         * @param string $ordering    The ordering. DESC or ASC.
         *
         * @return ORM
         */
        protected function add_order_by($column_name, $ordering)
        {
        }
        /**
         * Adds an ORDER BY column DESC clause.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function order_by_desc($column_name)
        {
        }
        /**
         * Adds an ORDER BY column ASC clause.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function order_by_asc($column_name)
        {
        }
        /**
         * Adds an unquoted expression as an ORDER BY clause.
         *
         * @param string $clause The clause.
         *
         * @return ORM
         */
        public function order_by_expr($clause)
        {
        }
        /**
         * Adds a column to the list of columns to GROUP BY.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function group_by($column_name)
        {
        }
        /**
         * Adds an unquoted expression to the list of columns to GROUP BY.
         *
         * @param string $expr The expression.
         *
         * @return ORM
         */
        public function group_by_expr($expr)
        {
        }
        /**
         * Adds a HAVING column = value clause to your query.
         *
         * Each time this is called in the chain, an additional HAVING will be added, and these will be ANDed together when
         * the final query is built.
         *
         * If you use an array in $column_name, a new clause will be added for each element. In this case, $value is
         * ignored.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value.
         *
         * @return ORM
         */
        public function having($column_name, $value = null)
        {
        }
        /**
         * Adds a having equal to your query.
         *
         * More explicitly named version of for the having() method. Can be used if preferred.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value.
         *
         * @return ORM
         */
        public function having_equal($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING column != value clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param mixed|null   $value       The value.
         *
         * @return ORM
         */
        public function having_not_equal($column_name, $value = null)
        {
        }
        /**
         * Queries the table by its primary key. Special method.
         *
         * If primary key is compound, only the columns that belong to they key will be used for the query.
         *
         * @param string $id The ID.
         *
         * @return ORM
         */
        public function having_id_is($id)
        {
        }
        /**
         * Adds a HAVING ... LIKE clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value.
         *
         * @return ORM
         */
        public function having_like($column_name, $value = null)
        {
        }
        /**
         * Adds where HAVING ... NOT LIKE clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value.
         *
         * @return ORM
         */
        public function having_not_like($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING ... > clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value.
         *
         * @return ORM
         */
        public function having_gt($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING ... < clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value.
         *
         * @return ORM
         */
        public function having_lt($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING ... >= clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value. Defaults to null.
         *
         * @return ORM
         */
        public function having_gte($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING ... <= clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $value       The value.
         *
         * @return ORM
         */
        public function having_lte($column_name, $value = null)
        {
        }
        /**
         * Adds a HAVING ... IN clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $values      The values. Defaults to null.
         *
         * @return ORM
         */
        public function having_in($column_name, $values = null)
        {
        }
        /**
         * Adds a HAVING ... NOT IN clause to your query.
         *
         * @param string|array $column_name The table column.
         * @param null         $values      The values. Defaults to null.
         *
         * @return ORM
         */
        public function having_not_in($column_name, $values = null)
        {
        }
        /**
         * Adds a HAVING column IS NULL clause to your query.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function having_null($column_name)
        {
        }
        /**
         * Adds a HAVING column IS NOT NULL clause to your query.
         *
         * @param string|array $column_name The table column.
         *
         * @return ORM
         */
        public function having_not_null($column_name)
        {
        }
        /**
         * Adds a raw HAVING clause to the query. The clause should contain question mark placeholders, which will be bound
         * to the parameters supplied in the second argument.
         *
         * @param string $clause     The clause that should contain question mark placeholders.
         * @param array  $parameters The parameters to include in the query.
         *
         * @return ORM
         */
        public function having_raw($clause, $parameters = [])
        {
        }
        /**
         * Builds a SELECT statement based on the clauses that have been passed to this instance by chaining method calls.
         *
         * @return string
         */
        protected function build_select()
        {
        }
        /**
         * Builds the start of the SELECT statement.
         *
         * @return string
         */
        protected function build_select_start()
        {
        }
        /**
         * Builds the JOIN sources.
         *
         * @return string
         */
        protected function build_join()
        {
        }
        /**
         * Builds the WHERE clause(s).
         *
         * @return string
         */
        protected function build_where()
        {
        }
        /**
         * Build the HAVING clause(s)
         *
         * @return string
         */
        protected function build_having()
        {
        }
        /**
         * Builds GROUP BY.
         *
         * @return string
         */
        protected function build_group_by()
        {
        }
        /**
         * Builds a WHERE or HAVING clause.
         *
         * @param string $type Where or having.
         *
         * @return string
         */
        protected function build_conditions($type)
        {
        }
        /**
         * Builds ORDER BY.
         *
         * @return string
         */
        protected function build_order_by()
        {
        }
        /**
         * Builds LIMIT.
         *
         * @return string
         */
        protected function build_limit()
        {
        }
        /**
         * Builds OFFSET.
         *
         * @return string
         */
        protected function build_offset()
        {
        }
        /**
         * Joins strings if they are not empty.
         *
         * @param string   $glue   Glue.
         * @param string[] $pieces Pieces to join.
         *
         * @return string
         */
        protected function join_if_not_empty($glue, $pieces)
        {
        }
        /**
         * Quotes a string that is used as an identifier (table names, column names etc).
         * This method can also deal with dot-separated identifiers eg table.column.
         *
         * @param string|string[] $identifier One or more identifiers.
         *
         * @return string
         */
        protected function quote_one_identifier($identifier)
        {
        }
        /**
         * Quotes a string that is used as an identifier (table names, column names etc) or an array containing multiple
         * identifiers. This method can also deal with dot-separated identifiers eg table.column.
         *
         * @param string|string[] $identifier One or more identifiers.
         *
         * @return string
         */
        protected function quote_identifier($identifier)
        {
        }
        /**
         * Quotes a single part of an identifier, using the identifier quote character specified in the config
         * (or autodetected).
         *
         * @param string $part The part to quote.
         *
         * @return string
         */
        protected function quote_identifier_part($part)
        {
        }
        /**
         * Executes the SELECT query that has been built up by chaining methods on this class.
         * Return an array of rows as associative arrays.
         *
         * @return array|false The result rows. False if the query failed.
         */
        protected function run()
        {
        }
        /**
         * Resets the Idiorm instance state.
         */
        private function reset_idiorm_state()
        {
        }
        /**
         * Returns the raw data wrapped by this ORM instance as an associative array. Column names may optionally be
         * supplied as arguments, if so, only those keys will be returned.
         *
         * @return array Associative array of the raw data.
         */
        public function as_array()
        {
        }
        /**
         * Returns the value of a property of this object (database row) or null if not present.
         *
         * If a column-names array is passed, it will return a associative array with the value of each column or null if
         * it is not present.
         *
         * @param string|array $key Key.
         *
         * @return array|mixed|null
         */
        public function get($key)
        {
        }
        /**
         * Returns the name of the column in the database table which contains the primary key ID of the row.
         *
         * @return string The primary key ID of the row.
         */
        protected function get_id_column_name()
        {
        }
        /**
         * Gets the primary key ID of this object.
         *
         * @param bool $disallow_null Whether to allow null IDs.
         *
         * @return array|mixed|null
         *
         * @throws \Exception Primary key ID contains null value(s).
         * @throws \Exception Primary key ID missing from row or is null.
         */
        public function id($disallow_null = false)
        {
        }
        /**
         * Sets a property to a particular value on this object.
         *
         * To set multiple properties at once, pass an associative array as the first parameter and leave out the second
         * parameter. Flags the properties as 'dirty' so they will be saved to the database when save() is called.
         *
         * @param string|array $key   Key.
         * @param string|null  $value Value.
         *
         * @return ORM
         */
        public function set($key, $value = null)
        {
        }
        /**
         * Set a property to a particular value on this object as expression.
         *
         * To set multiple properties at once, pass an associative array as the first parameter and leave out the second
         * parameter. Flags the properties as 'dirty' so they will be saved to the database when save() is called.
         *
         * @param string|array $key   Key.
         * @param string|null  $value Value.
         *
         * @return ORM
         */
        public function set_expr($key, $value = null)
        {
        }
        /**
         * Sets a property on the ORM object.
         *
         * @param string|array $key   Key.
         * @param string|null  $value Value.
         * @param bool         $expr  Expression.
         *
         * @return ORM
         */
        protected function set_orm_property($key, $value = null, $expr = false)
        {
        }
        /**
         * Checks whether the given field has been changed since this object was saved.
         *
         * @param mixed $key Key.
         *
         * @return bool
         */
        public function is_dirty($key)
        {
        }
        /**
         * Checks whether the model was the result of a call to create() or not.
         *
         * @return bool
         */
        public function is_new()
        {
        }
        /**
         * Saves any fields which have been modified on this object to the database.
         *
         * @return bool True on success.
         *
         * @throws \Exception Primary key ID contains null value(s).
         * @throws \Exception Primary key ID missing from row or is null.
         */
        public function save()
        {
        }
        /**
         * Extracts and gathers all dirty column names from the given model instances.
         *
         * @param array $models Array of model instances to be inserted.
         *
         * @return array The distinct set of columns that are dirty in at least one of the models.
         *
         * @throws \InvalidArgumentException Instance to be inserted is not a new one.
         */
        public function get_dirty_column_names($models)
        {
        }
        /**
         * Inserts multiple rows in a single query. Expects new rows as it's a strictly insert function, not an update one.
         *
         * @param array $models Array of model instances to be inserted.
         *
         * @return bool True for successful insert, false for failed.
         *
         * @example From the Indexable_Link_Builder class: $this->seo_links_repository->query()->insert_many( $links );
         *
         * @throws \InvalidArgumentException Invalid instances to be inserted.
         * @throws \InvalidArgumentException Instance to be inserted is not a new one.
         */
        public function insert_many($models)
        {
        }
        /**
         * Updates many records in the database.
         *
         * @return int|bool The number of rows changed if the query was succesful. False otherwise.
         */
        public function update_many()
        {
        }
        /**
         * Adds a WHERE clause for every column that belongs to the primary key.
         *
         * @return string The where part of the query.
         */
        public function add_id_column_conditions()
        {
        }
        /**
         * Builds an UPDATE query.
         *
         * @return string The update query.
         */
        protected function build_update()
        {
        }
        /**
         * Builds an INSERT query.
         *
         * @return string The insert query.
         */
        protected function build_insert()
        {
        }
        /**
         * Builds a bulk INSERT query.
         *
         * @param array $models Array of model instances to be inserted.
         * @param array $dirty_column_names Array of dirty fields to be used in INSERT.
         *
         * @return string The insert query.
         */
        protected function build_insert_many($models, $dirty_column_names)
        {
        }
        /**
         * Deletes this record from the database.
         *
         * @return string The delete query.
         *
         * @throws \Exception Primary key ID contains null value(s).
         * @throws \Exception Primary key ID missing from row or is null.
         */
        public function delete()
        {
        }
        /**
         * Deletes many records from the database.
         *
         * @return bool|int Response of wpdb::query.
         */
        public function delete_many()
        {
        }
        /*
         * ---  ArrayAccess  ---
         */
        /**
         * Checks whether the data has the key.
         *
         * @param mixed $key Key.
         *
         * @return bool Whether the data has the key.
         */
        public function offsetExists($key)
        {
        }
        /**
         * Retrieves the value of the key.
         *
         * @param mixed $key Key.
         *
         * @return array|mixed|null The value.
         */
        public function offsetGet($key)
        {
        }
        /**
         * Sets the value of the key.
         *
         * @param string|int $key   Key.
         * @param mixed      $value Value.
         */
        public function offsetSet($key, $value)
        {
        }
        /**
         * Removes the given key from the data.
         *
         * @param mixed $key Key.
         */
        public function offsetUnset($key)
        {
        }
        /*
         * --- MAGIC METHODS ---
         */
        /**
         * Handles magic get via offset.
         *
         * @param mixed $key Key.
         *
         * @return array|mixed|null The value in the offset.
         */
        public function __get($key)
        {
        }
        /**
         * Handles magic set via offset.
         *
         * @param string|int $key   Key.
         * @param mixed      $value Value.
         */
        public function __set($key, $value)
        {
        }
        /**
         * Handles magic unset via offset.
         *
         * @param mixed $key Key.
         */
        public function __unset($key)
        {
        }
        /**
         * Handles magic isset via offset.
         *
         * @param mixed $key Key.
         *
         * @return bool Whether the offset has the key.
         */
        public function __isset($key)
        {
        }
    }
}
namespace Yoast\WP\SEO\Actions\Addon_Installation {
    /**
     * Represents the endpoint for activating a specific Yoast Plugin on WordPress.
     */
    class Addon_Activate_Action
    {
        /**
         * The addon manager.
         *
         * @var \WPSEO_Addon_Manager
         */
        protected $addon_manager;
        /**
         * The require file helper.
         *
         * @var Require_File_Helper
         */
        protected $require_file_helper;
        /**
         * Addon_Activate_Action constructor.
         *
         * @param \WPSEO_Addon_Manager $addon_manager       The addon manager.
         * @param Require_File_Helper  $require_file_helper A file helper.
         */
        public function __construct(\WPSEO_Addon_Manager $addon_manager, \Yoast\WP\SEO\Helpers\Require_File_Helper $require_file_helper)
        {
        }
        /**
         * Activates the plugin based on the given plugin file.
         *
         * @param string $plugin_slug The plugin slug to get download url for.
         *
         * @return bool True when activation is successful.
         *
         * @throws Addon_Activation_Error_Exception       Exception when the activation encounters an error.
         * @throws User_Cannot_Activate_Plugins_Exception Exception when the user is not allowed to activate.
         */
        public function activate_addon($plugin_slug)
        {
        }
        /**
         * Requires the files needed from WordPress itself.
         *
         * @codeCoverageIgnore Only loads a WordPress file.
         *
         * @return void
         */
        protected function load_wordpress_classes()
        {
        }
    }
    /**
     * Represents the endpoint for downloading and installing a zip-file from MyYoast.
     */
    class Addon_Install_Action
    {
        /**
         * The addon manager.
         *
         * @var \WPSEO_Addon_Manager
         */
        protected $addon_manager;
        /**
         * The require file helper.
         *
         * @var Require_File_Helper
         */
        protected $require_file_helper;
        /**
         * Addon_Activate_Action constructor.
         *
         * @param \WPSEO_Addon_Manager $addon_manager       The addon manager.
         * @param Require_File_Helper  $require_file_helper A helper that can require files.
         */
        public function __construct(\WPSEO_Addon_Manager $addon_manager, \Yoast\WP\SEO\Helpers\Require_File_Helper $require_file_helper)
        {
        }
        /**
         * Installs the plugin based on the given slug.
         *
         * @param string $plugin_slug  The plugin slug to install.
         * @param string $download_url The plugin download URL.
         *
         * @return bool True when install is successful.
         *
         * @throws Addon_Already_Installed_Exception  When the addon is already installed.
         * @throws Addon_Installation_Error_Exception When the installation encounters an error.
         * @throws User_Cannot_Install_Plugins_Exception        When the user does not have the permissions to install plugins.
         */
        public function install_addon($plugin_slug, $download_url)
        {
        }
        /**
         * Requires the files needed from WordPress itself.
         *
         * @codeCoverageIgnore
         *
         * @return void
         */
        protected function load_wordpress_classes()
        {
        }
        /**
         * Checks is a plugin is installed.
         *
         * @param string $plugin_slug The plugin to check.
         *
         * @return bool True when plugin is installed.
         */
        protected function is_installed($plugin_slug)
        {
        }
        /**
         * Runs the installation by using the WordPress installation routine.
         *
         * @param string $plugin_download The url to the download.
         *
         * @codeCoverageIgnore Contains WordPress specific logic.
         *
         * @return bool|\WP_Error True when success, WP_Error when something went wrong.
         */
        protected function install($plugin_download)
        {
        }
    }
}
namespace Yoast\WP\SEO\Actions {
    /**
     * Class Alert_Dismissal_Action.
     */
    class Alert_Dismissal_Action
    {
        const USER_META_KEY = '_yoast_alerts_dismissed';
        /**
         * Holds the user helper instance.
         *
         * @var User_Helper
         */
        protected $user;
        /**
         * Constructs Alert_Dismissal_Action.
         *
         * @param User_Helper $user User helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\User_Helper $user)
        {
        }
        /**
         * Dismisses an alert.
         *
         * @param string $alert_identifier Alert identifier.
         *
         * @return bool Whether the dismiss was successful or not.
         */
        public function dismiss($alert_identifier)
        {
        }
        /**
         * Resets an alert.
         *
         * @param string $alert_identifier Alert identifier.
         *
         * @return bool Whether the reset was successful or not.
         */
        public function reset($alert_identifier)
        {
        }
        /**
         * Returns if an alert is dismissed or not.
         *
         * @param string $alert_identifier Alert identifier.
         *
         * @return bool Whether the alert has been dismissed.
         */
        public function is_dismissed($alert_identifier)
        {
        }
        /**
         * Returns an object with all alerts dismissed by current user.
         *
         * @return array|false An array with the keys of all Alerts that have been dismissed
         *                     by the current user or `false`.
         */
        public function all_dismissed()
        {
        }
        /**
         * Returns if an alert is allowed or not.
         *
         * @param string $alert_identifier Alert identifier.
         *
         * @return bool Whether the alert is allowed.
         */
        public function is_allowed($alert_identifier)
        {
        }
        /**
         * Retrieves the dismissed alerts.
         *
         * @param int $user_id User ID.
         *
         * @return string[]|false The dismissed alerts. False for an invalid $user_id.
         */
        protected function get_dismissed_alerts($user_id)
        {
        }
        /**
         * Retrieves the allowed dismissable alerts.
         *
         * @return string[] The allowed dismissable alerts.
         */
        protected function get_allowed_dismissable_alerts()
        {
        }
    }
}
namespace Yoast\WP\SEO\Actions\Indexables {
    /**
     * Get head action for indexables.
     */
    class Indexable_Head_Action
    {
        /**
         * Caches the output.
         *
         * @var mixed
         */
        protected $cache;
        /**
         * The meta surface.
         *
         * @var Meta_Surface
         */
        private $meta_surface;
        /**
         * Indexable_Head_Action constructor.
         *
         * @param Meta_Surface $meta_surface The meta surface.
         */
        public function __construct(\Yoast\WP\SEO\Surfaces\Meta_Surface $meta_surface)
        {
        }
        /**
         * Retrieves the head for a url.
         *
         * @param string $url The url to get the head for.
         *
         * @return object Object with head and status properties.
         */
        public function for_url($url)
        {
        }
        /**
         * Retrieves the head for a post.
         *
         * @param int $id The id.
         *
         * @return object Object with head and status properties.
         */
        public function for_post($id)
        {
        }
        /**
         * Retrieves the head for a term.
         *
         * @param int $id The id.
         *
         * @return object Object with head and status properties.
         */
        public function for_term($id)
        {
        }
        /**
         * Retrieves the head for an author.
         *
         * @param int $id The id.
         *
         * @return object Object with head and status properties.
         */
        public function for_author($id)
        {
        }
        /**
         * Retrieves the head for a post type archive.
         *
         * @param int $type The id.
         *
         * @return object Object with head and status properties.
         */
        public function for_post_type_archive($type)
        {
        }
        /**
         * Retrieves the head for the posts page.
         *
         * @return object Object with head and status properties.
         */
        public function for_posts_page()
        {
        }
        /**
         * Retrieves the head for the 404 page. Always sets the status to 404.
         *
         * @return object Object with head and status properties.
         */
        public function for_404()
        {
        }
        /**
         * Retrieves the head for a successful page load.
         *
         * @param object $head The calculated Yoast head.
         *
         * @return object The presentations and status code 200.
         */
        protected function for_200($head)
        {
        }
        /**
         * Returns the head with 404 fallback
         *
         * @param Meta|false $meta The meta object.
         *
         * @return object The head response.
         */
        protected function with_404_fallback($meta)
        {
        }
        /**
         * Retrieves a value from the meta surface cached.
         *
         * @param string $type     The type of value to retrieve.
         * @param string $argument Optional. The argument for the value.
         *
         * @return Meta The meta object.
         */
        protected function with_cache($type, $argument = '')
        {
        }
    }
}
namespace Yoast\WP\SEO\Actions\Indexing {
    /**
     * Interface definition of reindexing action for indexables.
     */
    interface Indexation_Action_Interface
    {
        /**
         * Returns the total number of unindexed objects.
         *
         * @return int The total number of unindexed objects.
         */
        public function get_total_unindexed();
        /**
         * Indexes a number of objects.
         *
         * NOTE: ALWAYS use limits, this method is intended to be called multiple times over several requests.
         *
         * For indexing that requires JavaScript simply return the objects that should be indexed.
         *
         * @return array The reindexed objects.
         */
        public function index();
        /**
         * Returns the number of objects that will be indexed in a single indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit();
    }
    /**
     * Interface definition of a reindexing action for indexables that have a limited unindexed count.
     *
     * @phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded
     */
    interface Limited_Indexing_Action_Interface
    {
        /**
         * Returns a limited number of unindexed posts.
         *
         * @param int $limit Limit the maximum number of unindexed posts that are counted.
         *
         * @return int|false The limited number of unindexed posts. False if the query fails.
         */
        public function get_limited_unindexed_count($limit);
    }
    /**
     * Trait used to calculate unindexed object.
     */
    abstract class Abstract_Indexing_Action implements \Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface, \Yoast\WP\SEO\Actions\Indexing\Limited_Indexing_Action_Interface
    {
        /**
         * The transient name.
         *
         * This is a trick to force derived classes to define a transient themselves.
         *
         * @var string
         */
        const UNINDEXED_COUNT_TRANSIENT = null;
        /**
         * The transient cache key for limited counts.
         *
         * @var string
         */
        const UNINDEXED_LIMITED_COUNT_TRANSIENT = self::UNINDEXED_COUNT_TRANSIENT . '_limited';
        /**
         * Builds a query for selecting the ID's of unindexed posts.
         *
         * @param bool $limit The maximum number of post IDs to return.
         *
         * @return string The prepared query string.
         */
        protected abstract function get_select_query($limit);
        /**
         * Builds a query for counting the number of unindexed posts.
         *
         * @return string The prepared query string.
         */
        protected abstract function get_count_query();
        /**
         * Returns a limited number of unindexed posts.
         *
         * @param int $limit Limit the maximum number of unindexed posts that are counted.
         *
         * @return int The limited number of unindexed posts. 0 if the query fails.
         */
        public function get_limited_unindexed_count($limit)
        {
        }
        /**
         * Returns the total number of unindexed posts.
         *
         * @return int|false The total number of unindexed posts. False if the query fails.
         */
        public function get_total_unindexed()
        {
        }
    }
    /**
     * Reindexing action for link indexables.
     */
    abstract class Abstract_Link_Indexing_Action extends \Yoast\WP\SEO\Actions\Indexing\Abstract_Indexing_Action
    {
        /**
         * The link builder.
         *
         * @var Indexable_Link_Builder
         */
        protected $link_builder;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        protected $repository;
        /**
         * The WordPress database instance.
         *
         * @var wpdb
         */
        protected $wpdb;
        /**
         * Indexable_Post_Indexing_Action constructor
         *
         * @param Indexable_Link_Builder $link_builder The indexable link builder.
         * @param Indexable_Repository   $repository   The indexable repository.
         * @param wpdb                   $wpdb         The WordPress database instance.
         */
        public function __construct(\Yoast\WP\SEO\Builders\Indexable_Link_Builder $link_builder, \Yoast\WP\SEO\Repositories\Indexable_Repository $repository, \wpdb $wpdb)
        {
        }
        /**
         * Builds links for indexables which haven't had their links indexed yet.
         *
         * @return SEO_Links[] The created SEO links.
         */
        public function index()
        {
        }
        /**
         * In the case of term-links and post-links we want to use the total unindexed count, because using
         * the limited unindexed count actually leads to worse performance.
         *
         * @param int|bool $limit Unused.
         *
         * @return int The total number of unindexed links.
         */
        public function get_limited_unindexed_count($limit = false)
        {
        }
        /**
         * Returns the number of texts that will be indexed in a single link indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit()
        {
        }
        /**
         * Returns objects to be indexed.
         *
         * @return array Objects to be indexed, should be an array of objects with object_id, object_type and content.
         */
        protected abstract function get_objects();
    }
    /**
     * General reindexing action for indexables.
     */
    class Indexable_General_Indexation_Action implements \Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface, \Yoast\WP\SEO\Actions\Indexing\Limited_Indexing_Action_Interface
    {
        /**
         * The transient cache key.
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_total_unindexed_general_items';
        /**
         * Represents the indexables repository.
         *
         * @var Indexable_Repository
         */
        protected $indexable_repository;
        /**
         * Indexable_General_Indexation_Action constructor.
         *
         * @param Indexable_Repository $indexable_repository The indexables repository.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository)
        {
        }
        /**
         * Returns the total number of unindexed objects.
         *
         * @return int The total number of unindexed objects.
         */
        public function get_total_unindexed()
        {
        }
        /**
         * Returns a limited number of unindexed posts.
         *
         * @param int $limit Limit the maximum number of unindexed posts that are counted.
         *
         * @return int|false The limited number of unindexed posts. False if the query fails.
         */
        public function get_limited_unindexed_count($limit)
        {
        }
        /**
         * Creates indexables for unindexed system pages, the date archive, and the homepage.
         *
         * @return Indexable[] The created indexables.
         */
        public function index()
        {
        }
        /**
         * Returns the number of objects that will be indexed in a single indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit()
        {
        }
        /**
         * Check which indexables already exists and return the values of the ones to create.
         *
         * @return array The indexable types to create.
         */
        private function query()
        {
        }
    }
    /**
     * Indexing action to call when the indexable indexing process is completed.
     */
    class Indexable_Indexing_Complete_Action
    {
        /**
         * The options helper.
         *
         * @var Indexable_Helper
         */
        protected $indexable_helper;
        /**
         * Indexable_Indexing_Complete_Action constructor.
         *
         * @param Indexable_Helper $indexable_helper The indexable helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Indexable_Helper $indexable_helper)
        {
        }
        /**
         * Wraps up the indexing process.
         *
         * @return void
         */
        public function complete()
        {
        }
    }
    /**
     * Reindexing action for post indexables.
     */
    class Indexable_Post_Indexation_Action extends \Yoast\WP\SEO\Actions\Indexing\Abstract_Indexing_Action
    {
        /**
         * The transient cache key.
         *
         * @var string
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_total_unindexed_posts';
        /**
         * The transient cache key for limited counts.
         *
         * @var string
         */
        const UNINDEXED_LIMITED_COUNT_TRANSIENT = self::UNINDEXED_COUNT_TRANSIENT . '_limited';
        /**
         * The post type helper.
         *
         * @var Post_Type_Helper
         */
        protected $post_type_helper;
        /**
         * The post helper.
         *
         * @var Post_Helper
         */
        protected $post_helper;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        protected $repository;
        /**
         * The WordPress database instance.
         *
         * @var wpdb
         */
        protected $wpdb;
        /**
         * Indexable_Post_Indexing_Action constructor
         *
         * @param Post_Type_Helper     $post_type_helper The post type helper.
         * @param Indexable_Repository $repository       The indexable repository.
         * @param wpdb                 $wpdb             The WordPress database instance.
         * @param Post_Helper          $post_helper      The post helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Post_Type_Helper $post_type_helper, \Yoast\WP\SEO\Repositories\Indexable_Repository $repository, \wpdb $wpdb, \Yoast\WP\SEO\Helpers\Post_Helper $post_helper)
        {
        }
        /**
         * Creates indexables for unindexed posts.
         *
         * @return Indexable[] The created indexables.
         */
        public function index()
        {
        }
        /**
         * Returns the number of posts that will be indexed in a single indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit()
        {
        }
        /**
         * Builds a query for counting the number of unindexed posts.
         *
         * @return string The prepared query string.
         */
        protected function get_count_query()
        {
        }
        /**
         * Builds a query for selecting the ID's of unindexed posts.
         *
         * @param bool $limit The maximum number of post IDs to return.
         *
         * @return string The prepared query string.
         */
        protected function get_select_query($limit = false)
        {
        }
        /**
         * Returns the post types that should be indexed.
         *
         * @return array The post types that should be indexed.
         */
        protected function get_post_types()
        {
        }
    }
    /**
     * Reindexing action for post type archive indexables.
     */
    class Indexable_Post_Type_Archive_Indexation_Action implements \Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface, \Yoast\WP\SEO\Actions\Indexing\Limited_Indexing_Action_Interface
    {
        /**
         * The transient cache key.
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_total_unindexed_post_type_archives';
        /**
         * The post type helper.
         *
         * @var Post_Type_Helper
         */
        private $post_type;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        private $repository;
        /**
         * The indexable builder.
         *
         * @var Indexable_Builder
         */
        private $builder;
        /**
         * Indexation_Post_Type_Archive_Action constructor.
         *
         * @param Indexable_Repository $repository The indexable repository.
         * @param Indexable_Builder    $builder    The indexable builder.
         * @param Post_Type_Helper     $post_type  The post type helper.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\Indexable_Repository $repository, \Yoast\WP\SEO\Builders\Indexable_Builder $builder, \Yoast\WP\SEO\Helpers\Post_Type_Helper $post_type)
        {
        }
        /**
         * Returns the total number of unindexed post type archives.
         *
         * @param int $limit Limit the number of counted objects.
         *
         * @return int The total number of unindexed post type archives.
         */
        public function get_total_unindexed($limit = false)
        {
        }
        /**
         * Creates indexables for post type archives.
         *
         * @return Indexable[] The created indexables.
         */
        public function index()
        {
        }
        /**
         * Returns the number of post type archives that will be indexed in a single indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit()
        {
        }
        /**
         * Retrieves the list of post types for which no indexable for its archive page has been made yet.
         *
         * @param int|false $limit Limit the number of retrieved indexables to this number.
         *
         * @return array The list of post types for which no indexable for its archive page has been made yet.
         */
        private function get_unindexed_post_type_archives($limit = false)
        {
        }
        /**
         * Returns the names of all the post types that have archive pages.
         *
         * @return array The list of names of all post types that have archive pages.
         */
        private function get_post_types_with_archive_pages()
        {
        }
        /**
         * Retrieves the list of post type names for which an archive indexable exists.
         *
         * @return array The list of names of post types with unindexed archive pages.
         */
        private function get_indexed_post_type_archives()
        {
        }
        /**
         * Returns a limited number of unindexed posts.
         *
         * @param int $limit Limit the maximum number of unindexed posts that are counted.
         *
         * @return int|false The limited number of unindexed posts. False if the query fails.
         */
        public function get_limited_unindexed_count($limit)
        {
        }
    }
    /**
     * Reindexing action for term indexables.
     */
    class Indexable_Term_Indexation_Action extends \Yoast\WP\SEO\Actions\Indexing\Abstract_Indexing_Action
    {
        /**
         * The transient cache key.
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_total_unindexed_terms';
        /**
         * The transient cache key for limited counts.
         *
         * @var string
         */
        const UNINDEXED_LIMITED_COUNT_TRANSIENT = self::UNINDEXED_COUNT_TRANSIENT . '_limited';
        /**
         * The post type helper.
         *
         * @var Taxonomy_Helper
         */
        protected $taxonomy;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        protected $repository;
        /**
         * The WordPress database instance.
         *
         * @var wpdb
         */
        protected $wpdb;
        /**
         * Indexable_Term_Indexation_Action constructor
         *
         * @param Taxonomy_Helper      $taxonomy   The taxonomy helper.
         * @param Indexable_Repository $repository The indexable repository.
         * @param wpdb                 $wpdb       The WordPress database instance.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Taxonomy_Helper $taxonomy, \Yoast\WP\SEO\Repositories\Indexable_Repository $repository, \wpdb $wpdb)
        {
        }
        /**
         * Creates indexables for unindexed terms.
         *
         * @return Indexable[] The created indexables.
         */
        public function index()
        {
        }
        /**
         * Returns the number of terms that will be indexed in a single indexing pass.
         *
         * @return int The limit.
         */
        public function get_limit()
        {
        }
        /**
         * Builds a query for counting the number of unindexed terms.
         *
         * @return string The prepared query string.
         */
        protected function get_count_query()
        {
        }
        /**
         * Builds a query for selecting the ID's of unindexed terms.
         *
         * @param bool $limit The maximum number of term IDs to return.
         *
         * @return string The prepared query string.
         */
        protected function get_select_query($limit = false)
        {
        }
    }
    /**
     * Indexing action to call when the indexing is completed.
     */
    class Indexing_Complete_Action
    {
        /**
         * The indexing helper.
         *
         * @var Indexing_Helper
         */
        protected $indexing_helper;
        /**
         * Indexing_Complete_Action constructor.
         *
         * @param Indexing_Helper $indexing_helper The indexing helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Indexing_Helper $indexing_helper)
        {
        }
        /**
         * Wraps up the indexing process.
         *
         * @return void
         */
        public function complete()
        {
        }
    }
    /**
     * Class Indexing_Prepare_Action.
     *
     * Action for preparing the indexing routine.
     */
    class Indexing_Prepare_Action
    {
        /**
         * The notification center.
         *
         * @var Yoast_Notification_Center
         */
        protected $notification_center;
        /**
         * The indexing helper.
         *
         * @var Indexing_Helper
         */
        protected $indexing_helper;
        /**
         * Action for preparing the indexing routine.
         *
         * @param Indexing_Helper           $indexing_helper     The indexing helper.
         * @param Yoast_Notification_Center $notification_center The notification center.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Indexing_Helper $indexing_helper, \Yoast_Notification_Center $notification_center)
        {
        }
        /**
         * Prepares the indexing routine.
         *
         * @return void
         */
        public function prepare()
        {
        }
    }
    /**
     * Reindexing action for post link indexables.
     */
    class Post_Link_Indexing_Action extends \Yoast\WP\SEO\Actions\Indexing\Abstract_Link_Indexing_Action
    {
        /**
         * The transient name.
         *
         * @var string
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_unindexed_post_link_count';
        /**
         * The transient cache key for limited counts.
         *
         * @var string
         */
        const UNINDEXED_LIMITED_COUNT_TRANSIENT = self::UNINDEXED_COUNT_TRANSIENT . '_limited';
        /**
         * The post type helper.
         *
         * @var Post_Type_Helper
         */
        protected $post_type_helper;
        /**
         * Sets the required helper.
         *
         * @required
         *
         * @param Post_Type_Helper $post_type_helper The post type helper.
         *
         * @return void
         */
        public function set_helper(\Yoast\WP\SEO\Helpers\Post_Type_Helper $post_type_helper)
        {
        }
        /**
         * Returns objects to be indexed.
         *
         * @return array Objects to be indexed.
         */
        protected function get_objects()
        {
        }
        /**
         * Builds a query for counting the number of unindexed post links.
         *
         * @return string The prepared query string.
         */
        protected function get_count_query()
        {
        }
        /**
         * Builds a query for selecting the ID's of unindexed post links.
         *
         * @param int|false $limit The maximum number of post link IDs to return.
         *
         * @return string The prepared query string.
         */
        protected function get_select_query($limit = false)
        {
        }
    }
    /**
     * Reindexing action for term link indexables.
     */
    class Term_Link_Indexing_Action extends \Yoast\WP\SEO\Actions\Indexing\Abstract_Link_Indexing_Action
    {
        /**
         * The transient name.
         *
         * @var string
         */
        const UNINDEXED_COUNT_TRANSIENT = 'wpseo_unindexed_term_link_count';
        /**
         * The transient cache key for limited counts.
         *
         * @var string
         */
        const UNINDEXED_LIMITED_COUNT_TRANSIENT = self::UNINDEXED_COUNT_TRANSIENT . '_limited';
        /**
         * The post type helper.
         *
         * @var Taxonomy_Helper
         */
        protected $taxonomy_helper;
        /**
         * Sets the required helper.
         *
         * @required
         *
         * @param Taxonomy_Helper $taxonomy_helper The taxonomy helper.
         *
         * @return void
         */
        public function set_helper(\Yoast\WP\SEO\Helpers\Taxonomy_Helper $taxonomy_helper)
        {
        }
        /**
         * Returns objects to be indexed.
         *
         * @return array Objects to be indexed.
         */
        protected function get_objects()
        {
        }
        /**
         * Builds a query for counting the number of unindexed term links.
         *
         * @return string The prepared query string.
         */
        protected function get_count_query()
        {
        }
        /**
         * Builds a query for selecting the ID's of unindexed term links.
         *
         * @param int|false $limit The maximum number of term link IDs to return.
         *
         * @return string The prepared query string.
         */
        protected function get_select_query($limit = false)
        {
        }
    }
}
namespace Yoast\WP\SEO\Actions\SEMrush {
    /**
     * Class SEMrush_Login_Action
     */
    class SEMrush_Login_Action
    {
        /**
         * The SEMrush_Client instance.
         *
         * @var SEMrush_Client
         */
        protected $client;
        /**
         * SEMrush_Login_Action constructor.
         *
         * @param SEMrush_Client $client The API client.
         */
        public function __construct(\Yoast\WP\SEO\Config\SEMrush_Client $client)
        {
        }
        /**
         * Authenticates with SEMrush to request the necessary tokens.
         *
         * @param string $code The authentication code to use to request a token with.
         *
         * @return object The response object.
         */
        public function authenticate($code)
        {
        }
        /**
         * Performs the login request, if necessary.
         */
        public function login()
        {
        }
    }
    /**
     * Class SEMrush_Options_Action
     */
    class SEMrush_Options_Action
    {
        /**
         * The Options_Helper instance.
         *
         * @var Options_Helper
         */
        protected $options_helper;
        /**
         * SEMrush_Options_Action constructor.
         *
         * @param Options_Helper $options_helper The WPSEO options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options_helper)
        {
        }
        /**
         * Stores SEMrush country code in the WPSEO options.
         *
         * @param string $country_code The country code to store.
         *
         * @return object The response object.
         */
        public function set_country_code($country_code)
        {
        }
    }
    /**
     * Class SEMrush_Phrases_Action
     */
    class SEMrush_Phrases_Action
    {
        /**
         * The transient cache key.
         */
        const TRANSIENT_CACHE_KEY = 'wpseo_semrush_related_keyphrases_%s_%s';
        /**
         * The SEMrush keyphrase URL.
         *
         * @var string
         */
        const KEYPHRASES_URL = 'https://oauth.semrush.com/api/v1/keywords/phrase_fullsearch';
        /**
         * The SEMrush_Client instance.
         *
         * @var SEMrush_Client
         */
        protected $client;
        /**
         * SEMrush_Phrases_Action constructor.
         *
         * @param SEMrush_Client $client The API client.
         */
        public function __construct(\Yoast\WP\SEO\Config\SEMrush_Client $client)
        {
        }
        /**
         * Gets the related keyphrases and data based on the passed keyphrase and database country code.
         *
         * @param string $keyphrase The keyphrase to search for.
         * @param string $database  The database's country code.
         *
         * @return object The response object.
         */
        public function get_related_keyphrases($keyphrase, $database)
        {
        }
        /**
         * Converts the passed dataset to an object.
         *
         * @param array $result The result dataset to convert to an object.
         *
         * @return object The result object.
         */
        protected function to_result_object($result)
        {
        }
    }
}
namespace Yoast\WP\SEO\Builders {
    /**
     * Trait for determine the social image to use in the indexable.
     *
     * Represents the trait used in builders for handling social images.
     */
    trait Indexable_Social_Image_Trait
    {
        /**
         * The image helper.
         *
         * @var Image_Helper
         */
        protected $image;
        /**
         * The Open Graph image helper.
         *
         * @var Open_Graph_Image_Helper
         */
        protected $open_graph_image;
        /**
         * The Twitter image helper.
         *
         * @var Twitter_Image_Helper
         */
        protected $twitter_image;
        /**
         * Sets the helpers for the trait.
         *
         * @required
         *
         * @param Image_Helper            $image            The image helper.
         * @param Open_Graph_Image_Helper $open_graph_image The Open Graph image helper.
         * @param Twitter_Image_Helper    $twitter_image    The Twitter image helper.
         */
        public function set_social_image_helpers(\Yoast\WP\SEO\Helpers\Image_Helper $image, \Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper $open_graph_image, \Yoast\WP\SEO\Helpers\Twitter\Image_Helper $twitter_image)
        {
        }
        /**
         * Sets the alternative on an indexable.
         *
         * @param array     $alternative_image The alternative image to set.
         * @param Indexable $indexable         The indexable to set image for.
         */
        protected function set_alternative_image(array $alternative_image, \Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Sets the Open Graph image meta data for an og image
         *
         * @param Indexable $indexable The indexable.
         */
        protected function set_open_graph_image_meta_data(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Handles the social images.
         *
         * @param Indexable $indexable The indexable to handle.
         */
        protected function handle_social_images(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Resets the social images.
         *
         * @param Indexable $indexable The indexable to set images for.
         */
        protected function reset_social_images(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
    }
    /**
     * Author Builder for the indexables.
     *
     * Formats the author meta to indexable format.
     */
    class Indexable_Author_Builder
    {
        use \Yoast\WP\SEO\Builders\Indexable_Social_Image_Trait;
        /**
         * The author archive helper.
         *
         * @var Author_Archive_Helper
         */
        private $author_archive;
        /**
         * Indexable_Author_Builder constructor.
         *
         * @param Author_Archive_Helper $author_archive The author archive helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Author_Archive_Helper $author_archive)
        {
        }
        /**
         * Formats the data.
         *
         * @param int       $user_id   The user to retrieve the indexable for.
         * @param Indexable $indexable The indexable to format.
         *
         * @return Indexable The extended indexable.
         */
        public function build($user_id, \Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Retrieves the meta data for this indexable.
         *
         * @param int $user_id The user to retrieve the meta data for.
         *
         * @return array List of meta entries.
         */
        protected function get_meta_data($user_id)
        {
        }
        /**
         * Retrieves the author meta.
         *
         * @param int    $user_id The user to retrieve the indexable for.
         * @param string $key     The meta entry to retrieve.
         *
         * @return string|null The value of the meta field.
         */
        protected function get_author_meta($user_id, $key)
        {
        }
        /**
         * Finds an alternative image for the social image.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return array|bool False when not found, array with data when found.
         */
        protected function find_alternative_image(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
    }
    /**
     * Builder for the indexables.
     *
     * Creates all the indexables.
     */
    class Indexable_Builder
    {
        /**
         * The author builder.
         *
         * @var Indexable_Author_Builder
         */
        private $author_builder;
        /**
         * The post builder.
         *
         * @var Indexable_Post_Builder
         */
        private $post_builder;
        /**
         * The term builder.
         *
         * @var Indexable_Term_Builder
         */
        private $term_builder;
        /**
         * The home page builder.
         *
         * @var Indexable_Home_Page_Builder
         */
        private $home_page_builder;
        /**
         * The post type archive builder.
         *
         * @var Indexable_Post_Type_Archive_Builder
         */
        private $post_type_archive_builder;
        /**
         * The data archive builder.
         *
         * @var Indexable_Date_Archive_Builder
         */
        private $date_archive_builder;
        /**
         * The system page builder.
         *
         * @var Indexable_System_Page_Builder
         */
        private $system_page_builder;
        /**
         * The indexable hierarchy builder.
         *
         * @var Indexable_Hierarchy_Builder
         */
        private $hierarchy_builder;
        /**
         * The primary term builder
         *
         * @var Primary_Term_Builder
         */
        private $primary_term_builder;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        private $indexable_repository;
        /**
         * The indexable helper.
         *
         * @var Indexable_Helper
         */
        protected $indexable_helper;
        /**
         * Returns the instance of this class constructed through the ORM Wrapper.
         *
         * @param Indexable_Author_Builder            $author_builder            The author builder for creating missing indexables.
         * @param Indexable_Post_Builder              $post_builder              The post builder for creating missing indexables.
         * @param Indexable_Term_Builder              $term_builder              The term builder for creating missing indexables.
         * @param Indexable_Home_Page_Builder         $home_page_builder         The front page builder for creating missing indexables.
         * @param Indexable_Post_Type_Archive_Builder $post_type_archive_builder The post type archive builder for creating missing indexables.
         * @param Indexable_Date_Archive_Builder      $date_archive_builder      The date archive builder for creating missing indexables.
         * @param Indexable_System_Page_Builder       $system_page_builder       The search result builder for creating missing indexables.
         * @param Indexable_Hierarchy_Builder         $hierarchy_builder         The hierarchy builder for creating the indexable hierarchy.
         * @param Primary_Term_Builder                $primary_term_builder      The primary term builder for creating primary terms for posts.
         * @param Indexable_Helper                    $indexable_helper          The indexable helper.
         */
        public function __construct(\Yoast\WP\SEO\Builders\Indexable_Author_Builder $author_builder, \Yoast\WP\SEO\Builders\Indexable_Post_Builder $post_builder, \Yoast\WP\SEO\Builders\Indexable_Term_Builder $term_builder, \Yoast\WP\SEO\Builders\Indexable_Home_Page_Builder $home_page_builder, \Yoast\WP\SEO\Builders\Indexable_Post_Type_Archive_Builder $post_type_archive_builder, \Yoast\WP\SEO\Builders\Indexable_Date_Archive_Builder $date_archive_builder, \Yoast\WP\SEO\Builders\Indexable_System_Page_Builder $system_page_builder, \Yoast\WP\SEO\Builders\Indexable_Hierarchy_Builder $hierarchy_builder, \Yoast\WP\SEO\Builders\Primary_Term_Builder $primary_term_builder, \Yoast\WP\SEO\Helpers\Indexable_Helper $indexable_helper)
        {
        }
        /**
         * Sets the indexable repository. Done to avoid circular dependencies.
         *
         * @required
         *
         * @param Indexable_Repository $indexable_repository The indexable repository.
         */
        public function set_indexable_repository(\Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository)
        {
        }
        /**
         * Creates an indexable by its ID and type.
         *
         * @param int            $object_id   The indexable object ID.
         * @param string         $object_type The indexable object type.
         * @param Indexable|bool $indexable   Optional. An existing indexable to overwrite.
         *
         * @return bool|Indexable Instance of indexable. False when unable to build.
         */
        public function build_for_id_and_type($object_id, $object_type, $indexable = false)
        {
        }
        /**
         * Creates an indexable for the homepage.
         *
         * @param Indexable|bool $indexable Optional. An existing indexable to overwrite.
         *
         * @return Indexable The home page indexable.
         */
        public function build_for_home_page($indexable = false)
        {
        }
        /**
         * Creates an indexable for the date archive.
         *
         * @param Indexable|bool $indexable Optional. An existing indexable to overwrite.
         *
         * @return Indexable The date archive indexable.
         */
        public function build_for_date_archive($indexable = false)
        {
        }
        /**
         * Creates an indexable for a post type archive.
         *
         * @param string         $post_type The post type.
         * @param Indexable|bool $indexable Optional. An existing indexable to overwrite.
         *
         * @return Indexable The post type archive indexable.
         */
        public function build_for_post_type_archive($post_type, $indexable = false)
        {
        }
        /**
         * Creates an indexable for a system page.
         *
         * @param string         $object_sub_type The type of system page.
         * @param Indexable|bool $indexable       Optional. An existing indexable to overwrite.
         *
         * @return Indexable The search result indexable.
         */
        public function build_for_system_page($object_sub_type, $indexable = false)
        {
        }
        /**
         * Ensures we have a valid indexable. Creates one if false is passed.
         *
         * @param Indexable|false $indexable The indexable.
         *
         * @return Indexable The indexable.
         */
        private function ensure_indexable($indexable)
        {
        }
        /**
         * Saves and returns an indexable (on production environments only).
         *
         * @param Indexable      $indexable        The indexable.
         * @param Indexable|null $indexable_before The indexable before possible changes.
         *
         * @return Indexable The indexable.
         */
        private function save_indexable($indexable, $indexable_before = null)
        {
        }
    }
    /**
     * Date Archive Builder for the indexables.
     *
     * Formats the date archive meta to indexable format.
     */
    class Indexable_Date_Archive_Builder
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Indexable_Date_Archive_Builder constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Formats the data.
         *
         * @param Indexable $indexable The indexable to format.
         *
         * @return Indexable The extended indexable.
         */
        public function build($indexable)
        {
        }
    }
    /**
     * Builder for the indexables hierarchy.
     *
     * Builds the indexable hierarchy for indexables.
     */
    class Indexable_Hierarchy_Builder
    {
        /**
         * Holds a list of indexables where the ancestors are saved for.
         *
         * @var array
         */
        protected $saved_ancestors = [];
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        private $indexable_repository;
        /**
         * The indexable hierarchy repository.
         *
         * @var Indexable_Hierarchy_Repository
         */
        private $indexable_hierarchy_repository;
        /**
         * The primary term repository.
         *
         * @var Primary_Term_Repository
         */
        private $primary_term_repository;
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Holds the Post_Helper instance.
         *
         * @var Post_Helper
         */
        private $post;
        /**
         * Indexable_Author_Builder constructor.
         *
         * @param Indexable_Hierarchy_Repository $indexable_hierarchy_repository The indexable hierarchy repository.
         * @param Primary_Term_Repository        $primary_term_repository        The primary term repository.
         * @param Options_Helper                 $options                        The options helper.
         * @param Post_Helper                    $post                           The post helper.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\Indexable_Hierarchy_Repository $indexable_hierarchy_repository, \Yoast\WP\SEO\Repositories\Primary_Term_Repository $primary_term_repository, \Yoast\WP\SEO\Helpers\Options_Helper $options, \Yoast\WP\SEO\Helpers\Post_Helper $post)
        {
        }
        /**
         * Sets the indexable repository. Done to avoid circular dependencies.
         *
         * @required
         *
         * @param Indexable_Repository $indexable_repository The indexable repository.
         */
        public function set_indexable_repository(\Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository)
        {
        }
        /**
         * Builds the ancestor hierarchy for an indexable.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return Indexable The indexable.
         */
        public function build(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Checks if a hierarchy is built already for the given indexable.
         *
         * @param Indexable $indexable The indexable to check.
         *
         * @return bool True when indexable has a built hierarchy.
         */
        protected function hierarchy_is_built(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Saves the ancestors.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return void
         */
        private function save_ancestors($indexable)
        {
        }
        /**
         * Adds ancestors for a post.
         *
         * @param int   $indexable_id The indexable id, this is the id of the original indexable.
         * @param int   $post_id      The post id, this is the id of the post currently being evaluated.
         * @param int[] $parents      The indexable IDs of all parents.
         *
         * @return void
         */
        private function add_ancestors_for_post($indexable_id, $post_id, &$parents)
        {
        }
        /**
         * Adds ancestors for a term.
         *
         * @param int   $indexable_id The indexable id, this is the id of the original indexable.
         * @param int   $term_id      The term id, this is the id of the term currently being evaluated.
         * @param int[] $parents      The indexable IDs of all parents.
         *
         * @return void
         */
        private function add_ancestors_for_term($indexable_id, $term_id, &$parents = [])
        {
        }
        /**
         * Gets the primary term ID for a post.
         *
         * @param WP_Post $post The post.
         *
         * @return int The primary term ID. 0 if none exists.
         */
        private function find_primary_term_id_for_post($post)
        {
        }
        /**
         * Find the deepest term in an array of term objects.
         *
         * @param array $terms Terms set.
         *
         * @return int The deepest term ID.
         */
        private function find_deepest_term_id($terms)
        {
        }
        /**
         * Get a term's parents.
         *
         * @param WP_Term $term Term to get the parents for.
         *
         * @return WP_Term[] An array of all this term's parents.
         */
        private function get_term_parents($term)
        {
        }
        /**
         * Checks if an ancestor is valid to add.
         *
         * @param Indexable $ancestor     The ancestor (presumed indexable) to check.
         * @param int       $indexable_id The indexable id we're adding ancestors for.
         * @param int[]     $parents      The indexable ids of the parents already added.
         *
         * @return bool
         */
        private function is_invalid_ancestor($ancestor, $indexable_id, $parents)
        {
        }
        /**
         * Returns the ID for an indexable. Catches situations where the id is null due to errors.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return string|int A unique ID for the indexable.
         */
        private function get_indexable_id(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Returns the primary term id of a post.
         *
         * @param int    $post_id       The post ID.
         * @param string $main_taxonomy The main taxonomy.
         *
         * @return int The ID of the primary term.
         */
        private function get_primary_term_id($post_id, $main_taxonomy)
        {
        }
    }
    /**
     * Homepage Builder for the indexables.
     *
     * Formats the homepage meta to indexable format.
     *
     * @phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded -- 4 words is fine.
     */
    class Indexable_Home_Page_Builder
    {
        use \Yoast\WP\SEO\Builders\Indexable_Social_Image_Trait;
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * The URL helper.
         *
         * @var Url_Helper
         */
        private $url;
        /**
         * Indexable_Home_Page_Builder constructor.
         *
         * @param Options_Helper $options The options helper.
         * @param Url_Helper     $url     The url helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options, \Yoast\WP\SEO\Helpers\Url_Helper $url)
        {
        }
        /**
         * Formats the data.
         *
         * @param Indexable $indexable The indexable to format.
         *
         * @return Indexable The extended indexable.
         */
        public function build($indexable)
        {
        }
    }
    /**
     * Indexable link builder.
     */
    class Indexable_Link_Builder
    {
        /**
         * The SEO links repository.
         *
         * @var SEO_Links_Repository
         */
        protected $seo_links_repository;
        /**
         * The url helper.
         *
         * @var Url_Helper
         */
        protected $url_helper;
        /**
         * The image helper.
         *
         * @var Image_Helper
         */
        protected $image_helper;
        /**
         * The post helper.
         *
         * @var Post_Helper
         */
        protected $post_helper;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        protected $indexable_repository;
        /**
         * Indexable_Link_Builder constructor.
         *
         * @param SEO_Links_Repository $seo_links_repository The SEO links repository.
         * @param Url_Helper           $url_helper           The URL helper.
         * @param Post_Helper          $post_helper          The post helper.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\SEO_Links_Repository $seo_links_repository, \Yoast\WP\SEO\Helpers\Url_Helper $url_helper, \Yoast\WP\SEO\Helpers\Post_Helper $post_helper)
        {
        }
        /**
         * Sets the indexable repository.
         *
         * @required
         *
         * @param Indexable_Repository $indexable_repository The indexable repository.
         * @param Image_Helper         $image_helper         The image helper.
         *
         * @return void
         */
        public function set_dependencies(\Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository, \Yoast\WP\SEO\Helpers\Image_Helper $image_helper)
        {
        }
        /**
         * Builds the links for a post.
         *
         * @param Indexable $indexable The indexable.
         * @param string    $content   The content. Expected to be unfiltered.
         *
         * @return SEO_Links[] The created SEO links.
         */
        public function build($indexable, $content)
        {
        }
        /**
         * Deletes all SEO links for an indexable.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return void
         */
        public function delete($indexable)
        {
        }
        /**
         * Gathers all links from content.
         *
         * @param string $content The content.
         *
         * @return string[] An array of urls.
         */
        protected function gather_links($content)
        {
        }
        /**
         * Gathers all images from content.
         *
         * @param string $content The content.
         *
         * @return string[] An array of urls.
         */
        protected function gather_images($content)
        {
        }
        /**
         * Creates link models from lists of URLs and image sources.
         *
         * @param Indexable $indexable The indexable.
         * @param string[]  $links     The link URLs.
         * @param string[]  $images    The image sources.
         *
         * @return SEO_Links[] The link models.
         */
        protected function create_links($indexable, $links, $images)
        {
        }
        /**
         * Get the post ID based on the link's type and its target's permalink.
         *
         * @param string $type      The type of link (either SEO_Links::TYPE_INTERNAL or SEO_Links::TYPE_INTERNAL_IMAGE).
         * @param string $permalink The permalink of the link's target.
         *
         * @return int The post ID.
         */
        protected function get_post_id($type, $permalink)
        {
        }
        /**
         * Creates an internal link.
         *
         * @param string    $url       The url of the link.
         * @param array     $home_url  The home url, as parsed by wp_parse_url.
         * @param Indexable $indexable The indexable of the post containing the link.
         * @param bool      $is_image  Whether or not the link is an image.
         *
         * @return SEO_Links The created link.
         */
        protected function create_internal_link($url, $home_url, $indexable, $is_image = false)
        {
        }
        /**
         * Filters out links that point to the same page with a fragment or query.
         *
         * @param SEO_Links $link        The link.
         * @param array     $current_url The url of the page the link is on, as parsed by wp_parse_url.
         *
         * @return bool Whether or not the link should be filtered.
         */
        protected function filter_link(\Yoast\WP\SEO\Models\SEO_Links $link, $current_url)
        {
        }
        /**
         * Updates the link counts for related indexables.
         *
         * @param Indexable   $indexable The indexable.
         * @param SEO_Links[] $links     The link models.
         *
         * @return void
         */
        protected function update_related_indexables($indexable, $links)
        {
        }
        /**
         * Creates a diff between two arrays of SEO links, based on urls.
         *
         * @param SEO_Links[] $links_a The array to compare.
         * @param SEO_Links[] $links_b The array to compare against.
         *
         * @return SEO_Links[] Links that are in $links_a, but not in $links_b.
         */
        protected function links_diff($links_a, $links_b)
        {
        }
        /**
         * Returns the number of internal links in an array of link models.
         *
         * @param SEO_Links[] $links The link models.
         *
         * @return int The number of internal links.
         */
        protected function get_internal_link_count($links)
        {
        }
        /**
         * Returns a cleaned permalink for a given link.
         *
         * @param string $link     The raw URL.
         * @param array  $home_url The home URL, as parsed by wp_parse_url.
         *
         * @return string The cleaned permalink.
         */
        protected function get_permalink($link, $home_url)
        {
        }
        /**
         * Updates incoming link counts for related indexables.
         *
         * @param int[] $related_indexable_ids The IDs of all related indexables.
         *
         * @return void
         */
        protected function update_incoming_links_for_related_indexables($related_indexable_ids)
        {
        }
    }
    /**
     * Post Builder for the indexables.
     *
     * Formats the post meta to indexable format.
     */
    class Indexable_Post_Builder
    {
        use \Yoast\WP\SEO\Builders\Indexable_Social_Image_Trait;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        protected $indexable_repository;
        /**
         * Holds the Post_Helper instance.
         *
         * @var Post_Helper
         */
        protected $post_helper;
        /**
         * The post type helper.
         *
         * @var Post_Type_Helper
         */
        protected $post_type_helper;
        /**
         * Indexable_Post_Builder constructor.
         *
         * @param Post_Helper      $post_helper      The post helper.
         * @param Post_Type_Helper $post_type_helper The post type helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Post_Helper $post_helper, \Yoast\WP\SEO\Helpers\Post_Type_Helper $post_type_helper)
        {
        }
        /**
         * Sets the indexable repository. Done to avoid circular dependencies.
         *
         * @required
         *
         * @param Indexable_Repository $indexable_repository The indexable repository.
         */
        public function set_indexable_repository(\Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository)
        {
        }
        /**
         * Formats the data.
         *
         * @param int       $post_id   The post ID to use.
         * @param Indexable $indexable The indexable to format.
         *
         * @return bool|Indexable The extended indexable. False when unable to build.
         *
         * @throws Post_Not_Found_Exception When the post could not be found.
         */
        public function build($post_id, $indexable)
        {
        }
        /**
         * Retrieves the permalink for a post with the given post type and ID.
         *
         * @param string $post_type The post type.
         * @param int    $post_id   The post ID.
         *
         * @return false|string|WP_Error The permalink.
         */
        protected function get_permalink($post_type, $post_id)
        {
        }
        /**
         * Determines the value of is_public.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return bool|null Whether or not the post type is public. Null if no override is set.
         */
        protected function is_public($indexable)
        {
        }
        /**
         * Determines the value of is_public for attachments.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return bool|null False when it has no parent. Null when it has a parent.
         */
        protected function is_public_attachment($indexable)
        {
        }
        /**
         * Determines the value of has_public_posts.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return bool|null Whether the attachment has a public parent, can be true, false and null. Null when it is not an attachment.
         */
        protected function has_public_posts($indexable)
        {
        }
        /**
         * Converts the meta robots noindex value to the indexable value.
         *
         * @param int $value Meta value to convert.
         *
         * @return bool|null True for noindex, false for index, null for default of parent/type.
         */
        protected function get_robots_noindex($value)
        {
        }
        /**
         * Retrieves the robot options to search for.
         *
         * @return array List of robots values.
         */
        protected function get_robots_options()
        {
        }
        /**
         * Determines the focus keyword score.
         *
         * @param string $keyword The focus keyword that is set.
         * @param int    $score   The score saved on the meta data.
         *
         * @return int|null Score to use.
         */
        protected function get_keyword_score($keyword, $score)
        {
        }
        /**
         * Retrieves the lookup table.
         *
         * @return array Lookup table for the indexable fields.
         */
        protected function get_indexable_lookup()
        {
        }
        /**
         * Retrieves the current value for the meta field.
         *
         * @param int    $post_id  The post ID to use.
         * @param string $meta_key Meta key to fetch.
         *
         * @return mixed The value of the indexable entry to use.
         */
        protected function get_meta_value($post_id, $meta_key)
        {
        }
        /**
         * Finds an alternative image for the social image.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return array|bool False when not found, array with data when found.
         */
        protected function find_alternative_image(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Gets the number of pages for a post.
         *
         * @param object $post The post object.
         *
         * @return int|null The number of pages or null if the post isn't paginated.
         */
        protected function get_number_of_pages_for_post($post)
        {
        }
        /**
         * Checks whether an indexable should be built for this post.
         *
         * @param WP_Post $post The post for which an indexable should be built.
         *
         * @return bool `true` if the post should be excluded from building, `false` if not.
         */
        protected function should_exclude_post($post)
        {
        }
    }
    /**
     * Post type archive builder for the indexables.
     *
     * Formats the post type archive meta to indexable format.
     */
    class Indexable_Post_Type_Archive_Builder
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Indexable_Post_Type_Archive_Builder constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Formats the data.
         *
         * @param string    $post_type The post type to build the indexable for.
         * @param Indexable $indexable The indexable to format.
         *
         * @return Indexable The extended indexable.
         */
        public function build($post_type, \Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
        /**
         * Returns the fallback breadcrumb title for a given post.
         *
         * @param string $post_type The post type to get the fallback breadcrumb title for.
         *
         * @return string
         */
        private function get_breadcrumb_title($post_type)
        {
        }
    }
    /**
     * System page builder for the indexables.
     *
     * Formats system pages ( search and error ) meta to indexable format.
     */
    class Indexable_System_Page_Builder
    {
        /**
         * Mapping of object type to title option keys.
         */
        const OPTION_MAPPING = ['search-result' => ['title' => 'title-search-wpseo'], '404' => ['title' => 'title-404-wpseo', 'breadcrumb_title' => 'breadcrumbs-404crumb']];
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Indexable_System_Page_Builder constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Formats the data.
         *
         * @param string    $object_sub_type The object sub type of the system page.
         * @param Indexable $indexable       The indexable to format.
         *
         * @return Indexable The extended indexable.
         */
        public function build($object_sub_type, \Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
    }
    /**
     * Term Builder for the indexables.
     *
     * Formats the term meta to indexable format.
     */
    class Indexable_Term_Builder
    {
        use \Yoast\WP\SEO\Builders\Indexable_Social_Image_Trait;
        /**
         * Holds the taxonomy helper instance.
         *
         * @var Taxonomy_Helper
         */
        private $taxonomy;
        /**
         * Indexable_Term_Builder constructor.
         *
         * @param Taxonomy_Helper $taxonomy The taxonomy helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Taxonomy_Helper $taxonomy)
        {
        }
        /**
         * Formats the data.
         *
         * @param int       $term_id   ID of the term to save data for.
         * @param Indexable $indexable The indexable to format.
         *
         * @return bool|Indexable The extended indexable. False when unable to build.
         *
         * @throws Invalid_Term_Exception When the term is invalid.
         * @throws Term_Not_Found_Exception When the term is not found.
         */
        public function build($term_id, $indexable)
        {
        }
        /**
         * Converts the meta noindex value to the indexable value.
         *
         * @param string $meta_value Term meta to base the value on.
         *
         * @return bool|null
         */
        protected function get_noindex_value($meta_value)
        {
        }
        /**
         * Determines the focus keyword score.
         *
         * @param string $keyword The focus keyword that is set.
         * @param int    $score   The score saved on the meta data.
         *
         * @return int|null Score to use.
         */
        protected function get_keyword_score($keyword, $score)
        {
        }
        /**
         * Retrieves the lookup table.
         *
         * @return array Lookup table for the indexable fields.
         */
        protected function get_indexable_lookup()
        {
        }
        /**
         * Retrieves a meta value from the given meta data.
         *
         * @param string $meta_key  The key to extract.
         * @param array  $term_meta The meta data.
         *
         * @return string|null The meta value.
         */
        protected function get_meta_value($meta_key, $term_meta)
        {
        }
        /**
         * Finds an alternative image for the social image.
         *
         * @param Indexable $indexable The indexable.
         *
         * @return array|bool False when not found, array with data when found.
         */
        protected function find_alternative_image(\Yoast\WP\SEO\Models\Indexable $indexable)
        {
        }
    }
    /**
     * Primary term builder.
     *
     * Creates the primary term for a post.
     */
    class Primary_Term_Builder
    {
        /**
         * The primary term repository.
         *
         * @var Primary_Term_Repository
         */
        protected $repository;
        /**
         * The primary term helper.
         *
         * @var Primary_Term_Helper
         */
        private $primary_term;
        /**
         * The meta helper.
         *
         * @var Meta_Helper
         */
        private $meta;
        /**
         * Primary_Term_Builder constructor.
         *
         * @param Primary_Term_Repository $repository   The primary term repository.
         * @param Primary_Term_Helper     $primary_term The primary term helper.
         * @param Meta_Helper             $meta         The meta helper.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\Primary_Term_Repository $repository, \Yoast\WP\SEO\Helpers\Primary_Term_Helper $primary_term, \Yoast\WP\SEO\Helpers\Meta_Helper $meta)
        {
        }
        /**
         * Formats and saves the primary terms for the post with the given post id.
         *
         * @param int $post_id The post ID.
         *
         * @return void
         */
        public function build($post_id)
        {
        }
        /**
         * Save the primary term for a specific taxonomy.
         *
         * @param int    $post_id  Post ID to save primary term for.
         * @param string $taxonomy Taxonomy to save primary term for.
         *
         * @return void
         */
        protected function save_primary_term($post_id, $taxonomy)
        {
        }
    }
}
namespace Yoast\WP\SEO\Commands {
    /**
     * Interface definition for WP CLI commands.
     *
     * An interface for registering integrations with WordPress.
     */
    interface Command_Interface
    {
        /**
         * Returns the namespace of this command.
         *
         * @return string
         */
        public static function get_namespace();
    }
    /**
     * Command to generate indexables for all posts and terms.
     */
    class Index_Command implements \Yoast\WP\SEO\Commands\Command_Interface
    {
        /**
         * The post indexation action.
         *
         * @var Indexable_Post_Indexation_Action
         */
        private $post_indexation_action;
        /**
         * The term indexation action.
         *
         * @var Indexable_Term_Indexation_Action
         */
        private $term_indexation_action;
        /**
         * The post type archive indexation action.
         *
         * @var Indexable_Post_Type_Archive_Indexation_Action
         */
        private $post_type_archive_indexation_action;
        /**
         * The general indexation action.
         *
         * @var Indexable_General_Indexation_Action
         */
        private $general_indexation_action;
        /**
         * The term link indexing action.
         *
         * @var Term_Link_Indexing_Action
         */
        private $term_link_indexing_action;
        /**
         * The post link indexing action.
         *
         * @var Post_Link_Indexing_Action
         */
        private $post_link_indexing_action;
        /**
         * The complete indexation action.
         *
         * @var Indexable_Indexing_Complete_Action
         */
        private $complete_indexation_action;
        /**
         * The indexing prepare action.
         *
         * @var Indexing_Prepare_Action
         */
        private $prepare_indexing_action;
        /**
         * Generate_Indexables_Command constructor.
         *
         * @param Indexable_Post_Indexation_Action              $post_indexation_action              The post indexation
         *                                                                                           action.
         * @param Indexable_Term_Indexation_Action              $term_indexation_action              The term indexation
         *                                                                                           action.
         * @param Indexable_Post_Type_Archive_Indexation_Action $post_type_archive_indexation_action The post type archive
         *                                                                                           indexation action.
         * @param Indexable_General_Indexation_Action           $general_indexation_action           The general indexation
         *                                                                                           action.
         * @param Indexable_Indexing_Complete_Action            $complete_indexation_action          The complete indexation
         *                                                                                           action.
         * @param Indexing_Prepare_Action                       $prepare_indexing_action             The prepare indexing
         *                                                                                           action.
         * @param Post_Link_Indexing_Action                     $post_link_indexing_action           The post link indexation
         *                                                                                           action.
         * @param Term_Link_Indexing_Action                     $term_link_indexing_action           The term link indexation
         *                                                                                           action.
         */
        public function __construct(\Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Indexation_Action $post_indexation_action, \Yoast\WP\SEO\Actions\Indexing\Indexable_Term_Indexation_Action $term_indexation_action, \Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Type_Archive_Indexation_Action $post_type_archive_indexation_action, \Yoast\WP\SEO\Actions\Indexing\Indexable_General_Indexation_Action $general_indexation_action, \Yoast\WP\SEO\Actions\Indexing\Indexable_Indexing_Complete_Action $complete_indexation_action, \Yoast\WP\SEO\Actions\Indexing\Indexing_Prepare_Action $prepare_indexing_action, \Yoast\WP\SEO\Actions\Indexing\Post_Link_Indexing_Action $post_link_indexing_action, \Yoast\WP\SEO\Actions\Indexing\Term_Link_Indexing_Action $term_link_indexing_action)
        {
        }
        /**
         * Gets the namespace.
         *
         * @return string
         */
        public static function get_namespace()
        {
        }
        /**
         * Indexes all your content to ensure the best performance.
         *
         * ## OPTIONS
         *
         * [--network]
         * : Performs the indexation on all sites within the network.
         *
         * [--reindex]
         * : Removes all existing indexables and then reindexes them.
         *
         * [--skip-confirmation]
         * : Skips the confirmations (for automated systems).
         *
         * ## EXAMPLES
         *
         *     wp yoast index
         *
         * @when after_wp_load
         *
         * @param array|null $args       The arguments.
         * @param array|null $assoc_args The associative arguments.
         *
         * @return void
         */
        public function index($args = null, $assoc_args = null)
        {
        }
        /**
         * Runs all indexation actions.
         *
         * @param array $assoc_args The associative arguments.
         *
         * @return void
         */
        protected function run_indexation_actions($assoc_args)
        {
        }
        /**
         * Runs an indexation action.
         *
         * @param string                      $name              The name of the object to be indexed.
         * @param Indexation_Action_Interface $indexation_action The indexation action.
         *
         * @return void
         */
        protected function run_indexation_action($name, \Yoast\WP\SEO\Actions\Indexing\Indexation_Action_Interface $indexation_action)
        {
        }
        /**
         * Clears the database related to the indexables.
         */
        protected function clear()
        {
        }
    }
}
namespace Yoast\WP\SEO\Conditionals {
    /**
     * Conditional interface, used to prevent integrations from loading.
     */
    interface Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met();
    }
    /**
     * Abstract class for creating conditionals based on feature flags.
     */
    abstract class Feature_Flag_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
        /**
         * Returns the name of the feature flag.
         * 'YOAST_SEO_' is automatically prepended to it and it will be uppercased.
         *
         * @return string the name of the feature flag.
         */
        protected abstract function get_feature_flag();
        /**
         * Returns the feature name.
         *
         * @return string the name of the feature flag.
         */
        public function get_feature_name()
        {
        }
    }
    /**
     * Checks if the Addon_Installation constant is set.
     */
    class Addon_Installation_Conditional extends \Yoast\WP\SEO\Conditionals\Feature_Flag_Conditional
    {
        /**
         * Returns the name of the feature flag.
         * 'YOAST_SEO_' is automatically prepended to it and it will be uppercased.
         *
         * @return string the name of the feature flag.
         */
        protected function get_feature_flag()
        {
        }
    }
    /**
     * Conditional that is only met when in the admin.
     */
    class Admin_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
}
namespace Yoast\WP\SEO\Conditionals\Admin {
    // phpcs:disable Yoast.NamingConventions.ObjectNameDepth.MaxExceeded -- Base class can't be written shorter without abbreviating.
    /**
     * Checks if the post is saved by inline-save. This is the case when doing quick edit.
     */
    class Doing_Post_Quick_Edit_Save_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Checks if the current request is ajax and the action is inline-save.
         *
         * @return bool True when the quick edit action is executed.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only when we want the Estimated Reading Time.
     */
    class Estimated_Reading_Time_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The Post Conditional.
         *
         * @var Post_Conditional
         */
        protected $post_conditional;
        /**
         * The Input Helper.
         *
         * @var Input_Helper
         */
        protected $input_helper;
        /**
         * Constructs the Estimated Reading Time Conditional.
         *
         * @param Post_Conditional $post_conditional The post conditional.
         * @param Input_Helper     $input_helper     The input helper.
         */
        public function __construct(\Yoast\WP\SEO\Conditionals\Admin\Post_Conditional $post_conditional, \Yoast\WP\SEO\Helpers\Input_Helper $input_helper)
        {
        }
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when current page is the tools page.
     */
    class Licenses_Page_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return boolean Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when on a post edit or new post page.
     */
    class Post_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when on a post overview page or during an ajax request.
     */
    class Posts_Overview_Or_Ajax_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
}
namespace Yoast\WP\SEO\Conditionals {
    /**
     * Conditional that is only met when in development mode.
     */
    class Development_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when NOT in the admin.
     */
    class Front_End_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns `true` when NOT on an admin page.
         *
         * @return bool `true` when NOT on an admin page.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when the current request uses the GET method.
     */
    class Get_Request_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when the headless rest endpoints are enabled.
     */
    class Headless_Rest_Endpoints_Enabled_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Headless_Rest_Endpoints_Enabled_Conditional constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Returns `true` whether the headless REST endpoints have been enabled.
         *
         * @return bool `true` when the headless REST endpoints have been enabled.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when Jetpack exists.
     */
    class Jetpack_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns `true` when the Jetpack plugin exists on this
         * WordPress installation.
         *
         * @return bool `true` when the Jetpack plugin exists on this WordPress installation.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when news SEO is activated.
     */
    class News_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return boolean Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Trait for integrations that do not have any conditionals.
     */
    trait No_Conditionals
    {
        /**
         * Returns an empty array, meaning no conditionals are required to load whatever uses this trait.
         *
         * @return array The conditionals that must be met to load this.
         */
        public static function get_conditionals()
        {
        }
    }
    /**
     * Conditional that is only met when current page is not a specific tool's page.
     */
    class No_Tool_Selected_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when the Open Graph feature is enabled.
     */
    class Open_Graph_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Open_Graph_Conditional constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Returns `true` when the Open Graph feature is enabled.
         *
         * @return bool `true` when the Open Graph feature is enabled.
         */
        public function is_met()
        {
        }
    }
    /**
     * Abstract class for creating conditionals based on feature flags.
     */
    class Premium_Inactive_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when in frontend or page is a post overview or post add/edit form.
     */
    class Primary_Category_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The current page helper.
         *
         * @var Current_Page_Helper
         */
        private $current_page;
        /**
         * Primary_Category_Conditional constructor.
         *
         * @param Current_Page_Helper $current_page The current page helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Current_Page_Helper $current_page)
        {
        }
        /**
         * Returns `true` when on the frontend,
         * or when on the post overview, post edit or new post admin page.
         *
         * @return bool `true` when on the frontend, or when on the post overview,
         *          post edit or new post admin page.
         */
        public function is_met()
        {
        }
    }
    /**
     * Checks if the YOAST_SEO_SCHEMA_BLOCKS constant is set.
     */
    class Schema_Blocks_Conditional extends \Yoast\WP\SEO\Conditionals\Feature_Flag_Conditional
    {
        /**
         * Returns the name of the feature flag.
         * 'YOAST_SEO_' is automatically prepended to it and it will be uppercased.
         *
         * @return string the name of the feature flag.
         */
        protected function get_feature_flag()
        {
        }
    }
    /**
     * Conditional that is only met when the SEMrush integration is enabled.
     */
    class SEMrush_Enabled_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * SEMrush_Enabled_Conditional constructor.
         *
         * @param Options_Helper $options The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options)
        {
        }
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Should_Index_Links_Conditional class.
     */
    class Should_Index_Links_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        protected $options_helper;
        /**
         * Should_Index_Links_Conditional constructor.
         *
         * @param Options_Helper $options_helper The options helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options_helper)
        {
        }
        /**
         * Returns `true` when the links on this website should be indexed.
         *
         * @return bool `true` when the links on this website should be indexed.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when The Events Calendar exists.
     */
    class The_Events_Calendar_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
}
namespace Yoast\WP\SEO\Conditionals\Third_Party {
    /**
     * Conditional that is met when the Elementor plugin is installed and activated.
     */
    class Elementor_Activated_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Checks if the Elementor plugins is installed and activated.
         *
         * @return bool `true` when the Elementor plugin is installed and activated.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when on an Elementor edit page or when the current
     * request is an ajax request for saving our post meta data.
     */
    class Elementor_Edit_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when in the admin.
     */
    class W3_Total_Cache_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when WPML is active.
     */
    class WPML_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is met when the Yoast SEO Multilingual plugin,
     * a glue plugin developed by and for WPML, is active.
     */
    class WPML_WPSEO_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Path to the Yoast SEO Multilingual plugin file.
         *
         * @internal
         */
        const PATH_TO_WPML_WPSEO_PLUGIN_FILE = 'wp-seo-multilingual/plugin.php';
        /**
         * Returns whether or not the Yoast SEO Multilingual plugin is active.
         *
         * @return bool Whether or not the Yoast SEO Multilingual plugin is active.
         */
        public function is_met()
        {
        }
    }
}
namespace Yoast\WP\SEO\Conditionals {
    /**
     * Conditional that is only met when Web Stories are active.
     */
    class Web_Stories_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns `true` when the Web Stories plugins is installed and active.
         *
         * @return bool `true` when the Web Stories plugins is installed and active.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when WooCommerce is active.
     */
    class WooCommerce_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns `true` when the WooCommerce plugin is installed and activated.
         *
         * @return bool `true` when the WooCommerce plugin is installed and activated.
         */
        public function is_met()
        {
        }
    }
    /**
     * Class that checks if wp_robots exists.
     */
    class WP_Robots_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Checks if the wp_robots function exists.
         *
         * @return bool True when the wp_robots function exists.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is met when the current request is an XML-RPC request.
     */
    class XMLRPC_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether the current request is an XML-RPC request.
         *
         * @return bool `true` when the current request is an XML-RPC request, `false` if not.
         */
        public function is_met()
        {
        }
    }
    /**
     * Conditional that is only met when in the admin dashboard, update or Yoast SEO pages.
     */
    class Yoast_Admin_And_Dashboard_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns `true` when on the admin dashboard, update or Yoast SEO pages.
         *
         * @return bool `true` when on the admin dashboard, update or Yoast SEO pages.
         */
        public function is_met()
        {
        }
        /**
         * Checks if we are on a theme or plugin upgrade page.
         *
         * @return bool Whether we are on a theme or plugin upgrade page.
         */
        private function on_upgrade_page()
        {
        }
    }
    /**
     * Conditional that is only met when current page is the tools page.
     */
    class Yoast_Tools_Page_Conditional implements \Yoast\WP\SEO\Conditionals\Conditional
    {
        /**
         * Returns whether or not this conditional is met.
         *
         * @return bool Whether or not the conditional is met.
         */
        public function is_met()
        {
        }
    }
}
namespace Yoast\WP\SEO\Config {
    /**
     * Class Badge_Group_Names.
     *
     * This class defines groups for "new" badges, with the version in which those groups are no longer considered
     * to be "new".
     */
    class Badge_Group_Names
    {
        const GROUP_GLOBAL_TEMPLATES = 'global-templates';
        /**
         * Constant describing when certain groups of new badges will no longer be shown.
         */
        const GROUP_NAMES = [self::GROUP_GLOBAL_TEMPLATES => '16.7-beta0'];
        /**
         * The current plugin version.
         *
         * @var string
         */
        protected $version;
        /**
         * Badge_Group_Names constructor.
         *
         * @param string|null $version Optional: the current plugin version.
         */
        public function __construct($version = null)
        {
        }
        /**
         * Check whether a group of badges is still eligible for a "new" badge.
         *
         * @param string      $group           One of the GROUP_* constants.
         * @param string|null $current_version The current version of the plugin that's being checked.
         *
         * @return bool Whether a group of badges is still eligible for a "new" badge.
         */
        public function is_still_eligible_for_new_badge($group, $current_version = null)
        {
        }
    }
    /**
     * Class Indexing_Reasons. Contains constants that aren't context specific.
     */
    class Indexing_Reasons
    {
        /**
         * Represents the reason that the indexing process failed and should be tried again.
         */
        const REASON_INDEXING_FAILED = 'indexing_failed';
        /**
         * Represents the reason that the permalink settings are changed.
         */
        const REASON_PERMALINK_SETTINGS = 'permalink_settings_changed';
        /**
         * Represents the reason that the category base is changed.
         */
        const REASON_CATEGORY_BASE_PREFIX = 'category_base_changed';
        /**
         * Represents the reason that the tag base is changed.
         */
        const REASON_TAG_BASE_PREFIX = 'tag_base_changed';
        /**
         * Represents the reason that the home url option is changed.
         */
        const REASON_HOME_URL_OPTION = 'home_url_option_changed';
    }
    /**
     * Migration_Status class.
     *
     * Used to validate whether or not migrations have been run and whether or not they should be run again.
     */
    class Migration_Status
    {
        /**
         * The migration option key.
         *
         * @var string
         */
        const MIGRATION_OPTION_KEY = 'yoast_migrations_';
        /**
         * The migration options.
         *
         * @var array
         */
        protected $migration_options = [];
        /**
         * Checks if a given migration should be run.
         *
         * @param string $name    The name of the migration.
         * @param string $version The current version.
         *
         * @return bool Whether or not the migration should be run.
         */
        public function should_run_migration($name, $version = \WPSEO_VERSION)
        {
        }
        /**
         * Checks whether or not the given migration is at least the given version, defaults to checking for the latest version.
         *
         * @param string $name    The name of the migration.
         * @param string $version The version to check, defaults to the latest version.
         *
         * @return bool Whether or not the requested migration is at least the requested version.
         */
        public function is_version($name, $version = \WPSEO_VERSION)
        {
        }
        /**
         * Gets the error of a given migration if it exists.
         *
         * @param string $name The name of the migration.
         *
         * @return bool|array False if there is no error, otherwise the error.
         */
        public function get_error($name)
        {
        }
        /**
         * Sets an error for the migration.
         *
         * @param string $name    The name of the migration.
         * @param string $message Message explaining the reason for the error.
         * @param string $version The current version.
         *
         * @return void
         */
        public function set_error($name, $message, $version = \WPSEO_VERSION)
        {
        }
        /**
         * Updates the migration version to the latest version.
         *
         * @param string $name    The name of the migration.
         * @param string $version The current version.
         *
         * @return void
         */
        public function set_success($name, $version = \WPSEO_VERSION)
        {
        }
        /**
         * Locks the migration status.
         *
         * @param string $name The name of the migration.
         *
         * @return bool Whether or not the migration was succesfully locked.
         */
        public function lock_migration($name)
        {
        }
        /**
         * Retrieves the migration option.
         *
         * @param string $name The name of the migration.
         *
         * @return bool|array The status of the migration, false if no status exists.
         */
        protected function get_migration_status($name)
        {
        }
        /**
         * Retrieves the migration option.
         *
         * @param string $name             The name of the migration.
         * @param array  $migration_status The migration status.
         *
         * @return bool True if the status was succesfully updated, false otherwise.
         */
        protected function set_migration_status($name, $migration_status)
        {
        }
    }
    /**
     * Class Schema_IDs.
     */
    class Schema_IDs
    {
        /**
         * Hash used for the Author `@id`.
         */
        const AUTHOR_HASH = '#author';
        /**
         * Hash used for the Author Logo's `@id`.
         */
        const AUTHOR_LOGO_HASH = '#authorlogo';
        /**
         * Hash used for the Breadcrumb's `@id`.
         */
        const BREADCRUMB_HASH = '#breadcrumb';
        /**
         * Hash used for the Person `@id`.
         */
        const PERSON_HASH = '#/schema/person/';
        /**
         * Hash used for the Article `@id`.
         */
        const ARTICLE_HASH = '#article';
        /**
         * Hash used for the Organization `@id`.
         */
        const ORGANIZATION_HASH = '#organization';
        /**
         * Hash used for the Organization `@id`.
         */
        const ORGANIZATION_LOGO_HASH = '#logo';
        /**
         * Hash used for the logo `@id`.
         */
        const PERSON_LOGO_HASH = '#personlogo';
        /**
         * Hash used for an Article's primary image `@id`.
         */
        const PRIMARY_IMAGE_HASH = '#primaryimage';
        /**
         * Hash used for the WebPage's `@id`.
         */
        const WEBPAGE_HASH = '#webpage';
        /**
         * Hash used for the Website's `@id`.
         */
        const WEBSITE_HASH = '#website';
    }
    /**
     * Class Schema_Types.
     */
    class Schema_Types
    {
        /**
         * Holds the possible schema page types.
         *
         * Capitalized in this way so the value can be directly used in the schema output.
         *
         * @var string[]
         */
        const PAGE_TYPES = ['WebPage' => '', 'ItemPage' => '', 'AboutPage' => '', 'FAQPage' => '', 'QAPage' => '', 'ProfilePage' => '', 'ContactPage' => '', 'MedicalWebPage' => '', 'CollectionPage' => '', 'CheckoutPage' => '', 'RealEstateListing' => '', 'SearchResultsPage' => ''];
        /**
         * Holds the possible schema article types.
         *
         * Capitalized in this way so the value can be directly used in the schema output.
         *
         * @var string[]
         */
        const ARTICLE_TYPES = ['Article' => '', 'SocialMediaPosting' => '', 'NewsArticle' => '', 'AdvertiserContentArticle' => '', 'SatiricalArticle' => '', 'ScholarlyArticle' => '', 'TechArticle' => '', 'Report' => '', 'None' => ''];
        /**
         * Gets the page type options.
         *
         * @return array[] The schema page type options.
         */
        public function get_page_type_options()
        {
        }
        /**
         * Gets the article type options.
         *
         * @return array[] The schema article type options.
         */
        public function get_article_type_options()
        {
        }
    }
}
namespace Yoast\WP\SEO\Presentations {
    /**
     * The abstract presentation class.
     */
    class Abstract_Presentation
    {
        /**
         * The model.
         *
         * @var mixed
         */
        public $model;
        /**
         * Whether or not there is a presentation prototype.
         *
         * @var bool
         */
        private $is_prototype = true;
        /**
         * Creates a model presentation.
         *
         * @param array $data The data that this is a presentation of.
         *
         * @return static A model presentation.
         *
         * @throws Exception If attempting to create a model presentation from another model presentation.
         */
        public function of($data)
        {
        }
        /**
         * Magic getter for lazy loading of generate functions.
         *
         * @param string $name The property to get.
         *
         * @return mixed The value if it could be generated.
         *
         * @throws Exception If there is no generator for the property.
         */
        public function __get($name)
        {
        }
        /**
         * Magic isset for ensuring methods that have a generator are recognised.
         *
         * @codeCoverageIgnore Wrapper method.
         *
         * @param string $name The property to get.
         *
         * @return bool Whether or not there is a generator for the requested property.
         */
        public function __isset($name)
        {
        }
        /**
         * Returns `true` if this class is a prototype.
         *
         * @return bool If this class is a prototype or not.
         *
         * @codeCoverageIgnore Wrapper method.
         */
        protected function is_prototype()
        {
        }
    }
}
namespace Yoast\WP\SEO\Context {
    /**
     * Class Meta_Tags_Context.
     *
     * Class that contains all relevant data for rendering the meta tags.
     *
     * @property string       $canonical
     * @property string       $title
     * @property string       $description
     * @property string       $id
     * @property string       $site_name
     * @property string       $wordpress_site_name
     * @property string       $site_url
     * @property string       $company_name
     * @property int          $company_logo_id
     * @property array        $company_logo_meta
     * @property int          $person_logo_id
     * @property array        $person_logo_meta
     * @property int          $site_user_id
     * @property string       $site_represents
     * @property array|false  $site_represents_reference
     * @property string       schema_page_type
     * @property string       $main_schema_id
     * @property string|array $main_entity_of_page
     * @property bool         $open_graph_enabled
     * @property string       $open_graph_publisher
     * @property string       $twitter_card
     * @property string       $page_type
     * @property bool         $has_image
     * @property int          $main_image_id
     * @property string       $main_image_url
     */
    class Meta_Tags_Context extends \Yoast\WP\SEO\Presentations\Abstract_Presentation
    {
        /**
         * The indexable.
         *
         * @var Indexable
         */
        public $indexable;
        /**
         * The WP Block Parser Block.
         *
         * @var WP_Block_Parser_Block[]
         */
        public $blocks;
        /**
         * The WP Post.
         *
         * @var WP_Post
         */
        public $post;
        /**
         * The indexable presentation.
         *
         * @var Indexable_Presentation
         */
        public $presentation;
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * The URL helper.
         *
         * @var Url_Helper
         */
        private $url;
        /**
         * The image helper.
         *
         * @var Image_Helper
         */
        private $image;
        /**
         * The ID helper.
         *
         * @var ID_Helper
         */
        private $id_helper;
        /**
         * The WPSEO Replace Vars object.
         *
         * @var WPSEO_Replace_Vars
         */
        private $replace_vars;
        /**
         * The site helper.
         *
         * @var Site_Helper
         */
        private $site;
        /**
         * The user helper.
         *
         * @var User_Helper
         */
        private $user;
        /**
         * The permalink helper.
         *
         * @var Permalink_Helper
         */
        private $permalink_helper;
        /**
         * The indexable helper.
         *
         * @var Indexable_Helper
         */
        private $indexable_helper;
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        private $indexable_repository;
        /**
         * Meta_Tags_Context constructor.
         *
         * @param Options_Helper       $options              The options helper.
         * @param Url_Helper           $url                  The url helper.
         * @param Image_Helper         $image                The image helper.
         * @param ID_Helper            $id_helper            The schema id helper.
         * @param WPSEO_Replace_Vars   $replace_vars         The replace vars helper.
         * @param Site_Helper          $site                 The site helper.
         * @param User_Helper          $user                 The user helper.
         * @param Permalink_Helper     $permalink_helper     The permalink helper.
         * @param Indexable_Helper     $indexable_helper     The indexable helper.
         * @param Indexable_Repository $indexable_repository The indexable repository.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Options_Helper $options, \Yoast\WP\SEO\Helpers\Url_Helper $url, \Yoast\WP\SEO\Helpers\Image_Helper $image, \Yoast\WP\SEO\Helpers\Schema\ID_Helper $id_helper, \WPSEO_Replace_Vars $replace_vars, \Yoast\WP\SEO\Helpers\Site_Helper $site, \Yoast\WP\SEO\Helpers\User_Helper $user, \Yoast\WP\SEO\Helpers\Permalink_Helper $permalink_helper, \Yoast\WP\SEO\Helpers\Indexable_Helper $indexable_helper, \Yoast\WP\SEO\Repositories\Indexable_Repository $indexable_repository)
        {
        }
        /**
         * Generates the title.
         *
         * @return string the title
         */
        public function generate_title()
        {
        }
        /**
         * Generates the description.
         *
         * @return string the description
         */
        public function generate_description()
        {
        }
        /**
         * Generates the canonical.
         *
         * @return string the canonical
         */
        public function generate_canonical()
        {
        }
        /**
         * Generates the id.
         *
         * @return string the id
         */
        public function generate_id()
        {
        }
        /**
         * Generates the site name.
         *
         * @return string The site name.
         */
        public function generate_site_name()
        {
        }
        /**
         * Generates the site name from the WordPress options.
         *
         * @return string The site name from the WordPress options.
         */
        public function generate_wordpress_site_name()
        {
        }
        /**
         * Generates the site url.
         *
         * @return string The site url.
         */
        public function generate_site_url()
        {
        }
        /**
         * Generates the company name.
         *
         * @return string The company name.
         */
        public function generate_company_name()
        {
        }
        /**
         * Generates the person logo id.
         *
         * @return int|bool The company logo id.
         */
        public function generate_person_logo_id()
        {
        }
        /**
         * Retrieve the person logo meta.
         *
         * @return array|bool
         */
        public function generate_person_logo_meta()
        {
        }
        /**
         * Generates the company logo id.
         *
         * @return int|bool The company logo id.
         */
        public function generate_company_logo_id()
        {
        }
        /**
         * Retrieve the company logo meta.
         *
         * @return array|bool
         */
        public function generate_company_logo_meta()
        {
        }
        /**
         * Generates the site user id.
         *
         * @return int The site user id.
         */
        public function generate_site_user_id()
        {
        }
        /**
         * Determines what our site represents, and grabs their values.
         *
         * @return string|false Person or company. False if invalid value.
         */
        public function generate_site_represents()
        {
        }
        /**
         * Returns the site represents reference.
         *
         * @return array|bool The site represents reference. False if none.
         */
        public function generate_site_represents_reference()
        {
        }
        /**
         * Returns whether or not open graph is enabled.
         *
         * @return bool Whether or not open graph is enabled.
         */
        public function generate_open_graph_enabled()
        {
        }
        /**
         * Returns the open graph publisher.
         *
         * @return string The open graph publisher.
         */
        public function generate_open_graph_publisher()
        {
        }
        /**
         * Returns the twitter card type.
         *
         * @return string The twitter card type.
         */
        public function generate_twitter_card()
        {
        }
        /**
         * Returns the schema page type.
         *
         * @return string|array The schema page type.
         */
        public function generate_schema_page_type()
        {
        }
        /**
         * Returns the schema article type.
         *
         * @return string|array The schema article type.
         */
        public function generate_schema_article_type()
        {
        }
        /**
         * Returns the main schema id.
         *
         * The main schema id.
         *
         * @return string
         */
        public function generate_main_schema_id()
        {
        }
        /**
         * Retrieves the main image URL. This is the featured image by default.
         *
         * @return string|null The main image URL.
         */
        public function generate_main_image_url()
        {
        }
        /**
         * Gets the main image ID.
         *
         * @return int|false|null The main image ID.
         */
        public function generate_main_image_id()
        {
        }
        /**
         * Determines whether the current indexable has an image.
         *
         * @return bool Whether the current indexable has an image.
         */
        public function generate_has_image()
        {
        }
        /**
         * Strips all nested dependencies from the debug info.
         *
         * @return array
         */
        public function __debugInfo()
        {
        }
        /* ********************* DEPRECATED METHODS ********************* */
        /**
         * Generates whether or not breadcrumbs are enabled.
         *
         * @deprecated 15.8
         * @codeCoverageIgnore
         *
         * @return bool Whether or not breadcrumbs are enabled.
         */
        public function generate_breadcrumbs_enabled()
        {
        }
    }
}
namespace Yoast\WP\SEO\Exceptions\Addon_Installation {
    /**
     * Class Addon_Activation_Error_Exception
     */
    class Addon_Activation_Error_Exception extends \Exception
    {
    }
    /**
     * Class Addon_Already_Installed_Exception
     */
    class Addon_Already_Installed_Exception extends \Exception
    {
    }
    /**
     * Class Addon_Installation_Error
     */
    class Addon_Installation_Error_Exception extends \Exception
    {
    }
    /**
     * Class User_Cannot_Activate_Plugins
     */
    class User_Cannot_Activate_Plugins_Exception extends \Exception
    {
    }
    /**
     * Class User_Cannot_Install_Plugins_Exception
     */
    class User_Cannot_Install_Plugins_Exception extends \Exception
    {
    }
}
namespace Yoast\WP\SEO\Exceptions\Indexable {
    /**
     * Class Indexable_Exception
     */
    abstract class Indexable_Exception extends \Exception
    {
    }
    /**
     * Class Indexable_Source_Exception
     */
    class Source_Exception extends \Yoast\WP\SEO\Exceptions\Indexable\Indexable_Exception
    {
    }
    /**
     * Exception that can be thrown whenever a term is considered invalid by WordPress
     * within the context of the indexables.
     */
    class Invalid_Term_Exception extends \Yoast\WP\SEO\Exceptions\Indexable\Source_Exception
    {
        /**
         * Exception that can be thrown whenever a term is considered invalid by WordPress
         * within the context of the indexables.
         *
         * @param string $reason The reason given by WordPress why the term is invalid.
         */
        public function __construct($reason)
        {
        }
    }
    /**
     * Exception that is thrown whenever a post could not be found
     * in the context of the indexables.
     */
    class Post_Not_Found_Exception extends \Yoast\WP\SEO\Exceptions\Indexable\Source_Exception
    {
        /**
         * Exception that is thrown whenever a post could not be found
         * in the context of the indexables.
         */
        public function __construct()
        {
        }
    }
    /**
     * Exception that is thrown whenever a term could not be found
     * in the context of the indexables.
     */
    class Term_Not_Found_Exception extends \Yoast\WP\SEO\Exceptions\Indexable\Source_Exception
    {
        /**
         * Exception that is thrown whenever a term could not be found
         * in the context of the indexables.
         */
        public function __construct()
        {
        }
    }
}
namespace Yoast\WP\SEO\Exceptions {
    /**
     * Exception to use when a method does not exist.
     */
    class Missing_Method extends \Exception
    {
        /**
         * Creates exception for a method that does not exist in a class.
         *
         * @param string $method     The method that does not exist.
         * @param string $class_name The class name.
         *
         * @return static Instance of the exception.
         */
        public static function for_class($method, $class_name)
        {
        }
    }
}
namespace Yoast\WP\SEO\Exceptions\OAuth {
    /**
     * Class Authentication_Failed_Exception
     */
    class Authentication_Failed_Exception extends \Exception
    {
        /**
         * Authentication_Failed_Exception constructor.
         *
         * @param Exception $original_exception The original exception.
         */
        public function __construct(\Exception $original_exception)
        {
        }
        /**
         * Returns a formatted response object.
         *
         * @return object The response object.
         */
        public function get_response()
        {
        }
    }
}
namespace Yoast\WP\SEO\Exceptions\SEMrush\Tokens {
    /**
     * Class Empty_Property_Exception
     */
    class Empty_Property_Exception extends \Exception
    {
        /**
         * Empty_Property_Exception constructor.
         *
         * @param string $property The property that is empty.
         */
        public function __construct($property)
        {
        }
    }
    /**
     * Class Empty_Token_Exception
     */
    class Empty_Token_Exception extends \Exception
    {
        /**
         * Empty_Token_Exception constructor.
         */
        public function __construct()
        {
        }
    }
    /**
     * Class Failed_Storage_Exception
     */
    class Failed_Storage_Exception extends \Exception
    {
        const DEFAULT_MESSAGE = 'Token storing failed. Please try again.';
        /**
         * Failed_Storage_Exception constructor.
         *
         * @param string $reason The reason why token storage failed. Optional.
         */
        public function __construct($reason = '')
        {
        }
    }
}
namespace YoastSEO_Vendor\Psr\Container {
    /**
     * Describes the interface of a container that exposes methods to read its entries.
     */
    interface ContainerInterface
    {
        /**
         * Finds an entry of the container by its identifier and returns it.
         *
         * @param string $id Identifier of the entry to look for.
         *
         * @throws NotFoundExceptionInterface  No entry was found for **this** identifier.
         * @throws ContainerExceptionInterface Error while retrieving the entry.
         *
         * @return mixed Entry.
         */
        public function get($id);
        /**
         * Returns true if the container can return an entry for the given identifier.
         * Returns false otherwise.
         *
         * `has($id)` returning true does not mean that `get($id)` will not throw an exception.
         * It does however mean that `get($id)` will not throw a `NotFoundExceptionInterface`.
         *
         * @param string $id Identifier of the entry to look for.
         *
         * @return bool
         */
        public function has($id);
    }
}
namespace YoastSEO_Vendor\Symfony\Component\DependencyInjection {
    /**
     * ContainerInterface is the interface implemented by service container classes.
     *
     * @author Fabien Potencier <fabien@symfony.com>
     * @author Johannes M. Schmitt <schmittjoh@gmail.com>
     */
    interface ContainerInterface extends \YoastSEO_Vendor\Psr\Container\ContainerInterface
    {
        const EXCEPTION_ON_INVALID_REFERENCE = 1;
        const NULL_ON_INVALID_REFERENCE = 2;
        const IGNORE_ON_INVALID_REFERENCE = 3;
        const IGNORE_ON_UNINITIALIZED_REFERENCE = 4;
        /**
         * Sets a service.
         *
         * @param string      $id      The service identifier
         * @param object|null $service The service instance
         */
        public function set($id, $service);
        /**
         * Gets a service.
         *
         * @param string $id              The service identifier
         * @param int    $invalidBehavior The behavior when the service does not exist
         *
         * @return object|null The associated service
         *
         * @throws ServiceCircularReferenceException When a circular reference is detected
         * @throws ServiceNotFoundException          When the service is not defined
         *
         * @see Reference
         */
        public function get($id, $invalidBehavior = self::EXCEPTION_ON_INVALID_REFERENCE);
        /**
         * Returns true if the given service is defined.
         *
         * @param string $id The service identifier
         *
         * @return bool true if the service is defined, false otherwise
         */
        public function has($id);
        /**
         * Check for whether or not a service has been initialized.
         *
         * @param string $id
         *
         * @return bool true if the service has been initialized, false otherwise
         */
        public function initialized($id);
        /**
         * Gets a parameter.
         *
         * @param string $name The parameter name
         *
         * @return mixed The parameter value
         *
         * @throws InvalidArgumentException if the parameter is not defined
         */
        public function getParameter($name);
        /**
         * Checks if a parameter exists.
         *
         * @param string $name The parameter name
         *
         * @return bool The presence of parameter in container
         */
        public function hasParameter($name);
        /**
         * Sets a parameter.
         *
         * @param string $name  The parameter name
         * @param mixed  $value The parameter value
         */
        public function setParameter($name, $value);
    }
    /**
     * ResettableContainerInterface defines additional resetting functionality
     * for containers, allowing to release shared services when the container is
     * not needed anymore.
     *
     * @author Christophe Coevoet <stof@notk.org>
     */
    interface ResettableContainerInterface extends \YoastSEO_Vendor\Symfony\Component\DependencyInjection\ContainerInterface
    {
        /**
         * Resets shared services from the container.
         *
         * The container is not intended to be used again after being reset in a normal workflow. This method is
         * meant as a way to release references for ref-counting.
         * A subsequent call to ContainerInterface::get will recreate a new instance of the shared service.
         */
        public function reset();
    }
    /**
     * Container is a dependency injection container.
     *
     * It gives access to object instances (services).
     * Services and parameters are simple key/pair stores.
     * The container can have four possible behaviors when a service
     * does not exist (or is not initialized for the last case):
     *
     *  * EXCEPTION_ON_INVALID_REFERENCE: Throws an exception (the default)
     *  * NULL_ON_INVALID_REFERENCE:      Returns null
     *  * IGNORE_ON_INVALID_REFERENCE:    Ignores the wrapping command asking for the reference
     *                                    (for instance, ignore a setter if the service does not exist)
     *  * IGNORE_ON_UNINITIALIZED_REFERENCE: Ignores/returns null for uninitialized services or invalid references
     *
     * @author Fabien Potencier <fabien@symfony.com>
     * @author Johannes M. Schmitt <schmittjoh@gmail.com>
     */
    class Container implements \YoastSEO_Vendor\Symfony\Component\DependencyInjection\ResettableContainerInterface
    {
        protected $parameterBag;
        protected $services = [];
        protected $fileMap = [];
        protected $methodMap = [];
        protected $aliases = [];
        protected $loading = [];
        protected $resolving = [];
        protected $syntheticIds = [];
        /**
         * @internal
         */
        protected $privates = [];
        /**
         * @internal
         */
        protected $normalizedIds = [];
        private $underscoreMap = ['_' => '', '.' => '_', '\\' => '_'];
        private $envCache = [];
        private $compiled = \false;
        private $getEnv;
        public function __construct(\YoastSEO_Vendor\Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface $parameterBag = null)
        {
        }
        /**
         * Compiles the container.
         *
         * This method does two things:
         *
         *  * Parameter values are resolved;
         *  * The parameter bag is frozen.
         */
        public function compile()
        {
        }
        /**
         * Returns true if the container is compiled.
         *
         * @return bool
         */
        public function isCompiled()
        {
        }
        /**
         * Returns true if the container parameter bag are frozen.
         *
         * @deprecated since version 3.3, to be removed in 4.0.
         *
         * @return bool true if the container parameter bag are frozen, false otherwise
         */
        public function isFrozen()
        {
        }
        /**
         * Gets the service container parameter bag.
         *
         * @return ParameterBagInterface A ParameterBagInterface instance
         */
        public function getParameterBag()
        {
        }
        /**
         * Gets a parameter.
         *
         * @param string $name The parameter name
         *
         * @return mixed The parameter value
         *
         * @throws InvalidArgumentException if the parameter is not defined
         */
        public function getParameter($name)
        {
        }
        /**
         * Checks if a parameter exists.
         *
         * @param string $name The parameter name
         *
         * @return bool The presence of parameter in container
         */
        public function hasParameter($name)
        {
        }
        /**
         * Sets a parameter.
         *
         * @param string $name  The parameter name
         * @param mixed  $value The parameter value
         */
        public function setParameter($name, $value)
        {
        }
        /**
         * Sets a service.
         *
         * Setting a synthetic service to null resets it: has() returns false and get()
         * behaves in the same way as if the service was never created.
         *
         * @param string      $id      The service identifier
         * @param object|null $service The service instance
         */
        public function set($id, $service)
        {
        }
        /**
         * Returns true if the given service is defined.
         *
         * @param string $id The service identifier
         *
         * @return bool true if the service is defined, false otherwise
         */
        public function has($id)
        {
        }
        /**
         * Gets a service.
         *
         * If a service is defined both through a set() method and
         * with a get{$id}Service() method, the former has always precedence.
         *
         * @param string $id              The service identifier
         * @param int    $invalidBehavior The behavior when the service does not exist
         *
         * @return object|null The associated service
         *
         * @throws ServiceCircularReferenceException When a circular reference is detected
         * @throws ServiceNotFoundException          When the service is not defined
         * @throws \Exception                        if an exception has been thrown when the service has been resolved
         *
         * @see Reference
         */
        public function get($id, $invalidBehavior = 1)
        {
        }
        /**
         * Returns true if the given service has actually been initialized.
         *
         * @param string $id The service identifier
         *
         * @return bool true if service has already been initialized, false otherwise
         */
        public function initialized($id)
        {
        }
        /**
         * {@inheritdoc}
         */
        public function reset()
        {
        }
        /**
         * Gets all service ids.
         *
         * @return string[] An array of all defined service ids
         */
        public function getServiceIds()
        {
        }
        /**
         * Gets service ids that existed at compile time.
         *
         * @return array
         */
        public function getRemovedIds()
        {
        }
        /**
         * Camelizes a string.
         *
         * @param string $id A string to camelize
         *
         * @return string The camelized string
         */
        public static function camelize($id)
        {
        }
        /**
         * A string to underscore.
         *
         * @param string $id The string to underscore
         *
         * @return string The underscored string
         */
        public static function underscore($id)
        {
        }
        /**
         * Creates a service by requiring its factory file.
         */
        protected function load($file)
        {
        }
        /**
         * Fetches a variable from the environment.
         *
         * @param string $name The name of the environment variable
         *
         * @return mixed The value to use for the provided environment variable name
         *
         * @throws EnvNotFoundException When the environment variable is not found and has no default value
         */
        protected function getEnv($name)
        {
        }
        /**
         * Returns the case sensitive id used at registration time.
         *
         * @param string $id
         *
         * @return string
         *
         * @internal
         */
        public function normalizeId($id)
        {
        }
        private function __clone()
        {
        }
    }
}
namespace Yoast\WP\SEO\Generated {
    /**
     * This class has been auto-generated
     * by the Symfony Dependency Injection Component.
     *
     * @final since Symfony 3.3
     */
    class Cached_Container extends \YoastSEO_Vendor\Symfony\Component\DependencyInjection\Container
    {
        private $parameters = [];
        private $targetDirs = [];
        public function __construct()
        {
        }
        public function getRemovedIds()
        {
        }
        public function compile()
        {
        }
        public function isCompiled()
        {
        }
        public function isFrozen()
        {
        }
        /**
         * Gets the public 'WPSEO_Addon_Manager' shared service.
         *
         * @return \WPSEO_Addon_Manager
         */
        protected function getWPSEOAddonManagerService()
        {
        }
        /**
         * Gets the public 'WPSEO_Admin_Asset_Manager' shared service.
         *
         * @return \WPSEO_Admin_Asset_Manager
         */
        protected function getWPSEOAdminAssetManagerService()
        {
        }
        /**
         * Gets the public 'WPSEO_Breadcrumbs' shared autowired service.
         *
         * @return \WPSEO_Breadcrumbs
         */
        protected function getWPSEOBreadcrumbsService()
        {
        }
        /**
         * Gets the public 'WPSEO_Frontend' shared autowired service.
         *
         * @return \WPSEO_Frontend
         */
        protected function getWPSEOFrontendService()
        {
        }
        /**
         * Gets the public 'WPSEO_Replace_Vars' shared service.
         *
         * @return \WPSEO_Replace_Vars
         */
        protected function getWPSEOReplaceVarsService()
        {
        }
        /**
         * Gets the public 'WPSEO_Shortlinker' shared service.
         *
         * @return \WPSEO_Shortlinker
         */
        protected function getWPSEOShortlinkerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\Lib\Migrations\Adapter' shared autowired service.
         *
         * @return \Yoast\WP\Lib\Migrations\Adapter
         */
        protected function getAdapterService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Addon_Installation\Addon_Activate_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Addon_Installation\Addon_Activate_Action
         */
        protected function getAddonActivateActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Addon_Installation\Addon_Install_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Addon_Installation\Addon_Install_Action
         */
        protected function getAddonInstallActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Alert_Dismissal_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Alert_Dismissal_Action
         */
        protected function getAlertDismissalActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexables\Indexable_Head_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexables\Indexable_Head_Action
         */
        protected function getIndexableHeadActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexable_General_Indexation_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexable_General_Indexation_Action
         */
        protected function getIndexableGeneralIndexationActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexable_Indexing_Complete_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexable_Indexing_Complete_Action
         */
        protected function getIndexableIndexingCompleteActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Indexation_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Indexation_Action
         */
        protected function getIndexablePostIndexationActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Type_Archive_Indexation_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexable_Post_Type_Archive_Indexation_Action
         */
        protected function getIndexablePostTypeArchiveIndexationActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexable_Term_Indexation_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexable_Term_Indexation_Action
         */
        protected function getIndexableTermIndexationActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexing_Complete_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexing_Complete_Action
         */
        protected function getIndexingCompleteActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Indexing_Prepare_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Indexing_Prepare_Action
         */
        protected function getIndexingPrepareActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Post_Link_Indexing_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Post_Link_Indexing_Action
         */
        protected function getPostLinkIndexingActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\Indexing\Term_Link_Indexing_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\Indexing\Term_Link_Indexing_Action
         */
        protected function getTermLinkIndexingActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\SEMrush\SEMrush_Login_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\SEMrush\SEMrush_Login_Action
         */
        protected function getSEMrushLoginActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\SEMrush\SEMrush_Options_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\SEMrush\SEMrush_Options_Action
         */
        protected function getSEMrushOptionsActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Actions\SEMrush\SEMrush_Phrases_Action' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Actions\SEMrush\SEMrush_Phrases_Action
         */
        protected function getSEMrushPhrasesActionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Author_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Author_Builder
         */
        protected function getIndexableAuthorBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Builder
         */
        protected function getIndexableBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Date_Archive_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Date_Archive_Builder
         */
        protected function getIndexableDateArchiveBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Hierarchy_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Hierarchy_Builder
         */
        protected function getIndexableHierarchyBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Home_Page_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Home_Page_Builder
         */
        protected function getIndexableHomePageBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Link_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Link_Builder
         */
        protected function getIndexableLinkBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Post_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Post_Builder
         */
        protected function getIndexablePostBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Post_Type_Archive_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Post_Type_Archive_Builder
         */
        protected function getIndexablePostTypeArchiveBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_System_Page_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_System_Page_Builder
         */
        protected function getIndexableSystemPageBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Indexable_Term_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Indexable_Term_Builder
         */
        protected function getIndexableTermBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Builders\Primary_Term_Builder' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Builders\Primary_Term_Builder
         */
        protected function getPrimaryTermBuilderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Commands\Index_Command' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Commands\Index_Command
         */
        protected function getIndexCommandService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Addon_Installation_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Addon_Installation_Conditional
         */
        protected function getAddonInstallationConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin\Doing_Post_Quick_Edit_Save_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin\Doing_Post_Quick_Edit_Save_Conditional
         */
        protected function getDoingPostQuickEditSaveConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin\Estimated_Reading_Time_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin\Estimated_Reading_Time_Conditional
         */
        protected function getEstimatedReadingTimeConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin\Licenses_Page_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin\Licenses_Page_Conditional
         */
        protected function getLicensesPageConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin\Post_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin\Post_Conditional
         */
        protected function getPostConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin\Posts_Overview_Or_Ajax_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin\Posts_Overview_Or_Ajax_Conditional
         */
        protected function getPostsOverviewOrAjaxConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Admin_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Admin_Conditional
         */
        protected function getAdminConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Development_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Development_Conditional
         */
        protected function getDevelopmentConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Front_End_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Front_End_Conditional
         */
        protected function getFrontEndConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Get_Request_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Get_Request_Conditional
         */
        protected function getGetRequestConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Headless_Rest_Endpoints_Enabled_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Headless_Rest_Endpoints_Enabled_Conditional
         */
        protected function getHeadlessRestEndpointsEnabledConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Jetpack_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Jetpack_Conditional
         */
        protected function getJetpackConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Migrations_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Migrations_Conditional
         */
        protected function getMigrationsConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\News_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\News_Conditional
         */
        protected function getNewsConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\No_Tool_Selected_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\No_Tool_Selected_Conditional
         */
        protected function getNoToolSelectedConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Open_Graph_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Open_Graph_Conditional
         */
        protected function getOpenGraphConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Premium_Inactive_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Premium_Inactive_Conditional
         */
        protected function getPremiumInactiveConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Primary_Category_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Primary_Category_Conditional
         */
        protected function getPrimaryCategoryConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\SEMrush_Enabled_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\SEMrush_Enabled_Conditional
         */
        protected function getSEMrushEnabledConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Schema_Blocks_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Schema_Blocks_Conditional
         */
        protected function getSchemaBlocksConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Should_Index_Links_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Should_Index_Links_Conditional
         */
        protected function getShouldIndexLinksConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\The_Events_Calendar_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\The_Events_Calendar_Conditional
         */
        protected function getTheEventsCalendarConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Third_Party\Elementor_Activated_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Third_Party\Elementor_Activated_Conditional
         */
        protected function getElementorActivatedConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Third_Party\Elementor_Edit_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Third_Party\Elementor_Edit_Conditional
         */
        protected function getElementorEditConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Third_Party\W3_Total_Cache_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Third_Party\W3_Total_Cache_Conditional
         */
        protected function getW3TotalCacheConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Third_Party\WPML_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Third_Party\WPML_Conditional
         */
        protected function getWPMLConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Third_Party\WPML_WPSEO_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Third_Party\WPML_WPSEO_Conditional
         */
        protected function getWPMLWPSEOConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\WP_Robots_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\WP_Robots_Conditional
         */
        protected function getWPRobotsConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Web_Stories_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Web_Stories_Conditional
         */
        protected function getWebStoriesConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\WooCommerce_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\WooCommerce_Conditional
         */
        protected function getWooCommerceConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\XMLRPC_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\XMLRPC_Conditional
         */
        protected function getXMLRPCConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Yoast_Admin_And_Dashboard_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Yoast_Admin_And_Dashboard_Conditional
         */
        protected function getYoastAdminAndDashboardConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Conditionals\Yoast_Tools_Page_Conditional' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Conditionals\Yoast_Tools_Page_Conditional
         */
        protected function getYoastToolsPageConditionalService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Badge_Group_Names' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Badge_Group_Names
         */
        protected function getBadgeGroupNamesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Indexing_Reasons' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Indexing_Reasons
         */
        protected function getIndexingReasonsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migration_Status' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migration_Status
         */
        protected function getMigrationStatusService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddCollationToTables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddCollationToTables
         */
        protected function getAddCollationToTablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddColumnsToIndexables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddColumnsToIndexables
         */
        protected function getAddColumnsToIndexablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddEstimatedReadingTime' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddEstimatedReadingTime
         */
        protected function getAddEstimatedReadingTimeService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddHasAncestorsColumn' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddHasAncestorsColumn
         */
        protected function getAddHasAncestorsColumnService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddIndexableObjectIdAndTypeIndex' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddIndexableObjectIdAndTypeIndex
         */
        protected function getAddIndexableObjectIdAndTypeIndexService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\AddIndexesForProminentWordsOnIndexables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\AddIndexesForProminentWordsOnIndexables
         */
        protected function getAddIndexesForProminentWordsOnIndexablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\BreadcrumbTitleAndHierarchyReset' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\BreadcrumbTitleAndHierarchyReset
         */
        protected function getBreadcrumbTitleAndHierarchyResetService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ClearIndexableTables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ClearIndexableTables
         */
        protected function getClearIndexableTablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\CreateIndexableSubpagesIndex' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\CreateIndexableSubpagesIndex
         */
        protected function getCreateIndexableSubpagesIndexService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\CreateSEOLinksTable' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\CreateSEOLinksTable
         */
        protected function getCreateSEOLinksTableService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\DeleteDuplicateIndexables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\DeleteDuplicateIndexables
         */
        protected function getDeleteDuplicateIndexablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ExpandIndexableColumnLengths' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ExpandIndexableColumnLengths
         */
        protected function getExpandIndexableColumnLengthsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ExpandIndexableIDColumnLengths' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ExpandIndexableIDColumnLengths
         */
        protected function getExpandIndexableIDColumnLengthsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ExpandPrimaryTermIDColumnLengths' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ExpandPrimaryTermIDColumnLengths
         */
        protected function getExpandPrimaryTermIDColumnLengthsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ReplacePermalinkHashIndex' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ReplacePermalinkHashIndex
         */
        protected function getReplacePermalinkHashIndexService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\ResetIndexableHierarchyTable' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\ResetIndexableHierarchyTable
         */
        protected function getResetIndexableHierarchyTableService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\TruncateIndexableTables' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\TruncateIndexableTables
         */
        protected function getTruncateIndexableTablesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\WpYoastDropIndexableMetaTableIfExists' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\WpYoastDropIndexableMetaTableIfExists
         */
        protected function getWpYoastDropIndexableMetaTableIfExistsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\WpYoastIndexable' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\WpYoastIndexable
         */
        protected function getWpYoastIndexableService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\WpYoastIndexableHierarchy' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\WpYoastIndexableHierarchy
         */
        protected function getWpYoastIndexableHierarchyService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Migrations\WpYoastPrimaryTerm' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Migrations\WpYoastPrimaryTerm
         */
        protected function getWpYoastPrimaryTermService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Researcher_Languages' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Researcher_Languages
         */
        protected function getResearcherLanguagesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\SEMrush_Client' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\SEMrush_Client
         */
        protected function getSEMrushClientService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Schema_IDs' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Schema_IDs
         */
        protected function getSchemaIDsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Config\Schema_Types' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Config\Schema_Types
         */
        protected function getSchemaTypesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Context\Meta_Tags_Context' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Context\Meta_Tags_Context
         */
        protected function getMetaTagsContextService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Breadcrumbs_Generator' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Breadcrumbs_Generator
         */
        protected function getBreadcrumbsGeneratorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Open_Graph_Image_Generator' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Open_Graph_Image_Generator
         */
        protected function getOpenGraphImageGeneratorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Open_Graph_Locale_Generator' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Open_Graph_Locale_Generator
         */
        protected function getOpenGraphLocaleGeneratorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Article' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Article
         */
        protected function getArticleService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Author' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Author
         */
        protected function getAuthorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Breadcrumb' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Breadcrumb
         */
        protected function getBreadcrumbService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\FAQ' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\FAQ
         */
        protected function getFAQService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\HowTo' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\HowTo
         */
        protected function getHowToService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Main_Image' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Main_Image
         */
        protected function getMainImageService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Organization' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Organization
         */
        protected function getOrganizationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Person' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Person
         */
        protected function getPersonService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Third_Party\Events_Calendar_Schema' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Third_Party\Events_Calendar_Schema
         */
        protected function getEventsCalendarSchemaService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\WebPage' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\WebPage
         */
        protected function getWebPageService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema\Website' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema\Website
         */
        protected function getWebsiteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Schema_Generator' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Schema_Generator
         */
        protected function getSchemaGeneratorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Generators\Twitter_Image_Generator' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Generators\Twitter_Image_Generator
         */
        protected function getTwitterImageGeneratorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Asset_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Asset_Helper
         */
        protected function getAssetHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Author_Archive_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Author_Archive_Helper
         */
        protected function getAuthorArchiveHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Blocks_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Blocks_Helper
         */
        protected function getBlocksHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Capability_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Capability_Helper
         */
        protected function getCapabilityHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Current_Page_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Current_Page_Helper
         */
        protected function getCurrentPageHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Date_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Date_Helper
         */
        protected function getDateHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Environment_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Environment_Helper
         */
        protected function getEnvironmentHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Home_Url_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Home_Url_Helper
         */
        protected function getHomeUrlHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Image_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Image_Helper
         */
        protected function getImageHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Indexable_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Indexable_Helper
         */
        protected function getIndexableHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Indexing_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Indexing_Helper
         */
        protected function getIndexingHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Input_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Input_Helper
         */
        protected function getInputHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Language_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Language_Helper
         */
        protected function getLanguageHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Meta_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Meta_Helper
         */
        protected function getMetaHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Notification_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Notification_Helper
         */
        protected function getNotificationHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper
         */
        protected function getImageHelper2Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Open_Graph\Values_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Open_Graph\Values_Helper
         */
        protected function getValuesHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Options_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Options_Helper
         */
        protected function getOptionsHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Pagination_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Pagination_Helper
         */
        protected function getPaginationHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Permalink_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Permalink_Helper
         */
        protected function getPermalinkHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Post_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Post_Helper
         */
        protected function getPostHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Post_Type_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Post_Type_Helper
         */
        protected function getPostTypeHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Primary_Term_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Primary_Term_Helper
         */
        protected function getPrimaryTermHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Product_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Product_Helper
         */
        protected function getProductHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Redirect_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Redirect_Helper
         */
        protected function getRedirectHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Request_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Request_Helper
         */
        protected function getRequestHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Require_File_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Require_File_Helper
         */
        protected function getRequireFileHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Robots_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Robots_Helper
         */
        protected function getRobotsHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\Article_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\Article_Helper
         */
        protected function getArticleHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\HTML_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\HTML_Helper
         */
        protected function getHTMLHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\ID_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\ID_Helper
         */
        protected function getIDHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\Image_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\Image_Helper
         */
        protected function getImageHelper3Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\Language_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\Language_Helper
         */
        protected function getLanguageHelper2Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Schema\Replace_Vars_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Schema\Replace_Vars_Helper
         */
        protected function getReplaceVarsHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Short_Link_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Short_Link_Helper
         */
        protected function getShortLinkHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Site_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Site_Helper
         */
        protected function getSiteHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\String_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\String_Helper
         */
        protected function getStringHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Taxonomy_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Taxonomy_Helper
         */
        protected function getTaxonomyHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Twitter\Image_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Twitter\Image_Helper
         */
        protected function getImageHelper4Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Url_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Url_Helper
         */
        protected function getUrlHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\User_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\User_Helper
         */
        protected function getUserHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Woocommerce_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Woocommerce_Helper
         */
        protected function getWoocommerceHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Helpers\Wordpress_Helper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Helpers\Wordpress_Helper
         */
        protected function getWordpressHelperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Initializers\Disable_Core_Sitemaps' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Initializers\Disable_Core_Sitemaps
         */
        protected function getDisableCoreSitemapsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Initializers\Migration_Runner' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Initializers\Migration_Runner
         */
        protected function getMigrationRunnerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Addon_Installation\Dialog_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Addon_Installation\Dialog_Integration
         */
        protected function getDialogIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Addon_Installation\Installation_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Addon_Installation\Installation_Integration
         */
        protected function getInstallationIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Admin_Columns_Cache_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Admin_Columns_Cache_Integration
         */
        protected function getAdminColumnsCacheIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Background_Indexing_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Background_Indexing_Integration
         */
        protected function getBackgroundIndexingIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Cron_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Cron_Integration
         */
        protected function getCronIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Disable_Concatenate_Scripts_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Disable_Concatenate_Scripts_Integration
         */
        protected function getDisableConcatenateScriptsIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Fix_News_Dependencies_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Fix_News_Dependencies_Integration
         */
        protected function getFixNewsDependenciesIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\HelpScout_Beacon' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\HelpScout_Beacon
         */
        protected function getHelpScoutBeaconService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Indexing_Notification_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Indexing_Notification_Integration
         */
        protected function getIndexingNotificationIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Indexing_Tool_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Indexing_Tool_Integration
         */
        protected function getIndexingToolIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Link_Count_Columns_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Link_Count_Columns_Integration
         */
        protected function getLinkCountColumnsIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Menu_Badge_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Menu_Badge_Integration
         */
        protected function getMenuBadgeIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Migration_Error_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Migration_Error_Integration
         */
        protected function getMigrationErrorIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Social_Templates_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Social_Templates_Integration
         */
        protected function getSocialTemplatesIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Admin\Workouts_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Admin\Workouts_Integration
         */
        protected function getWorkoutsIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Blocks\Breadcrumbs_Block' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Blocks\Breadcrumbs_Block
         */
        protected function getBreadcrumbsBlockService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Blocks\Internal_Linking_Category' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Blocks\Internal_Linking_Category
         */
        protected function getInternalLinkingCategoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Blocks\Structured_Data_Blocks' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Blocks\Structured_Data_Blocks
         */
        protected function getStructuredDataBlocksService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Breadcrumbs_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Breadcrumbs_Integration
         */
        protected function getBreadcrumbsIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Cleanup_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Cleanup_Integration
         */
        protected function getCleanupIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Duplicate_Post_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Duplicate_Post_Integration
         */
        protected function getDuplicatePostIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Estimated_Reading_Time' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Estimated_Reading_Time
         */
        protected function getEstimatedReadingTimeService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Exclude_Oembed_Cache_Post_Type' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Exclude_Oembed_Cache_Post_Type
         */
        protected function getExcludeOembedCachePostTypeService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Feature_Flag_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Feature_Flag_Integration
         */
        protected function getFeatureFlagIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Backwards_Compatibility' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Backwards_Compatibility
         */
        protected function getBackwardsCompatibilityService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Category_Term_Description' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Category_Term_Description
         */
        protected function getCategoryTermDescriptionService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Comment_Link_Fixer' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Comment_Link_Fixer
         */
        protected function getCommentLinkFixerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Force_Rewrite_Title' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Force_Rewrite_Title
         */
        protected function getForceRewriteTitleService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Handle_404' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Handle_404
         */
        protected function getHandle404Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Indexing_Controls' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Indexing_Controls
         */
        protected function getIndexingControlsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Open_Graph_OEmbed' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Open_Graph_OEmbed
         */
        protected function getOpenGraphOEmbedService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\RSS_Footer_Embed' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\RSS_Footer_Embed
         */
        protected function getRSSFooterEmbedService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Redirects' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Redirects
         */
        protected function getRedirectsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Schema_Accessibility_Feature' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Schema_Accessibility_Feature
         */
        protected function getSchemaAccessibilityFeatureService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\Theme_Titles' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\Theme_Titles
         */
        protected function getThemeTitlesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End\WP_Robots_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End\WP_Robots_Integration
         */
        protected function getWPRobotsIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Front_End_Integration' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Front_End_Integration
         */
        protected function getFrontEndIntegrationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Primary_Category' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Primary_Category
         */
        protected function getPrimaryCategoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Schema_Blocks' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Schema_Blocks
         */
        protected function getSchemaBlocksService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\AMP' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\AMP
         */
        protected function getAMPService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\BbPress' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\BbPress
         */
        protected function getBbPressService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Elementor' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Elementor
         */
        protected function getElementorService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Elementor_Exclude_Post_Types' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Elementor_Exclude_Post_Types
         *
         * @deprecated Yoast\WP\SEO\Integrations\Third_Party\Elementor_Exclude_Post_Types is deprecated since version 16.7! Use Yoast\WP\SEO\Integrations\Third_Party\Exclude_Elementor_Post_Types instead.
         */
        protected function getElementorExcludePostTypesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Exclude_Elementor_Post_Types' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Exclude_Elementor_Post_Types
         */
        protected function getExcludeElementorPostTypesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Exclude_WooCommerce_Post_Types' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Exclude_WooCommerce_Post_Types
         */
        protected function getExcludeWooCommercePostTypesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Jetpack' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Jetpack
         */
        protected function getJetpackService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\The_Events_Calendar' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\The_Events_Calendar
         */
        protected function getTheEventsCalendarService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\W3_Total_Cache' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\W3_Total_Cache
         */
        protected function getW3TotalCacheService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\WPML' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\WPML
         */
        protected function getWPMLService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\WPML_WPSEO_Notification' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\WPML_WPSEO_Notification
         */
        protected function getWPMLWPSEONotificationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Web_Stories' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Web_Stories
         */
        protected function getWebStoriesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\WooCommerce' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\WooCommerce
         */
        protected function getWooCommerceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Third_Party\Woocommerce_Permalinks' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Third_Party\Woocommerce_Permalinks
         */
        protected function getWoocommercePermalinksService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Addon_Update_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Addon_Update_Watcher
         */
        protected function getAddonUpdateWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Auto_Update_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Auto_Update_Watcher
         */
        protected function getAutoUpdateWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Ancestor_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Ancestor_Watcher
         */
        protected function getIndexableAncestorWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Author_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Author_Watcher
         */
        protected function getIndexableAuthorWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Category_Permalink_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Category_Permalink_Watcher
         */
        protected function getIndexableCategoryPermalinkWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Date_Archive_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Date_Archive_Watcher
         */
        protected function getIndexableDateArchiveWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_HomeUrl_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_HomeUrl_Watcher
         */
        protected function getIndexableHomeUrlWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Home_Page_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Home_Page_Watcher
         */
        protected function getIndexableHomePageWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Permalink_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Permalink_Watcher
         */
        protected function getIndexablePermalinkWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Meta_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Meta_Watcher
         */
        protected function getIndexablePostMetaWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Type_Archive_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Type_Archive_Watcher
         */
        protected function getIndexablePostTypeArchiveWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Post_Watcher
         */
        protected function getIndexablePostWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Static_Home_Page_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Static_Home_Page_Watcher
         */
        protected function getIndexableStaticHomePageWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_System_Page_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_System_Page_Watcher
         */
        protected function getIndexableSystemPageWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Indexable_Term_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Indexable_Term_Watcher
         */
        protected function getIndexableTermWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Option_Titles_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Option_Titles_Watcher
         */
        protected function getOptionTitlesWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Option_Wpseo_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Option_Wpseo_Watcher
         */
        protected function getOptionWpseoWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Primary_Category_Quick_Edit_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Primary_Category_Quick_Edit_Watcher
         */
        protected function getPrimaryCategoryQuickEditWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\Watchers\Primary_Term_Watcher' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\Watchers\Primary_Term_Watcher
         */
        protected function getPrimaryTermWatcherService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Integrations\XMLRPC' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Integrations\XMLRPC
         */
        protected function getXMLRPCService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Loader' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Loader
         */
        protected function getLoaderService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Loggers\Logger' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Loggers\Logger
         */
        protected function getLoggerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Memoizers\Meta_Tags_Context_Memoizer' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Memoizers\Meta_Tags_Context_Memoizer
         */
        protected function getMetaTagsContextMemoizerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Memoizers\Presentation_Memoizer' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Memoizers\Presentation_Memoizer
         */
        protected function getPresentationMemoizerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Abstract_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Abstract_Presentation
         */
        protected function getAbstractPresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Author_Archive_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Author_Archive_Presentation
         */
        protected function getIndexableAuthorArchivePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Date_Archive_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Date_Archive_Presentation
         */
        protected function getIndexableDateArchivePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Error_Page_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Error_Page_Presentation
         */
        protected function getIndexableErrorPagePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Home_Page_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Home_Page_Presentation
         */
        protected function getIndexableHomePagePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Post_Type_Archive_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Post_Type_Archive_Presentation
         */
        protected function getIndexablePostTypeArchivePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Post_Type_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Post_Type_Presentation
         */
        protected function getIndexablePostTypePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Presentation
         */
        protected function getIndexablePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Search_Result_Page_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Search_Result_Page_Presentation
         */
        protected function getIndexableSearchResultPagePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Static_Home_Page_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Static_Home_Page_Presentation
         */
        protected function getIndexableStaticHomePagePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Static_Posts_Page_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Static_Posts_Page_Presentation
         */
        protected function getIndexableStaticPostsPagePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Presentations\Indexable_Term_Archive_Presentation' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Presentations\Indexable_Term_Archive_Presentation
         */
        protected function getIndexableTermArchivePresentationService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Repositories\Indexable_Hierarchy_Repository' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Repositories\Indexable_Hierarchy_Repository
         */
        protected function getIndexableHierarchyRepositoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Repositories\Indexable_Repository' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Repositories\Indexable_Repository
         */
        protected function getIndexableRepositoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Repositories\Primary_Term_Repository' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Repositories\Primary_Term_Repository
         */
        protected function getPrimaryTermRepositoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Repositories\SEO_Links_Repository' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Repositories\SEO_Links_Repository
         */
        protected function getSEOLinksRepositoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Repositories\SEO_Meta_Repository' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Repositories\SEO_Meta_Repository
         */
        protected function getSEOMetaRepositoryService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\Alert_Dismissal_Route' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\Alert_Dismissal_Route
         */
        protected function getAlertDismissalRouteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\Indexables_Head_Route' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\Indexables_Head_Route
         */
        protected function getIndexablesHeadRouteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\Indexing_Route' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\Indexing_Route
         */
        protected function getIndexingRouteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\SEMrush_Route' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\SEMrush_Route
         */
        protected function getSEMrushRouteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\Supported_Features_Route' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\Supported_Features_Route
         */
        protected function getSupportedFeaturesRouteService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Routes\Yoast_Head_REST_Field' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Routes\Yoast_Head_REST_Field
         */
        protected function getYoastHeadRESTFieldService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Schema_Templates\Assets\Icons' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Schema_Templates\Assets\Icons
         */
        protected function getIconsService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Classes_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Classes_Surface
         */
        protected function getClassesSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Helpers_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Helpers_Surface
         */
        protected function getHelpersSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Meta_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Meta_Surface
         */
        protected function getMetaSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Open_Graph_Helpers_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Open_Graph_Helpers_Surface
         */
        protected function getOpenGraphHelpersSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Schema_Helpers_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Schema_Helpers_Surface
         */
        protected function getSchemaHelpersSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Surfaces\Twitter_Helpers_Surface' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Surfaces\Twitter_Helpers_Surface
         */
        protected function getTwitterHelpersSurfaceService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Values\Images' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Values\Images
         */
        protected function getImagesService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Values\Open_Graph\Images' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Values\Open_Graph\Images
         */
        protected function getImages2Service()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Wrappers\WP_Query_Wrapper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Wrappers\WP_Query_Wrapper
         */
        protected function getWPQueryWrapperService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Wrappers\WP_Remote_Handler' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Wrappers\WP_Remote_Handler
         */
        protected function getWPRemoteHandlerService()
        {
        }
        /**
         * Gets the public 'Yoast\WP\SEO\Wrappers\WP_Rewrite_Wrapper' shared autowired service.
         *
         * @return \Yoast\WP\SEO\Wrappers\WP_Rewrite_Wrapper
         */
        protected function getWPRewriteWrapperService()
        {
        }
        /**
         * Gets the public 'Yoast_Notification_Center' shared service.
         *
         * @return \Yoast_Notification_Center
         */
        protected function getYoastNotificationCenterService()
        {
        }
        /**
         * Gets the private 'wpdb' shared service.
         *
         * @return \wpdb
         */
        protected function getWpdbService()
        {
        }
    }
}
namespace Yoast\WP\SEO\Generators {
    interface Generator_Interface
    {
        /**
         * Returns a string, or other Thing that the associated presenter can handle.
         *
         * @param Meta_Tags_Context $context The meta tags context.
         *
         * @return mixed
         */
        public function generate(\Yoast\WP\SEO\Context\Meta_Tags_Context $context);
    }
    /**
     * Represents the generator class for the breadcrumbs.
     */
    class Breadcrumbs_Generator implements \Yoast\WP\SEO\Generators\Generator_Interface
    {
        /**
         * The indexable repository.
         *
         * @var Indexable_Repository
         */
        private $repository;
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * The current page helper.
         *
         * @var Current_Page_Helper
         */
        private $current_page_helper;
        /**
         * The post type helper.
         *
         * @var Post_Type_Helper
         */
        private $post_type_helper;
        /**
         * The URL helper.
         *
         * @var Url_Helper
         */
        private $url_helper;
        /**
         * The pagination helper.
         *
         * @var Pagination_Helper
         */
        private $pagination_helper;
        /**
         * Breadcrumbs_Generator constructor.
         *
         * @param Indexable_Repository $repository          The repository.
         * @param Options_Helper       $options             The options helper.
         * @param Current_Page_Helper  $current_page_helper The current page helper.
         * @param Post_Type_Helper     $post_type_helper    The post type helper.
         * @param Url_Helper           $url_helper          The URL helper.
         * @param Pagination_Helper    $pagination_helper   The pagination helper.
         */
        public function __construct(\Yoast\WP\SEO\Repositories\Indexable_Repository $repository, \Yoast\WP\SEO\Helpers\Options_Helper $options, \Yoast\WP\SEO\Helpers\Current_Page_Helper $current_page_helper, \Yoast\WP\SEO\Helpers\Post_Type_Helper $post_type_helper, \Yoast\WP\SEO\Helpers\Url_Helper $url_helper, \Yoast\WP\SEO\Helpers\Pagination_Helper $pagination_helper)
        {
        }
        /**
         * Generates the breadcrumbs.
         *
         * @param Meta_Tags_Context $context The meta tags context.
         *
         * @return array An array of associative arrays that each have a 'text' and a 'url'.
         */
        public function generate(\Yoast\WP\SEO\Context\Meta_Tags_Context $context)
        {
        }
        /**
         * Returns the modified post crumb.
         *
         * @param array     $crumb    The crumb.
         * @param Indexable $ancestor The indexable.
         *
         * @return array The crumb.
         */
        private function get_post_crumb($crumb, $ancestor)
        {
        }
        /**
         * Returns the modified post type crumb.
         *
         * @param array     $crumb    The crumb.
         * @param Indexable $ancestor The indexable.
         *
         * @return array The crumb.
         */
        private function get_post_type_archive_crumb($crumb, $ancestor)
        {
        }
        /**
         * Returns the modified term crumb.
         *
         * @param array     $crumb    The crumb.
         * @param Indexable $ancestor The indexable.
         *
         * @return array The crumb.
         */
        private function get_term_crumb($crumb, $ancestor)
        {
        }
        /**
         * Returns the modified system page crumb.
         *
         * @param array     $crumb    The crumb.
         * @param Indexable $ancestor The indexable.
         *
         * @return array The crumb.
         */
        private function get_system_page_crumb($crumb, $ancestor)
        {
        }
        /**
         * Returns the modified user crumb.
         *
         * @param array     $crumb    The crumb.
         * @param Indexable $ancestor The indexable.
         *
         * @return array The crumb.
         */
        private function get_user_crumb($crumb, $ancestor)
        {
        }
        /**
         * Returns the modified date archive crumb.
         *
         * @param array $crumb The crumb.
         *
         * @return array The crumb.
         */
        protected function get_date_archive_crumb($crumb)
        {
        }
        /**
         * Returns whether or not a blog crumb should be added.
         *
         * @param int               $page_for_posts The page for posts ID.
         * @param Meta_Tags_Context $context        The meta tags context.
         *
         * @return bool Whether or not a blog crumb should be added.
         */
        protected function should_have_blog_crumb($page_for_posts, $context)
        {
        }
        /**
         * Returns the post type parent of a given taxonomy.
         *
         * @param string $taxonomy The taxonomy.
         *
         * @return string|false The parent if it exists, false otherwise.
         */
        protected function get_taxonomy_post_type_parent($taxonomy)
        {
        }
        /**
         * Adds a crumb for the current page, if we're on an archive page or paginated post.
         *
         * @param array     $crumbs            The array of breadcrumbs.
         * @param Indexable $current_indexable The current indexable.
         *
         * @return array The breadcrumbs.
         */
        protected function add_paged_crumb(array $crumbs, $current_indexable)
        {
        }
    }
    /**
     * Represents the generator class for the Open Graph images.
     */
    class Open_Graph_Image_Generator implements \Yoast\WP\SEO\Generators\Generator_Interface
    {
        /**
         * The Open Graph image helper.
         *
         * @var Open_Graph_Image_Helper
         */
        protected $open_graph_image;
        /**
         * The image helper.
         *
         * @var Image_Helper
         */
        protected $image;
        /**
         * The URL helper.
         *
         * @var Url_Helper
         */
        protected $url;
        /**
         * The options helper.
         *
         * @var Options_Helper
         */
        private $options;
        /**
         * Images constructor.
         *
         * @codeCoverageIgnore
         *
         * @param Open_Graph_Image_Helper $open_graph_image Image helper for Open Graph.
         * @param Image_Helper            $image            The image helper.
         * @param Options_Helper          $options          The options helper.
         * @param Url_Helper              $url              The url helper.
         */
        public function __construct(\Yoast\WP\SEO\Helpers\Open_Graph\Image_Helper $open_graph_image, \Yoast\WP\SEO\Helpers\Image_Helper $image, \Yoast\WP\SEO\Helpers\Options_Helper $options, \Yoast\WP\SEO\Helpers\Url_Helper $url)
        {
        }
        /**
         * Retrieves the images for an indexable.
         *
         * For legacy reasons some plugins might expect we filter a WPSEO_Opengraph_Image object. That might cause
         * type errors. This is why we try/catch our filters.
         *
         * @param Meta_Tags_Context $context The context.
         *
         * @return array The images.
         */
        public function generate(\Yoast\WP\SEO\Context\Meta_Tags_Context $context)
        {
        }
        /**
         * Retrieves the images for an author archive indexable.
         *
         * This is a custom method to address the case of Author Archives, since they always have an Open Graph image
         * set in the indexable (even if it is an empty default Gravatar).
         *
         * @param Meta_Tags_Context $context The context.
         *
         * @return array The images.
         */
        public function generate_for_author_archive(\Yoast\WP\SEO\Context\Meta_Tags_Context $context)
        {
        }
        /**
         * Adds an image based on the given indexable.
         *
         * @param Indexable $indexable       The indexable.
         * @param Images    $image_container The image container.
         */
        protected function add_from_indexable(\Yoast\WP\SEO\Models\Indexable $indexable, \Yoast\WP\SEO\Values\Open_Graph\Images $image_container)
        {
        }
        /**
         * Retrieves the default Open Graph image.
         *
         * @param Images $image_container The image container.
         */
        protected function add_from_default(\Yoast\WP\SEO\Values\Open_Graph\Images $image_container)
        {
        }
        /**
         * Retrieves the default Open Graph image.
         *
         * @param Meta_Tags_Context $context         The context.
         * @param Images            $image_container The image container.
         */
        protected function add_from_templates(\Yoast\WP\SEO\Context\Meta_Tags_Context $context, \Yoast\WP\SEO\Values\Open_Graph\Images $image_container)
        {
        }
        /**
         * Retrieves an instance of the image container.
         *
         * @codeCoverageIgnore
         *
         * @return Images The image container.
         */
        protected function get_image_container()
        {
        }
    }
    /**
     * Class Open_Graph_Locale_Generator.
     */
    class Open_Graph_Locale_Generator implements \Yoast\WP\SEO\Generators\Generator_Interface
    {
        /**
         * Generates the OG Locale.
         *
         * @param Meta_Tags_Context $context The context.
         *
         * @return string The OG locale.
         */
        public function generate(\Yoast\WP\SEO\Context\Meta_Tags_Context $context)
        {
        }
    }
    /**
     * Class Schema_Generator.
     */
    class Schema_Generator implements \Yoast\WP\SEO\Generators\Generator_Interface
    {
        /**
         * The helpers surface.
         *
         * @var Helpers_Surface
         */
        protected $helpers;
        /**
         * The Schema replace vars helper.
         *
         * @var Replace_Vars_Helper
         */
        protected $schema_replace_vars_helper;
        /**
         * Generator constructor.
         *
         * @param Helpers_Surface     $helpers                    The helpers surface.
         * @param Replace_Vars_Helper $schema_replace_vars_helper The replace vars helper.
         */
        public function __construct(\Yoast\WP\SEO\Surfaces\Helpers_Surface $helpers, \Yoast\WP\SEO\Helpers\Schema\Replace_Vars_Helper $schema_replace_vars_helper)
        {
        }
        /**
         * Returns a Schema graph array.
         *
         * @param Meta_Tags_Context $context The meta tags context.
         *
         * @return array The graph.
         */
        public function generate(\Yoast\WP\SEO\Context\Meta_Tags_Context $context)
        {
        }
        /**
         * Filters out any graph pieces that should not be generated.
         * (Using the `wpseo_schema_needs_<graph_piece_identifier>` series of filters).
         *
         * @param array $graph_pieces The current list of graph pieces that we want to generate.
         *
         * @return array The graph pieces to generate.
         */
        protected function filter_graph_pieces_to_generate($graph_pieces)
        {
        }
        /**
         * Generates the schema graph.
         *
         * @param array             $graph_piece_generators The schema graph pieces to generate.
         * @param Meta_Tags_Context $context                The meta tags context to use.
         *
         * @return array The generated schema graph.
         */
        protected function generate_graph($graph_piece_generators, $context)
        {
        }
        /**
         * Adds schema graph pieces from Gutenberg blocks on the current page to
         * the given schema graph.
         *
         * Think of blocks like the Yoast FAQ block or the How To block.
         *
         * @param array             $graph   The current schema graph.
         * @param Meta_Tags_Context $context The meta tags context.
         *
         * @return array The graph with the schema blocks graph pieces added.
         */
        protected function add_schema_blocks_graph_pieces($graph, $context)
        {
        }
        /**
         * Adapts the WebPage graph piece for password-protected posts.
         *
         * It should only have certain whitelisted properties.
         * The type should always be WebPage.
         *
         * @param array $graph_piece The WebPage graph piece that should be adapted for password-protected posts.
         *
         * @return array The WebPage graph piece that has been adapted for password-protected posts.
         */
        public function protected_webpage_schema($graph_piece)
        {
        }
        /**
         * Gets all the graph pieces we need.
         *
         * @param Meta_Tags_Context $context The meta tags context.
         *
         * @return Abstract_Schema_Piece[] A filtered array of graph pieces.
         */
        protected function get_graph_pieces($context)
        {
        }
        /**
         * Allows filtering the graph piece by its schema type.
         *
         * Note: We removed the Abstract_Schema_Piece type-hint from the $graph_piece_generator argument, because
         *       it caused conflicts with old code, Yoast SEO Video specifically.
         *
         * @param array                   $graph_piece The graph piece we're filtering.
         * @param string                  $identifier  The identifier of the graph piece that is being filtered.
         * @param Meta_Tags_Context       $context     The meta tags context.
         * @param Abstract_Schema_Piece   $graph_piece_generator A value object with context variables.
         * @param Abstract_Schema_Piece[] $graph_piece_generators A value object with context variables.
         *
         * @return array The filtered graph piece.
         */
        private function type_filter($graph_piece, $identifier, \Yoast\WP\SEO\Context\Meta_Tags_Context $context, $graph_piece_generator, array $graph_piece_generators)
        {
        }
        /**
         * Retrieves the type from a graph piece.
         *
         * @param array $piece The graph piece.
         *
         * @return array An array of the piece's types.
         */
        private function get_type_from_piece($piece)
        {
        }
        /**
         * Validates a graph piece's type.
         *
         * When the type is an array:
         *   - Ensure the values are unique.
         *   - Only 1 value? Use that value without the array wrapping.
         *
         * @param array $piece The graph piece.
         *
         * @return array The graph piece.
         */
        private function validate_type($piece)
        {
        }
    }
}
namespace Yoast\WP\SEO\Generators\Schema {
    /**
     * Class Abstract_Schema_Piece.
     */
    abstract class Abstract_Schema_Piece
    {
        /**
         * The meta tags context.
         *
         * @var Meta_Tags_Context
         */
        public $context;
        /**
         * The helpers surface
         *
         * @var Helpers_Surface
         */
        public $helpers;
        /**
         * Generates the schema piece.
         *
         * @return mixed
         */
        public abstract function generate();
        /**
         * Determines whether the schema piece is needed.
         *
         * @return bool
         */
        public abstract function is_needed();
    }
    /**
     * Returns schema Article data.
     */
    class Article extends \Yoast\WP\SEO\Generators\Schema\Abstract_Schema_Piece
    {
        /**
         * Determines whether or not a piece should be added to the graph.
         *
         * @return bool
         */
        public function is_needed()
        {
        }
        /**
         * Returns Article data.
         *
         * @return array Article data.
         */
        public function generate()
        {
        }
        /**
         * Adds tags as keywords, if tags are assigned.
         *
         * @param array $data Article data.
         *
         * @return array Article data.
         */
        private function add_keywords($data)
        {
        }
        /**
         * Adds categories as sections, if categories are assigned.
         *
         * @param array $data Article data.
         *
         * @return array Article data.
         */
        private function add_sections($data)
        {
        }
        /**
         * Adds a term or multiple terms, comma separated, to a field.
         *
         * @param array  $data     Article data.
         * @param string $key      The key in data to save the terms in.
         * @param string $taxonomy The taxonomy to retrieve the terms from.
         *
         * @return mixed Article data.
         */
        protected function add_terms($data, $key, $taxonomy)
        {
        }
        /**
         * Adds an image node if the post has a featured image.
         *
         * @param array $data The Article data.
         *
         * @return array The Article data.
         */
        private function add_image($data)
        {
        }
        /**
         * Adds the potential action property to the Article Schema piece.
         *
         * @param array $data The Article data.
         *
         * @return array The Article data with the potential action added.
         */
        private function add_potential_action($data)
        {
        }
        /**
         * Does a simple word count but tries to be relatively smart about it.
         *
         * @param string $post_content The post content.
         * @param string $post_title   The post title.
         *
         * @return int The number of words in the content.
         */
        private function word_count($post_content, $post_title = '')
        {
        }
    }
    /**
     * Returns schema Person data.
     */
    class Person extends \Yoast\WP\SEO\Generators\Schema\Abstract_Schema_Piece
    {
        /**
         * Array of the social profiles we display for a Person.
         *
         * @var string[]
         */
        private $social_profiles = ['facebook', 'instagram', 'linkedin', 'pinterest', 'twitter', 'myspace', 'youtube', 'soundcloud', 'tumblr', 'wikipedia'];
        /**
         * The Schema type we use for this class.
         *
         * @var string[]
         */
        protected $type = ['