<?php
/**
 * Plugin Name: Itinerator
 * Plugin URI: https://itinerator.ca
 * Description: Show your itineraries in WordPress!
 * Author: The Number Creative
 * Author URI: https://thenumber.ca
 * Version: 1.9.22
 * License: GPL2+
 * License URI: https://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package CGB
 */

if (! defined('ABSPATH')) {
	exit;
}

// Load Composer autoloader
require_once plugin_dir_path(__FILE__) . 'lib/autoload.php';

// Load environment variables from .env file if it exists
if (file_exists(__DIR__ . '/.env')) {
	$dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
	$dotenv->safeLoad();
}


// Load environment variables from .env file if it exists
// if (file_exists(__DIR__ . '/.env')) {
//     $env_vars = file_get_contents(__DIR__ . '/.env');
//     if ($env_vars !== false) {
//         $env_vars = explode("\n", $env_vars);
//         foreach ($env_vars as $env_var) {
//             if (strpos($env_var, '=') !== false) {
//                 list($key, $value) = explode('=', $env_var, 2);
//                 putenv("$key=$value");
//                 $_ENV[$key] = trim($value);
//             }
//         }
//     } else {
//         // Handle error: file not found or unable to read
//         echo "Error: Unable to read .env file.";
//     }
// }


// CONSTANTS
define('ITINERATOR_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('ITINERATOR_PLUGIN_URL', plugin_dir_url(__FILE__));
define('API_URL', $_ENV['ITINERATOR_API_URL'] ?? 'https://admin.itinerator.ca/api/wp/v1/');
define('API_TOKEN', get_option('itinerator_api_key_field'));
define('DMO_PARTNER_API_KEY', get_option('itinerator_dmo_partner_key_field'));
define('ITIN_GOOGLE_MAPS_API_KEY', get_option('itinerator_google_api_key_field'));
define('ITIN_GOOGLE_MAPS_MAP_ID', get_option('itinerator_google_map_id_field'));
define('ITIN_BOOTSTRAP', get_option('itinerator_bootstrap_field'));
define('ITIN_IS_PLATFORM_API_KEY_VALID', get_option('itinerator_is_platform_api_key_valid'));
define('ITIN_IS_DMO_API_KEY_VALID', get_option('itinerator_is_dmo_api_key_valid'));

// Load the plugin's autoload file
require_once plugin_dir_path(__FILE__) . 'src/config/init.php';
