<?php

namespace Itinerator\Templates;

use JsonMapper;
use Parsedown;
use Itinerator\Vendors\TemplateLoader;


class BlockTemplate

{
  // Define the variables used in the class
  public $record, $itinPageType, $attributes, $linkedPageId, $slug, $jm, $customTemplateName,  $query_key, $tagCategory,  $tagFilters, $filterRecordsByRegion, $specificItinerary, $linkedRegionPageId, $itineraryRegionId, $className, $align, $showImage, $showName, $showDescription;
  protected $block_attributes, $block_type, $template_slug;


  // Method to get queried data
  protected function get_data()
  {
    $this->record = get_query_var('querydata');
  }

  // Method to get template name
  protected function get_template_name()
  {
    return $this->itinPageType;
  }

  // Method to parse markdown text
  public function parse_markdown($text)
  {
    // Return empty string if text is null
    if ($text === null) {
      return '';
    }

    $Parsedown = new Parsedown();
    // Enable line breaks in the markdown text
    $Parsedown->setBreaksEnabled(true);
    return $Parsedown->text($text);
  }

  public function query_listing_data($listing_id)
  {
    $listing = query_itin_api('listings/' . $listing_id);
    return $listing;
  }

  // Render callback function
  public function render_callback($attr)
  {
    // Enqueue the Google Maps API script if it hasn't been enqueued or embedded yet

    if ($this->block_type === 'map' || $this->block_type === 'itinerary') {
      wp_enqueue_script('google_maps_api');
    }

    // Enqueue the Itinerator JavaScript file in the block rather than the shared assets
    wp_enqueue_script('itinerator-js');

    // Check if frontend
    if (is_frontend()) {
      $this->set($attr);
      $this->attributes = $attr;

      // If linked page ID is set, get post name
      if (isset($this->linkedPageId)) {
        $this->slug = get_post($this->linkedPageId)->post_name;
      }

      // Get the page type and JSON mapper
      $this->itinPageType = get_query_var('itinPageType');
      $this->jm = new JsonMapper();
      // Set JSON Mapper properties
      $this->jm->postMappingMethod = "postMapping";
      $this->jm->bStrictNullTypes = false;
      $this->get_data();

      // Initialize and populate shortcode_atts
      $shortcode_atts = [];
      foreach ($attr as $key => $value) {
        $snake_case_key = $this->convert_to_snake_case($key);
        $shortcode_atts[$snake_case_key] = $this->format_attribute_value($value);
      }

      // Build the shortcode string
      // $shortcode_string = '[tourismo-' . $this->block_type . ' ';
      // foreach ($shortcode_atts as $key => $value) {
      //   if (is_array($value)) {
      //     $value = implode(',', $value);
      //   }
      //   $shortcode_string .= $key . '="' . esc_attr($value) . '" ';
      // }
      // $shortcode_string .= ']';

      // Echo the formatted shortcode for debugging
      // echo $shortcode_string;

      // Render template
      return $this->render_template();
    }
  }


  // Method to get block attributes json based on type
  public function get_block_json($type)
  {
    if (empty($this->block_attributes)) return [];
    $file_path = ITINERATOR_PLUGIN_DIR . "/src/" . $type . '/' . $this->block_attributes . '.json';
    if (!file_exists($file_path)) return [];
    // Get the file content and return decoded JSON
    $json = file_get_contents($file_path);
    return is_array(json_decode($json, true)) ? json_decode($json, true) : [];
  }

  public function __construct()
  {

    $blocks = json_decode(file_get_contents(__DIR__ . '/../attributes/block-registration.json'), true);

    if (ITIN_IS_PLATFORM_API_KEY_VALID) {
      foreach ($blocks['blockTypes']['platformBlocks'] as $block) {
        if ($this->block_type == $block) {

          // register block
          register_block_type(
            'itinerator/' . $this->block_type,
            array(
              'style' => 'itinerator-cgb-style-css',
              'editor_script' => 'itinerator-cgb-block-js',
              'editor_style' => 'itinerator-cgb-block-editor-css',
              'template' => [
                array('core/heading', array('level' => 5, 'content' => 'Role')),
              ],
              'attributes' => $this->get_block_json('attributes'),
              'render_callback' => array($this, 'render_callback'),
              'supports' => $this->get_block_json('supports')
            )
          );

          // Register the shortcode for the block type
          add_shortcode('tourismo-' . $this->block_type, array($this, 'render_shortcode'));
        }
      }
      // rest of constructor
    }
    if (ITIN_IS_DMO_API_KEY_VALID) {
      foreach ($blocks['blockTypes']['dmoBlocks'] as $block) {
        if ($this->block_type == $block) {
          // register block
          register_block_type(
            'itinerator/' . $this->block_type,
            array(
              'style' => 'itinerator-cgb-style-css',
              'editor_script' => 'itinerator-cgb-block-js',
              'editor_style' => 'itinerator-cgb-block-editor-css',
              'template' => [
                array('core/heading', array('level' => 5, 'content' => 'Role')),
              ],
              'attributes' => $this->get_block_json('attributes'),
              'render_callback' => array($this, 'render_callback'),
              'supports' => $this->get_block_json('supports')
            ),
          );

          // Register the shortcode for the block type
          add_shortcode('tourismo-' . $this->block_type, array($this, 'render_shortcode'));
        }
      }
    }
  }

  public function render_shortcode($atts)
  {

    // Check if frontend
    if (is_frontend()) {

      if (($this->block_type === 'map' || $this->block_type === 'itinerary')) {
        wp_enqueue_script('google_maps_api');
      }

      // Enqueue the Itinerator JavaScript file in the shortcode rather than the shared assets
      wp_enqueue_script('itinerator-js');

      // Set default shortcode attributes
      $default_atts = $this->get_default_attributes($atts);

      // Merge the provided shortcode attributes with the defaults
      $atts = shortcode_atts($default_atts, $atts);

      // Set the shortcode attributes
      $this->set_shortcode_attributes($atts);

      // If linked page ID is set, get post name
      if (isset($this->linkedPageId)) {
        $this->slug = get_post($this->linkedPageId)->post_name;
      }

      // Get the page type and JSON mapper
      $this->itinPageType = get_query_var('itinPageType');
      $this->jm = new JsonMapper();
      // Set JSON Mapper properties
      $this->jm->postMappingMethod = "postMapping";
      $this->jm->bStrictNullTypes = false;
      $this->get_data();

      // Convert the attributes to snake case and format the shortcode
      $shortcode_atts = [];
      foreach ($atts as $key => $value) {
        $snake_case_key = $this->convert_to_snake_case($key);
        $shortcode_atts[$snake_case_key] = $this->format_attribute_value($value);
      }

      // Build the shortcode string
      $shortcode_string = '[tourismo-' . $this->block_type . ' ';
      foreach ($shortcode_atts as $key => $value) {
        if (is_array($value)) {
          $value = implode(',', $value);
        }
        $shortcode_string .= $key . '="' . esc_attr($value) . '" ';
      }
      $shortcode_string .= ']';

      // Echo the formatted shortcode for debugging
      // echo $shortcode_string;

      // Render template
      return $this->render_template();
    }
  }

  /**
   * Convert a camelCase string to snake_case.
   *
   * @param string $key
   * @return string
   */
  protected function convert_to_snake_case($key)
  {
    return strtolower(preg_replace('/(?<!^)(?=[A-Z])/', '_', $key));
  }

  /**
   * Format the attribute value based on its type.
   *
   * @param mixed $value
   * @return string|array
   */
  protected function format_attribute_value($value)
  {
    if (is_bool($value)) {
      return $value ? 'true' : 'false';
    } elseif (is_array($value)) {
      return $value;
    } else {
      return (string) $value;
    }
  }

  /**
   * Get the default attributes for the current block type.
   *
   * @param array $atts The provided shortcode attributes.
   * @return array
   */
  protected function get_default_attributes($atts = [])
  {
    $json_file = __DIR__ . '/../attributes/' . $this->block_type . '.json';
    if (file_exists($json_file)) {
      $attributes = json_decode(file_get_contents($json_file), true);
      $default_atts = [];
      foreach ($attributes as $key => $attribute) {
        $default_atts[$key] = $attribute['default'];
      }

      // Convert the shortcode attributes to camelCase
      $atts = array_combine(
        array_map([$this, 'convert_to_camel_case'], array_keys($atts)),
        array_values($atts)
      );

      // Merge the default attributes with the provided shortcode attributes
      $atts = wp_parse_args($atts, $default_atts);

      // Convert the attributes based on the type information
      foreach ($atts as $key => $value) {
        if (isset($attributes[$key]['type'])) {
          switch ($attributes[$key]['type']) {
            case 'boolean':
              $atts[$key] = filter_var($value, FILTER_VALIDATE_BOOLEAN);
              break;
            case 'integer':
              $atts[$key] = filter_var($value, FILTER_VALIDATE_INT);
              break;
            case 'float':
              $atts[$key] = filter_var($value, FILTER_VALIDATE_FLOAT);
              break;
            case 'array':
              $atts[$key] = is_array($value) ? $value : explode(',', $value);
              break;
            default:
              // Leave the value as is for other types
              break;
          }
        }
      }

      return $atts;
    }
    return $atts;
  }




  /**
   * Set the shortcode attributes.
   *
   * @param array $atts The shortcode attributes.
   */
  protected function set_shortcode_attributes($atts)
  {
    // $this->linkedPageId = $atts['linked_page_id'];
    // Set any other shortcode attributes here
    // These attributes can then be used to set the block or page attributes
    $this->set($atts);
    $this->attributes = $atts;
  }

  protected function convert_to_camel_case($key)
  {
    return lcfirst(str_replace(' ', '', ucwords(str_replace('_', ' ', $key))));
  }


  // check the option here, then depending on which block it is you register it or not. can get the name/class or blocktype and decide

  // Method to set data by key and value pairs
  public function set($data)
  {
    foreach ($data as $key => $value) {
      $this->{$key} = $value;
    }
  }

  // Method to render a template
  public function render_template()
  {
    $template_name = !empty($this->customTemplateName) ? $this->customTemplateName : $this->get_template_name();
    ob_start();
    include((new TemplateLoader())($this->template_slug, $template_name));
    return ob_get_clean();
  }

  // Method to build query string for record list
  public function record_list_query()
  {
    if (!isset($this->query_key)) return '';
    $queryData = get_query_var('querydata');

    // Filter by region on a region page or region_id if available
    $filter_id = null;
    if (is_a($queryData, "Itinerator\Templates\Region") && $this->filterRecordsByRegion) {
      $filter_id = $queryData->id;
    } elseif (isset($queryData->region_id) && $this->filterRecordsByRegion) {
      $filter_id = $queryData->region_id;
    }

    // Filter by Tag Filters
    $tagIds = null;
    if (!empty($this->tagFilters)) {
      // xdebug_var_dump($this->tagFilters);
      if (is_array($this->tagFilters[0])) {
        // If $this->tagFilters is an array of arrays (e.g., from shortcode)
        $tagIds = implode(",", array_map(function ($tag) {
          return $tag['id'];
        }, $this->tagFilters));
      } else {
        // If $this->tagFilters is an array of objects (e.g., from render_callback)
        $tagIds = implode(",", $this->tagFilters);
      }
    }


    // Filter by Tag Category. Get the tag category, then search through the region or itinerary page this block is placed on, and get any tag names that match the same category. Use the tag names to filter.
    $tag_category = $this->tagCategory;
    $tag_names = [];
    if (!empty($queryData) && !empty($tag_category)) {
      foreach ($queryData->tags as $tag) {
        if ($tag->category === $tag_category) {
          $tag_names[] = $tag->name;
        }
      }
    }
    $tag_names = implode(', ', $tag_names);

    // Build query string based on conditions
    $query_string = http_build_query(array(
      'filter' => $this->filterRecordsByRegion ? array(
        $this->query_key => $filter_id
      ) : null, // this is for region filter
      'tagIds' => !empty($tagIds) ? $tagIds : null, // this is for the Tag Filters
      'tag' => !empty($tag_category) && !empty($tag_names) ? array(
        'category' => $tag_category,
        'name' => $tag_names
      ) : null // this is for Tag Category
    ));
    return $query_string;
  }
}
