<?php

namespace Itinerator\Templates;

use Parsedown;

class Challenge {
	public $id;
	public $slug;
	public $name;
	public $description;
	public $featured;
	public $status;
	public $target_name;
	public $target_id;
	public $target_type;
	public $type;
	public $tags;
	/**
	 * @var EventTime[]
	 */
	public $event_times;
	  /**
   * @var Media
   */
  public $hero;
	/**
	 * @var Media[]
	 */
	public $carousel_images;
	/**
	 * @var Reward[]
	 */
	public $rewards;
	/**
	 * @var Content[]
	 */
	public $contents;
	public $meta_image;

	public function postMapping() {
		$shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/challenge-shortcodes.json');
		$shortcodes = json_decode($shortcodeJson, true);
		array_map(function ($code) {
			$parsed_value = Parsedown::instance()->text($this->$code);
			add_shortcode('itin-' . $code, function () use ($parsed_value) {
				return $parsed_value;
			});
			add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
				return strip_tags($parsed_value);
			});
		}, $shortcodes);
	}
}
