<?php

namespace Itinerator\Templates;

class DmoItinerariesBlock extends BlockTemplate
{
    // Define class properties
    protected $template_slug = 'dmo-itineraries';
    protected $block_type = 'dmo-itineraries';
    protected $block_attributes = "dmo-itineraries";
    public $dmo_itineraries;

    protected function get_template_name() {
        return $this->viewType;
    }

    protected function get_data()
    {
        // Get query data and itinerary page type and construct the path
        $queryData = get_query_var('querydata');

        if(isset($_GET['secret_key'])){
            $secret_key = $_GET['parameter'];
        } else {
            $secret_key = DMO_PARTNER_API_KEY;
        }

        // Generate query parameters using the record_list_query method
        $params = $this->record_list_query();

        // Query the Itin API with the constructed path and parameters
        $data = query_itin_api('dmos/itineraries',  false, ['secret_key' => $secret_key]);

        $dmo_itineraries = []; // Initialize $dmos as an empty array
        // Check if the result is an array
        if (is_array($data)) {
            // Map the data array using a callback function and store it in the $dmos property
            $dmo_itineraries = array_map(function ($dmo) {
                return $this->jm->map($dmo, new SimpleDmosItinerary($this));
            }, $data);
        }

        // Set the $dmos property
        $this->dmo_itineraries = $dmo_itineraries;
    }
}
