<?php

namespace Itinerator\Templates;

class Dmos extends BlockTemplate
{
  // Define class properties
  protected $template_slug = 'dmos';
  protected $block_type = 'dmos';
  protected $block_attributes = "dmos";
  public $dmos;
  public $viewType;
  public $columns;

  protected function get_template_name() {
		return $this->viewType;
	}

  protected function get_data()
  {
    // Get query data and itinerary page type and construct the path
    $queryData = get_query_var('querydata');
    $pageType = strtolower(pluralize_type(get_query_var('itinPageType'))); //to lowercase plural
    $path = isset($queryData) && is_object($queryData) && property_exists($queryData, 'id') ? $pageType . '/' . $queryData->id . '/dmos?' : '/dmos?';

    // Generate query parameters using the record_list_query method
    $params = $this->record_list_query();

    // Query the Itin API with the constructed path and parameters
    $result = query_itin_api($path . $params);

    $dmos = []; // Initialize $dmos as an empty array
    // Check if the result is an array
    if (is_array($result)) {
      // Map the result array using a callback function and store it in the $dmos property
      $dmos = array_map(function ($dmo) {
        return $this->jm->map($dmo, new SimpleDmo($this));
      }, $result);
    }

    // Set the $dmos property
    $this->dmos = $dmos;
  }
}
