<?php

namespace Itinerator\Templates;

use Parsedown;

class Event
{
  public $id;
  public $slug;
  public $page_slug;
  public $path;
  public $name;
  public $description;
  public $featured;
  public $cost;
  public $ticket_url;
  public $email;
  public $website;
  public $phone_number;
  public $status;
  public $target_name;
  public $target_id;
  public $target_type;
  public $tags;
  /**
   * @var EventTime[]
   */
  public $event_times;
  /**
   * @var Media
   */
  public $hero;
  public $meta_image;
  public $recurring;
  public $filter_classes;

  public function __construct($attr = null)
  {
    $this->page_slug = $attr->slug ?? '';
  }

  public function get_filter_classes()
  {
    $classes = array("searchable-item");
    // array_push($classes, $this->region_slug);
    $classes = array_merge($classes, array_map(function ($tag) {
      return "tag-id-" . $tag->tag_id;
    }, $this->tags ?? []));
    return implode(" ", array_filter($classes));
  }


  public function postMapping()
  {
    $this->filter_classes = $this->get_filter_classes();
    $this->path = apply_filters('itinerator_event_url', "/" . $this->page_slug . '/' . $this->slug, $this);
    $shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/event-shortcodes.json');
    $shortcodes = json_decode($shortcodeJson, true);
    array_map(function ($code) {
      $parsed_value = Parsedown::instance()->text($this->$code);
      add_shortcode('itin-' . $code, function () use ($parsed_value) {
        return $parsed_value;
      });
      add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
        return strip_tags($parsed_value);
      });
    }, $shortcodes);
  }
}
