<?php

namespace Itinerator\Templates;

class Filter extends BlockTemplate
{
  protected $template_slug = 'filter';
  protected $block_type = 'filter';
  protected $block_attributes = "filter";
  public $filterType;
  public $options;
  public $filterPlaceholder;
  protected function get_template_name()
  {
    return $this->filterType;
  }

  public function get_id()
  {
    if ($this->filterType === "search") return "itinSearch";

    $type = !empty($this->tagCategory) ? $this->tagCategory : $this->filterType;
    return "itinSelect-$type";
  }

  protected function get_data()
  {
    if ($this->filterType == "region") {
      $options = query_itin_api('regions/list');
      if (is_array($options)) {
        array_walk($options, function ($tag) {
          if (is_object($tag)) {
            $tag->value = $tag->slug;
            unset($tag->slug);
          }
        });
        $this->options = $options;
      } else {
        $this->options = [];
      }
    } else if ($this->filterType == "tag-category" && $this->tagCategory) {
      $options = query_itin_api("tags/list/" . $this->tagCategory);
      if (is_array($options)) {
        array_walk($options, function ($tag) {
          if (is_object($tag)) {
            $tag->value = $tag->id;
            unset($tag->id);
          }
        });
        $this->options = $options;
      } else {
        $this->options = [];
      }
    }
    return;
  }
}


// FOR DEPLOY
// ADD DESCRIPTION BLOCK TO GARDEN
// ADD FILTER BLOCKS GARDENS
