<?php

namespace Itinerator\Templates;

use Parsedown;

class Form
{
  public $id;
  public $name;
  public $description;
  public $form_fields;
  public $selected_form;

  /**
   * This function maps the form properties to WordPress shortcodes.
   * It reads a JSON file containing the list of form shortcodes,
   * then creates two shortcodes for each property:
   * 1. 'itin-{property_name}' which returns the parsed Markdown content
   * 2. 'itin-stripped-{property_name}' which returns the property value with HTML tags stripped
   */
  public function postMapping()
  {
    // Read the JSON file containing the list of form shortcodes
    $shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/form-shortcodes.json');
    $shortcodes = json_decode($shortcodeJson, true);

    // Loop through each shortcode and create the corresponding WordPress shortcodes
    array_map(function ($code) {
      // Parse the Markdown content of the property
      $parsed_value = Parsedown::instance()->text($this->$code);

      // Create the 'itin-{property_name}' shortcode
      add_shortcode('itin-' . $code, function () use ($parsed_value) {
        return $parsed_value;
      });

      // Create the 'itin-stripped-{property_name}' shortcode
      add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
        return strip_tags($parsed_value);
      });
    }, $shortcodes);
  }
  public function set_target_paths($form_block)
  {
  // print_r($form_block);
    if (isset($form_block->selectedForm)) {
      $this->selected_form = $form_block->selectedForm;
    }
  }
}
