<?php

namespace Itinerator\Templates;

class FormBlock extends BlockTemplate
{
  protected $template_slug = 'form-block';
  protected $block_type = 'form-block';
  protected $block_attributes = 'form-block';
  public $form;
  public $selected_form;
  public $selectedForm;

  protected function get_data()
  {
    global $post;
    $selectedForm = $this->attributes['selectedForm'];

    if (!empty($selectedForm)) {
      // Query the form API for the specific form
      $apiResponse = query_itin_api('forms/' . $selectedForm);

      // Create a new Form object and populate its properties
      $this->form = new Form();
      $this->form->id = isset($apiResponse->id) ? $apiResponse->id : null;
      $this->form->name = isset($apiResponse->name) ? $apiResponse->name : null;
      $this->form->description = isset($apiResponse->description) ? $apiResponse->description : null;
      $this->form->form_fields = isset($apiResponse->form_fields) ? $apiResponse->form_fields : null;
    } else {
      // Check if the querydata is an instance of form, otherwise set it to null
      $this->form = is_a(get_query_var('querydata'), "Itinerator\Templates\FormBlock") ? get_query_var('querydata') : null;
    }

    // Set the target paths for the form
    if ($this->form !== null) {
      $this->form->set_target_paths($this);
    }
  }


  public function handle_form_submission($form)
  {
    // Gather the form data
    $formEntryFields = [];
    if (property_exists($form, 'form_fields') && is_array($form->form_fields)) {
      foreach ($form->form_fields as $field) {
        if (isset($_POST[$field->id]) || isset($_FILES[$field->id])) {
          if ($field->type === 'DateField' || $field->type === 'DateTimeField') {
            // Handle DateField and DateTimeField
            $formEntryFields[$field->id] = $_POST[$field->id];
          }

          if ($field->type === 'ImageField') {
            // Handle image field
            if (isset($_FILES[$field->id]) && is_array($_FILES[$field->id]['name'])) {
              $imageData = [];
              foreach ($_FILES[$field->id]['name'] as $index => $fileName) {
                if ($_FILES[$field->id]['error'][$index] === UPLOAD_ERR_OK) {
                  $base64 = base64_encode(file_get_contents($_FILES[$field->id]['tmp_name'][$index]));
                  $imageData[] = [
                    'base64' => $base64,
                    'type' => 'image',
                    'uri' => $fileName
                  ];
                } else {
                  error_log('Error: $_FILES[' . $field->id . '][' . $index . '] has an error');
                }
              }
              $formEntryFields[$field->id] = $imageData;
            } else {
              error_log('Error: $_FILES[' . $field->id . '] is not available or has an error');
            }
          } else {
            $formEntryFields[$field->id] = $_POST[$field->id];
          }
        } else {
          error_log('Error: $_POST[' . $field->id . '] or $_FILES[' . $field->id . '] is not available');
        }
      }
    } else {
      error_log('Error: $form->form_fields is not available');
    }

    $formData = [
      'form_id' => $form->id,
      'form_entry_fields' => $formEntryFields,
      'form_entry' => [
        'form_id' => $form->id
      ]
    ];

    // Send the form data to the API
    $apiResponse = wp_remote_post(API_URL . 'form_entries', [
      'headers' => [
        'Authorization' => 'Bearer ' . API_TOKEN,
        'Content-Type' => 'application/json'
      ],
      'body' => json_encode($formData),
      'timeout' => 30
    ]);

    // Handle the API response
    if (!is_wp_error($apiResponse)) {
      $httpCode = wp_remote_retrieve_response_code($apiResponse);
      if ($httpCode >= 200 && $httpCode < 300) {
        // Redirect or display a success message
        return true;
      } else {
        // Display an error message
        return wp_remote_retrieve_response_message($apiResponse);
      }
    } else {
      // Display an error message
      return $apiResponse->get_error_message();
    }
  }
}
