<?php

namespace Itinerator\Templates;

class Itineraries extends BlockTemplate
{
  // Set the template slug, block type, and block attributes
  protected $template_slug = 'itineraries';
  protected $block_type = "itineraries";
  protected $block_attributes = 'itineraries';
  public $query_key = 'region_id';
  public $itineraries;
  public $matchRecordsByTagCategory;
  public $buttonText;

  // Retrieve the data for the itineraries block
  protected function get_data()
  {
    // Get the querydata from the query variable
    $queryData = get_query_var('querydata');

    // Get the id from the querydata if it is an instance of Itinerary, otherwise set it to null
    $id = is_a($queryData, "Itinerator\Templates\Itinerary") ? $queryData->id : null;

    // Build the query parameters for the API request
    $params = $this->record_list_query();

    // Convert the $params to an array
    $params_array = array();
    parse_str($params, $params_array);

    // Query the itineraries API and map the response to SimpleItinerary objects
    $itineraries = array_map(function ($itinerary) {
      return $this->jm->map($itinerary, new SimpleItinerary($this));
    }, query_itin_api('itineraries?' . $params));

    // Filter out the itinerary with the same id as the current querydata
    $itineraries = array_filter($itineraries, function ($itinerary) use ($id) {
      return $itinerary->id != $id;
    });

    // Set the itineraries property to the filtered itineraries
    $this->itineraries = $itineraries;
  }
}
