<?php

namespace Itinerator\Templates;

use Parsedown;

class Itinerary
{
  public $id;
  public $title;
  public $name;
  public $subtitle;
  public $short_description;
  public $description;
  public $main_content;
  public $listing_page_slug;
  public $region_slug;
  public $region_id;
  public $specific_itinerary;
  	/**
	 * @var Tag[]
	 */
  public $tags;
  /**
   * @var Media
   */
  public $hero;
  /**
   * @var Media[]
   */
  public $carousel_images;
  /**
   * @var Media[]
   */
  public $images;
  /**
   * @var Content[]
   */
  public $contents;
  /**
   * @var Leg[]
   */
  public $legs;
  public $meta_image;

  public function set_target_paths($itinerary_block)
  {
    if (isset($itinerary_block->linkedPageId)) {
      $this->listing_page_slug = get_post($itinerary_block->linkedPageId)->post_name;
    }
    if (isset($itinerary_block->linkedRegionPageId)) {
      $this->region_slug = get_post($itinerary_block->linkedRegionPageId)->post_name;
    }
    if (isset($itinerary_block->specificItinerary)) {
      $this->specific_itinerary = $itinerary_block->specificItinerary;
    }
    if (isset($this->legs)) {
      foreach ($this->legs as $leg) {
        $leg->set_target_paths($this);
      }
    }
  }
  public function postMapping()
  {
    $shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/itinerary-shortcodes.json');
    $shortcodes = json_decode($shortcodeJson, true);
    array_map(function ($code) {
      $parsed_value = Parsedown::instance()->text($this->$code);
      add_shortcode('itin-' . $code, function () use ($parsed_value) {
        return $parsed_value;
      });
      add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
        return strip_tags($parsed_value);
      });
    }, $shortcodes);
  }
}
