<?php

namespace Itinerator\Templates;

class ItineraryBlock extends BlockTemplate
{
  protected $template_slug = 'itinerary';
  protected $block_type = 'itinerary';
  protected $block_attributes = 'itinerary';
  public $itinerary;
  public $region_slug;

  /**
   * Retrieve the data for the itinerary block
   */
  protected function get_data()
  {
    global $post;
    $specificItinerary = $this->attributes['specificItinerary'];

    if (!empty($specificItinerary)) {
      // Query the itinerary API for the specific itinerary
      $apiResponse = query_itin_api('itineraries/' . $specificItinerary);

      // Map the stdClass object to an Itinerary object
      $itinerary = $this->jm->map($apiResponse, new Itinerary());
    } else {
      // Check if the querydata is an instance of Itinerary, otherwise set it to null
      $itinerary = is_a(get_query_var('querydata'), "Itinerator\Templates\Itinerary") ? get_query_var('querydata') : null;
    }

    $this->attributes['itineraryRegionId'] = $itinerary->region_id ? $itinerary->region_id : '';

    // Map the itinerary object to the class property
    $this->itinerary = $this->jm->map($itinerary, new Itinerary());

    // Set the target paths for the itinerary
    $this->itinerary->set_target_paths($this);
  }
}
