<?php

namespace Itinerator\Templates;

use Parsedown;

class Listing {
	public $id;
	public $description;
	public $short_description;
	public $name;
	public $slug;
	public $region_id;
	public $region_slug;
	public $full_address;
	public $street_address;
	public $city;
	public $province;
	public $postal_code;
	public $country;
	public $email;
	public $phone_number;
	public $website;
	public $booking_website;
	public $subtitle;
	public $stakeholder;
	public $lat;
	public $lng;
	public $type;
	public $google_maps_url;
  /**
   * @var OperatingHour[]
   */
  public $operating_hours;
  /**
   * @var Media
   */
  public $hero;
  /**
   * @var Media[]
   */
  public $carousel_images;
  /**
   * @var Media[]
   */
  public $images;
	/**
	 * @var Social[]
	 */
	public $socials;
	/**
	 * @var Tag[]
	 */
	public $tags;
	/**
	 * @var Content[]
	 */
	public $contents;
	public $meta_image;

	public function postMapping() {

		$shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/listing-shortcodes.json');
		$shortcodes = json_decode($shortcodeJson, true);
		array_map(function ($code) {
			$parsed_value = Parsedown::instance()->text($this->$code);
			add_shortcode('itin-' . $code, function () use ($parsed_value) {
				return strip_tags($parsed_value);
			});
			add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
				return strip_tags($parsed_value);
			});
		}, $shortcodes);
	}
}
