<?php

namespace Itinerator\Templates;

class Listings extends BlockTemplate
{
  protected $template_slug = 'listings';
  protected $block_type = "listings";
  protected $block_attributes = 'listings';
  public $query_key = "region_id";
  public $region_id, $listings, $viewType, $listings_alpha;

  protected function get_template_name()
  {
    return $this->viewType;
  }

  private function group_listings()
  {
    $grouped_listings = array();
    foreach ($this->listings as $listing) {
      $grouped_listings[$listing->firstCharacter][] = $listing;
    }
    return $grouped_listings;
  }

  protected function get_data()
  {
    // Retrieve querydata variable and extract the id
    $queryData = get_query_var('querydata');

    $id_to_remove = null;
    $page_type = null;
    if (is_a($queryData, "Itinerator\Templates\Listing")) {
      $id_to_remove = isset($queryData->id) ? $queryData->id : null;
      $page_type = 'listing';
    } elseif (is_a($queryData, "Itinerator\Templates\Region")) {
      $id_to_remove = isset($queryData->id) ? $queryData->id : null;
      $page_type = 'region';
    } elseif (is_a($queryData, "Itinerator\Templates\Itinerary")) {
      $id_to_remove = isset($queryData->id) ? $queryData->id : null;
      $page_type = 'itinerary';
    }

    // Query the API
    $params = $this->record_list_query();
    $api_results = query_itin_api('listings?' . $params);

    // Filter out the listing with the id from querydata
    $filtered_results = array_filter($api_results, function ($listing) use ($id_to_remove, $page_type) {
      if ($page_type === 'listing') {
        return $listing->id !== $id_to_remove;
      } else {
        return true;
      }
    });

    // Map the filtered results to SimpleListing
    $this->listings = array_map(function ($listing) {
      return $this->jm->map($listing, new SimpleListing($this));
    }, $filtered_results);

    // Group listings if viewType is "alpha"
    if ($this->viewType == "alpha") {
      $this->listings_alpha = $this->group_listings();
    }
  }
}
