<?php

namespace Itinerator\Templates;

class Media {
	public $caption;
	public $url;
	public $content_type;
	public $width;
	public $height;

	public function isVideo() {
		return str_starts_with($this->content_type, 'video');
	}

	public function isImage() {
		return str_starts_with($this->content_type, 'image');
	}

	public function getSizeParams($size = null) {
		$params = is_array($size) ? $size : array('size' => $size);
		return '?' . http_build_query($params);
	}

	public function getUrl($size = null) {
		$params = $this->getSizeParams($size);
		return $this->url . $params;
	}

	public function getMedia($size = null, $class = null, $props = null) {
		$url = $this->getUrl($size);
		// if (!$this->URLExists($url)) return null;
		$dimensions = $this->getDimensions($size);
		if ($this->isVideo()) {
			return "<video width='$dimensions->width' height='$dimensions->height' class='$class' $props><source src='$url'/></video>";
		}
		return "<img width='$dimensions->width' height='$dimensions->height' src='$url' alt='$this->caption' class='$class' $props >";
	}

	public function getImg($size = null, $class = null, $props = null) {
		if ($this->isVideo()) {
			if (!$size) $size = 'xlarge';
			$size = $size . '_image';
		}
		$url = $this->getUrl($size);
		// if (!$this->URLExists($url)) return null;
		$dimensions = $this->getDimensions($size);
		return "<img width='$dimensions->width' height='$dimensions->height' src='$url' alt='$this->caption' class='$class' $props >";
	}

	public function getDimensions($size = null) {
		$url = $this->getUrl($size);
		$url = str_replace('?', '/dimensions?', $url);
		$response = wp_remote_get($url);
		return json_decode($response['body']);
	}

	public function URLExists($url) {
		$headers = get_headers($url);
		return strpos($headers[0], "302 Found") !== false;
	}
}

//size will come from this.image.sizes
