<?php

namespace Itinerator\Templates;

use Parsedown;

class Region {
	public $id;
	public $slug;
	public $name;
	public $description;
	public $subtitle;
	public $short_description;
	public $parent_slug;
	  /**
   * @var Media
   */
  public $hero;
	/**
	 * @var Media[]
	 */
	public $carousel_images;
	/**
	 * @var Media[]
	 */
	public $images;
	/**
	 * @var Content[]
	 */
	public $contents;

	public $meta_image;

	public $challenge_count;

  	/**
	 * @var Tag[]
	 */
	public $tags;

	public function postMapping() {
		$shortcodeJson = file_get_contents(ITINERATOR_PLUGIN_DIR . '/src/attributes/region-shortcodes.json');
		$shortcodes = json_decode($shortcodeJson, true);
		array_map(function ($code) {
			$parsed_value = Parsedown::instance()->text($this->$code);
			add_shortcode('itin-' . $code, function () use ($parsed_value) {
				return $parsed_value;
			});
			add_shortcode('itin-stripped-' . $code, function () use ($parsed_value) {
				return strip_tags($parsed_value);
			});
		}, $shortcodes);
	}
}
