<?php

namespace Itinerator\Templates;

class Regions extends BlockTemplate
{
  protected $template_slug = 'regions';
  protected $block_type = 'regions';
  protected $block_attributes = "regions";
  public $query_key = "parent_region_id";
  public $regions;
  public $buttonText;
  public $matchRecordsByTagCategory;
  public $onlyShowSubregions;
  public $showSubtitle;

  protected function get_data()
  {
    if ($this->itinPageType == 'region' && !$this->attributes['onlyShowSubregions']) {
      $this->query_key = 'region_id';
    }
    $queryData = get_query_var('querydata');
    $id = is_a($queryData, "Itinerator\Templates\Region") ? $queryData->id : null;
    $params = $this->record_list_query();
    $regions = array_map(function ($region) {
      return $this->jm->map($region, new SimpleRegion($this));
    }, query_itin_api('regions?' . $params));
    $regions = array_filter($regions, function ($itinerary) use ($id) {
      return $itinerary->id != $id;
    });
    $this->regions = $regions;
  }
}
