<?php

namespace Itinerator\Templates;

class RelatedPosts extends BlockTemplate {
	protected $template_slug = 'related-posts';
	protected $block_type = 'related-posts';
	protected $block_attributes = 'related-posts';
	public $displayCount;
	public $related_posts;
	protected function get_data() {
		$type = $this->itinPageType;
		$this->record = get_query_var('querydata');
		$count = isset($this->attributes['displayCount']) ? $this->attributes['displayCount'] : -1;
		$this->related_posts = get_posts(
			array(
				'post_type' => 'post',
				'post_status' => array('publish'),
				'numberposts' => $count,
				'orderby' => 'date',
				'tax_query' => array(
					array(
						"taxonomy" => "itin-" . pluralize_type($type),
						"field" => "slug",
						"terms" => $this->record->id,
					)
				)
			)
		);
		return;
	}
}
