<?php

namespace Itinerator\Templates;

class SimpleDmo {
	// Properties to store information about the DMO
	public $page_slug;      // The page that the DMO is on
	public $path;           // The path of the DMO
	public $filter_classes; // CSS classes for filtering

	// Constructor that initializes the DMO with attributes
	public function __construct($attr) {
		$this->page_slug = $attr->slug ?? ''; // Set the page slug from provided attributes
	}

	// Method to generate CSS classes for the DMO based on its properties
	public function get_filter_classes() {
		$classes = array("searchable-item"); // Initialize classes array
		array_push($classes, $this->slug); // Add parent and DMO slug
		return implode(" ", array_filter($classes)); // Combine and filter classes
	}

	// Properties to store DMO information
	public $id;           // DMO ID
	public $website;      // DMO website URL
	public $name;         // DMO name
	public $description;  // DMO description
  public $slug;
  // public $blockPropTest;

	/**
	 * @var Tag[]
	 */
  public $tags;

  /**
   * @var Media
   */
	public $logo;   // Media object for DMO logo

	// Method to perform post-mapping actions
	public function postMapping() {
		// Construct the DMO path based on page and DMO slug
		$this->path = apply_filters('itinerator_dmo_url', "/" .
    $this->page_slug . '/' . $this->slug, $this);
		// Generate CSS filter classes for the DMO
		$this->filter_classes = $this->get_filter_classes();
	}
}
