<?php

namespace Itinerator\Templates;

class SimpleDmosItinerary {
	// Properties to store information about the DMO
	public $page_slug;      // The page that the DMO is on
	public $path;           // The path of the DMO
	public $filter_classes; // CSS classes for filtering

	// Constructor that initializes the DMO with attributes
	public function __construct($attr) {
		$this->page_slug = $attr->slug ?? ''; // Set the page slug from provided attributes
	}

	// Method to generate CSS classes for the DMO based on its properties
	public function get_filter_classes() {
		$classes = array("searchable-item"); // Initialize classes array
		array_push($classes, $this->slug); // Add parent and DMO slug
		return implode(" ", array_filter($classes)); // Combine and filter classes
	}

	// Properties to store DMO information
	public $id;
	public $name;
	public $description;
	public $subtitle;
	public $short_description;
  public $slug;
  public $region_name;
  public $status;
  public $stop_count;
  public $leg_count;
  public $main_content;
  public $view_type;
  public $columns;
  public $platform_logo_border_radius;
  public $overlay_border_radius;
  public $grid_item_border_radius;
  public $grid_gap;
    /**
   * @var Media
   */
  public $hero;   // Media object for DMO hero
  public $tags;
    /**
   * @var Media
   */
  public $platform_logo;   // Media object for DMO logo
  public $platform_name;
  public $platform_url;
  public $primary_url;


	/**
   * @var Tag[]
	 */


  // Method to perform post-mapping actions
	public function postMapping() {
		// Construct the DMO path based on page and DMO slug
		$this->path = apply_filters('itinerator_dmo_url', "/" .
    $this->page_slug . '/' . $this->slug, $this);
		// Generate CSS filter classes for the DMO
		$this->filter_classes = $this->get_filter_classes();
	}
}
