<?php

namespace Itinerator\Templates;

/**
 * The SimpleItinerary class represents a simplified version of an itinerary.
 * It contains properties that store information about the itinerary.
 */
class SimpleItinerary
{
  public $filter_classes;
  public $page_slug;
  public $path;
  public $id;
  public $name;
  public $subtitle;
  public $description;
  public $short_description;
  public $slug;
  public $region_name;
  public $region_slug;
  public $stop_count;
  public $leg_count;
  /**
   * @var Tag[]
   */
  public $tags;
  /**
   * @var Media
   */
  public $hero;


  /**
   * The constructor method initializes the SimpleItinerary object.
   * It sets the page_slug property based on the provided attribute.
   *
   * @param object $attr - The attribute object containing the slug.
   */
  public function __construct($attr)
  {
    $this->page_slug = $attr->slug;
    $this->region_name = $attr->region_name ?? '';
  }

  /**
   * The postMapping method sets the path property based on the page_slug and slug properties.
   * It applies the 'itinerator_itinerary_url' filter to allow customization of the URL path.
   */
  public function postMapping()
  {
    $this->path = apply_filters('itinerator_itinerary_url', "/" . $this->page_slug . '/' . $this->slug, $this);
    $this->filter_classes = $this->get_filter_classes();
  }

  public function get_filter_classes()
  {
    $classes = array("searchable-item");
    array_push($classes, sanitize_title($this->region_name));
    $classes = array_merge($classes, array_map(function ($tag) {
      return "tag-id-" . $tag->tag_id;
    }, $this->tags ?? []));
    return implode(" ", array_filter($classes));
  }
}
