<?php

namespace Itinerator\Templates;

class SimpleListing {
	public $page_slug;
	public $path;
	public $firstCharacter;
	public $filter_classes;

	public function __construct($attr) {
		$this->page_slug = $attr->slug;
	}

	public function get_filter_classes() {
		$classes = array("searchable-item");
		array_push($classes, $this->region_slug);
		$classes = array_merge($classes, array_map(function ($tag) {
			return "tag-id-" . $tag->tag_id;
		}, $this->tags ?? []));
		return implode(" ", array_filter($classes));
	}

	public $id;
	public $name;
	public $description;
	public $short_description;
	public $slug;
	public $region_slug;
	public $region_id;
	public $city;
	public $website;
	public $website2;
	public $stakeholder;
	public $email;
	public $phone_number;
	public $full_address;
	public $lat;
	public $lng;
	public $type;
	/**
	 * @var Tag[]
	 */
	public $tags;
	  /**
   * @var Media
   */
  public $hero;
	public function postMapping() {
		$this->path = apply_filters('itinerator_listing_url', "/" . $this->page_slug . '/' . $this->slug, $this);
		$this->firstCharacter = substr(trim($this->name), 0, 1);
		$this->filter_classes = $this->get_filter_classes();
	}
}
