<?php

namespace Itinerator\Templates;

class SimpleRegion {
	public $page_slug;
	public $path;
	public $filter_classes;

	public function __construct($attr) {
		$this->page_slug = $attr->slug ?? '';
	}

	public function get_filter_classes() {
		$classes = array("searchable-item");
		array_push($classes, $this->parent_slug, $this->slug);
		$classes = array_merge($classes, array_map(function ($tag) {
			return "tag-id-" . $tag->tag_id;
		}, $this->tags ?? []));
		return implode(" ", array_filter($classes));
	}

	public $id;
	public $name;
	public $description;
	public $subtitle;
	public $short_description;
	public $slug;
	public $parent_slug;
	public $lat;
	public $lng;

	/**
	 * @var Tag[]
	 */
	public $tags;
	public $challenge_count;
	  /**
   * @var Media
   */
  public $hero;
	public function postMapping() {
		$this->path = apply_filters('itinerator_region_url', "/" . $this->page_slug . '/' . $this->slug, $this);
		$this->filter_classes = $this->get_filter_classes();
	}
}
