<?php

namespace Itinerator\Templates;

class Tags extends BlockTemplate
{
    protected $template_slug = 'tags';
    protected $block_type = 'tags';
    protected $block_attributes = 'tags';
    public $tags;


    protected function get_template_name()
    {
        return $this->tagCategory;
    }

    protected function get_data()
    {
        $data = get_query_var('querydata');

        if (!empty($data) && !empty($data->tags)) {
            $this->tags = array_filter($data->tags, function ($tag) {
                return $tag->category === $this->tagCategory;
            });
        } else {
            $this->tags = [];
        }
    }
}
