<?php

add_action('admin_bar_menu', 'add_clear_cache_button', 100);
add_action('admin_enqueue_scripts', 'enqueue_clear_cache_scripts');
add_action('wp_enqueue_scripts', 'enqueue_clear_cache_scripts');

function add_clear_cache_button($wp_admin_bar) {
    if (current_user_can('manage_options')) {
        $args = array(
            'id'    => 'clear_itin_cache',
            'title' => 'Clear Itinerator Cache',
            'href'  => '#',
            'meta'  => array(
                'class' => 'clear-itin-cache',
                'onclick' => 'clearItinCache(); return false;',
            ),
        );
        $wp_admin_bar->add_node($args);
    }
}

function enqueue_clear_cache_scripts() {
    wp_enqueue_script('itinerator-js');
    wp_localize_script('itinerator-js', 'ajax_object', array(
        'ajax_url' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('clear_itin_cache_nonce')
    ));
}

add_action('wp_ajax_clear_itin_cache', 'clear_itin_cache');

function clear_itin_cache() {
    // Verify nonce for security
    if (!check_ajax_referer('clear_itin_cache_nonce', false, false)) {
        wp_send_json_error(array('message' => 'Invalid security token.'));
        return;
    }

    // Verify user capabilities
    if (!current_user_can('manage_options')) {
        wp_send_json_error(array('message' => 'You do not have permission to perform this action.'));
        return;
    }

    global $wpdb;

    // Delete all transients related to the itinerary API
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_itin_api_%'");
    $wpdb->query("DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_timeout_itin_api_%'");

    wp_send_json_success(array('message' => 'Itinerator cache cleared successfully.'));
}
