<?php
if (!defined('ABSPATH')) {
  exit;
}

function block_editor_assets()
{
  // Register block editor styles for backend.
  wp_register_style(
    'itinerator-cgb-block-editor-css', // Handle.
    ITINERATOR_PLUGIN_URL . 'dist/blocks.editor.build.css', // Block editor CSS.
    array('wp-edit-blocks'),
    null // filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.editor.build.css' ) // Version: File modification time.
  );


  // Register block editor script for backend.
  wp_register_script(
    'itinerator-cgb-block-js', // Handle.
    ITINERATOR_PLUGIN_URL . 'dist/blocks.build.js',
    array(
      "wp-components",
      "wp-api-fetch",
      "wp-element",
      "wp-plugins",
      "wp-block-editor",
      "wp-blocks",
      "wp-hooks",
      "wp-date",
      "wp-data",
      "wp-i18n",
      "wp-notices",        // To show admin notices
      "wp-url",           // To add URL utilities
      'jquery'
    ),
    "1.9.22" //version
  );
  wp_enqueue_script('itinerator-cgb-block-js');
  // WP Localized globals. Use dynamic PHP stuff in JavaScript via `itineratorGlobal` object.
  wp_localize_script(
    'itinerator-cgb-block-js',
    'itineratorGlobal', // Array containing dynamic data for a JS Global.
    [
      'pluginDirPath' => ITINERATOR_PLUGIN_DIR,
      'pluginDirUrl'  => ITINERATOR_PLUGIN_URL,
      'googleMapsApiKey' => ITIN_GOOGLE_MAPS_API_KEY,
      'googleMapsMapId' => ITIN_GOOGLE_MAPS_MAP_ID,
      'dmoPartnerApiKey' => DMO_PARTNER_API_KEY,
      'itinBootstrap' => ITIN_BOOTSTRAP,
      'isPlatformAPIKeyValid' => ITIN_IS_PLATFORM_API_KEY_VALID,
      'isDMOAPIKeyValid' => ITIN_IS_DMO_API_KEY_VALID
      // Add more data here that you want to access from `itineratorGlobal` object.
    ]
  );


  // Define an array of possible script handles to see if any variant has loaded
  $google_script_handles = array(
    'google_maps_api',
    'google_maps',
    'maps_script',
    'maps_script'
  );

  // Check if any of the Google Maps API script handles have been enqueued
  $google_maps_enqueued = false;
  foreach ($google_script_handles as $handle) {
    if (wp_script_is($handle, 'enqueued')) {
      $google_maps_enqueued = true;
      break;
    }
  }

  // Check if Maps API script has been embedded in the page
  $google_maps_embedded = false;
  if (stripos(get_the_content(), 'maps.googleapis.com/api') !== false) {
    $google_maps_embedded = true;
  }

  // Enqueue the Google Maps API script if it hasn't been enqueued or embedded yet
  if (!$google_maps_enqueued && !$google_maps_embedded) {
    wp_enqueue_script('google_maps_api');
  }
}

add_action('enqueue_block_editor_assets', 'block_editor_assets');

function itin_add_bootstrap_to_editor()
{
  add_editor_style('../../plugins/dist/vendors.build.css');
}
add_action('admin_init', 'itin_add_bootstrap_to_editor');
