<?php

function check_if_dmo_api_key_is_valid($old_value, $new_value, $option_name)
{
    // If the api key field is empty
    if (empty($new_value)) {
        update_option('itinerator_is_dmo_api_key_valid', '');
    } else {
        // Ensure the API key is URL-safe
        $url_safe_api_key = rawurlencode($new_value);

        $url = add_query_arg(['secret_key' => $url_safe_api_key], API_URL . '/dmos/itineraries');

        $response = wp_remote_get($url, [
            'headers'     => [
                'Authorization' => 'Bearer ' . API_TOKEN,
            ],
            'timeout' => 30,
        ]);

        $http_code = wp_remote_retrieve_response_code($response);

        if ($http_code == '200') {
            update_option('itinerator_is_dmo_api_key_valid', 'true');
        } else {
            update_option('itinerator_is_dmo_api_key_valid', '');
        }
    }
}

add_action('update_option_itinerator_dmo_partner_key_field', 'check_if_dmo_api_key_is_valid', 10, 3);

function check_dmo_api_key_on_settings_page_load()
{
  global $plugin_page;

  if ($plugin_page === 'itinerator-plugin') {
    $dmo_api_key = get_option('itinerator_dmo_partner_key_field');
    check_if_dmo_api_key_is_valid($dmo_api_key, $dmo_api_key, 'itinerator_dmo_partner_key_field');
  }
}
add_action('admin_menu', 'check_dmo_api_key_on_settings_page_load');
