<?php

function check_if_platform_api_key_is_valid($old_value, $new_value, $option_name)
{
  // If the api key field is empty
  if (empty($new_value)) {
    update_option('itinerator_is_platform_api_key_valid', '');

  } else {

    // Update the 'itinerator_is_api_key_valid' option based on API validation check result.
    $result = query_itin_api('/validate_key', false, [], $new_value);

    if (is_object($result) && property_exists($result, 'valid_key') && $result->valid_key == true) {
      // in future could pass an object to this field with things like last checked, expiry date, etc.
      update_option('itinerator_is_platform_api_key_valid', 'true');

    } else {
      update_option('itinerator_is_platform_api_key_valid', '');
    }

  }
}

add_action('update_option_itinerator_api_key_field', 'check_if_platform_api_key_is_valid', 10, 3);

function check_api_key_on_settings_page_load()
{
  global $plugin_page;
  if ($plugin_page === 'itinerator-plugin') {
    $api_key = get_option('itinerator_api_key_field');
    check_if_platform_api_key_is_valid($api_key, $api_key, 'itinerator_api_key_field');
  }
}
add_action('admin_menu', 'check_api_key_on_settings_page_load');
