<?php
/**
 * Add a custom meta box to the classic editor.
 */
function itinerator_add_classic_editor_meta_box() {
    $current_screen = get_current_screen();
    if ($current_screen->base === 'post' && $current_screen->post_type === 'page' && !$current_screen->is_block_editor) {
        add_meta_box(
            'itin-page-type',
            'Itinerator Page Type',
            'itinerator_render_classic_editor_meta_box',
            'page',
            'side',
            'high'
        );
    }
}
add_action('add_meta_boxes', 'itinerator_add_classic_editor_meta_box');

/**
 * Render the custom meta box content.
 *
 * @param WP_Post $post The current post object.
 */
function itinerator_render_classic_editor_meta_box($post) {
    $page_type = get_post_meta($post->ID, 'itinerator_page_type', true);

    wp_nonce_field('itinerator_save_classic_editor_meta_box', 'itinerator_classic_editor_meta_box_nonce');
    ?>
    <p>
        <label for="itinerator_page_type">Page Type:</label>
        <select id="itinerator_page_type" name="itinerator_page_type" class="form-control">
            <option value="">None</option>
            <option value="region" <?php selected($page_type, 'region'); ?>>Single Region</option>
            <option value="listing" <?php selected($page_type, 'listing'); ?>>Single Listing</option>
            <option value="itinerary" <?php selected($page_type, 'itinerary'); ?>>Single Itinerary</option>
            <option value="event" <?php selected($page_type, 'event'); ?>>Single Event</option>
            <option value="challenge" <?php selected($page_type, 'challenge'); ?>>Single Challenge</option>
        </select>
    </p>
    <?php
}

/**
 * Save the custom meta box data.
 *
 * @param int $post_id The ID of the current post.
 */
function itinerator_save_classic_editor_meta_box($post_id) {
    if (!isset($_POST['itinerator_classic_editor_meta_box_nonce']) || !wp_verify_nonce($_POST['itinerator_classic_editor_meta_box_nonce'], 'itinerator_save_classic_editor_meta_box')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['itinerator_page_type'])) {
        update_post_meta($post_id, 'itinerator_page_type', sanitize_text_field($_POST['itinerator_page_type']));
    }
}
add_action('save_post', 'itinerator_save_classic_editor_meta_box');
